/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver;

public final class ByteBuffer {
    private static final int _$3 = 512;
    public byte[] buffer;
    int _$2;
    int _$1;
    public int pos;
    public int endPos;

    public ByteBuffer(int n) {
        this._$2 = 512;
        if (n > 4096) {
            this._$2 = n + 4095 & 0xFFFFF000;
        } else {
            do {
                this._$2 += this._$2;
            } while (this._$2 < n);
        }
        this.buffer = new byte[n];
        this._$1 = 0;
    }

    public ByteBuffer() {
        this.buffer = new byte[512];
        this._$2 = this.buffer.length;
        this._$1 = 0;
    }

    public int capacity() {
        return this._$2;
    }

    public int hashCode() {
        int n = 17;
        for (int i = this._$1 - 1; i >= 0; --i) {
            n = 65537 * n + this.buffer[i];
        }
        return n;
    }

    public void ensureCapacity(int n) {
        if (n <= this._$2) {
            return;
        }
        if (n > 4096) {
            this._$2 = n + 4095 & 0xFFFFF000;
        } else {
            do {
                this._$2 += this._$2;
            } while (this._$2 < n);
        }
        byte[] byArray = new byte[this._$2];
        System.arraycopy(this.buffer, 0, byArray, 0, this._$1);
        this.buffer = byArray;
    }

    public int length() {
        return this._$1;
    }

    public int size() {
        return this._$1;
    }

    public int getLength() {
        return this._$1;
    }

    public void setLength(int n) {
        if (n < 0) {
            throw new RuntimeException("illegal argument");
        }
        if (n > this._$2) {
            this.ensureCapacity(n);
        }
        this._$1 = n;
    }

    public void clear() {
        this._$2 = this.buffer.length;
        this._$1 = 0;
    }

    public byte[] getBuffer() {
        byte[] byArray = null;
        if (this._$1 == 0) {
            byArray = new byte[]{};
            return byArray;
        }
        byArray = new byte[this._$1];
        System.arraycopy(this.buffer, 0, byArray, 0, this._$1);
        return byArray;
    }

    public void append(int n) {
        if (this._$1 + 1 > this._$2) {
            this.ensureCapacity(this._$1 + 1);
        }
        this.buffer[this._$1++] = (byte)n;
    }

    public void append(long l) {
        if (this._$1 + 1 > this._$2) {
            this.ensureCapacity(this._$1 + 1);
        }
        this.buffer[this._$1++] = (byte)l;
    }

    public void add(int n, byte[] byArray, int n2, int n3) {
        if (this._$1 + n3 > this._$2) {
            this.ensureCapacity(this._$1 + n3);
        }
        System.arraycopy(this.buffer, n, this.buffer, n + n3, this._$1 - n);
        System.arraycopy(byArray, n2, this.buffer, n, n3);
        this._$1 += n3;
    }

    public void add(byte[] byArray, int n, int n2) {
        if (this._$1 + n2 > this._$2) {
            this.ensureCapacity(this._$1 + n2);
        }
        System.arraycopy(byArray, n, this.buffer, this._$1, n2);
        this._$1 += n2;
    }

    public void add(int n, int n2) {
        if (this._$1 + 1 > this._$2) {
            this.ensureCapacity(this._$1 + 1);
        }
        System.arraycopy(this.buffer, n, this.buffer, n + 1, this._$1 - n);
        this.buffer[n] = (byte)n2;
        ++this._$1;
    }

    public void add(int n) {
        if (this._$1 + 1 > this._$2) {
            this.ensureCapacity(this._$1 + 1);
        }
        this.buffer[this._$1++] = (byte)n;
    }

    public void set(int n, byte[] byArray, int n2, int n3) {
        System.arraycopy(byArray, n2, this.buffer, n, n3);
    }

    public void set(int n, int n2) {
        this.buffer[n] = (byte)n2;
    }

    public void insert(int n, byte[] byArray, int n2, int n3) {
        if (this._$1 + n3 > this._$2) {
            this.ensureCapacity(this._$1 + n3);
        }
        System.arraycopy(this.buffer, n, this.buffer, n + n3, this._$1 - n);
        System.arraycopy(byArray, n2, this.buffer, n, n3);
        this._$1 += n3;
    }

    public void replace(int n, byte[] byArray, int n2, int n3) {
        System.arraycopy(byArray, n2, this.buffer, n, n3);
    }

    public void append(byte[] byArray) {
        if (this._$1 + byArray.length >= this._$2) {
            this.ensureCapacity(this._$1 + byArray.length);
        }
        System.arraycopy(byArray, 0, this.buffer, this._$1, byArray.length);
        this._$1 += byArray.length;
    }

    public void append(byte[] byArray, int n, int n2) {
        if (this._$1 + n2 >= this._$2) {
            this.ensureCapacity(this._$1 + n2);
        }
        System.arraycopy(byArray, n, this.buffer, this._$1, n2);
        this._$1 += n2;
    }

    public void replaceShort(int n, int n2) {
        this.buffer[n] = (byte)(n2 >> 8);
        this.buffer[n + 1] = (byte)n2;
    }

    public void appendShort(int n) {
        if (this._$1 + 2 > this._$2) {
            this.ensureCapacity(this._$1 + 2);
        }
        this.replaceShort(this._$1, n);
        this._$1 += 2;
    }

    public void addShort(int n) {
        if (this._$1 + 2 > this._$2) {
            this.ensureCapacity(this._$1 + 2);
        }
        this.buffer[this._$1++] = (byte)(n >> 8);
        this.buffer[this._$1++] = (byte)n;
    }

    public void addShort(int n, int n2) {
        this.add(n, (byte)(n2 >> 8));
        this.add(n + 1, (byte)n2);
    }

    public void setShort(int n, int n2) {
        this.buffer[n] = (byte)(n2 >> 8);
        this.buffer[n + 1] = (byte)n2;
    }

    public void replaceInt(int n, int n2) {
        this.buffer[n] = (byte)(n2 >> 24);
        this.buffer[n + 1] = (byte)(n2 >> 16);
        this.buffer[n + 2] = (byte)(n2 >> 8);
        this.buffer[n + 3] = (byte)n2;
    }

    public void appendInt(int n) {
        if (this._$1 + 4 > this._$2) {
            this.ensureCapacity(this._$1 + 4);
        }
        this.replaceInt(this._$1, n);
        this._$1 += 4;
    }

    public void addInt(int n) {
        if (this._$1 + 4 > this._$2) {
            this.ensureCapacity(this._$1 + 4);
        }
        this.buffer[this._$1++] = (byte)(n >> 24);
        this.buffer[this._$1++] = (byte)(n >> 16);
        this.buffer[this._$1++] = (byte)(n >> 8);
        this.buffer[this._$1++] = (byte)n;
    }

    public void addInt(int n, int n2) {
        this.add(n + 0, (byte)(n2 >> 24));
        this.add(n + 1, (byte)(n2 >> 16));
        this.add(n + 2, (byte)(n2 >> 8));
        this.add(n + 3, (byte)n2);
    }

    public void setInt(int n, int n2) {
        this.buffer[n] = (byte)(n2 >> 24);
        this.buffer[n + 1] = (byte)(n2 >> 16);
        this.buffer[n + 2] = (byte)(n2 >> 8);
        this.buffer[n + 3] = (byte)n2;
    }

    public void addDouble(double d) {
        if (this._$1 + 8 > this._$2) {
            this.ensureCapacity(this._$1 + 8);
        }
        long l = Double.doubleToLongBits(d);
        this.buffer[this._$1++] = (byte)(l >> 56);
        this.buffer[this._$1++] = (byte)(l >> 48);
        this.buffer[this._$1++] = (byte)(l >> 40);
        this.buffer[this._$1++] = (byte)(l >> 32);
        this.buffer[this._$1++] = (byte)(l >> 24);
        this.buffer[this._$1++] = (byte)(l >> 16);
        this.buffer[this._$1++] = (byte)(l >> 8);
        this.buffer[this._$1++] = (byte)l;
    }

    public void addString(String string) {
        int n = string.length();
        if (n + this._$1 > this._$2) {
            this.ensureCapacity(this._$1 + n);
        }
        for (int i = 0; i < n; ++i) {
            this.buffer[this._$1++] = (byte)string.charAt(i);
        }
    }

    public void add(char[] cArray, int n, int n2) {
        if (n2 + this._$1 > this._$2) {
            this.ensureCapacity(this._$1 + n2);
        }
        for (int i = 0; i < n2; ++i) {
            this.buffer[this._$1++] = (byte)cArray[n + i];
        }
    }

    public void remove(int n, int n2) {
        System.arraycopy(this.buffer, n + n2, this.buffer, n, this._$2 - n2 - n);
        this._$1 -= n2;
    }

    public void append(String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.append(string.charAt(i));
        }
    }

    public byte byteAt(int n) {
        if (n < 0 || n > this._$1) {
            throw new RuntimeException();
        }
        return this.buffer[n];
    }

    public void setByteAt(int n, int n2) {
        this.buffer[n] = (byte)n2;
    }

    public byte get(int n) {
        if (n < 0 || n >= this._$1) {
            throw new RuntimeException("out of bounds: " + n + " len: " + this._$1);
        }
        return this.buffer[n];
    }

    public short getShort(int n) {
        if (n < 0 || n + 1 >= this._$1) {
            throw new RuntimeException("out of bounds: " + n + " len: " + this._$1);
        }
        return (short)(((this.buffer[n] & 0xFF) << 8) + (this.buffer[n + 1] & 0xFF));
    }

    public int getInt(int n) {
        if (n < 0 || n + 3 >= this._$1) {
            throw new RuntimeException("out of bounds: " + n + " len: " + this._$1);
        }
        return ((this.buffer[n + 0] & 0xFF) << 24) + ((this.buffer[n + 1] & 0xFF) << 16) + ((this.buffer[n + 2] & 0xFF) << 8) + (this.buffer[n + 3] & 0xFF);
    }

    public Object clone() {
        ByteBuffer byteBuffer = new ByteBuffer(this._$1);
        System.arraycopy(this.buffer, 0, byteBuffer.buffer, 0, this._$1);
        return byteBuffer;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ByteBuffer)) {
            return false;
        }
        ByteBuffer byteBuffer = (ByteBuffer)object;
        if (byteBuffer._$1 != this._$1) {
            return false;
        }
        for (int i = this._$1 - 1; i >= 0; --i) {
            if (byteBuffer.buffer[i] == this.buffer[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return new String(this.buffer, 0, this._$1);
    }

    public String toString(String string) {
        try {
            return new String(this.buffer, 0, this._$1, string);
        }
        catch (Exception exception) {
            return new String(this.buffer, 0, this._$1);
        }
    }
}

