/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.web;

import cn.sendsms.InboundMessage;
import cn.sendsms.TmpMsg;
import cn.sendsms.crypto.PwdConf;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.interfaces.ConnectionPool;
import cn.sendsms.jdsmsserver.web.AlertInfo;
import cn.sendsms.jdsmsserver.web.Condition;
import cn.sendsms.jdsmsserver.web.Page;
import cn.sendsms.jdsmsserver.web.User;
import cn.sendsms.otherModem.common.Const;
import cn.sendsms.otherModem.common.Utils;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.configuration.PropertiesConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DbHelper {
    protected PropertiesConfiguration props;
    protected String dbid;
    private static final Object _$1 = new Object();

    public static DbHelper getDbHelper(PropertiesConfiguration propertiesConfiguration, String string) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String string2 = DbHelper.class.getName();
        String string3 = string2 + "For" + propertiesConfiguration.getString(string + ".type").toUpperCase();
        if (propertiesConfiguration.getString(string + ".type").equals("oracle-rac")) {
            string3 = string2 + "For" + "ORACLE";
        }
        JDSMSServer.getInstance().userConsolePrint("m", "db classType:" + string3);
        Class<?> clazz = Class.forName(string3);
        Constructor<?> constructor = clazz.getConstructor(PropertiesConfiguration.class, String.class);
        DbHelper dbHelper = (DbHelper)constructor.newInstance(propertiesConfiguration, string);
        return dbHelper;
    }

    public String getProperty(String string) {
        return this.props.getString(this.dbid + "." + string, "");
    }

    public String getDbUserName() {
        return this.getProperty("username");
    }

    public String getDbPassword() {
        String string;
        String string2 = this.getProperty("enc");
        String string3 = string = this.getProperty("password");
        if (string2 != null && string2.equals("1")) {
            string3 = PwdConf.decPwd(string);
        }
        return string3;
    }

    public abstract String getHttpReceiveApiSQL(String var1, int var2);

    public abstract String getHttpReceiveApiSQL(String var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertMessage(boolean bl, String string, String string2, String string3, String string4, String string5) throws Exception {
        String string6 = "insert into %s (type,recipient,text,wap_url,wap_expiry_date,wap_signal,create_date,originator,encoding,status_report,flash_sms,dst_port,src_port,sent_date,ref_no,priority,status,errors,gateway_id,user_id) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        string6 = String.format(string6, this.getProperty("tables.sms_out"));
        Connection connection = null;
        Statement statement = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.prepareStatement(string6);
            String[] stringArray = string.split(" ");
            for (int i = 0; i < stringArray.length; ++i) {
                if (!bl) {
                    statement.setString(1, "O");
                } else {
                    statement.setString(1, "W");
                }
                statement.setString(2, stringArray[i]);
                statement.setString(3, string2);
                statement.setString(4, string4);
                statement.setTimestamp(5, null);
                statement.setString(6, null);
                statement.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
                statement.setString(8, "");
                statement.setString(9, "U");
                statement.setInt(10, 0);
                statement.setInt(11, 0);
                statement.setInt(12, -1);
                statement.setInt(13, -1);
                statement.setTimestamp(14, null);
                statement.setString(15, null);
                statement.setInt(16, 0);
                statement.setString(17, "U");
                statement.setInt(18, 0);
                statement.setString(19, string3);
                statement.setString(20, string5);
                JDSMSServer.getInstance().userConsolePrint("A", string6);
                statement.executeUpdate();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMessages() throws Exception {
        Connection connection = null;
        Statement statement = null;
        String string = "update " + this.getProperty("tables.sms_out") + " set errors = 0, gateway_id=? where status = 'U' and (gateway_id='*' or gateway_id='#' or gateway_id='$')";
        JDSMSServer.getInstance().userConsolePrint("m", "update messages: " + string);
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.prepareStatement(string);
            String string2 = this._$1();
            statement.setString(1, string2);
            statement.executeUpdate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
    }

    public Connection getConnection() throws Exception {
        Class.forName(this.getProperty("driver")).newInstance();
        Connection connection = DriverManager.getConnection(this.getProperty("url"), this.getDbUserName(), this.getDbPassword());
        return connection;
    }

    protected String DateFormat(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(date);
    }

    protected Timestamp DateFromString(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
        if (string == null || "".equals(string) || !string.matches("\\d{14}")) {
            return new Timestamp(simpleDateFormat.parse(simpleDateFormat.format(new Date())).getTime());
        }
        return new Timestamp(simpleDateFormat.parse(string).getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyUser(User user) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String string = "update  %s set password = ?, user_desc = ? where user_id = ?";
        string = String.format(string, this.getProperty("tables.sms_user"));
        Connection connection = null;
        Statement statement = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.prepareStatement(string);
            statement.setString(1, user.getPassword());
            statement.setString(2, user.getUserDesc());
            statement.setString(3, user.getUserId());
            statement.executeUpdate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyUserPassword(User user) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String string = "update  %s set password = ? where user_id = ?";
        string = String.format(string, this.getProperty("tables.sms_user"));
        Connection connection = null;
        Statement statement = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.prepareStatement(string);
            statement.setString(1, user.getPassword());
            statement.setString(2, user.getUserId());
            statement.executeUpdate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyUserSurplusNumber(User user) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String string = "update  %s set surplus_number = ? where user_id = ?";
        string = String.format(string, this.getProperty("tables.sms_user"));
        Connection connection = null;
        Statement statement = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.prepareStatement(string);
            statement.setInt(1, user.getSurplusNumber());
            statement.setString(2, user.getUserId());
            statement.executeUpdate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delUser(String[] stringArray) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String string = "delete  from %s where user_id = ?";
        string = String.format(string, this.getProperty("tables.sms_user"));
        Connection connection = null;
        Statement statement = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.prepareStatement(string);
            for (int i = 0; i < stringArray.length; ++i) {
                statement.setString(1, stringArray[i]);
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignUserPermission(String[] stringArray) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String string = "update %s set flag = '1' where user_id = ?";
        string = String.format(string, this.getProperty("tables.sms_user"));
        Connection connection = null;
        Statement statement = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.prepareStatement(string);
            for (int i = 0; i < stringArray.length; ++i) {
                statement.setString(1, stringArray[i]);
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokePermission(String[] stringArray) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String string = "update %s set flag = '0' where user_id = ?";
        string = String.format(string, this.getProperty("tables.sms_user"));
        Connection connection = null;
        Statement statement = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.prepareStatement(string);
            for (int i = 0; i < stringArray.length; ++i) {
                statement.setString(1, stringArray[i]);
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setnolimit(String[] stringArray) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String string = "update %s set sendlimit = '0' where user_id = ?";
        string = String.format(string, this.getProperty("tables.sms_user"));
        Connection connection = null;
        Statement statement = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.prepareStatement(string);
            for (int i = 0; i < stringArray.length; ++i) {
                statement.setString(1, stringArray[i]);
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setlimit(String[] stringArray) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String string = "update %s set sendlimit = '1' where user_id = ?";
        string = String.format(string, this.getProperty("tables.sms_user"));
        Connection connection = null;
        Statement statement = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.prepareStatement(string);
            for (int i = 0; i < stringArray.length; ++i) {
                statement.setString(1, stringArray[i]);
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSendRecord(User user) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String string = "update  %s set  surplus_number = ? where user_id = ?";
        string = String.format(string, this.getProperty("tables.sms_user"));
        Connection connection = null;
        Statement statement = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.prepareStatement(string);
            statement.setInt(1, user.getSurplusNumber());
            statement.setString(2, user.getUserId());
            statement.executeUpdate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delRecord(List<String> list, User user, String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String string2 = "";
        if ("0".equals(string)) {
            string2 = "delete from %s where id = ? and status = 'Z' ";
            if (!"admin".equals(user.getUserId())) {
                string2 = string2 + "and user_id = ?";
            }
            string2 = String.format(string2, this.getProperty("tables.sms_out"));
        } else if (!"3".equals(string)) {
            string2 = "delete  from %s where id = ? ";
            if (!"admin".equals(user.getUserId())) {
                string2 = string2 + "and user_id = ?";
            }
            string2 = String.format(string2, this.getProperty("tables.sms_out"));
        } else {
            string2 = "delete  from %s where id = ?";
            string2 = String.format(string2, this.getProperty("tables.sms_in"));
        }
        Connection connection = null;
        Statement statement = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.prepareStatement(string2);
            for (int i = 0; i < list.size(); ++i) {
                if ("0".equals(string)) {
                    statement.setInt(1, Integer.parseInt(list.get(i)));
                    if (!"admin".equals(user.getUserId())) {
                        statement.setString(2, user.getUserId());
                    }
                } else if (!"3".equals(string)) {
                    statement.setInt(1, Integer.parseInt(list.get(i)));
                    if (!"admin".equals(user.getUserId())) {
                        statement.setString(2, user.getUserId());
                    }
                } else {
                    statement.setInt(1, Integer.parseInt(list.get(i)));
                }
                statement.execute();
            }
            statement.executeBatch();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delRecord(String[] stringArray, User user, String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String string2 = "";
        if ("0".equals(string)) {
            string2 = "delete from %s where id = ? and status = 'Z' ";
            if (!"admin".equals(user.getUserId())) {
                string2 = string2 + "and user_id = ?";
            }
            string2 = String.format(string2, this.getProperty("tables.sms_out"));
        } else if (!"3".equals(string)) {
            string2 = "delete  from %s where id = ? ";
            if (!"admin".equals(user.getUserId())) {
                string2 = string2 + "and user_id = ?";
            }
            string2 = String.format(string2, this.getProperty("tables.sms_out"));
        } else {
            string2 = "delete  from %s where id = ?";
            string2 = String.format(string2, this.getProperty("tables.sms_in"));
        }
        Connection connection = null;
        Statement statement = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.prepareStatement(string2);
            for (int i = 0; i < stringArray.length; ++i) {
                if ("0".equals(string)) {
                    statement.setInt(1, Integer.parseInt(stringArray[i]));
                    if (!"admin".equals(user.getUserId())) {
                        statement.setString(2, user.getUserId());
                    }
                } else if (!"3".equals(string)) {
                    statement.setInt(1, Integer.parseInt(stringArray[i]));
                    if (!"admin".equals(user.getUserId())) {
                        statement.setString(2, user.getUserId());
                    }
                } else {
                    statement.setInt(1, Integer.parseInt(stringArray[i]));
                }
                statement.execute();
            }
            statement.executeBatch();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSending(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String string2 = "select * from " + this.getProperty("tables.sms_out") + " where id = " + string + " and status = 'Q'";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAddRecord(String string, int n) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String string2 = "insert into %s (add_time,user_id,add_number) values(?,?,?)";
        string2 = String.format(string2, this.getProperty("tables.sms_record"));
        Connection connection = null;
        Statement statement = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.prepareStatement(string2);
            statement.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            statement.setString(2, string);
            statement.setInt(3, n);
            statement.executeUpdate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getAllUser() throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        ArrayList<User> arrayList = new ArrayList<User>();
        Connection connection = null;
        Statement statement = null;
        String string = "select * from " + this.getProperty("tables.sms_user");
        ResultSet resultSet = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                User user = new User();
                user.setUserId(resultSet.getString("user_id"));
                user.setPassword(resultSet.getString("password"));
                user.setUserDesc(resultSet.getString("user_desc"));
                user.setSurplusNumber(resultSet.getInt("surplus_number"));
                arrayList.add(user);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUser(User user) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String string = "insert into %s (user_id,password,user_desc,surplus_number) values(?,?,?,?)";
        string = String.format(string, this.getProperty("tables.sms_user"));
        Connection connection = null;
        Statement statement = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.prepareStatement(string);
            statement.setString(1, user.getUserId());
            statement.setString(2, user.getPassword());
            statement.setString(3, user.getUserDesc());
            statement.setInt(4, user.getSurplusNumber());
            statement.executeUpdate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User findUserById(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String string2 = "select * from " + this.getProperty("tables.sms_user") + " where user_id = '" + string + "'";
        User user = null;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                user = new User();
                user.setUserId(resultSet.getString("user_id"));
                user.setPassword(resultSet.getString("password"));
                user.setUserDesc(resultSet.getString("user_desc"));
                user.setSurplusNumber(resultSet.getInt("surplus_number"));
                user.setFlag(resultSet.getInt("flag"));
                user.setSendlimit(resultSet.getInt("sendlimit"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFaultRecord(List<String> list, User user, String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String string2 = "update  %s set  status = ? where id = ? ";
        if (!"admin".equals(user.getUserId())) {
            string2 = string2 + "and user_id = ?";
        }
        string2 = String.format(string2, this.getProperty("tables.sms_out"));
        Connection connection = null;
        Statement statement = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.prepareStatement(string2);
            for (int i = 0; i < list.size(); ++i) {
                statement.setString(1, string);
                statement.setInt(2, Integer.parseInt(list.get(i)));
                if (!"admin".equals(user.getUserId())) {
                    statement.setString(3, user.getUserId());
                }
                statement.execute();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFaultRecord(User user, String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String string2 = "update  %s set  status = ? where status = 'U'";
        if (!"admin".equals(user.getUserId())) {
            string2 = string2 + " and user_id = ?";
        }
        string2 = String.format(string2, this.getProperty("tables.sms_out"));
        Connection connection = null;
        Statement statement = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.prepareStatement(string2);
            statement.setString(1, string);
            if (!"admin".equals(user.getUserId())) {
                statement.setString(2, user.getUserId());
            }
            statement.execute();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFaultRecord(String[] stringArray, User user, String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String string2 = "update  %s set  status = ? where id = ? ";
        if (!"admin".equals(user.getUserId())) {
            string2 = string2 + "and user_id = ?";
        }
        string2 = String.format(string2, this.getProperty("tables.sms_out"));
        Connection connection = null;
        Statement statement = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.prepareStatement(string2);
            for (int i = 0; i < stringArray.length; ++i) {
                statement.setString(1, string);
                statement.setInt(2, Integer.parseInt(stringArray[i]));
                if (!"admin".equals(user.getUserId())) {
                    statement.setString(3, user.getUserId());
                }
                statement.execute();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean AddAlertInfoToDB(AlertInfo alertInfo) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        Statement statement;
        Statement statement2;
        Statement statement3;
        Connection connection;
        block17: {
            connection = null;
            statement3 = null;
            statement2 = null;
            statement = null;
            ResultSet resultSet = null;
            try {
                try {
                    connection = ConnectionPool.getInstance().getConnection();
                    String string = alertInfo.getCCID();
                    String string2 = this.getProperty("tables.sms_alert");
                    statement3 = connection.createStatement();
                    String string3 = "select * from " + string2 + " where ccid_id = '" + string + "'";
                    resultSet = statement3.executeQuery(string3);
                    if (resultSet.next()) {
                        string3 = "delete from " + string2 + " where ccid_id = '" + string + "'";
                        statement = connection.prepareStatement(string3);
                        statement.executeUpdate();
                        statement.close();
                    }
                    string3 = "insert into %s (ccid_id,alert_number,sent_number,call_number,alert_msg,maxLimit_number,add_time) values(?,?,?,?,?,?,?)";
                    string3 = String.format(string3, string2);
                    statement2 = connection.prepareStatement(string3);
                    statement2.setString(1, alertInfo.getCCID());
                    statement2.setString(2, String.valueOf(alertInfo.getAlertNumber()));
                    statement2.setString(3, String.valueOf(alertInfo.getSentNumber()));
                    statement2.setString(4, alertInfo.getCallNumber());
                    String string4 = alertInfo.getAlertMsg();
                    statement2.setString(5, string4);
                    statement2.setString(6, String.valueOf(alertInfo.getMaxLimitNumber()));
                    statement2.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
                    statement2.executeUpdate();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var12_13 = null;
                    if (resultSet != null) {
                        resultSet.close();
                        resultSet = null;
                    }
                    if (statement2 != null) {
                        statement2.close();
                        statement2 = null;
                    }
                    if (statement != null) {
                        statement.close();
                        statement = null;
                    }
                    if (statement3 != null) {
                        statement3.close();
                        statement3 = null;
                    }
                    ConnectionPool.getInstance().returnConnection(connection);
                    return true;
                }
                Object var12_12 = null;
                if (resultSet == null) break block17;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (statement2 != null) {
                    statement2.close();
                    statement2 = null;
                }
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
                if (statement3 != null) {
                    statement3.close();
                    statement3 = null;
                }
                ConnectionPool.getInstance().returnConnection(connection);
                throw throwable;
            }
            resultSet.close();
            resultSet = null;
        }
        if (statement2 != null) {
            statement2.close();
            statement2 = null;
        }
        if (statement != null) {
            statement.close();
            statement = null;
        }
        if (statement3 != null) {
            statement3.close();
            statement3 = null;
        }
        ConnectionPool.getInstance().returnConnection(connection);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTmpMsg(String string, int n, String string2, int n2, String string3) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        Object object = _$1;
        synchronized (object) {
            JDSMSServer.getInstance().userConsolePrint("A", "addTmpMsg-----");
            String string4 = this.getProperty("tables.sms_tmp_msg");
            Connection connection = null;
            Statement statement = null;
            Statement statement2 = null;
            try {
                connection = ConnectionPool.getInstance().getConnection();
                statement2 = connection.createStatement();
                String string5 = "insert into %s (pdustring,memindex,memlocation,ml,ccid) values(?,?,?,?,?)";
                string5 = String.format(string5, string4);
                statement = connection.prepareStatement(string5);
                statement.setString(1, string);
                statement.setInt(2, n);
                statement.setString(3, string2);
                statement.setInt(4, n2);
                statement.setString(5, string3);
                statement.executeUpdate();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
                if (statement2 != null) {
                    statement2.close();
                    statement2 = null;
                }
                ConnectionPool.getInstance().returnConnection(connection);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<TmpMsg> getTmpMsg(boolean bl, String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        Object object = _$1;
        synchronized (object) {
            ArrayList<TmpMsg> arrayList = new ArrayList<TmpMsg>();
            ResultSet resultSet = null;
            Statement statement = null;
            Connection connection = null;
            try {
                Object object2;
                connection = ConnectionPool.getInstance().getConnection();
                String string2 = this.getProperty("tables.sms_tmp_msg");
                statement = connection.createStatement();
                String string3 = "";
                if (string != null && !string.trim().equals("")) {
                    string3 = " where ccid = '" + string + "'";
                }
                String string4 = "select * from " + string2 + string3 + " order by id";
                resultSet = statement.executeQuery(string4);
                while (resultSet.next()) {
                    object2 = new TmpMsg();
                    ((TmpMsg)object2).setId(resultSet.getInt("id"));
                    ((TmpMsg)object2).setPdustring(resultSet.getString("pdustring"));
                    ((TmpMsg)object2).setMemindex(resultSet.getInt("memindex"));
                    ((TmpMsg)object2).setMemlocation(resultSet.getString("memlocation"));
                    ((TmpMsg)object2).setMl(resultSet.getInt("ml"));
                    ((TmpMsg)object2).setCCID(resultSet.getString("ccid"));
                    if (bl) {
                        if (((TmpMsg)object2).getMemindex() == 0 && (Utils.isEmptyStr(((TmpMsg)object2).getMemlocation()) || Const.TMP_MSG_TYPE.contains(((TmpMsg)object2).getMemlocation())) && ((TmpMsg)object2).getMl() == 0) continue;
                        arrayList.add((TmpMsg)object2);
                    }
                    if (bl || ((TmpMsg)object2).getMemindex() != 0 || !Const.TMP_MSG_TYPE.contains(((TmpMsg)object2).getMemlocation()) || ((TmpMsg)object2).getMl() != 0) continue;
                    arrayList.add((TmpMsg)object2);
                }
                object2 = arrayList;
                return object2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
                ConnectionPool.getInstance().returnConnection(connection);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteTmpMsg(int n) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        JDSMSServer.getInstance().userConsolePrint("A", "delete----" + n);
        Connection connection = null;
        Statement statement = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            String string = this.getProperty("tables.sms_tmp_msg");
            statement = connection.createStatement();
            String string2 = "delete from " + string + " where id = '" + n + "'";
            statement.execute(string2);
            boolean bl = statement.execute(string2);
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteTmpMsg(String string, String string2) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        Object object = _$1;
        synchronized (object) {
            JDSMSServer.getInstance().userConsolePrint("A", "delete----" + string + "____" + string2);
            Connection connection = null;
            Statement statement = null;
            String string3 = this.getProperty("tables.sms_tmp_msg");
            String string4 = "delete from " + string3 + " where pdustring like " + "'" + string + "____" + string2 + "%'";
            try {
                connection = ConnectionPool.getInstance().getConnection();
                statement = connection.createStatement();
                boolean bl = statement.execute(string4);
                return bl;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
                ConnectionPool.getInstance().returnConnection(connection);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteTmpMsgByType(String string, String string2) {
        Object object = _$1;
        synchronized (object) {
            Statement statement = null;
            Connection connection = null;
            try {
                connection = ConnectionPool.getInstance().getConnection();
                String string3 = this.getProperty("tables.sms_tmp_msg");
                statement = connection.createStatement();
                String string4 = "delete from " + string3 + " where pdustring like " + "'" + string + "%'" + " and memlocation = " + "'" + string2 + "'";
                boolean bl = statement.execute(string4);
                return bl;
            }
            catch (Exception exception) {
                boolean bl2 = false;
                return bl2;
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                    statement = null;
                }
                ConnectionPool.getInstance().returnConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dealOldMsg() throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        Object object = _$1;
        synchronized (object) {
            JDSMSServer.getInstance().userConsolePrint("A", "delete----");
            String string = this.getProperty("tables.sms_tmp_msg");
            String string2 = "delete from " + string + " where memindex ='' and memlocation =0 and ml =0";
            String string3 = "update " + this.getProperty("tables.sms_in") + " set process = 99 where process >99";
            Connection connection = null;
            Statement statement = null;
            try {
                connection = ConnectionPool.getInstance().getConnection();
                statement = connection.createStatement();
                statement.execute(string2);
                statement.execute(string3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
                ConnectionPool.getInstance().returnConnection(connection);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlertInfo getAlertInfoFromDB(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        AlertInfo alertInfo = new AlertInfo();
        String string2 = this.getProperty("tables.sms_alert");
        String string3 = "select * from " + string2 + " where ccid_id = '" + string + "'";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                alertInfo.setCCID(resultSet.getString("ccid_id"));
                alertInfo.setAlertNumber(Integer.valueOf(resultSet.getString("alert_number")));
                alertInfo.setSentNumber(Integer.valueOf(resultSet.getString("sent_number")));
                alertInfo.setCallNumber(resultSet.getString("call_number"));
                String string4 = resultSet.getString("alert_msg");
                alertInfo.setAlertMsg(string4);
                alertInfo.setMaxLimitNumber(Integer.valueOf(resultSet.getString("maxLimit_number")));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
        return alertInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPhoneMsgSentCount(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        String string2 = "" + n;
        String string3 = "" + n2;
        String string4 = "" + n3;
        String string5 = "" + n4;
        String string6 = "" + n5;
        String string7 = "" + n6;
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        if (string4.length() == 1) {
            string4 = "0" + string4;
        }
        if (string5.length() == 1) {
            string5 = "0" + string5;
        }
        if (string6.length() == 1) {
            string6 = "0" + string6;
        }
        if (string7.length() == 1) {
            string7 = "0" + string7;
        }
        String string8 = string4 + string5 + string6 + string7;
        String string9 = JDSMSServer.getInstance().getProperties().getString("settings.settlement_interval_day_begin", "15");
        String string10 = JDSMSServer.getInstance().getProperties().getString("settings.settlement_interval_hour_begin", "00");
        String string11 = JDSMSServer.getInstance().getProperties().getString("settings.settlement_interval_min_begin", "00");
        String string12 = JDSMSServer.getInstance().getProperties().getString("settings.settlement_interval_second_begin", "00");
        if (string9.length() == 1) {
            string9 = "0" + string9;
        }
        if (string10.length() == 1) {
            string10 = "0" + string10;
        }
        if (string11.length() == 1) {
            string11 = "0" + string11;
        }
        if (string12.length() == 1) {
            string12 = "0" + string12;
        }
        String string13 = string9 + string10 + string11 + string12;
        String string14 = JDSMSServer.getInstance().getProperties().getString("settings.settlement_interval_day_end", "14");
        String string15 = JDSMSServer.getInstance().getProperties().getString("settings.settlement_interval_hour_end", "23");
        String string16 = JDSMSServer.getInstance().getProperties().getString("settings.settlement_interval_min_end", "59");
        String string17 = JDSMSServer.getInstance().getProperties().getString("settings.settlement_interval_second_end", "59");
        if (string14.length() == 1) {
            string14 = "0" + string14;
        }
        if (string15.length() == 1) {
            string15 = "0" + string15;
        }
        if (string16.length() == 1) {
            string16 = "0" + string16;
        }
        if (string17.length() == 1) {
            string17 = "0" + string17;
        }
        String string18 = string14 + string15 + string16 + string17;
        if (string8.compareTo(string13) >= 0) {
            string13 = string2 + string3 + string13;
            string18 = string8.compareTo(string18) <= 0 ? string2 + string3 + string18 : (string3.equals("12") ? String.valueOf(Integer.parseInt(string2) + 1) + "01" + string18 : string2 + String.valueOf(Integer.parseInt(string3) + 1) + string18);
        } else {
            string13 = string3.equals("01") ? String.valueOf(Integer.parseInt(string2) - 1) + "12" + string13 : string2 + String.valueOf(Integer.parseInt(string3) - 1) + string13;
            string18 = string8.compareTo(string18) <= 0 ? string2 + string3 + string18 : (string3.equals("12") ? String.valueOf(Integer.parseInt(string2) + 1) + string3 + string18 : string2 + String.valueOf(Integer.parseInt(string3) + 1) + string18);
        }
        Timestamp timestamp = null;
        Timestamp timestamp2 = null;
        try {
            timestamp = this.DateFromString(string13);
            timestamp2 = this.DateFromString(string18);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        int n7 = 0;
        String string19 = "select count(1) as MsgSentCount from " + this.getProperty("tables.sms_out") + " where gateway_id = '" + string + "' and sent_date >= '" + timestamp + "' and sent_date <= '" + timestamp2 + "'";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string19);
            if (resultSet.next()) {
                n7 = resultSet.getInt("MsgSentCount");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
        return n7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProcess(int n, int n2) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String string = "update  %s set  process = ? where id = ? ";
        string = String.format(string, this.getProperty("tables.sms_in"));
        Connection connection = null;
        Statement statement = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            statement = connection.prepareStatement(string);
            statement.setInt(1, n2);
            statement.setInt(2, n);
            statement.execute();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (statement != null) {
                statement.close();
                statement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InboundMessage> getProcess(int n) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        ArrayList<InboundMessage> arrayList = new ArrayList<InboundMessage>();
        String string = "select id,gateway_id,text,originator from  %s where  process = " + n + "";
        string = String.format(string, this.getProperty("tables.sms_in"));
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            preparedStatement = connection.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                InboundMessage inboundMessage = new InboundMessage(new Date(), resultSet.getString("originator"), resultSet.getString("text"), resultSet.getString("gateway_id"));
                inboundMessage.setPushMsgId(resultSet.getInt("id"));
                arrayList.add(inboundMessage);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            if (preparedStatement != null) {
                preparedStatement.close();
                preparedStatement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InboundMessage> getProcessFail(int n, long l) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        ArrayList<InboundMessage> arrayList = new ArrayList<InboundMessage>();
        long l2 = new Date().getTime();
        l = l * 24L * 60L * 60L * 1000L;
        long l3 = l2 -= l;
        Timestamp timestamp = new Timestamp(l3);
        String string = "select id,gateway_id,text,originator from  " + this.getProperty("tables.sms_in") + " where  process = " + n + " and receive_date >= '" + timestamp + "'";
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = ConnectionPool.getInstance().getConnection();
            preparedStatement = connection.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                InboundMessage inboundMessage = new InboundMessage(new Date(), resultSet.getString("originator"), resultSet.getString("text"), resultSet.getString("gateway_id"));
                inboundMessage.setPushMsgId(resultSet.getInt("id"));
                arrayList.add(inboundMessage);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            if (preparedStatement != null) {
                preparedStatement.close();
                preparedStatement = null;
            }
            ConnectionPool.getInstance().returnConnection(connection);
        }
        return arrayList;
    }

    public abstract Page waitForSendMsgList(int var1, User var2) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException;

    public abstract Page getUserList(int var1) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException;

    public abstract Page getAddRecordList(String var1, int var2) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException;

    public abstract void cancelWaitMsg(User var1) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException;

    public abstract void deleteCanceledMsg(User var1) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException;

    public abstract Page findMsgByCondition(Condition var1, User var2) throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException;

    public abstract List findAllMsgByCondition(Condition var1, User var2) throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException;

    public abstract boolean modifySendTable(String var1);

    protected String GenerateRecvSQL(String string) {
        String string2 = "";
        if (!"".equals(string)) {
            string2 = " where gateway_id='" + string + "' ";
        }
        return string2;
    }

    protected String GenerateRecvSQL(String string, int n) {
        String string2 = "";
        string2 = !"".equals(string) ? " where gateway_id='" + string + "' and id>" + n : " where id>" + n;
        return string2;
    }

    private String _$1() {
        String string = "*";
        int n = Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.using_sorted", "0"));
        String string2 = JDSMSServer.getInstance().getProperties().getString("settings.device_using", "yes");
        String string3 = JDSMSServer.getInstance().getProperties().getString("settings.phone_using", "yes");
        String string4 = JDSMSServer.getInstance().getProperties().getString("settings.gateway_using", "yes");
        switch (n) {
            case 0: {
                if (string2.equals("yes")) {
                    string = "*";
                    break;
                }
                if (string4.equals("yes")) {
                    string = "#";
                    break;
                }
                if (!string3.equals("yes")) break;
                string = "$";
                break;
            }
            case 1: {
                if (string2.equals("yes")) {
                    string = "*";
                    break;
                }
                if (string3.equals("yes")) {
                    string = "$";
                    break;
                }
                if (!string4.equals("yes")) break;
                string = "#";
                break;
            }
            case 2: {
                if (string4.equals("yes")) {
                    string = "#";
                    break;
                }
                if (string2.equals("yes")) {
                    string = "*";
                    break;
                }
                if (!string3.equals("yes")) break;
                string = "$";
                break;
            }
            case 3: {
                if (string4.equals("yes")) {
                    string = "#";
                    break;
                }
                if (string3.equals("yes")) {
                    string = "$";
                    break;
                }
                if (!string2.equals("yes")) break;
                string = "*";
                break;
            }
            case 4: {
                if (string3.equals("yes")) {
                    string = "$";
                    break;
                }
                if (string2.equals("yes")) {
                    string = "*";
                    break;
                }
                if (!string4.equals("yes")) break;
                string = "#";
                break;
            }
            case 5: {
                if (string3.equals("yes")) {
                    string = "$";
                    break;
                }
                if (string4.equals("yes")) {
                    string = "#";
                    break;
                }
                if (!string2.equals("yes")) break;
                string = "*";
                break;
            }
        }
        return string;
    }
}

