/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.web;

import cn.sendsms.AGateway;
import cn.sendsms.Service;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.ResourceManager;
import cn.sendsms.jdsmsserver.web.AlertInfo;
import cn.sendsms.jdsmsserver.web.DbHelper;
import cn.sendsms.jdsmsserver.web.DeviceInfoCache;
import cn.sendsms.jdsmsserver.web.GetIpModemInfo;
import cn.sendsms.jdsmsserver.web.GetPortInfo;
import cn.sendsms.jdsmsserver.web.GetSerialPortInfoByGateway;
import cn.sendsms.jdsmsserver.web.HttpRequestReader;
import cn.sendsms.jdsmsserver.web.IIllIlIlIIlIIlII;
import cn.sendsms.jdsmsserver.web.JDWebAction;
import cn.sendsms.jdsmsserver.web.NetDeviceBean;
import cn.sendsms.jdsmsserver.web.NewAuth;
import cn.sendsms.jdsmsserver.web.PhoneInfoCache;
import cn.sendsms.jdsmsserver.web.SerialModemBean;
import cn.sendsms.jdsmsserver.web.SerialPhoneBean;
import cn.sendsms.jdsmsserver.web.llIIllIllIlIlIll;
import cn.sendsms.jdsmsserver.web.llllIIIlIllIIlll;
import cn.sendsms.otherModem.bean.BigDipperBean;
import cn.sendsms.otherModem.bean.LoraBean;
import cn.sendsms.otherModem.bean.NbIoTBean;
import cn.sendsms.otherModem.bigdipper.BDDeviceInfoGetter;
import cn.sendsms.otherModem.common.Utils;
import cn.sendsms.otherModem.driver.bigdipperDriver.BDDriver;
import cn.sendsms.otherModem.driver.loraDriver.LoRaDriver;
import cn.sendsms.otherModem.modem.Modem;
import cn.sendsms.otherModem.nbiot.NbIoTDeviceInfoGetter;
import cn.sendsms.otherModem.nbiot.authorize.AuthorizeInfo;
import cn.sendsms.otherModem.nbiot.authorize.NbIoTAuthorize;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jssc.SerialPort;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.ArrayUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DeviceConfigAction
extends JDWebAction {
    private static final long serialVersionUID = -7617843582936702460L;
    SerialModemBean device;
    private String deviceIp;
    private int startPort;
    private int endPort;
    private static NbIoTDeviceInfoGetter nbiotDeviceInfoGetter = NbIoTDeviceInfoGetter.getInstance();
    private static BDDeviceInfoGetter bdDeviceInfoGetter = BDDeviceInfoGetter.getInstance();

    public void refresh(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, Exception {
        try {
            httpServletRequest.setAttribute("devices", DeviceInfoCache.getInstance().getAll());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            this.log.error((Object)"get device list failed", (Throwable)cloneNotSupportedException);
        }
        catch (Exception exception) {
            this.log.error((Object)"\u83b7\u53d6\u8bbe\u5907\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)exception);
            throw exception;
        }
        this.findForward("device-config.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void refreshLoRa(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, Exception {
        try {
            httpServletRequest.setAttribute("LoRas", LoRaDriver.getInstance().getAll());
        }
        catch (Exception exception) {
            this.log.error((Object)"\u83b7\u53d6\u8bbe\u5907\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)exception);
            throw exception;
        }
        this.findForward("loraInfoPage.jsp", true, httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshNbIoT(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, Exception {
        try {
            List<NbIoTBean> list = nbiotDeviceInfoGetter.getAll();
            for (int i = 0; i < list.size(); ++i) {
                SerialPort serialPort;
                NbIoTBean nbIoTBean = list.get(i);
                if (!"0".equals(nbIoTBean.getUsingStatus())) continue;
                SerialPort serialPort2 = serialPort = nbiotDeviceInfoGetter.getSerialPort(nbIoTBean.getPortID());
                synchronized (serialPort2) {
                    if (!serialPort.isOpened()) {
                        String string = "99.99";
                        try {
                            string = Modem.getDriver(nbIoTBean.getDeviceType()).getSignal(nbiotDeviceInfoGetter.getSerialPort(nbIoTBean.getPortID()));
                        }
                        catch (Exception exception) {
                            this.log.error((Object)"\u68c0\u6d4bnbiot\u8bbe\u5907\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\u3002\u3002\u3002", (Throwable)exception);
                        }
                        nbIoTBean.setSignal(string);
                    }
                    continue;
                }
            }
            httpServletRequest.setAttribute("NbIoTs", list);
        }
        catch (Exception exception) {
            this.log.error((Object)"\u83b7\u53d6\u8bbe\u5907\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)exception);
            throw exception;
        }
        this.findForward("nbiotInfoPage.jsp", true, httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshBD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, Exception {
        try {
            List<BigDipperBean> list = bdDeviceInfoGetter.getAll();
            for (int i = 0; i < list.size(); ++i) {
                SerialPort serialPort;
                BigDipperBean bigDipperBean = list.get(i);
                if (!"0".equals(bigDipperBean.getUsingStatus())) continue;
                SerialPort serialPort2 = serialPort = bdDeviceInfoGetter.getSerialPort(bigDipperBean.getPortID());
                synchronized (serialPort2) {
                    if (!serialPort.isOpened()) {
                        String string = "";
                        try {
                            string = Modem.getDriver(bigDipperBean.getDeviceType()).getSignal(bdDeviceInfoGetter.getSerialPort(bigDipperBean.getPortID()));
                        }
                        catch (Exception exception) {
                            this.log.error((Object)"\u68c0\u6d4b\u5317\u6597\u8bbe\u5907\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\u3002\u3002\u3002", (Throwable)exception);
                        }
                        bigDipperBean.setSignal(string);
                    }
                    continue;
                }
            }
            httpServletRequest.setAttribute("BDs", bdDeviceInfoGetter.getAll());
        }
        catch (Exception exception) {
            this.log.error((Object)"\u83b7\u53d6\u8bbe\u5907\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)exception);
            throw exception;
        }
        this.findForward("bigdipperInfo.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void refreshTest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, Exception {
        try {
            PhoneInfoCache.getInstance().resetShowFlag();
            List<SerialPhoneBean> list = PhoneInfoCache.getInstance().getAll();
            httpServletRequest.setAttribute("phones", list);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            this.log.error((Object)"get device list failed", (Throwable)cloneNotSupportedException);
        }
        catch (Exception exception) {
            this.log.error((Object)"\u83b7\u53d6\u8bbe\u5907\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)exception);
            throw exception;
        }
        this.findForward("phoneInfoPage.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void addVitualNbIoTDevice(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        int n;
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        String string = propertiesConfiguration.getString("settings.mqtt_server", "119.90.56.92");
        if (!Utils.isConnectionOK(string, n = propertiesConfiguration.getInt("settings.mqtt_port", 1883))) {
            httpServletRequest.setAttribute("message", (Object)(ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.nbiot_mqtt_server_connect_failed") + string + ":" + n));
        } else if (nbiotDeviceInfoGetter.addVitualDevice()) {
            httpServletRequest.setAttribute("needSaveConfig", (Object)new String());
        } else {
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.nbiot_vitual_device_add_failed"));
        }
        httpServletRequest.setAttribute("NbIoTs", nbiotDeviceInfoGetter.getAll());
        this.findForward("nbiotInfoPage?action=refreshNbIoT", true, httpServletRequest, httpServletResponse);
    }

    public void regPhoneDeviceInit(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("phoneNo");
        String string2 = "";
        String string3 = "";
        String string4 = ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_failed_to_get_imei");
        long l = System.currentTimeMillis();
        try {
            List<SerialPhoneBean> list = PhoneInfoCache.getInstance().getAll();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (!list.get(i).getPhoneNo().equals(string)) continue;
                string2 = list.get(i).getPhoneImei();
                break;
            }
            if (string2 == null || string2.equals("")) {
                string2 = "";
                httpServletRequest.setAttribute("error", (Object)string4);
            }
            this.log.info((Object)("\u6ce8\u518c\u624b\u673a" + string + "\u5e8f\u5217\u53f7" + string2));
        }
        catch (Exception exception) {
            this.log.error((Object)"\u83b7\u53d6\u8bbe\u5907\u6ce8\u518c\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)exception);
            string2 = "";
            httpServletRequest.setAttribute("error", (Object)string4);
        }
        long l2 = System.currentTimeMillis();
        double d = l2 - l;
        this.log.info((Object)("\u83b7\u53d6\u624b\u673a" + string + "\u5e8f\u5217\u53f7\u8017\u65f6" + (d /= 1000.0) + "\u79d2"));
        httpServletRequest.setAttribute("serialnum", (Object)string2);
        httpServletRequest.setAttribute("phoneNo", (Object)string);
        string3 = NewAuth.getAuthorizeInfo(string2, "regcode");
        if (string3 == null || string3.indexOf("null") != -1) {
            string3 = "";
        }
        httpServletRequest.setAttribute("regcode", (Object)string3);
        if (string2.equals("") || string3.equals("")) {
            this.findForward("phone-register.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        int n = NewAuth.checkDevRegCode(string2, string3);
        if (n == 1) {
            httpServletRequest.setAttribute("info", (Object)(NewAuth.getAuthorizeInfo(string2, "authorize_time") != null ? "\u6388\u6743\u6709\u6548\uff0c\u6388\u6743\u65f6\u95f4\u4e3a\uff1a" + NewAuth.getAuthorizeInfo(string2, "authorize_time") : ""));
        } else if (httpServletRequest.getAttribute("error") == null) {
            httpServletRequest.setAttribute("error", (Object)"\u6388\u6743\u65e0\u6548");
        }
        this.findForward("phone-register.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void regPhoneDevice(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Integer n = 0;
        try {
            String string = httpServletRequest.getParameter("serialnum");
            String string2 = httpServletRequest.getParameter("regcode");
            String string3 = httpServletRequest.getParameter("phoneNo");
            httpServletRequest.setAttribute("serialnum", (Object)string);
            httpServletRequest.setAttribute("regcode", (Object)string2);
            httpServletRequest.setAttribute("phoneNo", (Object)string3);
            int n2 = NewAuth.checkDevRegCode(string, string2);
            if (n2 == 1) {
                n = 1;
                PhoneInfoCache.getInstance().setRealUsingPhoneFlag(string3, "1");
                httpServletRequest.setAttribute("message", (Object)"\u606d\u559c\u60a8\u8bbe\u5907\u6ce8\u518c\u6210\u529f\uff01");
                httpServletRequest.setAttribute("info", (Object)"\u6388\u6743\u6709\u6548");
            } else {
                n = 0;
                if (n2 == 2) {
                    httpServletRequest.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u5df2\u8fc7\u671f\uff01");
                    httpServletRequest.setAttribute("error", (Object)"\u6388\u6743\u5df2\u8fc7\u671f");
                } else if (n2 == 3) {
                    httpServletRequest.setAttribute("message", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6ce8\u518c\u65e0\u6548\uff01");
                    httpServletRequest.setAttribute("error", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6388\u6743\u65e0\u6548");
                } else {
                    httpServletRequest.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u65e0\u6548\uff01");
                    httpServletRequest.setAttribute("error", (Object)"\u6388\u6743\u65e0\u6548");
                }
            }
            this.savePhoneConfiguration();
            NewAuth.saveAuthorize(string3, string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            httpServletRequest.setAttribute("serialnum", (Object)"");
            httpServletRequest.setAttribute("regcode", (Object)"");
            httpServletRequest.setAttribute("message", (Object)"\u6ce8\u518c\u8bbe\u5907\u5931\u8d25\uff01");
            httpServletRequest.setAttribute("error", (Object)"\u6ce8\u518c\u8bbe\u5907\u5931\u8d25\uff01");
        }
        this.findForward("phone-register.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void startPhones(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String[] stringArray = httpServletRequest.getParameter("ids").split(",");
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            boolean bl2;
            String string2 = stringArray[i];
            if (0 == PhoneInfoCache.getInstance().startPhones(string2)) {
                bl = true;
            }
            if (bl2 = NewAuth.checkDeviceAuth(string = PhoneInfoCache.getInstance().getPhoneIMEI(string2))) {
                NewAuth.updateAuthorizeTemp();
                continue;
            }
            NewAuth.updateAuthorizeTemp();
        }
        if (bl) {
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.phone_please_do_not_select_the_device_not_connected_or_in_the_enabled_state"));
            httpServletRequest.setAttribute("phones", PhoneInfoCache.getInstance().getAll());
            this.findForward("phoneInfoPage.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        this.savePhoneConfiguration();
        httpServletRequest.setAttribute("phones", PhoneInfoCache.getInstance().getAll());
        this.findForward("phoneInfoPage.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void startLoras(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        int n;
        String[] stringArray = httpServletRequest.getParameter("ids").split(",");
        boolean bl = true;
        boolean bl2 = false;
        String string = "";
        for (n = 0; n < stringArray.length; ++n) {
            if (!LoRaDriver.getInstance().findDeviceByPortID(stringArray[n]).isValidate()) {
                bl2 = true;
            }
            string = "";
            if (LoRaDriver.getInstance().checkStartLoras(stringArray[n])) {
                bl = false;
                httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.lora_start_tips1"));
                break;
            }
            string = LoRaDriver.getInstance().checkDeviceMode(LoRaDriver.getInstance().getSerialPort(stringArray[n]));
            if ("OK".equals(string)) continue;
            bl = false;
            break;
        }
        if (!bl) {
            if ("ERROR1".equals(string)) {
                httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.lora_start_tips1"));
            } else if ("ERROR2".equals(string)) {
                httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.lora_start_tips2"));
            } else {
                httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.lora_start_tips3"));
            }
            httpServletRequest.setAttribute("LoRas", LoRaDriver.getInstance().getAll());
            this.findForward("loraInfoPage.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        n = 0;
        ArrayList<String> arrayList = new ArrayList();
        if (bl2) {
            arrayList = LoRaDriver.getInstance().getSerialNumberList();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            n = 0;
            if (LoRaDriver.getInstance().startDevice(stringArray[i], arrayList)) {
                n = 1;
            }
            if (n != 0) continue;
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.phone_please_do_not_select_the_device_not_connected_or_in_the_enabled_state"));
            httpServletRequest.setAttribute("LoRas", LoRaDriver.getInstance().getAll());
            this.findForward("loraInfoPage.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        httpServletRequest.setAttribute("LoRas", LoRaDriver.getInstance().getAll());
        this.findForward("loraInfoPage.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void startNbIoTs(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String[] stringArray = httpServletRequest.getParameter("ids").split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (nbiotDeviceInfoGetter.checkStartNbIoT(stringArray[i])) {
                httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.nbiot_start_tips2"));
                httpServletRequest.setAttribute("NbIoTs", NbIoTDeviceInfoGetter.getInstance().getAll());
                this.findForward("nbiotInfoPage.jsp", true, httpServletRequest, httpServletResponse);
                return;
            }
            if (Modem.getDriver(nbiotDeviceInfoGetter.findDeviceByPortID(stringArray[i]).getDeviceType()).startDevice(stringArray[i])) continue;
            Modem.getDriver(nbiotDeviceInfoGetter.findDeviceByPortID(stringArray[i]).getDeviceType()).stopDevice(stringArray[i]);
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.nbiot_start_tips3"));
            httpServletRequest.setAttribute("NbIoTs", nbiotDeviceInfoGetter.getAll());
            this.findForward("nbiotInfoPage.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        httpServletRequest.setAttribute("NbIoTs", nbiotDeviceInfoGetter.getAll());
        this.findForward("nbiotInfoPage.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void startBigDippers(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        int n;
        String[] stringArray = httpServletRequest.getParameter("ids").split(",");
        for (n = 0; n < stringArray.length; ++n) {
            if (!bdDeviceInfoGetter.checkStartBD(stringArray[n])) continue;
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.bd_start_tips1"));
            httpServletRequest.setAttribute("BDs", bdDeviceInfoGetter.getAll());
            this.findForward("bigdipperInfo.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (BDDriver.getInstance().startDevice(stringArray[n])) continue;
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.bd_start_tips2"));
            httpServletRequest.setAttribute("BDs", bdDeviceInfoGetter.getAll());
            this.findForward("bigdipperInfo.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        httpServletRequest.setAttribute("BDs", bdDeviceInfoGetter.getAll());
        this.findForward("bigdipperInfo.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void stopPhones(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, CloneNotSupportedException, ConfigurationException {
        String[] stringArray = httpServletRequest.getParameter("ids").split(",");
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (0 != PhoneInfoCache.getInstance().stopPhones(stringArray[i])) continue;
            bl = true;
        }
        if (bl) {
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.phone_please_do_not_select_the_device_not_in_the_enabled_state"));
            httpServletRequest.setAttribute("phones", PhoneInfoCache.getInstance().getAll());
            this.findForward("phoneInfoPage.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        this.savePhoneConfiguration();
        httpServletRequest.setAttribute("phones", PhoneInfoCache.getInstance().getAll());
        this.findForward("phoneInfoPage.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void stopLoras(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, CloneNotSupportedException, ConfigurationException {
        String[] stringArray = httpServletRequest.getParameter("ids").split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].replace(" ", "").equals("")) continue;
            if (LoRaDriver.getInstance().checkStopLoras(stringArray[i])) {
                httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.lora_stop_tips1"));
                httpServletRequest.setAttribute("LoRas", LoRaDriver.getInstance().getAll());
                this.findForward("loraInfoPage.jsp", true, httpServletRequest, httpServletResponse);
                return;
            }
            boolean bl = LoRaDriver.getInstance().stopDevice(stringArray[i]);
            if (bl) {
                this.log.info((Object)("\u8bbe\u5907" + stringArray[i] + "\u5df2\u7ecf\u505c\u6b62"));
                continue;
            }
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.lora_start_tips2"));
            this.log.error((Object)("\u8bbe\u5907" + stringArray[i] + "\u505c\u6b62\u5931\u8d25\u3002\u3002"));
        }
        httpServletRequest.setAttribute("LoRas", LoRaDriver.getInstance().getAll());
        this.findForward("loraInfoPage.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void stopNbIoTs(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, CloneNotSupportedException, ConfigurationException {
        String[] stringArray = httpServletRequest.getParameter("ids").split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].replace(" ", "").equals("")) continue;
            if (nbiotDeviceInfoGetter.checkStopNbIoT(stringArray[i])) {
                httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.lora_stop_tips1"));
                httpServletRequest.setAttribute("NbIoTs", nbiotDeviceInfoGetter.getAll());
                this.findForward("nbiotInfoPage.jsp", true, httpServletRequest, httpServletResponse);
                return;
            }
            boolean bl = Modem.getDriver(nbiotDeviceInfoGetter.findDeviceByPortID(stringArray[i]).getDeviceType()).stopDevice(stringArray[i]);
            if (bl) {
                this.log.info((Object)("\u8bbe\u5907" + stringArray[i] + "\u5df2\u7ecf\u505c\u6b62"));
                continue;
            }
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.lora_start_tips2"));
            this.log.info((Object)("\u8bbe\u5907" + stringArray[i] + "\u5df2\u7ecf\u505c\u6b62"));
        }
        httpServletRequest.setAttribute("NbIoTs", nbiotDeviceInfoGetter.getAll());
        this.findForward("nbiotInfoPage.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void stopBigDippers(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, CloneNotSupportedException, ConfigurationException {
        String[] stringArray = httpServletRequest.getParameter("ids").split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].replace(" ", "").equals("")) continue;
            if (bdDeviceInfoGetter.checkStopBD(stringArray[i])) {
                httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.bd_stop_tips1"));
                httpServletRequest.setAttribute("BDs", bdDeviceInfoGetter.getAll());
                this.findForward("bigdipperInfo.jsp", true, httpServletRequest, httpServletResponse);
                return;
            }
            BDDriver.getInstance().stopDevice(stringArray[i]);
        }
        httpServletRequest.setAttribute("BDs", bdDeviceInfoGetter.getAll());
        this.findForward("bigdipperInfo.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void deleteLoraConfig(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, Exception {
        String[] stringArray = httpServletRequest.getParameter("ids").split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                LoraBean loraBean = LoRaDriver.getInstance().findDeviceByPortID(stringArray[i]);
                if (!"0".equals(loraBean.getUsingStatus())) {
                    httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.delete_device_tip_1"));
                    this.findForward("/loraInfoPage?action=refreshLoRa", true, httpServletRequest, httpServletResponse);
                    return;
                }
                try {
                    LoRaDriver.getInstance().deleteConfiguration(loraBean);
                    LoRaDriver.getInstance().deleteLora(loraBean.getPortID());
                    continue;
                }
                catch (ConfigurationException configurationException) {
                    this.log.error((Object)"\u5220\u9664\u914d\u7f6e\u5931\u8d25");
                    httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info"));
                    this.findForward("/loraInfoPage?action=refreshLoRa", true, httpServletRequest, httpServletResponse);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.log.info((Object)"\u5220\u9664\u914d\u7f6e\u6210\u529f");
        List<LoraBean> list = LoRaDriver.getInstance().getAll();
        httpServletRequest.setAttribute("LoRas", list);
        this.findForward("/loraInfoPage?action=refreshLoRa", true, httpServletRequest, httpServletResponse);
    }

    public void deleteNbIoTConfig(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, Exception {
        String[] stringArray = httpServletRequest.getParameter("ids").split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(stringArray[i]);
                if (!"0".equals(nbIoTBean.getUsingStatus())) {
                    httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.delete_device_tip_1"));
                    this.findForward("/nbiotInfoPage?action=refreshNbIoT", true, httpServletRequest, httpServletResponse);
                    return;
                }
                try {
                    nbiotDeviceInfoGetter.deleteNbIoT(nbIoTBean.getPortID());
                    continue;
                }
                catch (ConfigurationException configurationException) {
                    this.log.error((Object)"\u5220\u9664\u914d\u7f6e\u5931\u8d25");
                    httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info"));
                    this.findForward("/nbiotInfoPage?action=refreshNbIoT", true, httpServletRequest, httpServletResponse);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.log.info((Object)"\u5220\u9664\u914d\u7f6e\u6210\u529f");
        List<LoraBean> list = LoRaDriver.getInstance().getAll();
        httpServletRequest.setAttribute("NbIoTs", list);
        this.findForward("/nbiotInfoPage?action=refreshNbIoT", true, httpServletRequest, httpServletResponse);
    }

    public void deleteBigDipperConfig(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, Exception {
        String[] stringArray = httpServletRequest.getParameter("ids").split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                BigDipperBean bigDipperBean = bdDeviceInfoGetter.findDeviceByPortID(stringArray[i]);
                if (!"0".equals(bigDipperBean.getUsingStatus())) {
                    httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.delete_device_tip_1"));
                    this.findForward("/bigdipperInfo?action=refreshBD", true, httpServletRequest, httpServletResponse);
                    return;
                }
                try {
                    bdDeviceInfoGetter.deleteConfiguration(bigDipperBean);
                    bdDeviceInfoGetter.deleteBD(bigDipperBean.getPortID());
                    continue;
                }
                catch (ConfigurationException configurationException) {
                    this.log.error((Object)"\u5220\u9664\u914d\u7f6e\u5931\u8d25");
                    httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info"));
                    this.findForward("/bigdipperInfo?action=refreshBD", true, httpServletRequest, httpServletResponse);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.log.info((Object)"\u5220\u9664\u914d\u7f6e\u6210\u529f");
        List<BigDipperBean> list = bdDeviceInfoGetter.getAll();
        httpServletRequest.setAttribute("BDs", list);
        this.findForward("/bigdipperInfo?action=refreshBD", true, httpServletRequest, httpServletResponse);
    }

    public void deletePhoneConfig(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, Exception {
        String[] stringArray = httpServletRequest.getParameter("ids").split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            PhoneInfoCache.getInstance().deletePhone(string);
        }
        List<SerialPhoneBean> list = PhoneInfoCache.getInstance().getAll();
        httpServletRequest.setAttribute("phones", list);
        this.findForward("phoneInfoPage.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void savePhoneConfiguration() throws ConfigurationException, CloneNotSupportedException {
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        List<SerialPhoneBean> list = PhoneInfoCache.getInstance().getAll();
        int n = list.size();
        String[] stringArray = null;
        for (int i = 0; i < n; ++i) {
            int n2 = i + 1;
            propertiesConfiguration.setProperty("phoneDevice." + i, (Object)("phone" + n2));
            list.get(i).setPhoneID("phone" + n2);
            stringArray = propertiesConfiguration.getStringArray("phoneDevice." + i);
            propertiesConfiguration.setProperty(stringArray[0] + ".no", (Object)list.get(i).getPhoneNo());
            propertiesConfiguration.setProperty(stringArray[0] + ".imei", (Object)list.get(i).getPhoneImei());
            propertiesConfiguration.setProperty(stringArray[0] + ".battery", (Object)list.get(i).getBattery());
            propertiesConfiguration.setProperty(stringArray[0] + ".charging", (Object)list.get(i).getChargingStatus());
            propertiesConfiguration.setProperty(stringArray[0] + ".device_info", (Object)list.get(i).getDeviceInfo());
            propertiesConfiguration.setProperty(stringArray[0] + ".using_status", (Object)list.get(i).getUsingStatus());
        }
        propertiesConfiguration.save();
    }

    public void regDeviceInit(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("id");
        String string2 = "";
        String string3 = ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_failed_to_get_imei");
        long l = System.currentTimeMillis();
        try {
            Object object;
            if (DeviceInfoCache.getInstance().findDevice(string).getGateway() == null || DeviceInfoCache.getInstance().get(string).getStatus() != AGatewayHelper.GatewayStatuses.STARTED) {
                Object object2;
                if (DeviceInfoCache.getInstance().get(string).getStatus() != AGatewayHelper.GatewayStatuses.STOPPED) {
                    httpServletRequest.setAttribute("message", (Object)(ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_reg_failure_info1") + DeviceInfoCache.getInstance().get(string).getDescription() + ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_reg_failure_info2")));
                    this.refresh(httpServletRequest, httpServletResponse);
                    return;
                }
                object = DeviceInfoCache.getInstance().findDevice(string);
                GetPortInfo getPortInfo = null;
                if ("IpModem".equals(((DeviceInfoCache.DeviceBean)object).getDeviceInfo().getModemFlag())) {
                    object2 = new NetDeviceBean();
                    ((NetDeviceBean)object2).setId("");
                    ((NetDeviceBean)object2).setDeviceIp(((DeviceInfoCache.DeviceBean)object).getDeviceInfo().getIpAddress());
                    ((NetDeviceBean)object2).setCheckingPort(((DeviceInfoCache.DeviceBean)object).getDeviceInfo().getIpPort());
                    getPortInfo = new GetIpModemInfo((NetDeviceBean)object2);
                } else {
                    object2 = new Properties();
                    ((Properties)object2).setProperty("portname", string);
                    ((Properties)object2).setProperty("baudrate", DeviceInfoCache.getInstance().get(string).getBaudrate() + "");
                    getPortInfo = new GetSerialPortInfoByGateway((Properties)object2);
                }
                ((GetPortInfo)getPortInfo).handler();
                string2 = getPortInfo.serialmodem.getSerialnum();
            } else {
                object = DeviceInfoCache.getInstance().findDevice(string).getGateway().sendCustomATCommand("ATI3\r");
                string2 = ((String)object).indexOf("Q2406B") != -1 ? DeviceInfoCache.getInstance().findDevice(string).getGateway().getSerialNumber1() : (((String)object).indexOf("MH5000-31") != -1 ? DeviceInfoCache.getInstance().findDevice(string).getGateway().getSerialNumber1() : DeviceInfoCache.getInstance().findDevice(string).getGateway().getSerialNumber());
                if (string2 == null || string2.indexOf("ERROR") >= 0 || string2.indexOf("N/A") >= 0) {
                    string2 = DeviceInfoCache.getInstance().findDevice(string).getGateway().getSerialNumber1();
                }
            }
            if (string2 == null || string2.indexOf("ERROR") >= 0 || string2.equals("") || string2.indexOf("N/A") >= 0) {
                string2 = "";
                httpServletRequest.setAttribute("error", (Object)string3);
            }
            this.log.info((Object)("\u6ce8\u518c\u8bbe\u5907" + string + "\u5e8f\u5217\u53f7" + string2));
        }
        catch (Exception exception) {
            this.log.error((Object)"\u83b7\u53d6\u8bbe\u5907\u6ce8\u518c\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)exception);
            string2 = "";
            httpServletRequest.setAttribute("error", (Object)string3);
        }
        long l2 = System.currentTimeMillis();
        double d = l2 - l;
        this.log.info((Object)("\u83b7\u53d6\u8bbe\u5907" + string + "\u5e8f\u5217\u53f7\u8017\u65f6" + (d /= 1000.0) + "\u79d2"));
        httpServletRequest.setAttribute("serialnum", (Object)string2);
        httpServletRequest.setAttribute("gatewayid", (Object)string);
        String string4 = NewAuth.getAuthorizeInfo(string2, "regcode");
        if (string4 == null || string4.indexOf("null") != -1) {
            string4 = "";
        }
        httpServletRequest.setAttribute("regcode", (Object)string4);
        if (string2.equals("") || string4.equals("")) {
            this.findForward("device-register.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        int n = NewAuth.checkDevRegCode(string2, string4);
        if (n == 1) {
            httpServletRequest.setAttribute("info", (Object)(NewAuth.getAuthorizeInfo(string2, "authorize_time") != null ? ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_reg_success_info") + NewAuth.getAuthorizeInfo(string2, "authorize_time") : ""));
        } else if (httpServletRequest.getAttribute("error") == null) {
            httpServletRequest.setAttribute("error", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_reg_failure_info3"));
        }
        this.findForward("device-register.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void regDevice(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Integer n = 0;
        try {
            String string = httpServletRequest.getParameter("serialnum");
            String string2 = httpServletRequest.getParameter("regcode");
            String string3 = httpServletRequest.getParameter("gatewayid");
            httpServletRequest.setAttribute("serialnum", (Object)string);
            httpServletRequest.setAttribute("regcode", (Object)string2);
            httpServletRequest.setAttribute("gatewayid", (Object)string3);
            int n2 = NewAuth.checkDevRegCode(string, string2);
            if (n2 == 1) {
                n = 1;
                httpServletRequest.setAttribute("message", (Object)"\u606d\u559c\u60a8\u8bbe\u5907\u6ce8\u518c\u6210\u529f\uff01");
                httpServletRequest.setAttribute("info", (Object)(NewAuth.getAuthorizeInfo(string, "authorize_time") != null ? "\u6388\u6743\u6709\u6548\uff0c\u6388\u6743\u65f6\u95f4\u4e3a\uff1a" + NewAuth.getAuthorizeInfo(string, "authorize_time") : ""));
                DeviceInfoCache.getInstance().get(string3).setValidate(true);
            } else {
                n = 0;
                if (n2 == 2) {
                    httpServletRequest.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u5df2\u8fc7\u671f\uff01");
                    httpServletRequest.setAttribute("error", (Object)"\u6388\u6743\u5df2\u8fc7\u671f");
                } else if (n2 == 3) {
                    httpServletRequest.setAttribute("message", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6ce8\u518c\u65e0\u6548\uff01");
                    httpServletRequest.setAttribute("error", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6388\u6743\u65e0\u6548");
                } else {
                    httpServletRequest.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u65e0\u6548\uff01");
                    httpServletRequest.setAttribute("error", (Object)"\u6388\u6743\u65e0\u6548");
                }
                DeviceInfoCache.getInstance().get(string3).setValidate(false);
            }
            NewAuth.saveAuthorize(string3, string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            httpServletRequest.setAttribute("serialnum", (Object)"");
            httpServletRequest.setAttribute("regcode", (Object)"");
            httpServletRequest.setAttribute("gatewayid", (Object)"");
            httpServletRequest.setAttribute("message", (Object)"\u6ce8\u518c\u8bbe\u5907\u5931\u8d25\uff01");
            httpServletRequest.setAttribute("error", (Object)"\u6ce8\u518c\u8bbe\u5907\u5931\u8d25\uff01");
        }
        this.findForward("device-register.jsp", true, httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDevice(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            if (DeviceInfoCache.getInstance().getStatus().equals((Object)DeviceInfoCache.CheckStatus.RUNNING)) {
                httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_check_info1"));
                httpServletRequest.setAttribute("devices", DeviceInfoCache.getInstance().getAll());
                this.findForward("device-config.jsp", true, httpServletRequest, httpServletResponse);
                return;
            }
            boolean bl = false;
            for (AGateway aGateway : Service.getInstance().getGateways()) {
                if (aGateway.getStatus() == AGatewayHelper.GatewayStatuses.STOPPED || aGateway.getStatus() == AGatewayHelper.GatewayStatuses.FAILURE || aGateway.getStatus() == AGatewayHelper.GatewayStatuses.NOPORT || aGateway.getStatus() == AGatewayHelper.GatewayStatuses.OCCUPY) continue;
                bl = true;
                break;
            }
            Iterator<AGateway> iterator = null;
            if (bl) {
                httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_check_info2"));
                httpServletRequest.setAttribute("devices", DeviceInfoCache.getInstance().getAll());
                this.findForward("device-config.jsp", true, httpServletRequest, httpServletResponse);
                return;
            }
            DeviceInfoCache.getInstance().updateDeviceInfo();
            httpServletRequest.setAttribute("devices", DeviceInfoCache.getInstance().getAll());
            httpServletRequest.setAttribute("needSaveConfig", (Object)new String());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            this.log.error((Object)"get device list failed", (Throwable)cloneNotSupportedException);
        }
        finally {
            DeviceInfoCache.getInstance().setStatus(DeviceInfoCache.CheckStatus.STOPPED);
        }
        this.findForward("device-config.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void checkDeviceLoRa(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (!LoRaDriver.getInstance().getUsingLoraList().isEmpty()) {
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_check_info2"));
            httpServletRequest.setAttribute("LoRas", LoRaDriver.getInstance().getAll());
            this.findForward("loraInfoPage.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        LoRaDriver.getInstance().deleteAll();
        try {
            LoRaDriver.getInstance().getLoRaDeviceInfo();
        }
        catch (Exception exception) {
            this.log.error((Object)"\u68c0\u6d4b\u8bbe\u5907\u51fa\u73b0\u5f02\u5e38\u3002\u3002\u3002", (Throwable)exception);
        }
        httpServletRequest.setAttribute("LoRas", LoRaDriver.getInstance().getAll());
        if (LoRaDriver.getInstance().getAll().isEmpty()) {
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.lora_check_tips1"));
        } else {
            httpServletRequest.setAttribute("needSaveConfig", (Object)new String());
        }
        this.findForward("loraInfoPage.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void checkDeviceNbIoT(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (!nbiotDeviceInfoGetter.getUsingNbIoTList().isEmpty()) {
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_check_info2"));
            httpServletRequest.setAttribute("NbIoTs", nbiotDeviceInfoGetter.getAll());
            this.findForward("nbiotInfoPage.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        try {
            nbiotDeviceInfoGetter.getNbIoTDeviceInfo();
        }
        catch (Exception exception) {
            this.log.error((Object)"\u68c0\u6d4b\u8bbe\u5907\u65f6\u51fa\u73b0\u5f02\u5e38\u3002\u3002\u3002", (Throwable)exception);
        }
        httpServletRequest.setAttribute("NbIoTs", nbiotDeviceInfoGetter.getAll());
        if (nbiotDeviceInfoGetter.getAll().isEmpty()) {
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.nbiot_check_tips1"));
        } else {
            httpServletRequest.setAttribute("needSaveConfig", (Object)new String());
        }
        this.findForward("nbiotInfoPage.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void checkDeviceBigDipper(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (!bdDeviceInfoGetter.getUsingBDList().isEmpty()) {
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_check_info2"));
            httpServletRequest.setAttribute("BDs", bdDeviceInfoGetter.getAll());
            this.findForward("bigdipperInfo.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        bdDeviceInfoGetter.deleteAll();
        try {
            bdDeviceInfoGetter.getBDDeviceInfo();
        }
        catch (Exception exception) {
            this.log.error((Object)"\u68c0\u6d4b\u8bbe\u5907\u51fa\u73b0\u5f02\u5e38\u4fe1\u606f");
        }
        httpServletRequest.setAttribute("BDs", bdDeviceInfoGetter.getAll());
        if (bdDeviceInfoGetter.getAll().isEmpty()) {
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.bd_check_tips1"));
        } else {
            httpServletRequest.setAttribute("needSaveConfig", (Object)new String());
        }
        this.findForward("bigdipperInfo.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void details(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException {
        this.device = DeviceInfoCache.getInstance().get(httpServletRequest.getParameter("id").trim());
        DbHelper dbHelper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
        String string = this.device.getCcid();
        AlertInfo alertInfo = dbHelper.getAlertInfoFromDB(string);
        this.device.setAlert(alertInfo);
        this.findForward("device-details.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void save(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            if (DeviceInfoCache.getInstance().get(this.device.getPort()).getStatus().equals((Object)AGatewayHelper.GatewayStatuses.FAILURE)) {
                httpServletRequest.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info1"));
                this.findForward("/device-details.jsp", true, httpServletRequest, httpServletResponse);
                return;
            }
            if (DeviceInfoCache.getInstance().get(this.device.getPort()).getStatus().equals((Object)AGatewayHelper.GatewayStatuses.OCCUPY)) {
                httpServletRequest.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info2"));
                this.findForward("/device-details.jsp", true, httpServletRequest, httpServletResponse);
                return;
            }
            if (DeviceInfoCache.getInstance().get(this.device.getPort()).getStatus().equals((Object)AGatewayHelper.GatewayStatuses.NOPORT)) {
                httpServletRequest.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info3"));
                this.findForward("/device-details.jsp", true, httpServletRequest, httpServletResponse);
                return;
            }
            int n = Integer.parseInt(httpServletRequest.getParameter("device.alert_number"));
            String string = httpServletRequest.getParameter("device.administrator_phone");
            int n2 = Integer.parseInt(httpServletRequest.getParameter("device.sent_number"));
            HttpRequestReader httpRequestReader = new HttpRequestReader(httpServletRequest, "gbk");
            String string2 = httpRequestReader.getParameter("device.AlertMsg");
            int n3 = Integer.parseInt(httpServletRequest.getParameter("device.MaxLimitNumber"));
            String string3 = this.device.getCcid();
            if (n3 < 0 || n < 0) {
                httpServletRequest.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info4"));
                this.findForward("/device-details.jsp", true, httpServletRequest, httpServletResponse);
                return;
            }
            if (n3 > n) {
                httpServletRequest.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info5"));
                this.findForward("/device-details.jsp", true, httpServletRequest, httpServletResponse);
                return;
            }
            if (n3 == 0 && n != 0) {
                httpServletRequest.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info6"));
                this.findForward("/device-details.jsp", true, httpServletRequest, httpServletResponse);
                return;
            }
            if ((string.trim().isEmpty() || string2.trim().isEmpty()) && (n3 != 0 || n != 0)) {
                httpServletRequest.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info7"));
                this.findForward("/device-details.jsp", true, httpServletRequest, httpServletResponse);
                return;
            }
            AlertInfo alertInfo = new AlertInfo(n, n2, string, string3, string2, n3);
            this.device.setAlert(alertInfo);
            DbHelper dbHelper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            dbHelper.AddAlertInfoToDB(alertInfo);
            this.saveToConfig(this.device);
            DeviceInfoCache.getInstance().put(this.device);
            if (DeviceInfoCache.getInstance().findDevice(this.device).getGateway() != null) {
                DeviceInfoCache.getInstance().findDevice(this.device).getGateway().setGatewayId(this.device.getGatewayID());
            }
        }
        catch (Exception exception) {
            this.log.error((Object)("\u4fdd\u5b58\u914d\u7f6e\u4fe1\u606f\u51fa\u9519\uff01 ---" + this.device.getGatewayID()), (Throwable)exception);
            httpServletRequest.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info8"));
            this.findForward("/device-details.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        httpServletRequest.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_success_info"));
        this.findForward("/device-details.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void start(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, CloneNotSupportedException {
        String[] stringArray = httpServletRequest.getParameter("ids").split(",");
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            SerialModemBean serialModemBean = DeviceInfoCache.getInstance().findDevice(stringArray[i]).getDeviceInfo();
            if (serialModemBean.getStatus() != AGatewayHelper.GatewayStatuses.FAILURE && serialModemBean.getStatus() != AGatewayHelper.GatewayStatuses.NOPORT && serialModemBean.getStatus() != AGatewayHelper.GatewayStatuses.OCCUPY && serialModemBean.getStatus() != AGatewayHelper.GatewayStatuses.STARTED && serialModemBean.getStatus() != AGatewayHelper.GatewayStatuses.RESTART && serialModemBean.getStatus() != AGatewayHelper.GatewayStatuses.STARTING) continue;
            bl = true;
            break;
        }
        if (bl) {
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_start_info"));
            httpServletRequest.setAttribute("devices", DeviceInfoCache.getInstance().getAll());
            this.findForward("device-config.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        llllIIIlIllIIlll llllIIIlIllIIlll2 = new llllIIIlIllIIlll(this);
        for (int i = 0; i < stringArray.length; ++i) {
            DeviceInfoCache.DeviceBean deviceBean = DeviceInfoCache.getInstance().findDevice(stringArray[i]);
            if (deviceBean == null || deviceBean.getDeviceInfo().getStatus() == AGatewayHelper.GatewayStatuses.STARTED || deviceBean.getDeviceInfo().getStatus() == AGatewayHelper.GatewayStatuses.STARTING || deviceBean.getDeviceInfo().getStatus() == AGatewayHelper.GatewayStatuses.RESTART) continue;
            llIIllIllIlIlIll llIIllIllIlIlIll2 = new llIIllIllIlIlIll(this, deviceBean);
            if (Service.getInstance().getSettings().CONCURRENT_GATEWAY_START) {
                llllIIIlIllIIlll2._$1(llIIllIllIlIlIll2);
                continue;
            }
            llIIllIllIlIlIll2.run();
        }
        if (Service.getInstance().getSettings().CONCURRENT_GATEWAY_START) {
            llllIIIlIllIIlll2._$1();
        }
        this.findForward("/device-config?action=refresh", true, httpServletRequest, httpServletResponse);
    }

    public void stop(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, CloneNotSupportedException {
        String[] stringArray = httpServletRequest.getParameter("ids").split(",");
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            SerialModemBean serialModemBean = DeviceInfoCache.getInstance().findDevice(stringArray[i]).getDeviceInfo();
            if (serialModemBean.getStatus() != AGatewayHelper.GatewayStatuses.FAILURE && serialModemBean.getStatus() != AGatewayHelper.GatewayStatuses.NOPORT && serialModemBean.getStatus() != AGatewayHelper.GatewayStatuses.OCCUPY && serialModemBean.getStatus() != AGatewayHelper.GatewayStatuses.STOPPED && serialModemBean.getStatus() != AGatewayHelper.GatewayStatuses.STOPPING) continue;
            bl = true;
            break;
        }
        if (bl) {
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_stop_info"));
            httpServletRequest.setAttribute("devices", DeviceInfoCache.getInstance().getAll());
            this.findForward("device-config.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        llllIIIlIllIIlll llllIIIlIllIIlll2 = new llllIIIlIllIIlll(this);
        for (int i = 0; i < stringArray.length; ++i) {
            DeviceInfoCache.DeviceBean deviceBean = DeviceInfoCache.getInstance().findDevice(stringArray[i]);
            if (deviceBean == null || deviceBean.getDeviceInfo().getStatus() == AGatewayHelper.GatewayStatuses.STOPPED || deviceBean.getDeviceInfo().getStatus() == AGatewayHelper.GatewayStatuses.STOPPING) continue;
            llllIIIlIllIIlll2._$1(new IIllIlIlIIlIIlII(this, deviceBean));
        }
        llllIIIlIllIIlll2._$1();
        this.findForward("/device-config?action=refresh", true, httpServletRequest, httpServletResponse);
    }

    public void deleteConfig(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        DeviceInfoCache.DeviceBean deviceBean;
        int n;
        String[] stringArray = httpServletRequest.getParameter("ids").split(",");
        for (n = 0; n < stringArray.length; ++n) {
            deviceBean = DeviceInfoCache.getInstance().findDevice(stringArray[n]);
            if (deviceBean == null || deviceBean.getDeviceInfo().getStatus() != AGatewayHelper.GatewayStatuses.STARTED && deviceBean.getDeviceInfo().getStatus() != AGatewayHelper.GatewayStatuses.STARTING) continue;
            httpServletRequest.setAttribute("message", (Object)"\u9009\u4e2d\u7684\u8bbe\u5907\u5305\u542b\u5df2\u542f\u52a8\u6216\u6b63\u5728\u542f\u52a8\u7684\u8bbe\u5907\uff0c\u8bf7\u5c06\u5176\u505c\u6b62\uff0c\u518d\u505a\u5220\u9664\u5904\u7406");
            this.findForward("/device-config?action=refresh", true, httpServletRequest, httpServletResponse);
            return;
        }
        for (n = stringArray.length - 1; n > -1; --n) {
            deviceBean = DeviceInfoCache.getInstance().findDevice(stringArray[n]);
            if (deviceBean == null || deviceBean.getDeviceInfo().getStatus() == AGatewayHelper.GatewayStatuses.STARTED || deviceBean.getDeviceInfo().getStatus() == AGatewayHelper.GatewayStatuses.STARTING) continue;
            try {
                this.deleteConfiguration(deviceBean.getDeviceInfo());
                this.log.info((Object)("\u5220\u9664\u8bbe\u5907[" + deviceBean.getDeviceInfo().getGatewayID() + "]\u4fe1\u606f\u6210\u529f"));
            }
            catch (Exception exception) {
                this.log.error((Object)("\u5220\u9664\u8bbe\u5907[" + deviceBean.getDeviceInfo().getGatewayID() + "]\u4fe1\u606f\u5931\u8d25"), (Throwable)exception);
            }
            DeviceInfoCache.getInstance().remove(deviceBean);
            Service.getInstance().getGateways().remove(deviceBean.getGateway());
        }
        this.findForward("/device-config?action=refresh", true, httpServletRequest, httpServletResponse);
    }

    public void saveConfig(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String[] stringArray = httpServletRequest.getParameter("ids").split(",");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            DeviceInfoCache.DeviceBean deviceBean = DeviceInfoCache.getInstance().findDevice(stringArray[i]);
            if (deviceBean == null) continue;
            try {
                if (deviceBean.getDeviceInfo().getStatus().equals((Object)AGatewayHelper.GatewayStatuses.FAILURE) || deviceBean.getDeviceInfo().getStatus().equals((Object)AGatewayHelper.GatewayStatuses.NOPORT) || deviceBean.getDeviceInfo().getStatus().equals((Object)AGatewayHelper.GatewayStatuses.OCCUPY)) {
                    arrayList.add(deviceBean.getDeviceInfo().getPort());
                    continue;
                }
                this.saveToConfig(deviceBean.getDeviceInfo());
                if (deviceBean.getGateway() == null) continue;
                deviceBean.getGateway().setGatewayId(deviceBean.getDeviceInfo().getGatewayID());
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.log.info((Object)"\u4fdd\u5b58\u914d\u7f6e\u5931\u8d25");
                httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info"));
            }
        }
        this.log.info((Object)"\u4fdd\u5b58\u914d\u7f6e\u6210\u529f");
        if (arrayList.size() == 0) {
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_success_info1"));
        } else {
            httpServletRequest.setAttribute("message", (Object)(ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_success_info2") + arrayList + ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_success_info3")));
        }
        this.findForward("/device-config?action=refresh", true, httpServletRequest, httpServletResponse);
    }

    protected void saveToConfig(SerialModemBean serialModemBean) throws Exception {
        int n = 0;
        boolean bl = false;
        if ("IpModem".equals(serialModemBean.getModemFlag())) {
            bl = true;
        }
        boolean bl2 = false;
        Configuration configuration = JDSMSServer.getInstance().getProperties().subset("gateway");
        Iterator iterator = configuration.getKeys();
        while (iterator.hasNext()) {
            String string = configuration.getString((String)iterator.next());
            if (!string.startsWith(serialModemBean.getGatewayID())) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            while (n < 64) {
                if (JDSMSServer.getInstance().getProperties().getString("gateway." + n, "").length() == 0) {
                    serialModemBean.setGatewayID("modem" + (n + 1));
                    break;
                }
                ++n;
            }
            if (bl) {
                JDSMSServer.getInstance().getProperties().setProperty("gateway." + n, (Object)(serialModemBean.getGatewayID() + " ,IPModem"));
            } else {
                JDSMSServer.getInstance().getProperties().setProperty("gateway." + n, (Object)(serialModemBean.getGatewayID() + " ,SerialModem"));
            }
        }
        if (bl) {
            JDSMSServer.getInstance().getProperties().setProperty(serialModemBean.getGatewayID() + ".ip", (Object)serialModemBean.getIpAddress());
            JDSMSServer.getInstance().getProperties().setProperty(serialModemBean.getGatewayID() + ".port", (Object)serialModemBean.getIpPort());
            JDSMSServer.getInstance().getProperties().setProperty(serialModemBean.getGatewayID() + ".ipprotocol", (Object)"binary");
        } else {
            JDSMSServer.getInstance().getProperties().setProperty(serialModemBean.getGatewayID() + ".port", (Object)serialModemBean.getPort());
        }
        JDSMSServer.getInstance().getProperties().setProperty(serialModemBean.getGatewayID() + ".baudrate", (Object)(serialModemBean.getBaudrate() + ""));
        JDSMSServer.getInstance().getProperties().setProperty(serialModemBean.getGatewayID() + ".manufacturer", (Object)serialModemBean.getManufacturer());
        JDSMSServer.getInstance().getProperties().setProperty(serialModemBean.getGatewayID() + ".model", (Object)serialModemBean.getModel());
        JDSMSServer.getInstance().getProperties().setProperty(serialModemBean.getGatewayID() + ".protocol", (Object)serialModemBean.getProtocol().name());
        JDSMSServer.getInstance().getProperties().setProperty(serialModemBean.getGatewayID() + ".pin", (Object)serialModemBean.getPin());
        JDSMSServer.getInstance().getProperties().setProperty(serialModemBean.getGatewayID() + ".inbound", (Object)serialModemBean.getInbound());
        JDSMSServer.getInstance().getProperties().setProperty(serialModemBean.getGatewayID() + ".outbound", (Object)serialModemBean.getOutbound());
        JDSMSServer.getInstance().getProperties().setProperty(serialModemBean.getGatewayID() + ".smsc_number", (Object)serialModemBean.getSmsc_number());
        JDSMSServer.getInstance().getProperties().setProperty(serialModemBean.getGatewayID() + ".init_string", (Object)serialModemBean.getInit_string());
        JDSMSServer.getInstance().getProperties().save();
    }

    public void deleteConfiguration(SerialModemBean serialModemBean) throws ConfigurationException {
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        boolean bl = false;
        int n = 0;
        for (n = 0; n < 64; ++n) {
            Object[] objectArray = propertiesConfiguration.getStringArray("gateway." + n);
            if (ArrayUtils.isEmpty((Object[])objectArray) || !((String)objectArray[0]).equals(serialModemBean.getGatewayID())) continue;
            bl = true;
            propertiesConfiguration.clearProperty("gateway." + n);
            break;
        }
        if (bl) {
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".ip");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".ipprotocol");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".port");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".baudrate");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".manufacturer");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".model");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".protocol");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".pin");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".inbound");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".outbound");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".smsc_number");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".init_string");
        }
        propertiesConfiguration.save();
    }

    public void addNetDevice(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Object object;
        httpServletResponse.setContentType("text/xml;charset=UTF-8");
        String string = "0";
        String string2 = "\u6210\u529f";
        NetDeviceBean netDeviceBean = new NetDeviceBean();
        netDeviceBean.setDeviceIp(this.deviceIp);
        netDeviceBean.setStartPort(this.startPort);
        netDeviceBean.setEndPort(this.endPort);
        try {
            int n = 0;
            boolean bl = false;
            object = JDSMSServer.getInstance().getProperties().subset("netdevice");
            Iterator iterator = object.getKeys();
            while (iterator.hasNext()) {
                String[] stringArray = object.getStringArray((String)iterator.next());
                if (!stringArray[1].startsWith(netDeviceBean.getDeviceIp())) continue;
                bl = true;
                netDeviceBean.setId("device" + (n + 1));
                break;
            }
            if (!bl) {
                while (n < 64) {
                    if (JDSMSServer.getInstance().getProperties().getString("netdevice." + n, "").length() == 0) {
                        netDeviceBean.setId("device" + (n + 1));
                        break;
                    }
                    ++n;
                }
                JDSMSServer.getInstance().getProperties().setProperty("netdevice." + n, (Object)(netDeviceBean.getId() + "," + netDeviceBean.getDeviceIp()));
            }
            JDSMSServer.getInstance().getProperties().setProperty(netDeviceBean.getId() + ".ip", (Object)netDeviceBean.getDeviceIp());
            JDSMSServer.getInstance().getProperties().setProperty(netDeviceBean.getId() + ".startPort", (Object)netDeviceBean.getStartPort());
            JDSMSServer.getInstance().getProperties().setProperty(netDeviceBean.getId() + ".endPort", (Object)netDeviceBean.getEndPort());
            JDSMSServer.getInstance().getProperties().setProperty(netDeviceBean.getId() + ".ip", (Object)netDeviceBean.getDeviceIp());
            JDSMSServer.getInstance().getProperties().save();
        }
        catch (Exception exception) {
            string = "-1";
            string2 = "\u4fdd\u5b58\u914d\u7f6e\u4fe1\u606f\u5931\u8d25";
            this.log.error((Object)("\u4fdd\u5b58\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u9519\u8bef: " + exception.getMessage()));
        }
        Document document = DocumentHelper.createDocument();
        Element element = document.addElement("result");
        element.addElement("error").addText(string);
        element.addElement("errorDesc").addText(string2);
        object = document.asXML();
        try {
            httpServletResponse.getWriter().print((String)object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void delNetDevice(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Object object;
        httpServletResponse.setContentType("text/xml;charset=UTF-8");
        String string = "0";
        String string2 = "\u6210\u529f";
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        try {
            boolean bl = false;
            object = "";
            int n = 0;
            for (n = 0; n < 64; ++n) {
                Object[] objectArray = propertiesConfiguration.getStringArray("netdevice." + n);
                if (ArrayUtils.isEmpty((Object[])objectArray) || !((String)objectArray[1]).startsWith(this.deviceIp)) continue;
                bl = true;
                object = objectArray[0];
                propertiesConfiguration.clearProperty("netdevice." + n);
                break;
            }
            if (bl) {
                propertiesConfiguration.clearProperty((String)object + ".ip");
                propertiesConfiguration.clearProperty((String)object + ".startPort");
                propertiesConfiguration.clearProperty((String)object + ".endPort");
            }
            propertiesConfiguration.save();
        }
        catch (Exception exception) {
            string = "-1";
            string2 = "\u5220\u9664\u914d\u7f6e\u4fe1\u606f\u5931\u8d25";
            this.log.error((Object)("\u5220\u9664\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u9519\u8bef: " + exception.getMessage()));
        }
        Document document = DocumentHelper.createDocument();
        object = document.addElement("result");
        object.addElement("error").addText(string);
        object.addElement("errorDesc").addText(string2);
        String string3 = document.asXML();
        try {
            httpServletResponse.getWriter().print(string3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void saveLoraConfig(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String[] stringArray = httpServletRequest.getParameter("ids").split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                LoraBean loraBean = LoRaDriver.getInstance().findDeviceByPortID(stringArray[i]);
                if (loraBean == null) continue;
                try {
                    LoRaDriver.getInstance().saveConfigInfo(loraBean);
                    continue;
                }
                catch (ConfigurationException configurationException) {
                    this.log.error((Object)"\u4fdd\u5b58\u914d\u7f6e\u5931\u8d25");
                    httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info"));
                    this.findForward("/loraInfoPage?action=refreshLoRa", true, httpServletRequest, httpServletResponse);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.log.info((Object)"\u4fdd\u5b58\u914d\u7f6e\u6210\u529f");
        httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_success_info1"));
        this.findForward("/loraInfoPage?action=refreshLoRa", true, httpServletRequest, httpServletResponse);
    }

    public void saveNbIoTConfig(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String[] stringArray = httpServletRequest.getParameter("ids").split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(stringArray[i]);
                if (nbIoTBean == null) continue;
                try {
                    nbiotDeviceInfoGetter.saveConfigInfo(nbIoTBean);
                    continue;
                }
                catch (ConfigurationException configurationException) {
                    this.log.error((Object)"\u4fdd\u5b58\u914d\u7f6e\u5931\u8d25");
                    httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info"));
                    this.findForward("/nbiotInfoPage?action=refreshNbIoT", true, httpServletRequest, httpServletResponse);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.log.info((Object)"\u4fdd\u5b58\u914d\u7f6e\u6210\u529f");
        httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_success_info1"));
        this.findForward("/nbiotInfoPage?action=refreshNbIoT", true, httpServletRequest, httpServletResponse);
    }

    public void saveBigDipperConfig(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String[] stringArray = httpServletRequest.getParameter("ids").split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                BigDipperBean bigDipperBean = bdDeviceInfoGetter.findDeviceByPortID(stringArray[i]);
                if (bigDipperBean == null) continue;
                try {
                    bdDeviceInfoGetter.saveConfigInfo(bigDipperBean);
                    continue;
                }
                catch (ConfigurationException configurationException) {
                    this.log.error((Object)"\u4fdd\u5b58\u914d\u7f6e\u5931\u8d25");
                    httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info"));
                    this.findForward("/bigdipperInfo?action=refreshBD", true, httpServletRequest, httpServletResponse);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.log.info((Object)"\u4fdd\u5b58\u914d\u7f6e\u6210\u529f");
        httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_success_info1"));
        this.findForward("/bigdipperInfo?action=refreshBD", true, httpServletRequest, httpServletResponse);
    }

    public void regLoraDeviceInit(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        String string = httpServletRequest.getParameter("id");
        boolean bl = LoRaDriver.getInstance().checkStartLoras(string);
        if (bl) {
            httpServletRequest.setAttribute("LoRas", LoRaDriver.getInstance().getAll());
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.lora_register_tips1"));
            this.findForward("loraInfoPage.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        String string2 = LoRaDriver.getInstance().findDeviceByPortID(string).getSerialNumber();
        if (string2 == null || string2.equals("")) {
            object = LoRaDriver.getInstance().getSerialNumberList();
            LoRaDriver.getInstance().getSerialNumber(string, (List<String>)object);
        }
        httpServletRequest.setAttribute("serialnum", (Object)string2);
        httpServletRequest.setAttribute("gatewayid", (Object)string);
        object = NewAuth.getAuthorizeInfo(string2, "regcode");
        if (object == null || ((String)object).indexOf("null") != -1) {
            object = "";
        }
        if (string2.equals("")) {
            httpServletRequest.setAttribute("LoRas", LoRaDriver.getInstance().getAll());
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.lora_register_tips2"));
            this.findForward("loraInfoPage.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        httpServletRequest.setAttribute("regcode", object);
        this.findForward("lora-register.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void regNbIoTDeviceInit(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("id");
        String string2 = nbiotDeviceInfoGetter.getSerialNumber(string);
        httpServletRequest.setAttribute("serialnum", (Object)string2);
        httpServletRequest.setAttribute("gatewayid", (Object)string);
        String string3 = NewAuth.getAuthorizeInfo(string2, "regcode");
        if (string3 == null || string3.indexOf("null") != -1) {
            string3 = "";
        }
        if (string2.equals("")) {
            httpServletRequest.setAttribute("NbIoTs", nbiotDeviceInfoGetter.getAll());
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.nbiot_register_tips1"));
            this.findForward("nbiotInfoPage.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        httpServletRequest.setAttribute("regcode", (Object)string3);
        this.findForward("nbiot-register.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void regBigDipperDeviceInit(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("id");
        String string2 = bdDeviceInfoGetter.findDeviceByPortID(string).getSerialNumber();
        httpServletRequest.setAttribute("serialnum", (Object)string2);
        httpServletRequest.setAttribute("gatewayid", (Object)string);
        String string3 = NewAuth.getAuthorizeInfo(string2, "regcode");
        if (string3 == null || string3.indexOf("null") != -1) {
            string3 = "";
        }
        if (string2.equals("")) {
            httpServletRequest.setAttribute("BDs", bdDeviceInfoGetter.getAll());
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.bd_register_tips1"));
            this.findForward("bigdipperInfo.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        httpServletRequest.setAttribute("regcode", (Object)string3);
        this.findForward("bigdipper-register.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void regLoraDevice(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Integer n = 0;
        try {
            String string = httpServletRequest.getParameter("serialnum");
            String string2 = httpServletRequest.getParameter("regcode");
            String string3 = httpServletRequest.getParameter("gatewayid");
            httpServletRequest.setAttribute("serialnum", (Object)string);
            httpServletRequest.setAttribute("regcode", (Object)string2);
            httpServletRequest.setAttribute("gatewayid", (Object)string3);
            int n2 = NewAuth.checkDevRegCode(string, string2);
            if (n2 == 1) {
                n = 1;
                httpServletRequest.setAttribute("message", (Object)"\u606d\u559c\u60a8\u8bbe\u5907\u6ce8\u518c\u6210\u529f\uff01");
                httpServletRequest.setAttribute("info", (Object)(NewAuth.getAuthorizeInfo(string, "authorize_time") != null ? "\u6388\u6743\u6709\u6548\uff0c\u6388\u6743\u65f6\u95f4\u4e3a\uff1a" + NewAuth.getAuthorizeInfo(string, "authorize_time") : ""));
                LoRaDriver.getInstance().getPointedSerialLoraBean(string3).setValidate(true);
            } else {
                n = 0;
                if (n2 == 2) {
                    httpServletRequest.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u5df2\u8fc7\u671f\uff01");
                    httpServletRequest.setAttribute("error", (Object)"\u6388\u6743\u5df2\u8fc7\u671f");
                } else if (n2 == 3) {
                    httpServletRequest.setAttribute("message", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6ce8\u518c\u65e0\u6548\uff01");
                    httpServletRequest.setAttribute("error", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6388\u6743\u65e0\u6548");
                } else {
                    httpServletRequest.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u65e0\u6548\uff01");
                    httpServletRequest.setAttribute("error", (Object)"\u6388\u6743\u65e0\u6548");
                }
                LoRaDriver.getInstance().getPointedSerialLoraBean(string3).setValidate(false);
            }
            NewAuth.saveAuthorize(string3, string, string2);
        }
        catch (Exception exception) {
            httpServletRequest.setAttribute("serialnum", (Object)"");
            httpServletRequest.setAttribute("regcode", (Object)"");
            httpServletRequest.setAttribute("gatewayid", (Object)"");
            httpServletRequest.setAttribute("message", (Object)"\u6ce8\u518c\u8bbe\u5907\u5931\u8d25\uff01");
        }
        this.findForward("lora-register.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void regNbIoTDevice(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Integer n = 0;
        String string = httpServletRequest.getParameter("gatewayid");
        String string2 = httpServletRequest.getParameter("regcode");
        String string3 = httpServletRequest.getParameter("serialnum").toUpperCase();
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(string);
        if (nbIoTBean == null) {
            httpServletRequest.setAttribute("message", (Object)"\u6388\u6743\u65f6\u51fa\u73b0\u5f02\u5e38\uff01");
            this.findForward("nbiot-register.jsp", true, httpServletRequest, httpServletResponse);
            return;
        }
        if ("JD-VITUAL-NBIOT-DEVICE".equals(nbIoTBean.getDeviceType())) {
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            block35: {
                Object object;
                string9 = httpServletRequest.getParameter("telephone");
                string8 = httpServletRequest.getParameter("userId");
                string7 = httpServletRequest.getParameter("company");
                if (!string3.equals(nbIoTBean.getSerialNumber())) {
                    if (8 != string3.length() || !string3.matches("[0-9a-zA-Z]+")) {
                        httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_input_tips2"));
                        httpServletRequest.setAttribute("serialnum", (Object)string3);
                        httpServletRequest.setAttribute("regcode", (Object)string2);
                        httpServletRequest.setAttribute("gatewayid", (Object)string);
                        httpServletRequest.setAttribute("userId", (Object)string8);
                        httpServletRequest.setAttribute("company", (Object)string7);
                        httpServletRequest.setAttribute("telephone", (Object)string9);
                        this.findForward("nbiot-register.jsp", true, httpServletRequest, httpServletResponse);
                        return;
                    }
                    object = nbIoTBean.getSerialNumber();
                    nbIoTBean.setSerialNumber(string3);
                    nbIoTBean.setCommunicationID(string3);
                    try {
                        nbiotDeviceInfoGetter.saveConfigInfo(nbIoTBean);
                    }
                    catch (ConfigurationException configurationException) {
                        nbIoTBean.setSerialNumber((String)object);
                        nbIoTBean.setCommunicationID((String)object);
                        httpServletRequest.setAttribute("message", (Object)("\u901a\u4fe1ID" + string3 + "\u4fdd\u5b58\u5931\u8d25\uff01"));
                        httpServletRequest.setAttribute("serialnum", (Object)string3);
                        httpServletRequest.setAttribute("regcode", (Object)string2);
                        httpServletRequest.setAttribute("gatewayid", (Object)string);
                        httpServletRequest.setAttribute("userId", (Object)string8);
                        httpServletRequest.setAttribute("company", (Object)string7);
                        httpServletRequest.setAttribute("telephone", (Object)string9);
                        this.findForward("nbiot-register.jsp", true, httpServletRequest, httpServletResponse);
                        return;
                    }
                    try {
                        if (NewAuth.getAuthorizeInfo(string3, "authorize_time") != null) {
                            nbIoTBean.setValidate(true);
                            this.findForward("nbiotInfoPage?action=refreshNbIoT", false, httpServletRequest, httpServletResponse);
                            return;
                        }
                    }
                    catch (Exception exception) {
                        this.log.error((Object)("\u83b7\u53d6\u8bbe\u5907" + nbIoTBean.getGatewayID() + "\u672c\u5730\u6388\u6743\u4fe1\u606f\u51fa\u9519\uff01"), (Throwable)exception);
                    }
                } else if (nbIoTBean.isValidate()) {
                    httpServletRequest.setAttribute("message", (Object)"\u8bbe\u5907\u5df2\u7ecf\u6ce8\u518c\u6210\u529f\uff01");
                    httpServletRequest.setAttribute("serialnum", (Object)string3);
                    httpServletRequest.setAttribute("regcode", (Object)string2);
                    httpServletRequest.setAttribute("gatewayid", (Object)string);
                    httpServletRequest.setAttribute("userId", (Object)string8);
                    httpServletRequest.setAttribute("company", (Object)string7);
                    httpServletRequest.setAttribute("telephone", (Object)string9);
                    this.findForward("nbiot-register.jsp", true, httpServletRequest, httpServletResponse);
                    return;
                }
                object = new AuthorizeInfo();
                ((AuthorizeInfo)object).setSerialNum(string3);
                ((AuthorizeInfo)object).setRegCode(string2);
                ((AuthorizeInfo)object).setGatewayId(nbiotDeviceInfoGetter.findDeviceByPortID(string).getGatewayID());
                ((AuthorizeInfo)object).setTelephone(string9);
                ((AuthorizeInfo)object).setUseId(string8);
                ((AuthorizeInfo)object).setCompany(string7);
                string6 = NbIoTAuthorize.generatePara((AuthorizeInfo)object);
                string5 = NbIoTAuthorize.generateToken();
                if (!Utils.isEmptyStr(string7)) {
                    try {
                        string4 = NbIoTAuthorize.getAuthorizeInfoFromServer(string5, "authorizeSucess", string6);
                        if ("OK".equals(string4)) {
                            int n2 = NewAuth.checkDevRegCode(string3, string2);
                            if (n2 == 1) {
                                n = 1;
                                httpServletRequest.setAttribute("message", (Object)"\u606d\u559c\u60a8\u8bbe\u5907\u6ce8\u518c\u6210\u529f\uff01");
                                httpServletRequest.setAttribute("info", (Object)(NewAuth.getAuthorizeInfo(string3, "authorize_time") != null ? "\u6388\u6743\u6709\u6548\uff0c\u6388\u6743\u65f6\u95f4\u4e3a\uff1a" + NewAuth.getAuthorizeInfo(string3, "authorize_time") : ""));
                                nbiotDeviceInfoGetter.findDeviceByPortID(string).setValidate(true);
                            } else {
                                n = 0;
                                if (n2 == 2) {
                                    httpServletRequest.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u5df2\u8fc7\u671f\uff01");
                                    httpServletRequest.setAttribute("error", (Object)"\u6388\u6743\u5df2\u8fc7\u671f");
                                } else if (n2 == 3) {
                                    httpServletRequest.setAttribute("message", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6ce8\u518c\u65e0\u6548\uff01");
                                    httpServletRequest.setAttribute("error", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6388\u6743\u65e0\u6548");
                                } else {
                                    httpServletRequest.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u65e0\u6548\uff01");
                                    httpServletRequest.setAttribute("error", (Object)"\u6388\u6743\u65e0\u6548");
                                }
                                nbiotDeviceInfoGetter.findDeviceByPortID(string).setValidate(false);
                            }
                            break block35;
                        }
                        httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_input_tips3"));
                        this.log.error((Object)("\u6388\u6743\u670d\u52a1\u5668\u54cd\u5e94\uff1a" + string4));
                        n = 0;
                    }
                    catch (Exception exception) {
                        httpServletRequest.setAttribute("serialnum", (Object)"");
                        httpServletRequest.setAttribute("regcode", (Object)"");
                        httpServletRequest.setAttribute("gatewayid", (Object)"");
                        httpServletRequest.setAttribute("message", (Object)"\u6ce8\u518c\u8bbe\u5907\u5931\u8d25\uff01");
                    }
                } else {
                    httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_input_tips1"));
                    n = 0;
                }
            }
            if (n == 0 && !"OK".equals(string4 = NbIoTAuthorize.getAuthorizeInfoFromServer(string5, "cancellSucess", string6))) {
                this.log.error((Object)"\u8bbe\u5907\u6388\u6743\u5f02\u5e38...responseFromServer");
            }
            httpServletRequest.setAttribute("serialnum", (Object)string3);
            httpServletRequest.setAttribute("regcode", (Object)string2);
            httpServletRequest.setAttribute("gatewayid", (Object)string);
            httpServletRequest.setAttribute("userId", (Object)string8);
            httpServletRequest.setAttribute("company", (Object)string7);
            httpServletRequest.setAttribute("telephone", (Object)string9);
        } else {
            try {
                int n3 = NewAuth.checkDevRegCode(string3, string2);
                if (n3 == 1) {
                    n = 1;
                    httpServletRequest.setAttribute("message", (Object)"\u606d\u559c\u60a8\u8bbe\u5907\u6ce8\u518c\u6210\u529f\uff01");
                    httpServletRequest.setAttribute("info", (Object)(NewAuth.getAuthorizeInfo(string3, "authorize_time") != null ? "\u6388\u6743\u6709\u6548\uff0c\u6388\u6743\u65f6\u95f4\u4e3a\uff1a" + NewAuth.getAuthorizeInfo(string3, "authorize_time") : ""));
                    nbIoTBean.setValidate(true);
                } else {
                    n = 0;
                    if (n3 == 2) {
                        httpServletRequest.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u5df2\u8fc7\u671f\uff01");
                        httpServletRequest.setAttribute("error", (Object)"\u6388\u6743\u5df2\u8fc7\u671f");
                    } else if (n3 == 3) {
                        httpServletRequest.setAttribute("message", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6ce8\u518c\u65e0\u6548\uff01");
                        httpServletRequest.setAttribute("error", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6388\u6743\u65e0\u6548");
                    } else {
                        httpServletRequest.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u65e0\u6548\uff01");
                        httpServletRequest.setAttribute("error", (Object)"\u6388\u6743\u65e0\u6548");
                    }
                    nbIoTBean.setValidate(false);
                }
                httpServletRequest.setAttribute("serialnum", (Object)string3);
                httpServletRequest.setAttribute("regcode", (Object)string2);
            }
            catch (Exception exception) {
                httpServletRequest.setAttribute("serialnum", (Object)string3);
                httpServletRequest.setAttribute("regcode", (Object)string2);
            }
        }
        try {
            NewAuth.saveAuthorize(string, string3, string2);
        }
        catch (Exception exception) {
            this.log.error((Object)"\u6388\u6743\u5931\u8d252\uff01", (Throwable)exception);
        }
        this.findForward("nbiot-register.jsp", true, httpServletRequest, httpServletResponse);
    }

    public void cancellNbIoTDevice(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("ids");
        String string2 = httpServletRequest.getParameter("serialnum");
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(string);
        if (!nbIoTBean.getSerialNumber().equals(string2)) {
            this.log.error((Object)("\u8bbe\u5907" + nbIoTBean.getGatewayID() + "\u4fe1\u606f\u5f02\u5e38\uff01"));
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.nbiot_authorize_tips3"));
        }
        if (!nbIoTBean.isValidate()) {
            httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.nbiot_authorize_tips1"));
        } else {
            AuthorizeInfo authorizeInfo = new AuthorizeInfo();
            authorizeInfo.setGatewayId(nbIoTBean.getGatewayID());
            authorizeInfo.setSerialNum(string2);
            String string3 = NbIoTAuthorize.generatePara(authorizeInfo);
            String string4 = NbIoTAuthorize.generateToken();
            String string5 = NbIoTAuthorize.getAuthorizeInfoFromServer(string4, "cancellSucess", string3);
            if ("OK".equals(string5)) {
                httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.nbiot_authorize_tips2"));
                nbIoTBean.setValidate(false);
            } else {
                httpServletRequest.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.nbiot_authorize_tips3"));
                this.log.error((Object)("\u6388\u6743\u670d\u52a1\u5668\u54cd\u5e94\uff1a" + string5));
            }
        }
        this.findForward("nbiotInfoPage?action=refreshNbIoT", false, httpServletRequest, httpServletResponse);
    }

    public void regBigDipperDevice(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Integer n = 0;
        try {
            String string = httpServletRequest.getParameter("serialnum");
            String string2 = httpServletRequest.getParameter("regcode");
            String string3 = httpServletRequest.getParameter("gatewayid");
            httpServletRequest.setAttribute("serialnum", (Object)string);
            httpServletRequest.setAttribute("regcode", (Object)string2);
            httpServletRequest.setAttribute("gatewayid", (Object)string3);
            int n2 = NewAuth.checkDevRegCode(string, string2);
            if (n2 == 1) {
                n = 1;
                httpServletRequest.setAttribute("message", (Object)"\u606d\u559c\u60a8\u8bbe\u5907\u6ce8\u518c\u6210\u529f\uff01");
                httpServletRequest.setAttribute("info", (Object)(NewAuth.getAuthorizeInfo(string, "authorize_time") != null ? "\u6388\u6743\u6709\u6548\uff0c\u6388\u6743\u65f6\u95f4\u4e3a\uff1a" + NewAuth.getAuthorizeInfo(string, "authorize_time") : ""));
                bdDeviceInfoGetter.findDeviceByPortID(string3).setValidate(true);
            } else {
                n = 0;
                if (n2 == 2) {
                    httpServletRequest.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u5df2\u8fc7\u671f\uff01");
                    httpServletRequest.setAttribute("error", (Object)"\u6388\u6743\u5df2\u8fc7\u671f");
                } else if (n2 == 3) {
                    httpServletRequest.setAttribute("message", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6ce8\u518c\u65e0\u6548\uff01");
                    httpServletRequest.setAttribute("error", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6388\u6743\u65e0\u6548");
                } else {
                    httpServletRequest.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u65e0\u6548\uff01");
                    httpServletRequest.setAttribute("error", (Object)"\u6388\u6743\u65e0\u6548");
                }
                bdDeviceInfoGetter.findDeviceByPortID(string3).setValidate(false);
            }
            NewAuth.saveAuthorize(string3, string, string2);
        }
        catch (Exception exception) {
            httpServletRequest.setAttribute("serialnum", (Object)"");
            httpServletRequest.setAttribute("regcode", (Object)"");
            httpServletRequest.setAttribute("gatewayid", (Object)"");
            httpServletRequest.setAttribute("message", (Object)"\u6ce8\u518c\u8bbe\u5907\u5931\u8d25\uff01");
        }
        this.findForward("bigdipper-register.jsp", true, httpServletRequest, httpServletResponse);
    }
}

