/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.driver.nbiotDriver;

import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.otherModem.bean.NbIoTBean;
import cn.sendsms.otherModem.common.Utils;
import cn.sendsms.otherModem.driver.ModemDriver;
import cn.sendsms.otherModem.driver.nbiotDriver.NbIoTDriver;
import cn.sendsms.otherModem.thread.WatchDog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jssc.SerialPort;
import jssc.SerialPortException;
import org.apache.commons.configuration.PropertiesConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class M5310ANbIoTDriver
extends NbIoTDriver {
    private static final M5310ANbIoTDriver _$2 = new M5310ANbIoTDriver();

    public static final M5310ANbIoTDriver getInstance() {
        return _$2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSignal(SerialPort serialPort) {
        String string = "99,99";
        boolean bl = false;
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            if (!M5310ANbIoTDriver.serialportConnected(serialPort)) {
                Utils.closePort(serialPort);
                log.info((Object)("\u6b63\u5728\u5c1d\u8bd5\u6253\u5f00\u7aef\u53e3:" + serialPort.getPortName()));
                if (Utils.openPort(nbIoTBean.getBaudrate(), serialPort)) {
                    bl = true;
                } else {
                    return string;
                }
            }
            if (!M5310ANbIoTDriver.execAtCommand(nbIoTBean, serialPort, "AT+CSQ\r", "UTF-8")) {
                log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
                return string;
            }
            String string2 = "\\+CSQ:[0-9]+,[0-9]+OK";
            String string3 = ModemDriver.getStrResponse(serialPort, false, string2, "UTF-8");
            Pattern pattern = Pattern.compile(string2);
            Matcher matcher = pattern.matcher(string3);
            if (matcher.find()) {
                string = matcher.group(0);
            }
            string = Utils.deleteSuffix(string, "OK");
            string = Utils.deletePrefix(string, "+CSQ:");
            if (bl) {
                Utils.closePort(serialPort);
            }
        }
        return string;
    }

    @Override
    public String getSerialNumber(SerialPort serialPort) {
        String string = "";
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        if (!M5310ANbIoTDriver.execAtCommand(nbIoTBean, serialPort, "AT+CGSN\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return string;
        }
        String string2 = "[A-Z,0-9]+-[A-Z,0-9]+-[A-Z,0-9]+-[A-Z,0-9]+-[A-Z,0-9]+";
        string = ModemDriver.getStrResponse(serialPort, false, string2, "UTF-8");
        string = Utils.deleteSuffix(string, "OK");
        return string;
    }

    @Override
    public String getCommunicationID(String string) {
        String string2 = "";
        if (string == null || string.equals("")) {
            return string2;
        }
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        String string3 = propertiesConfiguration.getString("random_number_seed", "");
        if (string3 != null && !"".equals(string3) && string3.length() >= 10 && string3.matches("[0-9a-zA-Z]+")) {
            string = string3;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes("UTF-8"));
            byte[] byArray = messageDigest.digest();
            string2 = new BigInteger(1, byArray).toString(16).substring(8, 16).toUpperCase();
        }
        catch (Exception exception) {
            log.error((Object)"\u83b7\u53d6\u901a\u4fe1ID\u5931\u8d25\u3002\u3002\u3002", (Throwable)exception);
            string2 = "";
        }
        return string2;
    }

    @Override
    public boolean networkNormal(SerialPort serialPort) {
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        if (!M5310ANbIoTDriver.execAtCommand(nbIoTBean, serialPort, "AT+CEREG?\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        String string = "+CEREG:0,1";
        String string2 = ModemDriver.getStrResponse(serialPort, false, "OK", "UTF-8");
        if (string.equals(string2 = Utils.deleteSuffix(string2, "OK"))) {
            log.info((Object)(serialPort.getPortName() + "\u7f51\u7edc\u6b63\u5e38\u3002\u3002\u3002"));
            return true;
        }
        log.info((Object)(string2 + "\u5f53\u524d\u7f51\u7edc\u72b6\u6001\uff1a" + string2));
        return false;
    }

    @Override
    public boolean isCompleteMessages(byte[] byArray, NbIoTBean nbIoTBean, List<String> list, List<String> list2) {
        String string = Utils.getString(byArray);
        String string2 = "";
        List<String> list3 = this._$1(string, nbIoTBean);
        if (list3 == null || list3.size() == 0) {
            return true;
        }
        String string3 = "(\\+MQTT){0,1}PUBLISH:[0-9]+,[0-9]+,[0-9]+,[0-9]+," + nbIoTBean.getCommunicationID() + "," + "[0-9]+" + "," + "[\\s\\S]*";
        for (int i = 0; i < list3.size(); ++i) {
            String string4 = list3.get(i);
            if (string4.matches(string3)) {
                int n;
                String string5 = string4.replaceFirst("(\\+MQTT){0,1}PUBLISH:[0-9]+,[0-9]+,[0-9]+,[0-9]+," + nbIoTBean.getCommunicationID() + "," + "[0-9]+" + ",", "");
                int n2 = 0;
                if (Utils.isEmptyStr(string5) || string5.length() <= 38) {
                    list2.add(string4);
                    return false;
                }
                String string6 = string5.substring(35, 38);
                try {
                    n2 = Integer.valueOf(string6, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    list2.add(string4);
                    return false;
                }
                string2 = string5;
                string6 = string5.substring(34, 35);
                if ("U".equals(string6)) {
                    String string7 = string5.substring(0, 38);
                    String string8 = string5.substring(38);
                    try {
                        string2 = string7 + Utils.getString(Utils.hexStr2ByteArr(string8));
                    }
                    catch (Exception exception) {
                        list2.add(string4);
                        return false;
                    }
                }
                if (n2 > (n = Utils.getByteArray(string5.substring(38)).length)) {
                    list2.add(string4);
                    return false;
                }
            } else {
                list2.add(string4);
                return false;
            }
            list.add(string2);
        }
        return true;
    }

    private List<String> _$1(String string, NbIoTBean nbIoTBean) {
        Object object;
        String string2 = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        StringReader stringReader = new StringReader(string);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        int n = propertiesConfiguration.getInt("settings.mqtt_qos", 1);
        String string3 = "(\\+MQTT){0,1}STAT:[0-9]+";
        String string4 = "(\\+MQTT){0,1}OPEN:OK";
        String string5 = "(\\+MQTT){0,1}SUBACK:[0-9]+," + n + "," + nbIoTBean.getCommunicationID();
        String string6 = "(\\+MQTT){0,1}PUBACK:[0-9]+,[0-9]+";
        String string7 = "(\\+MQTT){0,1}PUBREC:[0-9]+,[0-9]+";
        String string8 = "(\\+MQTT){0,1}PUBCOMP:[0-9]+,[0-9]+";
        String string9 = "(\\+MQTT){0,1}DISC:OK";
        if (n != 1 && n != 0) {
            string6 = "(\\+MQTT){0,1}PUBREC:[0-9]+,[0-9]+[\\s\\S]*(\\+MQTT){0,1}PUBCOMP:[0-9]+,[0-9]+";
        }
        String string10 = "(\\+MQTT){0,1}REC:[0-9]+";
        String string11 = "(\\+MQTT){0,1}TO:[0-9]+";
        String string12 = "\\+CEREG:[0-9]+,[0-9]+";
        String string13 = "REBOOT_CAUSE_APPLICATION_WATCHDOG";
        String string14 = "REBOOT_CAUSE_PROTOCOL_RPC_TIMEOUT";
        while (true) {
            object = null;
            try {
                object = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                log.error((Object)"\u4fe1\u606f\u89e3\u6790\u5931\u8d25\u3002\u3002\u3002", (Throwable)iOException);
            }
            if (object == null) break;
            if (object.trim().equals("") || object.replace("\r", "").replace("\n", "").equals("OK")) continue;
            if (object.startsWith("OK")) {
                string2 = string2 + object.substring(2);
                continue;
            }
            if (object.replace("\r", "").replace("\n", "").equals("ERROR") || object.replace("\r", "").replace("\n", "").matches(string3) || object.replace("\r", "").replace("\n", "").matches(string4) || object.replace("\r", "").replace("\n", "").matches(string5) || (n == 1 || n == 0) && object.replace("\r", "").replace("\n", "").matches(string6)) continue;
            if (object.replace("\r", "").replace("\n", "").contains(string13) || object.replace("\r", "").replace("\n", "").contains(string14)) {
                log.error((Object)("\u8bbe\u5907\u3010" + nbIoTBean.getGatewayID() + "\u3011\u53d1\u751f\u4e25\u91cd\u5f02\u5e38\uff01\u5373\u5c06\u505c\u6b62\uff01"));
                log.info((Object)("\u9519\u8bef\u4fe1\u606f\uff1a" + string));
                this.stopDevice(nbIoTBean.getPortID());
                return arrayList;
            }
            if (n == 2 && object.replace("\r", "").replace("\n", "").matches(string7) || n == 2 && object.replace("\r", "").replace("\n", "").matches(string8)) continue;
            if (object.replace("\r", "").replace("\n", "").matches(string10)) {
                this._$1(nbIoTBean.getPortID());
                continue;
            }
            if (object.replace("\r", "").replace("\n", "").matches(string11) || object.replace("\r", "").replace("\n", "").matches(string9) || object.replace("\r", "").replace("\n", "").matches(string12)) continue;
            if (object.startsWith("+MQTTSTAT:5")) {
                object = object.replace("+MQTTSTAT:5", "");
            }
            string2 = string2 + (String)object;
        }
        try {
            bufferedReader.close();
            stringReader.close();
        }
        catch (IOException iOException) {
            log.error((Object)"\u6570\u636e\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)iOException);
        }
        object = string2.split("(\\+MQTT){0,1}PUBLISH:");
        for (int i = 0; i < ((String[])object).length; ++i) {
            if (object[i] == null || object[i].length() == 0) continue;
            arrayList.add("+MQTTPUBLISH:" + object[i]);
        }
        if (string2.endsWith("PUBLISH:")) {
            arrayList.add("+MQTTPUBLISH:");
        }
        return arrayList;
    }

    private void _$1(String string) {
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(string);
        if (nbIoTBean != null) {
            log.error((Object)"\u8bbe\u5907\u8fde\u63a5\u5f02\u5e38\uff0c\u5373\u5c06\u91cd\u542f\uff01\u3010M5310A-prepareRestartDevice\u3011");
            nbIoTBean.setUsingStatus("2");
            log.info((Object)(nbIoTBean.getGatewayID() + "\u5373\u5c06\u91cd\u542f\u3002\u3002\u3002"));
            WatchDog.getInstance().interrupt();
        }
    }

    @Override
    public boolean initDevice(SerialPort serialPort) {
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        if (!M5310ANbIoTDriver.execAtCommand(nbIoTBean, serialPort, "AT+NRB\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        String string = ModemDriver.getStrResponse(serialPort, false, "REBOOTING[\\s\\S]*OK", "UTF-8");
        if (string.matches("REBOOTING[\\s\\S]*OK")) {
            return true;
        }
        log.info((Object)("\u8bbe\u5907\u91cd\u542f\u5931\u8d25\uff1a" + string));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendMessage(String string, String string2, NbIoTBean nbIoTBean) {
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        String string3 = nbIoTBean.getPortID();
        boolean bl = false;
        SerialPort serialPort = nbiotDeviceInfoGetter.getSerialPort(string3);
        int n = propertiesConfiguration.getInt("settings.mqtt_qos", 1);
        String string4 = "AT+MQTTPUB=\"" + string + "\"," + n + ",0,0," + 0 + ",\"" + string2 + "\"\r";
        String string5 = "[\\s]*OK[\\s]*";
        String string6 = "(\\+MQTT){0,1}PUBACK:[0-9]+,[0-9]+";
        String string7 = "(\\+MQTT){0,1}PUBREC:[0-9]+,[0-9]+";
        String string8 = "(\\+MQTT){0,1}PUBCOMP:[0-9]+,[0-9]+";
        String string9 = "(\\+MQTT){0,1}TO:2";
        String string10 = "(\\+MQTT){0,1}REC:[0-9]+";
        Pattern pattern = Pattern.compile(string5);
        Pattern pattern2 = Pattern.compile(string6);
        Pattern pattern3 = Pattern.compile(string7);
        Pattern pattern4 = Pattern.compile(string8);
        Pattern pattern5 = Pattern.compile(string9);
        Pattern pattern6 = Pattern.compile(string10);
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            if (!M5310ANbIoTDriver.execAtCommand(nbIoTBean, serialPort, string4, "UTF-8")) {
                log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
                return false;
            }
            byte[] byArray = ModemDriver.getBytesResponse(serialPort, "UTF-8");
            int n2 = 0;
            while (M5310ANbIoTDriver.serialportConnected(serialPort)) {
                String string11 = Utils.getString(byArray);
                if (string11.replace("\r", "").replace("\n", "").equals("ERROR")) {
                    log.info((Object)("\u8bbe\u5907" + nbIoTBean.getGatewayID() + "\u4fe1\u606f\u53d1\u9001\u5931\u8d25." + "\u8fd4\u56de\u503c\uff1a" + string11));
                    return false;
                }
                Matcher matcher = pattern.matcher(string11.replace("\r", "").replace("\n", ""));
                Matcher matcher2 = pattern2.matcher(string11.replace("\r", "").replace("\n", ""));
                Matcher matcher3 = pattern3.matcher(string11.replace("\r", "").replace("\n", ""));
                Matcher matcher4 = pattern4.matcher(string11.replace("\r", "").replace("\n", ""));
                Matcher matcher5 = pattern5.matcher(string11.replace("\r", "").replace("\n", ""));
                Matcher matcher6 = pattern6.matcher(string11.replace("\r", "").replace("\n", ""));
                boolean bl2 = matcher.find();
                boolean bl3 = matcher2.find();
                boolean bl4 = matcher3.find() && matcher4.find();
                boolean bl5 = matcher5.find();
                boolean bl6 = matcher6.find();
                if (n == 0 && bl2 || n == 1 && bl3 || n == 2 && bl4) {
                    bl = true;
                    break;
                }
                if ((bl5 || bl6) && !matcher3.reset().find()) {
                    this._$1(nbIoTBean.getPortID());
                    break;
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    log.error((Object)"\u7b49\u5f85\u53d1\u9001\u4fe1\u606f\u547d\u4ee4\u7684\u8fd4\u56de\u7ed3\u679c\u65f6\u88ab\u6253\u65ad\u3002\u3002\u3002");
                }
                byte[] byArray2 = ModemDriver.getBytesResponse(serialPort, "UTF-8");
                byArray = Utils.mergeByteArray(byArray2, byArray);
                if (++n2 < 300) continue;
                break;
            }
            this.getCompleteMessages(byArray, serialPort, nbIoTBean, "\u53d1\u4fe1\u7ebf\u7a0b");
            return bl;
        }
    }

    @Override
    public void commandNotEcho(SerialPort serialPort) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean subSucessed(String string) {
        SerialPort serialPort = nbiotDeviceInfoGetter.getSerialPort(string);
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(string);
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
            int n = propertiesConfiguration.getInt("settings.mqtt_qos", 1);
            String string2 = "AT+MQTTSUB=\"" + nbIoTBean.getCommunicationID() + "\"," + n + "\r";
            if (!M5310ANbIoTDriver.execAtCommand(nbIoTBean, serialPort, string2, "UTF-8")) {
                log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
                return false;
            }
            byte[] byArray = ModemDriver.getBytesResponse(serialPort, "UTF-8");
            int n2 = 0;
            String string3 = "OK[\\s\\S]*(\\+MQTT){0,1}SUBACK:[0-9]+," + n + "," + nbIoTBean.getCommunicationID();
            String string4 = "(\\+MQTT){0,1}PUBLISH:[0-9]+,[0-9]+,[0-9]+,[0-9]+," + nbIoTBean.getCommunicationID() + "," + "[0-9]+" + "," + "[\\s\\S]*";
            Pattern pattern = Pattern.compile(string3);
            Pattern pattern2 = Pattern.compile(string4);
            Matcher matcher = null;
            Matcher matcher2 = null;
            String string5 = "";
            while (M5310ANbIoTDriver.serialportConnected(serialPort)) {
                string5 = Utils.getString(byArray);
                if (string5.replace("\r", "").replace("\n", "").matches(string3)) {
                    return true;
                }
                if (string5.replace("\r", "").replace("\n", "").equals("ERROR")) {
                    return false;
                }
                matcher = pattern.matcher(string5.replace("\r", "").replace("\n", ""));
                if (matcher.find() || (matcher2 = pattern2.matcher(string5.replace("\r", "").replace("\n", ""))).find()) break;
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    log.error((Object)"\u7b49\u5f85MQTT\u670d\u52a1\u5668\u8ba2\u9605\u662f\u5426\u6210\u529f\u7684\u53cd\u9988\u4fe1\u606f\u65f6\u88ab\u6253\u65ad\u3002\u3002\u3002");
                }
                byte[] byArray2 = ModemDriver.getBytesResponse(serialPort, "UTF-8");
                byArray = Utils.mergeByteArray(byArray2, byArray);
                if (++n2 < 150) continue;
                break;
            }
            if (string5 == null || string5.equals("")) {
                return false;
            }
            this.getCompleteMessages(byArray, serialPort, nbIoTBean, "\u8ba2\u9605\u4e3b\u9898");
            matcher.reset();
            matcher2.reset();
            return matcher.find() || matcher2.find();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connectSucessed(String string) {
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        SerialPort serialPort = nbiotDeviceInfoGetter.getSerialPort(string);
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(string);
        String string2 = propertiesConfiguration.getString("settings.mqtt_server", "119.90.56.92");
        String string3 = propertiesConfiguration.getString("settings.mqtt_port", "1883");
        String string4 = propertiesConfiguration.getString("settings.mqtt_user", "0000");
        String string5 = propertiesConfiguration.getString("settings.mqtt_password", "0000");
        int n = propertiesConfiguration.getInt("settings.mqtt_keepalive", 10);
        int n2 = propertiesConfiguration.getInt("settings.mqtt_ack", 8);
        String string6 = "AT+MQTTCFG=\"" + string2 + "\"," + string3 + ",\"" + nbIoTBean.getCommunicationID() + "\"," + n + ",\"" + string4 + "\"," + "\"" + string5 + "\",0" + "\r";
        if (!M5310ANbIoTDriver.execAtCommand(nbIoTBean, serialPort, string6, "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            this.stopDevice(nbIoTBean.getPortID());
            return false;
        }
        String string7 = ModemDriver.getStrResponse(serialPort, false, "OK", "UTF-8");
        if (!"OK".equals(string7)) {
            log.error((Object)(serialPort.getPortName() + "\u914d\u7f6eMQTT\u670d\u52a1\u5668\u8fde\u63a5\u53c2\u6570\u5f02\u5e38:" + string7));
            this.stopDevice(nbIoTBean.getPortID());
            return false;
        }
        String string8 = "AT+MQTTTO=" + n2 + "\r";
        if (!M5310ANbIoTDriver.execAtCommand(nbIoTBean, serialPort, string8, "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            this.stopDevice(nbIoTBean.getPortID());
            return false;
        }
        string7 = ModemDriver.getStrResponse(serialPort, false, "OK", "UTF-8");
        if (!"OK".equals(string7)) {
            log.error((Object)(serialPort.getPortName() + "MQTT\u670d\u52a1\u5668\u54cd\u5e94\u65f6\u95f4\u8bbe\u5b9a\u5f02\u5e38" + string7 + "\u91c7\u7528\u9ed8\u8ba4\u8bbe\u5b9a\uff0810S\uff09..."));
            this.stopDevice(nbIoTBean.getPortID());
            return false;
        }
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            String string9 = nbIoTBean.getCommunicationID();
            String string10 = string4.equals("0000") ? "1" : "0";
            String string11 = string5.equals("0000") ? "1" : "0";
            String string12 = "AT+MQTTOPEN=" + string10 + "," + string11 + ",0" + "\r";
            if (!M5310ANbIoTDriver.execAtCommand(nbIoTBean, serialPort, string12, "UTF-8")) {
                log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
                return false;
            }
            String string13 = "OK[\\s\\S]*(\\+MQTT){0,1}OPEN:OK";
            String string14 = "(\\+MQTT){0,1}PUBLISH:[0-9]+,[0-9]+,[0-9]+,[0-9]+," + string9 + "," + "[0-9]+" + "," + "[\\s\\S]*";
            Pattern pattern = Pattern.compile(string13);
            Pattern pattern2 = Pattern.compile(string14);
            Matcher matcher = null;
            Matcher matcher2 = null;
            byte[] byArray = ModemDriver.getBytesResponse(serialPort, "UTF-8");
            int n3 = 0;
            while (M5310ANbIoTDriver.serialportConnected(serialPort)) {
                string7 = Utils.getString(byArray);
                if (string7.replace("\r", "").replace("\n", "").matches(string13)) {
                    return true;
                }
                if (string7.replace("\r", "").replace("\n", "").equals("ERROR")) {
                    return false;
                }
                matcher = pattern.matcher(string7.replace("\r", "").replace("\n", ""));
                if (matcher.find() || (matcher2 = pattern2.matcher(string7.replace("\r", "").replace("\n", ""))).find()) break;
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    log.error((Object)"\u7b49\u5f85MQTT\u670d\u52a1\u5668\u8fde\u63a5\u662f\u5426\u6210\u529f\u7684\u53cd\u9988\u4fe1\u606f\u65f6\u88ab\u6253\u65ad\u3002\u3002\u3002");
                }
                byte[] byArray2 = ModemDriver.getBytesResponse(serialPort, "UTF-8");
                byArray = Utils.mergeByteArray(byArray2, byArray);
                if (++n3 < 150) continue;
                break;
            }
            if (string7 == null || string7.equals("")) {
                return false;
            }
            this.getCompleteMessages(byArray, serialPort, nbIoTBean, "\u8fde\u63a5MQTT\u670d\u52a1\u5668");
            matcher.reset();
            matcher2.reset();
            boolean bl = matcher.find();
            boolean bl2 = matcher2.find();
            if (bl || bl2) {
                if (bl2) {
                    nbIoTBean.setUsingStatus("1");
                }
                return true;
            }
            return false;
        }
    }

    @Override
    public void disconnectMQTTServer(SerialPort serialPort) {
        Object object;
        String string;
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        if (!M5310ANbIoTDriver.execAtCommand(nbIoTBean, serialPort, string = "AT+MQTTDISC\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
        }
        String string2 = "MQTTDISC:OK";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = null;
        byte[] byArray = ModemDriver.getBytesResponse(serialPort, "UTF-8");
        int n = 0;
        String string3 = "";
        while (M5310ANbIoTDriver.serialportConnected(serialPort)) {
            string3 = Utils.getString(byArray);
            if (string3.replace("\r", "").replace("\n", "").equals(string2)) {
                log.info((Object)(nbIoTBean.getGatewayID() + "\u65ad\u5f00\u8fde\u63a5\u6210\u529f(1)"));
                break;
            }
            if (string3.replace("\r", "").replace("\n", "").equals("ERROR")) {
                log.info((Object)(nbIoTBean.getGatewayID() + "\u65ad\u5f00\u8fde\u63a5\u5931\u8d25(1)\u3002"));
                break;
            }
            matcher = pattern.matcher(string3.replace("\r", "").replace("\n", ""));
            if (matcher.find()) break;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                log.error((Object)"\u7b49\u5f85MQTT\u670d\u52a1\u5668\u8fde\u63a5\u662f\u5426\u6210\u529f\u7684\u53cd\u9988\u4fe1\u606f\u65f6\u88ab\u6253\u65ad\u3002\u3002\u3002");
            }
            object = ModemDriver.getBytesResponse(serialPort, "UTF-8");
            byArray = Utils.mergeByteArray((byte[])object, byArray);
            if (++n < 150) continue;
            break;
        }
        if (string3 == null || string3.equals("")) {
            log.info((Object)(nbIoTBean.getGatewayID() + "\u65ad\u5f00\u8fde\u63a5\u5931\u8d25(2)"));
        }
        this.getCompleteMessages(byArray, serialPort, nbIoTBean, "\u65ad\u5f00MQTT\u670d\u52a1\u5668\u8fde\u63a5");
        object = "AT+MQTTDEL\r";
        if (!M5310ANbIoTDriver.execAtCommand(nbIoTBean, serialPort, (String)object, "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
        }
        if (!(string3 = ModemDriver.getStrResponse(serialPort, false, string2 = "OK", "UTF-8")).contains(string2)) {
            log.error((Object)"\u6ca1\u6709\u6210\u529f\u6e05\u9664\u5ba2\u6237\u7aef\u5b9e\u4f8b\u3002\u3002\u3002");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connectionOK(String string) {
        SerialPort serialPort = nbiotDeviceInfoGetter.getSerialPort(string);
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(string);
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            if ("0".equals(nbIoTBean.getUsingStatus())) {
                log.info((Object)("\u8bbe\u5907" + nbIoTBean.getGatewayID() + "\u5df2\u7ecf\u5173\u95ed\u3002\u3002\u3002"));
                return true;
            }
            String string2 = "(\\+MQTT){0,1}STAT:5";
            Pattern pattern = Pattern.compile(string2);
            String string3 = "AT+MQTTSTAT?\r";
            if (!M5310ANbIoTDriver.execAtCommand(nbIoTBean, serialPort, string3, "UTF-8")) {
                if ("0".equals(nbIoTBean.getUsingStatus())) {
                    log.info((Object)("\u8bbe\u5907" + nbIoTBean.getGatewayID() + "\u5df2\u7ecf\u5173\u95ed\u3002\u3002\u3002"));
                    return true;
                }
                return false;
            }
            byte[] byArray = ModemDriver.getBytesResponse(serialPort, "UTF-8");
            int n = 0;
            Matcher matcher = null;
            String string4 = "";
            while (M5310ANbIoTDriver.serialportConnected(serialPort)) {
                string4 = Utils.getString(byArray);
                if (string4.replace("\r", "").replace("\n", "").equals("ERROR")) {
                    return false;
                }
                matcher = pattern.matcher(string4.replace("\r", "").replace("\n", ""));
                if (matcher.find()) break;
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    log.error((Object)"\u7b49\u5f85MQTT\u670d\u52a1\u5668\u8fde\u63a5\u662f\u5426\u6b63\u5e38\u7684\u53cd\u9988\u4fe1\u606f\u65f6\u88ab\u6253\u65ad\u3002\u3002\u3002");
                }
                byte[] byArray2 = ModemDriver.getBytesResponse(serialPort, "UTF-8");
                byArray = Utils.mergeByteArray(byArray2, byArray);
                if (++n < 50) continue;
                break;
            }
            if (byArray == null || byArray.equals("")) {
                log.info((Object)("\u8bbe\u5907" + nbIoTBean.getGatewayID() + "\u72b6\u6001\u68c0\u6d4b\u65e0\u54cd\u5e94\u3002"));
                return false;
            }
            this.getCompleteMessages(byArray, serialPort, nbIoTBean, "\u5224\u65ad\u8fde\u63a5\u72b6\u6001");
            matcher.reset();
            boolean bl = matcher.find();
            if (bl) {
                return true;
            }
            log.info((Object)("\u8bbe\u5907" + nbIoTBean.getGatewayID() + "\u4e0e\u670d\u52a1\u5668\u8fde\u63a5\u5f02\u5e38\uff01\u68c0\u6d4b\u8fd4\u56de\u503c\uff1a" + string4));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] _$1(SerialPort serialPort, String string, NbIoTBean nbIoTBean) {
        String string2;
        if ("Quectel_BC26".equals(nbIoTBean.getDeviceType()) && string.endsWith("\"") && string.matches(string2 = "(\\+QMT){0,1}RECV: [0-9]+,[0-9]+,\"" + nbIoTBean.getCommunicationID() + "\",\"" + "[\\s\\S]+" + "\"$")) {
            log.info((Object)("\u4fe1\u606f\u4e0d\u5b8c\u6574\uff08\u8bbe\u5907\u5bfc\u81f4\u7684\u4fe1\u606f\u4e22\u5931\uff09\uff1a" + string));
            return Utils.getByteArray(string);
        }
        int n = 0;
        byte[] byArray = null;
        byte[] byArray2 = string.getBytes();
        while (true) {
            SerialPort serialPort2 = serialPort;
            synchronized (serialPort2) {
                byte[] byArray3;
                block25: {
                    byArray3 = new byte[1];
                    if (!M5310ANbIoTDriver.serialportConnected(serialPort)) {
                        return null;
                    }
                    try {
                        if (!serialPort.isOpened()) break block25;
                        while (serialPort.getInputBufferBytesCount() <= 0 && n < 50) {
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException interruptedException) {
                                log.info((Object)"\u7ebf\u7a0b\u7b49\u5f85\u88ab\u6253\u65ad\u3002\u3002\u3002");
                            }
                            if (++n < 49) continue;
                            log.error((Object)("\u8bbe\u5907" + nbIoTBean.getGatewayID() + "\u672a\u54cd\u5e94!"));
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(byArray) + "\u3011"));
                            return byArray2;
                        }
                        byArray3 = serialPort.readBytes(1);
                    }
                    catch (SerialPortException serialPortException) {
                        log.error((Object)("\u8bfb\u4e32\u53e3" + serialPort.getPortName() + "\u5931\u8d25\u3002\u3002\u3002"), (Throwable)serialPortException);
                        break;
                    }
                }
                if (byArray3 == null) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        log.info((Object)"\u7ebf\u7a0b\u7b49\u5f85\u88ab\u6253\u65ad\u3002\u3002\u3002");
                    }
                    if (++n > 50) {
                        break;
                    }
                } else {
                    Matcher matcher;
                    Matcher matcher2;
                    Pattern pattern;
                    Pattern pattern2;
                    String string3;
                    String string4;
                    byArray = Utils.mergeByteArray(byArray3, byArray);
                    byArray2 = Utils.mergeByteArray(byArray3, byArray2);
                    String string5 = Utils.getString(byArray2);
                    if ("Quectel_BC26".equals(nbIoTBean.getDeviceType())) {
                        if (string5.endsWith("+QMT")) {
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(byArray) + "\u3011"));
                            log.info((Object)("\u4fe1\u606f\u7f3a\u5931\u90e8\u5206\u5df2\u7ecf\u8bfb\u5b8c\uff1a" + string5));
                            return Utils.getByteArray(string5.substring(0, string5.length() - 4));
                        }
                        string4 = "((\\+QMT){0,1}STAT: [0-9]+,[0-9]+)$";
                        string3 = "Rb[\\S\\s]+B[\\S\\s]+";
                        pattern2 = Pattern.compile(string4);
                        pattern = Pattern.compile(string3);
                        matcher2 = pattern2.matcher(string5.replace("\r", "").replace("\n", ""));
                        matcher = pattern.matcher(string5.replace("\r", "").replace("\n", ""));
                        if (matcher2.find() || matcher.find()) {
                            nbIoTBean.setUsingStatus("2");
                            WatchDog.getInstance().interrupt();
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(byArray) + "\u3011"));
                            return Utils.getByteArray(string5.replaceAll(string3, "").replaceAll(string4, ""));
                        }
                        if (string5.replace("\r", "").replace("\n", "").endsWith("ERROR")) {
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(byArray) + "\u3011"));
                            return Utils.getByteArray(string5.replace("ERROR", ""));
                        }
                    }
                    if ("M5310-A".equals(nbIoTBean.getDeviceType())) {
                        if (string5.endsWith("+MQTT")) {
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(byArray) + "\u3011"));
                            log.info((Object)("\u4fe1\u606f\u7f3a\u5931\u90e8\u5206\u5df2\u7ecf\u8bfb\u5b8c\uff1a" + string5));
                            return Utils.getByteArray(string5.substring(0, string5.length() - 5));
                        }
                        string4 = "(\\+MQTT){0,1}REC:[0-9]+";
                        string3 = "(\\+MQTT){0,1}PUBREC:[0-9]+,[0-9]+";
                        pattern2 = Pattern.compile(string4);
                        pattern = Pattern.compile(string3);
                        matcher2 = pattern2.matcher(string5.replace("\r", "").replace("\n", ""));
                        matcher = pattern.matcher(string5.replace("\r", "").replace("\n", ""));
                        if (matcher2.find() && !matcher.find()) {
                            nbIoTBean.setUsingStatus("2");
                            WatchDog.getInstance().interrupt();
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(byArray) + "\u3011"));
                            return Utils.getByteArray(string5.replaceAll(string4, ""));
                        }
                        String string6 = "REBOOT_CAUSE_APPLICATION_WATCHDOG";
                        String string7 = "REBOOT_CAUSE_PROTOCOL_RPC_TIMEOUT";
                        if (string5.contains(string6) || string5.contains(string7)) {
                            this.stopDevice(serialPort.getPortName());
                        }
                    }
                }
            }
        }
        if (byArray2 != null && byArray2.length != 0) {
            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(byArray) + "\u3011"));
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getCompleteMessages(byte[] byArray, SerialPort serialPort, NbIoTBean nbIoTBean, String string) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            while (!this.isCompleteMessages(byArray, nbIoTBean, arrayList, arrayList2)) {
                byte[] byArray2;
                log.debug((Object)("\u6536\u5230\u4e0d\u5b8c\u6574\u4fe1\u606f\uff1a\u3010" + string + "\u3011" + Utils.getString(byArray)));
                if (n >= 15 || arrayList.size() > 50) {
                    log.info((Object)("\u8bfb\u4e32\u53e3\u6b21\u6570:" + n));
                    log.info((Object)("\u5185\u5b58\u4e2d\u4fe1\u606f\u6761\u6570\uff1a" + arrayList.size()));
                    if (arrayList2.isEmpty()) break;
                    log.info((Object)("\u4fe1\u606f\u63a5\u6536\u5b8c\u6574\u524d" + (String)arrayList2.get(0)));
                    byArray2 = this._$1(serialPort, (String)arrayList2.get(0), nbIoTBean);
                    log.info((Object)("\u4fe1\u606f\u63a5\u6536\u5b8c\u6574\u540e" + Utils.getString(byArray2)));
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    arrayList2 = new ArrayList();
                    if (!this.isCompleteMessages(byArray2, nbIoTBean, arrayList3, arrayList2)) {
                        log.error((Object)"\u4e0b\u5217\u4fe1\u606f\u672a\u63a5\u6536\u5b8c\u3002\u3002\u3002\u3002");
                        for (int i = 0; i < arrayList2.size(); ++i) {
                            log.info(arrayList2.get(i));
                        }
                        break;
                    }
                    arrayList.addAll(arrayList3);
                    break;
                }
                if (!M5310ANbIoTDriver.serialportConnected(serialPort)) {
                    log.info((Object)("\u8bbe\u5907" + nbIoTBean.getGatewayID() + "\u6389\u7ebf\u4e86\u3002\u3002\u3002"));
                    log.info((Object)("\u4fe1\u606f\u53ef\u80fd\u6709\u4e22\u5931\uff1a" + Utils.getString(byArray)));
                    break;
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                byArray2 = ModemDriver.getBytesResponse(serialPort, "UTF-8");
                byArray = Utils.mergeByteArray(byArray2, byArray);
                arrayList = new ArrayList();
                arrayList2 = new ArrayList();
                ++n;
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            nbiotMessageHolder.updateMessageList(nbIoTBean, (String)arrayList.get(i));
        }
    }

    @Override
    public boolean isDeviceAT(SerialPort serialPort) {
        if (!M5310ANbIoTDriver.execAtCommand(null, serialPort, "AT\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            log.info((Object)"\u7b49\u5f85AT\u54cd\u5e94\u65f6\u88ab\u6253\u65ad");
        }
        String string = ModemDriver.getStrResponse(serialPort, false, "", "UTF-8");
        string = string.replace("AT", "");
        return "OK".equals(string);
    }
}

