/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.smpp.jsmpp;

import cn.sendsms.GatewayException;
import cn.sendsms.OutboundMessage;
import cn.sendsms.TimeoutException;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.helper.Logger;
import cn.sendsms.smpp.AbstractSMPPGateway;
import cn.sendsms.smpp.BindAttributes;
import cn.sendsms.smpp.jsmpp.IlIlIIIIlIlIllII;
import cn.sendsms.smpp.jsmpp.lIIlIIIlllIIlllI;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.GeneralDataCoding;
import org.jsmpp.bean.MessageClass;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.SMSCDeliveryReceipt;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.MessageReceiverListener;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.session.SessionStateListener;

public class JSMPPGateway
extends AbstractSMPPGateway {
    private SMPPSession _$16 = null;
    private IlIlIIIIlIlIllII _$15 = new IlIlIIIIlIlIllII(this);
    private SessionStateListener _$14 = new lIIlIIIlllIIlllI(this);
    private BindType _$13;
    private TypeOfNumber _$12;
    private NumberingPlanIndicator _$11;

    public JSMPPGateway(String string, String string2, int n, BindAttributes bindAttributes) {
        super(string, string2, n, bindAttributes);
        this.setAttributes(79);
        this._$2();
    }

    private void _$2() {
        switch (this.bindAttributes.getBindType()) {
            case RECEIVER: {
                this._$13 = BindType.BIND_RX;
                this.setInbound(true);
                this.setOutbound(false);
                break;
            }
            case TRANSMITTER: {
                this._$13 = BindType.BIND_TX;
                this.setInbound(false);
                this.setOutbound(true);
                break;
            }
            case TRANSCEIVER: {
                this._$13 = BindType.BIND_TRX;
                this.setInbound(true);
                this.setOutbound(true);
                break;
            }
            default: {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Unknown BindType " + (Object)((Object)this.bindAttributes.getBindType()));
                Logger.getInstance().logError(illegalArgumentException.getMessage(), illegalArgumentException, this.getGatewayId());
                throw illegalArgumentException;
            }
        }
        this._$12 = TypeOfNumber.valueOf((byte)this.bindAttributes.getBindAddress().getTypeOfNumber().value());
        this._$11 = NumberingPlanIndicator.valueOf((byte)this.bindAttributes.getBindAddress().getNumberingPlanIndicator().value());
        this._$1();
    }

    private void _$1() {
        this._$16 = new SMPPSession();
        this._$16.addSessionStateListener(this._$14);
        this._$16.setMessageReceiverListener((MessageReceiverListener)this._$15);
    }

    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (!this._$16.getSessionState().isBound()) {
            if (this.enquireLink > 0) {
                this._$16.setEnquireLinkTimer(this.enquireLink);
            }
            this._$16.connectAndBind(this.host, this.port, new BindParameter(this._$13, this.bindAttributes.getSystemId(), this.bindAttributes.getPassword(), this.bindAttributes.getSystemType(), this._$12, this._$11, null));
        } else {
            Logger.getInstance().logWarn("SMPP session already bound.", null, this.getGatewayId());
        }
    }

    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this._$16.getSessionState().isBound()) {
            this._$16.removeSessionStateListener(this._$14);
            this._$16.unbindAndClose();
        } else {
            Logger.getInstance().logWarn("SMPP session not bound.", null, this.getGatewayId());
        }
        super.stopGateway();
    }

    public boolean sendMessage(OutboundMessage outboundMessage) throws TimeoutException, GatewayException, IOException, InterruptedException {
        GeneralDataCoding generalDataCoding;
        Alphabet alphabet = Alphabet.ALPHA_DEFAULT;
        switch (outboundMessage.getEncoding()) {
            case ENC8BIT: {
                alphabet = Alphabet.ALPHA_8_BIT;
                break;
            }
            case ENCUCS2: {
                alphabet = Alphabet.ALPHA_UCS2;
                break;
            }
            case ENCCUSTOM: {
                alphabet = Alphabet.ALPHA_RESERVED;
            }
        }
        switch (outboundMessage.getDCSMessageClass()) {
            case MSGCLASS_FLASH: {
                generalDataCoding = new GeneralDataCoding(false, true, MessageClass.CLASS0, alphabet);
                break;
            }
            case MSGCLASS_ME: {
                generalDataCoding = new GeneralDataCoding(false, true, MessageClass.CLASS1, alphabet);
                break;
            }
            case MSGCLASS_SIM: {
                generalDataCoding = new GeneralDataCoding(false, true, MessageClass.CLASS2, alphabet);
                break;
            }
            case MSGCLASS_TE: {
                generalDataCoding = new GeneralDataCoding(false, true, MessageClass.CLASS3, alphabet);
                break;
            }
            default: {
                generalDataCoding = new GeneralDataCoding();
                generalDataCoding.setAlphabet(alphabet);
            }
        }
        try {
            RegisteredDelivery registeredDelivery = new RegisteredDelivery();
            registeredDelivery.setSMSCDeliveryReceipt(outboundMessage.getStatusReport() ? SMSCDeliveryReceipt.SUCCESS_FAILURE : SMSCDeliveryReceipt.DEFAULT);
            String string = this._$16.submitShortMessage(this.bindAttributes.getSystemType(), TypeOfNumber.valueOf((byte)this.sourceAddress.getTypeOfNumber().value()), NumberingPlanIndicator.valueOf((byte)this.sourceAddress.getNumberingPlanIndicator().value()), outboundMessage.getFrom() != null ? outboundMessage.getFrom() : this.getFrom(), TypeOfNumber.valueOf((byte)this.destinationAddress.getTypeOfNumber().value()), NumberingPlanIndicator.valueOf((byte)this.destinationAddress.getNumberingPlanIndicator().value()), outboundMessage.getRecipient(), new ESMClass(), (byte)0, (byte)outboundMessage.getPriority(), null, this._$2(outboundMessage.getValidityPeriod()), registeredDelivery, (byte)0, (DataCoding)generalDataCoding, (byte)0, outboundMessage.getText().getBytes(), new OptionalParameter[0]);
            outboundMessage.setRefNo(string);
            outboundMessage.setDispatchDate(new Date());
            outboundMessage.setGatewayId(this.getGatewayId());
            outboundMessage.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
            this.incOutboundMessageCount();
        }
        catch (PDUException pDUException) {
            outboundMessage.setGatewayId(this.getGatewayId());
            outboundMessage.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
            outboundMessage.setFailureCause(OutboundMessage.FailureCauses.BAD_FORMAT);
            Logger.getInstance().logError("Message Format not accepted.", (Exception)((Object)pDUException), this.getGatewayId());
            return false;
        }
        catch (ResponseTimeoutException responseTimeoutException) {
            Logger.getInstance().logError("Message could not be sent.", (Exception)((Object)responseTimeoutException), this.getGatewayId());
            throw new TimeoutException(responseTimeoutException.getMessage());
        }
        catch (InvalidResponseException invalidResponseException) {
            Logger.getInstance().logError("Message could not be sent.", (Exception)((Object)invalidResponseException), this.getGatewayId());
            throw new IOException("InvalidResponseException: ", invalidResponseException);
        }
        catch (NegativeResponseException negativeResponseException) {
            Logger.getInstance().logError("Message could not be sent.", (Exception)((Object)negativeResponseException), this.getGatewayId());
            throw new IOException("NegativeResponseException: ", negativeResponseException);
        }
        return true;
    }

    private String _$2(int n) {
        if (n < 0) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, 0);
        calendar.add(10, n);
        int n2 = calendar.get(1) - calendar.getMinimum(1);
        int n3 = calendar.get(2);
        int n4 = calendar.get(5) - 1;
        int n5 = calendar.get(11);
        String string = n2 < 10 ? "0" + n2 : n2 + "";
        String string2 = n3 < 10 ? "0" + n3 : n3 + "";
        String string3 = n4 < 10 ? "0" + n4 : n4 + "";
        String string4 = n5 < 10 ? "0" + n5 : n5 + "";
        return string + string2 + string3 + string4 + "0000000R";
    }

    public void setEnquireLink(int n) {
        super.setEnquireLink(n);
        if (this._$16 != null) {
            this._$16.setEnquireLinkTimer(n);
        }
    }

    static /* synthetic */ void _$2(JSMPPGateway jSMPPGateway) throws TimeoutException, GatewayException, IOException, InterruptedException {
        super.startGateway();
    }

    static /* synthetic */ void _$1(JSMPPGateway jSMPPGateway, AGatewayHelper.GatewayStatuses gatewayStatuses) {
        super.setStatus(gatewayStatuses);
    }

    static /* synthetic */ void _$1(JSMPPGateway jSMPPGateway) {
        jSMPPGateway._$1();
    }
}

