/*
 * Decompiled with CFR 0.152.
 */
package cn.ajwcc.pduUtils.test.integration;

import cn.sendsms.AGateway;
import cn.sendsms.ICallNotification;
import cn.sendsms.IInboundMessageNotification;
import cn.sendsms.IOutboundMessageNotification;
import cn.sendsms.InboundMessage;
import cn.sendsms.Library;
import cn.sendsms.Message;
import cn.sendsms.OutboundMessage;
import cn.sendsms.Service;
import cn.sendsms.modem.SerialModemGateway;

public abstract class AbstractTester {
    protected static final String MODEM_NUMBER = "xxxx";
    protected static final String PHONE_NUMBER = "xxxx";

    protected void initModem() throws Exception {
        System.out.println(Library.getLibraryDescription());
        System.out.println("Version: " + Library.getLibraryVersion());
        SerialModemGateway serialModemGateway = new SerialModemGateway("modem.com1", "COM10", 115200, "Wavecom", "");
        serialModemGateway.setSimPin("0000");
        serialModemGateway.setOutbound(true);
        OutboundNotification outboundNotification = new OutboundNotification();
        Service.getInstance().setOutboundMessageNotification(outboundNotification);
        serialModemGateway.setInbound(true);
        InboundNotification inboundNotification = new InboundNotification();
        Service.getInstance().setInboundMessageNotification(inboundNotification);
        Service.getInstance().addGateway(serialModemGateway);
        Service.getInstance().startService();
        System.out.println();
        System.out.println("Modem Information:");
        System.out.println("  Manufacturer: " + serialModemGateway.getManufacturer());
        System.out.println("  Model: " + serialModemGateway.getModel());
        System.out.println("  Serial No: " + serialModemGateway.getSerialNo());
        System.out.println("  SIM IMSI: " + serialModemGateway.getImsi());
        System.out.println("  Signal Level: " + serialModemGateway.getSignalLevel() + " dBm");
        System.out.println("  Battery Level: " + serialModemGateway.getBatteryLevel() + "%");
        System.out.println();
    }

    protected abstract void test() throws Exception;

    public class OutboundNotification
    implements IOutboundMessageNotification {
        public void process(AGateway aGateway, OutboundMessage outboundMessage) {
            System.out.println("Outbound handler called from Gateway: " + aGateway.getGatewayId());
            System.out.println(outboundMessage);
        }
    }

    public class CallNotification
    implements ICallNotification {
        public void process(AGateway aGateway, String string) {
            System.out.println(">>> New call detected from Gateway: " + aGateway.getGatewayId() + " : " + string);
        }
    }

    public class InboundNotification
    implements IInboundMessageNotification {
        public void process(AGateway aGateway, Message.MessageTypes messageTypes, InboundMessage inboundMessage) {
            if (messageTypes == Message.MessageTypes.INBOUND) {
                System.out.println(">>> New Inbound message detected from Gateway: " + aGateway.getGatewayId());
            } else if (messageTypes == Message.MessageTypes.STATUSREPORT) {
                System.out.println(">>> New Inbound Status Report message detected from Gateway: " + aGateway.getGatewayId());
            }
            System.out.println(inboundMessage);
            try {
                Service.getInstance().deleteMessage(inboundMessage);
            }
            catch (Exception exception) {
                System.out.println("Oops!!! Something gone bad...");
                exception.printStackTrace();
            }
        }
    }
}

