/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.helper;

import java.io.File;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;

public class Logger {
    private static final Logger logger = new Logger();
    org.apache.log4j.Logger log4jLogger;
    private static final String FQCN = Logger.class.getName();

    private Logger() {
        if (System.getProperties().getProperty("java.vm.name").equalsIgnoreCase("ikvm.net")) {
            File file = new File("log4j.properties");
            if (!file.exists()) {
                this.log4jLogger = null;
            } else {
                this.log4jLogger = org.apache.log4j.Logger.getLogger((String)"sendsms");
                PropertyConfigurator.configure((String)"log4j.properties");
            }
        } else {
            this.log4jLogger = org.apache.log4j.Logger.getLogger((String)"sendsms");
        }
    }

    public static Logger getInstance() {
        return logger;
    }

    public void logInfo(String string, Exception exception, String string2) {
        if (this.log4jLogger == null) {
            return;
        }
        this.log4jLogger.log(FQCN, (Priority)Level.INFO, (Object)this.formatMessage(string, string2), (Throwable)exception);
    }

    public void logWarn(String string, Exception exception, String string2) {
        if (this.log4jLogger == null) {
            return;
        }
        this.log4jLogger.log(FQCN, (Priority)Level.WARN, (Object)this.formatMessage(string, string2), (Throwable)exception);
    }

    public void logDebug(String string, Exception exception, String string2) {
        if (this.log4jLogger == null) {
            return;
        }
        this.log4jLogger.log(FQCN, (Priority)Level.DEBUG, (Object)this.formatMessage(string, string2), (Throwable)exception);
    }

    public void logError(String string, Exception exception, String string2) {
        if (this.log4jLogger == null) {
            return;
        }
        this.log4jLogger.log(FQCN, (Priority)Level.ERROR, (Object)this.formatMessage(string, string2), (Throwable)exception);
    }

    private String formatMessage(String string, String string2) {
        return string2 == null ? string : "GTW: " + string2 + ": " + string;
    }
}

