/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.web;

import cn.sendsms.InboundMessage;
import cn.sendsms.Message;
import cn.sendsms.OutboundMessage;
import cn.sendsms.helper.CommPortIdentifier;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.web.DbHelper;
import cn.sendsms.jdsmsserver.web.NetDeviceBean;
import cn.sendsms.jdsmsserver.web.NewAuth;
import cn.sendsms.jdsmsserver.web.SerialModemBean;
import cn.sendsms.jdsmsserver.web.SerialPhoneBean;
import cn.sendsms.modem.ModemGateway;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhoneInfoCache {
    private static final PhoneInfoCache cache = new PhoneInfoCache();
    private static final String prefix = "newmodem";
    private static byte id;
    private static Logger log;
    private CheckStatus status = CheckStatus.STOPPED;
    private Vector<SerialPhoneBean> devices = new Vector();
    private Vector<OutboundMessage> messages = new Vector();
    private Vector<InboundMessage> inMessages = new Vector();

    public CheckStatus getStatus() {
        return this.status;
    }

    public void setStatus(CheckStatus checkStatus) {
        this.status = checkStatus;
    }

    private PhoneInfoCache() {
        id = 1;
    }

    private synchronized void increase() {
        id = (byte)(id + 1);
    }

    public static final PhoneInfoCache getInstance() {
        return cache;
    }

    public void deleteConfiguration(SerialModemBean serialModemBean) throws ConfigurationException {
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        boolean bl = false;
        int n = 0;
        for (n = 0; n < 64; ++n) {
            if (propertiesConfiguration.getString("phoneDevice." + n, "").trim().length() == 0 || propertiesConfiguration.getString("phoneDevice." + n, "").indexOf(serialModemBean.getGatewayID() + " ,") == -1) continue;
            bl = true;
            propertiesConfiguration.clearProperty("phoneDevice." + n);
            break;
        }
        if (bl) {
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".port");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".baudrate");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".manufacturer");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".model");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".protocol");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".pin");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".inbound");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".outbound");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".smsc_number");
            propertiesConfiguration.clearProperty(serialModemBean.getGatewayID() + ".init_string");
        }
        propertiesConfiguration.save();
    }

    public void updateDeviceInfo() {
        this.status = CheckStatus.RUNNING;
        ArrayList arrayList = new ArrayList();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Enumeration<CommPortIdentifier> enumeration = CommPortIdentifier.getPortIdentifiers();
        double d = System.currentTimeMillis();
        executorService = Executors.newSingleThreadExecutor();
        ArrayList<NetDeviceBean> arrayList2 = new ArrayList<NetDeviceBean>();
        for (int i = 0; i < 64; ++i) {
            try {
                String string = "netdevice." + i;
                Object[] objectArray = JDSMSServer.getInstance().getProperties().getStringArray(string);
                if (ArrayUtils.isEmpty((Object[])objectArray)) break;
                NetDeviceBean netDeviceBean = new NetDeviceBean();
                netDeviceBean.setId((String)objectArray[0]);
                netDeviceBean.setDeviceIp(JDSMSServer.getInstance().getProperties().getString((String)objectArray[0] + ".ip"));
                netDeviceBean.setStartPort(JDSMSServer.getInstance().getProperties().getInt((String)objectArray[0] + ".startPort"));
                netDeviceBean.setEndPort(JDSMSServer.getInstance().getProperties().getInt((String)objectArray[0] + ".endPort"));
                arrayList2.add(netDeviceBean);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        double d2 = System.currentTimeMillis();
        log.info((Object)("\u603b\u5171\u68c0\u6d4b\u4e86" + this.devices.size() + "\u4e2a\u8bbe\u5907\uff0c\u8017\u65f6" + (d2 - d) / 1000.0 + "\u79d2"));
        this.status = CheckStatus.STOPPED;
    }

    public void addPhone(SerialPhoneBean serialPhoneBean) {
        this.devices.add(serialPhoneBean);
    }

    public synchronized void addMessage(OutboundMessage outboundMessage) {
        this.messages.add(outboundMessage);
    }

    public synchronized void addMessages(List<OutboundMessage> list) {
        this.messages.addAll(list);
    }

    public synchronized void addInMessage(Date date, String string, String string2, String string3, String string4, int n) throws Exception {
        String string5 = JDSMSServer.getInstance().getProperties().getString("settings.phone_using", "yes");
        if (!string5.equals("yes")) {
            return;
        }
        String string6 = PhoneInfoCache.getInstance().getUsingPhoneIMEI(string3);
        boolean bl = NewAuth.checkDeviceAuth(string6);
        if (!bl) {
            string2 = "<\u8bf7\u586b\u5199\u8bbe\u5907\u6ce8\u518c\u7801>" + string2;
            int n2 = NewAuth.getAvaliableNum(string6);
            --n2;
            try {
                if (n2 >= -1) {
                    NewAuth.updateAvaliableNum(string6, n2);
                }
                if (n2 < 1) {
                    log.warn((Object)("\u624b\u673a\u672a\u6388\u6743\uff0c\u6536\u53d1\u77ed\u4fe1\u6761\u6570\u5df2\u8fbe\u5230\u6700\u5927\u9650\u5236\u657088\u6761,\u5df2\u505c\u6b62\u6536\u53d1\u77ed\u4fe1" + string3));
                    return;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        InboundMessage inboundMessage = new InboundMessage(date, string, string2, string3);
        switch (n) {
            case 0: {
                inboundMessage.setEncoding(Message.MessageEncodings.ENC7BIT);
                break;
            }
            case 4: {
                inboundMessage.setEncoding(Message.MessageEncodings.ENC8BIT);
                break;
            }
            case 8: {
                inboundMessage.setEncoding(Message.MessageEncodings.ENCUCS2);
            }
        }
        this.inMessages.add(inboundMessage);
    }

    public List<SerialPhoneBean> getAll() throws CloneNotSupportedException {
        ArrayList<SerialPhoneBean> arrayList = new ArrayList<SerialPhoneBean>();
        for (int i = 0; i < this.devices.size(); ++i) {
            arrayList.add(this.devices.get(i));
        }
        return arrayList;
    }

    public synchronized StringBuilder getMessages(String string) throws CloneNotSupportedException {
        int n;
        int n2;
        Object object;
        int n3 = 0;
        int n4 = 0;
        long l = System.currentTimeMillis();
        for (int i = 0; i < this.messages.size(); ++i) {
            object = this.messages.get(i);
            String string2 = ((OutboundMessage)object).getUsingPhoneNo();
            if (!string.equals(((OutboundMessage)object).getUsingPhoneNo()) || this.messages.get(n3).getSendFlag() && l - this.messages.get(n3).getHandleTime() > (long)JDSMSServer.getInstance().getProperties().getInt("settings.retries_time", 120000)) continue;
            ++n4;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (n4 >= 1) {
            return stringBuilder;
        }
        object = PhoneInfoCache.getInstance().getUsingPhoneIMEI(string);
        try {
            n2 = NewAuth.checkDeviceAuth((String)object);
            if (n2 == 0 && (n = NewAuth.getAvaliableNum((String)object)) < 1) {
                log.warn((Object)("\u624b\u673a\u672a\u6388\u6743\uff0c\u6536\u53d1\u77ed\u4fe1\u6761\u6570\u5df2\u8fbe\u5230\u6700\u5927\u9650\u5236\u657088\u6761,\u5df2\u505c\u6b62\u6536\u53d1\u77ed\u4fe1" + string + " num=" + n));
                PhoneInfoCache.getInstance().setRealUsingPhoneFlag(string, "0");
                return stringBuilder;
            }
        }
        catch (Exception exception) {
            log.error((Object)("\u5224\u65ad\u624b\u673a\u6388\u6743\u4fe1\u606f\u5931\u8d25" + string));
            return stringBuilder;
        }
        n2 = JDSMSServer.getInstance().getProperties().getInt("settings.phone_msg_max_count", 0);
        for (n = 0; n < this.messages.size(); ++n) {
            block20: {
                OutboundMessage outboundMessage = this.messages.get(n);
                String string3 = outboundMessage.getGatewayId();
                if (!string3.equals(string) && !string3.equals("$")) continue;
                long l2 = System.currentTimeMillis();
                if (!this.messages.get(n3).getSendFlag() || this.messages.get(n3).getSendFlag() && l2 - this.messages.get(n3).getHandleTime() > (long)JDSMSServer.getInstance().getProperties().getInt("settings.retries_time", 120000)) {
                    try {
                        Object object2;
                        if (n2 != 0 && this.getPhoneMsgLeft(string) == -1) {
                            object2 = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
                            this.setPhoneMsgLeft(string, n2 - ((DbHelper)object2).getPhoneMsgSentCount(string));
                        }
                        if (JDSMSServer.getInstance().getphone_msg_max_count() != n2 || JDSMSServer.getInstance().isChanged()) {
                            object2 = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
                            this.setPhoneMsgLeft(string, n2 - ((DbHelper)object2).getPhoneMsgSentCount(string));
                            JDSMSServer.getInstance().setphone_msg_max_count(n2);
                            JDSMSServer.getInstance().setChangeFlag(false);
                        }
                        if (n2 == 0 || this.getPhoneMsgLeft(string) > 0) {
                            object2 = outboundMessage.getMessageId() + "";
                            String string4 = outboundMessage.getRecipient();
                            String string5 = outboundMessage.getText();
                            boolean bl = NewAuth.checkDeviceAuth((String)object);
                            if (!bl) {
                                string5 = "<\u8bf7\u586b\u5199\u8bbe\u5907\u6ce8\u518c\u7801>" + string5;
                                outboundMessage.setText(string5);
                            }
                            HashMap<String, Object> hashMap = new HashMap<String, Object>();
                            hashMap.put("id", object2);
                            hashMap.put("to", string4);
                            hashMap.put("message", string5);
                            String string6 = JSONObject.fromObject(hashMap).toString();
                            stringBuilder.append(string6 + ",");
                            if (!bl) {
                                int n5 = NewAuth.getAvaliableNum((String)object);
                                if (n5 > 0) {
                                    log.error((Object)("num =" + n5));
                                    log.debug((Object)("\u624b\u673a\u672a\u6388\u6743\uff0c\u8fd8\u53ef\u6536\u53d1" + n5 + "\u6761\u77ed\u4fe1"));
                                }
                                --n5;
                                try {
                                    NewAuth.updateAvaliableNum((String)object, n5);
                                }
                                catch (SQLException sQLException) {
                                    log.error((Object)"\u66f4\u65b0\u53ef\u53d1\u9001\u7684\u77ed\u4fe1\u6570\u76ee\u51fa\u9519");
                                }
                                if (n5 == 0) {
                                    log.warn((Object)"\u8bbe\u5907\u672a\u6388\u6743\uff0c\u6536\u53d1\u77ed\u4fe1\u6761\u6570\u5df2\u8fbe\u5230\u6700\u5927\u9650\u5236\u657088\u6761,\u5df2\u505c\u6b62\u6536\u53d1\u77ed\u4fe1");
                                    this.messages.get(n3).setSendFlag(true);
                                    this.messages.get(n3).setUsingPhoneNo(string);
                                    this.messages.get(n3).setHandleTime(System.currentTimeMillis());
                                    return stringBuilder;
                                }
                                if (n5 < 0) {
                                    log.warn((Object)"\u8bbe\u5907\u672a\u6388\u6743\uff0c\u6536\u53d1\u77ed\u4fe1\u6761\u6570\u5df2\u8fbe\u5230\u6700\u5927\u9650\u5236\u657088\u6761,\u5df2\u505c\u6b62\u6536\u53d1\u77ed\u4fe1");
                                    return new StringBuilder();
                                }
                            }
                            this.messages.get(n3).setSendFlag(true);
                            this.messages.get(n3).setUsingPhoneNo(string);
                            this.messages.get(n3).setHandleTime(System.currentTimeMillis());
                            ++n4;
                            if (n2 != 0) {
                                this.setPhoneMsgLeft(string, this.getPhoneMsgLeft(string) - 1);
                            }
                            break block20;
                        }
                        return stringBuilder;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            ++n3;
            if (n4 < Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.app_send_count", "20"))) continue;
            return stringBuilder;
        }
        return stringBuilder;
    }

    public int getPhoneMsgLeft(String string) throws Exception {
        int n = -1;
        for (int i = 0; i < this.devices.size(); ++i) {
            SerialPhoneBean serialPhoneBean = this.devices.get(i);
            if (!string.equals(serialPhoneBean.getPhoneNo())) continue;
            n = serialPhoneBean.getLeft();
            break;
        }
        return n;
    }

    public void setPhoneMsgLeft(String string, int n) throws Exception {
        for (int i = 0; i < this.devices.size(); ++i) {
            SerialPhoneBean serialPhoneBean = this.devices.get(i);
            if (!string.equals(serialPhoneBean.getPhoneNo())) continue;
            serialPhoneBean.setLeft(n);
            break;
        }
    }

    public boolean isPhoneRegistered(String string) throws Exception {
        String string2 = NewAuth.getAuthorizeInfo(string, "regcode");
        if (string2 == null || string2.indexOf("null") != -1) {
            string2 = "";
        }
        if (string2.equals("")) {
            return false;
        }
        return NewAuth.checkDeviceAuth(string);
    }

    public synchronized List<OutboundMessage> getSentMessages() {
        int n;
        ArrayList<OutboundMessage> arrayList = new ArrayList<OutboundMessage>();
        for (n = 0; n < this.messages.size(); ++n) {
            OutboundMessage outboundMessage = this.messages.get(n);
            if (!this.messages.get(n).getSendFlag() || this.messages.get(n).getMessageStatus() == OutboundMessage.MessageStatuses.UNSENT) continue;
            if (this.messages.get(n).getMessageStatus() == OutboundMessage.MessageStatuses.FAILED && this.messages.get(n).getTryTimes() >= 2) {
                arrayList.add(outboundMessage);
                continue;
            }
            if (this.messages.get(n).getMessageStatus() != OutboundMessage.MessageStatuses.SENT) continue;
            arrayList.add(outboundMessage);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.messages.removeElement(arrayList.get(n));
        }
        return arrayList;
    }

    public synchronized List<InboundMessage> getInMessages() {
        int n;
        ArrayList<InboundMessage> arrayList = new ArrayList<InboundMessage>();
        int n2 = 0;
        for (n = 0; n < this.inMessages.size(); ++n) {
            InboundMessage inboundMessage = this.inMessages.get(n);
            if (!this.inMessages.get(n2).getStoreFlag()) {
                arrayList.add(inboundMessage);
            }
            ++n2;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.inMessages.removeElement(arrayList.get(n));
        }
        return arrayList;
    }

    public int getUsingPhoneCounts() {
        int n = 0;
        for (int i = 0; i < this.devices.size(); ++i) {
            if (!this.devices.get(i).getUsingStatus().equals("1")) continue;
            ++n;
        }
        return n;
    }

    public List<String> getUsingPhoneNos() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.devices.size(); ++i) {
            SerialPhoneBean serialPhoneBean = this.devices.get(i);
            if (!serialPhoneBean.getUsingStatus().equals("1")) continue;
            String string = this.getUsingPhoneIMEI(serialPhoneBean.getPhoneNo());
            boolean bl = NewAuth.checkDeviceAuth(string);
            if (bl) {
                arrayList.add(serialPhoneBean.getPhoneNo());
                continue;
            }
            int n = NewAuth.getAvaliableNum(string);
            if (n <= 0) continue;
            arrayList.add(serialPhoneBean.getPhoneNo());
        }
        return arrayList;
    }

    public List<String> getUsingPhoneList() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.devices.size(); ++i) {
            SerialPhoneBean serialPhoneBean = this.devices.get(i);
            if (!serialPhoneBean.getUsingStatus().equals("1")) continue;
            arrayList.add(serialPhoneBean.getPhoneNo());
        }
        return arrayList;
    }

    public String getUsingPhoneIMEI(String string) {
        String string2 = "";
        for (int i = 0; i < this.devices.size(); ++i) {
            SerialPhoneBean serialPhoneBean = this.devices.get(i);
            if (!serialPhoneBean.getUsingStatus().equals("1") || !string.equals(serialPhoneBean.getPhoneNo())) continue;
            string2 = serialPhoneBean.getPhoneImei();
        }
        return string2;
    }

    public List<SerialPhoneBean> getRealUsingPhones() {
        ArrayList<SerialPhoneBean> arrayList = new ArrayList<SerialPhoneBean>();
        for (int i = 0; i < this.devices.size(); ++i) {
            SerialPhoneBean serialPhoneBean = this.devices.get(i);
            if (!serialPhoneBean.getUsingStatus().equals("1") || !"1".equals(serialPhoneBean.getRealUsingtStatus())) continue;
            arrayList.add(serialPhoneBean);
        }
        return arrayList;
    }

    public void setRealUsingPhoneFlag(String string, String string2) {
        for (int i = 0; i < this.devices.size(); ++i) {
            SerialPhoneBean serialPhoneBean = this.devices.get(i);
            if (!string.equals(serialPhoneBean.getPhoneNo())) continue;
            this.devices.get(i).setRealUsingStatus(string2);
            break;
        }
    }

    public String getPhoneIMEI(String string) {
        String string2 = "";
        for (int i = 0; i < this.devices.size(); ++i) {
            SerialPhoneBean serialPhoneBean = this.devices.get(i);
            if (!string.equals(serialPhoneBean.getPhoneNo())) continue;
            string2 = serialPhoneBean.getPhoneImei();
        }
        return string2;
    }

    public int getMessagesCounts() {
        return this.messages.size();
    }

    public synchronized void setSentMessages(long l, String string, String string2) throws CloneNotSupportedException {
        for (int i = 0; i < this.messages.size(); ++i) {
            OutboundMessage outboundMessage = this.messages.get(i);
            if (!this.messages.get(i).getSendFlag()) continue;
            System.out.println("messageid=" + this.messages.get(i).getMessageId() + " id=" + l);
            System.out.println(this.messages.get(i).getMessageId() == l);
            if (this.messages.get(i).getMessageId() != l) continue;
            if (string2.equals("sent")) {
                outboundMessage.setDispatchDate(new Date());
                outboundMessage.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
                outboundMessage.setGatewayId(string);
                continue;
            }
            if (!string2.equals("failed")) continue;
            outboundMessage.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
            outboundMessage.addTryTimes(1);
        }
    }

    public synchronized int getPhoneMsgCounts(String string) {
        int n = 0;
        for (int i = 0; i < this.messages.size(); ++i) {
            if (!string.equals(this.messages.get(i).getUsingPhoneNo())) continue;
            ++n;
        }
        return n;
    }

    public synchronized void setSentForwardMessages(String string, String string2, String string3) throws CloneNotSupportedException, IOException {
        for (int i = 0; i < this.messages.size(); ++i) {
            OutboundMessage outboundMessage = this.messages.get(i);
            if (!this.messages.get(i).getSendFlag() || !this.messages.get(i).getText().equals(string2) || !this.messages.get(i).getRecipient().equals(string) || outboundMessage.getMessageStatus().equals((Object)OutboundMessage.MessageStatuses.SENT) || !outboundMessage.getUsingPhoneNo().equals(string3)) continue;
            outboundMessage.setDispatchDate(new Date());
            outboundMessage.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
            outboundMessage.setGatewayId(string3);
            break;
        }
    }

    public List<SerialPhoneBean> getUsingPhones() {
        ArrayList<SerialPhoneBean> arrayList = new ArrayList<SerialPhoneBean>();
        for (int i = 0; i < this.devices.size(); ++i) {
            SerialPhoneBean serialPhoneBean = this.devices.get(i);
            if (!serialPhoneBean.getUsingStatus().equals("1")) continue;
            arrayList.add(serialPhoneBean);
        }
        return arrayList;
    }

    public boolean isPhoneUsing(String string) {
        for (int i = 0; i < this.devices.size(); ++i) {
            SerialPhoneBean serialPhoneBean = this.devices.get(i);
            if (!string.equals(serialPhoneBean.getPhoneNo()) || !serialPhoneBean.getUsingStatus().equals("1")) continue;
            return true;
        }
        return false;
    }

    public void setConnectStatusFalse(long l) throws CloneNotSupportedException {
        for (int i = 0; i < this.devices.size(); ++i) {
            SerialPhoneBean serialPhoneBean = this.devices.get(i);
            if (!this.devices.get(i).getConnectStatus().equals("1") || (l - serialPhoneBean.getLastShowTime()) / 1000L < (long)serialPhoneBean.getRequestInterval()) continue;
            this.devices.get(i).setConnectStatus("0");
        }
    }

    public void setUsingStatusFalse(long l) throws CloneNotSupportedException {
        for (int i = 0; i < this.devices.size(); ++i) {
            SerialPhoneBean serialPhoneBean = this.devices.get(i);
            if (!this.devices.get(i).getConnectStatus().equals("1") || (l - serialPhoneBean.getLastShowTime()) / 1000L < (long)serialPhoneBean.getRequestInterval()) continue;
            this.devices.get(i).setUsingStatus("0");
        }
    }

    public void setChargingStatusFalse(String string) throws CloneNotSupportedException {
        for (int i = 0; i < this.devices.size(); ++i) {
            if (!this.devices.get(i).getPhoneNo().equals(string)) continue;
            this.devices.get(i).setChargingStatusChanged(false);
            break;
        }
    }

    public void setPowerFalse(String string) throws CloneNotSupportedException {
        for (int i = 0; i < this.devices.size(); ++i) {
            if (!this.devices.get(i).getPhoneNo().equals(string)) continue;
            this.devices.get(i).setPowerChanged(false);
            break;
        }
    }

    public void setConnectStatusTrue(long l) throws CloneNotSupportedException {
        for (int i = 0; i < this.devices.size(); ++i) {
            SerialPhoneBean serialPhoneBean = this.devices.get(i);
            if (!this.devices.get(i).getConnectStatus().equals("0") || (l - serialPhoneBean.getLastShowTime()) / 1000L >= (long)serialPhoneBean.getRequestInterval()) continue;
            this.devices.get(i).setConnectStatus("1");
        }
    }

    public boolean setUsingtatusTrue(String string) throws CloneNotSupportedException, ConfigurationException {
        int n;
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        ArrayList<SerialPhoneBean> arrayList = new ArrayList<SerialPhoneBean>();
        for (n = 0; n < 64; ++n) {
            String string2 = "phoneDevice." + n;
            Object[] objectArray = propertiesConfiguration.getStringArray(string2);
            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
            SerialPhoneBean serialPhoneBean = new SerialPhoneBean();
            serialPhoneBean.setPhoneNo(propertiesConfiguration.getString((String)objectArray[0] + ".no"));
            serialPhoneBean.setUsingStatus(propertiesConfiguration.getString((String)objectArray[0] + ".using_status"));
            serialPhoneBean.setPhoneID((String)objectArray[0]);
            arrayList.add(serialPhoneBean);
        }
        n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            for (int j = 0; j < this.devices.size(); ++j) {
                SerialPhoneBean serialPhoneBean = this.devices.get(j);
                if (serialPhoneBean.getPhoneNo().equals(string) && ((SerialPhoneBean)arrayList.get(i)).getPhoneNo().equals(string) && ((SerialPhoneBean)arrayList.get(i)).getUsingStatus().equals("1")) {
                    this.devices.get(n2).setUsingStatus("1");
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean getUsingtatus(String string) throws CloneNotSupportedException, ConfigurationException {
        SerialPhoneBean serialPhoneBean;
        int n;
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        ArrayList<SerialPhoneBean> arrayList = new ArrayList<SerialPhoneBean>();
        for (n = 0; n < 64; ++n) {
            String string2 = "phoneDevice." + n;
            Object[] objectArray = propertiesConfiguration.getStringArray(string2);
            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
            serialPhoneBean = new SerialPhoneBean();
            serialPhoneBean.setPhoneNo(propertiesConfiguration.getString((String)objectArray[0] + ".no"));
            serialPhoneBean.setUsingStatus(propertiesConfiguration.getString((String)objectArray[0] + ".using_status"));
            serialPhoneBean.setPhoneID((String)objectArray[0]);
            arrayList.add(serialPhoneBean);
        }
        n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.devices.size(); ++j) {
                serialPhoneBean = this.devices.get(j);
                if (!serialPhoneBean.getPhoneNo().equals(string) || !serialPhoneBean.getUsingStatus().equals("1")) continue;
                return true;
            }
        }
        return false;
    }

    public void resetTime(String string) throws CloneNotSupportedException {
        for (int i = 0; i < this.devices.size(); ++i) {
            if (!this.devices.get(i).getPhoneNo().equals(string)) continue;
            this.devices.get(i).setLastShowTime(System.currentTimeMillis());
            break;
        }
    }

    public void resetRequestInterval(String string, int n) throws CloneNotSupportedException {
        for (int i = 0; i < this.devices.size(); ++i) {
            if (!this.devices.get(i).getPhoneNo().equals(string)) continue;
            this.devices.get(i).setRequestInterval(n);
            break;
        }
    }

    public void resetShowFlag() throws CloneNotSupportedException {
        for (int i = 0; i < this.devices.size(); ++i) {
            if (!this.devices.get(i).getShowFlag().equals("0")) continue;
            this.devices.get(i).setShowFlag("1");
        }
    }

    public void deletePhone(String string) throws ServletException, IOException, Exception {
        int n;
        for (n = 0; n < this.devices.size() && !this.devices.get(n).getPhoneNo().equals(string); ++n) {
        }
        PhoneInfoCache.getInstance().deletePhoneDevice(string);
        this.devices.removeElementAt(n);
    }

    public synchronized void deleteAllSendMessages() {
        for (int i = 0; i < this.messages.size(); ++i) {
            if (this.messages.get(i).getSendFlag()) continue;
            this.messages.removeElementAt(i);
        }
    }

    public boolean checkStartPhones(String string) throws ServletException, IOException {
        for (int i = 0; i < this.devices.size(); ++i) {
            if (!this.devices.get(i).getPhoneNo().equals(string) || !this.devices.get(i).getUsingStatus().equals("1") && !this.devices.get(i).getConnectStatus().equals("0")) continue;
            return false;
        }
        return true;
    }

    public boolean cheakStopPhones(String string) throws ServletException, IOException {
        for (int i = 0; i < this.devices.size(); ++i) {
            if (!this.devices.get(i).getPhoneNo().equals(string) || !this.devices.get(i).getConnectStatus().equals("0") && !this.devices.get(i).getUsingStatus().equals("0")) continue;
            return false;
        }
        return true;
    }

    public int startPhones(String string) throws ServletException, IOException {
        for (int i = 0; i < this.devices.size(); ++i) {
            if (!this.devices.get(i).getPhoneNo().equals(string) || !this.devices.get(i).getUsingStatus().equals("0") || !this.devices.get(i).getConnectStatus().equals("1")) continue;
            this.devices.get(i).setUsingStatus("1");
            return 1;
        }
        return 0;
    }

    public int stopPhones(String string) throws ServletException, IOException {
        for (int i = 0; i < this.devices.size(); ++i) {
            if (!this.devices.get(i).getPhoneNo().equals(string) || !this.devices.get(i).getUsingStatus().equals("1")) continue;
            this.devices.get(i).setUsingStatus("0");
            return 1;
        }
        return 0;
    }

    public synchronized void addPhoneDevice(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws ServletException, IOException, Exception {
        try {
            int n;
            String string8 = string3;
            long l = System.currentTimeMillis();
            int n2 = Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.phone_overtime", "0"));
            List<SerialPhoneBean> list = PhoneInfoCache.getInstance().getAll();
            int n3 = list.size();
            for (n = 0; n < n3; ++n) {
                if (list.get(n).getPhoneImei().equals(string2) && !list.get(n).getPhoneNo().equals(string8)) {
                    return;
                }
                if (list.get(n).getPhoneImei().equals(string2) || !list.get(n).getPhoneNo().equals(string8)) continue;
                return;
            }
            for (n = 0; n < n3; ++n) {
                if (!list.get(n).getPhoneNo().equals(string8)) continue;
                PhoneInfoCache.getInstance().resetTime(string8);
                PhoneInfoCache.getInstance().resetRequestInterval(string8, n2);
                PhoneInfoCache.getInstance().devices.get(n).setConnectStatus("1");
                if ("0".equals(PhoneInfoCache.getInstance().devices.get(n).getUsingStatus()) && PhoneInfoCache.getInstance().getUsingtatus(string8)) {
                    PhoneInfoCache.getInstance().devices.get(n).setUsingStatus("1");
                }
                if (!string4.equals(PhoneInfoCache.getInstance().devices.get(n).getBattery())) {
                    PhoneInfoCache.getInstance().devices.get(n).setBattery(string4);
                    PhoneInfoCache.getInstance().devices.get(n).setPowerChanged(true);
                }
                if (!string5.equals(PhoneInfoCache.getInstance().devices.get(n).getChargingStatus())) {
                    PhoneInfoCache.getInstance().devices.get(n).setChargingStatus(string5);
                    PhoneInfoCache.getInstance().devices.get(n).setChargingStatusChanged(true);
                }
                return;
            }
            SerialPhoneBean serialPhoneBean = new SerialPhoneBean();
            serialPhoneBean.setPhoneImei(string2);
            serialPhoneBean.setPhoneNo(string8);
            serialPhoneBean.setConnectStatus("1");
            serialPhoneBean.setLastShowTime(l);
            serialPhoneBean.setBattery(string4);
            serialPhoneBean.setChargingStatus(string5);
            serialPhoneBean.setDeviceInfo(string);
            serialPhoneBean.setRequestInterval(n2);
            PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
            int n4 = 0;
            Object[] objectArray = null;
            for (n4 = 0; n4 < 64 && !ArrayUtils.isEmpty((Object[])(objectArray = propertiesConfiguration.getStringArray("phoneDevice." + n4))); ++n4) {
            }
            int n5 = n4 + 1;
            propertiesConfiguration.setProperty("phoneDevice." + n4, (Object)("phone" + n5));
            serialPhoneBean.setPhoneID("phone" + n5);
            objectArray = propertiesConfiguration.getStringArray("phoneDevice." + n4);
            propertiesConfiguration.setProperty((String)objectArray[0] + ".no", (Object)serialPhoneBean.getPhoneNo());
            propertiesConfiguration.setProperty((String)objectArray[0] + ".imei", (Object)serialPhoneBean.getPhoneImei());
            propertiesConfiguration.setProperty((String)objectArray[0] + ".battery", (Object)string4);
            propertiesConfiguration.setProperty((String)objectArray[0] + ".charging", (Object)serialPhoneBean.getChargingStatus());
            propertiesConfiguration.setProperty((String)objectArray[0] + ".device_info", (Object)serialPhoneBean.getDeviceInfo());
            propertiesConfiguration.setProperty((String)objectArray[0] + ".using_status", (Object)serialPhoneBean.getUsingStatus());
            propertiesConfiguration.save();
            NewAuth.initAuthorize(string8, serialPhoneBean.getPhoneImei(), "");
            PhoneInfoCache.getInstance().addPhone(serialPhoneBean);
            PhoneInfoCache.getInstance().setRealUsingPhoneFlag(string8, "1");
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            log.error((Object)"add phone device list failed", (Throwable)cloneNotSupportedException);
        }
        catch (Exception exception) {
            log.error((Object)"\u6dfb\u52a0\u624b\u673a\u8bbe\u5907\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)exception);
            throw exception;
        }
    }

    public void deletePhoneDevice(String string) throws ServletException, IOException, Exception {
        try {
            String string2 = string;
            List<SerialPhoneBean> list = PhoneInfoCache.getInstance().getAll();
            int n = list.size();
            int n2 = 0;
            for (n2 = 0; n2 < n && !list.get(n2).getPhoneNo().equals(string2); ++n2) {
            }
            PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
            int n3 = 0;
            for (n3 = 0; n3 < 64; ++n3) {
                Object[] objectArray = propertiesConfiguration.getStringArray("phoneDevice." + n3);
                if (ArrayUtils.isEmpty((Object[])objectArray) || !((String)objectArray[0]).equals(list.get(n2).getPhoneID())) continue;
                propertiesConfiguration.clearProperty("phoneDevice." + n3);
                propertiesConfiguration.clearProperty((String)objectArray[0] + ".no");
                propertiesConfiguration.clearProperty((String)objectArray[0] + ".imei");
                propertiesConfiguration.clearProperty((String)objectArray[0] + ".battery");
                propertiesConfiguration.clearProperty((String)objectArray[0] + ".charging");
                propertiesConfiguration.clearProperty((String)objectArray[0] + ".device_info");
                propertiesConfiguration.clearProperty((String)objectArray[0] + ".using_status");
                propertiesConfiguration.save();
                break;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            log.error((Object)"delete phone device list failed", (Throwable)cloneNotSupportedException);
        }
        catch (Exception exception) {
            log.error((Object)"\u5220\u9664\u624b\u673a\u8bbe\u5907\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)exception);
            throw exception;
        }
    }

    public String getServerIp() {
        String string = "";
        InetAddress inetAddress = null;
        try {
            if (this.isWindowsOS()) {
                inetAddress = InetAddress.getLocalHost();
            } else {
                boolean bl = false;
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                block2: while (enumeration.hasMoreElements() && !bl) {
                    NetworkInterface networkInterface = enumeration.nextElement();
                    Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                    while (enumeration2.hasMoreElements()) {
                        inetAddress = enumeration2.nextElement();
                        if (!inetAddress.isSiteLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.getHostAddress().indexOf(":") != -1) continue;
                        bl = true;
                        continue block2;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (null != inetAddress) {
            string = inetAddress.getHostAddress();
        }
        return string;
    }

    public boolean isWindowsOS() {
        boolean bl = false;
        String string = System.getProperty("os.name");
        if (string.toLowerCase().indexOf("windows") > -1) {
            bl = true;
        }
        return bl;
    }

    static {
        log = Logger.getRootLogger();
    }

    public class DeviceBean {
        private SerialPhoneBean _$3;
        private ModemGateway _$2;

        public SerialPhoneBean getDeviceInfo() {
            return this._$3;
        }

        public ModemGateway getGateway() {
            return this._$2;
        }

        public void setGateway(ModemGateway modemGateway) {
            this._$2 = modemGateway;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CheckStatus {
        RUNNING,
        STOPPED;

    }
}

