/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem.athandler;

import cn.sendsms.AGateway;
import cn.sendsms.GatewayException;
import cn.sendsms.InboundMessage;
import cn.sendsms.Service;
import cn.sendsms.TimeoutException;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.helper.Logger;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.web.DeviceInfoCache;
import cn.sendsms.jdsmsserver.web.SerialModemBean;
import cn.sendsms.modem.AModemDriver;
import cn.sendsms.modem.CNMIDetector;
import cn.sendsms.modem.ModemGateway;
import cn.sendsms.modem.athandler.AATHandler;
import cn.sendsms.util.GSM0338;
import java.io.IOException;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ATHandler
extends AATHandler {
    protected Pattern delLineSeparatorAfterCMGR = Pattern.compile("(\\+CMGR:.*?)[\r|\n]{1,}");
    protected AModemDriver modemDriver;
    protected CNMIDetector cnmiDetector;
    protected static final int DEFAULT_USSD_DCS_NUM = 15;

    public String getCXXCID() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CXXCID\r");
        String string = this.getModemDriver().getResponse();
        return string;
    }

    public String getCSQ() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CSQ\r");
        String string = this.getModemDriver().getResponse();
        return string;
    }

    public int getCSQValue() throws TimeoutException, GatewayException, IOException, InterruptedException {
        String string = this.getCSQ();
        if (string == null) {
            return 0;
        }
        if (string.length() < 2) {
            return 0;
        }
        String string2 = "\\+CSQ:\\s*\\d{1,2},\\s*\\d{1,2}";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return 0;
        }
        String string3 = matcher.group(0);
        int n = string3.indexOf("+CSQ:");
        int n2 = string3.indexOf(",", n);
        String string4 = string3.substring(n + 5, n2).trim();
        int n3 = Integer.parseInt(string4);
        return n3;
    }

    public void checkMode() throws TimeoutException, GatewayException, IOException, InterruptedException {
    }

    public String getCCID() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CCID\r");
        String string = this.getModemDriver().getResponse();
        return string;
    }

    public AModemDriver getModemDriver() {
        return this.modemDriver;
    }

    public ATHandler(ModemGateway modemGateway) {
        super(modemGateway);
        this.modemDriver = modemGateway.getModemDriver();
        this.cnmiDetector = null;
        this.terminators = new String[15];
        this.terminators[0] = "OK\\s";
        this.terminators[1] = "\\s*[\\p{ASCII}]*\\s+OK\\s";
        this.terminators[2] = "\\s*(ERROR|NO CARRIER|NO DIALTONE)\\s";
        this.terminators[3] = "ERROR:\\s*\\d+\\s";
        this.terminators[4] = "[>]*([\\s\\S]*)\\+CM[ES]\\s+ERROR:\\s*\\d+\\s*";
        this.terminators[5] = "\\s*[\\p{ASCII}]*\\s*\\+CPIN:\\s*READY\\s";
        this.terminators[6] = "\\+CPIN:\\s*SIM\\s*BUSY\\s";
        this.terminators[7] = "\\+CPIN:\\s*SIM\\s*PIN\\s";
        this.terminators[8] = "\\+CPIN:\\s*SIM\\s*PIN2\\s";
        this.terminators[9] = "fge";
        this.terminators[10] = "\\+CUSD:\\s.*\\s";
        this.terminators[11] = "[>]*([\\s\\S]*)\\+CMTI:\\s*\\p{Punct}[\\p{ASCII}]+\\p{Punct}\\p{Punct}\\s*\\d+\\s*([\\s\\S]*)";
        this.terminators[12] = "\\+CDSI:\\s*\\p{Punct}[\\p{ASCII}]+\\p{Punct}\\p{Punct}\\s*\\d+\\s";
        this.terminators[13] = "RING";
        this.terminators[14] = "\\+CLIP:\\s*\\p{Punct}[\\p{ASCII}]*\\p{Punct}\\p{Punct}\\s*\\d+[\\p{ASCII}]*\\s*";
        this.unsolicitedResponses = new String[5];
        this.unsolicitedResponses[0] = "+CMTI";
        this.unsolicitedResponses[1] = "+CDSI";
        this.unsolicitedResponses[2] = "RING";
        this.unsolicitedResponses[3] = "+CLIP";
        this.unsolicitedResponses[4] = "+CUSD";
    }

    public void sync() throws IOException, InterruptedException {
        this.getModemDriver().write("ATZ\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
    }

    public int getSimNums() throws TimeoutException, GatewayException, IOException, InterruptedException {
        if ("1".equals(JDSMSServer.getInstance().getProperties().getString("settings.sendfirst", "1"))) {
            return 0;
        }
        this.getModemDriver().write("AT+CPMS?\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        String string = this.getModemDriver().getResponse();
        int n = 0;
        int n2 = string.indexOf("CPMS");
        if (n2 != -1) {
            int n3 = string.indexOf(",", n2);
            int n4 = string.indexOf(",", n3 + 1);
            n = Integer.valueOf(string.substring(n3 + 1, n4));
        }
        return n;
    }

    public void reset() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().clearBuffer();
    }

    public void echoOff() throws IOException, InterruptedException {
        this.getModemDriver().write("ATE0\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().clearBuffer();
    }

    public void init() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CLIP=1\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CNMI=1,1,0,1,1\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().getResponse();
        SerialModemBean serialModemBean = DeviceInfoCache.getInstance().get(this.getGateway().getGatewayId());
        if (serialModemBean.getManufacturer().equalsIgnoreCase("Quectel") && serialModemBean.getModel().equalsIgnoreCase("EC20F")) {
            this.getModemDriver().write("AT+QCFG=\"nwscanmode\",0,1\r");
            this.threadWait(Service.getInstance().getSettings().AT_WAIT);
            this.getModemDriver().getResponse();
            this.getModemDriver().write("AT+QCFG=\"nwscanseq\",04,1\r");
            this.threadWait(Service.getInstance().getSettings().AT_WAIT);
            this.getModemDriver().getResponse();
        } else if (serialModemBean.getManufacturer().equals("INCORPORATED") && serialModemBean.getModel().equals("SIMCOM_SIM7600CE_L")) {
            this.getModemDriver().write("AT+CNMP=38\r");
            this.threadWait(Service.getInstance().getSettings().AT_WAIT);
            this.getModemDriver().getResponse();
        }
    }

    public String readTextMode() throws GatewayException, TimeoutException, IOException, InterruptedException {
        return "";
    }

    public void done() throws TimeoutException, GatewayException, IOException, InterruptedException {
    }

    public boolean isAlive() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT\r");
        this.threadWait(200L);
        String string = this.getModemDriver().getResponse();
        Logger.getInstance().logInfo("isAlive\u8fd4\u56de" + string, null, this.getGateway().getGatewayId());
        if (string.indexOf("OK") != -1 || string.indexOf("ok") != -1) {
            return true;
        }
        if (string.indexOf("AT\r") == -1) {
            return this.getModemDriver().isOk();
        }
        return false;
    }

    public static String toHexString(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            String string3 = Integer.toHexString(c);
            string2 = string2 + string3;
        }
        return string2;
    }

    public String getSimStatus() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CPIN?\r");
        return this.getModemDriver().getResponse();
    }

    public boolean enterPin(String string) throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CPIN=\"_1_\"\r".replaceAll("_1_", string));
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    public boolean setVerboseErrors() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CMEE=1\r");
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    public boolean setPduProtocol() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CMGF=0\r");
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    public boolean setTextProtocol() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CMGF=1\r");
        this.getModemDriver().getResponse();
        if (this.getModemDriver().isOk()) {
            this.getModemDriver().write("AT+CSCS=\"GSM\"\r");
            this.getModemDriver().getResponse();
            return this.getModemDriver().isOk();
        }
        return false;
    }

    public boolean setIndications() throws TimeoutException, GatewayException, IOException, InterruptedException {
        int n = 10;
        for (int i = 0; i < n; ++i) {
            this.getModemDriver().write("AT+CNMI=?\r");
            try {
                this.cnmiDetector = new CNMIDetector(this.getModemDriver().getResponse());
                this.getModemDriver().write(this.cnmiDetector.getATCommand());
                this.getModemDriver().getResponse();
                return this.getModemDriver().isOk();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Logger.getInstance().logWarn("Retrying the detection of CNMI, modem busy?", null, this.getGateway().getGatewayId());
                this.threadWait(Service.getInstance().getSettings().AT_WAIT_CNMI);
                continue;
            }
        }
        Logger.getInstance().logWarn("CNMI detection failed, proceeding with defaults.", null, this.getGateway().getGatewayId());
        return false;
    }

    public CNMIDetector getIndications() {
        return this.cnmiDetector;
    }

    public String getManufacturer() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CGMI\r");
        return this.getModemDriver().getResponse();
    }

    public String getModel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CGMM\r");
        return this.getModemDriver().getResponse();
    }

    public String getSerialNo() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CGSN\r");
        return this.getModemDriver().getResponse();
    }

    public String getImsi() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CIMI\r");
        return this.getModemDriver().getResponse();
    }

    public String getSwVersion() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CGMR\r");
        return this.getModemDriver().getResponse();
    }

    public String getBatteryLevel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CBC\r");
        return this.getModemDriver().getResponse();
    }

    public String getSignalLevel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CSQ\r");
        return this.getModemDriver().getResponse();
    }

    public boolean switchStorageLocation(String string) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (string.equalsIgnoreCase("--")) {
            return true;
        }
        this.getModemDriver().write("ATE0\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CPMS=\"" + string + "\",\"" + string + "\",\"" + string + "\"\r");
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    public void switchToCmdMode() throws IOException, InterruptedException {
        this.getModemDriver().write("+++");
        Date date = new Date();
        while (new Date().getTime() - date.getTime() <= (long)Service.getInstance().getSettings().AT_WAIT_CMD) {
            this.threadWait(100L);
        }
    }

    public void keepLinkOpen() throws TimeoutException, GatewayException, IOException, InterruptedException {
        block0: {
            if (Service.getInstance().getSettings().DISABLE_CMMS) break block0;
            boolean bl = false;
            this.getModemDriver().write("AT+CMMS=2\r");
            this.threadWait(Service.getInstance().getSettings().AT_WAIT);
            String string = this.getModemDriver().getResponse();
        }
    }

    public int sendMessage(int n, String string, String string2, String string3) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int n2 = -1;
        if (this.getGateway().getProtocol() == AGatewayHelper.Protocols.PDU) {
            int n3 = 0;
            SerialModemBean serialModemBean = DeviceInfoCache.getInstance().get(this.getGateway().getGatewayId());
            if (serialModemBean != null && serialModemBean.getManufacturer().equals("Wavecom")) {
                this.getModemDriver().write("AT+CMGF?\r");
                String string4 = this.getModemDriver().getResponse();
                if (string4.indexOf("CMGF: 1") != -1) {
                    Logger.getInstance().logError("pdu\u7f16\u7801\u53d1\u751f\u9519\u8bef,\u91cd\u65b0\u521d\u59cb\u5316\u7f16\u7801", null, this.getGateway().getGatewayId());
                    this.setPduProtocol();
                }
            }
            long l = 3600 / Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.send_speed", "600")) * 1000;
            while (this.getGateway().getStatus() == AGatewayHelper.GatewayStatuses.STARTED) {
                int n4 = 0;
                this.getModemDriver().write("AT+CMGS=\"_1_\"\r".replaceAll("\"_1_\"", "" + n));
                if (!this.threadWait(Service.getInstance().getSettings().AT_WAIT_CGMS)) break;
                while (!this.getModemDriver().dataAvailable() && this.getGateway().getStatus() == AGatewayHelper.GatewayStatuses.STARTED) {
                    if (++n4 == Service.getInstance().getSettings().OUTBOUND_RES_RETRIES) {
                        Logger.getInstance().logError("\u54cd\u5e94\u91cd\u8bd5\u8d85\u8fc7\u6700\u5927\u6b21\u6570", null, this.getGateway().getGatewayId());
                        throw new GatewayException("Gateway is not responding, max number of retries reached.");
                    }
                    Logger.getInstance().logWarn("ATHandler().SendMessage(): Still waiting for response (I) (" + n4 + ")...", null, this.getGateway().getGatewayId());
                    if (this.threadWait((long)Service.getInstance().getSettings().OUTBOUND_RETRY_WAIT + l)) continue;
                }
                if (this.getGateway().getStatus() != AGatewayHelper.GatewayStatuses.STARTED) {
                    n2 = -1;
                    break;
                }
                n4 = 0;
                this.getModemDriver().write(string);
                this.getModemDriver().write('\u001a');
                String string5 = this.getModemDriver().getResponse();
                int n5 = 0;
                Logger.getInstance().logDebug("debug------\u6b21\u6570\u662f\uff08\u65e0\u5faa\u73af\uff09\uff1a" + String.valueOf(n5++), null, null);
                Logger.getInstance().logDebug("debug------\u7ed3\u679c\u662f\uff08\u65e0\u5faa\u73af\uff09\uff1a" + string5, null, null);
                while (string5.length() == 0 && this.getGateway().getStatus() == AGatewayHelper.GatewayStatuses.STARTED) {
                    if (++n4 == Service.getInstance().getSettings().OUTBOUND_RES_RETRIES) {
                        Logger.getInstance().logError("\u54cd\u5e94\u91cd\u8bd5\u8d85\u8fc7\u6700\u5927\u6b21\u6570", null, this.getGateway().getGatewayId());
                        throw new GatewayException("Gateway is not responding, max number of retries reached.");
                    }
                    Logger.getInstance().logWarn("ATHandler().SendMessage(): Still waiting for response (II) (" + n4 + ")...", null, this.getGateway().getGatewayId());
                    if (!this.threadWait((long)Service.getInstance().getSettings().OUTBOUND_RETRY_WAIT + l)) break;
                    string5 = this.getModemDriver().getResponse();
                    Logger.getInstance().logDebug("debug------\u6b21\u6570\u662f(\u8fdb\u5faa\u73af)\uff1a", null, String.valueOf(n5++));
                    Logger.getInstance().logDebug("debug------\u7ed3\u679c\u662f(\u8fdb\u5faa\u73af)\uff1a", null, string5);
                }
                if (this.getGateway().getStatus() != AGatewayHelper.GatewayStatuses.STARTED) {
                    n2 = -1;
                    break;
                }
                if (this.getModemDriver().getLastError() == 0) {
                    Matcher matcher = Pattern.compile("\\s*\\+CMGS: *(\\d+)").matcher(string5);
                    n2 = matcher.find() ? Integer.parseInt(matcher.group(1)) : -1;
                    break;
                }
                if (this.getModemDriver().getLastError() > 0) {
                    if (this.getModemDriver().getLastErrorText().indexOf("unknown") >= 0) {
                        Logger.getInstance().logError("\u51fa\u73b0\u672a\u77e5\u9519\u8bef\u7aef\u53e3\u91cd\u542f", null, this.getGateway().getGatewayId());
                        this.getGateway().setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                        if (!this.threadWait(10000L)) break;
                    }
                    if (this.getModemDriver().getLastErrorText().indexOf("CMS Error 305") >= 0) {
                        Logger.getInstance().logError("\u6a21\u5757\u51fa\u73b0\u7f16\u7801\u9519\u8befCMS ERROR: 305", null, this.getGateway().getGatewayId());
                        this.setPduProtocol();
                    }
                    if (++n3 == Service.getInstance().getSettings().OUTBOUND_RETRIES) {
                        Logger.getInstance().logError(this.getModemDriver().getLastErrorText() + ": Quit retrying, message lost...", null, this.getGateway().getGatewayId());
                        n2 = -1;
                    } else {
                        Logger.getInstance().logWarn(string5 + ": Retrying...", null, this.getGateway().getGatewayId());
                        if (this.threadWait((long)Service.getInstance().getSettings().OUTBOUND_RETRY_WAIT + l)) continue;
                    }
                    break;
                }
                n2 = -1;
            }
        } else if (this.getGateway().getProtocol() == AGatewayHelper.Protocols.TEXT) {
            this.getModemDriver().write("AT+CMGS=\"_1_\"\r".replaceAll("_1_", string2));
            this.getModemDriver().clearBuffer();
            this.getModemDriver().write(GSM0338.encode(string3));
            this.threadWait(Service.getInstance().getSettings().AT_WAIT_CGMS);
            this.getModemDriver().write('\u001a');
            String string6 = this.getModemDriver().getResponse();
            if (string6.indexOf("OK\r") >= 0) {
                StringBuilder stringBuilder = new StringBuilder();
                int n6 = string6.indexOf(":");
                while (!Character.isDigit(string6.charAt(n6))) {
                    ++n6;
                }
                while (Character.isDigit(string6.charAt(n6))) {
                    stringBuilder.append(string6.charAt(n6));
                    ++n6;
                }
                n2 = Integer.parseInt(stringBuilder.toString());
            } else {
                n2 = -1;
            }
        }
        return n2;
    }

    public String listMessages(InboundMessage.MessageClasses messageClasses) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getGateway().getProtocol() == AGatewayHelper.Protocols.PDU) {
            if (messageClasses == InboundMessage.MessageClasses.ALL) {
                this.getModemDriver().write("AT+CMGL=4\r");
            } else if (messageClasses == InboundMessage.MessageClasses.UNREAD) {
                this.getModemDriver().write("AT+CMGL=0\r");
            } else if (messageClasses == InboundMessage.MessageClasses.READ) {
                this.getModemDriver().write("AT+CMGL=1\r");
            }
        } else if (this.getGateway().getProtocol() == AGatewayHelper.Protocols.TEXT) {
            if (messageClasses == InboundMessage.MessageClasses.ALL) {
                this.getModemDriver().write("AT+CMGL=\"ALL\"\r");
            } else if (messageClasses == InboundMessage.MessageClasses.UNREAD) {
                this.getModemDriver().write("AT+CMGL=\"REC UNREAD\"\r");
            } else if (messageClasses == InboundMessage.MessageClasses.READ) {
                this.getModemDriver().write("AT+CMGL=\"REC READ\"\r");
            }
        }
        return this.getModemDriver().getResponse();
    }

    public String getMessageByIndex(int n) throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CMGR=" + n + "\r");
        return this.getModemDriver().getResponse();
    }

    public boolean deleteMessage(int n, String string) throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().write("AT+CMGD=_1_\r".replaceAll("_1_", "" + n));
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    public String getGprsStatus() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CGATT?\r");
        return this.getModemDriver().getResponse();
    }

    public String send(String string) throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write(string);
        return this.getModemDriver().getResponse();
    }

    public String getNetworkRegistration() throws GatewayException, TimeoutException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CREG=1\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CREG?\r");
        return this.getModemDriver().getResponse();
    }

    public void readStorageLocations() throws Exception {
        this.getModemDriver().write("AT+CPMS=?\r");
        String string = this.getModemDriver().getResponse();
        try {
            this.addStorageLocation("SM");
        }
        catch (Exception exception) {
            this.addStorageLocation("SM");
            Logger.getInstance().logWarn("CPMS detection failed, proceeding with default storage 'SM'.", null, this.getGateway().getGatewayId());
        }
    }

    public String readPhonebookLocations() throws GatewayException, TimeoutException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CPBS=?\r");
        String string = this.getModemDriver().getResponse();
        if (string.indexOf("+CPBS:") >= 0) {
            string = string.replaceAll("\\s*\\+CPBS:\\s*", "");
            string = string.replaceAll("[()]", "");
            return string;
        }
        return "";
    }

    public String readPhonebook(String string) throws GatewayException, TimeoutException, IOException {
        try {
            this.getModemDriver().write("AT+CPBS=\"" + string + "\"\r");
            this.getModemDriver().getResponse();
            this.getModemDriver().write("AT+CPBR=?\r");
            String string2 = this.getModemDriver().getResponse();
            string2 = string2.replaceAll("\\s*\\+CPBR:\\s*", "");
            string2 = string2.replaceAll("[()]", "");
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "-");
            int n = Integer.parseInt(stringTokenizer2.nextToken());
            int n2 = Integer.parseInt(stringTokenizer2.nextToken());
            this.getModemDriver().write("AT+CPBR=" + n + "," + n2 + "\r");
            string2 = this.getModemDriver().getResponse();
            return string2;
        }
        catch (Exception exception) {
            Logger.getInstance().logWarn("Phonebook detection failed.", null, this.getGateway().getGatewayId());
            return "";
        }
    }

    public String sendCustomATCommand(String string) throws GatewayException, TimeoutException, IOException, InterruptedException {
        this.threadWait(Service.getInstance().getSettings().AT_WAIT4M35);
        this.getModemDriver().write(string);
        this.threadWait(Service.getInstance().getSettings().AT_WAIT4M35);
        return this.getModemDriver().getResponse();
    }

    public String sendUSSDCommand(String string) throws GatewayException, TimeoutException, IOException, InterruptedException {
        return this.sendUSSDCommand(string, false);
    }

    public String sendUSSDCommand(String string, boolean bl) throws GatewayException, TimeoutException, IOException, InterruptedException {
        String string2;
        Pattern pattern;
        Matcher matcher;
        String string3 = this.formatUSSDCommand(string);
        String string4 = this.sendCustomATCommand(string3);
        if (!string4.contains("OK")) {
            Logger.getInstance().logError("+CUSD command returned non-OK result: " + string4, null, this.getGateway().getGatewayId());
            return null;
        }
        string4 = new String(this.getModemDriver().getResponse(AGateway.AsyncEvents.USSDRESPONSE));
        if (!bl) {
            char c = '\u001b';
            string3 = "" + c + '\r';
            this.getModemDriver().write(string3);
            this.getModemDriver().clearBuffer();
        }
        String string5 = (matcher = (pattern = Pattern.compile(string2 = "\"(.*)\"")).matcher(string4)).find() ? this.formatUSSDResponse(matcher.group(1)) : string4;
        return string5;
    }

    public boolean sendUSSDRequest(String string, String string2, String string3) throws GatewayException, TimeoutException, IOException, InterruptedException {
        String string4 = this.formatUSSDCommand(string, string2, string3);
        String string5 = this.sendCustomATCommand(string4);
        if (!string5.contains("OK")) {
            Logger.getInstance().logError("+CUSD command returned non-OK result: " + string5, null, this.getGateway().getGatewayId());
            return false;
        }
        return true;
    }

    protected String formatUSSDCommand(String string) {
        return this.formatUSSDCommand("1", string, null);
    }

    protected String formatUSSDCommand(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AT+CUSD=");
        stringBuffer.append(string);
        stringBuffer.append(",");
        stringBuffer.append("\"");
        stringBuffer.append(string2);
        stringBuffer.append("\"");
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append(",");
            stringBuffer.append(string3);
        }
        stringBuffer.append("\r");
        return stringBuffer.toString();
    }

    public String formatUSSDResponse(String string) {
        return string;
    }

    public AGateway.AsyncEvents processUnsolicitedEvents(String string) throws IOException {
        AGateway.AsyncEvents asyncEvents = AGateway.AsyncEvents.NOTHING;
        if (string.indexOf(this.getUnsolicitedResponse(0)) >= 0) {
            asyncEvents = AGateway.AsyncEvents.INBOUNDMESSAGE;
        } else if (string.indexOf(this.getUnsolicitedResponse(1)) >= 0) {
            asyncEvents = AGateway.AsyncEvents.INBOUNDSTATUSREPORTMESSAGE;
        } else if (string.indexOf(this.getUnsolicitedResponse(2)) >= 0) {
            asyncEvents = AGateway.AsyncEvents.NOTHING;
        } else if (string.indexOf(this.getUnsolicitedResponse(3)) >= 0) {
            asyncEvents = AGateway.AsyncEvents.INBOUNDCALL;
        } else if (string.indexOf(this.getUnsolicitedResponse(4)) >= 0) {
            asyncEvents = AGateway.AsyncEvents.USSDRESPONSE;
        }
        return asyncEvents;
    }

    public String getSerialNumber() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Logger.getInstance().logInfo("TO SEND AT+WMSN (3)", null, null);
        this.getModemDriver().write("AT+WMSN\r");
        return this.getModemDriver().getResponse();
    }

    public int getTextSplitNum(String string) {
        return 0;
    }

    public void modifyMMSRemindWay() throws IOException, InterruptedException {
    }
}

