/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem.athandler;

import cn.ajwcc.pduUtils.gsm3040.Pdu;
import cn.ajwcc.pduUtils.gsm3040.PduParser;
import cn.ajwcc.pduUtils.gsm3040.SmsDeliveryPdu;
import cn.sendsms.GatewayException;
import cn.sendsms.InboundMessage;
import cn.sendsms.Service;
import cn.sendsms.TimeoutException;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.modem.ModemGateway;
import cn.sendsms.modem.athandler.ATHandler;
import cn.sendsms.tools.TimeChecker;
import cn.sendsms.util.Logger;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;

public class ATHandler_TDTech_MH5000
extends ATHandler {
    private long _$4;

    public ATHandler_TDTech_MH5000(ModemGateway modemGateway) {
        super(modemGateway);
        this.setStorageLocations("SM");
    }

    public void init() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT^CURC=0\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CLIP=1\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CSMS=1\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CNMI=1,1,0,1,0\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CREG=0\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CPMS=\"SM\",\"SM\",\"SM\"\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().getResponse();
    }

    public void reset() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().clearBuffer();
    }

    public int findMatchingTerminator(String string) {
        if (string.indexOf("OK") != -1) {
            return 0;
        }
        for (int i = 0; i < this.terminators.length; ++i) {
            if (!string.matches(this.terminators[i])) continue;
            return i;
        }
        return -1;
    }

    public String getCCID() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT^ICCID?\r");
        String string = this.getModemDriver().getResponse();
        return string;
    }

    public String readTextMode() throws GatewayException, TimeoutException, IOException, InterruptedException {
        this.threadWait(2000L);
        this.getModemDriver().write("AT+CREG?\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        return this.getModemDriver().getResponse();
    }

    public String listMessages(InboundMessage.MessageClasses messageClasses) throws TimeoutException, GatewayException, IOException, InterruptedException {
        long l = TimeChecker.currentMilliSeconds();
        if (this._$4 <= 0L) {
            this._$4 = l - 870000L;
        }
        if (l - this._$4 < 0L || l - this._$4 > 900000L) {
            this._$4 = l;
            this.getModemDriver().write("AT+CFUN=0,0\r");
            this.threadWait(5000L);
            this.getModemDriver().write("AT+CFUN=1,0\r");
            this.threadWait(10000L);
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.getModemDriver().write("AT+CMGD=?\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        String string = this.getModemDriver().getResponse();
        int n = string.indexOf("(");
        int n2 = string.indexOf(")");
        Logger.getInstance().logInfo("listMessages = " + string, null, null);
        String string2 = "";
        if (n + 1 < n2) {
            String string3;
            int n3;
            String[] stringArray = string.substring(n + 1, n2).split(",");
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; stringArray != null && i < stringArray2.length; ++i) {
                stringArray2[i] = "";
            }
            PduParser pduParser = new PduParser();
            for (n3 = 0; this.getGateway().getStatus() == AGatewayHelper.GatewayStatuses.STARTED && stringArray != null && n3 < stringArray.length; ++n3) {
                string3 = stringArray[n3];
                try {
                    string2 = "";
                    string = "";
                    this.getModemDriver().write("ATE0\r");
                    this.threadWait(Service.getInstance().getSettings().AT_WAIT);
                    this.getModemDriver().write("AT+CMGR=" + string3 + "\r");
                    this.threadWait(Service.getInstance().getSettings().AT_WAIT);
                    string = this.getModemDriver().getResponse();
                    if (string.indexOf("+CMGR") >= 0) {
                        int n4;
                        Matcher matcher = this.delLineSeparatorAfterCMGR.matcher(string = string.substring(string.indexOf("+CMGR")));
                        if (matcher.find()) {
                            string = string.replace(matcher.group(), matcher.group(1) + "\r");
                        }
                        String string4 = string.trim();
                        Logger.getInstance().logInfo("\u6536\u5230\u77ed\u4fe1:" + string4, null, null);
                        int n5 = string4.indexOf("\n");
                        if (n5 == -1) {
                            n5 = string4.indexOf("\r");
                        }
                        if ((n4 = string4.lastIndexOf("\nOK")) == -1) {
                            n4 = string4.lastIndexOf("\rOK");
                        }
                        string2 = string4 = string4.substring(n5 + 1, n4).replaceFirst("[\r|\n]+", "");
                        Pdu pdu = pduParser.parsePdu(string4);
                        String string5 = "";
                        if (pdu instanceof SmsDeliveryPdu) {
                            string5 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(((SmsDeliveryPdu)pdu).getTimestamp());
                        }
                        stringBuilder.append(string.replace("CMGR:", "CMGL: " + string3 + ",").replaceFirst("\n*OK.*", ""));
                        stringArray2[n3] = string3;
                        continue;
                    }
                    Logger.getInstance().logError("\u8bfb\u53d6" + string3 + "\u4f4d\u7f6e\u7684\u77ed\u4fe1\u5f02\u5e38: index: " + string, null, this.getGateway().getGatewayId());
                    continue;
                }
                catch (Exception exception) {
                    Logger.getInstance().logError("\u8bfb\u53d6" + string3 + "\u4f4d\u7f6e\u7684\u77ed\u4fe1\u65f6\u51fa\u9519", exception, this.getGateway().getGatewayId());
                    Logger.getInstance().logError("index : " + string, null, this.getGateway().getGatewayId());
                    Logger.getInstance().logError("parse : " + string2, null, this.getGateway().getGatewayId());
                }
            }
            for (n3 = 0; this.getGateway().getStatus() == AGatewayHelper.GatewayStatuses.STARTED && stringArray != null && n3 < stringArray2.length; ++n3) {
                string3 = stringArray2[n3];
                try {
                    if (string3.isEmpty()) continue;
                    this.getModemDriver().write("AT+CMGD=" + string3 + "\r");
                    this.threadWait(Service.getInstance().getSettings().AT_WAIT);
                    this._$4 = TimeChecker.currentMilliSeconds();
                    continue;
                }
                catch (Exception exception) {
                    Logger.getInstance().logError("\u5220\u9664" + string3 + "\u4f4d\u7f6e\u7684\u77ed\u4fe1\u65f6\u9519\u8bef", null, this.getGateway().getGatewayId());
                }
            }
        }
        stringBuilder.append("\nOK");
        return stringBuilder.toString();
    }

    public boolean deleteMessage(int n, String string) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return true;
    }
}

