/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.driver.nbiotDriver;

import cn.sendsms.otherModem.bean.NbIoTBean;
import cn.sendsms.otherModem.common.Utils;
import cn.sendsms.otherModem.driver.ModemDriver;
import cn.sendsms.otherModem.driver.nbiotDriver.BC26NbIoTDriver;
import cn.sendsms.otherModem.driver.nbiotDriver.M5310ANbIoTDriver;
import cn.sendsms.otherModem.driver.nbiotDriver.QBC32NbIoTDriver;
import cn.sendsms.otherModem.driver.nbiotDriver.SIM7020CNbIoTDriver;
import cn.sendsms.otherModem.driver.nbiotDriver.VirtualNbIoTDriver;
import cn.sendsms.otherModem.driver.nbiotDriver.XYM110NBIoTDriver;
import cn.sendsms.otherModem.nbiot.NbIoTDeviceInfoGetter;
import cn.sendsms.otherModem.nbiot.NbIoTMessageHolder;
import java.util.List;
import jssc.SerialPort;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NbIoTDriver
extends ModemDriver {
    public static final Logger log = Logger.getRootLogger();
    public static NbIoTDeviceInfoGetter nbiotDeviceInfoGetter = NbIoTDeviceInfoGetter.getInstance();
    public static NbIoTMessageHolder nbiotMessageHolder = NbIoTMessageHolder.getInstance();

    @Override
    public boolean startDevice(String string) {
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(string);
        SerialPort serialPort = nbiotDeviceInfoGetter.getSerialPort(string);
        if (!Utils.openPort(nbIoTBean.getBaudrate(), serialPort)) {
            nbIoTBean.setUsingStatus("0");
            return false;
        }
        if (!this.isDeviceAT(serialPort)) {
            log.error((Object)("\u8bbe\u5907\u3010" + nbIoTBean.getGatewayID() + "\u4e0dAT\uff01"));
            return false;
        }
        nbIoTBean.setAT(true);
        this.commandNotEcho(serialPort);
        this.disconnectMQTTServer(serialPort);
        if (!this.isNetworkNormal(serialPort)) {
            log.error((Object)"\u7f51\u7edc\u5f02\u5e38\u3002\u3002\u3002");
            this.stopDevice(nbIoTBean.getPortID());
            return false;
        }
        nbIoTBean.setSignal(this.getSignal(serialPort));
        if (!this.connectSucessed(string)) {
            log.error((Object)"MQTT\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25...");
            this.stopDevice(nbIoTBean.getPortID());
            return false;
        }
        if (!nbIoTBean.getDeviceType().equals("SIM7020C") && "1".equals(nbIoTBean.getUsingStatus())) {
            log.info((Object)"\u5df2\u7ecf\u8ba2\u9605\u8fc7\uff0c\u4e0d\u518d\u91cd\u590d\u8ba2\u9605\uff01\u3010\u542f\u52a8\u3011");
            return true;
        }
        if (!nbIoTBean.getDeviceType().equals("XYM110") && "1".equals(nbIoTBean.getUsingStatus())) {
            log.info((Object)"\u5df2\u7ecf\u8ba2\u9605\u8fc7\uff0c\u4e0d\u518d\u91cd\u590d\u8ba2\u9605\uff01\u3010\u542f\u52a8\u3011");
            return true;
        }
        if (!this.subSucessed(string)) {
            log.error((Object)"\u8ba2\u9605\u901a\u4fe1ID\u5931\u8d25...");
            this.stopDevice(nbIoTBean.getPortID());
            return false;
        }
        nbIoTBean.setUsingStatus("1");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restartDevice(String string) {
        SerialPort serialPort;
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(string);
        if (nbIoTBean == null) {
            log.error((Object)("\u7aef\u53e3" + string + "\u5bf9\u5e94 \u7684\u8bbe\u5907\u672a\u627e\u5230\u3002\u3002\u3002"));
            return false;
        }
        SerialPort serialPort2 = serialPort = nbiotDeviceInfoGetter.getSerialPort(string);
        synchronized (serialPort2) {
            if (serialPort == null) {
                log.error((Object)("\u7aef\u53e3" + string + "\u672a\u627e\u5230\u3002\u3002\u3002"));
                return false;
            }
            Utils.closePort(serialPort);
            if (!Utils.openPort(nbIoTBean.getBaudrate(), serialPort)) {
                log.error((Object)("\u7aef\u53e3" + string + "\u6253\u5f00\u5931\u8d25\u3002\u3002\u3002"));
                return false;
            }
            this.commandNotEcho(serialPort);
            this.disconnectMQTTServer(serialPort);
            this.initDevice(serialPort);
            this.commandNotEcho(serialPort);
            if (!this.isNetworkNormal(serialPort)) {
                log.error((Object)"\u7f51\u7edc\u5f02\u5e38\u3002\u3002\u3002");
                return false;
            }
            nbIoTBean.setSignal(this.getSignal(serialPort));
            if (!this.connectSucessed(string)) {
                log.error((Object)"\u91cd\u542f\u8bbe\u5907\u65f6MQTT\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25");
                return false;
            }
            if (!nbIoTBean.getDeviceType().equals("SIM7020C") && "1".equals(nbIoTBean.getUsingStatus())) {
                log.info((Object)"\u5df2\u7ecf\u8ba2\u9605\u8fc7\uff0c\u4e0d\u518d\u91cd\u590d\u8ba2\u9605\uff01\u3010\u91cd\u8fde\u3011");
                return true;
            }
            if (!nbIoTBean.getDeviceType().equals("XYM110") && "1".equals(nbIoTBean.getUsingStatus())) {
                log.info((Object)"\u5df2\u7ecf\u8ba2\u9605\u8fc7\uff0c\u4e0d\u518d\u91cd\u590d\u8ba2\u9605\uff01\u3010\u91cd\u8fde\u3011");
                return true;
            }
            if (!this.subSucessed(string)) {
                log.error((Object)"\u91cd\u542f\u8bbe\u5907\u65f6\u8ba2\u9605\u901a\u4fe1ID\u5931\u8d25:");
                return false;
            }
            nbIoTBean.setUsingStatus("1");
            return true;
        }
    }

    public abstract boolean connectSucessed(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stopDevice(String string) {
        SerialPort serialPort;
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(string);
        if (nbIoTBean == null) {
            log.info((Object)("\u7aef\u53e3" + string + "\u4e0d\u5b58\u5728\u3002\u3002\u3002"));
            return true;
        }
        SerialPort serialPort2 = serialPort = nbiotDeviceInfoGetter.getSerialPort(string);
        synchronized (serialPort2) {
            if (serialPort == null) {
                nbIoTBean.setUsingStatus("0");
                return true;
            }
            this.disconnectMQTTServer(serialPort);
            if (Utils.closePort(serialPort)) {
                nbIoTBean.setUsingStatus("0");
            } else if (!serialPort.isOpened()) {
                log.info((Object)("\u7aef\u53e3" + string + "\u5173\u95ed\u6210\u529f"));
                nbIoTBean.setUsingStatus("0");
            } else {
                log.error((Object)("\u7aef\u53e3" + string + "\u5173\u95ed\u5931\u8d25"));
                nbIoTBean.setUsingStatus("1");
                return false;
            }
        }
        return true;
    }

    public abstract boolean isCompleteMessages(byte[] var1, NbIoTBean var2, List<String> var3, List<String> var4);

    public abstract String getCommunicationID(String var1);

    public abstract boolean sendMessage(String var1, String var2, NbIoTBean var3);

    public abstract void commandNotEcho(SerialPort var1);

    public abstract boolean subSucessed(String var1);

    public abstract void disconnectMQTTServer(SerialPort var1);

    public abstract boolean networkNormal(SerialPort var1);

    public abstract boolean initDevice(SerialPort var1);

    public abstract boolean isDeviceAT(SerialPort var1);

    public boolean isNetworkNormal(SerialPort serialPort) {
        boolean bl = false;
        if (serialPort == null) {
            return bl;
        }
        int n = 0;
        while (NbIoTDriver.serialportConnected(serialPort)) {
            if (this.networkNormal(serialPort)) {
                bl = true;
                break;
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                log.error((Object)"\u68c0\u6d4b\u7f51\u7edc\u65f6\uff0c\u7b49\u5f85\u88ab\u4e2d\u65ad\u4e86\u3002\u3002\u3002");
            }
            if (++n <= 10) continue;
            break;
        }
        return bl;
    }

    public abstract void getCompleteMessages(byte[] var1, SerialPort var2, NbIoTBean var3, String var4);

    public static final NbIoTDriver getNbIoTDriver(String string) {
        if (string.equals("XYM110")) {
            return XYM110NBIoTDriver.getInstance();
        }
        if (string.equals("SIM7020C")) {
            return SIM7020CNbIoTDriver.getInstance();
        }
        if (string.equals("M5310-A")) {
            return M5310ANbIoTDriver.getInstance();
        }
        if (string.equals("Quectel_BC26")) {
            return BC26NbIoTDriver.getInstance();
        }
        if (string.equals("JD-VITUAL-NBIOT-DEVICE")) {
            return VirtualNbIoTDriver.getInstance();
        }
        if (string.equals("Quectel_BC32-B8")) {
            return QBC32NbIoTDriver.getInstance();
        }
        return null;
    }

    public static boolean checkAT(SerialPort serialPort) {
        if (serialPort.getPortName().matches("Vitual-[0-9]+-COM")) {
            return true;
        }
        if (!NbIoTDriver.execAtCommand(null, serialPort, "AT\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            log.info((Object)"\u7b49\u5f85AT\u54cd\u5e94\u65f6\u88ab\u6253\u65ad");
        }
        String string = ModemDriver.getStrResponse(serialPort, false, "", "UTF-8");
        if (string.indexOf("OK") != -1) {
            return true;
        }
        log.info((Object)("AT\u5f02\u5e38, \u8fd4\u56de:" + string));
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            log.info((Object)"\u7b49\u5f85AT\u54cd\u5e94\u65f6\u88ab\u6253\u65ad");
        }
        if (!NbIoTDriver.execAtCommand(null, serialPort, "AT\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            log.info((Object)"\u7b49\u5f85AT\u54cd\u5e94\u65f6\u88ab\u6253\u65ad");
        }
        string = ModemDriver.getStrResponse(serialPort, false, "", "UTF-8");
        if (string.indexOf("OK") != -1) {
            return true;
        }
        log.info((Object)("AT\u5f02\u5e38, \u8fd4\u56de:" + string));
        return false;
    }

    public static String checkDeviceType(SerialPort serialPort) {
        if (serialPort.getPortName().matches("Vitual-[0-9]+-COM")) {
            return "JD-VITUAL-NBIOT-DEVICE";
        }
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        NbIoTDriver.execAtCommand(nbIoTBean, serialPort, "AT+CGMM\r", "UTF-8");
        String string = ModemDriver.getStrResponse(serialPort, false, "\\S+OK", "UTF-8");
        string = Utils.deleteSuffix(string, "OK");
        string = string.replace("AT+CGMM", "");
        if (Utils.isEmptyStr(string)) {
            return "";
        }
        return string;
    }
}

