/*
 * Decompiled with CFR 0.152.
 */
package cn.ajwcc.pduUtils.gsm3040;

import cn.ajwcc.pduUtils.gsm3040.Pdu;
import cn.ajwcc.pduUtils.gsm3040.SmsDeliveryPdu;
import cn.ajwcc.pduUtils.gsm3040.SmsStatusReportPdu;
import cn.ajwcc.pduUtils.gsm3040.SmsSubmitPdu;
import cn.ajwcc.pduUtils.wappush.WapSiPdu;

public class PduFactory {
    public static SmsSubmitPdu newSmsSubmitPdu() {
        int additionalFields = 16;
        return PduFactory.newSmsSubmitPdu(additionalFields);
    }

    public static SmsSubmitPdu newSmsSubmitPdu(int additionalFields) {
        int firstOctet = 1 | additionalFields;
        return (SmsSubmitPdu)PduFactory.createPdu(firstOctet);
    }

    public static WapSiPdu newWapSiPdu() {
        int additionalFields = 16;
        return PduFactory.newWapSiPdu(additionalFields);
    }

    public static WapSiPdu newWapSiPdu(int additionalFields) {
        WapSiPdu pdu;
        int firstOctet = 1 | additionalFields;
        int messageType = PduFactory.getFirstOctetField(firstOctet, 252);
        switch (messageType) {
            case 1: {
                pdu = new WapSiPdu();
                break;
            }
            default: {
                throw new RuntimeException("Invalid TP-MTI value: " + messageType);
            }
        }
        pdu.setFirstOctet(firstOctet);
        return pdu;
    }

    public static SmsSubmitPdu newSmsDeliveryPdu() {
        int firstOctet = 4;
        return (SmsSubmitPdu)PduFactory.createPdu(firstOctet);
    }

    public static SmsDeliveryPdu newSmsDeliveryPdu(int additionalFields) {
        int firstOctet = 0 | additionalFields;
        return (SmsDeliveryPdu)PduFactory.createPdu(firstOctet);
    }

    private static int getFirstOctetField(int firstOctet, int fieldName) {
        return firstOctet & ~fieldName;
    }

    public static Pdu createPdu(int firstOctet) {
        Pdu pdu = null;
        int messageType = PduFactory.getFirstOctetField(firstOctet, 252);
        switch (messageType) {
            case 0: {
                pdu = new SmsDeliveryPdu();
                break;
            }
            case 2: {
                pdu = new SmsStatusReportPdu();
                break;
            }
            case 1: {
                pdu = new SmsSubmitPdu();
                break;
            }
            default: {
                throw new RuntimeException("Invalid TP-MTI value: " + messageType);
            }
        }
        pdu.setFirstOctet(firstOctet);
        return pdu;
    }
}

