/*
 * Decompiled with CFR 0.152.
 */
package cn.ajwcc.pduUtils.gsm3040;

import cn.ajwcc.pduUtils.gsm3040.Pdu;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.util.BitSet;

public class PduUtils {
    private static final char[][] grcAlphabetRemapping = new char[][]{{'\u0386', 'A'}, {'\u0388', 'E'}, {'\u0389', 'H'}, {'\u038a', 'I'}, {'\u038c', 'O'}, {'\u038e', 'Y'}, {'\u038f', '\u03a9'}, {'\u0390', 'I'}, {'\u0391', 'A'}, {'\u0392', 'B'}, {'\u0393', '\u0393'}, {'\u0394', '\u0394'}, {'\u0395', 'E'}, {'\u0396', 'Z'}, {'\u0397', 'H'}, {'\u0398', '\u0398'}, {'\u0399', 'I'}, {'\u039a', 'K'}, {'\u039b', '\u039b'}, {'\u039c', 'M'}, {'\u039d', 'N'}, {'\u039e', '\u039e'}, {'\u039f', 'O'}, {'\u03a0', '\u03a0'}, {'\u03a1', 'P'}, {'\u03a3', '\u03a3'}, {'\u03a4', 'T'}, {'\u03a5', 'Y'}, {'\u03a6', '\u03a6'}, {'\u03a7', 'X'}, {'\u03a8', '\u03a8'}, {'\u03a9', '\u03a9'}, {'\u03aa', 'I'}, {'\u03ab', 'Y'}, {'\u03ac', 'A'}, {'\u03ad', 'E'}, {'\u03ae', 'H'}, {'\u03af', 'I'}, {'\u03b0', 'Y'}, {'\u03b1', 'A'}, {'\u03b2', 'B'}, {'\u03b3', '\u0393'}, {'\u03b4', '\u0394'}, {'\u03b5', 'E'}, {'\u03b6', 'Z'}, {'\u03b7', 'H'}, {'\u03b8', '\u0398'}, {'\u03b9', 'I'}, {'\u03ba', 'K'}, {'\u03bb', '\u039b'}, {'\u03bc', 'M'}, {'\u03bd', 'N'}, {'\u03be', '\u039e'}, {'\u03bf', 'O'}, {'\u03c0', '\u03a0'}, {'\u03c1', 'P'}, {'\u03c2', '\u03a3'}, {'\u03c3', '\u03a3'}, {'\u03c4', 'T'}, {'\u03c5', 'Y'}, {'\u03c6', '\u03a6'}, {'\u03c7', 'X'}, {'\u03c8', '\u03a8'}, {'\u03c9', '\u03a9'}, {'\u03ca', 'I'}, {'\u03cb', 'Y'}, {'\u03cc', 'O'}, {'\u03cd', 'Y'}, {'\u03ce', '\u03a9'}};
    private static final char[] extAlphabet = new char[]{'\f', '^', '{', '}', '\\', '[', '~', ']', '|', '\u20ac'};
    private static final String[] extBytes = new String[]{"1b0a", "1b14", "1b28", "1b29", "1b2f", "1b3c", "1b3d", "1b3e", "1b40", "1b65"};
    private static final char[] stdAlphabet = new char[]{'@', '\u00a3', '$', '\u00a5', '\u00e8', '\u00e9', '\u00f9', '\u00ec', '\u00f2', '\u00c7', '\n', '\u00d8', '\u00f8', '\r', '\u00c5', '\u00e5', '\u0394', '_', '\u03a6', '\u0393', '\u039b', '\u03a9', '\u03a0', '\u03a8', '\u03a3', '\u0398', '\u039e', '\u00a0', '\u00c6', '\u00e6', '\u00df', '\u00c9', ' ', '!', '\"', '#', '\u00a4', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '\u00a1', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c4', '\u00d6', '\u00d1', '\u00dc', '\u00a7', '\u00bf', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00e4', '\u00f6', '\u00f1', '\u00fc', '\u00e0'};
    public static final int TP_MTI_MASK = 252;
    public static final int TP_MTI_SMS_DELIVER = 0;
    public static final int TP_MTI_SMS_SUBMIT = 1;
    public static final int TP_MTI_SMS_STATUS_REPORT = 2;
    public static final int TP_RD_MASK = 251;
    public static final int TP_RD_ACCEPT_DUPLICATES = 0;
    public static final int TP_RD_REJECT_DUPLICATES = 4;
    public static final int TP_MMS_MASK = 251;
    public static final int TP_MMS_NO_MESSAGES = 0;
    public static final int TP_MMS_MORE_MESSAGES = 4;
    public static final int TP_VPF_MASK = 231;
    public static final int TP_VPF_NONE = 0;
    public static final int TP_VPF_INTEGER = 16;
    public static final int TP_VPF_TIMESTAMP = 24;
    public static final int TP_SRI_MASK = 223;
    public static final int TP_SRI_NO_REPORT = 0;
    public static final int TP_SRI_REPORT = 32;
    public static final int TP_SRR_MASK = 223;
    public static final int TP_SRR_NO_REPORT = 0;
    public static final int TP_SRR_REPORT = 32;
    public static final int TP_UDHI_MASK = 191;
    public static final int TP_UDHI_NO_UDH = 0;
    public static final int TP_UDHI_WITH_UDH = 64;
    public static final int ADDRESS_NUMBER_PLAN_ID_MASK = 15;
    public static final int ADDRESS_NUMBER_PLAN_ID_UNKNOWN = 0;
    public static final int ADDRESS_NUMBER_PLAN_ID_TELEPHONE = 1;
    public static final int ADDRESS_TYPE_MASK = 112;
    public static final int ADDRESS_TYPE_UNKNOWN = 0;
    public static final int ADDRESS_TYPE_INTERNATIONAL = 16;
    public static final int ADDRESS_TYPE_ALPHANUMERIC = 80;
    public static final int DCS_CODING_GROUP_MASK = 15;
    public static final int DCS_CODING_GROUP_DATA = 240;
    public static final int DCS_CODING_GROUP_GENERAL = 192;
    public static final int DCS_ENCODING_MASK = 243;
    public static final int DCS_ENCODING_7BIT = 0;
    public static final int DCS_ENCODING_8BIT = 4;
    public static final int DCS_ENCODING_UCS2 = 8;
    public static final int DCS_MESSAGE_CLASS_MASK = 236;
    public static final int DCS_MESSAGE_CLASS_NONE = 0;
    public static final int DCS_MESSAGE_CLASS_FLASH = 16;
    public static final int DCS_MESSAGE_CLASS_ME = 17;
    public static final int DCS_MESSAGE_CLASS_SIM = 18;
    public static final int DCS_MESSAGE_CLASS_TE = 19;

    public static String getMultiCharFor(char c2) {
        switch (c2) {
            case '\n': {
                return "'\f'";
            }
            case '\u039b': {
                return "^";
            }
            case '(': {
                return "{";
            }
            case ')': {
                return "}";
            }
            case '/': {
                return "\\";
            }
            case '<': {
                return "[";
            }
            case '=': {
                return "~";
            }
            case '>': {
                return "]";
            }
            case '\u00a1': {
                return "|";
            }
            case 'e': {
                return "\u20ac";
            }
        }
        return "";
    }

    public static int getAddressTypeFor(String address) {
        boolean international = false;
        if (address.startsWith("+")) {
            international = true;
            address = address.substring(1);
        }
        for (int i2 = 0; i2 < address.length(); ++i2) {
            if (Character.isDigit(address.charAt(i2))) continue;
            return PduUtils.createAddressType(80);
        }
        if (international) {
            return PduUtils.createAddressType(17);
        }
        return PduUtils.createAddressType(1);
    }

    public static int extractAddressType(int addressType) {
        return addressType & 0x70;
    }

    public static int extractNumberPlan(int addressType) {
        return addressType & 0xF;
    }

    public static int createAddressType(int addressType) {
        return 0x80 | addressType;
    }

    public static int extractDcsEncoding(int dataCodingScheme) {
        return dataCodingScheme & 0xFFFFFF0C;
    }

    public static int extractDcsClass(int dataCodingScheme) {
        return dataCodingScheme & 0xFFFFFF13;
    }

    public static int extractDcsFlash(int dataCodingScheme) {
        return dataCodingScheme & 0xFFFFFF13;
    }

    public static int extractDcsCodingGroup(int dataCodingScheme) {
        return dataCodingScheme & 0xFFFFFFF0;
    }

    private static Integer getTpField(Pdu pdu, String fieldName) {
        try {
            Method m2 = pdu.getClass().getMethod("get" + fieldName, new Class[0]);
            return (Integer)m2.invoke((Object)pdu, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Boolean hasTpField(Pdu pdu, String fieldName) {
        try {
            Method m2 = pdu.getClass().getMethod("has" + fieldName, new Class[0]);
            return (Boolean)m2.invoke((Object)pdu, new Object[0]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String decodeFirstOctet(Pdu pdu) {
        StringBuffer sb = new StringBuffer();
        sb.append("First Octet: " + PduUtils.byteToPdu(pdu.getFirstOctet()));
        sb.append(" [");
        switch (pdu.getTpMti()) {
            case 0: {
                sb.append("TP-MTI: (SMS-DELIVER)");
                break;
            }
            case 2: {
                sb.append("TP-MTI: (SMS-STATUS REPORT)");
                break;
            }
            case 1: {
                sb.append("TP-MTI: (SMS-SUBMIT)");
                break;
            }
            default: {
                throw new RuntimeException("Invalid message type");
            }
        }
        if (PduUtils.hasTpField(pdu, "TpMms") != null) {
            if (PduUtils.hasTpField(pdu, "TpMms").booleanValue()) {
                sb.append(", TP-MMS: (Has more messages)");
            } else {
                sb.append(", TP-MMS: (has no messages)");
            }
        }
        if (PduUtils.hasTpField(pdu, "TpRd") != null) {
            if (PduUtils.hasTpField(pdu, "TpRd").booleanValue()) {
                sb.append(", TP-RD: (Reject duplicates)");
            } else {
                sb.append(", TP-RD: (allow duplicates)");
            }
        }
        if (PduUtils.hasTpField(pdu, "TpVpf") != null && PduUtils.hasTpField(pdu, "TpVpf").booleanValue()) {
            switch (PduUtils.getTpField(pdu, "TpVpf")) {
                case 16: {
                    sb.append(", TP-VPF: (validity format, integer");
                    break;
                }
                case 24: {
                    sb.append(", TP-VPF: (validity format, timestamp");
                    break;
                }
                case 0: {
                    sb.append(", TP-VPF: (validity format, none)");
                }
            }
        }
        if (PduUtils.hasTpField(pdu, "TpSri") != null) {
            if (PduUtils.hasTpField(pdu, "TpSri").booleanValue()) {
                sb.append(", TP-SRI: (Requests Status Report)");
            } else {
                sb.append(", TP-SRI: (No Status Report)");
            }
        }
        if (PduUtils.hasTpField(pdu, "TpSrr") != null) {
            if (PduUtils.hasTpField(pdu, "TpSrr").booleanValue()) {
                sb.append(", TP-SRR: (Requests Status Report)");
            } else {
                sb.append(", TP-SRR: (No Status Report)");
            }
        }
        if (pdu.hasTpUdhi()) {
            sb.append(", TP-UDHI: (has UDH)");
        } else {
            sb.append(", TP-UDHI: (no UDH)");
        }
        sb.append("]");
        sb.append("\n");
        return sb.toString();
    }

    public static String decodeDataCodingScheme(Pdu pdu) {
        StringBuffer sb = new StringBuffer();
        switch (PduUtils.extractDcsEncoding(pdu.getDataCodingScheme())) {
            case 0: {
                sb.append("7-bit GSM Alphabet");
                break;
            }
            case 4: {
                sb.append("8-bit encoding");
                break;
            }
            case 8: {
                sb.append("UCS2 encoding");
            }
        }
        if ((pdu.getDataCodingScheme() & 0xFFFFFF3F) == 0) {
            switch (PduUtils.extractDcsClass(pdu.getDataCodingScheme())) {
                case 16: {
                    sb.append(", (Flash Message)");
                    break;
                }
                case 17: {
                    sb.append(", (Class1 ME Message)");
                    break;
                }
                case 18: {
                    sb.append(", (Class2 SIM Message)");
                    break;
                }
                case 19: {
                    sb.append(", (Class3 TE Message)");
                }
            }
        }
        return sb.toString();
    }

    public static byte[] encode8bitUserData(String text) {
        try {
            return text.getBytes("ISO8859_1");
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static byte[] hexStr2ByteArr(String strIn) {
        try {
            byte[] arrB = strIn.getBytes();
            int iLen = arrB.length;
            byte[] arrOut = new byte[iLen / 2];
            for (int i2 = 0; i2 < iLen; i2 += 2) {
                String strTmp = new String(arrB, i2, 2);
                arrOut[i2 / 2] = (byte)Integer.parseInt(strTmp, 16);
            }
            return arrOut;
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static byte[] convertByteArr(byte[] arrB) {
        try {
            boolean bSingle = false;
            int iLen = arrB.length;
            if (iLen % 2 != 0) {
                ++iLen;
                bSingle = true;
            }
            byte[] arrOut = new byte[iLen / 2];
            for (int i2 = 0; i2 < iLen; i2 += 2) {
                String strTmp = null;
                strTmp = bSingle && i2 == iLen - 2 ? new String(arrB, i2, 1) : new String(arrB, i2, 2);
                arrOut[i2 / 2] = (byte)Integer.parseInt(strTmp, 16);
            }
            return arrOut;
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static String byteArr2HexStr(byte[] udhData, byte[] arrB) {
        try {
            int udhLength = udhData == null ? 0 : udhData.length;
            byte[] effectiveUDArray = null;
            if (udhLength != 0) {
                effectiveUDArray = new byte[arrB.length - udhLength];
                System.arraycopy(arrB, udhLength, effectiveUDArray, 0, effectiveUDArray.length);
                arrB = effectiveUDArray;
            }
            int iLen = arrB.length;
            StringBuffer sb = new StringBuffer(iLen * 2);
            for (int i2 = 0; i2 < iLen; ++i2) {
                int intTmp;
                for (intTmp = arrB[i2]; intTmp < 0; intTmp += 256) {
                }
                if (intTmp < 16) {
                    sb.append("0");
                }
                sb.append(Integer.toString(intTmp, 16));
            }
            return sb.toString();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static byte[] encodeUcs2UserData(String text) {
        try {
            return text.getBytes("UTF-16BE");
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static byte[] encode7bitUserData(byte[] udhOctets, byte[] textSeptets) {
        if (udhOctets == null) {
            return PduUtils.unencodedSeptetsToEncodedSeptets(textSeptets);
        }
        byte[] udhSeptets = PduUtils.encodedSeptetsToUnencodedSeptets(udhOctets, false);
        byte[] combined = new byte[udhSeptets.length + textSeptets.length];
        System.arraycopy(udhSeptets, 0, combined, 0, udhSeptets.length);
        System.arraycopy(textSeptets, 0, combined, udhSeptets.length, textSeptets.length);
        return PduUtils.unencodedSeptetsToEncodedSeptets(combined);
    }

    public static String decode7bitEncoding(byte[] encodedPduData) {
        return PduUtils.decode7bitEncoding(null, encodedPduData);
    }

    public static String decode7bitEncoding(byte[] udhData, byte[] encodedPduData) {
        int udhLength;
        int n2 = udhLength = udhData == null ? 0 : udhData.length;
        if (udhLength == 0) {
            return PduUtils.unencodedSeptetsToString(PduUtils.encodedSeptetsToUnencodedSeptets(encodedPduData));
        }
        String decodedUdh = PduUtils.unencodedSeptetsToString(PduUtils.encodedSeptetsToUnencodedSeptets(udhData, false));
        String decoded = PduUtils.unencodedSeptetsToString(PduUtils.encodedSeptetsToUnencodedSeptets(encodedPduData));
        return decoded.substring(decodedUdh.length());
    }

    public static String decode8bitEncoding(byte[] udhData, byte[] pduData) {
        try {
            int udhLength = udhData == null ? 0 : udhData.length;
            return new String(pduData, udhLength, pduData.length - udhLength, "ISO8859_1");
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static String decodeUcs2Encoding(byte[] udhData, byte[] pduData) {
        try {
            int udhLength = udhData == null ? 0 : udhData.length;
            return new String(pduData, udhLength, pduData.length - udhLength, "UTF-16");
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static byte swapNibbles(int b2) {
        return (byte)(b2 << 4 & 0xF0 | b2 >>> 4 & 0xF);
    }

    public static String readBCDNumbers(int numDigits, byte[] addressData) {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < addressData.length; ++i2) {
            byte b2 = addressData[i2];
            int num1 = b2 & 0xF;
            sb.append(num1);
            int num2 = b2 >>> 4 & 0xF;
            if (num2 == 15) continue;
            sb.append(num2);
        }
        return sb.toString();
    }

    public static int createSwappedBCD(int decimal) {
        int tens = (decimal & 0xFF) / 10;
        int ones = (decimal & 0xFF) - tens * 10;
        return ones << 4 | tens;
    }

    public static String stringToPdu(String txt) {
        byte[] txtBytes = PduUtils.stringToUnencodedSeptets(txt);
        return PduUtils.bytesToPdu(PduUtils.unencodedSeptetsToEncodedSeptets(txtBytes));
    }

    public static byte[] stringToUnencodedSeptets(String s) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int k2 = 0;
        block0: for (int i2 = 0; i2 < s.length(); ++i2) {
            int j2;
            char ch = s.charAt(i2);
            int index = -1;
            for (j2 = 0; j2 < extAlphabet.length; ++j2) {
                if (extAlphabet[j2] != ch) continue;
                index = j2;
                break;
            }
            if (index != -1) {
                baos.write((byte)Integer.parseInt(extBytes[index].substring(0, 2), 16));
                ++k2;
                baos.write((byte)Integer.parseInt(extBytes[index].substring(2, 4), 16));
                ++k2;
                continue;
            }
            index = -1;
            for (j2 = 0; j2 < stdAlphabet.length; ++j2) {
                if (stdAlphabet[j2] != ch) continue;
                index = j2;
                baos.write((byte)j2);
                ++k2;
                break;
            }
            if (index != -1) continue;
            for (j2 = 0; j2 < grcAlphabetRemapping.length; ++j2) {
                if (grcAlphabetRemapping[j2][0] != ch) continue;
                index = j2;
                ch = grcAlphabetRemapping[j2][1];
                break;
            }
            if (index != -1) {
                for (j2 = 0; j2 < stdAlphabet.length; ++j2) {
                    if (stdAlphabet[j2] != ch) continue;
                    index = j2;
                    baos.write((byte)j2);
                    ++k2;
                    continue block0;
                }
                continue;
            }
            baos.write(32);
            ++k2;
        }
        return baos.toByteArray();
    }

    public static byte[] unencodedSeptetsToEncodedSeptets(byte[] septetBytes) {
        int j2;
        int i2;
        byte[] txtBytes = septetBytes;
        int txtBytesLen = txtBytes.length;
        BitSet bits = new BitSet();
        for (i2 = 0; i2 < txtBytesLen; ++i2) {
            for (j2 = 0; j2 < 7; ++j2) {
                if ((txtBytes[i2] & 1 << j2) == 0) continue;
                bits.set(i2 * 7 + j2);
            }
        }
        int encodedSeptetByteArrayLength = txtBytesLen * 7 / 8 + (txtBytesLen * 7 % 8 != 0 ? 1 : 0);
        byte[] txtSeptets = new byte[encodedSeptetByteArrayLength];
        for (i2 = 0; i2 < encodedSeptetByteArrayLength; ++i2) {
            for (j2 = 0; j2 < 8; ++j2) {
                int n2 = i2;
                txtSeptets[n2] = (byte)(txtSeptets[n2] | (byte)((bits.get(i2 * 8 + j2) ? 1 : 0) << j2));
            }
        }
        return txtSeptets;
    }

    public static int getNumMultiCharsInSeptets(byte[] bytes) {
        int count = 0;
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            if (bytes[i2] != 27) continue;
            ++count;
        }
        return count;
    }

    public static String unencodedSeptetsToString(byte[] bytes) {
        StringBuffer text = new StringBuffer();
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            if (bytes[i2] == 27) {
                if (i2 >= bytes.length - 1) continue;
                String extChar = "1b" + Integer.toHexString(bytes[++i2]);
                for (int j2 = 0; j2 < extBytes.length; ++j2) {
                    if (!extBytes[j2].equalsIgnoreCase(extChar)) continue;
                    text.append(extAlphabet[j2]);
                }
                continue;
            }
            text.append(stdAlphabet[bytes[i2]]);
        }
        return text.toString();
    }

    public static String encodedSeptetsToString(byte[] encodedSeptets) {
        return PduUtils.unencodedSeptetsToString(PduUtils.encodedSeptetsToUnencodedSeptets(encodedSeptets));
    }

    public static int getNumSeptetsForOctets(int numOctets) {
        return numOctets * 8 / 7 + (numOctets * 8 % 7 != 0 ? 1 : 0);
    }

    public static byte[] encodedSeptetsToUnencodedSeptets(byte[] octetBytes) {
        return PduUtils.encodedSeptetsToUnencodedSeptets(octetBytes, true);
    }

    public static byte[] encodedSeptetsToUnencodedSeptets(byte[] octetBytes, boolean discardLast) {
        int value2;
        int j2;
        int i2;
        BitSet bitSet = new BitSet(octetBytes.length * 8);
        int value1 = 0;
        for (i2 = 0; i2 < octetBytes.length; ++i2) {
            for (j2 = 0; j2 < 8; ++j2) {
                value1 = i2 * 8 + j2;
                if ((octetBytes[i2] & 1 << j2) == 0) continue;
                bitSet.set(value1);
            }
        }
        if ((value2 = ++value1 / 7 + (value1 % 7 != 0 ? 1 : 0)) == 0) {
            ++value2;
        }
        byte[] newBytes = new byte[value2];
        for (i2 = 0; i2 < value2; ++i2) {
            for (j2 = 0; j2 < 7; ++j2) {
                if (value1 + 1 <= i2 * 7 + j2 || !bitSet.get(i2 * 7 + j2)) continue;
                int n2 = i2;
                newBytes[n2] = (byte)(newBytes[n2] | (byte)(1 << j2));
            }
        }
        if (discardLast && newBytes[newBytes.length - 1] == 0) {
            byte[] retVal = new byte[newBytes.length - 1];
            System.arraycopy(newBytes, 0, retVal, 0, retVal.length);
            return retVal;
        }
        return newBytes;
    }

    public static byte[] pduToBytes(String s) {
        byte[] bytes = new byte[s.length() / 2];
        for (int i2 = 0; i2 < s.length(); i2 += 2) {
            bytes[i2 / 2] = (byte)Integer.parseInt(s.substring(i2, i2 + 2), 16);
        }
        return bytes;
    }

    public static String pduToBits(String pduString) {
        return PduUtils.bytesToBits(PduUtils.pduToBytes(pduString));
    }

    public static String bytesToPdu(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            sb.append(PduUtils.byteToPdu(bytes[i2] & 0xFF));
        }
        return sb.toString();
    }

    public static String bytesToBits(byte[] b2) {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < b2.length; ++i2) {
            String bits = Integer.toBinaryString(b2[i2] & 0xFF);
            while (bits.length() < 8) {
                bits = "0" + bits;
            }
            if (i2 > 0) {
                sb.append(" ");
            }
            sb.append(bits);
        }
        return sb.toString();
    }

    public static String byteToBits(byte b2) {
        String bits = Integer.toBinaryString(b2 & 0xFF);
        while (bits.length() < 8) {
            bits = "0" + bits;
        }
        return bits;
    }

    public static String byteToPdu(int b2) {
        StringBuffer sb = new StringBuffer();
        String s = Integer.toHexString(b2 & 0xFF);
        if (s.length() == 1) {
            sb.append("0");
        }
        sb.append(s);
        return sb.toString().toUpperCase();
    }
}

