/*
 * Decompiled with CFR 0.152.
 */
package cn.ajwcc.pduUtils.gsm3040;

import cn.ajwcc.pduUtils.gsm3040.Pdu;
import cn.ajwcc.pduUtils.gsm3040.PduUtils;
import java.util.Calendar;
import java.util.Date;

public class SmsStatusReportPdu
extends Pdu {
    private int a = 0;
    private int b = 0;
    private Calendar c;
    private Calendar d;

    SmsStatusReportPdu() {
    }

    public void setTpMms(int value) {
        this.checkTpMti(new int[]{0, 2});
        this.setFirstOctetField(251, value, new int[]{4, 0});
    }

    public boolean hasTpMms() {
        this.checkTpMti(new int[]{0, 2});
        return this.getFirstOctetField(251) == 4;
    }

    public void setTpSri(int value) {
        this.setFirstOctetField(223, value, new int[]{0, 32});
    }

    public boolean hasTpSri() {
        return this.getFirstOctetField(223) == 32;
    }

    public void setMessageReference(int reference) {
        this.a = reference;
    }

    public int getMessageReference() {
        return this.a;
    }

    public void setStatus(int status) {
        this.b = status;
    }

    public int getStatus() {
        return this.b;
    }

    public void setTimestamp(Calendar timestamp) {
        this.c = timestamp;
    }

    public Date getTimestamp() {
        return this.c.getTime();
    }

    public Calendar getTimestampAsCalendar() {
        return this.c;
    }

    public void setDischargeTime(Calendar myDischargeTime) {
        this.d = myDischargeTime;
    }

    public Date getDischargeTime() {
        return this.d.getTime();
    }

    public Calendar getDischargeTimeAsCalendar() {
        return this.d;
    }

    @Override
    protected String pduSubclassInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("Message Reference: " + PduUtils.byteToPdu(this.getMessageReference()));
        sb.append("\n");
        if (this.getAddress() != null) {
            sb.append("Destination Address: [Length: " + this.getAddress().length() + " (" + PduUtils.byteToPdu((byte)this.getAddress().length()) + ")");
            sb.append(", Type: " + PduUtils.byteToPdu(this.getAddressType()) + " (" + PduUtils.byteToBits((byte)this.getAddressType()) + ")");
            sb.append(", Address: " + this.getAddress());
            sb.append("]");
        } else {
            sb.append("Destination Address: [Length: 0");
            sb.append(", Type: " + PduUtils.byteToPdu(this.getAddressType()) + " (" + PduUtils.byteToBits((byte)this.getAddressType()) + ")");
            sb.append("]");
        }
        sb.append("\n");
        sb.append("TP-SCTS: " + this.formatTimestamp(this.getTimestampAsCalendar()));
        sb.append("\n");
        sb.append("Discharge Time: " + this.formatTimestamp(this.getDischargeTimeAsCalendar()));
        sb.append("\n");
        sb.append("Status: " + PduUtils.byteToPdu(this.getStatus()));
        sb.append("\n");
        return sb.toString();
    }
}

