/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms;

import cn.ajwcc.pduUtils.gsm3040.Pdu;
import cn.ajwcc.pduUtils.gsm3040.PduFactory;
import cn.ajwcc.pduUtils.gsm3040.PduGenerator;
import cn.ajwcc.pduUtils.gsm3040.PduParser;
import cn.ajwcc.pduUtils.gsm3040.PduUtils;
import cn.ajwcc.pduUtils.gsm3040.SmsSubmitPdu;
import cn.ajwcc.pduUtils.gsm3040.ie.InformationElementFactory;
import cn.sendsms.Message;
import cn.sendsms.OutboundBinaryMessage;
import java.util.Date;
import java.util.List;

public class OutboundMessage
extends Message {
    private static final long serialVersionUID = 2L;
    private int a;
    protected String recipient;
    private Date b;
    private int c;
    private boolean d;
    private String e;
    private MessageStatuses f;
    private FailureCauses g;
    private int h;
    private int i;
    private String j;
    private String k;
    private boolean l;
    private String m;
    private String n;
    private int o;
    private long p;
    private Date q;
    private int r;

    public long getHandleTime() {
        return this.p;
    }

    public void setHandleTime(long date) {
        this.p = date;
    }

    public int getSplitNum() {
        return this.a;
    }

    public void setSplitNum(int nSplitNum) {
        this.a = nSplitNum;
    }

    public OutboundMessage() {
        super(Message.MessageTypes.OUTBOUND, null, null);
        this.setRecipient("");
        this.setValidityPeriod(-1);
        this.setStatusReport(false);
        this.setDCSMessageClass(Message.MessageClasses.MSGCLASS_NONE);
        this.setFrom("");
        this.setDispatchDate(null);
        this.setDate(new Date());
        this.setEncoding(Message.MessageEncodings.ENC7BIT);
        this.setMessageStatus(MessageStatuses.UNSENT);
        this.setFailureCause(FailureCauses.NO_ERROR);
        this.setPriority(0);
        this.setRefNo("");
        this.setGatewayId("*");
        this.setRetryCount(0);
        this.setSendFlag(false);
        this.setTryTimes(0);
    }

    public boolean getSendFlag() {
        return this.l;
    }

    public void setSendFlag(boolean mySendFlag) {
        this.l = mySendFlag;
    }

    public int getTryTimes() {
        return this.o;
    }

    public void addTryTimes(int tryTime) {
        this.o += tryTime;
    }

    public void setTryTimes(int tryTime) {
        this.o = tryTime;
    }

    public String getUsingPhoneNo() {
        return this.m;
    }

    public void setUsingPhoneNo(String phoneNo) {
        this.m = phoneNo;
    }

    public OutboundMessage(String myRecipient, String text) {
        super(Message.MessageTypes.OUTBOUND, new Date(), text);
        this.setRecipient(myRecipient);
        this.setValidityPeriod(-1);
        this.setStatusReport(false);
        this.setDCSMessageClass(Message.MessageClasses.MSGCLASS_NONE);
        this.setFrom("");
        this.setDispatchDate(null);
        this.setDate(new Date());
        this.setEncoding(Message.MessageEncodings.ENC7BIT);
        this.setMessageStatus(MessageStatuses.UNSENT);
        this.setFailureCause(FailureCauses.NO_ERROR);
        this.setPriority(0);
        this.setRefNo("");
        this.setGatewayId("*");
        this.setRetryCount(0);
        this.setSendFlag(false);
        this.setUsingPhoneNo("$");
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String myRecipient) {
        this.recipient = myRecipient;
    }

    public Date getDispatchDate() {
        if (this.b != null) {
            return new Date(this.b.getTime());
        }
        return null;
    }

    public void setDispatchDate(Date myDispatchDate) {
        this.b = myDispatchDate;
    }

    public boolean getFlashSms() {
        return this.getDCSMessageClass() == Message.MessageClasses.MSGCLASS_FLASH;
    }

    public void setFlashSms(boolean flashSms) {
        if (flashSms) {
            this.setDCSMessageClass(Message.MessageClasses.MSGCLASS_FLASH);
        } else {
            this.setDCSMessageClass(Message.MessageClasses.MSGCLASS_NONE);
        }
    }

    public boolean getStatusReport() {
        return this.d;
    }

    public void setStatusReport(boolean myStatusReport) {
        this.d = myStatusReport;
    }

    public int getValidityPeriod() {
        return this.c;
    }

    public void setValidityPeriod(int myValidityPeriod) {
        this.c = myValidityPeriod;
    }

    public String getFrom() {
        return this.e;
    }

    public void setFrom(String myFrom) {
        this.e = myFrom;
    }

    public MessageStatuses getMessageStatus() {
        return this.f;
    }

    public void setMessageStatus(MessageStatuses myMessageStatus) {
        this.f = myMessageStatus;
    }

    public FailureCauses getFailureCause() {
        return this.g;
    }

    public void setFailureCause(FailureCauses myFailureCause) {
        if (myFailureCause != FailureCauses.NO_ERROR) {
            this.f = MessageStatuses.FAILED;
        }
        this.g = myFailureCause;
    }

    public int getRetryCount() {
        return this.h;
    }

    public void setRetryCount(int myRetryCount) {
        this.h = myRetryCount;
    }

    void a() {
        ++this.h;
    }

    public int getPriority() {
        return this.i;
    }

    public void setPriority(int myPriority) {
        this.i = myPriority;
    }

    public String getRefNo() {
        return this.j;
    }

    public void setRefNo(String myRefNo) {
        this.j = myRefNo;
    }

    public String getErrorMessage() {
        return this.k;
    }

    public void setErrorMessage(String errorMessage) {
        this.k = errorMessage;
    }

    public String toString() {
        String str = "\n";
        str = str + "===============================================================================";
        str = str + "\n";
        str = str + "<< " + this.getClass().getSimpleName() + " >>";
        str = str + "\n";
        str = str + "-------------------------------------------------------------------------------";
        str = str + "\n";
        str = str + " Gateway Id: " + this.getGatewayId();
        str = str + "\n";
        str = str + " Message Id: " + this.getMessageId();
        str = str + "\n";
        str = str + " Message UUID: " + this.getUuid();
        str = str + "\n";
        str = str + " Encoding: " + (this.getEncoding() == Message.MessageEncodings.ENC7BIT ? "7-bit" : (this.getEncoding() == Message.MessageEncodings.ENC8BIT ? "8-bit" : "UCS2 (Unicode)"));
        str = str + "\n";
        str = str + " Date: " + this.getDate();
        str = str + "\n";
        str = str + " SMSC Ref No: " + this.getRefNo();
        str = str + "\n";
        str = str + " Recipient: " + this.getRecipient();
        str = str + "\n";
        str = str + " Dispatch Date: " + this.getDispatchDate();
        str = str + "\n";
        str = str + " Message Status: " + (Object)((Object)this.getMessageStatus());
        str = str + "\n";
        str = str + " Failure Cause: " + (Object)((Object)this.getFailureCause());
        str = str + "\n";
        str = str + " Validity Period (Hours): " + this.getValidityPeriod();
        str = str + "\n";
        str = str + " Status Report: " + this.getStatusReport();
        str = str + "\n";
        str = str + " Source / Destination Ports: " + this.getSrcPort() + " / " + this.getDstPort();
        str = str + "\n";
        str = str + " Flash SMS: " + this.getFlashSms();
        str = str + "\n";
        if (this instanceof OutboundBinaryMessage) {
            OutboundBinaryMessage binaryMessage = (OutboundBinaryMessage)this;
            if (binaryMessage.getDataBytes() != null) {
                String binaryString = PduUtils.bytesToPdu(binaryMessage.getDataBytes());
                str = str + " Binary: " + binaryString;
                str = str + "\n";
            } else {
                str = str + " Binary: null";
                str = str + "\n";
            }
        } else {
            str = str + " Text: " + this.getText();
            str = str + "\n";
            try {
                str = str + " PDU data: " + this.getPduUserData();
                str = str + "\n";
            }
            catch (Exception e2) {
                str = str + " PDU data: <cannot extract properly, udh present>";
                str = str + "\n";
            }
        }
        str = str + " Scheduled Delivery: " + this.q;
        str = str + "\n";
        str = str + "===============================================================================";
        str = str + "\n";
        return str;
    }

    public List<String> getPdus(String smscNumber, int mpRefNo) {
        PduGenerator pduGenerator = new PduGenerator();
        SmsSubmitPdu pdu = this.createPduObject();
        this.initPduObject(pdu, smscNumber);
        return pduGenerator.generatePduList(pdu, mpRefNo);
    }

    protected SmsSubmitPdu createPduObject() {
        SmsSubmitPdu pdu = this.d ? PduFactory.newSmsSubmitPdu(48) : PduFactory.newSmsSubmitPdu();
        return pdu;
    }

    protected void initPduObject(SmsSubmitPdu pdu, String smscNumber) {
        if (this.getDstPort() > -1 && this.getSrcPort() > -1) {
            pdu.addInformationElement(InformationElementFactory.generatePortInfo(this.getDstPort(), this.getSrcPort()));
        }
        String smscNumberForLengthCheck = smscNumber;
        if (smscNumber.startsWith("+")) {
            smscNumberForLengthCheck = smscNumber.substring(1);
        }
        pdu.setSmscInfoLength(1 + smscNumberForLengthCheck.length() / 2 + (smscNumberForLengthCheck.length() % 2 == 1 ? 1 : 0));
        pdu.setSmscAddress(smscNumber);
        pdu.setSmscAddressType(PduUtils.getAddressTypeFor(smscNumber));
        pdu.setMessageReference(0);
        pdu.setAddress(this.getRecipient());
        pdu.setProtocolIdentifier(0);
        if (!pdu.isBinary()) {
            int dcs = 0;
            if (this.getEncoding() == Message.MessageEncodings.ENC7BIT) {
                dcs = 0;
            } else if (this.getEncoding() == Message.MessageEncodings.ENC8BIT) {
                dcs = 4;
            } else if (this.getEncoding() == Message.MessageEncodings.ENCUCS2) {
                dcs = 8;
            } else if (this.getEncoding() == Message.MessageEncodings.ENCCUSTOM) {
                dcs = 0;
            }
            if (this.getDCSMessageClass() == Message.MessageClasses.MSGCLASS_FLASH) {
                dcs |= 0x10;
            } else if (this.getDCSMessageClass() == Message.MessageClasses.MSGCLASS_ME) {
                dcs |= 0x11;
            } else if (this.getDCSMessageClass() == Message.MessageClasses.MSGCLASS_SIM) {
                dcs |= 0x12;
            } else if (this.getDCSMessageClass() == Message.MessageClasses.MSGCLASS_TE) {
                dcs |= 0x13;
            }
            pdu.setDataCodingScheme(dcs);
        }
        pdu.setValidityPeriod(this.c);
        this.setPduPayload(pdu);
    }

    protected void setPduPayload(SmsSubmitPdu pdu) {
        pdu.setDecodedText(this.getText());
    }

    @Override
    public String getPduUserData() {
        PduGenerator pduGenerator = new PduGenerator();
        SmsSubmitPdu pdu = this.createPduObject();
        this.initPduObject(pdu, "");
        List<String> pdus = pduGenerator.generatePduList(pdu, 1);
        if (pdu.hasTpUdhi() && this.getEncoding() == Message.MessageEncodings.ENC7BIT) {
            throw new RuntimeException("getPduUserData() not supported for 7-bit messages with UDH");
        }
        StringBuffer ud = new StringBuffer();
        for (int i2 = 0; i2 < pdus.size(); ++i2) {
            String pduString = pdus.get(i2);
            Pdu newPdu = new PduParser().parsePdu(pduString);
            ud.append(PduUtils.bytesToPdu(newPdu.getUserDataAsBytes()));
        }
        return ud.toString();
    }

    @Override
    public String getPduUserDataHeader() {
        PduGenerator pduGenerator = new PduGenerator();
        SmsSubmitPdu pdu = this.createPduObject();
        this.initPduObject(pdu, "");
        List<String> pdus = pduGenerator.generatePduList(pdu, 1);
        Pdu newPdu = new PduParser().parsePdu(pdus.get(0));
        byte[] udh = newPdu.getUDHData();
        if (udh != null) {
            return PduUtils.bytesToPdu(udh);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setEncoding(Message.MessageEncodings encoding) {
        if (encoding == Message.MessageEncodings.ENC8BIT) {
            if (!(this instanceof OutboundBinaryMessage)) throw new RuntimeException("Cannot use 8-bit encoding with OutgoingMessage, use OutgoingBinaryMessage instead");
            super.setEncoding(encoding);
            return;
        } else {
            super.setEncoding(encoding);
        }
    }

    public void setEncodingForOthers(Message.MessageEncodings encoding) {
        super.setEncoding(encoding);
    }

    public void copyTo(OutboundMessage msg) {
        super.copyTo(msg);
        msg.setRecipient(this.getRecipient());
        msg.setDispatchDate(this.getDispatchDate());
        msg.setValidityPeriod(this.getValidityPeriod());
        msg.setStatusReport(this.getStatusReport());
        msg.setFlashSms(this.getFlashSms());
        msg.setFrom(this.getFrom());
        msg.setMessageStatus(this.getMessageStatus());
        msg.setFailureCause(this.getFailureCause());
        msg.h = this.getRetryCount();
        msg.setPriority(this.getPriority());
        msg.setRefNo(this.getRefNo());
        msg.setSendFlag(this.getSendFlag());
    }

    public void setScheduledDeliveryDate(Date scheduledDeliveryDate) {
        this.q = scheduledDeliveryDate;
    }

    public Date getScheduledDeliveryDate() {
        return this.q;
    }

    public long getDeliveryDelay() {
        return this.q == null ? 0L : this.q.getTime() - System.currentTimeMillis();
    }

    public void setDeliveryDelay(long deliveryDelay) {
        this.q = new Date(System.currentTimeMillis() + deliveryDelay);
    }

    public String getUsingPortID() {
        return this.n;
    }

    public void setUsingPortID(String usingPortID) {
        this.n = usingPortID;
    }

    public int getMessageID() {
        return this.r;
    }

    public void setMessageID(int messageID) {
        this.r = messageID;
    }

    public static enum MessageStatuses {
        UNSENT,
        SENT,
        FAILED;

    }

    public static enum FailureCauses {
        NO_ERROR,
        BAD_NUMBER,
        BAD_FORMAT,
        GATEWAY_FAILURE,
        NO_CREDIT,
        GATEWAY_AUTH,
        NO_ROUTE,
        LOCAL_OPTOUT,
        GLOBAL_OPTOUT,
        UNKNOWN;

    }
}

