/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms;

import cn.ajwcc.pduUtils.gsm3040.SmsStatusReportPdu;
import cn.sendsms.InboundMessage;
import cn.sendsms.Message;
import java.util.Date;

public class StatusReportMessage
extends InboundMessage {
    private static final long serialVersionUID = 1L;
    private String a;
    private Date b;
    private Date c;
    private DeliveryStatuses d;
    private String e;

    public StatusReportMessage(SmsStatusReportPdu pdu, int memIndex, String memLocation) {
        super(Message.MessageTypes.STATUSREPORT, memIndex, memLocation);
        this.e = String.valueOf(pdu.getMessageReference());
        this.a = pdu.getAddress();
        this.b = pdu.getTimestamp();
        this.c = pdu.getDischargeTime();
        int i2 = pdu.getStatus();
        if ((i2 & 0x60) == 0) {
            this.setText("00 - Succesful Delivery.");
            this.d = DeliveryStatuses.DELIVERED;
        }
        if ((i2 & 0x20) == 32) {
            this.setText("01 - Errors, will retry dispatch.");
            this.d = DeliveryStatuses.KEEPTRYING;
        }
        if ((i2 & 0x40) == 64) {
            this.setText("02 - Errors, stopped retrying dispatch.");
            this.d = DeliveryStatuses.ABORTED;
        }
        if ((i2 & 0x60) == 96) {
            this.setText("03 - Errors, stopped retrying dispatch.");
            this.d = DeliveryStatuses.ABORTED;
        }
        this.setDate(null);
    }

    public StatusReportMessage(String myRefNo, int memIndex, String memLocation, Date dateOriginal, Date dateReceived) {
        super(Message.MessageTypes.STATUSREPORT, memIndex, memLocation);
        this.e = myRefNo;
        this.b = dateOriginal;
        this.c = dateReceived;
        this.setText("");
        this.d = DeliveryStatuses.UNKNOWN;
        this.setDate(null);
    }

    public StatusReportMessage(String myRefNo, String srcAddress, String destAddress, String text, Date dateOriginal, Date dateReceived) {
        super(Message.MessageTypes.STATUSREPORT, -1, "");
        this.e = myRefNo;
        this.b = dateOriginal;
        this.c = dateReceived;
        this.a = destAddress;
        this.setOriginator(srcAddress);
        this.setText(text);
        this.d = DeliveryStatuses.UNKNOWN;
        this.setDate(null);
    }

    public String getRecipient() {
        return this.a;
    }

    public Date getReceived() {
        return new Date(this.c.getTime());
    }

    public void setReceived(Date myReceived) {
        this.c = myReceived;
    }

    public Date getSent() {
        return new Date(this.b.getTime());
    }

    public void setSent(Date mySent) {
        this.b = mySent;
    }

    public DeliveryStatuses getStatus() {
        return this.d;
    }

    public void setStatus(DeliveryStatuses myStatus) {
        this.d = myStatus;
    }

    public String getRefNo() {
        return this.e;
    }

    public static enum DeliveryStatuses {
        UNKNOWN,
        INPROGRESS,
        DELIVERED,
        KEEPTRYING,
        ABORTED;

    }
}

