/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.addressbook;

import cn.sendsms.addressbook.Address;
import cn.sendsms.util.ConfParam;
import cn.sendsms.util.Param;
import cn.sendsms.util.Util;
import java.util.ArrayList;

public class AddressFolder {
    public String m_FolderName = "";
    public String m_id = "";
    public String m_foldertype = "";
    public ArrayList alAddress = new ArrayList();
    public ArrayList alAddressFolder = new ArrayList();
    public AddressFolder m_parentFolder = null;
    private static int m_iSNo = 0;

    public static String createId() {
        String strId = "";
        int iTemp = m_iSNo++;
        strId = strId + iTemp + "_" + String.valueOf(System.currentTimeMillis());
        return strId;
    }

    public void getAddress(boolean bShowsuball, ArrayList al) {
        if (bShowsuball) {
            int iSize = this.alAddressFolder.size();
            AddressFolder af = null;
            for (int i2 = 0; i2 < iSize; ++i2) {
                af = (AddressFolder)this.alAddressFolder.get(i2);
                af.getAddress(bShowsuball, al);
            }
        }
        al.add(this.alAddress);
    }

    public void addAdress(AddressFolder al) {
        int i2;
        AddressFolder af = al.findAddressFolder_id(this.getFullId());
        if (af == null) {
            af = al.findAddressFolder_id(this.m_parentFolder.getFullId());
            if (af != null) {
                af.alAddressFolder.add(this);
                this.m_parentFolder = af;
            }
            return;
        }
        Address tempAddress = null;
        for (i2 = 0; i2 < this.alAddress.size(); ++i2) {
            tempAddress = (Address)this.alAddress.get(i2);
            tempAddress.m_id = AddressFolder.createId();
            tempAddress.m_parentFolder = af;
            af.alAddress.add(tempAddress);
        }
        af = null;
        for (i2 = 0; i2 < this.alAddressFolder.size(); ++i2) {
            af = (AddressFolder)this.alAddressFolder.get(i2);
            af.addAdress(al);
        }
    }

    public AddressFolder findAddressFolder(String name) {
        if (name == null) {
            return this;
        }
        if (name.length() == 0) {
            return this;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.length() == 0) {
            return this;
        }
        int i2 = name.indexOf("/");
        String curName = "";
        String subName = null;
        if (i2 == -1) {
            curName = name;
        } else {
            curName = name.substring(0, i2);
            try {
                subName = name.substring(i2 + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        AddressFolder addrfolder = null;
        int iSize = this.alAddressFolder.size();
        AddressFolder findfolder = null;
        for (int k2 = 0; k2 < iSize; ++k2) {
            addrfolder = (AddressFolder)this.alAddressFolder.get(k2);
            if (!addrfolder.m_FolderName.equals(curName)) continue;
            if (subName == null) {
                return addrfolder;
            }
            findfolder = addrfolder.findAddressFolder(subName);
        }
        return null;
    }

    public AddressFolder findCurAddressFolder(String name) {
        int iSize = this.alAddressFolder.size();
        AddressFolder af = null;
        for (int i2 = 0; i2 < iSize; ++i2) {
            af = (AddressFolder)this.alAddressFolder.get(i2);
            if (!af.m_FolderName.equals(name)) continue;
            return af;
        }
        return null;
    }

    public void deleteCurAddress_id(String id) {
        int iSize = this.alAddress.size();
        Address addr = null;
        for (int i2 = 0; i2 < iSize; ++i2) {
            addr = (Address)this.alAddress.get(i2);
            if (!addr.m_id.equals(id)) continue;
            this.alAddress.remove(addr);
            return;
        }
    }

    public void deleteCurAddressFolder_id(String id) {
        int iSize = this.alAddress.size();
        AddressFolder af = null;
        for (int i2 = 0; i2 < iSize; ++i2) {
            af = (AddressFolder)this.alAddressFolder.get(i2);
            if (!af.m_id.equals(id)) continue;
            this.alAddressFolder.remove(af);
            return;
        }
    }

    public Address findCurAddress(String name) {
        int iSize = this.alAddress.size();
        Address addr = null;
        for (int i2 = 0; i2 < iSize; ++i2) {
            addr = (Address)this.alAddress.get(i2);
            if (!addr.Name.equals(name)) continue;
            return addr;
        }
        return null;
    }

    public AddressFolder findAddressFolder_id(String name) {
        if (name == null) {
            return this;
        }
        if (name.length() == 0) {
            return this;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.length() == 0) {
            return this;
        }
        int i2 = name.indexOf("/");
        String curName = "";
        String subName = null;
        if (i2 == -1) {
            curName = name;
        } else {
            curName = name.substring(0, i2);
            try {
                subName = name.substring(i2 + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        AddressFolder addrfolder = null;
        int iSize = this.alAddressFolder.size();
        AddressFolder findfolder = null;
        for (int k2 = 0; k2 < iSize; ++k2) {
            addrfolder = (AddressFolder)this.alAddressFolder.get(k2);
            if (!addrfolder.m_id.equals(curName)) continue;
            if (subName == null) {
                return addrfolder;
            }
            findfolder = addrfolder.findAddressFolder_id(subName);
            return findfolder;
        }
        return null;
    }

    public AddressFolder findAddressFolder_fullname(String fullname) {
        if (fullname == null) {
            return this;
        }
        if (fullname.length() == 0) {
            return this;
        }
        if (fullname.startsWith("/")) {
            fullname = fullname.substring(1);
        }
        if (fullname.length() == 0) {
            return this;
        }
        int i2 = fullname.indexOf("/");
        String curName = "";
        String subName = null;
        if (i2 == -1) {
            curName = fullname;
        } else {
            curName = fullname.substring(0, i2);
            try {
                subName = fullname.substring(i2 + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        AddressFolder addrfolder = null;
        int iSize = this.alAddressFolder.size();
        AddressFolder findfolder = null;
        for (int k2 = 0; k2 < iSize; ++k2) {
            addrfolder = (AddressFolder)this.alAddressFolder.get(k2);
            if (!addrfolder.m_FolderName.equals(curName)) continue;
            if (subName == null) {
                return addrfolder;
            }
            findfolder = addrfolder.findAddressFolder_fullname(subName);
            return findfolder;
        }
        return null;
    }

    public String getFullId() {
        String tempId = "";
        String tempRootId = "";
        tempRootId = this.m_parentFolder != null ? this.m_parentFolder.getFullId() : "";
        tempId = tempRootId.equals("/") ? tempRootId + this.m_id : tempRootId + "/" + this.m_id;
        return tempId;
    }

    public String getFullName() {
        String tempId = "";
        String tempRootId = "";
        tempRootId = this.m_parentFolder != null ? this.m_parentFolder.getFullName() : "";
        tempId = tempRootId.equals("/") ? tempRootId + this.m_FolderName : tempRootId + "/" + this.m_FolderName;
        return tempId;
    }

    public StringBuffer getAddressXML() {
        ArrayList al = this.alAddress;
        Address addr = null;
        int iSize = al.size();
        StringBuffer sb = new StringBuffer();
        sb.append("");
        for (int k2 = 0; k2 < iSize; ++k2) {
            addr = (Address)al.get(k2);
            sb.append("   <address>\r\n");
            sb.append("        <id>" + addr.m_id + "</id>\r\n");
            sb.append("        <name>" + Util.htmlspecialchars(addr.Name, false, false) + "</name>\r\n");
            sb.append("        <telephone>" + Util.htmlspecialchars(addr.Telephone, false, false) + "</telephone>\r\n");
            sb.append("        <email>" + Util.htmlspecialchars(addr.EmailAddress, false, false) + "</email>\r\n");
            sb.append("        <organization>" + Util.htmlspecialchars(addr.Organization, false, false) + "</organization>\r\n");
            sb.append("        <department>" + Util.htmlspecialchars(addr.Department, false, false) + "</department>\r\n");
            sb.append("        <employment>" + Util.htmlspecialchars(addr.Employment, false, false) + "</employment>\r\n");
            sb.append("        <orderrule>" + Util.htmlspecialchars(addr.Orderrule, false, false) + "</orderrule>\r\n");
            sb.append("        <address>" + Util.htmlspecialchars(addr.Address, false, false) + "</address>\r\n");
            sb.append("        <postalcode>" + Util.htmlspecialchars(addr.Postalcode, false, false) + "</postalcode>\r\n");
            sb.append("   </address>\r\n");
        }
        return sb;
    }

    public static AddressFolder parseXml(String strXml, String foldertype) {
        ConfParam tempCF = new ConfParam();
        if (tempCF.OpenString(strXml) == 1) {
            return null;
        }
        AddressFolder af = new AddressFolder();
        Param p2 = tempCF.GetParam("folder");
        af.m_FolderName = p2.getAttribte("name");
        af.m_foldertype = foldertype;
        return af;
    }

    public StringBuffer getFolderXML() {
        StringBuffer sbContent = new StringBuffer();
        sbContent.append("<folder name=\"" + Util.htmlspecialchars(this.m_FolderName, false, false) + "\" id=\"" + this.m_id + "\" >\r\n");
        sbContent.append(this.getAddressXML());
        AddressFolder addrfolder = null;
        int iSize = this.alAddressFolder.size();
        for (int k2 = 0; k2 < iSize; ++k2) {
            addrfolder = (AddressFolder)this.alAddressFolder.get(k2);
            sbContent.append(addrfolder.getFolderXML());
        }
        sbContent.append("</folder>\r\n");
        return sbContent;
    }

    public String outputOutlookAddress(ArrayList alFormat) {
        ArrayList al = this.alAddress;
        Address addr = null;
        int iSize = al.size();
        StringBuffer sb = new StringBuffer();
        sb.append("");
        for (int k2 = 0; k2 < iSize; ++k2) {
            addr = (Address)al.get(k2);
            sb.append("\r\n");
            sb.append(addr.outputFormatAddress(alFormat));
        }
        return sb.toString();
    }

    public String outputOutlookFolder(ArrayList alFormat) {
        StringBuffer sbContent = new StringBuffer();
        sbContent.append(this.outputOutlookAddress(alFormat));
        AddressFolder addrfolder = null;
        int iSize = this.alAddressFolder.size();
        for (int k2 = 0; k2 < iSize; ++k2) {
            addrfolder = (AddressFolder)this.alAddressFolder.get(k2);
            sbContent.append(addrfolder.outputOutlookFolder(alFormat));
        }
        return sbContent.toString();
    }

    public String outputOutlookFolder(ArrayList alFormat, ArrayList alaladdr) {
        StringBuffer sbContent = new StringBuffer();
        Object addrfolder = null;
        ArrayList aladdr = null;
        Address addr = null;
        int iSize = alaladdr.size();
        for (int i2 = 0; i2 < alaladdr.size(); ++i2) {
            aladdr = (ArrayList)alaladdr.get(i2);
            for (int j2 = 0; j2 < aladdr.size(); ++j2) {
                addr = (Address)aladdr.get(j2);
                sbContent.append("\r\n");
                sbContent.append(addr.outputFormatAddress(alFormat));
            }
        }
        return sbContent.toString();
    }

    public void findAddr(ArrayList alRet, String name, String email, String mobile, String tel) {
        this.findAddr(alRet, name, email, mobile, tel, false);
    }

    public void findAddr(ArrayList alRet, String name, String email, String mobile, String tel, boolean bWhole) {
        if (name == null) {
            name = "";
        }
        if (email == null) {
            email = "";
        }
        if (mobile == null) {
            mobile = "";
        }
        if (tel == null) {
            tel = "";
        }
        if (name.equals("") && email.equals("") && mobile.equals("") && tel.equals("")) {
            return;
        }
        if (alRet == null) {
            return;
        }
        Address addr = null;
        int iSize = this.alAddress.size();
        boolean bMatch = false;
        boolean iMatch = false;
        for (int i2 = 0; i2 < iSize; ++i2) {
            addr = (Address)this.alAddress.get(i2);
            bMatch = true;
            boolean bHasMatchAction = false;
            if (!name.equals("")) {
                if (bWhole) {
                    if (!addr.Name.toLowerCase().equals(name)) {
                        bMatch = false;
                    }
                } else if (addr.Name.toLowerCase().indexOf(name) < 0) {
                    bMatch = false;
                }
                bHasMatchAction = true;
            }
            if (!email.equals("")) {
                bHasMatchAction = true;
                int iFindIdx = addr.EmailAddress.toLowerCase().indexOf(email);
                if (bWhole) {
                    int iLenFind = email.length();
                    int iLenAb = addr.EmailAddress.length();
                    if (iFindIdx < 0) {
                        bMatch = false;
                    } else if (iFindIdx < 0 || iLenFind != iLenAb) {
                        if (iFindIdx == 0) {
                            if (!Util.isEmailAddressSplit(addr.EmailAddress.charAt(iLenFind))) {
                                bMatch = false;
                            }
                        } else if (Util.isEmailAddressSplit(addr.EmailAddress.charAt(iFindIdx - 1))) {
                            if (iFindIdx + iLenFind < iLenAb && !Util.isEmailAddressSplit(addr.EmailAddress.charAt(iFindIdx + iLenFind))) {
                                bMatch = false;
                            }
                        } else {
                            bMatch = false;
                        }
                    }
                } else if (iFindIdx < 0) {
                    bMatch = false;
                }
            }
            if (!tel.equals("")) {
                bHasMatchAction = true;
                if (bWhole) {
                    if (!addr.Telephone.toLowerCase().equals(tel)) {
                        bMatch = false;
                    }
                } else if (addr.Telephone.toLowerCase().indexOf(tel) < 0) {
                    bMatch = false;
                }
            }
            if (!bHasMatchAction) {
                bMatch = false;
            }
            if (!bMatch) continue;
            alRet.add(addr);
        }
        AddressFolder addrfolder = null;
        iSize = this.alAddressFolder.size();
        for (int k2 = 0; k2 < iSize; ++k2) {
            addrfolder = (AddressFolder)this.alAddressFolder.get(k2);
            addrfolder.findAddr(alRet, name, email, mobile, tel, bWhole);
        }
    }
}

