/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.http;

import cn.sendsms.GatewayException;
import cn.sendsms.Message;
import cn.sendsms.OutboundMessage;
import cn.sendsms.TimeoutException;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.helper.Logger;
import cn.sendsms.http.a;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class KannelHTTPGateway
extends a {
    String a;
    String b;
    String c;
    String d;
    String e;
    String f;
    boolean g;
    boolean h;
    Object i;

    public KannelHTTPGateway(String smscId, String sendUrl, String username, String password) {
        super(smscId);
        this.a = sendUrl;
        this.b = username;
        this.c = password;
        this.i = new Object();
        this.setAttributes(79);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        String text;
        String encodingHeader;
        ArrayList<a.a> request = new ArrayList<a.a>();
        String from = msg.getFrom();
        request.add(new a.a("username", this.b, false));
        request.add(new a.a("password", this.c, false));
        request.add(new a.a("smsc", this.getGatewayId(), false));
        request.add(new a.a("to", msg.getRecipient(), false));
        int priority = msg.getPriority();
        if (priority < 0) {
            priority = 0;
        } else if (priority > 3) {
            priority = 3;
        }
        request.add(new a.a("priority", priority + "", false));
        if (msg.getValidityPeriod() >= 0) {
            request.add(new a.a("validity", msg.getValidityPeriod() * 60 + "", false));
        }
        if (from == null) {
            from = this.getFrom();
        }
        if (from != null) {
            request.add(new a.a("from", msg.getRecipient(), false));
        }
        Message.MessageEncodings encoding = msg.getEncoding();
        switch (encoding) {
            case ENC8BIT: {
                encodingHeader = "1";
                text = URLEncoder.encode(msg.getText(), "utf-8");
                break;
            }
            case ENCUCS2: {
                encodingHeader = "2";
                text = URLEncoder.encode(msg.getText(), "utf-16BE");
                break;
            }
            default: {
                encodingHeader = "0";
                text = URLEncoder.encode(msg.getText(), "utf-8");
            }
        }
        request.add(new a.a("coding", encodingHeader, false));
        if (msg.getFlashSms()) {
            request.add(new a.a("mclass", "1", false));
        }
        request.add(new a.a("text", text, false));
        String reqLine = this.a(request);
        URL url = new URL(this.a + "?" + reqLine);
        Object object = this.i;
        synchronized (object) {
            List<String> response = this.a(url);
            if (!response.get(0).startsWith("202")) {
                Logger.getInstance().logError("Error sending message. Response: " + response.get(0) + " - " + response.get(1), null, this.getGatewayId());
                msg.setRefNo(null);
                msg.setDispatchDate(null);
                msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                msg.setFailureCause(this.b(response));
                return false;
            }
            Logger.getInstance().logInfo("Message sent. Response: " + response.get(0) + " - " + response.get(1), null, this.getGatewayId());
        }
        msg.setDispatchDate(new Date());
        msg.setGatewayId(this.getGatewayId());
        msg.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
        this.incOutboundMessageCount();
        return true;
    }

    private OutboundMessage.FailureCauses b(List<String> response) {
        if (response.get(0).startsWith("503")) {
            return OutboundMessage.FailureCauses.GATEWAY_FAILURE;
        }
        String errorMessage = response.get(0);
        if (errorMessage.startsWith("Authorization failed")) {
            return OutboundMessage.FailureCauses.GATEWAY_AUTH;
        }
        if (errorMessage.startsWith("Missing receiver")) {
            return OutboundMessage.FailureCauses.BAD_NUMBER;
        }
        if (errorMessage.startsWith("Not routable")) {
            return OutboundMessage.FailureCauses.NO_ROUTE;
        }
        if (errorMessage.startsWith("Sender missing")) {
            return OutboundMessage.FailureCauses.BAD_FORMAT;
        }
        return OutboundMessage.FailureCauses.UNKNOWN;
    }

    public String getSendUrl() {
        return this.a;
    }

    public void setSendUrl(String sendUrl) {
        this.a = sendUrl;
    }

    public String getUsername() {
        return this.b;
    }

    public void setUsername(String username) {
        this.b = username;
    }

    public String getPassword() {
        return this.c;
    }

    public void setPassword(String password) {
        this.c = password;
    }

    public String getAdminUrl() {
        return this.d;
    }

    public void setAdminUrl(String adminUrl) {
        this.d = adminUrl;
        if (!this.d.endsWith("/")) {
            this.d = this.d + "/";
        }
    }

    public String getAdminPassword() {
        return this.e;
    }

    public void setAdminPassword(String adminPassword) {
        this.e = adminPassword;
    }

    @Override
    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.g && !this.startSmsc()) {
            this.setStatus(AGatewayHelper.GatewayStatuses.STARTING);
            super.stopGateway();
            this.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
            return;
        }
        super.startGateway();
    }

    @Override
    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.h) {
            this.stopSmsc();
        }
        super.stopGateway();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startSmsc() throws TimeoutException, GatewayException, IOException, InterruptedException {
        boolean started = true;
        KannelSMSCStatuses smscStatus = this.getKannelSMSCStatus();
        if (smscStatus == KannelSMSCStatuses.UNAVAILABLE || smscStatus == KannelSMSCStatuses.UNKNOWN) {
            started = false;
            Logger.getInstance().logError("SMSC was not found on Kannel.", null, this.getGatewayId());
        } else if (smscStatus == KannelSMSCStatuses.DEAD) {
            if (this.e == null) {
                Logger.getInstance().logWarn("Can't start Kannel SMSC, admin password not set.", null, this.getGatewayId());
            } else {
                List<String> response;
                ArrayList<a.a> request = new ArrayList<a.a>();
                request.add(new a.a("smsc", this.getGatewayId(), false));
                request.add(new a.a("password", this.e, false));
                String reqLine = this.a(request);
                URL url = new URL(this.d + "start-smsc.txt?" + reqLine);
                Object object = this.i;
                synchronized (object) {
                    response = this.a(url);
                }
                if (response.get(1).startsWith("Denied")) {
                    Logger.getInstance().logError("Could not start SMSC." + response.get(0) + " - " + response.get(1), null, this.getGatewayId());
                    started = false;
                } else {
                    Logger.getInstance().logInfo("Sent command to start SMSC." + response.get(0) + " - " + response.get(1), null, this.getGatewayId());
                }
            }
        }
        return started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopSmsc() throws TimeoutException, GatewayException, IOException, InterruptedException {
        boolean stopped = true;
        if (this.d == null || this.e == null) {
            Logger.getInstance().logError("Can't stop Kannel SMSC, admin Url and password need to be set.", null, this.getGatewayId());
            stopped = false;
        } else {
            List<String> response;
            ArrayList<a.a> request = new ArrayList<a.a>();
            request.add(new a.a("smsc", this.getGatewayId(), false));
            request.add(new a.a("password", this.e, false));
            String reqLine = this.a(request);
            URL url = new URL(this.d + "stop-smsc.txt?" + reqLine);
            Object object = this.i;
            synchronized (object) {
                response = this.a(url);
            }
            if (response.get(1).startsWith("Denied")) {
                Logger.getInstance().logError("Could not stop SMSC." + response.get(0) + " - " + response.get(1), null, this.getGatewayId());
                stopped = false;
            } else {
                Logger.getInstance().logInfo("Sent command to stop SMSC." + response.get(0) + " - " + response.get(1), null, this.getGatewayId());
            }
        }
        return stopped;
    }

    public KannelSMSCStatuses getKannelSMSCStatus() {
        if (this.d == null) {
            Logger.getInstance().logWarn("Can't check Kannel SMSC status, admin URL not set.", null, this.getGatewayId());
            return KannelSMSCStatuses.UNKNOWN;
        }
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            String url = this.d + "status.xml";
            if (this.f != null) {
                url = url + "?password=" + this.f;
            }
            doc = docBuilder.parse(url);
        }
        catch (SAXException e2) {
            Logger.getInstance().logError("Error getting smsc status.", e2, this.getGatewayId());
            return KannelSMSCStatuses.UNKNOWN;
        }
        catch (ParserConfigurationException e3) {
            Logger.getInstance().logError("Error getting smsc status.", e3, this.getGatewayId());
            return KannelSMSCStatuses.UNKNOWN;
        }
        catch (IOException e4) {
            Logger.getInstance().logError("Error getting smsc status. Make sure Kannel is running.", e4, this.getGatewayId());
            return KannelSMSCStatuses.UNKNOWN;
        }
        NodeList smscsList = doc.getElementsByTagName("smsc");
        int totalSmscs = smscsList.getLength();
        KannelSMSCStatuses smscStatus = KannelSMSCStatuses.UNAVAILABLE;
        for (int i2 = 0; i2 < totalSmscs; ++i2) {
            Node smscNode = smscsList.item(i2);
            if (smscNode.getNodeType() != 1) continue;
            Element smsc = (Element)smscNode;
            NodeList smscIdNodes = smsc.getElementsByTagName("id");
            String smscId = smscIdNodes.item(0).getTextContent();
            if (!this.getGatewayId().equalsIgnoreCase(smscId)) continue;
            NodeList smscStatusNodes = smsc.getElementsByTagName("status");
            String status = smscStatusNodes.item(0).getTextContent();
            if (status.startsWith("online")) {
                smscStatus = KannelSMSCStatuses.ONLINE;
            } else if (status.startsWith("connecting")) {
                smscStatus = KannelSMSCStatuses.CONNECTING;
            } else if (status.startsWith("re-connecting")) {
                smscStatus = KannelSMSCStatuses.RECONNECTING;
            } else if (status.startsWith("dead")) {
                smscStatus = KannelSMSCStatuses.DEAD;
            }
            return smscStatus;
        }
        return smscStatus;
    }

    @Override
    List<String> a(URL url) throws IOException {
        String inputLine;
        ArrayList<String> responseList = new ArrayList<String>();
        Logger.getInstance().logInfo("HTTP GET: " + url, null, this.getGatewayId());
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setConnectTimeout(20000);
        con.setAllowUserInteraction(false);
        responseList.add(con.getResponseCode() + " " + con.getResponseMessage());
        InputStream inputStream = con.getErrorStream();
        if (inputStream == null) {
            inputStream = con.getInputStream();
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        while ((inputLine = in.readLine()) != null) {
            responseList.add(inputLine);
        }
        in.close();
        return responseList;
    }

    public String getStatusPassword() {
        return this.f;
    }

    public void setStatusPassword(String statusPassword) {
        this.f = statusPassword;
    }

    public boolean isAutoStartSmsc() {
        return this.g;
    }

    public void setAutoStartSmsc(boolean autoStartSmsc) {
        this.g = autoStartSmsc;
    }

    public boolean isAutoStopSmsc() {
        return this.h;
    }

    public void setAutoStopSmsc(boolean autoStopSmsc) {
        this.h = autoStopSmsc;
    }

    public static enum KannelSMSCStatuses {
        ONLINE,
        DEAD,
        CONNECTING,
        RECONNECTING,
        UNAVAILABLE,
        UNKNOWN;

    }
}

