/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.interfaces;

import cn.sendsms.crypto.PwdConf;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.util.Logger;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;

public class ConnectionPool {
    private static final ConnectionPool cache = new ConnectionPool();
    private String a = JDSMSServer.getInstance().getProperties().getString("db1.driver", "");
    private String b = JDSMSServer.getInstance().getProperties().getString("db1.url", "");
    private String c = JDSMSServer.getInstance().getProperties().getString("db1.username", "");
    private String d = "";
    private HikariDataSource e = null;

    public ConnectionPool() {
        String szTmpPwd;
        String szTmpEnc = JDSMSServer.getInstance().getProperties().getString("db1.enc", "");
        String szDbPwd = szTmpPwd = JDSMSServer.getInstance().getProperties().getString("db1.password", "");
        if (szTmpEnc != null && szTmpEnc.equals("1")) {
            szDbPwd = PwdConf.decPwd(szTmpPwd);
        }
        this.d = szDbPwd;
    }

    public void initConnectionPool() {
        String szTmpPwd;
        this.a = JDSMSServer.getInstance().getProperties().getString("db1.driver", "");
        this.b = JDSMSServer.getInstance().getProperties().getString("db1.url", "");
        this.c = JDSMSServer.getInstance().getProperties().getString("db1.username", "");
        String szTmpEnc = JDSMSServer.getInstance().getProperties().getString("db1.enc", "");
        String szDbPwd = szTmpPwd = JDSMSServer.getInstance().getProperties().getString("db1.password", "");
        if (szTmpEnc != null && szTmpEnc.equals("1")) {
            szDbPwd = PwdConf.decPwd(szTmpPwd);
        }
        this.d = szDbPwd;
    }

    public static final ConnectionPool getInstance() {
        return cache;
    }

    public boolean isPoolCreate() {
        return this.e != null;
    }

    public void createPool() {
        this.e = new HikariDataSource();
        this.e.setDriverClassName(this.a);
        this.e.setJdbcUrl(this.b);
        this.e.setUsername(this.c);
        this.e.setPassword(this.d);
        this.e.setMaximumPoolSize(30);
        this.e.setMinimumIdle(5);
        String type = JDSMSServer.getInstance().getProperties().getString("db1.type", "");
        if ("mysql".equalsIgnoreCase(type) || "oracle".equalsIgnoreCase(type) || "mysql8".equalsIgnoreCase(type)) {
            this.e.setConnectionTestQuery("select 1 from dual ");
        }
        if ("DM7".equalsIgnoreCase(type)) {
            this.e.setConnectionTestQuery("select 1 from dual ");
        }
        if ("OSCAR7".equalsIgnoreCase(type)) {
            this.e.setConnectionTestQuery("select 1 from dual ");
        }
        if ("KINGBASE8".equalsIgnoreCase(type)) {
            this.e.setConnectionTestQuery("select 1 from dual ");
        }
        if ("GBASE8A".equalsIgnoreCase(type)) {
            this.e.setConnectionTestQuery("select 1 from dual ");
        }
        if ("mssql".equalsIgnoreCase(type)) {
            this.e.setConnectionTestQuery("select 1 ");
        }
        if ("postgresql".equalsIgnoreCase(type)) {
            this.e.setConnectionTestQuery("select 1 ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.e.isClosed()) {
                this.e = null;
                this.createPool();
            }
        }
        Connection conn = this.e.getConnection();
        return conn;
    }

    public void returnConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e2) {
            Logger.getInstance().logError("\u5173\u95ed\u8fde\u63a5\u65f6\u51fa\u73b0\u95ee\u9898", e2, null);
        }
    }

    public void closeConnectionPool() {
        if (this.e == null) {
            Logger.getInstance().logError(" \u8fde\u63a5\u6c60\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5173\u95ed !", null, null);
            return;
        }
        this.e.close();
    }
}

