/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.web;

import cn.sendsms.AGateway;
import cn.sendsms.GatewayException;
import cn.sendsms.Service;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.ResourceManager;
import cn.sendsms.jdsmsserver.web.AlertInfo;
import cn.sendsms.jdsmsserver.web.DbHelper;
import cn.sendsms.jdsmsserver.web.DeviceInfoCache;
import cn.sendsms.jdsmsserver.web.GetIpModemInfo;
import cn.sendsms.jdsmsserver.web.GetPortInfo;
import cn.sendsms.jdsmsserver.web.GetSerialPortInfoByGateway;
import cn.sendsms.jdsmsserver.web.HttpRequestReader;
import cn.sendsms.jdsmsserver.web.JDWebAction;
import cn.sendsms.jdsmsserver.web.NetDeviceBean;
import cn.sendsms.jdsmsserver.web.NewAuth;
import cn.sendsms.jdsmsserver.web.PhoneInfoCache;
import cn.sendsms.jdsmsserver.web.SerialModemBean;
import cn.sendsms.jdsmsserver.web.SerialPhoneBean;
import cn.sendsms.otherModem.bean.BigDipperBean;
import cn.sendsms.otherModem.bean.LoraBean;
import cn.sendsms.otherModem.bean.NbIoTBean;
import cn.sendsms.otherModem.bigdipper.BDDeviceInfoGetter;
import cn.sendsms.otherModem.common.Utils;
import cn.sendsms.otherModem.driver.bigdipperDriver.BDDriver;
import cn.sendsms.otherModem.driver.loraDriver.LoRaDriver;
import cn.sendsms.otherModem.modem.Modem;
import cn.sendsms.otherModem.nbiot.NbIoTDeviceInfoGetter;
import cn.sendsms.otherModem.nbiot.authorize.AuthorizeInfo;
import cn.sendsms.otherModem.nbiot.authorize.NbIoTAuthorize;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jssc.SerialPort;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.ArrayUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DeviceConfigAction
extends JDWebAction {
    private static final long serialVersionUID = -7617843582936702460L;
    private SerialModemBean device;
    private String deviceIp;
    private int startPort;
    private int endPort;
    private static NbIoTDeviceInfoGetter nbiotDeviceInfoGetter = NbIoTDeviceInfoGetter.getInstance();
    private static BDDeviceInfoGetter bdDeviceInfoGetter = BDDeviceInfoGetter.getInstance();

    public void refresh(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, Exception {
        try {
            req.setAttribute("devices", DeviceInfoCache.getInstance().getAll());
        }
        catch (CloneNotSupportedException e2) {
            this.log.error((Object)"get device list failed", (Throwable)e2);
        }
        catch (Exception e3) {
            this.log.error((Object)"\u83b7\u53d6\u8bbe\u5907\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e3);
            throw e3;
        }
        this.findForward("device-config.jsp", true, req, resp);
    }

    public void refreshLoRa(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, Exception {
        try {
            req.setAttribute("LoRas", LoRaDriver.getInstance().getAll());
        }
        catch (Exception e2) {
            this.log.error((Object)"\u83b7\u53d6\u8bbe\u5907\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e2);
            throw e2;
        }
        this.findForward("loraInfoPage.jsp", true, req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshNbIoT(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, Exception {
        try {
            List<NbIoTBean> deviceList = nbiotDeviceInfoGetter.getAll();
            for (int i2 = 0; i2 < deviceList.size(); ++i2) {
                SerialPort serialPort;
                NbIoTBean device = deviceList.get(i2);
                if (!"0".equals(device.getUsingStatus())) continue;
                SerialPort serialPort2 = serialPort = nbiotDeviceInfoGetter.getSerialPort(device.getPortID());
                synchronized (serialPort2) {
                    if (!serialPort.isOpened()) {
                        String freshSignal = "99.99";
                        try {
                            freshSignal = Modem.getDriver(device.getDeviceType()).getSignal(nbiotDeviceInfoGetter.getSerialPort(device.getPortID()));
                        }
                        catch (Exception e2) {
                            this.log.error((Object)"\u68c0\u6d4bnbiot\u8bbe\u5907\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\u3002\u3002\u3002", (Throwable)e2);
                        }
                        device.setSignal(freshSignal);
                    }
                    continue;
                }
            }
            req.setAttribute("NbIoTs", deviceList);
        }
        catch (Exception e3) {
            this.log.error((Object)"\u83b7\u53d6\u8bbe\u5907\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e3);
            throw e3;
        }
        this.findForward("nbiotInfoPage.jsp", true, req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshBD(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, Exception {
        try {
            List<BigDipperBean> deviceList = bdDeviceInfoGetter.getAll();
            for (int i2 = 0; i2 < deviceList.size(); ++i2) {
                SerialPort serialPort;
                BigDipperBean device = deviceList.get(i2);
                if (!"0".equals(device.getUsingStatus())) continue;
                SerialPort serialPort2 = serialPort = bdDeviceInfoGetter.getSerialPort(device.getPortID());
                synchronized (serialPort2) {
                    if (!serialPort.isOpened()) {
                        String freshSignal = "";
                        try {
                            freshSignal = Modem.getDriver(device.getDeviceType()).getSignal(bdDeviceInfoGetter.getSerialPort(device.getPortID()));
                        }
                        catch (Exception e2) {
                            this.log.error((Object)"\u68c0\u6d4b\u5317\u6597\u8bbe\u5907\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\u3002\u3002\u3002", (Throwable)e2);
                        }
                        device.setSignal(freshSignal);
                    }
                    continue;
                }
            }
            req.setAttribute("BDs", bdDeviceInfoGetter.getAll());
        }
        catch (Exception e3) {
            this.log.error((Object)"\u83b7\u53d6\u8bbe\u5907\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e3);
            throw e3;
        }
        this.findForward("bigdipperInfo.jsp", true, req, resp);
    }

    public void refreshTest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, Exception {
        try {
            PhoneInfoCache.getInstance().resetShowFlag();
            List<SerialPhoneBean> list = PhoneInfoCache.getInstance().getAll();
            req.setAttribute("phones", list);
        }
        catch (CloneNotSupportedException e2) {
            this.log.error((Object)"get device list failed", (Throwable)e2);
        }
        catch (Exception e3) {
            this.log.error((Object)"\u83b7\u53d6\u8bbe\u5907\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e3);
            throw e3;
        }
        this.findForward("phoneInfoPage.jsp", true, req, resp);
    }

    public void addVitualNbIoTDevice(HttpServletRequest req, HttpServletResponse resp) {
        int MQTTPort;
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        String MQTTServer = props.getString("settings.mqtt_server", "119.90.56.92");
        if (!Utils.isConnectionOK(MQTTServer, MQTTPort = props.getInt("settings.mqtt_port", 1883))) {
            req.setAttribute("message", (Object)(ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.nbiot_mqtt_server_connect_failed") + MQTTServer + ":" + MQTTPort));
        } else if (nbiotDeviceInfoGetter.addVitualDevice()) {
            req.setAttribute("needSaveConfig", (Object)new String());
        } else {
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.nbiot_vitual_device_add_failed"));
        }
        req.setAttribute("NbIoTs", nbiotDeviceInfoGetter.getAll());
        this.findForward("nbiotInfoPage?action=refreshNbIoT", true, req, resp);
    }

    public void regPhoneDeviceInit(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String phoneNo = req.getParameter("phoneNo");
        String serialnum = "";
        String regcode = "";
        String error = ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_failed_to_get_imei");
        long begin = System.currentTimeMillis();
        try {
            List<SerialPhoneBean> list = PhoneInfoCache.getInstance().getAll();
            int listLen = list.size();
            for (int i2 = 0; i2 < listLen; ++i2) {
                if (!list.get(i2).getPhoneNo().equals(phoneNo)) continue;
                serialnum = list.get(i2).getPhoneImei();
                break;
            }
            if (serialnum == null || serialnum.equals("")) {
                serialnum = "";
                req.setAttribute("error", (Object)error);
            }
            this.log.info((Object)("\u6ce8\u518c\u624b\u673a" + phoneNo + "\u5e8f\u5217\u53f7" + serialnum));
        }
        catch (Exception e2) {
            this.log.error((Object)"\u83b7\u53d6\u8bbe\u5907\u6ce8\u518c\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)e2);
            serialnum = "";
            req.setAttribute("error", (Object)error);
        }
        long end = System.currentTimeMillis();
        double time = end - begin;
        this.log.info((Object)("\u83b7\u53d6\u624b\u673a" + phoneNo + "\u5e8f\u5217\u53f7\u8017\u65f6" + (time /= 1000.0) + "\u79d2"));
        req.setAttribute("serialnum", (Object)serialnum);
        req.setAttribute("phoneNo", (Object)phoneNo);
        regcode = NewAuth.getAuthorizeInfo(serialnum, "regcode");
        if (regcode == null || regcode.indexOf("null") != -1) {
            regcode = "";
        }
        req.setAttribute("regcode", (Object)regcode);
        if (serialnum.equals("") || regcode.equals("")) {
            this.findForward("phone-register.jsp", true, req, resp);
            return;
        }
        int nNewType = NewAuth.checkDevRegCode(serialnum, regcode);
        if (nNewType == 1) {
            req.setAttribute("info", (Object)(NewAuth.getAuthorizeInfo(serialnum, "authorize_time") != null ? "\u6388\u6743\u6709\u6548\uff0c\u6388\u6743\u65f6\u95f4\u4e3a\uff1a" + NewAuth.getAuthorizeInfo(serialnum, "authorize_time") : ""));
        } else if (req.getAttribute("error") == null) {
            req.setAttribute("error", (Object)"\u6388\u6743\u65e0\u6548");
        }
        this.findForward("phone-register.jsp", true, req, resp);
    }

    public void regPhoneDevice(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Integer isAuthorize = 0;
        try {
            String serialnum = req.getParameter("serialnum");
            String regCode = req.getParameter("regcode");
            String phoneNo = req.getParameter("phoneNo");
            req.setAttribute("serialnum", (Object)serialnum);
            req.setAttribute("regcode", (Object)regCode);
            req.setAttribute("phoneNo", (Object)phoneNo);
            int nNewType = NewAuth.checkDevRegCode(serialnum, regCode);
            if (nNewType == 1) {
                isAuthorize = 1;
                PhoneInfoCache.getInstance().setRealUsingPhoneFlag(phoneNo, "1");
                req.setAttribute("message", (Object)"\u606d\u559c\u60a8\u8bbe\u5907\u6ce8\u518c\u6210\u529f\uff01");
                req.setAttribute("info", (Object)"\u6388\u6743\u6709\u6548");
            } else {
                isAuthorize = 0;
                if (nNewType == 2) {
                    req.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u5df2\u8fc7\u671f\uff01");
                    req.setAttribute("error", (Object)"\u6388\u6743\u5df2\u8fc7\u671f");
                } else if (nNewType == 3) {
                    req.setAttribute("message", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6ce8\u518c\u65e0\u6548\uff01");
                    req.setAttribute("error", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6388\u6743\u65e0\u6548");
                } else {
                    req.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u65e0\u6548\uff01");
                    req.setAttribute("error", (Object)"\u6388\u6743\u65e0\u6548");
                }
            }
            this.savePhoneConfiguration();
            NewAuth.saveAuthorize(phoneNo, serialnum, regCode);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            req.setAttribute("serialnum", (Object)"");
            req.setAttribute("regcode", (Object)"");
            req.setAttribute("message", (Object)"\u6ce8\u518c\u8bbe\u5907\u5931\u8d25\uff01");
            req.setAttribute("error", (Object)"\u6ce8\u518c\u8bbe\u5907\u5931\u8d25\uff01");
        }
        this.findForward("phone-register.jsp", true, req, resp);
    }

    public void startPhones(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String[] ids = req.getParameter("ids").split(",");
        boolean flag = false;
        for (int i2 = 0; i2 < ids.length; ++i2) {
            String serialnum;
            boolean flagR;
            String id = ids[i2];
            if (0 == PhoneInfoCache.getInstance().startPhones(id)) {
                flag = true;
            }
            if (flagR = NewAuth.checkDeviceAuth(serialnum = PhoneInfoCache.getInstance().getPhoneIMEI(id))) {
                NewAuth.updateAuthorizeTemp(id, serialnum);
                continue;
            }
            NewAuth.updateAuthorizeTemp(id, serialnum);
        }
        if (flag) {
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.phone_please_do_not_select_the_device_not_connected_or_in_the_enabled_state"));
            req.setAttribute("phones", PhoneInfoCache.getInstance().getAll());
            this.findForward("phoneInfoPage.jsp", true, req, resp);
            return;
        }
        this.savePhoneConfiguration();
        req.setAttribute("phones", PhoneInfoCache.getInstance().getAll());
        this.findForward("phoneInfoPage.jsp", true, req, resp);
    }

    public void startLoras(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String[] ids = req.getParameter("ids").split(",");
        boolean inWorkMode = true;
        boolean hasUnauthorizedDevice = false;
        String response = "";
        for (int j2 = 0; j2 < ids.length; ++j2) {
            if (!LoRaDriver.getInstance().findDeviceByPortID(ids[j2]).isValidate()) {
                hasUnauthorizedDevice = true;
            }
            response = "";
            if (LoRaDriver.getInstance().checkStartLoras(ids[j2])) {
                inWorkMode = false;
                req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.lora_start_tips1"));
                break;
            }
            response = LoRaDriver.getInstance().checkDeviceMode(LoRaDriver.getInstance().getSerialPort(ids[j2]));
            if ("OK".equals(response)) continue;
            inWorkMode = false;
            break;
        }
        if (!inWorkMode) {
            if ("ERROR1".equals(response)) {
                req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.lora_start_tips1"));
            } else if ("ERROR2".equals(response)) {
                req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.lora_start_tips2"));
            } else {
                req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.lora_start_tips3"));
            }
            req.setAttribute("LoRas", LoRaDriver.getInstance().getAll());
            this.findForward("loraInfoPage.jsp", true, req, resp);
            return;
        }
        boolean flag = false;
        ArrayList<String> serialNumberList = new ArrayList();
        if (hasUnauthorizedDevice) {
            serialNumberList = LoRaDriver.getInstance().getSerialNumberList();
        }
        for (int i2 = 0; i2 < ids.length; ++i2) {
            flag = false;
            if (LoRaDriver.getInstance().startDevice(ids[i2], serialNumberList)) {
                flag = true;
            }
            if (flag) continue;
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.phone_please_do_not_select_the_device_not_connected_or_in_the_enabled_state"));
            req.setAttribute("LoRas", LoRaDriver.getInstance().getAll());
            this.findForward("loraInfoPage.jsp", true, req, resp);
            return;
        }
        req.setAttribute("LoRas", LoRaDriver.getInstance().getAll());
        this.findForward("loraInfoPage.jsp", true, req, resp);
    }

    public void startNbIoTs(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String[] ids = req.getParameter("ids").split(",");
        for (int i2 = 0; i2 < ids.length; ++i2) {
            if (nbiotDeviceInfoGetter.checkStartNbIoT(ids[i2])) {
                req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.nbiot_start_tips2"));
                req.setAttribute("NbIoTs", NbIoTDeviceInfoGetter.getInstance().getAll());
                this.findForward("nbiotInfoPage.jsp", true, req, resp);
                return;
            }
            if (Modem.getDriver(nbiotDeviceInfoGetter.findDeviceByPortID(ids[i2]).getDeviceType()).startDevice(ids[i2])) continue;
            Modem.getDriver(nbiotDeviceInfoGetter.findDeviceByPortID(ids[i2]).getDeviceType()).stopDevice(ids[i2]);
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.nbiot_start_tips3"));
            req.setAttribute("NbIoTs", nbiotDeviceInfoGetter.getAll());
            this.findForward("nbiotInfoPage.jsp", true, req, resp);
            return;
        }
        req.setAttribute("NbIoTs", nbiotDeviceInfoGetter.getAll());
        this.findForward("nbiotInfoPage.jsp", true, req, resp);
    }

    public void startBigDippers(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String[] ids = req.getParameter("ids").split(",");
        for (int j2 = 0; j2 < ids.length; ++j2) {
            if (!bdDeviceInfoGetter.checkStartBD(ids[j2])) continue;
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.bd_start_tips1"));
            req.setAttribute("BDs", bdDeviceInfoGetter.getAll());
            this.findForward("bigdipperInfo.jsp", true, req, resp);
            return;
        }
        for (int i2 = 0; i2 < ids.length; ++i2) {
            if (BDDriver.getInstance().startDevice(ids[i2])) continue;
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.bd_start_tips2"));
            req.setAttribute("BDs", bdDeviceInfoGetter.getAll());
            this.findForward("bigdipperInfo.jsp", true, req, resp);
            return;
        }
        req.setAttribute("BDs", bdDeviceInfoGetter.getAll());
        this.findForward("bigdipperInfo.jsp", true, req, resp);
    }

    public void stopPhones(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, CloneNotSupportedException, ConfigurationException {
        String[] ids = req.getParameter("ids").split(",");
        boolean flag = false;
        for (int i2 = 0; i2 < ids.length; ++i2) {
            if (0 != PhoneInfoCache.getInstance().stopPhones(ids[i2])) continue;
            flag = true;
        }
        if (flag) {
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.phone_please_do_not_select_the_device_not_in_the_enabled_state"));
            req.setAttribute("phones", PhoneInfoCache.getInstance().getAll());
            this.findForward("phoneInfoPage.jsp", true, req, resp);
            return;
        }
        this.savePhoneConfiguration();
        req.setAttribute("phones", PhoneInfoCache.getInstance().getAll());
        this.findForward("phoneInfoPage.jsp", true, req, resp);
    }

    public void stopLoras(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, CloneNotSupportedException, ConfigurationException {
        String[] ids = req.getParameter("ids").split(",");
        for (int i2 = 0; i2 < ids.length; ++i2) {
            if (ids[i2] == null || ids[i2].replace(" ", "").equals("")) continue;
            if (LoRaDriver.getInstance().checkStopLoras(ids[i2])) {
                req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.lora_stop_tips1"));
                req.setAttribute("LoRas", LoRaDriver.getInstance().getAll());
                this.findForward("loraInfoPage.jsp", true, req, resp);
                return;
            }
            boolean deviceStoped = LoRaDriver.getInstance().stopDevice(ids[i2]);
            if (deviceStoped) {
                this.log.info((Object)("\u8bbe\u5907" + ids[i2] + "\u5df2\u7ecf\u505c\u6b62"));
                continue;
            }
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.lora_start_tips2"));
            this.log.error((Object)("\u8bbe\u5907" + ids[i2] + "\u505c\u6b62\u5931\u8d25\u3002\u3002"));
        }
        req.setAttribute("LoRas", LoRaDriver.getInstance().getAll());
        this.findForward("loraInfoPage.jsp", true, req, resp);
    }

    public void stopNbIoTs(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, CloneNotSupportedException, ConfigurationException {
        String[] ids = req.getParameter("ids").split(",");
        for (int i2 = 0; i2 < ids.length; ++i2) {
            if (ids[i2] == null || ids[i2].replace(" ", "").equals("")) continue;
            if (nbiotDeviceInfoGetter.checkStopNbIoT(ids[i2])) {
                req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.lora_stop_tips1"));
                req.setAttribute("NbIoTs", nbiotDeviceInfoGetter.getAll());
                this.findForward("nbiotInfoPage.jsp", true, req, resp);
                return;
            }
            boolean deviceStopped = Modem.getDriver(nbiotDeviceInfoGetter.findDeviceByPortID(ids[i2]).getDeviceType()).stopDevice(ids[i2]);
            if (deviceStopped) {
                this.log.info((Object)("\u8bbe\u5907" + ids[i2] + "\u5df2\u7ecf\u505c\u6b62"));
                continue;
            }
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.lora_start_tips2"));
            this.log.info((Object)("\u8bbe\u5907" + ids[i2] + "\u5df2\u7ecf\u505c\u6b62"));
        }
        req.setAttribute("NbIoTs", nbiotDeviceInfoGetter.getAll());
        this.findForward("nbiotInfoPage.jsp", true, req, resp);
    }

    public void stopBigDippers(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, CloneNotSupportedException, ConfigurationException {
        String[] ids = req.getParameter("ids").split(",");
        for (int i2 = 0; i2 < ids.length; ++i2) {
            if (ids[i2] == null || ids[i2].replace(" ", "").equals("")) continue;
            if (bdDeviceInfoGetter.checkStopBD(ids[i2])) {
                req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.bd_stop_tips1"));
                req.setAttribute("BDs", bdDeviceInfoGetter.getAll());
                this.findForward("bigdipperInfo.jsp", true, req, resp);
                return;
            }
            BDDriver.getInstance().stopDevice(ids[i2]);
        }
        req.setAttribute("BDs", bdDeviceInfoGetter.getAll());
        this.findForward("bigdipperInfo.jsp", true, req, resp);
    }

    public void deleteLoraConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, Exception {
        String[] ids = req.getParameter("ids").split(",");
        for (int i2 = 0; i2 < ids.length; ++i2) {
            try {
                LoraBean bean = LoRaDriver.getInstance().findDeviceByPortID(ids[i2]);
                if (!"0".equals(bean.getUsingStatus())) {
                    req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.delete_device_tip_1"));
                    this.findForward("/loraInfoPage?action=refreshLoRa", true, req, resp);
                    return;
                }
                try {
                    LoRaDriver.getInstance().deleteConfiguration(bean);
                    LoRaDriver.getInstance().deleteLora(bean.getPortID());
                    continue;
                }
                catch (ConfigurationException e2) {
                    this.log.error((Object)"\u5220\u9664\u914d\u7f6e\u5931\u8d25");
                    req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info"));
                    this.findForward("/loraInfoPage?action=refreshLoRa", true, req, resp);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.log.info((Object)"\u5220\u9664\u914d\u7f6e\u6210\u529f");
        List<LoraBean> list = LoRaDriver.getInstance().getAll();
        req.setAttribute("LoRas", list);
        this.findForward("/loraInfoPage?action=refreshLoRa", true, req, resp);
    }

    public void deleteNbIoTConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, Exception {
        String[] ids = req.getParameter("ids").split(",");
        for (int i2 = 0; i2 < ids.length; ++i2) {
            try {
                NbIoTBean bean = nbiotDeviceInfoGetter.findDeviceByPortID(ids[i2]);
                if (!"0".equals(bean.getUsingStatus())) {
                    req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.delete_device_tip_1"));
                    this.findForward("/nbiotInfoPage?action=refreshNbIoT", true, req, resp);
                    return;
                }
                try {
                    nbiotDeviceInfoGetter.deleteNbIoT(bean.getPortID());
                    continue;
                }
                catch (ConfigurationException e2) {
                    this.log.error((Object)"\u5220\u9664\u914d\u7f6e\u5931\u8d25");
                    req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info"));
                    this.findForward("/nbiotInfoPage?action=refreshNbIoT", true, req, resp);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.log.info((Object)"\u5220\u9664\u914d\u7f6e\u6210\u529f");
        List<LoraBean> list = LoRaDriver.getInstance().getAll();
        req.setAttribute("NbIoTs", list);
        this.findForward("/nbiotInfoPage?action=refreshNbIoT", true, req, resp);
    }

    public void deleteBigDipperConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, Exception {
        String[] ids = req.getParameter("ids").split(",");
        for (int i2 = 0; i2 < ids.length; ++i2) {
            try {
                BigDipperBean bean = bdDeviceInfoGetter.findDeviceByPortID(ids[i2]);
                if (!"0".equals(bean.getUsingStatus())) {
                    req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.delete_device_tip_1"));
                    this.findForward("/bigdipperInfo?action=refreshBD", true, req, resp);
                    return;
                }
                try {
                    bdDeviceInfoGetter.deleteConfiguration(bean);
                    bdDeviceInfoGetter.deleteBD(bean.getPortID());
                    continue;
                }
                catch (ConfigurationException e2) {
                    this.log.error((Object)"\u5220\u9664\u914d\u7f6e\u5931\u8d25");
                    req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info"));
                    this.findForward("/bigdipperInfo?action=refreshBD", true, req, resp);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.log.info((Object)"\u5220\u9664\u914d\u7f6e\u6210\u529f");
        List<BigDipperBean> list = bdDeviceInfoGetter.getAll();
        req.setAttribute("BDs", list);
        this.findForward("/bigdipperInfo?action=refreshBD", true, req, resp);
    }

    public void deletePhoneConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, Exception {
        String[] ids = req.getParameter("ids").split(",");
        for (int i2 = 0; i2 < ids.length; ++i2) {
            String phoneNo = ids[i2];
            PhoneInfoCache.getInstance().deletePhone(phoneNo);
        }
        List<SerialPhoneBean> list = PhoneInfoCache.getInstance().getAll();
        req.setAttribute("phones", list);
        this.findForward("phoneInfoPage.jsp", true, req, resp);
    }

    public void savePhoneConfiguration() throws ConfigurationException, CloneNotSupportedException {
        PropertiesConfiguration phoneprops = JDSMSServer.getInstance().getProperties();
        List<SerialPhoneBean> list = PhoneInfoCache.getInstance().getAll();
        int listLen = list.size();
        String[] values = null;
        for (int index = 0; index < listLen; ++index) {
            int iTmp = index + 1;
            phoneprops.setProperty("phoneDevice." + index, (Object)("phone" + iTmp));
            list.get(index).setPhoneID("phone" + iTmp);
            values = phoneprops.getStringArray("phoneDevice." + index);
            phoneprops.setProperty(values[0] + ".no", (Object)list.get(index).getPhoneNo());
            phoneprops.setProperty(values[0] + ".imei", (Object)list.get(index).getPhoneImei());
            phoneprops.setProperty(values[0] + ".battery", (Object)list.get(index).getBattery());
            phoneprops.setProperty(values[0] + ".charging", (Object)list.get(index).getChargingStatus());
            phoneprops.setProperty(values[0] + ".device_info", (Object)list.get(index).getDeviceInfo());
            phoneprops.setProperty(values[0] + ".using_status", (Object)list.get(index).getUsingStatus());
        }
        phoneprops.save();
    }

    public void regDeviceInit(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String gatewayid = req.getParameter("id");
        String serialnum = "";
        String error = ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_failed_to_get_imei");
        long begin = System.currentTimeMillis();
        try {
            if (DeviceInfoCache.getInstance().findDevice(gatewayid).getGateway() == null || DeviceInfoCache.getInstance().get(gatewayid).getStatus() != AGatewayHelper.GatewayStatuses.STARTED) {
                if (DeviceInfoCache.getInstance().get(gatewayid).getStatus() != AGatewayHelper.GatewayStatuses.STOPPED) {
                    req.setAttribute("message", (Object)(ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_reg_failure_info1") + DeviceInfoCache.getInstance().get(gatewayid).getDescription() + ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_reg_failure_info2")));
                    this.refresh(req, resp);
                    return;
                }
                DeviceInfoCache.DeviceBean bean = DeviceInfoCache.getInstance().findDevice(gatewayid);
                GetPortInfo hanlder = null;
                if ("IpModem".equals(bean.getDeviceInfo().getModemFlag())) {
                    NetDeviceBean deviceBean = new NetDeviceBean();
                    deviceBean.setId("");
                    deviceBean.setDeviceIp(bean.getDeviceInfo().getIpAddress());
                    deviceBean.setCheckingPort(bean.getDeviceInfo().getIpPort());
                    hanlder = new GetIpModemInfo(deviceBean);
                } else {
                    Properties options = new Properties();
                    options.setProperty("portname", gatewayid);
                    options.setProperty("baudrate", DeviceInfoCache.getInstance().get(gatewayid).getBaudrate() + "");
                    hanlder = new GetSerialPortInfoByGateway(options);
                }
                ((GetPortInfo)hanlder).handler();
                serialnum = hanlder.serialmodem.getSerialnum();
            } else {
                String deviceType = DeviceInfoCache.getInstance().findDevice(gatewayid).getGateway().sendCustomATCommand("ATI3\r");
                serialnum = deviceType.indexOf("Q2406B") != -1 ? DeviceInfoCache.getInstance().findDevice(gatewayid).getGateway().getSerialNumber1() : (deviceType.indexOf("MH5000-31") != -1 ? DeviceInfoCache.getInstance().findDevice(gatewayid).getGateway().getSerialNumber1() : DeviceInfoCache.getInstance().findDevice(gatewayid).getGateway().getSerialNumber());
                if (serialnum == null || serialnum.indexOf("ERROR") >= 0 || serialnum.indexOf("N/A") >= 0) {
                    serialnum = DeviceInfoCache.getInstance().findDevice(gatewayid).getGateway().getSerialNumber1();
                }
            }
            if (serialnum == null || serialnum.indexOf("ERROR") >= 0 || serialnum.equals("") || serialnum.indexOf("N/A") >= 0) {
                serialnum = "";
                req.setAttribute("error", (Object)error);
            }
            this.log.info((Object)("\u6ce8\u518c\u8bbe\u5907" + gatewayid + "\u5e8f\u5217\u53f7" + serialnum));
        }
        catch (Exception e2) {
            this.log.error((Object)"\u83b7\u53d6\u8bbe\u5907\u6ce8\u518c\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)e2);
            serialnum = "";
            req.setAttribute("error", (Object)error);
        }
        long end = System.currentTimeMillis();
        double time = end - begin;
        this.log.info((Object)("\u83b7\u53d6\u8bbe\u5907" + gatewayid + "\u5e8f\u5217\u53f7\u8017\u65f6" + (time /= 1000.0) + "\u79d2"));
        req.setAttribute("serialnum", (Object)serialnum);
        req.setAttribute("gatewayid", (Object)gatewayid);
        String regcode = NewAuth.getAuthorizeInfo(serialnum, "regcode");
        if (regcode == null || regcode.indexOf("null") != -1 || regcode.length() < 3) {
            regcode = "";
        }
        req.setAttribute("regcode", (Object)regcode);
        if (serialnum.equals("") || regcode.equals("")) {
            this.findForward("device-register.jsp", true, req, resp);
            return;
        }
        int nNewType = NewAuth.checkDevRegCode(serialnum, regcode);
        if (nNewType == 1) {
            req.setAttribute("info", (Object)(NewAuth.getAuthorizeInfo(serialnum, "authorize_time") != null ? ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_reg_success_info") + NewAuth.getAuthorizeInfo(serialnum, "authorize_time") : ""));
        } else if (req.getAttribute("error") == null) {
            req.setAttribute("error", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_reg_failure_info3"));
        }
        this.findForward("device-register.jsp", true, req, resp);
    }

    public void regDevice(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Integer isAuthorize = 0;
        try {
            String serialnum = req.getParameter("serialnum");
            String regCode = req.getParameter("regcode");
            String gatewayid = req.getParameter("gatewayid");
            req.setAttribute("serialnum", (Object)serialnum);
            req.setAttribute("regcode", (Object)regCode);
            req.setAttribute("gatewayid", (Object)gatewayid);
            int nNewType = NewAuth.checkDevRegCode(serialnum, regCode);
            if (nNewType == 1) {
                isAuthorize = 1;
                req.setAttribute("message", (Object)"\u606d\u559c\u60a8\u8bbe\u5907\u6ce8\u518c\u6210\u529f\uff01");
                req.setAttribute("info", (Object)(NewAuth.getAuthorizeInfo(serialnum, "authorize_time") != null ? "\u6388\u6743\u6709\u6548\uff0c\u6388\u6743\u65f6\u95f4\u4e3a\uff1a" + NewAuth.getAuthorizeInfo(serialnum, "authorize_time") : ""));
                DeviceInfoCache.getInstance().get(gatewayid).setValidate(true);
            } else {
                isAuthorize = 0;
                if (nNewType == 2) {
                    req.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u5df2\u8fc7\u671f\uff01");
                    req.setAttribute("error", (Object)"\u6388\u6743\u5df2\u8fc7\u671f");
                } else if (nNewType == 3) {
                    req.setAttribute("message", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6ce8\u518c\u65e0\u6548\uff01");
                    req.setAttribute("error", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6388\u6743\u65e0\u6548");
                } else {
                    req.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u65e0\u6548\uff01");
                    req.setAttribute("error", (Object)"\u6388\u6743\u65e0\u6548");
                }
                DeviceInfoCache.getInstance().get(gatewayid).setValidate(false);
            }
            NewAuth.saveAuthorize(gatewayid, serialnum, regCode);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            req.setAttribute("serialnum", (Object)"");
            req.setAttribute("regcode", (Object)"");
            req.setAttribute("gatewayid", (Object)"");
            req.setAttribute("message", (Object)"\u6ce8\u518c\u8bbe\u5907\u5931\u8d25\uff01");
            req.setAttribute("error", (Object)"\u6ce8\u518c\u8bbe\u5907\u5931\u8d25\uff01");
        }
        this.findForward("device-register.jsp", true, req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDevice(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            if (DeviceInfoCache.getInstance().getStatus().equals((Object)DeviceInfoCache.CheckStatus.RUNNING)) {
                req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_check_info1"));
                req.setAttribute("devices", DeviceInfoCache.getInstance().getAll());
                this.findForward("device-config.jsp", true, req, resp);
                return;
            }
            boolean flag = false;
            for (AGateway gateway : Service.getInstance().getGateways()) {
                if (gateway.getStatus() == AGatewayHelper.GatewayStatuses.STOPPED || gateway.getStatus() == AGatewayHelper.GatewayStatuses.FAILURE || gateway.getStatus() == AGatewayHelper.GatewayStatuses.NOPORT || gateway.getStatus() == AGatewayHelper.GatewayStatuses.OCCUPY) continue;
                flag = true;
                break;
            }
            Iterator<AGateway> iter = null;
            if (flag) {
                req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_check_info2"));
                req.setAttribute("devices", DeviceInfoCache.getInstance().getAll());
                this.findForward("device-config.jsp", true, req, resp);
                return;
            }
            DeviceInfoCache.getInstance().updateDeviceInfo();
            req.setAttribute("devices", DeviceInfoCache.getInstance().getAll());
            req.setAttribute("needSaveConfig", (Object)new String());
        }
        catch (CloneNotSupportedException e2) {
            this.log.error((Object)"get device list failed", (Throwable)e2);
        }
        finally {
            DeviceInfoCache.getInstance().setStatus(DeviceInfoCache.CheckStatus.STOPPED);
        }
        this.findForward("device-config.jsp", true, req, resp);
    }

    public void checkDeviceLoRa(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!LoRaDriver.getInstance().getUsingLoraList().isEmpty()) {
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_check_info2"));
            req.setAttribute("LoRas", LoRaDriver.getInstance().getAll());
            this.findForward("loraInfoPage.jsp", true, req, resp);
            return;
        }
        LoRaDriver.getInstance().deleteAll();
        try {
            LoRaDriver.getInstance().getLoRaDeviceInfo();
        }
        catch (Exception e2) {
            this.log.error((Object)"\u68c0\u6d4b\u8bbe\u5907\u51fa\u73b0\u5f02\u5e38\u3002\u3002\u3002", (Throwable)e2);
        }
        req.setAttribute("LoRas", LoRaDriver.getInstance().getAll());
        if (LoRaDriver.getInstance().getAll().isEmpty()) {
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.lora_check_tips1"));
        } else {
            req.setAttribute("needSaveConfig", (Object)new String());
        }
        this.findForward("loraInfoPage.jsp", true, req, resp);
    }

    public void checkDeviceNbIoT(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!nbiotDeviceInfoGetter.getUsingNbIoTList().isEmpty()) {
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_check_info2"));
            req.setAttribute("NbIoTs", nbiotDeviceInfoGetter.getAll());
            this.findForward("nbiotInfoPage.jsp", true, req, resp);
            return;
        }
        try {
            nbiotDeviceInfoGetter.getNbIoTDeviceInfo();
        }
        catch (Exception e2) {
            this.log.error((Object)"\u68c0\u6d4b\u8bbe\u5907\u65f6\u51fa\u73b0\u5f02\u5e38\u3002\u3002\u3002", (Throwable)e2);
        }
        req.setAttribute("NbIoTs", nbiotDeviceInfoGetter.getAll());
        if (nbiotDeviceInfoGetter.getAll().isEmpty()) {
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.nbiot_check_tips1"));
        } else {
            req.setAttribute("needSaveConfig", (Object)new String());
        }
        this.findForward("nbiotInfoPage.jsp", true, req, resp);
    }

    public void checkDeviceBigDipper(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!bdDeviceInfoGetter.getUsingBDList().isEmpty()) {
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_check_info2"));
            req.setAttribute("BDs", bdDeviceInfoGetter.getAll());
            this.findForward("bigdipperInfo.jsp", true, req, resp);
            return;
        }
        bdDeviceInfoGetter.deleteAll();
        try {
            bdDeviceInfoGetter.getBDDeviceInfo();
        }
        catch (Exception e2) {
            this.log.error((Object)"\u68c0\u6d4b\u8bbe\u5907\u51fa\u73b0\u5f02\u5e38\u4fe1\u606f");
        }
        req.setAttribute("BDs", bdDeviceInfoGetter.getAll());
        if (bdDeviceInfoGetter.getAll().isEmpty()) {
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.bd_check_tips1"));
        } else {
            req.setAttribute("needSaveConfig", (Object)new String());
        }
        this.findForward("bigdipperInfo.jsp", true, req, resp);
    }

    public void details(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException {
        this.device = DeviceInfoCache.getInstance().get(req.getParameter("id").trim());
        DbHelper helper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
        String strCCID = this.device.getCcid();
        AlertInfo demo = helper.getAlertInfoFromDB(strCCID);
        this.device.setAlert(demo);
        this.findForward("device-details.jsp", true, req, resp);
    }

    public void save(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            if (DeviceInfoCache.getInstance().get(this.device.getPort()).getStatus().equals((Object)AGatewayHelper.GatewayStatuses.FAILURE)) {
                req.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info1"));
                this.findForward("/device-details.jsp", true, req, resp);
                return;
            }
            if (DeviceInfoCache.getInstance().get(this.device.getPort()).getStatus().equals((Object)AGatewayHelper.GatewayStatuses.OCCUPY)) {
                req.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info2"));
                this.findForward("/device-details.jsp", true, req, resp);
                return;
            }
            if (DeviceInfoCache.getInstance().get(this.device.getPort()).getStatus().equals((Object)AGatewayHelper.GatewayStatuses.NOPORT)) {
                req.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info3"));
                this.findForward("/device-details.jsp", true, req, resp);
                return;
            }
            int nAlertNumber = Integer.parseInt(req.getParameter("device.alert_number"));
            String strCallNumber = req.getParameter("device.administrator_phone");
            int nSentNumber = Integer.parseInt(req.getParameter("device.sent_number"));
            HttpRequestReader paramReader = new HttpRequestReader(req, "gbk");
            String strAlertMsg = paramReader.getParameter("device.AlertMsg");
            int nMaxLimitNumber = Integer.parseInt(req.getParameter("device.MaxLimitNumber"));
            String strCCID = this.device.getCcid();
            if (nMaxLimitNumber < 0 || nAlertNumber < 0) {
                req.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info4"));
                this.findForward("/device-details.jsp", true, req, resp);
                return;
            }
            if (nMaxLimitNumber > nAlertNumber) {
                req.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info5"));
                this.findForward("/device-details.jsp", true, req, resp);
                return;
            }
            if (nMaxLimitNumber == 0 && nAlertNumber != 0) {
                req.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info6"));
                this.findForward("/device-details.jsp", true, req, resp);
                return;
            }
            if ((strCallNumber.trim().isEmpty() || strAlertMsg.trim().isEmpty()) && (nMaxLimitNumber != 0 || nAlertNumber != 0)) {
                req.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info7"));
                this.findForward("/device-details.jsp", true, req, resp);
                return;
            }
            AlertInfo demo = new AlertInfo(nAlertNumber, nSentNumber, strCallNumber, strCCID, strAlertMsg, nMaxLimitNumber);
            this.device.setAlert(demo);
            DbHelper helper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            helper.AddAlertInfoToDB(demo);
            this.saveToConfig(this.device);
            DeviceInfoCache.getInstance().put(this.device);
            if (DeviceInfoCache.getInstance().findDevice(this.device).getGateway() != null) {
                DeviceInfoCache.getInstance().findDevice(this.device).getGateway().setGatewayId(this.device.getGatewayID());
            }
        }
        catch (Exception e2) {
            this.log.error((Object)("\u4fdd\u5b58\u914d\u7f6e\u4fe1\u606f\u51fa\u9519\uff01 ---" + this.device.getGatewayID()), (Throwable)e2);
            req.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info8"));
            this.findForward("/device-details.jsp", true, req, resp);
            return;
        }
        req.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_success_info"));
        this.findForward("/device-details.jsp", true, req, resp);
    }

    public void start(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, CloneNotSupportedException {
        String[] ids = req.getParameter("ids").split(",");
        boolean flag = false;
        for (int i2 = 0; i2 < ids.length; ++i2) {
            SerialModemBean gateway = DeviceInfoCache.getInstance().findDevice(ids[i2]).getDeviceInfo();
            if (gateway.getStatus() != AGatewayHelper.GatewayStatuses.FAILURE && gateway.getStatus() != AGatewayHelper.GatewayStatuses.NOPORT && gateway.getStatus() != AGatewayHelper.GatewayStatuses.OCCUPY && gateway.getStatus() != AGatewayHelper.GatewayStatuses.STARTED && gateway.getStatus() != AGatewayHelper.GatewayStatuses.RESTART && gateway.getStatus() != AGatewayHelper.GatewayStatuses.STARTING) continue;
            flag = true;
            break;
        }
        if (flag) {
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_start_info"));
            req.setAttribute("devices", DeviceInfoCache.getInstance().getAll());
            this.findForward("device-config.jsp", true, req, resp);
            return;
        }
        d manager = new d();
        for (int i3 = 0; i3 < ids.length; ++i3) {
            DeviceInfoCache.DeviceBean d2 = DeviceInfoCache.getInstance().findDevice(ids[i3]);
            if (d2 == null || d2.getDeviceInfo().getStatus() == AGatewayHelper.GatewayStatuses.STARTED || d2.getDeviceInfo().getStatus() == AGatewayHelper.GatewayStatuses.STARTING || d2.getDeviceInfo().getStatus() == AGatewayHelper.GatewayStatuses.RESTART) continue;
            class A
            extends c {
                private DeviceInfoCache.DeviceBean b;

                public A(DeviceInfoCache.DeviceBean device) {
                    this.b = device;
                }

                @Override
                public void a() throws IOException {
                    try {
                        this.b.startGateway();
                        if (!Service.getInstance().getGateways().contains(this.b.getGateway()) && this.b.getGateway() != null) {
                            Service.getInstance().getGateways().remove(Service.getInstance().getGateway(this.b.getGateway().getGatewayId()));
                            Service.getInstance().getGateways().add(this.b.getGateway());
                        }
                    }
                    catch (Exception e2) {
                        if (e2 instanceof GatewayException) {
                            this.b.getGateway().setStatus(AGatewayHelper.GatewayStatuses.FAILURE);
                        } else {
                            this.b.getGateway().setStatus(AGatewayHelper.GatewayStatuses.STOPPED);
                        }
                        DeviceConfigAction.this.log.error((Object)("\u542f\u52a8\u8bbe\u5907[" + this.b.getGateway().getGatewayId() + "]\u5931\u8d25"), (Throwable)e2);
                        return;
                    }
                    if (this.b.getDeviceInfo().getStatus() == AGatewayHelper.GatewayStatuses.STARTED) {
                        DeviceConfigAction.this.log.info((Object)("\u542f\u52a8\u8bbe\u5907[" + this.b.getGateway().getGatewayId() + "]\u6210\u529f"));
                    } else {
                        DeviceConfigAction.this.log.info((Object)("\u542f\u52a8\u8bbe\u5907[" + this.b.getGateway().getGatewayId() + "]\u5931\u8d25"));
                    }
                }
            }
            A s = new A(d2);
            if (Service.getInstance().getSettings().CONCURRENT_GATEWAY_START) {
                manager.a(s);
                continue;
            }
            s.run();
        }
        if (Service.getInstance().getSettings().CONCURRENT_GATEWAY_START) {
            manager.a();
        }
        this.findForward("/device-config?action=refresh", true, req, resp);
    }

    public void stop(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, CloneNotSupportedException {
        String[] ids = req.getParameter("ids").split(",");
        boolean flag = false;
        for (int i2 = 0; i2 < ids.length; ++i2) {
            SerialModemBean gateway = DeviceInfoCache.getInstance().findDevice(ids[i2]).getDeviceInfo();
            if (gateway.getStatus() != AGatewayHelper.GatewayStatuses.FAILURE && gateway.getStatus() != AGatewayHelper.GatewayStatuses.NOPORT && gateway.getStatus() != AGatewayHelper.GatewayStatuses.OCCUPY && gateway.getStatus() != AGatewayHelper.GatewayStatuses.STOPPED && gateway.getStatus() != AGatewayHelper.GatewayStatuses.STOPPING) continue;
            flag = true;
            break;
        }
        if (flag) {
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_stop_info"));
            req.setAttribute("devices", DeviceInfoCache.getInstance().getAll());
            this.findForward("device-config.jsp", true, req, resp);
            return;
        }
        d manager = new d();
        for (int i3 = 0; i3 < ids.length; ++i3) {
            DeviceInfoCache.DeviceBean d2 = DeviceInfoCache.getInstance().findDevice(ids[i3]);
            if (d2 == null || d2.getDeviceInfo().getStatus() == AGatewayHelper.GatewayStatuses.STOPPED || d2.getDeviceInfo().getStatus() == AGatewayHelper.GatewayStatuses.STOPPING) continue;
            class B
            extends c {
                DeviceInfoCache.DeviceBean a;

                public B(DeviceInfoCache.DeviceBean device) {
                    this.a = device;
                }

                @Override
                public void a() {
                    try {
                        Service.getInstance().getGateways().remove(this.a.getGateway());
                        this.a.getGateway().stopGateway();
                    }
                    catch (Exception e2) {
                        this.a.getGateway().setStatus(AGatewayHelper.GatewayStatuses.STOPPED);
                        DeviceConfigAction.this.log.info((Object)("\u505c\u6b62\u8bbe\u5907[" + this.a.getGateway().getGatewayId() + "]\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38"));
                        return;
                    }
                    DeviceConfigAction.this.log.info((Object)("\u505c\u6b62\u8bbe\u5907[" + this.a.getGateway().getGatewayId() + "]\u6210\u529f"));
                }
            }
            manager.a(new B(d2));
        }
        manager.a();
        this.findForward("/device-config?action=refresh", true, req, resp);
    }

    public void deleteConfig(HttpServletRequest req, HttpServletResponse resp) {
        DeviceInfoCache.DeviceBean d2;
        int i2;
        String[] ids = req.getParameter("ids").split(",");
        for (i2 = 0; i2 < ids.length; ++i2) {
            d2 = DeviceInfoCache.getInstance().findDevice(ids[i2]);
            if (d2 == null || d2.getDeviceInfo().getStatus() != AGatewayHelper.GatewayStatuses.STARTED && d2.getDeviceInfo().getStatus() != AGatewayHelper.GatewayStatuses.STARTING) continue;
            req.setAttribute("message", (Object)"\u9009\u4e2d\u7684\u8bbe\u5907\u5305\u542b\u5df2\u542f\u52a8\u6216\u6b63\u5728\u542f\u52a8\u7684\u8bbe\u5907\uff0c\u8bf7\u5c06\u5176\u505c\u6b62\uff0c\u518d\u505a\u5220\u9664\u5904\u7406");
            this.findForward("/device-config?action=refresh", true, req, resp);
            return;
        }
        for (i2 = ids.length - 1; i2 > -1; --i2) {
            d2 = DeviceInfoCache.getInstance().findDevice(ids[i2]);
            if (d2 == null || d2.getDeviceInfo().getStatus() == AGatewayHelper.GatewayStatuses.STARTED || d2.getDeviceInfo().getStatus() == AGatewayHelper.GatewayStatuses.STARTING) continue;
            try {
                this.deleteConfiguration(d2.getDeviceInfo());
                this.log.info((Object)("\u5220\u9664\u8bbe\u5907[" + d2.getDeviceInfo().getGatewayID() + "]\u4fe1\u606f\u6210\u529f"));
            }
            catch (Exception e2) {
                this.log.error((Object)("\u5220\u9664\u8bbe\u5907[" + d2.getDeviceInfo().getGatewayID() + "]\u4fe1\u606f\u5931\u8d25"), (Throwable)e2);
            }
            DeviceInfoCache.getInstance().remove(d2);
            Service.getInstance().getGateways().remove(d2.getGateway());
        }
        this.findForward("/device-config?action=refresh", true, req, resp);
    }

    public void saveConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String[] ids = req.getParameter("ids").split(",");
        ArrayList<String> unknowlist = new ArrayList<String>();
        for (int i2 = 0; i2 < ids.length; ++i2) {
            DeviceInfoCache.DeviceBean d2 = DeviceInfoCache.getInstance().findDevice(ids[i2]);
            if (d2 == null) continue;
            try {
                if (d2.getDeviceInfo().getStatus().equals((Object)AGatewayHelper.GatewayStatuses.FAILURE) || d2.getDeviceInfo().getStatus().equals((Object)AGatewayHelper.GatewayStatuses.NOPORT) || d2.getDeviceInfo().getStatus().equals((Object)AGatewayHelper.GatewayStatuses.OCCUPY)) {
                    unknowlist.add(d2.getDeviceInfo().getPort());
                    continue;
                }
                this.saveToConfig(d2.getDeviceInfo());
                if (d2.getGateway() == null) continue;
                d2.getGateway().setGatewayId(d2.getDeviceInfo().getGatewayID());
                continue;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                this.log.info((Object)"\u4fdd\u5b58\u914d\u7f6e\u5931\u8d25");
                req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info"));
            }
        }
        this.log.info((Object)"\u4fdd\u5b58\u914d\u7f6e\u6210\u529f");
        if (unknowlist.size() == 0) {
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_success_info1"));
        } else {
            req.setAttribute("message", (Object)(ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_success_info2") + unknowlist + ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_success_info3")));
        }
        this.findForward("/device-config?action=refresh", true, req, resp);
    }

    protected void saveToConfig(SerialModemBean bean) throws Exception {
        int count = 0;
        boolean isIpModem = false;
        if ("IpModem".equals(bean.getModemFlag())) {
            isIpModem = true;
        }
        boolean flag = false;
        Configuration config = JDSMSServer.getInstance().getProperties().subset("gateway");
        Iterator it = config.getKeys();
        while (it.hasNext()) {
            String v = config.getString((String)it.next());
            if (!v.startsWith(bean.getGatewayID())) continue;
            flag = true;
            break;
        }
        if (!flag) {
            while (count < 64) {
                if (JDSMSServer.getInstance().getProperties().getString("gateway." + count, "").length() == 0) {
                    bean.setGatewayID("modem" + (count + 1));
                    break;
                }
                ++count;
            }
            if (isIpModem) {
                JDSMSServer.getInstance().getProperties().setProperty("gateway." + count, (Object)(bean.getGatewayID() + " ,IPModem"));
            } else {
                JDSMSServer.getInstance().getProperties().setProperty("gateway." + count, (Object)(bean.getGatewayID() + " ,SerialModem"));
            }
        }
        if (isIpModem) {
            JDSMSServer.getInstance().getProperties().setProperty(bean.getGatewayID() + ".ip", (Object)bean.getIpAddress());
            JDSMSServer.getInstance().getProperties().setProperty(bean.getGatewayID() + ".port", (Object)bean.getIpPort());
            JDSMSServer.getInstance().getProperties().setProperty(bean.getGatewayID() + ".ipprotocol", (Object)"binary");
        } else {
            JDSMSServer.getInstance().getProperties().setProperty(bean.getGatewayID() + ".port", (Object)bean.getPort());
        }
        JDSMSServer.getInstance().getProperties().setProperty(bean.getGatewayID() + ".baudrate", (Object)(bean.getBaudrate() + ""));
        JDSMSServer.getInstance().getProperties().setProperty(bean.getGatewayID() + ".manufacturer", (Object)bean.getManufacturer());
        JDSMSServer.getInstance().getProperties().setProperty(bean.getGatewayID() + ".model", (Object)bean.getModel());
        JDSMSServer.getInstance().getProperties().setProperty(bean.getGatewayID() + ".protocol", (Object)bean.getProtocol().name());
        JDSMSServer.getInstance().getProperties().setProperty(bean.getGatewayID() + ".pin", (Object)bean.getPin());
        JDSMSServer.getInstance().getProperties().setProperty(bean.getGatewayID() + ".inbound", (Object)bean.getInbound());
        JDSMSServer.getInstance().getProperties().setProperty(bean.getGatewayID() + ".outbound", (Object)bean.getOutbound());
        JDSMSServer.getInstance().getProperties().setProperty(bean.getGatewayID() + ".smsc_number", (Object)bean.getSmsc_number());
        JDSMSServer.getInstance().getProperties().setProperty(bean.getGatewayID() + ".init_string", (Object)bean.getInit_string());
        JDSMSServer.getInstance().getProperties().save();
    }

    public void deleteConfiguration(SerialModemBean bean) throws ConfigurationException {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        boolean flag = false;
        int i2 = 0;
        for (i2 = 0; i2 < 64; ++i2) {
            Object[] values = props.getStringArray("gateway." + i2);
            if (ArrayUtils.isEmpty((Object[])values) || !((String)values[0]).equals(bean.getGatewayID())) continue;
            flag = true;
            props.clearProperty("gateway." + i2);
            break;
        }
        if (flag) {
            props.clearProperty(bean.getGatewayID() + ".ip");
            props.clearProperty(bean.getGatewayID() + ".ipprotocol");
            props.clearProperty(bean.getGatewayID() + ".port");
            props.clearProperty(bean.getGatewayID() + ".baudrate");
            props.clearProperty(bean.getGatewayID() + ".manufacturer");
            props.clearProperty(bean.getGatewayID() + ".model");
            props.clearProperty(bean.getGatewayID() + ".protocol");
            props.clearProperty(bean.getGatewayID() + ".pin");
            props.clearProperty(bean.getGatewayID() + ".inbound");
            props.clearProperty(bean.getGatewayID() + ".outbound");
            props.clearProperty(bean.getGatewayID() + ".smsc_number");
            props.clearProperty(bean.getGatewayID() + ".init_string");
        }
        props.save();
    }

    public void addNetDevice(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/xml;charset=UTF-8");
        String errorcode = "0";
        String errorDesc = "\u6210\u529f";
        NetDeviceBean netDevice = new NetDeviceBean();
        netDevice.setDeviceIp(this.deviceIp);
        netDevice.setStartPort(this.startPort);
        netDevice.setEndPort(this.endPort);
        try {
            int count = 0;
            boolean flag = false;
            Configuration config = JDSMSServer.getInstance().getProperties().subset("netdevice");
            Iterator it = config.getKeys();
            while (it.hasNext()) {
                String[] v = config.getStringArray((String)it.next());
                if (!v[1].startsWith(netDevice.getDeviceIp())) continue;
                flag = true;
                netDevice.setId("device" + (count + 1));
                break;
            }
            if (!flag) {
                while (count < 64) {
                    if (JDSMSServer.getInstance().getProperties().getString("netdevice." + count, "").length() == 0) {
                        netDevice.setId("device" + (count + 1));
                        break;
                    }
                    ++count;
                }
                JDSMSServer.getInstance().getProperties().setProperty("netdevice." + count, (Object)(netDevice.getId() + "," + netDevice.getDeviceIp()));
            }
            JDSMSServer.getInstance().getProperties().setProperty(netDevice.getId() + ".ip", (Object)netDevice.getDeviceIp());
            JDSMSServer.getInstance().getProperties().setProperty(netDevice.getId() + ".startPort", (Object)netDevice.getStartPort());
            JDSMSServer.getInstance().getProperties().setProperty(netDevice.getId() + ".endPort", (Object)netDevice.getEndPort());
            JDSMSServer.getInstance().getProperties().setProperty(netDevice.getId() + ".ip", (Object)netDevice.getDeviceIp());
            JDSMSServer.getInstance().getProperties().save();
        }
        catch (Exception e2) {
            errorcode = "-1";
            errorDesc = "\u4fdd\u5b58\u914d\u7f6e\u4fe1\u606f\u5931\u8d25";
            this.log.error((Object)("\u4fdd\u5b58\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u9519\u8bef: " + e2.getMessage()));
        }
        Document doc = DocumentHelper.createDocument();
        Element rootElt = doc.addElement("result");
        rootElt.addElement("error").addText(errorcode);
        rootElt.addElement("errorDesc").addText(errorDesc);
        String xmlString = doc.asXML();
        try {
            response.getWriter().print(xmlString);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    public void delNetDevice(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/xml;charset=UTF-8");
        String errorcode = "0";
        String errorDesc = "\u6210\u529f";
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        try {
            boolean flag = false;
            Object deviceId = "";
            int i2 = 0;
            for (i2 = 0; i2 < 64; ++i2) {
                Object[] values = props.getStringArray("netdevice." + i2);
                if (ArrayUtils.isEmpty((Object[])values) || !((String)values[1]).startsWith(this.deviceIp)) continue;
                flag = true;
                deviceId = values[0];
                props.clearProperty("netdevice." + i2);
                break;
            }
            if (flag) {
                props.clearProperty((String)deviceId + ".ip");
                props.clearProperty((String)deviceId + ".startPort");
                props.clearProperty((String)deviceId + ".endPort");
            }
            props.save();
        }
        catch (Exception e2) {
            errorcode = "-1";
            errorDesc = "\u5220\u9664\u914d\u7f6e\u4fe1\u606f\u5931\u8d25";
            this.log.error((Object)("\u5220\u9664\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u9519\u8bef: " + e2.getMessage()));
        }
        Document doc = DocumentHelper.createDocument();
        Element rootElt = doc.addElement("result");
        rootElt.addElement("error").addText(errorcode);
        rootElt.addElement("errorDesc").addText(errorDesc);
        String xmlString = doc.asXML();
        try {
            response.getWriter().print(xmlString);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    public void saveLoraConfig(HttpServletRequest req, HttpServletResponse resp) {
        String[] ids = req.getParameter("ids").split(",");
        for (int i2 = 0; i2 < ids.length; ++i2) {
            try {
                LoraBean bean = LoRaDriver.getInstance().findDeviceByPortID(ids[i2]);
                if (bean == null) continue;
                try {
                    LoRaDriver.getInstance().saveConfigInfo(bean);
                    continue;
                }
                catch (ConfigurationException e2) {
                    this.log.error((Object)"\u4fdd\u5b58\u914d\u7f6e\u5931\u8d25");
                    req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info"));
                    this.findForward("/loraInfoPage?action=refreshLoRa", true, req, resp);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.log.info((Object)"\u4fdd\u5b58\u914d\u7f6e\u6210\u529f");
        req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_success_info1"));
        this.findForward("/loraInfoPage?action=refreshLoRa", true, req, resp);
    }

    public void saveNbIoTConfig(HttpServletRequest req, HttpServletResponse resp) {
        String[] ids = req.getParameter("ids").split(",");
        for (int i2 = 0; i2 < ids.length; ++i2) {
            try {
                NbIoTBean bean = nbiotDeviceInfoGetter.findDeviceByPortID(ids[i2]);
                if (bean == null) continue;
                try {
                    nbiotDeviceInfoGetter.saveConfigInfo(bean);
                    continue;
                }
                catch (ConfigurationException e2) {
                    this.log.error((Object)"\u4fdd\u5b58\u914d\u7f6e\u5931\u8d25");
                    req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info"));
                    this.findForward("/nbiotInfoPage?action=refreshNbIoT", true, req, resp);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.log.info((Object)"\u4fdd\u5b58\u914d\u7f6e\u6210\u529f");
        req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_success_info1"));
        this.findForward("/nbiotInfoPage?action=refreshNbIoT", true, req, resp);
    }

    public void saveBigDipperConfig(HttpServletRequest req, HttpServletResponse resp) {
        String[] ids = req.getParameter("ids").split(",");
        for (int i2 = 0; i2 < ids.length; ++i2) {
            try {
                BigDipperBean bean = bdDeviceInfoGetter.findDeviceByPortID(ids[i2]);
                if (bean == null) continue;
                try {
                    bdDeviceInfoGetter.saveConfigInfo(bean);
                    continue;
                }
                catch (ConfigurationException e2) {
                    this.log.error((Object)"\u4fdd\u5b58\u914d\u7f6e\u5931\u8d25");
                    req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_failure_info"));
                    this.findForward("/bigdipperInfo?action=refreshBD", true, req, resp);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.log.info((Object)"\u4fdd\u5b58\u914d\u7f6e\u6210\u529f");
        req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_sava_success_info1"));
        this.findForward("/bigdipperInfo?action=refreshBD", true, req, resp);
    }

    public void regLoraDeviceInit(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String gatewayid = req.getParameter("id");
        boolean isUnderUsing = LoRaDriver.getInstance().checkStartLoras(gatewayid);
        if (isUnderUsing) {
            req.setAttribute("LoRas", LoRaDriver.getInstance().getAll());
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.lora_register_tips1"));
            this.findForward("loraInfoPage.jsp", true, req, resp);
            return;
        }
        String serialnum = LoRaDriver.getInstance().findDeviceByPortID(gatewayid).getSerialNumber();
        if (serialnum == null || serialnum.equals("")) {
            List<String> serialNumberList = LoRaDriver.getInstance().getSerialNumberList();
            LoRaDriver.getInstance().getSerialNumber(gatewayid, serialNumberList);
        }
        req.setAttribute("serialnum", (Object)serialnum);
        req.setAttribute("gatewayid", (Object)gatewayid);
        String regcode = NewAuth.getAuthorizeInfo(serialnum, "regcode");
        if (regcode == null || regcode.indexOf("null") != -1) {
            regcode = "";
        }
        if (serialnum.equals("")) {
            req.setAttribute("LoRas", LoRaDriver.getInstance().getAll());
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.lora_register_tips2"));
            this.findForward("loraInfoPage.jsp", true, req, resp);
            return;
        }
        req.setAttribute("regcode", (Object)regcode);
        this.findForward("lora-register.jsp", true, req, resp);
    }

    public void regNbIoTDeviceInit(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String gatewayid = req.getParameter("id");
        String serialnum = nbiotDeviceInfoGetter.getSerialNumber(gatewayid);
        req.setAttribute("serialnum", (Object)serialnum);
        req.setAttribute("gatewayid", (Object)gatewayid);
        String regcode = NewAuth.getAuthorizeInfo(serialnum, "regcode");
        if (regcode == null || regcode.indexOf("null") != -1) {
            regcode = "";
        }
        if (serialnum.equals("")) {
            req.setAttribute("NbIoTs", nbiotDeviceInfoGetter.getAll());
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.nbiot_register_tips1"));
            this.findForward("nbiotInfoPage.jsp", true, req, resp);
            return;
        }
        req.setAttribute("regcode", (Object)regcode);
        this.findForward("nbiot-register.jsp", true, req, resp);
    }

    public void regBigDipperDeviceInit(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String gatewayid = req.getParameter("id");
        String serialnum = bdDeviceInfoGetter.findDeviceByPortID(gatewayid).getSerialNumber();
        req.setAttribute("serialnum", (Object)serialnum);
        req.setAttribute("gatewayid", (Object)gatewayid);
        String regcode = NewAuth.getAuthorizeInfo(serialnum, "regcode");
        if (regcode == null || regcode.indexOf("null") != -1) {
            regcode = "";
        }
        if (serialnum.equals("")) {
            req.setAttribute("BDs", bdDeviceInfoGetter.getAll());
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.bd_register_tips1"));
            this.findForward("bigdipperInfo.jsp", true, req, resp);
            return;
        }
        req.setAttribute("regcode", (Object)regcode);
        this.findForward("bigdipper-register.jsp", true, req, resp);
    }

    public void regLoraDevice(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Integer isAuthorize = 0;
        try {
            String serialnum = req.getParameter("serialnum");
            String regCode = req.getParameter("regcode");
            String portID = req.getParameter("gatewayid");
            req.setAttribute("serialnum", (Object)serialnum);
            req.setAttribute("regcode", (Object)regCode);
            req.setAttribute("gatewayid", (Object)portID);
            int nNewType = NewAuth.checkDevRegCode(serialnum, regCode);
            if (nNewType == 1) {
                isAuthorize = 1;
                req.setAttribute("message", (Object)"\u606d\u559c\u60a8\u8bbe\u5907\u6ce8\u518c\u6210\u529f\uff01");
                req.setAttribute("info", (Object)(NewAuth.getAuthorizeInfo(serialnum, "authorize_time") != null ? "\u6388\u6743\u6709\u6548\uff0c\u6388\u6743\u65f6\u95f4\u4e3a\uff1a" + NewAuth.getAuthorizeInfo(serialnum, "authorize_time") : ""));
                LoRaDriver.getInstance().getPointedSerialLoraBean(portID).setValidate(true);
            } else {
                isAuthorize = 0;
                if (nNewType == 2) {
                    req.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u5df2\u8fc7\u671f\uff01");
                    req.setAttribute("error", (Object)"\u6388\u6743\u5df2\u8fc7\u671f");
                } else if (nNewType == 3) {
                    req.setAttribute("message", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6ce8\u518c\u65e0\u6548\uff01");
                    req.setAttribute("error", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6388\u6743\u65e0\u6548");
                } else {
                    req.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u65e0\u6548\uff01");
                    req.setAttribute("error", (Object)"\u6388\u6743\u65e0\u6548");
                }
                LoRaDriver.getInstance().getPointedSerialLoraBean(portID).setValidate(false);
            }
            NewAuth.saveAuthorize(portID, serialnum, regCode);
        }
        catch (Exception e2) {
            req.setAttribute("serialnum", (Object)"");
            req.setAttribute("regcode", (Object)"");
            req.setAttribute("gatewayid", (Object)"");
            req.setAttribute("message", (Object)"\u6ce8\u518c\u8bbe\u5907\u5931\u8d25\uff01");
        }
        this.findForward("lora-register.jsp", true, req, resp);
    }

    public void regNbIoTDevice(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Integer isAuthorize = 0;
        String portID = req.getParameter("gatewayid");
        String regCode = req.getParameter("regcode");
        String serialnum = req.getParameter("serialnum").toUpperCase();
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(portID);
        if (device == null) {
            req.setAttribute("message", (Object)"\u6388\u6743\u65f6\u51fa\u73b0\u5f02\u5e38\uff01");
            this.findForward("nbiot-register.jsp", true, req, resp);
            return;
        }
        if ("JD-VITUAL-NBIOT-DEVICE".equals(device.getDeviceType())) {
            String responseFromServer;
            String token;
            String para;
            String company;
            String userId;
            String telephone;
            block35: {
                telephone = req.getParameter("telephone");
                userId = req.getParameter("userId");
                company = req.getParameter("company");
                if (!serialnum.equals(device.getSerialNumber())) {
                    if (8 != serialnum.length() || !serialnum.matches("[0-9a-zA-Z]+")) {
                        req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_input_tips2"));
                        req.setAttribute("serialnum", (Object)serialnum);
                        req.setAttribute("regcode", (Object)regCode);
                        req.setAttribute("gatewayid", (Object)portID);
                        req.setAttribute("userId", (Object)userId);
                        req.setAttribute("company", (Object)company);
                        req.setAttribute("telephone", (Object)telephone);
                        this.findForward("nbiot-register.jsp", true, req, resp);
                        return;
                    }
                    String preSerialnum = device.getSerialNumber();
                    device.setSerialNumber(serialnum);
                    device.setCommunicationID(serialnum);
                    try {
                        nbiotDeviceInfoGetter.saveConfigInfo(device);
                    }
                    catch (ConfigurationException e2) {
                        device.setSerialNumber(preSerialnum);
                        device.setCommunicationID(preSerialnum);
                        req.setAttribute("message", (Object)("\u901a\u4fe1ID" + serialnum + "\u4fdd\u5b58\u5931\u8d25\uff01"));
                        req.setAttribute("serialnum", (Object)serialnum);
                        req.setAttribute("regcode", (Object)regCode);
                        req.setAttribute("gatewayid", (Object)portID);
                        req.setAttribute("userId", (Object)userId);
                        req.setAttribute("company", (Object)company);
                        req.setAttribute("telephone", (Object)telephone);
                        this.findForward("nbiot-register.jsp", true, req, resp);
                        return;
                    }
                    try {
                        if (NewAuth.getAuthorizeInfo(serialnum, "authorize_time") != null) {
                            device.setValidate(true);
                            this.findForward("nbiotInfoPage?action=refreshNbIoT", false, req, resp);
                            return;
                        }
                    }
                    catch (Exception e3) {
                        this.log.error((Object)("\u83b7\u53d6\u8bbe\u5907" + device.getGatewayID() + "\u672c\u5730\u6388\u6743\u4fe1\u606f\u51fa\u9519\uff01"), (Throwable)e3);
                    }
                } else if (device.isValidate()) {
                    req.setAttribute("message", (Object)"\u8bbe\u5907\u5df2\u7ecf\u6ce8\u518c\u6210\u529f\uff01");
                    req.setAttribute("serialnum", (Object)serialnum);
                    req.setAttribute("regcode", (Object)regCode);
                    req.setAttribute("gatewayid", (Object)portID);
                    req.setAttribute("userId", (Object)userId);
                    req.setAttribute("company", (Object)company);
                    req.setAttribute("telephone", (Object)telephone);
                    this.findForward("nbiot-register.jsp", true, req, resp);
                    return;
                }
                AuthorizeInfo authorizeInfo = new AuthorizeInfo();
                authorizeInfo.setSerialNum(serialnum);
                authorizeInfo.setRegCode(regCode);
                authorizeInfo.setGatewayId(nbiotDeviceInfoGetter.findDeviceByPortID(portID).getGatewayID());
                authorizeInfo.setTelephone(telephone);
                authorizeInfo.setUseId(userId);
                authorizeInfo.setCompany(company);
                para = NbIoTAuthorize.generatePara(authorizeInfo);
                token = NbIoTAuthorize.generateToken();
                if (!Utils.isEmptyStr(company)) {
                    try {
                        responseFromServer = NbIoTAuthorize.getAuthorizeInfoFromServer(token, "authorizeSucess", para);
                        if ("OK".equals(responseFromServer)) {
                            int nNewType = NewAuth.checkDevRegCode(serialnum, regCode);
                            if (nNewType == 1) {
                                isAuthorize = 1;
                                req.setAttribute("message", (Object)"\u606d\u559c\u60a8\u8bbe\u5907\u6ce8\u518c\u6210\u529f\uff01");
                                req.setAttribute("info", (Object)(NewAuth.getAuthorizeInfo(serialnum, "authorize_time") != null ? "\u6388\u6743\u6709\u6548\uff0c\u6388\u6743\u65f6\u95f4\u4e3a\uff1a" + NewAuth.getAuthorizeInfo(serialnum, "authorize_time") : ""));
                                nbiotDeviceInfoGetter.findDeviceByPortID(portID).setValidate(true);
                            } else {
                                isAuthorize = 0;
                                if (nNewType == 2) {
                                    req.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u5df2\u8fc7\u671f\uff01");
                                    req.setAttribute("error", (Object)"\u6388\u6743\u5df2\u8fc7\u671f");
                                } else if (nNewType == 3) {
                                    req.setAttribute("message", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6ce8\u518c\u65e0\u6548\uff01");
                                    req.setAttribute("error", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6388\u6743\u65e0\u6548");
                                } else {
                                    req.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u65e0\u6548\uff01");
                                    req.setAttribute("error", (Object)"\u6388\u6743\u65e0\u6548");
                                }
                                nbiotDeviceInfoGetter.findDeviceByPortID(portID).setValidate(false);
                            }
                            break block35;
                        }
                        req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_input_tips3"));
                        this.log.error((Object)("\u6388\u6743\u670d\u52a1\u5668\u54cd\u5e94\uff1a" + responseFromServer));
                        isAuthorize = 0;
                    }
                    catch (Exception e4) {
                        req.setAttribute("serialnum", (Object)"");
                        req.setAttribute("regcode", (Object)"");
                        req.setAttribute("gatewayid", (Object)"");
                        req.setAttribute("message", (Object)"\u6ce8\u518c\u8bbe\u5907\u5931\u8d25\uff01");
                    }
                } else {
                    req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.device_input_tips1"));
                    isAuthorize = 0;
                }
            }
            if (isAuthorize == 0 && !"OK".equals(responseFromServer = NbIoTAuthorize.getAuthorizeInfoFromServer(token, "cancellSucess", para))) {
                this.log.error((Object)"\u8bbe\u5907\u6388\u6743\u5f02\u5e38...responseFromServer");
            }
            req.setAttribute("serialnum", (Object)serialnum);
            req.setAttribute("regcode", (Object)regCode);
            req.setAttribute("gatewayid", (Object)portID);
            req.setAttribute("userId", (Object)userId);
            req.setAttribute("company", (Object)company);
            req.setAttribute("telephone", (Object)telephone);
        } else {
            try {
                int nNewType = NewAuth.checkDevRegCode(serialnum, regCode);
                if (nNewType == 1) {
                    isAuthorize = 1;
                    req.setAttribute("message", (Object)"\u606d\u559c\u60a8\u8bbe\u5907\u6ce8\u518c\u6210\u529f\uff01");
                    req.setAttribute("info", (Object)(NewAuth.getAuthorizeInfo(serialnum, "authorize_time") != null ? "\u6388\u6743\u6709\u6548\uff0c\u6388\u6743\u65f6\u95f4\u4e3a\uff1a" + NewAuth.getAuthorizeInfo(serialnum, "authorize_time") : ""));
                    device.setValidate(true);
                } else {
                    isAuthorize = 0;
                    if (nNewType == 2) {
                        req.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u5df2\u8fc7\u671f\uff01");
                        req.setAttribute("error", (Object)"\u6388\u6743\u5df2\u8fc7\u671f");
                    } else if (nNewType == 3) {
                        req.setAttribute("message", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6ce8\u518c\u65e0\u6548\uff01");
                        req.setAttribute("error", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6388\u6743\u65e0\u6548");
                    } else {
                        req.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u65e0\u6548\uff01");
                        req.setAttribute("error", (Object)"\u6388\u6743\u65e0\u6548");
                    }
                    device.setValidate(false);
                }
                req.setAttribute("serialnum", (Object)serialnum);
                req.setAttribute("regcode", (Object)regCode);
            }
            catch (Exception e5) {
                req.setAttribute("serialnum", (Object)serialnum);
                req.setAttribute("regcode", (Object)regCode);
            }
        }
        try {
            NewAuth.saveAuthorize(portID, serialnum, regCode);
        }
        catch (Exception e6) {
            this.log.error((Object)"\u6388\u6743\u5931\u8d252\uff01", (Throwable)e6);
        }
        this.findForward("nbiot-register.jsp", true, req, resp);
    }

    public void cancellNbIoTDevice(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String portID = req.getParameter("ids");
        String serialnum = req.getParameter("serialnum");
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(portID);
        if (!device.getSerialNumber().equals(serialnum)) {
            this.log.error((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u4fe1\u606f\u5f02\u5e38\uff01"));
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.nbiot_authorize_tips3"));
        }
        if (!device.isValidate()) {
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.nbiot_authorize_tips1"));
        } else {
            AuthorizeInfo authorizeInfo = new AuthorizeInfo();
            authorizeInfo.setGatewayId(device.getGatewayID());
            authorizeInfo.setSerialNum(serialnum);
            String para = NbIoTAuthorize.generatePara(authorizeInfo);
            String token = NbIoTAuthorize.generateToken();
            String responseFromServer = NbIoTAuthorize.getAuthorizeInfoFromServer(token, "cancellSucess", para);
            if ("OK".equals(responseFromServer)) {
                req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.nbiot_authorize_tips2"));
                device.setValidate(false);
            } else {
                req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.nbiot_authorize_tips3"));
                this.log.error((Object)("\u6388\u6743\u670d\u52a1\u5668\u54cd\u5e94\uff1a" + responseFromServer));
            }
        }
        this.findForward("nbiotInfoPage?action=refreshNbIoT", false, req, resp);
    }

    public void regBigDipperDevice(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Integer isAuthorize = 0;
        try {
            String serialnum = req.getParameter("serialnum");
            String regCode = req.getParameter("regcode");
            String portID = req.getParameter("gatewayid");
            req.setAttribute("serialnum", (Object)serialnum);
            req.setAttribute("regcode", (Object)regCode);
            req.setAttribute("gatewayid", (Object)portID);
            int nNewType = NewAuth.checkDevRegCode(serialnum, regCode);
            if (nNewType == 1) {
                isAuthorize = 1;
                req.setAttribute("message", (Object)"\u606d\u559c\u60a8\u8bbe\u5907\u6ce8\u518c\u6210\u529f\uff01");
                req.setAttribute("info", (Object)(NewAuth.getAuthorizeInfo(serialnum, "authorize_time") != null ? "\u6388\u6743\u6709\u6548\uff0c\u6388\u6743\u65f6\u95f4\u4e3a\uff1a" + NewAuth.getAuthorizeInfo(serialnum, "authorize_time") : ""));
                bdDeviceInfoGetter.findDeviceByPortID(portID).setValidate(true);
            } else {
                isAuthorize = 0;
                if (nNewType == 2) {
                    req.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u5df2\u8fc7\u671f\uff01");
                    req.setAttribute("error", (Object)"\u6388\u6743\u5df2\u8fc7\u671f");
                } else if (nNewType == 3) {
                    req.setAttribute("message", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6ce8\u518c\u65e0\u6548\uff01");
                    req.setAttribute("error", (Object)"\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38,\u6388\u6743\u65e0\u6548");
                } else {
                    req.setAttribute("message", (Object)"\u6ce8\u518c\u7801\u65e0\u6548\uff01");
                    req.setAttribute("error", (Object)"\u6388\u6743\u65e0\u6548");
                }
                bdDeviceInfoGetter.findDeviceByPortID(portID).setValidate(false);
            }
            NewAuth.saveAuthorize(portID, serialnum, regCode);
        }
        catch (Exception e2) {
            req.setAttribute("serialnum", (Object)"");
            req.setAttribute("regcode", (Object)"");
            req.setAttribute("gatewayid", (Object)"");
            req.setAttribute("message", (Object)"\u6ce8\u518c\u8bbe\u5907\u5931\u8d25\uff01");
        }
        this.findForward("bigdipper-register.jsp", true, req, resp);
    }

    class d {
        ArrayList<c> a = new ArrayList();

        d() {
        }

        void a(c worker) {
            this.a.add(worker);
            worker.start();
        }

        void a() {
            int count = 30;
            int internal = 1;
            while (count > 0) {
                int num = 0;
                for (int i2 = 0; i2 < this.a.size(); ++i2) {
                    if (!this.a.get((int)i2).c) continue;
                    ++num;
                }
                if (num == this.a.size()) break;
                --count;
                try {
                    Thread.sleep(internal * 1000);
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    abstract class c
    extends Thread {
        boolean c = false;

        c() {
        }

        @Override
        public void run() {
            try {
                this.a();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            this.c = true;
        }

        public abstract void a() throws IOException;
    }
}

