/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.web;

import cn.sendsms.GatewayException;
import cn.sendsms.Service;
import cn.sendsms.TimeoutException;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.web.GetIpModemInfo;
import cn.sendsms.jdsmsserver.web.GetPortInfo;
import cn.sendsms.jdsmsserver.web.GetSerialPortInfo;
import cn.sendsms.jdsmsserver.web.GetSerialPortInfoByGateway;
import cn.sendsms.jdsmsserver.web.NetDeviceBean;
import cn.sendsms.jdsmsserver.web.NewAuth;
import cn.sendsms.jdsmsserver.web.SerialModemBean;
import cn.sendsms.modem.IPModemGateway;
import cn.sendsms.modem.ModemGateway;
import cn.sendsms.modem.SerialModemGateway;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import jssc.SerialPort;
import jssc.SerialPortList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class DeviceInfoCache {
    private static final DeviceInfoCache cache = new DeviceInfoCache();
    private static final String prefix = "newmodem";
    private static byte id;
    private static Logger log;
    private CheckStatus status = CheckStatus.STOPPED;
    private Vector<DeviceBean> devices = new Vector();

    public CheckStatus getStatus() {
        return this.status;
    }

    public void setStatus(CheckStatus status) {
        this.status = status;
    }

    private DeviceInfoCache() {
        id = 1;
    }

    private synchronized void increase() {
        id = (byte)(id + 1);
    }

    public static final DeviceInfoCache getInstance() {
        return cache;
    }

    public void deleteConfiguration(SerialModemBean bean) throws ConfigurationException {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        boolean flag = false;
        int i2 = 0;
        for (i2 = 0; i2 < 64; ++i2) {
            if (props.getString("gateway." + i2, "").trim().length() == 0 || props.getString("gateway." + i2, "").indexOf(bean.getGatewayID() + " ,") == -1) continue;
            flag = true;
            props.clearProperty("gateway." + i2);
            break;
        }
        if (flag) {
            props.clearProperty(bean.getGatewayID() + ".port");
            props.clearProperty(bean.getGatewayID() + ".baudrate");
            props.clearProperty(bean.getGatewayID() + ".manufacturer");
            props.clearProperty(bean.getGatewayID() + ".model");
            props.clearProperty(bean.getGatewayID() + ".protocol");
            props.clearProperty(bean.getGatewayID() + ".pin");
            props.clearProperty(bean.getGatewayID() + ".inbound");
            props.clearProperty(bean.getGatewayID() + ".outbound");
            props.clearProperty(bean.getGatewayID() + ".smsc_number");
            props.clearProperty(bean.getGatewayID() + ".init_string");
        }
        props.save();
    }

    public void updateDeviceInfo() {
        class A
        implements Callable<SerialModemBean> {
            private Properties b;
            private NetDeviceBean c;

            A(Properties options) {
                this.b = options;
            }

            A(NetDeviceBean bean) {
                this.c = bean;
            }

            public SerialModemBean a() {
                GetPortInfo getter = null;
                getter = this.b != null ? new GetSerialPortInfoByGateway(this.b) : new GetIpModemInfo(this.c);
                getter.handler();
                String serialnum = getter.serialmodem.getSerialnum();
                boolean flag = NewAuth.checkDeviceAuth(serialnum);
                getter.serialmodem.setValidate(flag);
                if (flag) {
                    try {
                        NewAuth.updateAuthorizeTemp(getter.serialmodem.getPort(), serialnum);
                    }
                    catch (Exception e2) {
                        log.error((Object)"", (Throwable)e2);
                    }
                    cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u6388\u6743\u6709\u6548", null, getter.serialmodem.getGatewayID());
                } else {
                    try {
                        NewAuth.updateAuthorizeTemp(getter.serialmodem.getPort(), serialnum);
                    }
                    catch (Exception e3) {
                        log.error((Object)"", (Throwable)e3);
                    }
                    cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u672a\u6388\u6743", null, getter.serialmodem.getGatewayID());
                }
                return getter.serialmodem;
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.a();
            }
        }
        this.status = CheckStatus.RUNNING;
        final ArrayList<String> resultList = new ArrayList<String>();
        ExecutorService services = Executors.newSingleThreadExecutor();
        String[] portList = SerialPortList.getPortNames();
        double cbegin = System.currentTimeMillis();
        for (int i2 = 0; i2 < portList.length; ++i2) {
            long begin = System.currentTimeMillis();
            Properties options = new Properties();
            SerialPort ser_ = new SerialPort(portList[i2]);
            options.setProperty("portname", ser_.getPortName());
            SerialModemBean bean = this.get(ser_.getPortName());
            if (bean != null) {
                options.setProperty("baudrate", bean.getBaudrate() + "");
            }
            Future<SerialModemBean> result = services.submit(new A(options));
            SerialModemBean rsbean = null;
            try {
                rsbean = result.get(1L, TimeUnit.HOURS);
            }
            catch (InterruptedException e2) {
                log.error((Object)("\u68c0\u6d4b\u7aef\u53e3[" + ser_.getPortName() + "]\u88ab\u6253\u65ad"), (Throwable)e2);
            }
            catch (ExecutionException e3) {
                log.error((Object)("\u68c0\u6d4b\u7aef\u53e3[" + ser_.getPortName() + "]\u51fa\u73b0\u5f02\u5e38"), (Throwable)e3);
            }
            catch (java.util.concurrent.TimeoutException e4) {
                log.error((Object)("\u68c0\u6d4b\u7aef\u53e3[" + ser_.getPortName() + "]\u8d85\u65f6"), (Throwable)e4);
                result.cancel(true);
                log.info((Object)("\u53d6\u6d88\u68c0\u6d4b\u7aef\u53e3[" + ser_.getPortName() + "]\u7684\u4efb\u52a1\u6210\u529f\u3002"));
            }
            if (rsbean == null) {
                rsbean = new SerialModemBean();
                rsbean.setPort(ser_.getPortName());
                rsbean.setBaudrate(GetSerialPortInfo.botelvs[GetSerialPortInfo.botelvs.length - 1]);
                rsbean.setStatus(AGatewayHelper.GatewayStatuses.FAILURE);
                rsbean.setGatewayID(null);
            }
            if (bean != null) {
                rsbean.setGatewayID(bean.getGatewayID());
            }
            this.put(rsbean);
            resultList.add(ser_.getPortName());
            long end = System.currentTimeMillis();
            double total = end - begin;
            log.info((Object)("\u68c0\u6d4b\u7aef\u53e3[" + ser_.getPortName() + "]\u8017\u8d39\u65f6\u95f4" + (total /= 1000.0) + "\u79d2"));
        }
        services.shutdownNow();
        services = Executors.newSingleThreadExecutor();
        ArrayList<NetDeviceBean> list = new ArrayList<NetDeviceBean>();
        for (int i3 = 0; i3 < 64; ++i3) {
            try {
                String propName = "netdevice." + i3;
                Object[] propValues = JDSMSServer.getInstance().getProperties().getStringArray(propName);
                if (ArrayUtils.isEmpty((Object[])propValues)) continue;
                NetDeviceBean deviceBean = new NetDeviceBean();
                deviceBean.setId((String)propValues[0]);
                deviceBean.setDeviceIp(JDSMSServer.getInstance().getProperties().getString((String)propValues[0] + ".ip"));
                deviceBean.setStartPort(JDSMSServer.getInstance().getProperties().getInt((String)propValues[0] + ".startPort"));
                deviceBean.setEndPort(JDSMSServer.getInstance().getProperties().getInt((String)propValues[0] + ".endPort"));
                list.add(deviceBean);
                continue;
            }
            catch (Exception e5) {
                e5.printStackTrace();
            }
        }
        for (int x = 0; x < list.size(); ++x) {
            NetDeviceBean deviceBean = (NetDeviceBean)list.get(x);
            for (int i4 = deviceBean.getStartPort(); i4 <= deviceBean.getEndPort(); ++i4) {
                long begin = System.currentTimeMillis();
                deviceBean.setCheckingPort(i4);
                String portName = deviceBean.getDeviceIp() + ":" + deviceBean.getCheckingPort();
                SerialModemBean bean = this.get(portName);
                Future<SerialModemBean> result = services.submit(new A(deviceBean));
                SerialModemBean rsbean = null;
                try {
                    rsbean = result.get(1L, TimeUnit.MINUTES);
                }
                catch (InterruptedException e6) {
                    log.error((Object)("\u68c0\u6d4b\u7aef\u53e3[" + portName + "]\u88ab\u6253\u65ad"), (Throwable)e6);
                }
                catch (ExecutionException e7) {
                    log.error((Object)("\u68c0\u6d4b\u7aef\u53e3[" + portName + "]\u51fa\u73b0\u5f02\u5e38"), (Throwable)e7);
                }
                catch (java.util.concurrent.TimeoutException e8) {
                    log.error((Object)("\u68c0\u6d4b\u7aef\u53e3[" + portName + "]\u8d85\u65f6"), (Throwable)e8);
                    result.cancel(true);
                    log.info((Object)("\u53d6\u6d88\u68c0\u6d4b\u7aef\u53e3[" + portName + "]\u7684\u4efb\u52a1\u6210\u529f\u3002"));
                }
                if (bean != null) {
                    rsbean.setGatewayID(bean.getGatewayID());
                }
                if (rsbean == null) {
                    rsbean = new SerialModemBean();
                    rsbean.setPort(portName);
                    rsbean.setBaudrate(115200);
                    rsbean.setStatus(AGatewayHelper.GatewayStatuses.FAILURE);
                    rsbean.setGatewayID(null);
                }
                this.put(rsbean);
                resultList.add(portName);
                long end = System.currentTimeMillis();
                double total = end - begin;
                log.info((Object)("\u68c0\u6d4b\u7aef\u53e3[" + portName + "]\u8017\u8d39\u65f6\u95f4" + (total /= 1000.0) + "\u79d2"));
            }
        }
        services.shutdownNow();
        Collection rejectedList = CollectionUtils.selectRejected(this.devices, (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                DeviceBean device = (DeviceBean)arg0;
                if (!resultList.contains(device.getDeviceInfo().getPort())) {
                    Service.getInstance().getGateways().remove(Service.getInstance().getGateway(device.getDeviceInfo().getGatewayID()));
                }
                return resultList.contains(device.getDeviceInfo().getPort());
            }
        });
        this.devices.removeAll(rejectedList);
        for (Object d2 : rejectedList) {
            try {
                this.deleteConfiguration(((DeviceBean)d2).getDeviceInfo());
            }
            catch (ConfigurationException e9) {
                e9.printStackTrace();
            }
        }
        Iterator iter = null;
        double cend = System.currentTimeMillis();
        log.info((Object)("\u603b\u5171\u68c0\u6d4b\u4e86" + this.devices.size() + "\u4e2a\u8bbe\u5907\uff0c\u8017\u65f6" + (cend - cbegin) / 1000.0 + "\u79d2"));
        this.status = CheckStatus.STOPPED;
    }

    public void remove(Object obj) {
        DeviceBean bean = this.findDevice(obj);
        if (bean == null) {
            return;
        }
        this.devices.remove(bean);
    }

    public DeviceBean add(SerialModemBean obj) {
        DeviceBean bean = this.findDevice(obj);
        if (bean != null) {
            return bean;
        }
        return this.add(new DeviceBean(obj));
    }

    public DeviceBean add(DeviceBean obj) {
        DeviceBean bean = this.findDevice(obj);
        if (bean != null) {
            return bean;
        }
        this.devices.add(obj);
        Collections.sort(this.devices);
        return obj;
    }

    public DeviceBean add(String port) {
        String gatewayId = prefix + id;
        this.increase();
        SerialModemBean obj = new SerialModemBean(port, gatewayId);
        return this.add(obj);
    }

    public SerialModemBean get(Object obj) {
        DeviceBean bean = this.findDevice(obj);
        if (bean == null) {
            return null;
        }
        return bean.serialModem;
    }

    public SerialModemBean findByPort(String szPort) {
        SerialModemBean retModem = null;
        for (DeviceBean bean : this.devices) {
            SerialModemBean curModem = bean.getDeviceInfo();
            if (curModem == null || curModem.getPort() == null || !curModem.getPort().equalsIgnoreCase(szPort)) continue;
            retModem = curModem;
            break;
        }
        return retModem;
    }

    public DeviceBean findDevice(final Object obj) {
        DeviceBean bean = (DeviceBean)CollectionUtils.find(this.devices, (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                DeviceBean device = (DeviceBean)arg0;
                return device.compareTo(obj) == 0;
            }
        });
        return bean;
    }

    public List<SerialModemBean> getAll() throws CloneNotSupportedException {
        ArrayList<SerialModemBean> list = new ArrayList<SerialModemBean>();
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            list.add(this.devices.get(i2).serialModem);
        }
        return list;
    }

    public DeviceBean put(SerialModemBean obj) {
        DeviceBean bean = this.findDevice(obj);
        if (bean == null) {
            bean = this.add(new DeviceBean(obj));
        } else {
            bean.serialModem = obj;
        }
        return bean;
    }

    static {
        log = Logger.getRootLogger();
    }

    public class DeviceBean
    implements Comparable<Object> {
        private SerialModemBean serialModem;
        private ModemGateway gateway;

        public SerialModemBean getDeviceInfo() {
            return this.serialModem;
        }

        public ModemGateway getGateway() {
            return this.gateway;
        }

        public void setGateway(ModemGateway gateway) {
            this.gateway = gateway;
        }

        public DeviceBean(String port) {
            String gatewayId = DeviceInfoCache.prefix + id;
            DeviceInfoCache.this.increase();
            this.serialModem = new SerialModemBean(port, gatewayId);
        }

        public DeviceBean(SerialModemBean serialModem) {
            if (serialModem.getGatewayID() == null) {
                serialModem.setGatewayID(DeviceInfoCache.prefix + id);
                DeviceInfoCache.this.increase();
            }
            this.serialModem = serialModem;
        }

        public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
            this.gateway = "IpModem".equals(this.serialModem.getModemFlag()) ? new IPModemGateway(this.serialModem) : new SerialModemGateway(this.serialModem);
            this.gateway.startGateway();
        }

        @Override
        public int compareTo(Object o2) {
            int result = 0;
            if (o2 instanceof String) {
                String port = (String)o2;
                result = port.equals(this.serialModem.getPort()) || port.equals(this.serialModem.getGatewayID()) ? 0 : (port.length() > this.serialModem.getPort().length() ? -1 : (port.length() == this.serialModem.getPort().length() ? this.serialModem.getPort().compareTo(port) : 1));
            } else if (o2 instanceof DeviceBean) {
                DeviceBean bean = (DeviceBean)o2;
                String port = bean.serialModem.getPort();
                result = port.length() > this.serialModem.getPort().length() ? -1 : (port.length() == this.serialModem.getPort().length() ? this.serialModem.getPort().compareTo(port) : 1);
            } else if (o2 instanceof SerialModemBean) {
                SerialModemBean bean = (SerialModemBean)o2;
                String port = bean.getPort();
                result = port.length() > this.serialModem.getPort().length() ? -1 : (port.length() == this.serialModem.getPort().length() ? this.serialModem.getPort().compareTo(port) : 1);
            }
            return result;
        }
    }

    public static enum CheckStatus {
        RUNNING,
        STOPPED;

    }
}

