/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.web;

import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.helper.Logger;
import cn.sendsms.jdsmsserver.web.GetPortInfo;
import cn.sendsms.jdsmsserver.web.NetDeviceBean;
import cn.sendsms.jdsmsserver.web.SerialModemBean;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Random;
import org.apache.commons.io.IOUtils;

public class GetIpModemInfo
extends GetPortInfo {
    private Socket socket = null;
    public static final String IP_ADDRESS = "ipaddress";
    public static final String IP_PORT = "ipport";
    private NetDeviceBean deviceBean = null;
    private InputStream inStream;
    private OutputStream outStream;

    public GetIpModemInfo(NetDeviceBean deviceBean) {
        this.deviceBean = deviceBean;
        this.serialmodem = new SerialModemBean(deviceBean.getDeviceIp() + ":" + deviceBean.getCheckingPort(), null);
        this.serialmodem.setModemFlag("IpModem");
        this.serialmodem.setIpAddress(deviceBean.getDeviceIp());
        this.serialmodem.setIpPort(deviceBean.getCheckingPort());
    }

    @Override
    public void handler() {
        try {
            this.open();
        }
        catch (Exception e2) {
            this.serialmodem.setStatus(AGatewayHelper.GatewayStatuses.FAILURE);
            return;
        }
        this.serialmodem.setStatus(AGatewayHelper.GatewayStatuses.STOPPED);
        try {
            this.init();
            this.testOK();
            this.getSignal();
            this.getManufacturer();
            Logger.getInstance().logInfo("getManufacturer() : " + this.serialmodem.getManufacturer(), null, null);
            if (this.serialmodem.getManufacturer().equalsIgnoreCase("Siemens")) {
                this.getModel2();
                this.getCardNumber1();
                this.getSerialNumber1();
            } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("huawei")) {
                String result;
                this.getModel2();
                if (this.serialmodem.getModel().equalsIgnoreCase("MC323")) {
                    this.serialmodem.setProtocol(AGatewayHelper.Protocols.TEXT);
                    this.a();
                }
                if (this.serialmodem.getModel().equalsIgnoreCase("MG301")) {
                    result = null;
                    result = this.athandle("AT+CGSN\r");
                    this.serialmodem.setSerialnum(result);
                }
                if (this.serialmodem.getModel().equalsIgnoreCase("ME909") || this.serialmodem.getModel().equalsIgnoreCase("MH5000-31") || this.serialmodem.getModel().equalsIgnoreCase("MH5000-82M")) {
                    result = null;
                    result = this.athandle("AT+CGSN\r");
                    if (this.serialmodem.getModel().equalsIgnoreCase("MH5000-31")) {
                        result = this.a(result);
                    }
                    this.serialmodem.setSerialnum(result);
                    if (this.serialmodem.getModel().equalsIgnoreCase("MH5000-31")) {
                        this.getCardNumber3();
                    } else {
                        this.getCardNumber2();
                    }
                } else {
                    this.getCardNumber();
                }
            } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("TDTech")) {
                this.getModel();
                if (this.serialmodem.getModel().equalsIgnoreCase("ME909")) {
                    String result = null;
                    result = this.athandle("AT+CGSN\r");
                    this.serialmodem.setSerialnum(result);
                    this.getCardNumber2();
                } else if (this.serialmodem.getModel().equalsIgnoreCase("MH5000-82M")) {
                    String result = null;
                    result = this.athandle("AT+CGSN\r");
                    this.serialmodem.setSerialnum(result);
                    this.getCardNumber2();
                } else if (this.serialmodem.getModel().equalsIgnoreCase("ME901")) {
                    String result = null;
                    result = this.athandle("AT+CGSN\r");
                    this.serialmodem.setSerialnum(result);
                    this.getCardNumber();
                }
            } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("WAVECOM")) {
                this.getModel1();
                if (this.serialmodem.getModel().equalsIgnoreCase("WISMOQCDMA")) {
                    if (this.getVersion().indexOf("WQ2") != -1) {
                        this.b();
                    } else {
                        this.getSerialNumber();
                    }
                    this.serialmodem.setProtocol(AGatewayHelper.Protocols.TEXT);
                } else if (this.getVersion().indexOf("Q2406B") != -1) {
                    this.getSerialNumber1();
                } else {
                    this.getSerialNumber();
                }
                this.getCardNumber();
            } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("Quectel_Ltd")) {
                this.getModel();
                if (this.serialmodem.getModel().equalsIgnoreCase("Quectel_M35") || this.serialmodem.getModel().equalsIgnoreCase("Quectel_M26")) {
                    String result = null;
                    result = this.athandle("AT+CGSN\r");
                    this.serialmodem.setSerialnum(result);
                }
                this.getCardNumber();
            } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("Quectel")) {
                this.getModel();
                if (this.serialmodem.getModel().equalsIgnoreCase("EC20F")) {
                    String result = null;
                    result = this.athandle("AT+CGSN\r");
                    this.serialmodem.setSerialnum(result);
                }
                this.getCardNumber();
            } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("Yuga")) {
                this.getModel();
                Logger.getInstance().logInfo("getModel() : " + this.serialmodem.getModel(), null, null);
                if (this.serialmodem.getModel().equalsIgnoreCase("CLM920_RC3")) {
                    if ("".equals(this.serialmodem.getSerialnum())) {
                        String result = this.athandle("AT+CGSN\r");
                        this.serialmodem.setSerialnum(result);
                    }
                    this.getCardNumber4();
                } else if (this.serialmodem.getModel().equalsIgnoreCase("CLM920_RV3")) {
                    if ("".equals(this.serialmodem.getSerialnum())) {
                        String result = this.athandle("AT+CGSN\r");
                        this.serialmodem.setSerialnum(result);
                    }
                    this.getCardNumber4();
                } else if (this.serialmodem.getModel().equalsIgnoreCase("CLM920_NC5")) {
                    if ("".equals(this.serialmodem.getSerialnum())) {
                        String result = this.athandle("AT+CGSN\r");
                        this.serialmodem.setSerialnum(result);
                    }
                    this.getCardNumber();
                } else {
                    this.getModel1();
                    if ("".equals(this.serialmodem.getSerialnum())) {
                        String result = this.athandle("AT+CGSN\r");
                        this.serialmodem.setSerialnum(result);
                    }
                    this.getCardNumber();
                }
            } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("INCORPORATED")) {
                this.getModel();
                if (this.serialmodem.getModel().equalsIgnoreCase("A7600C1_SE")) {
                    String result = null;
                    result = this.athandle("AT+CGSN\r");
                    this.serialmodem.setSerialnum(result);
                    this.getCardNumberForINCORPORATED();
                } else if (this.serialmodem.getModel().equalsIgnoreCase("7600CE_L") || this.serialmodem.getModel().equalsIgnoreCase("7600CE_JT1S") || this.serialmodem.getModel().equalsIgnoreCase("7600CE_T")) {
                    String result = null;
                    result = this.athandle("AT+CGSN\r");
                    this.serialmodem.setSerialnum(result);
                    this.getCardNumberForINCORPORATED();
                }
            } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("MEIG")) {
                this.getModel();
                if (this.serialmodem.getModel().equalsIgnoreCase("SLM750_V")) {
                    if ("".equals(this.serialmodem.getSerialnum())) {
                        String result = this.athandle("AT+CGSN\r");
                        this.serialmodem.setSerialnum(result);
                    }
                    this.getCardNumber4();
                }
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
            if (!this.serialmodem.getAtFlag().equals("OK")) {
                this.serialmodem.setStatus(AGatewayHelper.GatewayStatuses.FAILURE);
            }
        }
        finally {
            this.close();
        }
    }

    private String a(String result) {
        BufferedReader reader;
        StringReader stringReader;
        block5: {
            String line;
            stringReader = new StringReader(result);
            reader = new BufferedReader(stringReader);
            do {
                line = null;
                try {
                    line = reader.readLine();
                }
                catch (IOException e2) {
                    Logger.getInstance().logError(result + "\u89e3\u6790\u5f02\u5e38!", null, null);
                }
                if (line == null) break block5;
            } while (!line.matches("[0-9]{15}"));
            return line;
        }
        try {
            reader.close();
            stringReader.close();
        }
        catch (IOException e3) {
            Logger.getInstance().logError("\u6570\u636e\u6d41\u5173\u95ed\u5f02\u5e38!", null, null);
        }
        return "";
    }

    protected void getCardNumber1() throws Exception {
        String result = null;
        result = this.athandle("AT+CXXCID\r");
        if (result.indexOf("ERROR") == -1) {
            this.serialmodem.setCcid(result.substring(result.indexOf(58) + 1));
        }
    }

    protected void getCardNumber2() throws Exception {
        String result = null;
        result = this.athandle("AT^ICCID?\r");
        if (result.indexOf("ERROR") == -1) {
            this.serialmodem.setCcid(result.substring(result.indexOf(58) + 1));
        }
    }

    protected void getCardNumber3() throws Exception {
        this.getCardNumber2();
    }

    protected void getCardNumber4() throws Exception {
        String result = null;
        result = this.athandle("AT+ICCID\r");
        if (result.indexOf("ERROR") == -1) {
            this.serialmodem.setCcid(result.substring(result.indexOf(58) + 1));
        }
    }

    public void open() throws IOException {
        this.socket = new Socket();
        this.socket.connect(new InetSocketAddress(this.deviceBean.getDeviceIp(), this.deviceBean.getCheckingPort()), 10000);
        this.socket.setSoTimeout(10000);
    }

    protected void getCardNumber() throws Exception {
        String result = null;
        result = this.athandle("AT+CCID\r");
        if (result.indexOf("ERROR") == -1) {
            this.serialmodem.setCcid(result.substring(result.indexOf(58) + 1));
        }
    }

    protected void getCardNumberForINCORPORATED() throws Exception {
        String result = null;
        result = this.athandle("AT+CICCID\r");
        if (result.indexOf("ERROR") == -1) {
            this.serialmodem.setCcid(result.substring(result.indexOf(58) + 1));
        }
    }

    private void a() throws Exception {
        String wmsn;
        String result = null;
        result = this.athandle("AT+CPBS=\"ME\"\r");
        result = this.athandle("AT^CPBR=1\r");
        String key = "";
        if (result.indexOf("ERROR") != -1) {
            wmsn = GetIpModemInfo.getWMSN();
            this.athandle("AT^CPBW=1,\"" + wmsn + "\",129,\"WMSN\"\r");
            result = this.athandle("AT^CPBR=1\r");
        } else {
            key = result.substring(result.lastIndexOf(44, result.length() - 3) + 1, result.lastIndexOf(","));
            System.out.println("key:" + key);
            if ((result.equals("") || !key.equals("\"WMSN\"")) && result.indexOf("ERROR") == -1) {
                wmsn = GetIpModemInfo.getWMSN();
                this.athandle("AT^CPBW=1,\"" + wmsn + "\",129,\"WMSN\"\r");
                result = this.athandle("AT^CPBR=1\r");
            }
        }
        result = result.substring(result.indexOf(58) + 1);
        key = result.substring(result.lastIndexOf(44, result.length() - 3) + 1, result.lastIndexOf(","));
        if (result.indexOf("ERROR") != -1) {
            return;
        }
        if (result.trim().equals("")) {
            return;
        }
        if (!key.equals("\"WMSN\"")) {
            return;
        }
        String str = result.split(",")[1];
        this.serialmodem.setSerialnum(str.substring(1, str.length() - 1));
    }

    protected void init() throws Exception {
        this.inStream = this.socket.getInputStream();
        this.outStream = this.socket.getOutputStream();
        this.serialmodem.setBaudrate(115200);
        this.athandle("ATE0\r");
    }

    protected void testOK() throws Exception {
        String response = null;
        String[] result = null;
        this.outStream.write("AT\r".getBytes());
        response = "";
        int c2 = this.inStream.read();
        Thread.sleep(200L);
        while (this.inStream.available() > 0) {
            response = response + (char)c2;
            c2 = this.inStream.read();
        }
        result = response.replaceAll("\\s+\\s+", " ").replaceAll("\n", " ").replaceAll("\r", " ").split(" ");
        if (result[result.length - 1].indexOf("OK") == -1 && result[result.length - 1].indexOf("ERROR") == -1) {
            throw new Exception();
        }
        this.serialmodem.setAtFlag(result[result.length - 1]);
    }

    protected String getVersion() throws Exception {
        String result = "";
        result = this.athandle("ATI3\r");
        return result;
    }

    protected void getSignal() throws Exception {
        String result = null;
        String matchStr = "\\+CSQ:\\d{1,2},\\d{1,2}";
        result = this.athandle("AT+CSQ\r");
        if (result.matches(matchStr)) {
            this.serialmodem.setCsq(result.substring(result.indexOf(58) + 1));
        } else if (result.indexOf("ERROR") == -1) {
            throw new Exception();
        }
    }

    private static String getWMSN() {
        char[] nums = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
        Random rand = new Random();
        String wmsn = "";
        for (int i2 = 0; i2 < 17; ++i2) {
            wmsn = wmsn + nums[rand.nextInt(10)];
        }
        return wmsn;
    }

    private void b() throws Exception {
        String result = null;
        result = this.athandle("AT+WAIP=0\r");
        result = this.athandle("AT+CPBS=\"ME\"\r");
        result = this.athandle("AT+CPBR=1\r");
        String key = result.substring(result.lastIndexOf(44) + 1);
        System.out.println("key:" + key);
        if ((result.equals("") || !key.equals("\"WMSN\"")) && result.indexOf("ERROR") == -1) {
            String wmsn = GetIpModemInfo.getWMSN();
            this.athandle("AT+CPBW=1,\"" + wmsn + "\",129,\"WMSN\"\r");
            result = this.athandle("AT+CPBR=1\r");
        }
        result = result.substring(result.indexOf(58) + 1);
        key = result.substring(result.lastIndexOf(44) + 1);
        if (result.indexOf("ERROR") != -1) {
            return;
        }
        if (result.trim().equals("")) {
            return;
        }
        if (!key.equals("\"WMSN\"")) {
            return;
        }
        String str = result.split(",")[1];
        this.serialmodem.setSerialnum(str.substring(1, str.length() - 1));
    }

    protected void getSerialNumber1() throws Exception {
        String result = null;
        String matchStr = "[a-z0-9A-Z]+";
        result = this.athandle("AT+CGSN\r");
        if ((result = result.substring(result.indexOf(58) + 1)).matches(matchStr)) {
            this.serialmodem.setSerialnum(result.substring(result.indexOf(58) + 1));
        } else if (result.indexOf("ERROR") == -1) {
            throw new Exception();
        }
    }

    protected void getSerialNumber() throws Exception {
        String result = null;
        String matchStr = "SerialNumber[a-z0-9A-Z]+";
        String matchStr1 = "\\+WMSN:SerialNumber:[a-z0-9A-Z]+";
        Logger.getInstance().logInfo("TO SEND AT+WMSN (1)", null, null);
        result = this.athandle("AT+WMSN\r");
        if (result.matches(matchStr) || result.matches(matchStr1)) {
            if (result.matches(matchStr)) {
                this.serialmodem.setSerialnum(result.replace("SerialNumber", ""));
            } else {
                this.serialmodem.setSerialnum(result.replaceFirst("\\+WMSN:SerialNumber:", ""));
            }
        } else if (result.indexOf("ERROR") == -1 && result.indexOf("NOT") == -1) {
            throw new Exception();
        }
    }

    protected void getManufacturer() throws Exception {
        String result = null;
        result = this.athandle("ATI\r");
        if (result.indexOf("ERROR") != -1) {
            this.serialmodem.setManufacturer("");
        } else if (result.indexOf("WAVECOM") != -1 || result.indexOf("WISMOQ") != -1 || result.indexOf("SierraWireless") != -1) {
            this.serialmodem.setManufacturer("Wavecom");
        } else if (result.indexOf("SIEMENS") != -1) {
            this.serialmodem.setManufacturer("Siemens");
        } else if (result.indexOf("Quectel_Ltd") != -1) {
            this.serialmodem.setManufacturer("Quectel_Ltd");
        } else if (result.indexOf("Quectel") != -1) {
            this.serialmodem.setManufacturer("Quectel");
        } else if (result.indexOf("Yuga") != -1) {
            this.serialmodem.setManufacturer("Yuga");
        } else if (result.indexOf("TDTech") != -1) {
            this.serialmodem.setManufacturer("TDTech");
        } else if (result.indexOf("INCORPORATED") != -1) {
            this.serialmodem.setManufacturer("INCORPORATED");
        } else if (result.indexOf("MEIG") != -1) {
            this.serialmodem.setManufacturer("MEIG");
        } else if ((result = result.toLowerCase()).indexOf("huawei") != -1) {
            this.serialmodem.setManufacturer("Huawei");
        } else {
            throw new Exception();
        }
    }

    protected void getModel1() throws Exception {
        String result = null;
        result = this.athandle("AT+CGMR\r");
        System.out.println("debug: " + result);
        if (result.indexOf("ERROR") != -1) {
            this.serialmodem.setModel("");
        } else if (result.indexOf("WISM") != -1) {
            this.serialmodem.setModel("WISMOQCDMA");
        } else {
            this.serialmodem.setModel("");
        }
    }

    protected void getModel() throws Exception {
        String result = null;
        result = this.athandle("AT+CGMM\r");
        if (result.indexOf("ERROR") != -1) {
            this.serialmodem.setModel("");
        } else if (result.indexOf("Quectel_M35") != -1) {
            this.serialmodem.setModel("Quectel_M35");
        } else if (result.indexOf("Quectel_M26") != -1) {
            this.serialmodem.setModel("Quectel_M26");
        } else if (result.indexOf("EC20F") != -1) {
            this.serialmodem.setModel("EC20F");
        } else if (result.indexOf("MC323") != -1) {
            this.serialmodem.setModel("MC323");
        } else if (result.indexOf("MG301") != -1) {
            this.serialmodem.setModel("MG301");
        } else if (result.indexOf("ME909") != -1) {
            this.serialmodem.setModel("ME909");
        } else if (result.indexOf("MH5000-82M") != -1) {
            this.serialmodem.setModel("MH5000-82M");
        } else if (result.indexOf("ME901") != -1) {
            this.serialmodem.setModel("ME901");
        } else if (result.indexOf("CLM920_NC5") != -1) {
            this.serialmodem.setModel("CLM920_NC5");
        } else if (result.indexOf("CLM920_RC3") != -1) {
            this.serialmodem.setModel("CLM920_RC3");
        } else if (result.indexOf("CLM920_RV3") != -1) {
            this.serialmodem.setModel("CLM920_RV3");
        } else if (result.indexOf("A7600C1-SE") != -1) {
            this.serialmodem.setModel("A7600C1_SE");
        } else if (result.indexOf("SIMCOM_SIM7600CE-L") != -1) {
            this.serialmodem.setModel("7600CE_L");
        } else if (result.indexOf("SIMCOM_SIM7600CE-JT1S") != -1) {
            this.serialmodem.setModel("7600CE_JT1S");
        } else if (result.indexOf("SIMCOM_SIM7600CE-T") != -1) {
            this.serialmodem.setModel("7600CE_T");
        } else if (result.indexOf("MH5000-31") != -1) {
            this.serialmodem.setModel("MH5000-31");
        } else if (result.indexOf("SLM750-V") != -1) {
            this.serialmodem.setModel("SLM750_V");
        } else {
            this.serialmodem.setModel("");
        }
    }

    protected void getModel2() throws Exception {
        this.getModel();
    }

    protected String athandle(String cmd) throws Exception {
        String response = null;
        this.outStream.write(cmd.getBytes());
        this.outStream.flush();
        response = "";
        int c2 = this.inStream.read();
        Thread.sleep(200L);
        while (this.inStream.available() > 0) {
            response = response + (char)c2;
            c2 = this.inStream.read();
        }
        Logger.getInstance().logInfo("\u53d1\u9001" + cmd + " \u8fd4\u56de:" + response, null, null);
        response = response.replace(cmd, "").replaceAll("\\s+OK\\s+", "").replaceAll("\\s+", "");
        return response;
    }

    protected void close() {
        IOUtils.closeQuietly((InputStream)this.inStream);
        IOUtils.closeQuietly((OutputStream)this.outStream);
    }
}

