/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.web;

import cn.sendsms.InboundMessage;
import cn.sendsms.Message;
import cn.sendsms.OutboundMessage;
import cn.sendsms.helper.CommPortIdentifier;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.web.DbHelper;
import cn.sendsms.jdsmsserver.web.NetDeviceBean;
import cn.sendsms.jdsmsserver.web.NewAuth;
import cn.sendsms.jdsmsserver.web.SerialModemBean;
import cn.sendsms.jdsmsserver.web.SerialPhoneBean;
import cn.sendsms.modem.ModemGateway;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class PhoneInfoCache {
    private static final PhoneInfoCache cache = new PhoneInfoCache();
    private static final String prefix = "newmodem";
    private static byte id;
    private static Logger log;
    private CheckStatus status = CheckStatus.STOPPED;
    private Vector<SerialPhoneBean> devices = new Vector();
    private Vector<OutboundMessage> messages = new Vector();
    private Vector<InboundMessage> inMessages = new Vector();

    public CheckStatus getStatus() {
        return this.status;
    }

    public void setStatus(CheckStatus status) {
        this.status = status;
    }

    private PhoneInfoCache() {
        id = 1;
    }

    private synchronized void increase() {
        id = (byte)(id + 1);
    }

    public static final PhoneInfoCache getInstance() {
        return cache;
    }

    public void deleteConfiguration(SerialModemBean bean) throws ConfigurationException {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        boolean flag = false;
        int i2 = 0;
        for (i2 = 0; i2 < 64; ++i2) {
            if (props.getString("phoneDevice." + i2, "").trim().length() == 0 || props.getString("phoneDevice." + i2, "").indexOf(bean.getGatewayID() + " ,") == -1) continue;
            flag = true;
            props.clearProperty("phoneDevice." + i2);
            break;
        }
        if (flag) {
            props.clearProperty(bean.getGatewayID() + ".port");
            props.clearProperty(bean.getGatewayID() + ".baudrate");
            props.clearProperty(bean.getGatewayID() + ".manufacturer");
            props.clearProperty(bean.getGatewayID() + ".model");
            props.clearProperty(bean.getGatewayID() + ".protocol");
            props.clearProperty(bean.getGatewayID() + ".pin");
            props.clearProperty(bean.getGatewayID() + ".inbound");
            props.clearProperty(bean.getGatewayID() + ".outbound");
            props.clearProperty(bean.getGatewayID() + ".smsc_number");
            props.clearProperty(bean.getGatewayID() + ".init_string");
        }
        props.save();
    }

    public void updateDeviceInfo() {
        this.status = CheckStatus.RUNNING;
        ArrayList resultList = new ArrayList();
        ExecutorService services = Executors.newSingleThreadExecutor();
        Enumeration<CommPortIdentifier> portList = CommPortIdentifier.getPortIdentifiers();
        double cbegin = System.currentTimeMillis();
        services = Executors.newSingleThreadExecutor();
        ArrayList<NetDeviceBean> list = new ArrayList<NetDeviceBean>();
        for (int i2 = 0; i2 < 64; ++i2) {
            try {
                String propName = "netdevice." + i2;
                Object[] propValues = JDSMSServer.getInstance().getProperties().getStringArray(propName);
                if (ArrayUtils.isEmpty((Object[])propValues)) break;
                NetDeviceBean deviceBean = new NetDeviceBean();
                deviceBean.setId((String)propValues[0]);
                deviceBean.setDeviceIp(JDSMSServer.getInstance().getProperties().getString((String)propValues[0] + ".ip"));
                deviceBean.setStartPort(JDSMSServer.getInstance().getProperties().getInt((String)propValues[0] + ".startPort"));
                deviceBean.setEndPort(JDSMSServer.getInstance().getProperties().getInt((String)propValues[0] + ".endPort"));
                list.add(deviceBean);
                continue;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        double cend = System.currentTimeMillis();
        log.info((Object)("\u603b\u5171\u68c0\u6d4b\u4e86" + this.devices.size() + "\u4e2a\u8bbe\u5907\uff0c\u8017\u65f6" + (cend - cbegin) / 1000.0 + "\u79d2"));
        this.status = CheckStatus.STOPPED;
    }

    public void addPhone(SerialPhoneBean obj) {
        this.devices.add(obj);
    }

    public synchronized void addMessage(OutboundMessage obj) {
        this.messages.add(obj);
    }

    public synchronized void addMessages(List<OutboundMessage> objList) {
        this.messages.addAll(objList);
    }

    public synchronized void addInMessage(Date date, String myOriginator, String text, String phoneNo, String imei, int encode) throws Exception {
        String phone_using = JDSMSServer.getInstance().getProperties().getString("settings.phone_using", "yes");
        if (!phone_using.equals("yes")) {
            return;
        }
        String serialnum = PhoneInfoCache.getInstance().getUsingPhoneIMEI(phoneNo);
        boolean flagR = NewAuth.checkDeviceAuth(serialnum);
        if (!flagR) {
            text = "<\u8bf7\u586b\u5199\u8bbe\u5907\u6ce8\u518c\u7801>" + text;
            int num = NewAuth.getAvaliableNum(serialnum);
            --num;
            try {
                if (num >= -1) {
                    NewAuth.updateAvaliableNum(serialnum, num);
                }
                if (num < 1) {
                    log.warn((Object)("\u624b\u673a\u672a\u6388\u6743\uff0c\u6536\u53d1\u77ed\u4fe1\u6761\u6570\u5df2\u8fbe\u5230\u6700\u5927\u9650\u5236\u657088\u6761,\u5df2\u505c\u6b62\u6536\u53d1\u77ed\u4fe1" + phoneNo));
                    return;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        InboundMessage obj = new InboundMessage(date, myOriginator, text, phoneNo);
        switch (encode) {
            case 0: {
                obj.setEncoding(Message.MessageEncodings.ENC7BIT);
                break;
            }
            case 4: {
                obj.setEncoding(Message.MessageEncodings.ENC8BIT);
                break;
            }
            case 8: {
                obj.setEncoding(Message.MessageEncodings.ENCUCS2);
            }
        }
        this.inMessages.add(obj);
    }

    public List<SerialPhoneBean> getAll() throws CloneNotSupportedException {
        ArrayList<SerialPhoneBean> list = new ArrayList<SerialPhoneBean>();
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            list.add(this.devices.get(i2));
        }
        return list;
    }

    public synchronized StringBuilder getMessages(String phoneNo) throws CloneNotSupportedException {
        int i2 = 0;
        int msgCounts = 0;
        long lnoww = System.currentTimeMillis();
        for (int x = 0; x < this.messages.size(); ++x) {
            OutboundMessage msg = this.messages.get(x);
            String phoneNo1 = msg.getUsingPhoneNo();
            if (!phoneNo.equals(msg.getUsingPhoneNo()) || this.messages.get(i2).getSendFlag() && lnoww - this.messages.get(i2).getHandleTime() > (long)JDSMSServer.getInstance().getProperties().getInt("settings.retries_time", 120000)) continue;
            ++msgCounts;
        }
        StringBuilder bufferJson = new StringBuilder();
        if (msgCounts >= 1) {
            return bufferJson;
        }
        String serialnum = PhoneInfoCache.getInstance().getUsingPhoneIMEI(phoneNo);
        try {
            int num;
            boolean flagR = NewAuth.checkDeviceAuth(serialnum);
            if (!flagR && (num = NewAuth.getAvaliableNum(serialnum)) < 1) {
                log.warn((Object)("\u624b\u673a\u672a\u6388\u6743\uff0c\u6536\u53d1\u77ed\u4fe1\u6761\u6570\u5df2\u8fbe\u5230\u6700\u5927\u9650\u5236\u657088\u6761,\u5df2\u505c\u6b62\u6536\u53d1\u77ed\u4fe1" + phoneNo + " num=" + num));
                PhoneInfoCache.getInstance().setRealUsingPhoneFlag(phoneNo, "0");
                return bufferJson;
            }
        }
        catch (Exception e1) {
            log.error((Object)("\u5224\u65ad\u624b\u673a\u6388\u6743\u4fe1\u606f\u5931\u8d25" + phoneNo));
            return bufferJson;
        }
        int phone_msg_max_count = JDSMSServer.getInstance().getProperties().getInt("settings.phone_msg_max_count", 0);
        for (int x = 0; x < this.messages.size(); ++x) {
            block20: {
                OutboundMessage msg = this.messages.get(x);
                String gatewayid = msg.getGatewayId();
                if (!gatewayid.equals(phoneNo) && !gatewayid.equals("$")) continue;
                long lnow = System.currentTimeMillis();
                if (!this.messages.get(i2).getSendFlag() || this.messages.get(i2).getSendFlag() && lnow - this.messages.get(i2).getHandleTime() > (long)JDSMSServer.getInstance().getProperties().getInt("settings.retries_time", 120000)) {
                    try {
                        DbHelper helper;
                        if (phone_msg_max_count != 0 && this.getPhoneMsgLeft(phoneNo) == -1) {
                            helper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
                            this.setPhoneMsgLeft(phoneNo, phone_msg_max_count - helper.getPhoneMsgSentCount(phoneNo));
                        }
                        if (JDSMSServer.getInstance().getphone_msg_max_count() != phone_msg_max_count || JDSMSServer.getInstance().isChanged()) {
                            helper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
                            this.setPhoneMsgLeft(phoneNo, phone_msg_max_count - helper.getPhoneMsgSentCount(phoneNo));
                            JDSMSServer.getInstance().setphone_msg_max_count(phone_msg_max_count);
                            JDSMSServer.getInstance().setChangeFlag(false);
                        }
                        if (phone_msg_max_count == 0 || this.getPhoneMsgLeft(phoneNo) > 0) {
                            String id = msg.getMessageId() + "";
                            String sendTo = msg.getRecipient();
                            String sendContent = msg.getText();
                            boolean flagR = NewAuth.checkDeviceAuth(serialnum);
                            if (!flagR) {
                                sendContent = "<\u8bf7\u586b\u5199\u8bbe\u5907\u6ce8\u518c\u7801>" + sendContent;
                                msg.setText(sendContent);
                            }
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("id", id);
                            map.put("to", sendTo);
                            map.put("message", sendContent);
                            String sss = JSONObject.fromObject(map).toString();
                            bufferJson.append(sss + ",");
                            if (!flagR) {
                                int num = NewAuth.getAvaliableNum(serialnum);
                                if (num > 0) {
                                    log.error((Object)("num =" + num));
                                    log.debug((Object)("\u624b\u673a\u672a\u6388\u6743\uff0c\u8fd8\u53ef\u6536\u53d1" + num + "\u6761\u77ed\u4fe1"));
                                }
                                --num;
                                try {
                                    NewAuth.updateAvaliableNum(serialnum, num);
                                }
                                catch (SQLException e2) {
                                    log.error((Object)"\u66f4\u65b0\u53ef\u53d1\u9001\u7684\u77ed\u4fe1\u6570\u76ee\u51fa\u9519");
                                }
                                if (num == 0) {
                                    log.warn((Object)"\u8bbe\u5907\u672a\u6388\u6743\uff0c\u6536\u53d1\u77ed\u4fe1\u6761\u6570\u5df2\u8fbe\u5230\u6700\u5927\u9650\u5236\u657088\u6761,\u5df2\u505c\u6b62\u6536\u53d1\u77ed\u4fe1");
                                    this.messages.get(i2).setSendFlag(true);
                                    this.messages.get(i2).setUsingPhoneNo(phoneNo);
                                    this.messages.get(i2).setHandleTime(System.currentTimeMillis());
                                    return bufferJson;
                                }
                                if (num < 0) {
                                    log.warn((Object)"\u8bbe\u5907\u672a\u6388\u6743\uff0c\u6536\u53d1\u77ed\u4fe1\u6761\u6570\u5df2\u8fbe\u5230\u6700\u5927\u9650\u5236\u657088\u6761,\u5df2\u505c\u6b62\u6536\u53d1\u77ed\u4fe1");
                                    return new StringBuilder();
                                }
                            }
                            this.messages.get(i2).setSendFlag(true);
                            this.messages.get(i2).setUsingPhoneNo(phoneNo);
                            this.messages.get(i2).setHandleTime(System.currentTimeMillis());
                            ++msgCounts;
                            if (phone_msg_max_count != 0) {
                                this.setPhoneMsgLeft(phoneNo, this.getPhoneMsgLeft(phoneNo) - 1);
                            }
                            break block20;
                        }
                        return bufferJson;
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                    }
                }
            }
            ++i2;
            if (msgCounts < Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.app_send_count", "20"))) continue;
            return bufferJson;
        }
        return bufferJson;
    }

    public int getPhoneMsgLeft(String phoneno) throws Exception {
        int left = -1;
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            SerialPhoneBean device = this.devices.get(i2);
            if (!phoneno.equals(device.getPhoneNo())) continue;
            left = device.getLeft();
            break;
        }
        return left;
    }

    public void setPhoneMsgLeft(String phoneno, int left) throws Exception {
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            SerialPhoneBean device = this.devices.get(i2);
            if (!phoneno.equals(device.getPhoneNo())) continue;
            device.setLeft(left);
            break;
        }
    }

    public boolean isPhoneRegistered(String serialnum) throws Exception {
        String regcode = NewAuth.getAuthorizeInfo(serialnum, "regcode");
        if (regcode == null || regcode.indexOf("null") != -1) {
            regcode = "";
        }
        if (regcode.equals("")) {
            return false;
        }
        return NewAuth.checkDeviceAuth(serialnum);
    }

    public synchronized List<OutboundMessage> getSentMessages() {
        int i2;
        ArrayList<OutboundMessage> list = new ArrayList<OutboundMessage>();
        for (i2 = 0; i2 < this.messages.size(); ++i2) {
            OutboundMessage msg = this.messages.get(i2);
            if (!this.messages.get(i2).getSendFlag() || this.messages.get(i2).getMessageStatus() == OutboundMessage.MessageStatuses.UNSENT) continue;
            if (this.messages.get(i2).getMessageStatus() == OutboundMessage.MessageStatuses.FAILED && this.messages.get(i2).getTryTimes() >= 2) {
                list.add(msg);
                continue;
            }
            if (this.messages.get(i2).getMessageStatus() != OutboundMessage.MessageStatuses.SENT) continue;
            list.add(msg);
        }
        for (i2 = 0; i2 < list.size(); ++i2) {
            this.messages.removeElement(list.get(i2));
        }
        return list;
    }

    public synchronized List<InboundMessage> getInMessages() {
        int i1;
        ArrayList<InboundMessage> list = new ArrayList<InboundMessage>();
        int i2 = 0;
        for (i1 = 0; i1 < this.inMessages.size(); ++i1) {
            InboundMessage msg = this.inMessages.get(i1);
            if (!this.inMessages.get(i2).getStoreFlag()) {
                list.add(msg);
            }
            ++i2;
        }
        for (i1 = 0; i1 < list.size(); ++i1) {
            this.inMessages.removeElement(list.get(i1));
        }
        return list;
    }

    public int getUsingPhoneCounts() {
        int phoneCount = 0;
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            if (!this.devices.get(i2).getUsingStatus().equals("1")) continue;
            ++phoneCount;
        }
        return phoneCount;
    }

    public List<String> getUsingPhoneNos() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            SerialPhoneBean device = this.devices.get(i2);
            if (!device.getUsingStatus().equals("1")) continue;
            String serialnum = this.getUsingPhoneIMEI(device.getPhoneNo());
            boolean flag = NewAuth.checkDeviceAuth(serialnum);
            if (flag) {
                list.add(device.getPhoneNo());
                continue;
            }
            int num = NewAuth.getAvaliableNum(serialnum);
            if (num <= 0) continue;
            list.add(device.getPhoneNo());
        }
        return list;
    }

    public List<String> getUsingPhoneList() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            SerialPhoneBean device = this.devices.get(i2);
            if (!device.getUsingStatus().equals("1")) continue;
            list.add(device.getPhoneNo());
        }
        return list;
    }

    public String getUsingPhoneIMEI(String phoneNo) {
        String imei = "";
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            SerialPhoneBean device = this.devices.get(i2);
            if (!device.getUsingStatus().equals("1") || !phoneNo.equals(device.getPhoneNo())) continue;
            imei = device.getPhoneImei();
        }
        return imei;
    }

    public List<SerialPhoneBean> getRealUsingPhones() {
        ArrayList<SerialPhoneBean> list = new ArrayList<SerialPhoneBean>();
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            SerialPhoneBean device = this.devices.get(i2);
            if (!device.getUsingStatus().equals("1") || !"1".equals(device.getRealUsingtStatus())) continue;
            list.add(device);
        }
        return list;
    }

    public void setRealUsingPhoneFlag(String phoneNo, String usingFlag) {
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            SerialPhoneBean device = this.devices.get(i2);
            if (!phoneNo.equals(device.getPhoneNo())) continue;
            this.devices.get(i2).setRealUsingStatus(usingFlag);
            break;
        }
    }

    public String getPhoneIMEI(String phoneNo) {
        String imei = "";
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            SerialPhoneBean device = this.devices.get(i2);
            if (!phoneNo.equals(device.getPhoneNo())) continue;
            imei = device.getPhoneImei();
        }
        return imei;
    }

    public int getMessagesCounts() {
        return this.messages.size();
    }

    public synchronized void setSentMessages(long id, String phoneNo, String sent) throws CloneNotSupportedException {
        for (int i2 = 0; i2 < this.messages.size(); ++i2) {
            OutboundMessage msg = this.messages.get(i2);
            if (!this.messages.get(i2).getSendFlag()) continue;
            System.out.println("messageid=" + this.messages.get(i2).getMessageId() + " id=" + id);
            System.out.println(this.messages.get(i2).getMessageId() == id);
            if (this.messages.get(i2).getMessageId() != id) continue;
            if (sent.equals("sent")) {
                msg.setDispatchDate(new Date());
                msg.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
                msg.setGatewayId(phoneNo);
                continue;
            }
            if (!sent.equals("failed")) continue;
            msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
            msg.addTryTimes(1);
        }
    }

    public synchronized int getPhoneMsgCounts(String phoneNo) {
        int counts = 0;
        for (int i2 = 0; i2 < this.messages.size(); ++i2) {
            if (!phoneNo.equals(this.messages.get(i2).getUsingPhoneNo())) continue;
            ++counts;
        }
        return counts;
    }

    public synchronized void setSentForwardMessages(String sentTo, String sentMessage, String phoneNo) throws CloneNotSupportedException, IOException {
        for (int i2 = 0; i2 < this.messages.size(); ++i2) {
            OutboundMessage msg = this.messages.get(i2);
            if (!this.messages.get(i2).getSendFlag() || !this.messages.get(i2).getText().equals(sentMessage) || !this.messages.get(i2).getRecipient().equals(sentTo) || msg.getMessageStatus().equals((Object)OutboundMessage.MessageStatuses.SENT) || !msg.getUsingPhoneNo().equals(phoneNo)) continue;
            msg.setDispatchDate(new Date());
            msg.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
            msg.setGatewayId(phoneNo);
            break;
        }
    }

    public List<SerialPhoneBean> getUsingPhones() {
        ArrayList<SerialPhoneBean> list = new ArrayList<SerialPhoneBean>();
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            SerialPhoneBean device = this.devices.get(i2);
            if (!device.getUsingStatus().equals("1")) continue;
            list.add(device);
        }
        return list;
    }

    public boolean isPhoneUsing(String phoneNo) {
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            SerialPhoneBean device = this.devices.get(i2);
            if (!phoneNo.equals(device.getPhoneNo()) || !device.getUsingStatus().equals("1")) continue;
            return true;
        }
        return false;
    }

    public void setConnectStatusFalse(long lnow) throws CloneNotSupportedException {
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            SerialPhoneBean device = this.devices.get(i2);
            if (!this.devices.get(i2).getConnectStatus().equals("1") || (lnow - device.getLastShowTime()) / 1000L < (long)device.getRequestInterval()) continue;
            this.devices.get(i2).setConnectStatus("0");
        }
    }

    public void setUsingStatusFalse(long lnow) throws CloneNotSupportedException {
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            SerialPhoneBean device = this.devices.get(i2);
            if (!this.devices.get(i2).getConnectStatus().equals("1") || (lnow - device.getLastShowTime()) / 1000L < (long)device.getRequestInterval()) continue;
            this.devices.get(i2).setUsingStatus("0");
        }
    }

    public void setChargingStatusFalse(String phoneNo) throws CloneNotSupportedException {
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            if (!this.devices.get(i2).getPhoneNo().equals(phoneNo)) continue;
            this.devices.get(i2).setChargingStatusChanged(false);
            break;
        }
    }

    public void setPowerFalse(String phoneNo) throws CloneNotSupportedException {
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            if (!this.devices.get(i2).getPhoneNo().equals(phoneNo)) continue;
            this.devices.get(i2).setPowerChanged(false);
            break;
        }
    }

    public void setConnectStatusTrue(long lnow) throws CloneNotSupportedException {
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            SerialPhoneBean device = this.devices.get(i2);
            if (!this.devices.get(i2).getConnectStatus().equals("0") || (lnow - device.getLastShowTime()) / 1000L >= (long)device.getRequestInterval()) continue;
            this.devices.get(i2).setConnectStatus("1");
        }
    }

    public boolean setUsingtatusTrue(String phoneNo) throws CloneNotSupportedException, ConfigurationException {
        PropertiesConfiguration propsPhone = JDSMSServer.getInstance().getProperties();
        ArrayList<SerialPhoneBean> phoneList = new ArrayList<SerialPhoneBean>();
        for (int i2 = 0; i2 < 64; ++i2) {
            String propName = "phoneDevice." + i2;
            Object[] propValues = propsPhone.getStringArray(propName);
            if (ArrayUtils.isEmpty((Object[])propValues)) continue;
            SerialPhoneBean phoneInfo = new SerialPhoneBean();
            phoneInfo.setPhoneNo(propsPhone.getString((String)propValues[0] + ".no"));
            phoneInfo.setUsingStatus(propsPhone.getString((String)propValues[0] + ".using_status"));
            phoneInfo.setPhoneID((String)propValues[0]);
            phoneList.add(phoneInfo);
        }
        int len = phoneList.size();
        for (int i3 = 0; i3 < len; ++i3) {
            int index = 0;
            for (int j2 = 0; j2 < this.devices.size(); ++j2) {
                SerialPhoneBean device = this.devices.get(j2);
                if (device.getPhoneNo().equals(phoneNo) && ((SerialPhoneBean)phoneList.get(i3)).getPhoneNo().equals(phoneNo) && ((SerialPhoneBean)phoneList.get(i3)).getUsingStatus().equals("1")) {
                    this.devices.get(index).setUsingStatus("1");
                    return true;
                }
                ++index;
            }
        }
        return false;
    }

    public boolean getUsingtatus(String phoneNo) throws CloneNotSupportedException, ConfigurationException {
        PropertiesConfiguration propsPhone = JDSMSServer.getInstance().getProperties();
        ArrayList<SerialPhoneBean> phoneList = new ArrayList<SerialPhoneBean>();
        for (int i2 = 0; i2 < 64; ++i2) {
            String propName = "phoneDevice." + i2;
            Object[] propValues = propsPhone.getStringArray(propName);
            if (ArrayUtils.isEmpty((Object[])propValues)) continue;
            SerialPhoneBean phoneInfo = new SerialPhoneBean();
            phoneInfo.setPhoneNo(propsPhone.getString((String)propValues[0] + ".no"));
            phoneInfo.setUsingStatus(propsPhone.getString((String)propValues[0] + ".using_status"));
            phoneInfo.setPhoneID((String)propValues[0]);
            phoneList.add(phoneInfo);
        }
        int len = phoneList.size();
        for (int i3 = 0; i3 < len; ++i3) {
            for (int j2 = 0; j2 < this.devices.size(); ++j2) {
                SerialPhoneBean device = this.devices.get(j2);
                if (!device.getPhoneNo().equals(phoneNo) || !device.getUsingStatus().equals("1")) continue;
                return true;
            }
        }
        return false;
    }

    public void resetTime(String phoneNo) throws CloneNotSupportedException {
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            if (!this.devices.get(i2).getPhoneNo().equals(phoneNo)) continue;
            this.devices.get(i2).setLastShowTime(System.currentTimeMillis());
            break;
        }
    }

    public void resetRequestInterval(String phoneNo, int myRequestInterval) throws CloneNotSupportedException {
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            if (!this.devices.get(i2).getPhoneNo().equals(phoneNo)) continue;
            this.devices.get(i2).setRequestInterval(myRequestInterval);
            break;
        }
    }

    public void resetShowFlag() throws CloneNotSupportedException {
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            if (!this.devices.get(i2).getShowFlag().equals("0")) continue;
            this.devices.get(i2).setShowFlag("1");
        }
    }

    public void deletePhone(String phoneNo) throws ServletException, IOException, Exception {
        int i2;
        for (i2 = 0; i2 < this.devices.size() && !this.devices.get(i2).getPhoneNo().equals(phoneNo); ++i2) {
        }
        PhoneInfoCache.getInstance().deletePhoneDevice(phoneNo);
        this.devices.removeElementAt(i2);
    }

    public synchronized void deleteAllSendMessages() {
        for (int i2 = 0; i2 < this.messages.size(); ++i2) {
            if (this.messages.get(i2).getSendFlag()) continue;
            this.messages.removeElementAt(i2);
        }
    }

    public boolean checkStartPhones(String phoneNo) throws ServletException, IOException {
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            if (!this.devices.get(i2).getPhoneNo().equals(phoneNo) || !this.devices.get(i2).getUsingStatus().equals("1") && !this.devices.get(i2).getConnectStatus().equals("0")) continue;
            return false;
        }
        return true;
    }

    public boolean cheakStopPhones(String phoneNo) throws ServletException, IOException {
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            if (!this.devices.get(i2).getPhoneNo().equals(phoneNo) || !this.devices.get(i2).getConnectStatus().equals("0") && !this.devices.get(i2).getUsingStatus().equals("0")) continue;
            return false;
        }
        return true;
    }

    public int startPhones(String phoneNo) throws ServletException, IOException {
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            if (!this.devices.get(i2).getPhoneNo().equals(phoneNo) || !this.devices.get(i2).getUsingStatus().equals("0") || !this.devices.get(i2).getConnectStatus().equals("1")) continue;
            this.devices.get(i2).setUsingStatus("1");
            return 1;
        }
        return 0;
    }

    public int stopPhones(String phoneNo) throws ServletException, IOException {
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            if (!this.devices.get(i2).getPhoneNo().equals(phoneNo) || !this.devices.get(i2).getUsingStatus().equals("1")) continue;
            this.devices.get(i2).setUsingStatus("0");
            return 1;
        }
        return 0;
    }

    public synchronized void addPhoneDevice(String deviceInfo, String myImei, String myPhoneNo, String strBattery, String strCharging, String phoneID, String requestInterval) throws ServletException, IOException, Exception {
        try {
            int i2;
            String phoneNo = myPhoneNo;
            long lastShowTime = System.currentTimeMillis();
            int myRequestInterval = Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.phone_overtime", "0"));
            List<SerialPhoneBean> List2 = PhoneInfoCache.getInstance().getAll();
            int iLen = List2.size();
            for (i2 = 0; i2 < iLen; ++i2) {
                if (List2.get(i2).getPhoneImei().equals(myImei) && !List2.get(i2).getPhoneNo().equals(phoneNo)) {
                    return;
                }
                if (List2.get(i2).getPhoneImei().equals(myImei) || !List2.get(i2).getPhoneNo().equals(phoneNo)) continue;
                return;
            }
            for (i2 = 0; i2 < iLen; ++i2) {
                if (!List2.get(i2).getPhoneNo().equals(phoneNo)) continue;
                PhoneInfoCache.getInstance().resetTime(phoneNo);
                PhoneInfoCache.getInstance().resetRequestInterval(phoneNo, myRequestInterval);
                PhoneInfoCache.getInstance().devices.get(i2).setConnectStatus("1");
                if ("0".equals(PhoneInfoCache.getInstance().devices.get(i2).getUsingStatus()) && PhoneInfoCache.getInstance().getUsingtatus(phoneNo)) {
                    PhoneInfoCache.getInstance().devices.get(i2).setUsingStatus("1");
                }
                if (!strBattery.equals(PhoneInfoCache.getInstance().devices.get(i2).getBattery())) {
                    PhoneInfoCache.getInstance().devices.get(i2).setBattery(strBattery);
                    PhoneInfoCache.getInstance().devices.get(i2).setPowerChanged(true);
                }
                if (!strCharging.equals(PhoneInfoCache.getInstance().devices.get(i2).getChargingStatus())) {
                    PhoneInfoCache.getInstance().devices.get(i2).setChargingStatus(strCharging);
                    PhoneInfoCache.getInstance().devices.get(i2).setChargingStatusChanged(true);
                }
                return;
            }
            SerialPhoneBean bean = new SerialPhoneBean();
            bean.setPhoneImei(myImei);
            bean.setPhoneNo(phoneNo);
            bean.setConnectStatus("1");
            bean.setLastShowTime(lastShowTime);
            bean.setBattery(strBattery);
            bean.setChargingStatus(strCharging);
            bean.setDeviceInfo(deviceInfo);
            bean.setRequestInterval(myRequestInterval);
            PropertiesConfiguration phoneprops = JDSMSServer.getInstance().getProperties();
            int i3 = 0;
            Object[] values = null;
            for (i3 = 0; i3 < 64 && !ArrayUtils.isEmpty((Object[])(values = phoneprops.getStringArray("phoneDevice." + i3))); ++i3) {
            }
            int iTmp = i3 + 1;
            phoneprops.setProperty("phoneDevice." + i3, (Object)("phone" + iTmp));
            bean.setPhoneID("phone" + iTmp);
            values = phoneprops.getStringArray("phoneDevice." + i3);
            phoneprops.setProperty((String)values[0] + ".no", (Object)bean.getPhoneNo());
            phoneprops.setProperty((String)values[0] + ".imei", (Object)bean.getPhoneImei());
            phoneprops.setProperty((String)values[0] + ".battery", (Object)strBattery);
            phoneprops.setProperty((String)values[0] + ".charging", (Object)bean.getChargingStatus());
            phoneprops.setProperty((String)values[0] + ".device_info", (Object)bean.getDeviceInfo());
            phoneprops.setProperty((String)values[0] + ".using_status", (Object)bean.getUsingStatus());
            phoneprops.save();
            NewAuth.initAuthorize(phoneNo, bean.getPhoneImei(), "");
            PhoneInfoCache.getInstance().addPhone(bean);
            PhoneInfoCache.getInstance().setRealUsingPhoneFlag(phoneNo, "1");
        }
        catch (CloneNotSupportedException e2) {
            log.error((Object)"add phone device list failed", (Throwable)e2);
        }
        catch (Exception e3) {
            log.error((Object)"\u6dfb\u52a0\u624b\u673a\u8bbe\u5907\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e3);
            throw e3;
        }
    }

    public void deletePhoneDevice(String myPhoneNo) throws ServletException, IOException, Exception {
        try {
            String phoneNo = myPhoneNo;
            List<SerialPhoneBean> List2 = PhoneInfoCache.getInstance().getAll();
            int iLen = List2.size();
            int iLocation = 0;
            for (iLocation = 0; iLocation < iLen && !List2.get(iLocation).getPhoneNo().equals(phoneNo); ++iLocation) {
            }
            PropertiesConfiguration phoneprops = JDSMSServer.getInstance().getProperties();
            int i2 = 0;
            for (i2 = 0; i2 < 64; ++i2) {
                Object[] values = phoneprops.getStringArray("phoneDevice." + i2);
                if (ArrayUtils.isEmpty((Object[])values) || !((String)values[0]).equals(List2.get(iLocation).getPhoneID())) continue;
                phoneprops.clearProperty("phoneDevice." + i2);
                phoneprops.clearProperty((String)values[0] + ".no");
                phoneprops.clearProperty((String)values[0] + ".imei");
                phoneprops.clearProperty((String)values[0] + ".battery");
                phoneprops.clearProperty((String)values[0] + ".charging");
                phoneprops.clearProperty((String)values[0] + ".device_info");
                phoneprops.clearProperty((String)values[0] + ".using_status");
                phoneprops.save();
                break;
            }
        }
        catch (CloneNotSupportedException e2) {
            log.error((Object)"delete phone device list failed", (Throwable)e2);
        }
        catch (Exception e3) {
            log.error((Object)"\u5220\u9664\u624b\u673a\u8bbe\u5907\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e3);
            throw e3;
        }
    }

    public String getServerIp() {
        String sIP = "";
        InetAddress ip = null;
        try {
            if (this.isWindowsOS()) {
                ip = InetAddress.getLocalHost();
            } else {
                boolean bFindIP = false;
                Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
                block2: while (netInterfaces.hasMoreElements() && !bFindIP) {
                    NetworkInterface ni = netInterfaces.nextElement();
                    Enumeration<InetAddress> ips = ni.getInetAddresses();
                    while (ips.hasMoreElements()) {
                        ip = ips.nextElement();
                        if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                        bFindIP = true;
                        continue block2;
                    }
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (null != ip) {
            sIP = ip.getHostAddress();
        }
        return sIP;
    }

    public boolean isWindowsOS() {
        boolean isWindowsOS = false;
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().indexOf("windows") > -1) {
            isWindowsOS = true;
        }
        return isWindowsOS;
    }

    static {
        log = Logger.getRootLogger();
    }

    public class DeviceBean {
        private SerialPhoneBean serialPhone;
        private ModemGateway gateway;

        public SerialPhoneBean getDeviceInfo() {
            return this.serialPhone;
        }

        public ModemGateway getGateway() {
            return this.gateway;
        }

        public void setGateway(ModemGateway gateway) {
            this.gateway = gateway;
        }
    }

    public static enum CheckStatus {
        RUNNING,
        STOPPED;

    }
}

