/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.web;

import cn.sendsms.AGateway;
import cn.sendsms.Service;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.ResourceManager;
import cn.sendsms.jdsmsserver.web.Condition;
import cn.sendsms.jdsmsserver.web.DbHelper;
import cn.sendsms.jdsmsserver.web.JDWebAction;
import cn.sendsms.jdsmsserver.web.Page;
import cn.sendsms.jdsmsserver.web.Record;
import cn.sendsms.jdsmsserver.web.User;
import cn.sendsms.otherModem.bigdipper.BDDeviceInfoGetter;
import cn.sendsms.otherModem.driver.loraDriver.LoRaDriver;
import cn.sendsms.otherModem.nbiot.NbIoTDeviceInfoGetter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class SystemManagerAction
extends JDWebAction {
    private static final long serialVersionUID = 1L;
    private String userId;
    private String password;
    private String userDesc;
    private int pageIndex;
    private int addNumber;
    private Condition condition;

    public void Init(HttpServletRequest req, HttpServletResponse resp) {
        ArrayList<String> gateways = new ArrayList<String>();
        for (AGateway gateway : Service.getInstance().getGateways()) {
            if (gateway == null) continue;
            gateways.add(gateway.getGatewayId());
        }
        Iterator<AGateway> iter = null;
        req.setAttribute("gateways", gateways);
        ArrayList<String> loraList = new ArrayList<String>();
        for (int i2 = 0; i2 < LoRaDriver.getInstance().getUsingLoraList().size(); ++i2) {
            loraList.add(LoRaDriver.getInstance().getUsingLoraList().get(i2));
        }
        req.setAttribute("loralist", loraList);
        ArrayList<String> nbiotList = new ArrayList<String>();
        for (int i3 = 0; i3 < NbIoTDeviceInfoGetter.getInstance().getUsingNbIoTList().size(); ++i3) {
            nbiotList.add(NbIoTDeviceInfoGetter.getInstance().getUsingNbIoTList().get(i3));
        }
        req.setAttribute("nbiotlist", nbiotList);
        ArrayList<String> bdList = new ArrayList<String>();
        for (int i4 = 0; i4 < BDDeviceInfoGetter.getInstance().getUsingBDList().size(); ++i4) {
            bdList.add(BDDeviceInfoGetter.getInstance().getUsingBDList().get(i4));
        }
        req.setAttribute("bdlist", bdList);
        this.findForward("/sendMessage.jsp", true, req, resp);
    }

    public void userList(HttpServletRequest req, HttpServletResponse resp) {
        Page page = null;
        DbHelper hepler = null;
        try {
            hepler = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            page = hepler.getUserList(this.pageIndex);
            req.setAttribute("page", (Object)page);
            this.findForward("/user-maintain.jsp", true, req, resp);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            req.setAttribute("page", (Object)new Page());
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.sending_failed_to_access_the_database"));
            this.findForward("/user-maintain.jsp", true, req, resp);
        }
    }

    public void userList4XML(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/xml;charset=UTF-8");
        DbHelper helper = null;
        String errorcode = "0";
        Document doc = DocumentHelper.createDocument();
        Element rootElt = doc.addElement("result");
        try {
            Page page = new Page();
            try {
                helper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
                page = helper.getUserList(this.pageIndex);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                errorcode = "1";
            }
            rootElt.addElement("error").addText(errorcode);
            if ("0".equals(errorcode)) {
                Element userList = rootElt.addElement("users");
                ArrayList list = page.getData();
                for (User currentUser : list) {
                    Element userElt = userList.addElement("user");
                    userElt.addElement("userId").addText(currentUser.getUserId());
                    userElt.addElement("password").addText(currentUser.getPassword());
                    userElt.addElement("userDesc").addText(currentUser.getUserDesc());
                    userElt.addElement("surplusNumber").addText(String.valueOf(currentUser.getSurplusNumber()));
                }
                userList.addElement("totalNumbers").addText(String.valueOf(page.getTotalNum()));
                userList.addElement("pageNum").addText(String.valueOf(page.getPageNum()));
                userList.addElement("pageSize").addText(String.valueOf(page.getPageSize4User()));
                userList.addElement("pageIndex").addText(String.valueOf(page.getPageIndex()));
            }
            String xmlString = doc.asXML();
            response.getWriter().print(xmlString);
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }

    public void addUser(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/xml;charset=UTF-8");
        DbHelper helper = null;
        String errorcode = "0";
        try {
            helper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            User user = helper.findUserById(this.userId);
            if (user != null) {
                errorcode = "-1";
            }
            if ("0".equals(errorcode)) {
                user = new User();
                user.setUserId(this.userId);
                user.setPassword(this.password);
                user.setUserDesc(this.userDesc);
                user.setSurplusNumber(0);
                helper.addUser(user);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            errorcode = "1";
        }
        Document doc = DocumentHelper.createDocument();
        Element rootElt = doc.addElement("result");
        Element error = rootElt.addElement("error").addText(errorcode);
        try {
            if ("0".equals(errorcode)) {
                Element userList = rootElt.addElement("users");
                Page page = helper.getUserList(this.pageIndex);
                ArrayList list = page.getData();
                for (User currentUser : list) {
                    Element userElt = userList.addElement("user");
                    userElt.addElement("userId").addText(currentUser.getUserId());
                    userElt.addElement("password").addText(currentUser.getPassword());
                    userElt.addElement("userDesc").addText(currentUser.getUserDesc());
                    userElt.addElement("surplusNumber").addText(String.valueOf(currentUser.getSurplusNumber()));
                    userElt.addElement("isAssginPermission").addText(String.valueOf(currentUser.getFlag() == 0 ? ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.user_no") : ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.user_yes")));
                }
                userList.addElement("totalNumbers").addText(String.valueOf(page.getTotalNum()));
                userList.addElement("pageNum").addText(String.valueOf(page.getPageNum()));
                userList.addElement("pageSize").addText(String.valueOf(page.getPageSize4User()));
                userList.addElement("pageIndex").addText(String.valueOf(page.getPageIndex()));
            }
            String xmlString = doc.asXML();
            response.getWriter().print(xmlString);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void assignPermission(HttpServletRequest request, HttpServletResponse response) {
        DbHelper hepler = null;
        try {
            hepler = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            String[] userIdArray = request.getParameterValues("selectFlag");
            if (userIdArray != null) {
                hepler.assignUserPermission(userIdArray);
            }
            this.findForward("/systemManager?action=userList&pageIndex=1", true, request, response);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            request.setAttribute("user", (Object)new User());
            request.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.sending_failed_to_access_the_database"));
            this.findForward("/systemManager?action=userList&pageIndex=1", true, request, response);
        }
    }

    public void revokePermission(HttpServletRequest request, HttpServletResponse response) {
        DbHelper hepler = null;
        try {
            hepler = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            String[] userIdArray = request.getParameterValues("selectFlag");
            if (userIdArray != null) {
                hepler.revokePermission(userIdArray);
            }
            this.findForward("/systemManager?action=userList&pageIndex=1", true, request, response);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            request.setAttribute("user", (Object)new User());
            request.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.sending_failed_to_access_the_database"));
            this.findForward("/systemManager?action=userList&pageIndex=1", true, request, response);
        }
    }

    public void nolimitsend(HttpServletRequest request, HttpServletResponse response) {
        DbHelper hepler = null;
        try {
            hepler = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            String[] userIdArray = request.getParameterValues("selectFlag");
            if (userIdArray != null) {
                hepler.setnolimit(userIdArray);
                for (int i2 = 0; i2 < userIdArray.length; ++i2) {
                    String userId = userIdArray[i2];
                    request.getSession(true).getServletContext().setAttribute(userId, (Object)"true");
                }
            }
            this.findForward("/systemManager?action=userList&pageIndex=1", true, request, response);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            request.setAttribute("user", (Object)new User());
            request.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.sending_failed_to_access_the_database"));
            this.findForward("/systemManager?action=userList&pageIndex=1", true, request, response);
        }
    }

    public void usersetlimit(HttpServletRequest request, HttpServletResponse response) {
        DbHelper hepler = null;
        try {
            hepler = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            String[] userIdArray = request.getParameterValues("selectFlag");
            if (userIdArray != null) {
                hepler.setlimit(userIdArray);
                for (int i2 = 0; i2 < userIdArray.length; ++i2) {
                    String userId = userIdArray[i2];
                    request.getSession(true).getServletContext().setAttribute(userId, (Object)"true");
                }
            }
            this.findForward("/systemManager?action=userList&pageIndex=1", true, request, response);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            request.setAttribute("user", (Object)new User());
            request.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.sending_failed_to_access_the_database"));
            this.findForward("/systemManager?action=userList&pageIndex=1", true, request, response);
        }
    }

    public void showModifyUser(HttpServletRequest request, HttpServletResponse response) {
        User user = null;
        DbHelper hepler = null;
        try {
            hepler = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            user = hepler.findUserById(this.userId);
            request.setAttribute("user", (Object)user);
            this.findForward("/modifyUser.jsp", true, request, response);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            request.setAttribute("user", (Object)new User());
            request.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.sending_failed_to_access_the_database"));
            this.findForward("/modifyUser.jsp", true, request, response);
        }
    }

    public void modifyUser(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/xml;charset=UTF-8");
        DbHelper helper = null;
        String errorcode = "0";
        try {
            helper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            User user = new User();
            user.setUserId(this.userId);
            user.setPassword(this.password);
            user.setUserDesc(this.userDesc);
            helper.modifyUser(user);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            errorcode = "-1";
        }
        Document doc = DocumentHelper.createDocument();
        Element rootElt = doc.addElement("result");
        rootElt.addElement("error").addText(errorcode);
        String xmlString = doc.asXML();
        try {
            response.getWriter().print(xmlString);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    public void delUser(HttpServletRequest request, HttpServletResponse response) {
        DbHelper hepler = null;
        try {
            hepler = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            String[] userIdArray = request.getParameterValues("selectFlag");
            if (userIdArray != null) {
                hepler.delUser(userIdArray);
            }
            this.findForward("/systemManager?action=userList&pageIndex=1", true, request, response);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            request.setAttribute("user", (Object)new User());
            request.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.sending_failed_to_access_the_database"));
            this.findForward("/systemManager?action=userList&pageIndex=1", true, request, response);
        }
    }

    public void userChargeUp(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/xml;charset=UTF-8");
        DbHelper helper = null;
        String errorcode = "0";
        User user = null;
        try {
            helper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            user = helper.findUserById(this.userId);
            if (user != null) {
                int surplusNumber = user.getSurplusNumber();
                if (surplusNumber + this.addNumber < 0) {
                    user.setSurplusNumber(0);
                } else {
                    user.setSurplusNumber(surplusNumber + this.addNumber);
                }
                helper.updateSendRecord(user);
                helper.updateAddRecord(this.userId, this.addNumber);
            } else {
                errorcode = "-1";
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            errorcode = "1";
        }
        if ("0".equals(errorcode)) {
            request.getSession(true).getServletContext().setAttribute(user.getUserId(), (Object)"true");
        }
        Document doc = DocumentHelper.createDocument();
        Element rootElt = doc.addElement("result");
        rootElt.addElement("error").addText(errorcode);
        if (user != null) {
            rootElt.addElement("surplusNumber").addText(String.valueOf(user.getSurplusNumber()));
        }
        String xmlString = doc.asXML();
        try {
            response.getWriter().print(xmlString);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    public void showChargeInfo(HttpServletRequest request, HttpServletResponse response) {
        Page page = null;
        DbHelper helper = null;
        try {
            helper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            if ("".equals(this.userId)) {
                this.userId = null;
            }
            page = helper.getAddRecordList(this.userId, this.pageIndex);
            if (this.userId == null) {
                this.userId = "";
            }
            request.setAttribute("userId", (Object)this.userId);
            request.setAttribute("page", (Object)page);
            this.findForward("/checkChargeInfo.jsp", true, request, response);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            request.setAttribute("page", (Object)new Page());
            request.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.sending_failed_to_access_the_database"));
            this.findForward("/checkChargeInfo.jsp", true, request, response);
        }
    }

    public void showChargeInfo4XML(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/xml;charset=UTF-8");
        DbHelper helper = null;
        String errorcode = "0";
        Document doc = DocumentHelper.createDocument();
        Element rootElt = doc.addElement("result");
        try {
            if ("".equals(this.userId)) {
                this.userId = null;
            }
            Element recordList = rootElt.addElement("records");
            Page page = new Page();
            try {
                helper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
                page = helper.getAddRecordList(this.userId, this.pageIndex);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                errorcode = "1";
            }
            rootElt.addElement("error").addText(errorcode);
            if ("0".equals(errorcode)) {
                ArrayList list = page.getData();
                for (Record currentRecord : list) {
                    Element userElt = recordList.addElement("record");
                    userElt.addElement("addTime").addText(currentRecord.getAddTime());
                    userElt.addElement("userId").addText(currentRecord.getUserId());
                    userElt.addElement("addNumber").addText(String.valueOf(currentRecord.getAddNumber()));
                }
                recordList.addElement("totalNumbers").addText(String.valueOf(page.getTotalNum()));
                recordList.addElement("pageNum").addText(String.valueOf(page.getPageNum()));
                recordList.addElement("pageSize").addText(String.valueOf(page.getPageSize4User()));
                recordList.addElement("pageIndex").addText(String.valueOf(page.getPageIndex()));
            }
            String xmlString = doc.asXML();
            response.getWriter().print(xmlString);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void storeUserInfo(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/xml;charset=UTF-8");
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet("address book");
        HSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor((short)40);
        style.setFillPattern((short)1);
        style.setBorderBottom((short)1);
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderTop((short)1);
        style.setAlignment((short)2);
        HSSFFont font = workbook.createFont();
        font.setColor((short)20);
        font.setFontHeightInPoints((short)12);
        font.setBoldweight((short)700);
        style.setFont(font);
        DbHelper helper = null;
        String errorcode = "0";
        List<Object> list = new ArrayList();
        try {
            try {
                helper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
                list = helper.getAllUser();
            }
            catch (Exception e2) {
                errorcode = "1";
            }
            int rowNum = 0;
            HSSFRow row = sheet.createRow(rowNum++);
            HSSFCell cell = row.createCell(0);
            cell.setCellStyle(style);
            cell.setCellValue(ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.user_user_name"));
            cell = row.createCell(1);
            cell.setCellStyle(style);
            cell.setCellValue(ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.user_user_password"));
            cell = row.createCell(2);
            cell.setCellStyle(style);
            cell.setCellValue(ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.user_the_available_number"));
            cell = row.createCell(3);
            cell.setCellStyle(style);
            cell.setCellValue(ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.user_user_description"));
            for (User user : list) {
                row = sheet.createRow(rowNum++);
                cell = row.createCell(0);
                cell.setCellStyle(style);
                cell.setCellValue(user.getUserId());
                cell = row.createCell(1);
                cell.setCellStyle(style);
                cell.setCellValue(user.getPassword());
                cell = row.createCell(2);
                cell.setCellStyle(style);
                cell.setCellValue((double)user.getSurplusNumber());
                cell = row.createCell(3);
                cell.setCellStyle(style);
                cell.setCellValue(user.getUserDesc());
            }
            UUID uuid = UUID.randomUUID();
            File file = new File(this.uploadPath, uuid.toString() + "UserInfo.xls");
            FileOutputStream bf = new FileOutputStream(file);
            workbook.write((OutputStream)bf);
            Document doc = DocumentHelper.createDocument();
            Element rootElt = doc.addElement("result");
            rootElt.addElement("error").addText(errorcode);
            rootElt.addElement("path").addText(file.getAbsolutePath());
            String xmlString = doc.asXML();
            response.getWriter().print(xmlString);
        }
        catch (Exception e3) {
            this.log.error((Object)"\u5907\u4efd\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)e3);
        }
        response.setContentType("text/xml;charset=UTF-8");
    }

    public void importUserInfo(HttpServletRequest request, HttpServletResponse response) {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(4096);
        factory.setRepository(this.tempPath);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setSizeMax(100000000L);
        upload.setHeaderEncoding("GB2312");
        String fileName = "";
        File batchFile = null;
        try {
            List fileItems = upload.parseRequest(request);
            for (FileItem item : fileItems) {
                if (item.isFormField()) continue;
                fileName = item.getName();
                long size = item.getSize();
                if ((fileName == null || fileName.equals("")) && size == 0L) continue;
                fileName = fileName.substring(fileName.lastIndexOf("\\") + 1, fileName.length());
                UUID uuid = UUID.randomUUID();
                item.write(new File(this.uploadPath, uuid.toString() + fileName));
                batchFile = new File(this.uploadPath, uuid.toString() + fileName);
                System.out.println("batchFileName: " + batchFile.getName());
            }
        }
        catch (Exception e2) {
            this.log.error((Object)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25!", (Throwable)e2);
        }
        if (batchFile == null) {
            return;
        }
        if (StringUtils.endsWithAny((String)batchFile.getName(), (String[])new String[]{".xls", ".XLS"})) {
            this.importUserInfo4XLS(batchFile, request, response);
        } else if (StringUtils.endsWithAny((String)batchFile.getName(), (String[])new String[]{".xlsx", ".XLSX"})) {
            this.importUserInfo4XLSX(batchFile, request, response);
        }
    }

    public void importUserInfo4XLS(File file, HttpServletRequest request, HttpServletResponse response) {
        String matchStr = "\\d+";
        String matchPassword = "[a-zA-Z0-9]+";
        String currentUserId = "";
        String currentPassword = "";
        String currentUserDesc = "";
        String currentSurplusNumber = "";
        int surplusNumber = 0;
        long batchRecord = 0L;
        int sameRecords = 0;
        int validateRecords = 0;
        long updateRecordCount = 0L;
        DbHelper helper = null;
        response.setContentType("text/html;charset=GB18030");
        try {
            DbHelper database = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            helper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            Connection conn = database.getConnection();
            String sql = "insert into %s (user_id,password,user_desc,surplus_number) values(?,?,?,?)";
            sql = String.format(sql, database.getProperty("tables.sms_user"));
            PreparedStatement pstmt = conn.prepareStatement(sql);
            try {
                int[] num;
                FileInputStream input = FileUtils.openInputStream((File)file);
                HSSFWorkbook workbook = new HSSFWorkbook((InputStream)input);
                HSSFSheet sheet = workbook.getSheetAt(0);
                Iterator rowIterator = sheet.rowIterator();
                long time = System.currentTimeMillis();
                if (rowIterator.hasNext()) {
                    rowIterator.next();
                }
                while (rowIterator.hasNext()) {
                    Row row = (Row)rowIterator.next();
                    Iterator cells = row.cellIterator();
                    if (!cells.hasNext()) continue;
                    Cell cell = (Cell)cells.next();
                    currentUserId = this.a(cell);
                    if (!cells.hasNext()) continue;
                    cell = (Cell)cells.next();
                    currentPassword = this.a(cell);
                    if (!cells.hasNext()) continue;
                    cell = (Cell)cells.next();
                    currentSurplusNumber = this.a(cell);
                    if (cells.hasNext()) {
                        cell = (Cell)cells.next();
                        currentUserDesc = this.a(cell);
                    }
                    if ("".equals(currentUserId) || "".equals(currentPassword) || !currentPassword.matches(matchPassword)) continue;
                    try {
                        User user = helper.findUserById(currentUserId);
                        if (user != null) {
                            ++sameRecords;
                        }
                    }
                    catch (Exception e2) {}
                    continue;
                    if (!"".equals(currentSurplusNumber)) {
                        if (currentSurplusNumber.matches(matchStr)) {
                            try {
                                surplusNumber = Integer.parseInt(currentSurplusNumber);
                            }
                            catch (Exception e3) {
                                continue;
                            }
                        }
                    } else {
                        surplusNumber = 0;
                    }
                    ++validateRecords;
                    try {
                        this.a(pstmt, currentUserId, currentPassword, currentUserDesc, surplusNumber);
                    }
                    catch (Exception e4) {
                        this.log.error((Object)("\u7528\u6237\u4ee3\u53f7\uff1a" + currentUserId + "\u63d2\u5165\u6570\u636e\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u8fde\u63a5\u6216\u7528\u6237\u4ee3\u7801\u683c\u5f0f\u662f\u5426\u6709\u8bef"), (Throwable)e4);
                        continue;
                    }
                    if (++batchRecord != 5000L) continue;
                    num = pstmt.executeBatch();
                    pstmt.clearBatch();
                    updateRecordCount += (long)num.length;
                    batchRecord = 0L;
                }
                num = pstmt.executeBatch();
                long time2 = System.currentTimeMillis();
                System.out.println("\u5171\u66f4\u65b0\u4e86" + (updateRecordCount += (long)num.length) + "\u6761\u8bb0\u5f55,\u5171\u8017\u65f6" + (time2 - time) / 1000L + "\u79d2");
            }
            catch (IOException e5) {
                this.log.error((Object)"\u89e3\u6790\u6587\u4ef6\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6..", (Throwable)e5);
                return;
            }
        }
        catch (Exception e6) {
            this.log.error((Object)"\u5bfc\u5165\u7528\u6237\u5931\u8d25", (Throwable)e6);
            return;
        }
        try {
            String message = "\u5bfc\u5165\u6587\u4ef6\u4e2d\u5171\u8ba1\u6709" + validateRecords + "\u4e2a\u6709\u6548\u7528\u6237\u540d, \u5b58\u5728" + sameRecords + "\u4e2a\u7528\u6237\u540c\u540d, \u5b9e\u9645\u5bfc\u5165" + updateRecordCount + "\u4e2a\u65b0\u7528\u6237";
            response.getWriter().println("<script> parent.callback('" + message + "','" + updateRecordCount + "')</script>");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void importUserInfo4XLSX(File file, HttpServletRequest request, HttpServletResponse response) {
        int sameRecords = 0;
        int validateRecords = 0;
        String matchStr = "\\d+";
        String currentUserId = "";
        String currentPassword = "";
        String currentUserDesc = "";
        String currentSurplusNumber = "";
        int surplusNumber = 0;
        long batchRecord = 0L;
        long updateRecordCount = 0L;
        DbHelper helper = null;
        String matchPassword = "[a-zA-Z0-9]+";
        response.setContentType("text/html;charset=GB18030");
        try {
            DbHelper database = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            helper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            Connection conn = database.getConnection();
            String sql = "insert into %s (user_id,password,user_desc,surplus_number) values(?,?,?,?)";
            sql = String.format(sql, database.getProperty("tables.sms_user"));
            PreparedStatement pstmt = conn.prepareStatement(sql);
            try {
                int[] num;
                FileInputStream input = FileUtils.openInputStream((File)file);
                XSSFWorkbook workbook = new XSSFWorkbook((InputStream)input);
                XSSFSheet sheet = workbook.getSheetAt(0);
                Iterator rowIterator = sheet.rowIterator();
                long time = System.currentTimeMillis();
                if (rowIterator.hasNext()) {
                    rowIterator.next();
                }
                while (rowIterator.hasNext()) {
                    Row row = (Row)rowIterator.next();
                    Iterator cells = row.cellIterator();
                    if (!cells.hasNext()) continue;
                    Cell cell = (Cell)cells.next();
                    currentUserId = this.a(cell);
                    if (!cells.hasNext()) continue;
                    cell = (Cell)cells.next();
                    currentPassword = this.a(cell);
                    if (!cells.hasNext()) continue;
                    cell = (Cell)cells.next();
                    currentSurplusNumber = this.a(cell);
                    if (cells.hasNext()) {
                        cell = (Cell)cells.next();
                        currentUserDesc = this.a(cell);
                    }
                    if ("".equals(this.userId) || "".equals(this.password) || !currentPassword.matches(matchPassword)) continue;
                    try {
                        User user = helper.findUserById(currentUserId);
                        if (user != null) {
                            ++sameRecords;
                        }
                    }
                    catch (Exception e2) {}
                    continue;
                    if (!"".equals(currentSurplusNumber)) {
                        if (currentSurplusNumber.matches(matchStr)) {
                            try {
                                surplusNumber = Integer.parseInt(currentSurplusNumber);
                            }
                            catch (Exception e3) {
                                continue;
                            }
                        }
                    } else {
                        surplusNumber = 0;
                    }
                    ++validateRecords;
                    try {
                        this.a(pstmt, currentUserId, currentPassword, currentUserDesc, surplusNumber);
                    }
                    catch (Exception e4) {
                        this.log.error((Object)("\u7528\u6237\u4ee3\u53f7\uff1a" + currentUserId + "\u63d2\u5165\u6570\u636e\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u8fde\u63a5\u6216\u7528\u6237\u4ee3\u7801\u683c\u5f0f\u662f\u5426\u6709\u8bef"), (Throwable)e4);
                        continue;
                    }
                    if (++batchRecord != 5000L) continue;
                    num = pstmt.executeBatch();
                    pstmt.clearBatch();
                    updateRecordCount += (long)num.length;
                    batchRecord = 0L;
                }
                num = pstmt.executeBatch();
                long time2 = System.currentTimeMillis();
                System.out.println("\u5171\u66f4\u65b0\u4e86" + (updateRecordCount += (long)num.length) + "\u6761\u8bb0\u5f55,\u5171\u8017\u65f6" + (time2 - time) / 1000L + "\u79d2");
            }
            catch (IOException e5) {
                this.log.error((Object)"\u89e3\u6790\u6587\u4ef6\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6..", (Throwable)e5);
                return;
            }
        }
        catch (Exception e6) {
            this.log.error((Object)"\u5bfc\u5165\u7528\u6237\u5931\u8d25", (Throwable)e6);
            return;
        }
        try {
            String message = "\u5bfc\u5165\u6587\u4ef6\u4e2d\u5171\u8ba1\u6709" + validateRecords + "\u4e2a\u6709\u6548\u7528\u6237\u540d, \u5b58\u5728" + sameRecords + "\u4e2a\u7528\u6237\u540c\u540d, \u5b9e\u9645\u5bfc\u5165" + updateRecordCount + "\u4e2a\u65b0\u7528\u6237";
            response.getWriter().println("<script> parent.callback('" + message + "','" + updateRecordCount + "')</script>");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void a(PreparedStatement pstmt, String userId, String password, String userDesc, int surplusNumber) throws SQLException {
        pstmt.setString(1, userId);
        pstmt.setString(2, password);
        pstmt.setString(3, userDesc);
        pstmt.setInt(4, surplusNumber);
        pstmt.addBatch();
    }

    private String a(Cell cell) {
        switch (cell.getCellType()) {
            case 0: {
                return "" + (long)cell.getNumericCellValue();
            }
            case 1: {
                return cell.getStringCellValue();
            }
            case 4: {
                return "" + cell.getBooleanCellValue();
            }
            case 2: {
                return cell.getCellFormula();
            }
            case 3: {
                return null;
            }
            case 5: {
                return null;
            }
        }
        return null;
    }

    public void cancelWaitMsg(HttpServletRequest req, HttpServletResponse resp) {
        DbHelper hepler = null;
        try {
            User user = (User)req.getSession(true).getAttribute("user");
            hepler = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            hepler.cancelWaitMsg(user);
        }
        catch (Exception e2) {
            req.setAttribute("page", (Object)new Page());
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.sending_failed_to_access_the_database"));
            this.findForward("/unsentrecord.jsp", true, req, resp);
        }
        this.findForward("/smsAction?action=unsentRecord&pageIndex=1", true, req, resp);
    }

    public void deleteCanceledMsg(HttpServletRequest req, HttpServletResponse resp) {
        DbHelper hepler = null;
        try {
            User user = (User)req.getSession(true).getAttribute("user");
            hepler = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            hepler.deleteCanceledMsg(user);
        }
        catch (Exception e2) {
            req.setAttribute("page", (Object)new Page());
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.sending_failed_to_access_the_database"));
            this.findForward("/unsentrecord.jsp", true, req, resp);
        }
        this.findForward("/smsAction?action=unsentRecord&pageIndex=1", true, req, resp);
    }

    public void msgRecord(HttpServletRequest req, HttpServletResponse resp) {
        DbHelper hepler = null;
        Page page = null;
        try {
            User user = (User)req.getSession(true).getAttribute("user");
            hepler = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            if (this.condition == null) {
                this.condition = new Condition();
            }
            page = hepler.findMsgByCondition(this.condition, user);
            req.setAttribute("page", (Object)page);
            this.findForward("/msgrecord.jsp", true, req, resp);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            if (this.condition == null) {
                this.condition = new Condition();
            }
            req.setAttribute("page", (Object)new Page());
            req.setAttribute("message", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.sending_failed_to_access_the_database"));
            this.findForward("/msgrecord.jsp", true, req, resp);
        }
    }
}

