/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem.athandler;

import cn.sendsms.GatewayException;
import cn.sendsms.Service;
import cn.sendsms.TimeoutException;
import cn.sendsms.modem.ModemGateway;
import cn.sendsms.modem.athandler.ATHandler;
import java.io.IOException;

public class ATHandler_TDTech_ME901
extends ATHandler {
    public ATHandler_TDTech_ME901(ModemGateway myGateway) {
        super(myGateway);
        this.setStorageLocations("SM");
    }

    @Override
    public void init() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT^CURC=0\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CLIP=1\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CSMS=1\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CNMI=1,1,0,1,0\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CREG=0\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CPMS=\"SM\",\"SM\",\"SM\"\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().getResponse();
    }

    @Override
    public void reset() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CFUN=1\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT_AFTER_RESET);
        this.getModemDriver().clearBuffer();
    }

    @Override
    public int findMatchingTerminator(String response) {
        if (response.indexOf("OK") != -1) {
            return 0;
        }
        for (int i2 = 0; i2 < this.terminators.length; ++i2) {
            if (!response.matches(this.terminators[i2])) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public String readTextMode() throws GatewayException, TimeoutException, IOException, InterruptedException {
        this.threadWait(2000L);
        this.getModemDriver().write("AT+CREG?\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        return this.getModemDriver().getResponse();
    }

    @Override
    public boolean deleteMessage(int memIndex, String memLocation) throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CMGD=_1_\r".replaceAll("_1_", "" + memIndex));
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        return true;
    }

    @Override
    public void keepLinkOpen() throws TimeoutException, GatewayException, IOException, InterruptedException {
    }
}

