/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.common;

import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.web.DbHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Random;
import jssc.SerialPort;
import jssc.SerialPortException;
import org.apache.log4j.Logger;

public class Utils {
    public static final Logger log = Logger.getRootLogger();

    public static String getString(byte[] byteArray) {
        if (byteArray == null || byteArray.length == 0) {
            return "";
        }
        try {
            return new String(byteArray, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            log.error((Object)Utils.byteArrayToStr(byteArray), (Throwable)e2);
            return "";
        }
    }

    public static byte[] getByteArray(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            return null;
        }
    }

    public static byte[] getByteArray(String str, String codingType) {
        try {
            return str.getBytes(codingType);
        }
        catch (UnsupportedEncodingException e2) {
            return null;
        }
    }

    public static String getString(byte[] byteArray, String codingType) {
        if (byteArray == null || byteArray.length == 0) {
            return "";
        }
        try {
            return new String(byteArray, codingType);
        }
        catch (UnsupportedEncodingException e2) {
            log.error((Object)Utils.byteArrayToStr(byteArray), (Throwable)e2);
            return "";
        }
    }

    public static String byteArrayToStr(byte[] byteArray) {
        StringBuffer buffer = new StringBuffer();
        for (int i2 = 0; i2 < byteArray.length; ++i2) {
            buffer.append(byteArray[i2] + " ");
        }
        return buffer.toString();
    }

    public static byte[] mergeByteArray(byte[] tmpMessageByteArray, byte[] messageByteArray) {
        if (tmpMessageByteArray == null && messageByteArray == null) {
            return null;
        }
        if (tmpMessageByteArray == null && messageByteArray != null) {
            return messageByteArray;
        }
        if (tmpMessageByteArray != null && messageByteArray == null) {
            return tmpMessageByteArray;
        }
        byte[] mergedeByteArray = new byte[tmpMessageByteArray.length + messageByteArray.length];
        System.arraycopy(messageByteArray, 0, mergedeByteArray, 0, messageByteArray.length);
        System.arraycopy(tmpMessageByteArray, 0, mergedeByteArray, messageByteArray.length, tmpMessageByteArray.length);
        return mergedeByteArray;
    }

    public static String complementStrWithZero(String str, int length) {
        if (str == null) {
            return "";
        }
        int strLength = str.length();
        if (strLength > length) {
            return str.substring(strLength - length);
        }
        if (strLength == length) {
            return str;
        }
        for (int i2 = 0; i2 < length - strLength; ++i2) {
            str = "0" + str;
        }
        return str;
    }

    public static String complementStrWithSpace(String str, int length) {
        if (str == null) {
            return "";
        }
        int strLength = str.length();
        if (strLength > length) {
            return str.substring(strLength - length);
        }
        if (strLength == length) {
            return str;
        }
        for (int i2 = 0; i2 < length - strLength; ++i2) {
            str = " " + str;
        }
        return str;
    }

    public static String deleteSuffix(String inputStr, String suffix) {
        if (inputStr == null || inputStr.equals("") || !inputStr.endsWith(suffix)) {
            return inputStr;
        }
        return inputStr.substring(0, inputStr.length() - suffix.length());
    }

    public static String deletePrefix(String sourceStr, String prefix) {
        if (sourceStr == null || sourceStr.equals("") || !sourceStr.startsWith(prefix)) {
            return sourceStr;
        }
        return sourceStr.substring(prefix.length());
    }

    public static boolean isEmptyStr(String str) {
        return str == null || "".equals(str);
    }

    public static int getRandom(int min, int max) {
        if (max <= min) {
            return 0;
        }
        return new Random().nextInt(max - min) + min;
    }

    public static String byteArr2HexStr(byte[] arrB) {
        int iLen = arrB.length;
        StringBuffer sb = new StringBuffer(iLen * 2);
        for (int i2 = 0; i2 < iLen; ++i2) {
            int intTmp;
            for (intTmp = arrB[i2]; intTmp < 0; intTmp += 256) {
            }
            if (intTmp < 16) {
                sb.append("0");
            }
            sb.append(Integer.toString(intTmp, 16));
        }
        return sb.toString();
    }

    public static byte[] hexStr2ByteArr(String strIn) {
        byte[] arrB = strIn.getBytes();
        int iLen = arrB.length;
        byte[] arrOut = new byte[iLen / 2];
        for (int i2 = 0; i2 < iLen; i2 += 2) {
            String strTmp = new String(arrB, i2, 2);
            arrOut[i2 / 2] = (byte)Integer.parseInt(strTmp, 16);
        }
        return arrOut;
    }

    public static ArrayList<String> getEmptyList(int length) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < length; ++i2) {
            list.add("");
        }
        return list;
    }

    public static String getXORCheckStr(byte[] data) {
        String checkStr = "";
        byte temp = data[0];
        for (int i2 = 1; i2 < data.length; ++i2) {
            temp = (byte)(temp ^ data[i2]);
        }
        String frontPart = Integer.toHexString((temp & 0xF0) >> 4);
        String rearPart = Integer.toHexString(temp & 0xF);
        checkStr = frontPart + rearPart;
        return checkStr.toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isConnectionOK(String server, int port) {
        Socket connect = new Socket();
        try {
            connect.connect(new InetSocketAddress(server, port), 100);
            boolean bl = connect.isConnected();
            return bl;
        }
        catch (Exception e2) {
            log.error((Object)("\u65e0\u6cd5\u8fde\u63a5\u5230\u3010" + server + ":" + port + "\u3011\uff01"), (Throwable)e2);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                connect.close();
            }
            catch (IOException e3) {
                log.error((Object)("\u3010" + server + ":" + port + "\u3011\u65ad\u5f00\u8fde\u63a5\u5f02\u5e38\uff01"), (Throwable)e3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean closePort(SerialPort serialport) {
        if (serialport == null) {
            return true;
        }
        String portID = serialport.getPortName();
        if (portID.matches("Vitual-[0-9]+-COM")) {
            return true;
        }
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            try {
                if (!serialport.isOpened()) {
                    return true;
                }
                serialport.closePort();
                return true;
            }
            catch (SerialPortException e2) {
                if (!serialport.isOpened()) {
                    log.info((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u5173\u95ed\u6210\u529f"));
                    return true;
                }
                log.error((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u5173\u95ed\u5931\u8d25"));
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean openPort(int baudrate, SerialPort serialport) {
        if (serialport == null) {
            return false;
        }
        String portID = serialport.getPortName();
        if (portID.matches("Vitual-[0-9]+-COM")) {
            return true;
        }
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            if (serialport.isOpened()) {
                log.info((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u5df2\u7ecf\u6253\u5f00\u4e86\u3002\u3002\u3002"));
                return true;
            }
            try {
                serialport.openPort();
                serialport.setFlowControlMode(0);
                serialport.setParams(baudrate, 8, 1, 0);
                return true;
            }
            catch (SerialPortException e2) {
                log.error((Object)"\u7aef\u53e3\u6253\u5f00\u5931\u8d25\u3002\u3002\u3002", (Throwable)e2);
                try {
                    if (serialport.isOpened()) {
                        serialport.closePort();
                    }
                }
                catch (SerialPortException e1) {
                    log.error((Object)"\u7aef\u53e3\u5173\u95ed\u5f02\u5e38...", (Throwable)e1);
                }
                return false;
            }
        }
    }

    public static void deleteTmpmsg(String pduString, String messageType) {
        DbHelper helper = null;
        try {
            helper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
        }
        catch (Exception e2) {
            log.error((Object)"\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\u3002\u3002\u3002\u3002\u3002", (Throwable)e2);
        }
        boolean deleteSucess = helper.deleteTmpMsgByType(pduString, messageType);
        if (!deleteSucess) {
            log.info((Object)("\u4e34\u65f6\u8868\u4fe1\u606f\u5220\u9664\u8fd4\u56defalse\uff1a" + pduString), null);
        }
    }
}

