/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.driver.loraDriver;

import cn.ajwcc.pduUtils.gsm3040.PduUtils;
import cn.sendsms.InboundMessage;
import cn.sendsms.Message;
import cn.sendsms.OutboundMessage;
import cn.sendsms.TmpMsg;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.web.NewAuth;
import cn.sendsms.otherModem.bean.LoraBean;
import cn.sendsms.otherModem.common.DesUtils;
import cn.sendsms.otherModem.common.Utils;
import cn.sendsms.otherModem.driver.ModemDriver;
import cn.sendsms.otherModem.thread.WatchDog;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletException;
import jssc.SerialPort;
import jssc.SerialPortException;
import jssc.SerialPortList;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.log4j.Logger;

public class LoRaDriver
extends ModemDriver {
    private static int loop = -1;
    private static ArrayList<SerialPort> serialPortList = new ArrayList();
    private static final LoRaDriver cache = new LoRaDriver();
    private static Logger log = Logger.getRootLogger();
    private Vector<LoraBean> a = new Vector();
    private Vector<OutboundMessage> b = new Vector();
    private Vector<InboundMessage> c = new Vector();
    private static DesUtils des = null;
    public static final int[] BAUDRATES = new int[]{9600, 115200};
    public static final int MESSAGE_lENGTH = 2;
    public static final String MESSAGE_HEADER_HEX_STR = "FFFF";
    public static final int MESSAGE_HEADER_HEX_STR_LENGTH = 4;
    public static final int DISPATCH_DATE_LENGTH = 14;
    public static final int MESSAGE_SERIAL_LENGTH = 2;
    public static final int ENCODING_TYPE_LENGTH = 2;
    private static HashMap<String, String> messageIDWaitTimesMap = new HashMap();
    public static HashMap<String, String> messageIDReceiveDeviceIDMap = new HashMap();
    public static HashMap<String, ArrayList<String>> messageIDMessageInfoMap = new HashMap();
    public static HashMap<String, String> messageIDExpectMessageNumMap = new HashMap();
    public static HashMap<String, HashSet<String>> messageIDRealMessageNumMap = new HashMap();
    public static final String LOST_MESSAGE_FRAGMENT = "*****";
    public static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private static int MESSAGE_TEXT_LENGTH = 10;
    public static final String LORA_DEVICE_SERIAL_NUMBER = "LORA";
    public static final int SPILITER = -1;
    public static final String ENCODING_IN_7BIT = "AA";
    public static final String ENCODING_IN_8BIT = "BB";
    public static final String ENCODING_IN_UFT8 = "CC";

    private LoRaDriver() {
    }

    public static final LoRaDriver getInstance() {
        return cache;
    }

    public void deleteConfiguration(LoraBean bean) throws ConfigurationException {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        boolean flag = false;
        int i2 = 0;
        for (i2 = 0; i2 < 64; ++i2) {
            if (props.getString("loraDevice." + i2, "").trim().length() == 0 || props.getString("loraDevice." + i2, "").indexOf(bean.getGatewayID()) == -1) continue;
            flag = true;
            props.clearProperty("loraDevice." + i2);
            break;
        }
        if (flag) {
            props.clearProperty(bean.getGatewayID() + ".port");
            props.clearProperty(bean.getGatewayID() + ".baudrate");
            props.clearProperty(bean.getGatewayID() + ".address");
            props.clearProperty(bean.getGatewayID() + ".channel");
            props.clearProperty(bean.getGatewayID() + ".type");
            props.clearProperty(bean.getGatewayID() + ".using_status");
            props.clearProperty(bean.getGatewayID() + ".serial_number");
        }
        props.save();
    }

    public void getLoRaDeviceInfo() throws Exception {
        int i2;
        long startTime = System.currentTimeMillis();
        ArrayList<String> serialNumberList = new ArrayList();
        serialPortList = new ArrayList();
        String[] portList = SerialPortList.getPortNames();
        if (portList.length > 0) {
            serialNumberList = this.getSerialNumberList();
        }
        int deviceID = 1;
        block14: for (i2 = 0; i2 < portList.length; ++i2) {
            for (int j2 = 0; j2 < BAUDRATES.length; ++j2) {
                SerialPort serialPort = new SerialPort(portList[i2]);
                LoraBean loraInfo = new LoraBean();
                log.error((Object)("\u7aef\u53e3" + serialPort + "\u672a\u6253\u5f00"), null);
                log.info((Object)("\u6b63\u5728\u5c1d\u8bd5\u6253\u5f00\u7aef\u53e3:" + serialPort));
                try {
                    if (!serialPort.isOpened()) {
                        serialPort.openPort();
                    }
                    serialPort.setFlowControlMode(0);
                    serialPort.setParams(BAUDRATES[j2], 8, 1, 0);
                }
                catch (SerialPortException e2) {
                    if (serialPort.isOpened()) {
                        log.info((Object)("\u7aef\u53e3" + serialPort + "\u6253\u5f00\u6210\u529f"));
                    }
                    log.info((Object)("\u7aef\u53e3" + serialPort + "\u6253\u5f00\u5931\u8d25"));
                }
                String response = this.b(serialPort);
                response = response.replace(" ", "");
                if (response.startsWith("C0") && response.length() == 12) {
                    loraInfo.setGatewayID("lora" + deviceID);
                    ++deviceID;
                    loraInfo.setPortID(portList[i2]);
                    loraInfo.setAddress(response.substring(2, 6));
                    loraInfo.setChannel(response.substring(8, 10));
                    String seiralNumber = this.getSerialNumber(portList[i2], serialNumberList);
                    boolean flag = NewAuth.checkDeviceAuth(seiralNumber);
                    loraInfo.setValidate(flag);
                    if (flag) {
                        try {
                            NewAuth.updateAuthorizeTemp();
                        }
                        catch (Exception e3) {
                            log.error((Object)"", (Throwable)e3);
                        }
                        cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u6388\u6743\u6709\u6548", null, loraInfo.getGatewayID());
                    } else {
                        try {
                            NewAuth.updateAuthorizeTemp();
                        }
                        catch (Exception e4) {
                            log.error((Object)"", (Throwable)e4);
                        }
                        cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u672a\u6388\u6743", null, loraInfo.getGatewayID());
                    }
                    loraInfo.setSerialNumber(seiralNumber);
                    this.addLora(loraInfo);
                    serialPortList.add(serialPort);
                    try {
                        serialPort.closePort();
                    }
                    catch (SerialPortException e5) {
                        if (!serialPort.isOpened()) {
                            log.info((Object)("\u7aef\u53e3" + serialPort + "\u5173\u95ed\u6210\u529f\uff01"));
                            continue block14;
                        }
                        log.info((Object)("\u7aef\u53e3" + serialPort + "\u5173\u95ed\u5931\u8d25"));
                    }
                    continue block14;
                }
                try {
                    serialPort.closePort();
                    continue;
                }
                catch (SerialPortException e6) {
                    if (!serialPort.isOpened()) {
                        log.info((Object)("\u7aef\u53e3" + serialPort + "\u5173\u95ed\u6210\u529f\uff01"));
                        continue;
                    }
                    log.info((Object)("\u7aef\u53e3" + serialPort + "\u5173\u95ed\u5931\u8d25"));
                }
            }
        }
        for (i2 = 0; i2 < this.a.size(); ++i2) {
            LoraBean loraInfo = this.a.get(i2);
            String seiralNumber = this.getSerialNumber(loraInfo.getPortID(), serialNumberList);
            boolean flag = NewAuth.checkDeviceAuth(seiralNumber);
            loraInfo.setValidate(flag);
            if (flag) {
                try {
                    NewAuth.updateAuthorizeTemp();
                }
                catch (Exception e7) {
                    log.error((Object)"", (Throwable)e7);
                }
                cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u6388\u6743\u6709\u6548", null, loraInfo.getGatewayID());
            } else {
                try {
                    NewAuth.updateAuthorizeTemp();
                }
                catch (Exception e8) {
                    log.error((Object)"", (Throwable)e8);
                }
                cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u672a\u6388\u6743", null, loraInfo.getGatewayID());
            }
            loraInfo.setSerialNumber(seiralNumber);
        }
        long endTime = System.currentTimeMillis();
        log.info((Object)("\u68c0\u6d4b\u8bbe\u5907\u82b1\u8d39\uff1a" + (endTime - startTime) + "ms"));
    }

    public String getSerialNumber(String portID, List<String> serialNumberList) {
        if (serialNumberList == null) {
            return "";
        }
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            if (!this.a.get(i2).getPortID().equals(portID)) continue;
            if (serialNumberList.size() > i2) {
                return serialNumberList.get(i2);
            }
            return "";
        }
        return "";
    }

    public void addLora(LoraBean obj) {
        this.a.add(obj);
    }

    public void addMessage(OutboundMessage obj) {
        this.b.add(obj);
    }

    public void addMessages(List<OutboundMessage> objList) {
        this.b.addAll(objList);
    }

    public synchronized void addInMessage(Date date, String myOriginator, String text, String deviveID, String serialNumber) throws Exception {
        String lora_using = JDSMSServer.getInstance().getProperties().getString("settings.lora_using", "yes");
        if (!lora_using.equals("yes")) {
            return;
        }
        InboundMessage obj = new InboundMessage(date, myOriginator, text, deviveID);
        this.c.add(obj);
    }

    public List<LoraBean> getAll() {
        ArrayList<LoraBean> list = new ArrayList<LoraBean>();
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            list.add(this.a.get(i2));
        }
        return list;
    }

    public void deleteAll() {
        this.a.removeAllElements();
        serialPortList = new ArrayList();
    }

    public boolean isLoraRegistered(String serialnum) throws Exception {
        String regcode = NewAuth.getAuthorizeInfo(serialnum, "regcode");
        if (regcode == null || regcode.indexOf("null") != -1) {
            regcode = "";
        }
        if (regcode.equals("")) {
            return false;
        }
        return NewAuth.checkDeviceAuth(serialnum);
    }

    public List<InboundMessage> getInMessages() {
        ArrayList<InboundMessage> list = new ArrayList<InboundMessage>();
        for (int i2 = 0; i2 < this.c.size(); ++i2) {
            InboundMessage msg = this.c.get(i2);
            list.add(msg);
        }
        this.c = new Vector();
        return list;
    }

    public List<String> getUsingLoraList() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            LoraBean device = this.a.get(i2);
            if (!device.getUsingStatus().equals("1")) continue;
            list.add(device.getGatewayID());
        }
        return list;
    }

    public String getSerialNumber(String portID) {
        String serialNumber = "";
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            LoraBean device = this.a.get(i2);
            if (!portID.equals(device.getPortID())) continue;
            serialNumber = device.getSerialNumber();
        }
        return serialNumber;
    }

    public List<LoraBean> getUsingLoras() {
        ArrayList<LoraBean> list = new ArrayList<LoraBean>();
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            LoraBean device = this.a.get(i2);
            if (!device.getUsingStatus().equals("1")) continue;
            list.add(device);
        }
        return list;
    }

    public void deleteLora(String portID) throws ServletException, IOException, Exception {
        int index = 0;
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            LoraBean device = this.a.get(i2);
            if (!device.getPortID().equals(portID)) continue;
            index = i2;
            break;
        }
        LoRaDriver.getInstance().deleteLoraDevice(portID);
        this.a.removeElementAt(index);
    }

    public boolean checkStartLoras(String portID) {
        if (portID == null || portID.equals("")) {
            return false;
        }
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            SerialPort serialPort;
            LoraBean device = this.a.get(i2);
            if (!portID.equals(device.getPortID()) || !device.getUsingStatus().equals("1") || (serialPort = this.getSerialPort(portID)) == null || !serialPort.isOpened()) continue;
            return true;
        }
        return false;
    }

    public boolean checkStopLoras(String portID) {
        if (portID == null || portID.equals("")) {
            return false;
        }
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            SerialPort serialPort;
            LoraBean device = this.a.get(i2);
            if (!portID.equals(device.getPortID()) || !device.getUsingStatus().equals("0") || (serialPort = this.getSerialPort(portID)) == null || serialPort.isOpened()) continue;
            return true;
        }
        return false;
    }

    public boolean startDevice(String portID, List<String> serialNumberList) {
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            LoraBean device = this.a.get(i2);
            if (!device.getPortID().equals(portID)) continue;
            if (!device.isValidate()) {
                String serial_number = device.getSerialNumber();
                String port = device.getPortID();
                if (serial_number == null || serial_number.equals("")) {
                    serial_number = this.getSerialNumber(port, serialNumberList);
                }
                boolean flag = NewAuth.checkDeviceAuth(serial_number);
                device.setValidate(flag);
                if (flag) {
                    try {
                        NewAuth.updateAuthorizeTemp();
                    }
                    catch (Exception e2) {
                        log.error((Object)"\u66f4\u65b0\u6388\u6743\u4fe1\u606f\u5f02\u5e38\u3002", (Throwable)e2);
                    }
                    cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u6388\u6743\u6709\u6548", null, device.getGatewayID());
                } else {
                    try {
                        NewAuth.updateAuthorizeTemp();
                    }
                    catch (Exception e3) {
                        log.error((Object)"\u66f4\u65b0\u6388\u6743\u4fe1\u606f\u5f02\u5e38\u3002", (Throwable)e3);
                    }
                    cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u672a\u6388\u6743", null, device.getGatewayID());
                }
            }
            if (!device.getUsingStatus().equals("0")) continue;
            SerialPort serialport = this.getSerialPort(portID);
            try {
                serialport.openPort();
                serialport.setFlowControlMode(0);
                serialport.setParams(this.getbaudrate(portID), 8, 1, 0);
                device.setUsingStatus("1");
                return true;
            }
            catch (SerialPortException e4) {
                if (serialport.isOpened()) {
                    log.info((Object)("\u7aef\u53e3" + portID + "\u6253\u5f00\u6210\u529f"));
                    device.setUsingStatus("1");
                    return true;
                }
                log.error((Object)("\u7aef\u53e3" + portID + "\u6253\u5f00\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u8bbe\u5907\u662f\u5426\u6b63\u5e38\u8fde\u63a5:" + portID));
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean restartDevice(String portID) {
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            LoraBean device = this.a.get(i2);
            if (!device.getPortID().equals(portID)) continue;
            SerialPort serialport = this.getSerialPort(portID);
            if (serialport == null) {
                return false;
            }
            try {
                serialport.closePort();
            }
            catch (SerialPortException e2) {
                if (!serialport.isOpened()) {
                    log.info((Object)("\u7aef\u53e3" + portID + "\u5173\u95ed\u6210\u529f"));
                }
                log.error((Object)("\u7aef\u53e3" + portID + "\u5173\u95ed\u5931\u8d25"));
                return false;
            }
            try {
                serialport.openPort();
                serialport.setFlowControlMode(0);
                serialport.setParams(this.getbaudrate(portID), 8, 1, 0);
                device.setUsingStatus("1");
                return true;
            }
            catch (SerialPortException e3) {
                if (serialport.isOpened()) {
                    log.info((Object)("\u7aef\u53e3" + portID + "\u6253\u5f00\u6210\u529f"));
                    device.setUsingStatus("1");
                    return true;
                }
                log.error((Object)("\u7aef\u53e3" + portID + "\u6253\u5f00\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u8bbe\u5907\u662f\u5426\u6b63\u5e38\u8fde\u63a5:" + portID));
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean stopDevice(String portID) {
        int i2 = 0;
        while (i2 < this.a.size()) {
            LoraBean device;
            LoraBean loraBean = device = this.a.get(i2);
            synchronized (loraBean) {
                if (device.getPortID().equals(portID)) {
                    SerialPort serialport;
                    device.setUsingStatus("0");
                    SerialPort serialPort = serialport = this.getSerialPort(portID);
                    synchronized (serialPort) {
                        if (serialport == null) {
                            return false;
                        }
                        try {
                            serialport.closePort();
                        }
                        catch (SerialPortException e2) {
                            if (serialport.isOpened()) {
                                log.error((Object)("\u7aef\u53e3" + portID + "\u5173\u95ed\u5931\u8d25"));
                                return false;
                            }
                            log.info((Object)("\u7aef\u53e3" + portID + "\u5173\u95ed\u6210\u529f"));
                        }
                        return true;
                    }
                }
            }
            ++i2;
        }
        return false;
    }

    public SerialPort getSerialPort(String portID) {
        for (int i2 = 0; i2 < serialPortList.size(); ++i2) {
            if (!serialPortList.get(i2).getPortName().equals(portID)) continue;
            return serialPortList.get(i2);
        }
        SerialPort serialPort = new SerialPort(portID);
        try {
            if (!serialPort.isOpened()) {
                serialPort.openPort();
            }
            serialPort.setFlowControlMode(0);
            serialPort.setParams(this.getbaudrate(portID), 8, 1, 0);
            serialPortList.add(serialPort);
            serialPort.closePort();
            return serialPort;
        }
        catch (SerialPortException e2) {
            log.error((Object)"\u4ece\u914d\u7f6e\u6587\u4ef6\u4e2d\u8bfb\u53d6\u7684\u8bbe\u5907\u521d\u59cb\u5316\u5931\u8d25\u3002\u3002\u3002", null);
            return null;
        }
    }

    public void deleteLoraDevice(String portID) throws ServletException, IOException, Exception {
        try {
            List<LoraBean> List2 = LoRaDriver.getInstance().getAll();
            int iLen = List2.size();
            int iLocation = 0;
            for (iLocation = 0; iLocation < iLen && !List2.get(iLocation).getPortID().equals(portID); ++iLocation) {
            }
            PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
            int i2 = 0;
            for (i2 = 0; i2 < 64; ++i2) {
                Object[] values = props.getStringArray("loraDevice." + i2);
                if (ArrayUtils.isEmpty((Object[])values) || !((String)values[0]).equals(List2.get(iLocation).getGatewayID())) continue;
                props.clearProperty("loraDevice." + i2);
                props.clearProperty((String)values[0] + ".port");
                props.clearProperty((String)values[0] + ".baudrate");
                props.clearProperty((String)values[0] + ".address");
                props.clearProperty((String)values[0] + ".channel");
                props.clearProperty((String)values[0] + ".type");
                props.clearProperty((String)values[0] + ".serial_number");
                props.clearProperty((String)values[0] + ".using_status");
                props.save();
                break;
            }
        }
        catch (Exception e2) {
            log.error((Object)"\u5220\u9664LoRa\u8bbe\u5907\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e2);
            throw e2;
        }
    }

    public boolean sendMessage(OutboundMessage msg) {
        String usingPort = msg.getUsingPortID();
        SerialPort serialport = this.getSerialPort(usingPort);
        LoraBean device = this.findDeviceByPortID(usingPort);
        try {
            if (LoRaDriver.readPortInputBufferUsedSize(serialport) == -1) {
                log.error((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u6389\u7ebf\u4e86\uff01"));
                device.setUsingStatus("2");
                WatchDog.getInstance().interrupt();
                return false;
            }
        }
        catch (Exception e2) {
            log.error((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u6389\u7ebf\u4e86\uff01"));
            log.error((Object)"\u8bbe\u5907\u8fde\u63a5\u5f02\u5e38\uff0c\u5373\u5c06\u91cd\u542f\uff01\u3010sendMessage\u3011");
            device.setUsingStatus("2");
            WatchDog.getInstance().interrupt();
            return false;
        }
        msg.setGatewayId(device.getGatewayID());
        String text = msg.getText();
        Date date = msg.getDispatchDate();
        if (date == null) {
            date = new Date();
        }
        String recipient = msg.getRecipient().toUpperCase();
        String channel = this.findDeviceByPortID(usingPort).getChannel();
        int textLength = text.length();
        this.a(msg.getEncoding());
        int splitNumber = textLength / MESSAGE_TEXT_LENGTH;
        if (textLength % MESSAGE_TEXT_LENGTH != 0) {
            ++splitNumber;
        }
        int msgID = msg.getMessageID();
        if (textLength <= MESSAGE_TEXT_LENGTH) {
            String messageIdentificationStr = this.a(msgID, 1, 1);
            boolean result = this.a(usingPort, recipient, channel, text, msg.getEncoding(), messageIdentificationStr, date);
            if (!result) {
                log.error((Object)(text + "\u53d1\u9001\u5931\u8d25.."));
                return false;
            }
        } else {
            int serialNumber = 0;
            for (int startIndex = 0; startIndex < text.length(); startIndex += MESSAGE_TEXT_LENGTH) {
                boolean result;
                String tempText = "";
                String getMessageIdentificationStr = this.a(msgID, splitNumber, ++serialNumber);
                if (startIndex + MESSAGE_TEXT_LENGTH < textLength) {
                    tempText = text.substring(startIndex, startIndex + MESSAGE_TEXT_LENGTH);
                    result = this.a(usingPort, recipient, channel, tempText, msg.getEncoding(), getMessageIdentificationStr, date);
                    if (result) continue;
                    log.error((Object)(text + "\u53d1\u9001\u5931\u8d25.."));
                    return false;
                }
                tempText = text.substring(startIndex, text.length());
                result = this.a(usingPort, recipient, channel, tempText, msg.getEncoding(), getMessageIdentificationStr, date);
                if (result) continue;
                log.error((Object)(text + "\u53d1\u9001\u5931\u8d25.."));
                return false;
            }
        }
        return true;
    }

    private void a(Message.MessageEncodings encoding) {
        switch (encoding) {
            case ENC7BIT: {
                MESSAGE_TEXT_LENGTH = 32;
                break;
            }
            case ENC8BIT: {
                MESSAGE_TEXT_LENGTH = 32;
                break;
            }
            case ENCUCS2: {
                MESSAGE_TEXT_LENGTH = 10;
                break;
            }
        }
    }

    private String a(String usingLoraPortID) {
        if (usingLoraPortID == null) {
            return "0000";
        }
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            if (!this.a.get(i2).getPortID().equals(usingLoraPortID)) continue;
            return this.a(this.a.get(i2).getAddress(), 4);
        }
        return null;
    }

    private boolean a(String portID, String recipient, String channel, String text, Message.MessageEncodings messageEncodings, String messageIdentification, Date date) {
        byte[] encryptText;
        SerialPort serialport;
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        String gateway = this.findDeviceByPortID(portID).getGatewayID();
        if (des == null) {
            try {
                des = new DesUtils(props.getString("settings.secretkey", "B123KLF3AB12"));
            }
            catch (Exception e2) {
                log.error((Object)"\u52a0\u5bc6\u89e3\u5bc6\u5de5\u5177\u5b9e\u4f53\u5316\u5931\u8d25", (Throwable)e2);
            }
        }
        if ((serialport = this.getSerialPort(portID)) == null || !serialport.isOpened()) {
            log.error((Object)("\u7aef\u53e3" + portID + "\u672a\u6253\u5f00\uff0c\u8bf7\u786e\u8ba4\u8bbe\u5907\u662f\u5426\u6b63\u5e38\u8fde\u63a5\u3002\u3002\u3002"));
            return false;
        }
        messageIdentification = messageIdentification.toUpperCase();
        String dispatchDate = this.a(dateFormat.format(date).trim(), 14);
        String originator = this.a(portID);
        try {
            encryptText = des.encrypt(this.a(text, messageEncodings));
        }
        catch (Exception e3) {
            log.error((Object)("\u4fe1\u606f\u52a0\u5bc6\u5931\u8d25:" + text), (Throwable)e3);
            return false;
        }
        String messageLengthHexStr = this.a(Integer.toHexString(16 + encryptText.length), 2).toUpperCase();
        String codingType = this.b(messageEncodings);
        byte[] attachInfo = LoRaDriver.compressHexStr(MESSAGE_HEADER_HEX_STR + messageLengthHexStr + messageIdentification + originator + dispatchDate + codingType);
        byte[] message = new byte[attachInfo.length + encryptText.length];
        System.arraycopy(attachInfo, 0, message, 0, attachInfo.length);
        System.arraycopy(encryptText, 0, message, attachInfo.length, encryptText.length);
        byte[] address = this.c(recipient + channel);
        byte[] messageWithAddress = new byte[message.length + address.length];
        System.arraycopy(address, 0, messageWithAddress, 0, address.length);
        System.arraycopy(message, 0, messageWithAddress, address.length, message.length);
        try {
            if (!this.a(serialport)) {
                return false;
            }
            boolean sendMessage = this.writePort(serialport, messageWithAddress);
            if (!sendMessage) {
                return false;
            }
            if (!this.a(serialport)) {
                return false;
            }
            try {
                Thread.sleep(props.getInt("settings.lora_outbound_slip_interval", 3) * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (SerialPortException e4) {
            log.error((Object)("\u8bbe\u5907" + gateway + "\u53d1\u9001\u4fe1\u606f" + message + "\u5931\u8d25:" + text), (Throwable)e4);
            return false;
        }
        log.info((Object)("\u8bbe\u5907" + gateway + "\u53d1\u9001\u4fe1\u606f\u6210\u529f\u3002\u5185\u5bb9 \uff1a" + text));
        log.info((Object)("\u4fe1\u606f\u7f16\u7801\uff1a " + this.c(message)));
        return true;
    }

    private boolean a(SerialPort serialport) throws SerialPortException {
        int RestSize = this.readPortOutputBufferUsedSize(serialport);
        int retryCount = 0;
        while (RestSize != 0 && RestSize != -1) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (++retryCount > 50) {
                log.error((Object)"\u53d1\u9001\u7f13\u51b2\u533a\u6e05\u7a7a\u5931\u8d25\uff01");
                return false;
            }
            log.info((Object)("\u53d1\u9001\u7f13\u51b2\u533a\u88ab\u5360\u7528\uff1a" + RestSize));
            RestSize = this.readPortOutputBufferUsedSize(serialport);
        }
        if (RestSize == -1) {
            log.error((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u672a\u6253\u5f00\uff0c\u8bf7\u786e\u8ba4\u8bbe\u5907\u662f\u5426\u6b63\u5e38\u8fde\u63a5\u3002\u3002\u3002."));
            return false;
        }
        return true;
    }

    private String b(Message.MessageEncodings encoding) {
        switch (encoding) {
            case ENC7BIT: {
                return ENCODING_IN_7BIT;
            }
            case ENC8BIT: {
                return ENCODING_IN_8BIT;
            }
            case ENCUCS2: {
                return ENCODING_IN_UFT8;
            }
        }
        return ENCODING_IN_UFT8;
    }

    private Message.MessageEncodings b(String encoding) {
        if (ENCODING_IN_7BIT.equals(encoding)) {
            return Message.MessageEncodings.ENC7BIT;
        }
        if (ENCODING_IN_8BIT.equals(encoding)) {
            return Message.MessageEncodings.ENC8BIT;
        }
        if (ENCODING_IN_UFT8.equals(encoding)) {
            return Message.MessageEncodings.ENCUCS2;
        }
        return Message.MessageEncodings.ENCUCS2;
    }

    private byte[] a(String text, Message.MessageEncodings encoding) throws UnsupportedEncodingException {
        switch (encoding) {
            case ENC7BIT: {
                return PduUtils.encode7bitUserData(null, text.getBytes("US-ASCII"));
            }
            case ENC8BIT: {
                return PduUtils.encode8bitUserData(text);
            }
            case ENCUCS2: {
                return text.getBytes("UTF-8");
            }
        }
        return text.getBytes("UTF-8");
    }

    public void sendMessages(List<OutboundMessage> groupMessages) {
        for (int i2 = 0; i2 < groupMessages.size(); ++i2) {
            boolean sendResult = this.sendMessage(groupMessages.get(i2));
            if (!sendResult) continue;
            groupMessages.get(i2).setMessageStatus(OutboundMessage.MessageStatuses.SENT);
        }
    }

    public LoraBean getPointedSerialLoraBean(String portID) {
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            if (!this.a.get(i2).getPortID().equals(portID)) continue;
            return this.a.get(i2);
        }
        return null;
    }

    private byte[] c(String hex) {
        int len = hex.length() / 2;
        byte[] result = new byte[len];
        char[] achar = hex.toCharArray();
        for (int i2 = 0; i2 < len; ++i2) {
            int pos = i2 * 2;
            result[i2] = (byte)(this.a(achar[pos]) << 4 | this.a(achar[pos + 1]));
        }
        return result;
    }

    private int a(char c2) {
        byte b2 = (byte)"0123456789ABCDEF".indexOf(c2);
        return b2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String b(SerialPort serialport) {
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            try {
                this.writePort(serialport, this.c("C1C1C1"));
            }
            catch (SerialPortException e2) {
                log.error((Object)"\u4e32\u53e3\u901a\u4fe1(\u5199)\u5f02\u5e38\u3002\u8bf7\u786e\u8ba4\u8bbe\u5907\u662f\u5426\u6b63\u5e38\u8fde\u63a5\u3002\u3002\u3002", (Throwable)e2);
                return "";
            }
            PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
            try {
                Thread.sleep(props.getInt("settings.lora_wait_response", 1000));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            String responseStr = "";
            try {
                responseStr = this.readPortInHexStr(serialport);
            }
            catch (SerialPortException e3) {
                log.error((Object)"\u4e32\u53e3\u901a\u4fe1(\u8bfb)\u5f02\u5e38\u3002\u8bf7\u786e\u8ba4\u8bbe\u5907\u662f\u5426\u6b63\u5e38\u8fde\u63a5\u3002\u3002\u3002", (Throwable)e3);
            }
            if (null == responseStr || "".equals(responseStr)) {
                log.info((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u672a\u5904\u4e8e\u4f11\u7720\u72b6\u6001"));
                return "";
            }
            log.info((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u53ef\u80fd\u5904\u4e8e\u4f11\u7720\u72b6\u6001\u6216\u8005\u8be5\u7aef\u53e3\u6b63\u5728\u63a5\u6536\u4fe1\u606f\u3002"));
            log.info((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u8fd4\u56de\u7684\u4fe1\u606f:" + responseStr));
            return responseStr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkDeviceMode(SerialPort serialport) {
        if (serialport == null) {
            return "ERROR2";
        }
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
            try {
                if (!serialport.isOpened()) {
                    serialport.openPort();
                    serialport.setFlowControlMode(0);
                    serialport.setParams(this.getbaudrate(serialport.getPortName()), 8, 1, 0);
                }
                this.writePort(serialport, this.c("C1C1C1"));
                try {
                    Thread.sleep(props.getInt("settings.lora_wait_response", 1000));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                String response = this.readPortInHexStr(serialport);
                serialport.closePort();
                if (response != null && !response.trim().equals("")) {
                    return "ERROR1";
                }
            }
            catch (SerialPortException e2) {
                log.error((Object)"\u4e32\u53e3\u901a\u4fe1(\u5199)\u5f02\u5e38\u3002\u8bf7\u786e\u8ba4\u8bbe\u5907\u662f\u5426\u6b63\u5e38\u8fde\u63a5\u3002\u3002\u3002", (Throwable)e2);
                try {
                    serialport.closePort();
                }
                catch (SerialPortException e1) {
                    log.error((Object)"\u68c0\u6d4b\u8bbe\u5907\u65f6\uff0c\u7aef\u53e3\u5173\u95ed\u5f02\u5e38\u3002\u3002\u3002", (Throwable)e2);
                    return "ERROR2";
                }
                return "ERROR2";
            }
            return "OK";
        }
    }

    public void readLoraMessages() {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        if (des == null) {
            try {
                des = new DesUtils(props.getString("settings.secretkey", "B123KLF3AB12"));
            }
            catch (Exception e1) {
                log.error((Object)"\u83b7\u53d6\u5bc6\u94a5\u5931\u8d25..", (Throwable)e1);
            }
        }
        List<LoraBean> loraInfoList = this.getUsingLoras();
        for (int i2 = 0; i2 < loraInfoList.size(); ++i2) {
            if (this.checkStopLoras(loraInfoList.get(i2).getPortID())) {
                log.error((Object)("\u8bbe\u5907" + loraInfoList.get(i2).getGatewayID() + "\u672a\u542f\u7528\u3002"));
                continue;
            }
            byte[] receiveBytes = null;
            try {
                boolean checkResult = this.checkAuthorizeInfo(loraInfoList.get(i2).getPortID(), null);
                if (!checkResult) continue;
                log.debug((Object)(loraInfoList.get(i2).getGatewayID() + "\u6b63\u5728\u63a5\u6536\u77ed\u4fe1..."));
                SerialPort serialPort = this.getSerialPort(loraInfoList.get(i2).getPortID());
                if (LoRaDriver.readPortInputBufferUsedSize(serialPort) == -1) {
                    log.error((Object)("\u8bbe\u5907" + loraInfoList.get(i2).getGatewayID() + "\u6389\u7ebf\u4e86\uff01"));
                    loraInfoList.get(i2).setUsingStatus("2");
                    WatchDog.getInstance().interrupt();
                    continue;
                }
                receiveBytes = this.readPortInByteArray(serialPort);
                if (receiveBytes == null || receiveBytes.length == 0) {
                    log.debug((Object)("\u8bbe\u5907" + loraInfoList.get(i2).getGatewayID() + "\u6ca1\u6709\u6536\u5230\u4fe1\u606f"));
                    continue;
                }
                if (!this.a(receiveBytes)) {
                    log.info((Object)"\u5c1d\u8bd5\u8bfb\u53d6\u672a\u63a5\u6536\u5b8c\u7684\u4fe1\u606f...");
                    receiveBytes = this.a(receiveBytes, this.getSerialPort(loraInfoList.get(i2).getPortID()));
                }
            }
            catch (SerialPortException e2) {
                log.error((Object)("\u8bfb\u4e32\u53e3" + loraInfoList.get(i2).getPortID() + "\u5931\u8d25.."), (Throwable)e2);
            }
            log.info((Object)("\u8bbe\u5907" + loraInfoList.get(i2).getGatewayID() + "\u6536\u5230\u7f16\u7801\u4fe1\u606f\uff1a" + this.c(receiveBytes)));
            List<String> textList = this.b(receiveBytes);
            if (textList.isEmpty()) {
                log.info((Object)"\u4fe1\u606f\u89e3\u7801\u540e\u4e3a\u7a7a");
            }
            for (int n2 = 0; n2 < textList.size(); ++n2) {
                String text = textList.get(n2);
                log.info((Object)("\u8bbe\u5907" + loraInfoList.get(i2).getGatewayID() + "\u6536\u5230\u4fe1\u606f\uff1a" + textList.get(n2)));
                if (text == null || text.equals("")) continue;
                try {
                    this.addInMessage(new Date(), "", text, loraInfoList.get(i2).getGatewayID(), loraInfoList.get(i2).getSerialNumber());
                    continue;
                }
                catch (Exception e3) {
                    log.error((Object)"\u6dfb\u52a0\u4fe1\u606f\u5931\u8d25\u3002\u3002\u3002");
                }
            }
        }
    }

    private boolean a(byte[] receiveBytes) {
        int minLength = 19;
        if (receiveBytes.length <= minLength) {
            log.error((Object)("\u4fe1\u606f\u3010" + this.c(receiveBytes) + "\u3011\u672a\u63a5\u6536\u5b8c(\u4fe1\u606f\u957f\u5ea6\u5c0f\u4e8e17\u4e2a\u5b57\u8282)\u3002\u3002\u3002"));
            return false;
        }
        ArrayList<Integer> spilitIndexList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < receiveBytes.length; ++i2) {
            if (receiveBytes[i2] != -1 || i2 + 1 >= receiveBytes.length || receiveBytes[i2 + 1] != -1 || i2 + 2 >= receiveBytes.length || receiveBytes[i2 + 2] == -1) continue;
            spilitIndexList.add(i2);
        }
        int endIndex = receiveBytes.length;
        for (int i3 = 0; i3 < spilitIndexList.size(); ++i3) {
            String decompressedStr = "";
            int startIndex = (Integer)spilitIndexList.get(i3);
            endIndex = i3 + 1 < spilitIndexList.size() ? (Integer)spilitIndexList.get(i3 + 1) : receiveBytes.length;
            byte[] receiveBytesSlip = new byte[endIndex - startIndex];
            byte[] attachInfo = new byte[minLength];
            try {
                System.arraycopy(receiveBytes, startIndex, receiveBytesSlip, 0, receiveBytesSlip.length);
                if (endIndex - startIndex <= minLength) {
                    log.error((Object)("\u4fe1\u606f\u3010" + this.c(receiveBytesSlip) + "\u3011\u672a\u63a5\u6536\u5b8c(\u4fe1\u606f\u957f\u5ea6\u5c0f\u4e8e17\u4e2a\u5b57\u8282)\u3002\u3002\u3002"));
                    return false;
                }
                System.arraycopy(receiveBytesSlip, 0, attachInfo, 0, attachInfo.length);
                decompressedStr = LoRaDriver.decompressByteArray(attachInfo, 0, attachInfo.length).substring(4);
                int effectiveLength = Integer.valueOf(decompressedStr.substring(0, 2), 16);
                if (receiveBytesSlip.length - 3 == effectiveLength) continue;
                log.error((Object)("\u4fe1\u606f\u3010" + this.c(receiveBytesSlip) + "\u3011\u672a\u63a5\u6536\u5b8c(\u63a5\u6536\u5230\u4fe1\u606f\u7684\u957f\u5ea6\u548c\u671f\u5f85\u957f\u5ea6\u4e0d\u4e00\u81f4)\u3002\u3002\u3002\u5b9e\u9645\u957f\u5ea6\uff1a" + (receiveBytesSlip.length - 3) + "\u671f\u5f85\u957f\u5ea6\uff1a" + effectiveLength));
                return false;
            }
            catch (Exception e2) {
                log.error((Object)("\u4fe1\u606f\u3010" + this.c(receiveBytesSlip) + "\u3011\u672a\u63a5\u6536\u5b8c(\u51fa\u73b0\u5f02\u5e38\u3002\u3002\u3002)"), (Throwable)e2);
                return false;
            }
        }
        return true;
    }

    private byte[] a(byte[] partialMessage, SerialPort serialport) {
        byte[] buffer = new byte[1024];
        byte[] completeMessage = null;
        int startIndex = 0;
        int messageLength = partialMessage.length;
        System.arraycopy(partialMessage, 0, buffer, startIndex, partialMessage.length);
        startIndex += partialMessage.length;
        int waitTimes = 1;
        do {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            log.info((Object)("\u7b2c" + waitTimes + "\u6b21\u7b49\u5f85.."));
            try {
                if (LoRaDriver.readPortInputBufferUsedSize(serialport) == -1) {
                    log.error((Object)("\u8bbe\u5907" + serialport.getPortName() + "\u6389\u7ebf\uff0c" + this.c(completeMessage) + "\u4e22\u5931\u4e86\uff01"));
                    return completeMessage;
                }
                byte[] remainingMessage = this.readPortInByteArray(serialport);
                if (remainingMessage != null && remainingMessage.length != 0) {
                    System.arraycopy(remainingMessage, 0, buffer, startIndex, remainingMessage.length);
                    startIndex += remainingMessage.length;
                    messageLength += remainingMessage.length;
                }
            }
            catch (Exception e2) {
                log.error((Object)("\u8bfb\u7aef\u53e3" + serialport.getPortName() + "\u5f02\u5e38\u3002\u3002\u3002"), (Throwable)e2);
            }
            completeMessage = new byte[messageLength];
            System.arraycopy(buffer, 0, completeMessage, 0, messageLength);
            if (!this.a(completeMessage)) continue;
            log.info((Object)("\u6536\u5230\u5b8c\u6574\u7684\u7f16\u7801\u4fe1\u606f\uff1a" + this.c(completeMessage)));
            return completeMessage;
        } while (++waitTimes < 10);
        log.error((Object)(this.c(completeMessage) + "\u4e22\u5931\u4e86\uff01"));
        completeMessage = null;
        return completeMessage;
    }

    private List<String> b(byte[] receiveBytes) {
        ArrayList<String> receiveMessageList = new ArrayList<String>();
        if (receiveBytes == null) {
            return receiveMessageList;
        }
        ArrayList<Integer> spilitIndexList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < receiveBytes.length; ++i2) {
            if (receiveBytes[i2] != -1 || i2 + 1 >= receiveBytes.length || receiveBytes[i2 + 1] != -1 || i2 + 2 >= receiveBytes.length || receiveBytes[i2 + 2] == -1) continue;
            spilitIndexList.add(i2);
        }
        int endIndex = receiveBytes.length;
        int minLength = 19;
        for (int i3 = 0; i3 < spilitIndexList.size(); ++i3) {
            byte[] receiveBytesSlip;
            StringBuffer buffer;
            String codingType;
            String decompressedStr;
            block10: {
                decompressedStr = "";
                codingType = "";
                buffer = new StringBuffer();
                int startIndex = (Integer)spilitIndexList.get(i3);
                endIndex = i3 + 1 < spilitIndexList.size() ? (Integer)spilitIndexList.get(i3 + 1) : receiveBytes.length;
                receiveBytesSlip = new byte[endIndex - startIndex];
                byte[] attachInfo = new byte[minLength];
                try {
                    System.arraycopy(receiveBytes, startIndex, receiveBytesSlip, 0, receiveBytesSlip.length);
                    if (endIndex - startIndex <= minLength) {
                        log.error((Object)("\u4fe1\u606f\u3010" + this.c(receiveBytesSlip) + "\u3011\u6709\u4e22\u5931(1)"));
                        continue;
                    }
                    System.arraycopy(receiveBytesSlip, 0, attachInfo, 0, attachInfo.length);
                    decompressedStr = LoRaDriver.decompressByteArray(attachInfo, 0, attachInfo.length).substring(4);
                    int effectiveLength = Integer.valueOf(decompressedStr.substring(0, 2), 16);
                    decompressedStr = decompressedStr.substring(2);
                    if (receiveBytesSlip.length - 3 != effectiveLength) {
                        log.error((Object)("\u4fe1\u606f\u3010" + this.c(receiveBytesSlip) + "\u3011\u6709\u4e22\u5931(2)"));
                        continue;
                    }
                    codingType = decompressedStr.substring(decompressedStr.length() - 2);
                    if (!(codingType.equals(ENCODING_IN_7BIT) || codingType.equals(ENCODING_IN_8BIT) || codingType.equals(ENCODING_IN_UFT8))) {
                        log.error((Object)("\u4fe1\u606f\u3010" + this.c(receiveBytesSlip) + "\u7684\u7f16\u7801\u683c\u5f0f\u4e0d\u660e\u3002\u3002\u3002"));
                    }
                    break block10;
                }
                catch (Exception e2) {
                    log.error((Object)("\u4fe1\u606f\u3010" + this.c(receiveBytesSlip) + "\u3011\u6709\u4e22\u5931(4)"), (Throwable)e2);
                }
                continue;
            }
            try {
                byte[] encryptText = new byte[receiveBytesSlip.length - minLength];
                System.arraycopy(receiveBytesSlip, minLength, encryptText, 0, encryptText.length);
                byte[] decryptText = des.decrypt(encryptText);
                String text = "";
                text = codingType.equals(ENCODING_IN_7BIT) ? PduUtils.decode7bitEncoding(decryptText) : (codingType.equals(ENCODING_IN_8BIT) ? PduUtils.decode8bitEncoding(null, decryptText) : new String(decryptText, "UTF-8"));
                buffer.append(decompressedStr);
                buffer.append(text);
            }
            catch (Exception e3) {
                log.error((Object)("\u4fe1\u606f\u3010" + this.c(receiveBytesSlip) + "\u3011\u89e3\u5bc6\u5931\u8d25"), (Throwable)e3);
                continue;
            }
            receiveMessageList.add(buffer.toString());
        }
        return receiveMessageList;
    }

    public boolean checkAuthorizeInfo(String usingPort, OutboundMessage msg) {
        String gatewayID = this.findDeviceByPortID(usingPort).getGatewayID();
        String serialNum = this.findDeviceByPortID(usingPort).getSerialNumber();
        try {
            boolean flag = this.findDeviceByPortID(usingPort).isValidate();
            if (!flag) {
                if (msg != null) {
                    msg.setText("<\u8bf7\u586b\u5199\u8bbe\u5907\u6ce8\u518c\u7801>" + msg.getText());
                }
                int num = NewAuth.getAvaliableNum(serialNum);
                log.info((Object)("\u8bbe\u5907\u672a\u6388\u6743\uff0c\u8fd8\u53ef\u6536\u53d1" + num + "\u6761\u77ed\u4fe1" + gatewayID));
                if (num < 1) {
                    log.warn((Object)("\u8bbe\u5907\u672a\u6388\u6743\uff0c\u6536\u53d1\u4fe1\u606f\u6761\u6570\u5df2\u8fbe\u5230\u6700\u5927\u9650\u5236\u657088\u6761,\u5df2\u505c\u6b62\u6536\u53d1\u4fe1\u606f" + gatewayID));
                    return false;
                }
            }
        }
        catch (Exception e2) {
            log.info((Object)("\u83b7\u53d6\u8bbe\u5907\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff1a" + gatewayID), (Throwable)e2);
            return false;
        }
        return true;
    }

    public void saveConfigInfo(LoraBean bean) throws ConfigurationException {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        Configuration config = JDSMSServer.getInstance().getProperties().subset("loraDevice");
        int count = 0;
        boolean flag = false;
        Iterator it = config.getKeys();
        while (it.hasNext()) {
            String v = config.getString((String)it.next());
            if (!v.startsWith(bean.getGatewayID())) continue;
            flag = true;
            break;
        }
        if (!flag) {
            while (count < 64) {
                if (JDSMSServer.getInstance().getProperties().getString("loraDevice." + count, "").length() == 0) {
                    props.setProperty("loraDevice." + count, (Object)(bean.getGatewayID() + ",LoRa"));
                    break;
                }
                ++count;
            }
        }
        props.setProperty(bean.getGatewayID() + ".port", (Object)bean.getPortID());
        props.setProperty(bean.getGatewayID() + ".baudrate", (Object)bean.getBaudrate());
        props.setProperty(bean.getGatewayID() + ".address", (Object)bean.getAddress());
        props.setProperty(bean.getGatewayID() + ".channel", (Object)bean.getChannel());
        props.setProperty(bean.getGatewayID() + ".type", (Object)bean.getDeviceType());
        props.setProperty(bean.getGatewayID() + ".serial_number", (Object)bean.getSerialNumber());
        props.setProperty(bean.getGatewayID() + ".using_status", (Object)bean.getUsingStatus());
        props.save();
    }

    public LoraBean findDeviceByPortID(String portID) {
        List<LoraBean> list = this.getAll();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!list.get(i2).getPortID().equals(portID)) continue;
            return list.get(i2);
        }
        return null;
    }

    public LoraBean findDeviceByGatewayID(String gatewayID) {
        List<LoraBean> list = this.getAll();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!list.get(i2).getGatewayID().equals(gatewayID)) continue;
            return list.get(i2);
        }
        return null;
    }

    public String getPortIDByLoop(OutboundMessage msg) {
        if (this.getUsingLoraList().isEmpty()) {
            return "";
        }
        String gatewayID = msg.getGatewayId();
        String recipient = msg.getRecipient();
        if (gatewayID == null || gatewayID.equals("")) {
            return "";
        }
        if (recipient == null || recipient.equals("")) {
            return "";
        }
        int loopTimes = 0;
        if ("@".equals(gatewayID)) {
            while (true) {
                ++loop;
                if (++loopTimes > this.a.size()) {
                    log.error((Object)"\u6ca1\u6709\u627e\u5230\u53ef\u7528\u7684\u7aef\u53e3");
                    return "";
                }
                if (loop < this.a.size()) {
                    if (!this.a.get(loop).getUsingStatus().equals("1") || this.a.get(loop).getAddress().equals(recipient)) continue;
                    return this.a.get(loop).getPortID();
                }
                loop = 0;
                if (this.a.get(loop).getUsingStatus().equals("1") && !this.a.get(loop).getAddress().equals(recipient)) break;
            }
            return this.a.get(loop).getPortID();
        }
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            LoraBean device = this.a.get(i2);
            if (device.getGatewayID().equals(gatewayID) && !device.getAddress().equals(recipient)) {
                return device.getPortID();
            }
            if (device.getAddress().equals(recipient)) {
                log.error((Object)("LoRa\u4e0d\u652f\u6301\u7ed9\u81ea\u8eab\u53d1\u9001\u4fe1\u606f\u3002\u3002\u3002" + msg.getGatewayId()));
                continue;
            }
            log.error((Object)("\u8bbe\u5907" + msg.getGatewayId() + "\u672a\u542f\u7528\u6216\u8005\u4e0d\u5b58\u5728\u3002\u3002\u3002"));
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readPortInHexStr(SerialPort serialport) throws SerialPortException {
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            if (serialport.isOpened()) {
                return serialport.readHexString();
            }
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readPortInByteArray(SerialPort serialport) throws SerialPortException {
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            if (serialport.isOpened()) {
                return serialport.readBytes();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writePort(SerialPort serialport, byte[] message) throws SerialPortException {
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            if (serialport.isOpened()) {
                return serialport.writeBytes(message);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readPortOutputBufferUsedSize(SerialPort serialport) throws SerialPortException {
        LoraBean serialLoraInfo = this.findDeviceByPortID(serialport.getPortName());
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            if ("0".equals(serialLoraInfo.getUsingStatus())) {
                return 0;
            }
            if (serialport.isOpened()) {
                return serialport.getOutputBufferBytesCount();
            }
            return -1;
        }
    }

    private String a(int messageID, int splitNumber, int serialNumber) {
        String messageIDStr = Integer.toHexString(messageID);
        messageIDStr = this.a(messageIDStr, 8);
        String splitNumberStr = Integer.toHexString(splitNumber);
        splitNumberStr = this.a(splitNumberStr, 2);
        String serialNumberStr = Integer.toHexString(serialNumber);
        serialNumberStr = this.a(serialNumberStr, 2);
        return messageIDStr + splitNumberStr + serialNumberStr;
    }

    private String a(String str, int length) {
        int strLength = str.length();
        if (strLength > length) {
            return str.substring(strLength - length);
        }
        if (strLength == length) {
            return str;
        }
        for (int i2 = 0; i2 < length - strLength; ++i2) {
            str = "0" + str;
        }
        return str;
    }

    public ArrayList<InboundMessage> getMessages(List<TmpMsg> tmpMsgList) {
        int minLength = 32;
        ArrayList<InboundMessage> msgList = new ArrayList<InboundMessage>();
        for (int i2 = 0; i2 < tmpMsgList.size(); ++i2) {
            TmpMsg tmpMsg = tmpMsgList.get(i2);
            String tmpMsgPduString = tmpMsg.getPdustring();
            if (tmpMsg.getMemindex() != 0 || Utils.isEmptyStr(tmpMsg.getMemlocation()) || !"LR".equals(tmpMsg.getMemlocation()) || tmpMsg.getMl() != 0) continue;
            if (tmpMsgPduString.length() <= minLength) {
                Utils.deleteTmpmsg(tmpMsg.getPdustring(), "LR");
                continue;
            }
            String attachInfo = tmpMsgList.get(i2).getPdustring().substring(0, minLength);
            if (!attachInfo.matches("[A-F,0-9]+")) {
                Utils.deleteTmpmsg(tmpMsg.getPdustring(), "LR");
                continue;
            }
            int startIndex = 0;
            int endIndex = startIndex + 8 + 4;
            String messageIdentification = tmpMsgPduString.substring(startIndex, endIndex);
            String messageIDStr = messageIdentification.substring(0, 8);
            String originator = tmpMsgPduString.substring(12, 16);
            String messageKey = messageIDStr + originator;
            String splitNumberStr = messageIdentification.substring(8, 10);
            String serialNumberStr = messageIdentification.substring(10);
            String sendDateStr = tmpMsgPduString.substring(16, 30);
            if (!messageIDWaitTimesMap.containsKey(messageKey)) {
                messageIDWaitTimesMap.put(messageKey, sendDateStr);
            }
            int serialNumber = -1;
            try {
                serialNumber = Integer.valueOf(serialNumberStr, 16);
            }
            catch (NumberFormatException e2) {
                log.error((Object)("\u6536\u5230\u7684\u4fe1\u606f\uff1a" + tmpMsgPduString), null);
                Utils.deleteTmpmsg(tmpMsg.getPdustring(), "LR");
                continue;
            }
            String text = tmpMsgPduString.substring(minLength);
            String sendDateStrAndSender = tmpMsgPduString.substring(12, 30);
            String codingType = tmpMsgPduString.substring(30, 32);
            text = sendDateStrAndSender + codingType + text;
            if (!messageIDMessageInfoMap.containsKey(messageKey)) {
                ArrayList<String> messageList = this.a(Integer.valueOf(splitNumberStr, 16));
                try {
                    messageList.set(serialNumber, text);
                }
                catch (Exception e3) {
                    log.error((Object)("\u4fe1\u606f\u7247\u6bb5\u4fdd\u5b58\u5931\u8d25\uff1a" + text));
                    log.error((Object)("\u4fe1\u5fc3\u7f16\u53f7\uff1a" + messageKey + ": " + serialNumber));
                }
                messageIDMessageInfoMap.put(messageKey, messageList);
            } else {
                try {
                    messageIDMessageInfoMap.get(messageKey).set(serialNumber, text);
                }
                catch (Exception e4) {
                    log.error((Object)("\u4fe1\u606f\u7247\u6bb5\u4fdd\u5b58\u5931\u8d25\uff1a" + text));
                    log.error((Object)("\u4fe1\u606f\u7f16\u53f7\uff1a" + messageKey + ": " + serialNumber));
                }
            }
            if (!messageIDExpectMessageNumMap.containsKey(messageKey)) {
                messageIDExpectMessageNumMap.put(messageKey, splitNumberStr);
            }
            if (!messageIDRealMessageNumMap.containsKey(messageKey)) {
                HashSet<String> serialNumberSet = new HashSet<String>();
                serialNumberSet.add(serialNumberStr);
                messageIDRealMessageNumMap.put(messageKey, serialNumberSet);
                continue;
            }
            messageIDRealMessageNumMap.get(messageKey).add(serialNumberStr);
        }
        for (Map.Entry<String, String> entry : messageIDExpectMessageNumMap.entrySet()) {
            String messageKey = entry.getKey();
            String splitNumberStr = entry.getValue();
            InboundMessage msg = new InboundMessage(messageKey);
            msg.setError(false);
            if (messageIDRealMessageNumMap.get(messageKey).size() != Integer.valueOf(splitNumberStr, 16).intValue()) {
                long hours;
                if (!messageIDWaitTimesMap.containsKey(messageKey)) continue;
                String sendDateStr = messageIDWaitTimesMap.get(messageKey);
                Date dispatchDate = new Date();
                try {
                    dispatchDate = dateFormat.parse(sendDateStr);
                }
                catch (ParseException e5) {
                    log.error((Object)"\u65e5\u671f\u4fe1\u606f\u683c\u5f0f\u5f02\u5e38..\u3002", (Throwable)e5);
                }
                Date now = new Date();
                int diffhours = 5;
                try {
                    diffhours = Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.recvdiff", "5"));
                }
                catch (Exception e6) {
                    log.error((Object)"\u3010settings.recvdiff\u3011\u8bbe\u5b9a\u5f02\u5e38\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c\uff1a5\uff08\u5c0f\u65f6\uff09\u3002");
                }
                if ((hours = (now.getTime() - dispatchDate.getTime()) / 3600000L) <= (long)diffhours) continue;
                msg.setError(true);
                msgList.add(msg);
                continue;
            }
            msgList.add(msg);
        }
        for (InboundMessage msg : msgList) {
            String messageKey = msg.getMessageID();
            this.a(messageIDMessageInfoMap.get(messageKey), msg);
        }
        this.a();
        return msgList;
    }

    private ArrayList<String> a(int length) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < length + 1; ++i2) {
            list.add("");
        }
        return list;
    }

    private void a(ArrayList<String> messageList, InboundMessage msg) {
        StringBuffer stringbuffer = new StringBuffer();
        String maxDateStr = "00000000000000";
        String originatorStr = "";
        String codingType = "";
        for (int i2 = 0; i2 < messageList.size(); ++i2) {
            if ("".equals(messageList.get(i2)) && i2 != 0) {
                stringbuffer.append(LOST_MESSAGE_FRAGMENT);
                continue;
            }
            if (("".equals(messageList.get(i2)) || null == messageList.get(i2)) && i2 == 0) continue;
            stringbuffer.append(messageList.get(i2).substring(20));
            String tempStr = messageList.get(i2).substring(4, 18);
            if (maxDateStr.compareTo(tempStr) < 0) {
                try {
                    dateFormat.parse(tempStr);
                    maxDateStr = tempStr;
                }
                catch (ParseException e2) {
                    log.error((Object)"\u65e5\u671f\u4fe1\u606f\u683c\u5f0f\u5f02\u5e381\u3002", (Throwable)e2);
                }
            }
            if (originatorStr.equals("")) {
                originatorStr = messageList.get(i2).substring(0, 4);
            }
            if (!codingType.equals("")) continue;
            int startIndex = 18;
            codingType = messageList.get(i2).substring(startIndex, startIndex + 2);
        }
        msg.setOriginator(originatorStr);
        Date dispatchDate = new Date();
        try {
            dispatchDate = dateFormat.parse(maxDateStr);
        }
        catch (ParseException e3) {
            log.error((Object)"\u65e5\u671f\u4fe1\u606f\u683c\u5f0f\u5f02\u5e382\u3002", (Throwable)e3);
        }
        msg.setEncoding(this.b(codingType));
        msg.setDate(dispatchDate);
        msg.setText(stringbuffer.toString());
        msg.setMessageID(msg.getMessageID().substring(0, 8));
        msg.setGatewayId(messageIDReceiveDeviceIDMap.get(msg.getMessageID()));
    }

    public HashMap<String, String> updateReceiveDeviceID(List<InboundMessage> msgList) {
        Iterator<InboundMessage> iter = msgList.iterator();
        int minLength = 32;
        while (iter.hasNext()) {
            InboundMessage msg = iter.next();
            if (msg.getText().length() <= minLength) {
                iter.remove();
                continue;
            }
            int startIndex = 0;
            int endIndex = startIndex + 8;
            String messageID = msg.getText().substring(startIndex, endIndex);
            if (!messageID.matches("[A-F,0-9]+")) {
                iter.remove();
                continue;
            }
            if (!messageIDReceiveDeviceIDMap.containsKey(messageID)) {
                messageIDReceiveDeviceIDMap.put(messageID, msg.getGatewayId());
                continue;
            }
            String receiveDeviceID = messageIDReceiveDeviceIDMap.get(messageID);
            if (receiveDeviceID != null && !receiveDeviceID.equals("")) continue;
            messageIDReceiveDeviceIDMap.put(messageID, msg.getGatewayId());
        }
        return messageIDReceiveDeviceIDMap;
    }

    public void initForLoRa() {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        String secretKey = props.getString("settings.secretkey", "");
        if (null == secretKey || "".equals(secretKey)) {
            secretKey = RandomStringUtils.randomAlphanumeric((int)12);
            props.setProperty("settings.secretkey", (Object)secretKey);
            try {
                props.save();
            }
            catch (ConfigurationException e2) {
                log.error((Object)"\u83b7\u53d6\u5bc6\u94a5\u5931\u8d25", (Throwable)e2);
            }
        }
        serialPortList = new ArrayList();
        Configuration config = props.subset("loraDevice");
        Iterator it = config.getKeys();
        boolean hasEmptySerialNumber = false;
        while (it.hasNext()) {
            String deviceIDKey = (String)it.next();
            String deviceID = config.getString(deviceIDKey);
            String port = props.getString(deviceID + ".port");
            int baudrate = props.getInt(deviceID + ".baudrate");
            String address = props.getString(deviceID + ".address");
            String channel = props.getString(deviceID + ".channel");
            String type = props.getString(deviceID + ".type");
            String serial_number = props.getString(deviceID + ".serial_number");
            if (serial_number == null || serial_number.trim().equals("")) {
                hasEmptySerialNumber = true;
            }
            String using_status = props.getString(deviceID + ".using_status");
            LoraBean loraInfo = new LoraBean();
            loraInfo.setGatewayID(deviceID);
            loraInfo.setPortID(port);
            loraInfo.setBaudrate(baudrate);
            loraInfo.setAddress(address);
            loraInfo.setChannel(channel);
            loraInfo.setDeviceType(type);
            loraInfo.setSerialNumber(serial_number);
            loraInfo.setUsingStatus(using_status);
            LoRaDriver.getInstance().addLora(loraInfo);
        }
        List<LoraBean> loraInfoList = this.getAll();
        ArrayList<String> serialNumberList = new ArrayList();
        if (hasEmptySerialNumber) {
            serialNumberList = this.getSerialNumberList();
        }
        for (LoraBean loraInfo : loraInfoList) {
            String serial_number = loraInfo.getSerialNumber();
            String port = loraInfo.getPortID();
            if (serial_number == null || serial_number.equals("")) {
                serial_number = this.getSerialNumber(port, serialNumberList);
                loraInfo.setSerialNumber(serial_number);
            }
            boolean flag = NewAuth.checkDeviceAuth(serial_number);
            loraInfo.setValidate(flag);
            if (flag) {
                try {
                    NewAuth.updateAuthorizeTemp();
                }
                catch (Exception e3) {
                    log.error((Object)"\u66f4\u65b0\u6388\u6743\u4fe1\u606f\u5f02\u5e38\u3002", (Throwable)e3);
                }
                cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u6388\u6743\u6709\u6548", null, loraInfo.getGatewayID());
            } else {
                try {
                    NewAuth.updateAuthorizeTemp();
                }
                catch (Exception e4) {
                    log.error((Object)"\u66f4\u65b0\u6388\u6743\u4fe1\u606f\u5f02\u5e38\u3002", (Throwable)e4);
                }
                cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u672a\u6388\u6743", null, loraInfo.getGatewayID());
            }
            SerialPort serialPort = new SerialPort(loraInfo.getPortID());
            try {
                if (!serialPort.isOpened()) {
                    serialPort.openPort();
                }
                serialPort.setFlowControlMode(0);
                serialPort.setParams(loraInfo.getBaudrate(), 8, 1, 0);
                serialPortList.add(serialPort);
                if (!loraInfo.getUsingStatus().equals("0")) continue;
                serialPort.closePort();
            }
            catch (SerialPortException e5) {
                log.error((Object)"\u4ece\u914d\u7f6e\u6587\u4ef6\u4e2d\u8bfb\u53d6\u7684\u8bbe\u5907\u521d\u59cb\u5316\u5931\u8d25\u3002\u3002\u3002", null);
                loraInfo.setUsingStatus("0");
            }
        }
    }

    private void a() {
        messageIDWaitTimesMap.clear();
        messageIDReceiveDeviceIDMap.clear();
        messageIDMessageInfoMap.clear();
        messageIDMessageInfoMap.clear();
        messageIDExpectMessageNumMap.clear();
        messageIDRealMessageNumMap.clear();
    }

    public boolean isWindowsOS() {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        String OStype = props.getString("settings.os_type", "");
        boolean isWindowsOS = false;
        if (OStype == null || OStype.equals("")) {
            String osName = System.getProperty("os.name");
            if (osName.toLowerCase().indexOf("windows") > -1) {
                isWindowsOS = true;
            }
        } else if (OStype.equals("WIN")) {
            isWindowsOS = true;
        }
        return isWindowsOS;
    }

    public String getAddressByPortID(String portID) {
        LoraBean serialLoraInfo = this.findDeviceByPortID(portID);
        if (serialLoraInfo != null) {
            return serialLoraInfo.getAddress();
        }
        return "";
    }

    public int getbaudrate(String portID) {
        LoraBean serialLoraInfo = this.findDeviceByPortID(portID);
        if (serialLoraInfo != null) {
            return serialLoraInfo.getBaudrate();
        }
        return 9600;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSerialNumberList() {
        ArrayList<String> serialNumberList = new ArrayList<String>();
        long startTime = System.currentTimeMillis();
        if (this.isWindowsOS()) {
            File cmdLine = FileUtils.getFile((String[])new String[]{System.getProperty("user.dir"), "bin", "FT_Prog-CmdLine.exe"});
            if (!cmdLine.exists()) {
                log.error((Object)(cmdLine.getAbsolutePath() + "\u4e0d\u5b58\u5728\uff01"));
                return serialNumberList;
            }
            Process process = null;
            try {
                process = Runtime.getRuntime().exec(cmdLine.getAbsolutePath() + " scan");
                process.waitFor();
                InputStream in = process.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                String tempStr = null;
                while ((tempStr = br.readLine()) != null) {
                    if (!(tempStr = tempStr.replaceAll("\\s", "")).startsWith("Device") || !(tempStr = tempStr.substring(tempStr.lastIndexOf(",") + 1)).startsWith(LORA_DEVICE_SERIAL_NUMBER)) continue;
                    serialNumberList.add(tempStr.substring(tempStr.lastIndexOf(",") + 1));
                }
            }
            catch (InterruptedException e2) {
                log.error((Object)"\u7b49\u5f85\u8fd4\u56de\u7ed3\u679c\u65f6\u88ab\u6253\u65ad\u3002");
                ArrayList<String> br = serialNumberList;
                return br;
            }
            catch (IOException e3) {
                log.error((Object)"\u53d6\u5f97\u8bbe\u5907\u5e8f\u5217\u53f7\u65f6\u51fa\u9519");
                ArrayList<String> br = serialNumberList;
                return br;
            }
            finally {
                if (process != null) {
                    process.destroy();
                }
            }
        }
        Process process = null;
        String[] command = new String[]{"/bin/sh", "-c", "lsusb -v|grep iSerial"};
        try {
            process = Runtime.getRuntime().exec(command);
            process.waitFor();
            InputStream in = process.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String tempStr = null;
            while ((tempStr = br.readLine()) != null) {
                tempStr = tempStr.replace("iSerial", "");
                if ((tempStr = tempStr.replaceAll("\\s", "")).length() == 1 || !tempStr.matches("[A-Z,0-9]+") || !(tempStr = tempStr.substring(1)).startsWith(LORA_DEVICE_SERIAL_NUMBER)) continue;
                serialNumberList.add(tempStr);
            }
        }
        catch (InterruptedException e4) {
            log.error((Object)"\u7b49\u5f85\u8fd4\u56de\u7ed3\u679c\u65f6\u88ab\u6253\u65ad\u3002");
            ArrayList<String> arrayList = serialNumberList;
            return arrayList;
        }
        catch (IOException e5) {
            log.error((Object)"\u53d6\u5f97\u8bbe\u5907\u5e8f\u5217\u53f7\u65f6\u51fa\u9519");
            ArrayList<String> arrayList = serialNumberList;
            return arrayList;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        long endTime = System.currentTimeMillis();
        log.info((Object)("\u83b7\u53d6\u8bbe\u5907\u5e8f\u5217\u53f7\u82b1\u8d39\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms"));
        return serialNumberList;
    }

    private static byte[] compressHexStr(String hexStr) {
        if (!hexStr.matches("[A-F,a-f,0-9]+")) {
            return null;
        }
        if (hexStr.length() % 2 != 0) {
            return null;
        }
        byte[] hexStrInByteArray = new byte[hexStr.length() / 2];
        int index = 0;
        for (int i2 = 0; i2 < hexStr.length(); i2 += 2) {
            hexStrInByteArray[index] = Integer.valueOf(hexStr.substring(i2, i2 + 2), 16).byteValue();
            ++index;
        }
        return hexStrInByteArray;
    }

    private static String decompressByteArray(byte[] byteArray, int startIndex, int endIndex) {
        StringBuffer buffer = new StringBuffer();
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            if (byteArray[i2] >= 0) {
                int high4thBit = (byteArray[i2] & 0xF0) >> 4;
                buffer.append(Integer.toHexString(high4thBit));
                int low4thBit = byteArray[i2] & 0xF;
                buffer.append(Integer.toHexString(low4thBit));
                continue;
            }
            int temp = byteArray[i2] + 128;
            int high4thBit = ((temp & 0xF0) >> 4) + 8;
            buffer.append(Integer.toHexString(high4thBit));
            int low4thBit = temp & 0xF;
            buffer.append(Integer.toHexString(low4thBit));
        }
        return buffer.toString().toUpperCase();
    }

    private String c(byte[] arrB) {
        if (arrB == null || arrB.length == 0) {
            return "";
        }
        int iLen = arrB.length;
        StringBuffer sb = new StringBuffer(iLen * 2);
        for (int i2 = 0; i2 < iLen; ++i2) {
            int intTmp;
            for (intTmp = arrB[i2]; intTmp < 0; intTmp += 256) {
            }
            if (intTmp < 16) {
                sb.append("0");
            }
            try {
                sb.append(Integer.toString(intTmp, 16));
                continue;
            }
            catch (Exception e2) {
                log.error((Object)"\u8f6c\u6362\u5931\u8d25\u3002\u3002", (Throwable)e2);
                sb.append("**");
            }
        }
        return sb.toString().toUpperCase();
    }

    @Override
    public boolean startDevice(String portID) {
        return false;
    }

    @Override
    public String getSignal(SerialPort serialPort) {
        return "";
    }

    @Override
    public String getSerialNumber(SerialPort serialPort) {
        return "";
    }

    @Override
    public boolean connectionOK(String portID) {
        SerialPort serialPort = this.getSerialPort(portID);
        return ModemDriver.readPortInputBufferUsedSize(serialPort) != -1;
    }
}

