/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.driver.nbiotDriver;

import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.otherModem.bean.BC26NbIoTBean;
import cn.sendsms.otherModem.bean.NbIoTBean;
import cn.sendsms.otherModem.common.Const;
import cn.sendsms.otherModem.common.Utils;
import cn.sendsms.otherModem.driver.ModemDriver;
import cn.sendsms.otherModem.driver.nbiotDriver.NbIoTDriver;
import cn.sendsms.otherModem.thread.WatchDog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jssc.SerialPort;
import jssc.SerialPortException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class BC26NbIoTDriver
extends NbIoTDriver {
    private static final BC26NbIoTDriver BC26_DRIVER = new BC26NbIoTDriver();

    public static final BC26NbIoTDriver getInstance() {
        return BC26_DRIVER;
    }

    @Override
    public String getSignal(SerialPort serialPort) {
        String signal = "99,99";
        boolean needToClose = false;
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        if (!serialPort.isOpened()) {
            log.info((Object)("\u6b63\u5728\u5c1d\u8bd5\u6253\u5f00\u7aef\u53e3:" + serialPort.getPortName()));
            if (Utils.openPort(device.getBaudrate(), serialPort)) {
                needToClose = true;
            } else {
                return signal;
            }
        }
        if (!BC26NbIoTDriver.execAtCommand(device, serialPort, "AT+CSQ\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return signal;
        }
        String regex = "[+]{0,1}CSQ: [0-9]+,[0-9]+OK";
        signal = ModemDriver.getStrResponse(serialPort, false, regex, "UTF-8");
        Pattern pattern = Pattern.compile("[+]{0,1}CSQ:[0-9]+,[0-9]+");
        Matcher matcher = pattern.matcher(signal.replaceAll("\\s+", ""));
        if (matcher.find()) {
            signal = matcher.group(0).replace("+CSQ:", "");
        }
        if (needToClose) {
            Utils.closePort(serialPort);
        }
        return signal;
    }

    @Override
    public String getSerialNumber(SerialPort serialPort) {
        String serialNumber = "";
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        if (!BC26NbIoTDriver.execAtCommand(device, serialPort, "AT+CGSN\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return serialNumber;
        }
        String regex = "[A-Z,0-9]+";
        serialNumber = ModemDriver.getStrResponse(serialPort, false, regex, "UTF-8");
        if ("ERROR".equals(serialNumber)) {
            log.error((Object)("\u8bbe\u5907\u5e8f\u5217\u53f7\u53d6\u5f97\u5931\u8d25" + serialNumber));
            return "";
        }
        serialNumber = Utils.deletePrefix(serialNumber, "AT+CGSN");
        serialNumber = Utils.deleteSuffix(serialNumber, "OK");
        for (int i2 = 0; i2 < Const.UNSOLICITED_RESPONSE_REGEX.size(); ++i2) {
            serialNumber = serialNumber.replaceAll(Const.UNSOLICITED_RESPONSE_REGEX.get(i2), "");
        }
        if (serialNumber.length() > 17 && serialNumber.endsWith("OK")) {
            serialNumber = serialNumber.substring(0, serialNumber.length() - 2);
        }
        return serialNumber;
    }

    @Override
    public String getCommunicationID(String serialNumber) {
        String communicationID = "";
        if (serialNumber == null || serialNumber.equals("")) {
            return communicationID;
        }
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        String pointedOrignStr = props.getString("random_number_seed", "");
        if (pointedOrignStr != null && !"".equals(pointedOrignStr) && pointedOrignStr.length() >= 10 && pointedOrignStr.matches("[0-9a-zA-Z]+")) {
            serialNumber = pointedOrignStr;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(serialNumber.getBytes("UTF-8"));
            byte[] b2 = md.digest();
            communicationID = new BigInteger(1, b2).toString(16).substring(8, 16).toUpperCase();
        }
        catch (Exception e2) {
            log.error((Object)"\u83b7\u53d6\u901a\u4fe1ID\u5931\u8d25\u3002\u3002\u3002", (Throwable)e2);
            communicationID = "";
        }
        return communicationID;
    }

    @Override
    public boolean networkNormal(SerialPort serialPort) {
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        if (!BC26NbIoTDriver.execAtCommand(device, serialPort, "AT+CEREG?\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        String regex = "[+]{0,1}CEREG:[\\s]*[0-9]+,[0-9]+OK";
        String response = ModemDriver.getStrResponse(serialPort, false, regex, "UTF-8");
        Pattern pattern = Pattern.compile("[+]{0,1}CEREG:[\\s]*0,1");
        Matcher matcher = pattern.matcher(response);
        if (matcher.find()) {
            log.info((Object)(serialPort.getPortName() + "\u7f51\u7edc\u6b63\u5e38\u3002\u3002\u3002"));
            return true;
        }
        log.info((Object)(response + "\u5f53\u524d\u7f51\u7edc\u72b6\u6001\uff1a" + response));
        return false;
    }

    @Override
    public boolean isCompleteMessages(byte[] messageByteArray, NbIoTBean device, List<String> messageList, List<String> incompleteMessageList) {
        String messages = Utils.getString(messageByteArray);
        String decodedContext = "";
        List<String> formattedMessageList = this.a(messages, device);
        if (formattedMessageList == null || formattedMessageList.size() == 0) {
            return false;
        }
        String messageRegex = "(\\+QMT){0,1}RECV: [0-9]+,[0-9]+,\"" + device.getCommunicationID() + "\",\"[\\s\\S]+\"$";
        String illegalMessageRegex = "(\\+QMT){0,1}RECV:,[0-9]+[\\s]*";
        for (int i2 = 0; i2 < formattedMessageList.size(); ++i2) {
            String message = formattedMessageList.get(i2);
            if (message.matches(messageRegex)) {
                String context = message.replaceFirst("(\\+QMT){0,1}RECV: [0-9]+,[0-9]+,\"" + device.getCommunicationID() + "\",", "");
                int sentContextLength = 0;
                if (Utils.isEmptyStr(context)) {
                    log.info((Object)("\u4fe1\u606f\u5185\u5bb9\u5f02\u5e38\uff1a" + message));
                    continue;
                }
                if (context.startsWith("\"")) {
                    context = context.substring(1);
                }
                if (context.endsWith("\"")) {
                    context = context.substring(0, context.length() - 1);
                }
                if (Utils.isEmptyStr(context)) {
                    log.info((Object)("\u4fe1\u606f\u5185\u5bb9\u5f02\u5e38\uff1a" + message));
                    continue;
                }
                if (context.length() <= 38) {
                    log.info((Object)("\u4fe1\u606f\u5185\u5bb9\u5f02\u5e38\uff1a" + message));
                    continue;
                }
                String sentContextLengthStr = context.substring(35, 38);
                try {
                    sentContextLength = Integer.valueOf(sentContextLengthStr, 16);
                }
                catch (NumberFormatException e2) {
                    log.info((Object)("\u4fe1\u606f\u5185\u5bb9\u5f02\u5e38\uff1a" + message));
                    continue;
                }
                decodedContext = context;
                String codingType = context.substring(34, 35);
                if ("U".equals(codingType)) {
                    String attachInfo = context.substring(0, 38);
                    String encodedText = context.substring(38);
                    try {
                        decodedContext = attachInfo + Utils.getString(Utils.hexStr2ByteArr(encodedText));
                    }
                    catch (Exception e3) {
                        log.info((Object)("\u4fe1\u606f\u5185\u5bb9\u5f02\u5e38\uff1a" + message));
                        continue;
                    }
                }
                if ("S".equals(codingType)) {
                    log.info((Object)"Quectel_BC26\u4e0d\u652f\u6301\u652f\u6301\u53d1\u9001\u4e2d\u6587\u4fe1\u606f");
                    continue;
                }
                int receivedContextLength = Utils.getByteArray(context.substring(38)).length;
                if (sentContextLength <= receivedContextLength) {
                    messageList.add(decodedContext);
                    continue;
                }
                log.info((Object)("\u4fe1\u606f\u5185\u5bb9\u5f02\u5e38\uff1a" + message));
                continue;
            }
            if (message.matches(illegalMessageRegex)) {
                log.info((Object)("\u4fe1\u606f\u5185\u5bb9\u5f02\u5e38\uff1a" + message));
                continue;
            }
            incompleteMessageList.add(message);
            return false;
        }
        return true;
    }

    private List<String> a(String messages, NbIoTBean device) {
        String formatedMessage = "";
        StringReader stringReader = new StringReader(messages);
        BufferedReader reader = new BufferedReader(stringReader);
        String openConn = "(\\+QMT){0,1}OPEN: [0-9]+,[0-9]+";
        String connectionRegex = "(\\+QMT){0,1}STAT: [0-9]+,[0-9]+";
        String connectSucess1 = "(\\+QMT){0,1}CONN: [0-9]+,[0-9]+,[0-9]+";
        String connectSucess2 = "(\\+QMT){0,1}CONN: [0-9]+,[0-9]+";
        String subSucess1 = "(\\+QMT){0,1}SUB: [0-9]+,[0-9]+,[0-9]+,[0-9]+";
        String subSucess2 = "(\\+QMT){0,1}SUB: [0-9]+,[0-9]+,[0-9]+";
        String pubSucess1 = "(\\+QMT){0,1}PUB: [0-9]+,[0-9]+,[0-9]";
        String pubSucess2 = "(\\+QMT){0,1}PUB: [0-9]+,[0-9]+,[0-9]";
        String closeNetwork1 = "(\\+QMT){0,1}CLOSE: [0-9]+,[0-9]";
        String closeNetwork2 = "AT(\\+QMT){0,1}CLOSE: [0-9]+,[0-9]";
        String closeNetwork3 = "AT(\\+QMT){0,1}CLOSE=[0-9]+";
        String cpinNotReady = "[+]{0,1}CPIN: NOT READY";
        String cpinReady = "[+]{0,1}CPIN: READY";
        String ip = "[+]{0,1}IP: [0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+";
        String exceptionRegex1 = "[\\s]*------------- Exception called -------------[\\s]*";
        String exceptionRegex2 = "[\\s]*assert failed: pxQueue[\\s]*";
        String exceptionRegex3 = "[\\s]*file: ../../../../../kernel/rtos/FreeRTOS/Source/queue.c[\\s]*";
        String exceptionRegex4 = "[\\s]*line: 1741[\\s]*";
        String exceptionRegex5 = "[\\s]*genie connected: No[\\s]";
        String exceptionRegex6 = "[\\s]*auto-reboot: Yes[\\s]*";
        String exceptionRegex7 = "(Rb[\\S\\s]+B[\\S\\s]+)+";
        boolean bNeedRestart = false;
        while (true) {
            String line = null;
            try {
                line = reader.readLine();
            }
            catch (IOException e2) {
                log.error((Object)"\u4fe1\u606f\u89e3\u6790\u5931\u8d25\u3002\u3002\u3002", (Throwable)e2);
            }
            if (line == null) break;
            if (line.trim().equals("") || line.replace("\r", "").replace("\n", "").equals("OK")) continue;
            if (line.startsWith("OK")) {
                formatedMessage = formatedMessage + line.substring(2);
                continue;
            }
            if (line.replace("\r", "").replace("\n", "").equals("ERROR") || line.replace("\r", "").replace("\n", "").matches(connectSucess1) || line.replace("\r", "").replace("\n", "").matches(connectSucess2)) continue;
            if (line.replace("\r", "").replace("\n", "").matches(connectionRegex)) {
                bNeedRestart = true;
                continue;
            }
            if (line.replace("\r", "").replace("\n", "").matches(exceptionRegex1) || line.replace("\r", "").replace("\n", "").matches(exceptionRegex2) || line.replace("\r", "").replace("\n", "").matches(exceptionRegex3) || line.replace("\r", "").replace("\n", "").matches(exceptionRegex4) || line.replace("\r", "").replace("\n", "").matches(exceptionRegex5) || line.replace("\r", "").replace("\n", "").matches(exceptionRegex6) || line.replace("\r", "").replace("\n", "").matches(exceptionRegex7)) {
                bNeedRestart = true;
                continue;
            }
            if (line.replace("\r", "").replace("\n", "").matches(subSucess1) || line.replace("\r", "").replace("\n", "").matches(subSucess2) || line.replace("\r", "").replace("\n", "").matches(pubSucess1) || line.replace("\r", "").replace("\n", "").matches(pubSucess2) || line.replace("\r", "").replace("\n", "").matches(closeNetwork1) || line.replace("\r", "").replace("\n", "").matches(closeNetwork2) || line.replace("\r", "").replace("\n", "").matches(closeNetwork3) || line.replace("\r", "").replace("\n", "").matches(cpinNotReady) || line.replace("\r", "").replace("\n", "").matches(cpinReady) || line.replace("\r", "").replace("\n", "").matches(ip) || line.replace("\r", "").replace("\n", "").matches(openConn)) continue;
            String lineBefore = line;
            line = line.replaceAll(exceptionRegex7, "");
            formatedMessage = formatedMessage + line;
            if (lineBefore.equals(line)) continue;
            log.error((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u6536\u5230\u5f02\u5e38\u4fe1\u606f\uff1a" + lineBefore));
            bNeedRestart = true;
        }
        if (bNeedRestart) {
            this.a(device.getPortID());
        }
        try {
            reader.close();
            stringReader.close();
        }
        catch (IOException e3) {
            log.error((Object)"\u6570\u636e\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e3);
        }
        String[] messageArray = formatedMessage.split("(\\+QMT){0,1}RECV:");
        ArrayList<String> messageList = new ArrayList<String>();
        for (int i2 = 0; i2 < messageArray.length; ++i2) {
            if (messageArray[i2] == null || messageArray[i2].length() == 0) continue;
            messageList.add("+QMTRECV:" + messageArray[i2]);
        }
        if (formatedMessage.endsWith("RECV:")) {
            messageList.add("+QMTRECV:");
        }
        return messageList;
    }

    private void a(String portID) {
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(portID);
        if (device != null) {
            log.error((Object)"\u8bbe\u5907\u8fde\u63a5\u5f02\u5e38\uff0c\u5373\u5c06\u91cd\u542f\uff01\u3010BC26-prepareRestartDevice\u3011");
            device.setUsingStatus("2");
            log.info((Object)(device.getGatewayID() + "\u5373\u5c06\u91cd\u542f\u3002\u3002\u3002"));
            WatchDog.getInstance().interrupt();
        }
    }

    @Override
    public boolean initDevice(SerialPort serialPort) {
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        if (!BC26NbIoTDriver.execAtCommand(device, serialPort, "AT+QRST=1\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException e2) {
            log.info((Object)"\u8bbe\u5907\u521d\u59cb\u5316\u7b49\u5f85\u88ab\u6253\u65ad(1)");
        }
        String response = ModemDriver.getStrResponse(serialPort, false, "", "UTF-8");
        int waitTimes = 0;
        while (BC26NbIoTDriver.serialportConnected(serialPort)) {
            ++waitTimes;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e3) {
                log.info((Object)"\u8bbe\u5907\u521d\u59cb\u5316\u7b49\u5f85\u88ab\u6253\u65ad(2)");
            }
            if ((!(response = response + ModemDriver.getStrResponse(serialPort, false, "", "UTF-8")).startsWith("AT+QRST=?") || response.length() != 31) && response.startsWith("AT+QRST=?") && response.length() == 22 && waitTimes <= 30) continue;
        }
        if (!Utils.isEmptyStr(response)) {
            this.commandNotEcho(serialPort);
            return true;
        }
        log.info((Object)("\u8bbe\u5907\u521d\u59cb\u5316\u5f02\u5e38\u3002\u3002\u3002" + response));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendMessage(String recipient, String text, NbIoTBean device) {
        BC26NbIoTBean nbiotDevice = (BC26NbIoTBean)device;
        if (!"Quectel_BC26".equals(nbiotDevice.getDeviceType())) {
            log.error((Object)(nbiotDevice.getGatewayID() + "\u8bbf\u95ee\u5f02\u5e38\u3002\u3002"));
            return false;
        }
        if ("0".equals(nbiotDevice.getUsingStatus())) {
            log.info((Object)(nbiotDevice.getGatewayID() + "\u5df2\u7ecf\u505c\u6b62\u3002\u3002"));
            return false;
        }
        if ("2".equals(nbiotDevice.getUsingStatus())) {
            log.info((Object)(nbiotDevice.getGatewayID() + "\u6b63\u5728\u91cd\u542f\u3002\u3002"));
            return false;
        }
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        String usingPort = nbiotDevice.getPortID();
        boolean publishSucess = false;
        SerialPort serialport = nbiotDeviceInfoGetter.getSerialPort(usingPort);
        int mqttQos = props.getInt("settings.mqtt_qos", 1);
        int messageID = nbiotDevice.getMessageID();
        if (mqttQos == 0) {
            messageID = 0;
        }
        String sendMessagecmd = "AT+QMTPUB=" + nbiotDevice.getTcpConnectID() + "," + messageID + "," + mqttQos + ",0,\"" + recipient + "\",\"" + text + "\"\r";
        String publishSucessRegex = "OK[\\s\\S]*(\\+QMT){0,1}PUB: " + nbiotDevice.getTcpConnectID() + "," + messageID + ",0";
        Pattern publishSucessPattern = Pattern.compile(publishSucessRegex);
        String connectionRegex = "(\\+QMT){0,1}STAT: [0-9]+,[0-9]+";
        String exceptionRegex = "[\\s]*------------- Exception called -------------[\\s]*[\\s]*assert failed: pxQueue[\\s]*[\\s]file: ../../../../../kernel/rtos/FreeRTOS/Source/queue.c[\\s]*[\\s]line: 1741[\\s]*[\\s]genie connected: No[\\s]*[\\s]auto-reboot: Yes[\\s]*";
        Pattern connectionPattern = Pattern.compile(connectionRegex);
        Pattern exceptionPattern = Pattern.compile(exceptionRegex);
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            if (!BC26NbIoTDriver.execAtCommand(nbiotDevice, serialport, sendMessagecmd, "UTF-8")) {
                log.error((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
                return false;
            }
            byte[] responseByteArray = ModemDriver.getBytesResponse(serialport, "UTF-8");
            int loop = 0;
            while (BC26NbIoTDriver.serialportConnected(serialport)) {
                String response = Utils.getString(responseByteArray);
                if (response.replace("\r", "").replace("\n", "").equals("ERROR")) {
                    log.info((Object)("\u8bbe\u5907" + nbiotDevice.getGatewayID() + "\u4fe1\u606f\u53d1\u9001\u5931\u8d25.\u8fd4\u56de\u503c\uff1a" + response));
                    return false;
                }
                Matcher publishSucessMatcher = publishSucessPattern.matcher(response.replace("\r", "").replace("\n", ""));
                if (publishSucessMatcher.find()) {
                    publishSucess = true;
                    break;
                }
                Matcher connectionMatcher = connectionPattern.matcher(response.replace("\r", "").replace("\n", ""));
                Matcher exceptionMatcher = exceptionPattern.matcher(response.replace("\r", "").replace("\n", ""));
                if (connectionMatcher.find() || exceptionMatcher.find()) {
                    this.a(serialport.getPortName());
                    break;
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e2) {
                    log.error((Object)"\u7b49\u5f85\u53d1\u9001\u4fe1\u606f\u547d\u4ee4\u7684\u8fd4\u56de\u7ed3\u679c\u65f6\u88ab\u6253\u65ad\u3002\u3002\u3002");
                }
                byte[] tmpResponseByteArray = ModemDriver.getBytesResponse(serialport, "UTF-8");
                responseByteArray = Utils.mergeByteArray(tmpResponseByteArray, responseByteArray);
                if (++loop < 300) continue;
                break;
            }
            this.getCompleteMessages(responseByteArray, serialport, nbiotDevice, "\u53d1\u4fe1\u7ebf\u7a0b");
            if ("2".equals(nbiotDevice.getUsingStatus())) {
                log.info((Object)("\u7531\u4e8e\u8bbe\u5907\u53d1\u751f\u4e86\u91cd\u542f\uff0c" + text + "\u8981\u91cd\u65b0\u53d1\u9001\uff01"));
                publishSucess = false;
            }
            return publishSucess;
        }
    }

    @Override
    public void commandNotEcho(SerialPort serialPort) {
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        if (!BC26NbIoTDriver.execAtCommand(device, serialPort, "ATE0\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return;
        }
        String regex = "[\\s\\S]*OK";
        String commandNotEcho = ModemDriver.getStrResponse(serialPort, false, regex, "UTF-8");
        if (commandNotEcho.contains("OK")) {
            log.info((Object)"\u5173\u95ed\u547d\u4ee4\u56de\u663e\u6210\u529f");
        } else {
            log.error((Object)"\u5173\u95ed\u547d\u4ee4\u56de\u663e\u5931\u8d25");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean subSucessed(String portID) {
        SerialPort serialport = nbiotDeviceInfoGetter.getSerialPort(portID);
        BC26NbIoTBean device = (BC26NbIoTBean)nbiotDeviceInfoGetter.findDeviceByPortID(portID);
        if (!"Quectel_BC26".equals(device.getDeviceType())) {
            log.error((Object)(device.getGatewayID() + "\u8bbf\u95ee\u5f02\u5e38\u3002\u3002"));
            return false;
        }
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        int mqttQos = props.getInt("settings.mqtt_qos", 1);
        String subSucessRegex = "OK[\\s\\S]*(\\+QMT){0,1}SUB: [0-9]+,[0-9]+,0," + mqttQos;
        String subFailedRegex = "OK[\\s\\S]*(\\+QMT){0,1}SUB: [0-9]+,[0-9]+,[1-2]+";
        String exceptionRegex = "[\\s]*------------- Exception called -------------[\\s]*";
        String connectionRegex = "(\\+QMT){0,1}STAT: [0-9]+,[0-9]+";
        String messageRegex = "(\\+QMT){0,1}RECV: [0-9]+,[0-9]+,\"" + device.getCommunicationID() + "\",\"[\\s\\S]+\"$";
        Pattern subSucessPattern = Pattern.compile(subSucessRegex);
        Pattern subFailedPattern = Pattern.compile(subFailedRegex);
        Pattern exceptionPattern = Pattern.compile(exceptionRegex);
        Pattern connectionPattern = Pattern.compile(connectionRegex);
        Pattern messagePattern = Pattern.compile(messageRegex);
        Matcher subSucessMatcher = null;
        Matcher subFailedMatcher = null;
        Matcher exceptionMatcher = null;
        Matcher connectionMatcher = null;
        Matcher messageMatcher = null;
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            String subscribeTopic = "AT+QMTSUB=" + device.getTcpConnectID() + "," + device.getMessageID() + ",\"" + device.getCommunicationID() + "\"," + mqttQos + "\r";
            if (!BC26NbIoTDriver.execAtCommand(device, serialport, subscribeTopic, "UTF-8")) {
                log.error((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
                return false;
            }
            byte[] responseByteArray = ModemDriver.getBytesResponse(serialport, "UTF-8");
            int loop = 0;
            String response = "";
            while (BC26NbIoTDriver.serialportConnected(serialport)) {
                response = Utils.getString(responseByteArray);
                if (response.replace("\r", "").replace("\n", "").equals("ERROR")) {
                    return false;
                }
                subSucessMatcher = subSucessPattern.matcher(response.replace("\r", "").replace("\n", ""));
                subFailedMatcher = subFailedPattern.matcher(response.replace("\r", "").replace("\n", ""));
                exceptionMatcher = exceptionPattern.matcher(response.replace("\r", "").replace("\n", ""));
                connectionMatcher = connectionPattern.matcher(response.replace("\r", "").replace("\n", ""));
                messageMatcher = messagePattern.matcher(response.replace("\r", "").replace("\n", ""));
                if (subSucessMatcher.find() || subFailedMatcher.find() || exceptionMatcher.find() || connectionMatcher.find() || messageMatcher.find()) break;
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e2) {
                    log.error((Object)"\u7b49\u5f85MQTT\u670d\u52a1\u5668\u8ba2\u9605\u662f\u5426\u6210\u529f\u7684\u53cd\u9988\u4fe1\u606f\u65f6\u88ab\u6253\u65ad\u3002\u3002\u3002");
                }
                byte[] tmpResponseByteArray = ModemDriver.getBytesResponse(serialport, "UTF-8");
                responseByteArray = Utils.mergeByteArray(tmpResponseByteArray, responseByteArray);
                if (++loop < 300) continue;
                break;
            }
            if (response == null || response.equals("")) {
                return false;
            }
            this.getCompleteMessages(responseByteArray, serialport, device, "\u8ba2\u9605\u4e3b\u9898");
            subSucessMatcher.reset();
            messageMatcher.reset();
            subFailedMatcher.reset();
            exceptionMatcher.reset();
            connectionMatcher.reset();
            if (subFailedMatcher.find() || exceptionMatcher.find() || connectionMatcher.find()) {
                log.error((Object)"\u8ba2\u9605\u4e3b\u9898\u5931\u8d25");
                log.error((Object)(serialport.getPortName() + "\u8fd4\u56de\uff1a" + response));
                return false;
            }
            if (subSucessMatcher.find() || messageMatcher.find()) {
                log.info((Object)"\u8ba2\u9605\u4e3b\u9898\u6210\u529f");
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connectSucessed(String portID) {
        SerialPort serialport = nbiotDeviceInfoGetter.getSerialPort(portID);
        BC26NbIoTBean device = (BC26NbIoTBean)nbiotDeviceInfoGetter.findDeviceByPortID(portID);
        if (!"Quectel_BC26".equals(device.getDeviceType())) {
            log.error((Object)(device.getGatewayID() + "\u8bbf\u95ee\u5f02\u5e38\u3002\u3002"));
            return false;
        }
        if (!this.a(serialport, device)) {
            return false;
        }
        if (!this.b(serialport, device)) {
            return false;
        }
        if (!this.c(serialport, device)) {
            return false;
        }
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        String mqttUser = props.getString("settings.mqtt_user", "0000");
        String mqttPassword = props.getString("settings.mqtt_password", "0000");
        String connectMQTTServerCCCmd = "AT+QMTCONN=" + device.getTcpConnectID() + ",\"" + device.getCommunicationID() + "\"," + mqttUser + "," + mqttPassword + "\r";
        String connSucessRegex = "OK[\\s\\S]*(\\+QMT){0,1}CONN: " + device.getTcpConnectID() + ",0,0";
        String messageRegex = "(\\+QMT){0,1}RECV: [0-9]+,[0-9]+,\"" + device.getCommunicationID() + "\",\"[\\s\\S]+\"$";
        Pattern connSucessPattern = Pattern.compile(connSucessRegex);
        Pattern messagePattern = Pattern.compile(messageRegex);
        Matcher connSucessMatcher = null;
        Matcher messageMatcher = null;
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            if (!BC26NbIoTDriver.execAtCommand(device, serialport, connectMQTTServerCCCmd, "UTF-8")) {
                log.error((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
                return false;
            }
            byte[] responseByteArray = ModemDriver.getBytesResponse(serialport, "UTF-8");
            int loop = 0;
            String response = "";
            while (BC26NbIoTDriver.serialportConnected(serialport)) {
                response = Utils.getString(responseByteArray);
                if (response.replace("\r", "").replace("\n", "").matches(connSucessRegex)) {
                    return true;
                }
                if (response.replace("\r", "").replace("\n", "").equals("ERROR")) {
                    return false;
                }
                connSucessMatcher = connSucessPattern.matcher(response.replace("\r", "").replace("\n", ""));
                messageMatcher = messagePattern.matcher(response.replace("\r", "").replace("\n", ""));
                if (connSucessMatcher.find() || messageMatcher.find()) break;
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e2) {
                    log.error((Object)"\u7b49\u5f85MQTT\u670d\u52a1\u5668\u8fde\u63a5\u662f\u5426\u6210\u529f\u7684\u53cd\u9988\u4fe1\u606f\u65f6\u88ab\u6253\u65ad\u3002\u3002\u3002");
                }
                byte[] tmpResponseByteArray = ModemDriver.getBytesResponse(serialport, "UTF-8");
                responseByteArray = Utils.mergeByteArray(tmpResponseByteArray, responseByteArray);
                if (++loop < 150) continue;
                break;
            }
            if (response == null || response.equals("")) {
                return false;
            }
            this.getCompleteMessages(responseByteArray, serialport, device, "\u8fde\u63a5MQTT\u670d\u52a1\u5668");
            connSucessMatcher.reset();
            messageMatcher.reset();
            boolean connSucess = connSucessMatcher.find();
            boolean receivedMessage = messageMatcher.find();
            if (connSucess || receivedMessage) {
                if (receivedMessage) {
                    device.setUsingStatus("1");
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(SerialPort serialport, BC26NbIoTBean device) {
        String setConfigCmd = "AT+QMTCFG=\"SESSION\"," + device.getTcpConnectID() + ",0\r";
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            if (!BC26NbIoTDriver.execAtCommand(device, serialport, setConfigCmd, "UTF-8")) {
                log.error((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
                return false;
            }
            String response = ModemDriver.getStrResponse(serialport, false, "OK", "UTF-8");
            if ("OK".equals(response)) {
                log.info((Object)(device.getGatewayID() + "\u8fde\u63a5\u53c2\u6570\u3010Session\u3011\u8bbe\u5b9a\u6210\u529f\u3002"));
                return true;
            }
            log.error((Object)(device.getGatewayID() + "\u8fde\u63a5\u53c2\u6570\u3010Session\u3011\u8bbe\u5b9a\u5931\u8d25\uff1a" + response));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean b(SerialPort serialport, BC26NbIoTBean device) {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        int keepAlive = props.getInt("settings.mqtt_keepalive", 10);
        String setConfigCmd = "AT+QMTCFG=\"KEEPALIVE\"," + device.getTcpConnectID() + "," + keepAlive + "\r";
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            if (!BC26NbIoTDriver.execAtCommand(device, serialport, setConfigCmd, "UTF-8")) {
                log.error((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
                return false;
            }
            String response = ModemDriver.getStrResponse(serialport, false, "OK", "UTF-8");
            if ("OK".equals(response)) {
                log.info((Object)(device.getGatewayID() + "\u8fde\u63a5\u53c2\u6570\u3010KeepAlive\u3011\u8bbe\u5b9a\u6210\u529f\u3002"));
                return true;
            }
            log.error((Object)(device.getGatewayID() + "\u8fde\u63a5\u53c2\u6570\u3010KeepAlive\u3011\u8bbe\u5b9a\u5931\u8d25\uff1a" + response));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean c(SerialPort serialport, BC26NbIoTBean device) {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        String mqttServer = props.getString("settings.mqtt_server", "119.90.56.92");
        String mqttPort = props.getString("settings.mqtt_port", "1883");
        String openConectionSucessRegex = "OK[\\s\\S]*(\\+QMT){0,1}OPEN: " + device.getTcpConnectID() + ",0";
        String setConfigCmd = "AT+QMTOPEN=" + device.getTcpConnectID() + ",\"" + mqttServer + "\"," + mqttPort + "\r";
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            if (!BC26NbIoTDriver.execAtCommand(device, serialport, setConfigCmd, "UTF-8")) {
                log.error((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
                return false;
            }
            String response = ModemDriver.getStrResponse(serialport, false, openConectionSucessRegex, "UTF-8");
            if (response.matches(openConectionSucessRegex)) {
                log.info((Object)(device.getGatewayID() + "\u6253\u5f00\u8fde\u63a5\u6210\u529f\u3002"));
                return true;
            }
            log.error((Object)(device.getGatewayID() + "\u6253\u5f00\u8fde\u63a5\u5931\u8d25\u5931\u8d25\uff1a" + response));
            return false;
        }
    }

    @Override
    public void disconnectMQTTServer(SerialPort serialport) {
        BC26NbIoTBean BC26device = nbiotDeviceInfoGetter.findBC26NbIoTBeanByPortID(serialport.getPortName());
        String tcpConnectID = BC26device.getTcpConnectID() + "";
        String closeNetworkCmd = "AT+QMTCLOSE=" + tcpConnectID + "\r";
        if (!BC26NbIoTDriver.execAtCommand(BC26device, serialport, closeNetworkCmd, "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return;
        }
        String expectResult1 = "(\\+QMT){0,1}CLOSE: [0-9]+,0";
        Pattern pattern1 = Pattern.compile(expectResult1);
        Matcher matcher1 = null;
        byte[] responseByteArray = ModemDriver.getBytesResponse(serialport, "UTF-8");
        int loop = 0;
        String response = "";
        while (BC26NbIoTDriver.serialportConnected(serialport)) {
            response = Utils.getString(responseByteArray);
            if (response.replace("\r", "").replace("\n", "").matches(expectResult1)) {
                log.info((Object)(BC26device.getGatewayID() + "\u7f51\u7edc\u5173\u95ed\u6210\u529f(1)"));
                break;
            }
            if (response.replace("\r", "").replace("\n", "").equals("ERROR")) {
                log.info((Object)(BC26device.getGatewayID() + "\u7f51\u7edc\u5173\u95ed\u5931\u8d25(1)\u3002"));
                break;
            }
            matcher1 = pattern1.matcher(response.replace("\r", "").replace("\n", ""));
            if (matcher1.find()) break;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e2) {
                log.error((Object)"\u7b49\u5f85MQTT\u670d\u52a1\u5668\u8fde\u63a5\u662f\u5426\u6210\u529f\u7684\u53cd\u9988\u4fe1\u606f\u65f6\u88ab\u6253\u65ad\u3002\u3002\u3002");
            }
            byte[] tmpResponseByteArray = ModemDriver.getBytesResponse(serialport, "UTF-8");
            responseByteArray = Utils.mergeByteArray(tmpResponseByteArray, responseByteArray);
            if (++loop < 150) continue;
            break;
        }
        if (response == null || response.equals("")) {
            log.info((Object)(BC26device.getGatewayID() + "\u7f51\u7edc\u5173\u95ed\u5931\u8d25(2)"));
        }
        this.getCompleteMessages(responseByteArray, serialport, BC26device, "\u65ad\u5f00MQTT\u670d\u52a1\u5668\u8fde\u63a5");
    }

    @Override
    public boolean connectionOK(String portID) {
        log.info((Object)("\u8bbe\u5907" + nbiotDeviceInfoGetter.findDeviceByPortID(portID).getGatewayID() + "\u662f" + "Quectel_BC26" + "\u8bbe\u5907\uff0c\u8df3\u8fc7\u68c0\u6d4b\u3002\u3002"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] a(SerialPort serialPort, String incompleteMessage, NbIoTBean device) {
        String messageRegex;
        if ("Quectel_BC26".equals(device.getDeviceType()) && incompleteMessage.endsWith("\"") && incompleteMessage.matches(messageRegex = "(\\+QMT){0,1}RECV: [0-9]+,[0-9]+,\"" + device.getCommunicationID() + "\",\"[\\s\\S]+\"$")) {
            log.info((Object)("\u4fe1\u606f\u4e0d\u5b8c\u6574\uff08\u8bbe\u5907\u5bfc\u81f4\u7684\u4fe1\u606f\u4e22\u5931\uff09\uff1a" + incompleteMessage));
            return Utils.getByteArray(incompleteMessage);
        }
        int retryTime = 0;
        byte[] rest = null;
        byte[] response = incompleteMessage.getBytes();
        while (true) {
            SerialPort serialPort2 = serialPort;
            synchronized (serialPort2) {
                byte[] moreResponse;
                block25: {
                    moreResponse = new byte[1];
                    if (!BC26NbIoTDriver.serialportConnected(serialPort)) {
                        return null;
                    }
                    try {
                        if (!serialPort.isOpened()) break block25;
                        while (serialPort.getInputBufferBytesCount() <= 0 && retryTime < 50) {
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException e2) {
                                log.info((Object)"\u7ebf\u7a0b\u7b49\u5f85\u88ab\u6253\u65ad\u3002\u3002\u3002");
                            }
                            if (++retryTime < 49) continue;
                            log.error((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u672a\u54cd\u5e94!"));
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(rest) + "\u3011"));
                            return response;
                        }
                        moreResponse = serialPort.readBytes(1);
                    }
                    catch (SerialPortException e3) {
                        log.error((Object)("\u8bfb\u4e32\u53e3" + serialPort.getPortName() + "\u5931\u8d25\u3002\u3002\u3002"), (Throwable)e3);
                        break;
                    }
                }
                if (moreResponse == null) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e4) {
                        log.info((Object)"\u7ebf\u7a0b\u7b49\u5f85\u88ab\u6253\u65ad\u3002\u3002\u3002");
                    }
                    if (++retryTime > 50) {
                        break;
                    }
                } else {
                    rest = Utils.mergeByteArray(moreResponse, rest);
                    response = Utils.mergeByteArray(moreResponse, response);
                    String responseStr = Utils.getString(response);
                    if ("Quectel_BC26".equals(device.getDeviceType())) {
                        if (responseStr.endsWith("+QMT")) {
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(rest) + "\u3011"));
                            log.info((Object)("\u4fe1\u606f\u7f3a\u5931\u90e8\u5206\u5df2\u7ecf\u8bfb\u5b8c\uff1a" + responseStr));
                            return Utils.getByteArray(responseStr.substring(0, responseStr.length() - 4));
                        }
                        String connectionRegex = "((\\+QMT){0,1}STAT: [0-9]+,[0-9]+)$";
                        String exceptionRegex = "Rb[\\S\\s]+B[\\S\\s]+";
                        Pattern connectionPattern = Pattern.compile(connectionRegex);
                        Pattern exceptionPattern = Pattern.compile(exceptionRegex);
                        Matcher connectionMatcher = connectionPattern.matcher(responseStr.replace("\r", "").replace("\n", ""));
                        Matcher exceptionMatcher = exceptionPattern.matcher(responseStr.replace("\r", "").replace("\n", ""));
                        if (connectionMatcher.find() || exceptionMatcher.find()) {
                            device.setUsingStatus("2");
                            WatchDog.getInstance().interrupt();
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(rest) + "\u3011"));
                            return Utils.getByteArray(responseStr.replaceAll(exceptionRegex, "").replaceAll(connectionRegex, ""));
                        }
                        if (responseStr.replace("\r", "").replace("\n", "").endsWith("ERROR")) {
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(rest) + "\u3011"));
                            return Utils.getByteArray(responseStr.replace("ERROR", ""));
                        }
                    }
                    if ("M5310-A".equals(device.getDeviceType())) {
                        if (responseStr.endsWith("+MQTT")) {
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(rest) + "\u3011"));
                            log.info((Object)("\u4fe1\u606f\u7f3a\u5931\u90e8\u5206\u5df2\u7ecf\u8bfb\u5b8c\uff1a" + responseStr));
                            return Utils.getByteArray(responseStr.substring(0, responseStr.length() - 5));
                        }
                        String reconnectRegex = "(\\+MQTT){0,1}REC:[0-9]+";
                        String publishSucessWithQosIs2ResponseRegex1 = "(\\+MQTT){0,1}PUBREC:[0-9]+,[0-9]+";
                        Pattern reconnectPattern = Pattern.compile(reconnectRegex);
                        Pattern publishSucessWithQosIs2Pattern1 = Pattern.compile(publishSucessWithQosIs2ResponseRegex1);
                        Matcher reconnectMatcher = reconnectPattern.matcher(responseStr.replace("\r", "").replace("\n", ""));
                        Matcher publishSucessWithQosIs2Matcher1 = publishSucessWithQosIs2Pattern1.matcher(responseStr.replace("\r", "").replace("\n", ""));
                        if (reconnectMatcher.find() && !publishSucessWithQosIs2Matcher1.find()) {
                            device.setUsingStatus("2");
                            WatchDog.getInstance().interrupt();
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(rest) + "\u3011"));
                            return Utils.getByteArray(responseStr.replaceAll(reconnectRegex, ""));
                        }
                        String exception1 = "REBOOT_CAUSE_APPLICATION_WATCHDOG";
                        String exception2 = "REBOOT_CAUSE_PROTOCOL_RPC_TIMEOUT";
                        if (responseStr.contains(exception1) || responseStr.contains(exception2)) {
                            this.stopDevice(serialPort.getPortName());
                        }
                    }
                }
            }
        }
        if (response != null && response.length != 0) {
            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(rest) + "\u3011"));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getCompleteMessages(byte[] responseByteArray, SerialPort serialport, NbIoTBean device, String markForLog) {
        int readTimes = 0;
        ArrayList<String> messageList = new ArrayList<String>();
        ArrayList<String> incompleteMessageList = new ArrayList<String>();
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            while (!this.isCompleteMessages(responseByteArray, device, messageList, incompleteMessageList)) {
                log.debug((Object)("\u6536\u5230\u4e0d\u5b8c\u6574\u4fe1\u606f\uff1a\u3010" + markForLog + "\u3011" + Utils.getString(responseByteArray)));
                if (readTimes >= 15 || messageList.size() > 50) {
                    log.info((Object)("\u8bfb\u4e32\u53e3\u6b21\u6570:" + readTimes));
                    log.info((Object)("\u5185\u5b58\u4e2d\u4fe1\u606f\u6761\u6570\uff1a" + messageList.size()));
                    if (incompleteMessageList.isEmpty()) break;
                    log.info((Object)("\u4fe1\u606f\u63a5\u6536\u5b8c\u6574\u524d" + (String)incompleteMessageList.get(0)));
                    byte[] lastMessageInByteArray = this.a(serialport, (String)incompleteMessageList.get(0), device);
                    log.info((Object)("\u4fe1\u606f\u63a5\u6536\u5b8c\u6574\u540e" + Utils.getString(lastMessageInByteArray)));
                    ArrayList<String> tmpMessageList = new ArrayList<String>();
                    incompleteMessageList = new ArrayList();
                    if (!this.isCompleteMessages(lastMessageInByteArray, device, tmpMessageList, incompleteMessageList)) {
                        log.error((Object)"\u4e0b\u5217\u4fe1\u606f\u672a\u63a5\u6536\u5b8c\u3002\u3002\u3002\u3002");
                        for (int i2 = 0; i2 < incompleteMessageList.size(); ++i2) {
                            log.info(incompleteMessageList.get(i2));
                        }
                        break;
                    }
                    messageList.addAll(tmpMessageList);
                    break;
                }
                if (!BC26NbIoTDriver.serialportConnected(serialport)) {
                    log.info((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u6389\u7ebf\u4e86\u3002\u3002\u3002"));
                    log.info((Object)("\u4fe1\u606f\u53ef\u80fd\u6709\u4e22\u5931\uff1a" + Utils.getString(responseByteArray)));
                    break;
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException lastMessageInByteArray) {
                    // empty catch block
                }
                byte[] tmpResponseByteArray = ModemDriver.getBytesResponse(serialport, "UTF-8");
                responseByteArray = Utils.mergeByteArray(tmpResponseByteArray, responseByteArray);
                messageList = new ArrayList();
                incompleteMessageList = new ArrayList();
                ++readTimes;
            }
        }
        for (int i3 = 0; i3 < messageList.size(); ++i3) {
            nbiotMessageHolder.updateMessageList(device, (String)messageList.get(i3));
        }
    }

    @Override
    public boolean isDeviceAT(SerialPort serialPort) {
        if (!BC26NbIoTDriver.execAtCommand(null, serialPort, "AT\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e2) {
            log.info((Object)"\u7b49\u5f85AT\u54cd\u5e94\u65f6\u88ab\u6253\u65ad");
        }
        String response = ModemDriver.getStrResponse(serialPort, false, "", "UTF-8");
        response = response.replace("AT", "");
        return "OK".equals(response);
    }
}

