/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.driver.nbiotDriver;

import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.otherModem.bean.NbIoTBean;
import cn.sendsms.otherModem.common.Utils;
import cn.sendsms.otherModem.driver.ModemDriver;
import cn.sendsms.otherModem.driver.nbiotDriver.NbIoTDriver;
import cn.sendsms.otherModem.thread.WatchDog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jssc.SerialPort;
import jssc.SerialPortException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class M5310ANbIoTDriver
extends NbIoTDriver {
    private static final M5310ANbIoTDriver M5310A_DRIVER = new M5310ANbIoTDriver();

    public static final M5310ANbIoTDriver getInstance() {
        return M5310A_DRIVER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSignal(SerialPort serialPort) {
        String signal = "99,99";
        boolean needToClose = false;
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            if (!M5310ANbIoTDriver.serialportConnected(serialPort)) {
                Utils.closePort(serialPort);
                log.info((Object)("\u6b63\u5728\u5c1d\u8bd5\u6253\u5f00\u7aef\u53e3:" + serialPort.getPortName()));
                if (Utils.openPort(device.getBaudrate(), serialPort)) {
                    needToClose = true;
                } else {
                    return signal;
                }
            }
            if (!M5310ANbIoTDriver.execAtCommand(device, serialPort, "AT+CSQ\r", "UTF-8")) {
                log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
                return signal;
            }
            String regex = "\\+CSQ:[0-9]+,[0-9]+OK";
            String response = ModemDriver.getStrResponse(serialPort, false, regex, "UTF-8");
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(response);
            if (matcher.find()) {
                signal = matcher.group(0);
            }
            signal = Utils.deleteSuffix(signal, "OK");
            signal = Utils.deletePrefix(signal, "+CSQ:");
            if (needToClose) {
                Utils.closePort(serialPort);
            }
        }
        return signal;
    }

    @Override
    public String getSerialNumber(SerialPort serialPort) {
        String serialNumber = "";
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        if (!M5310ANbIoTDriver.execAtCommand(device, serialPort, "AT+CGSN\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return serialNumber;
        }
        String regex = "[A-Z,0-9]+-[A-Z,0-9]+-[A-Z,0-9]+-[A-Z,0-9]+-[A-Z,0-9]+";
        serialNumber = ModemDriver.getStrResponse(serialPort, false, regex, "UTF-8");
        serialNumber = Utils.deleteSuffix(serialNumber, "OK");
        return serialNumber;
    }

    @Override
    public String getCommunicationID(String serialNumber) {
        String communicationID = "";
        if (serialNumber == null || serialNumber.equals("")) {
            return communicationID;
        }
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        String pointedOrignStr = props.getString("random_number_seed", "");
        if (pointedOrignStr != null && !"".equals(pointedOrignStr) && pointedOrignStr.length() >= 10 && pointedOrignStr.matches("[0-9a-zA-Z]+")) {
            serialNumber = pointedOrignStr;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(serialNumber.getBytes("UTF-8"));
            byte[] b2 = md.digest();
            communicationID = new BigInteger(1, b2).toString(16).substring(8, 16).toUpperCase();
        }
        catch (Exception e2) {
            log.error((Object)"\u83b7\u53d6\u901a\u4fe1ID\u5931\u8d25\u3002\u3002\u3002", (Throwable)e2);
            communicationID = "";
        }
        return communicationID;
    }

    @Override
    public boolean networkNormal(SerialPort serialPort) {
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        if (!M5310ANbIoTDriver.execAtCommand(device, serialPort, "AT+CEREG?\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        String regex = "+CEREG:0,1";
        String response = ModemDriver.getStrResponse(serialPort, false, "OK", "UTF-8");
        if (regex.equals(response = Utils.deleteSuffix(response, "OK"))) {
            log.info((Object)(serialPort.getPortName() + "\u7f51\u7edc\u6b63\u5e38\u3002\u3002\u3002"));
            return true;
        }
        log.info((Object)(response + "\u5f53\u524d\u7f51\u7edc\u72b6\u6001\uff1a" + response));
        return false;
    }

    @Override
    public boolean isCompleteMessages(byte[] messageByteArray, NbIoTBean device, List<String> messageList, List<String> incompleteMessageList) {
        String messages = Utils.getString(messageByteArray);
        String decodedContext = "";
        List<String> formattedMessageList = this.a(messages, device);
        if (formattedMessageList == null || formattedMessageList.size() == 0) {
            return true;
        }
        String messageRegex = "(\\+MQTT){0,1}PUBLISH:[0-9]+,[0-9]+,[0-9]+,[0-9]+," + device.getCommunicationID() + ",[0-9]+,[\\s\\S]*";
        for (int i2 = 0; i2 < formattedMessageList.size(); ++i2) {
            String message = formattedMessageList.get(i2);
            if (message.matches(messageRegex)) {
                int receivedContextLength;
                String context = message.replaceFirst("(\\+MQTT){0,1}PUBLISH:[0-9]+,[0-9]+,[0-9]+,[0-9]+," + device.getCommunicationID() + ",[0-9]+,", "");
                int sentContextLength = 0;
                if (Utils.isEmptyStr(context) || context.length() <= 38) {
                    incompleteMessageList.add(message);
                    return false;
                }
                String sentContextLengthStr = context.substring(35, 38);
                try {
                    sentContextLength = Integer.valueOf(sentContextLengthStr, 16);
                }
                catch (NumberFormatException e2) {
                    incompleteMessageList.add(message);
                    return false;
                }
                decodedContext = context;
                String codingType = context.substring(34, 35);
                if ("U".equals(codingType)) {
                    String attachInfo = context.substring(0, 38);
                    String encodedText = context.substring(38);
                    try {
                        decodedContext = attachInfo + Utils.getString(Utils.hexStr2ByteArr(encodedText));
                    }
                    catch (Exception e3) {
                        incompleteMessageList.add(message);
                        return false;
                    }
                }
                if (sentContextLength > (receivedContextLength = Utils.getByteArray(context.substring(38)).length)) {
                    incompleteMessageList.add(message);
                    return false;
                }
            } else {
                incompleteMessageList.add(message);
                return false;
            }
            messageList.add(decodedContext);
        }
        return true;
    }

    private List<String> a(String messages, NbIoTBean device) {
        String formatedMessage = "";
        ArrayList<String> messageList = new ArrayList<String>();
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        StringReader stringReader = new StringReader(messages);
        BufferedReader reader = new BufferedReader(stringReader);
        int mqttQos = props.getInt("settings.mqtt_qos", 1);
        String connectionOKRegex = "(\\+MQTT){0,1}STAT:[0-9]+";
        String connectSucessedRegex = "(\\+MQTT){0,1}OPEN:OK";
        String subSucesseRegex = "(\\+MQTT){0,1}SUBACK:[0-9]+," + mqttQos + "," + device.getCommunicationID();
        String pubSucessedRegex = "(\\+MQTT){0,1}PUBACK:[0-9]+,[0-9]+";
        String pubSucessedRegex1 = "(\\+MQTT){0,1}PUBREC:[0-9]+,[0-9]+";
        String pubSucessedRegex2 = "(\\+MQTT){0,1}PUBCOMP:[0-9]+,[0-9]+";
        String disconnectSucess = "(\\+MQTT){0,1}DISC:OK";
        if (mqttQos != 1 && mqttQos != 0) {
            pubSucessedRegex = "(\\+MQTT){0,1}PUBREC:[0-9]+,[0-9]+[\\s\\S]*(\\+MQTT){0,1}PUBCOMP:[0-9]+,[0-9]+";
        }
        String reconnectRegex = "(\\+MQTT){0,1}REC:[0-9]+";
        String noRequestRegex = "(\\+MQTT){0,1}TO:[0-9]+";
        String netState = "\\+CEREG:[0-9]+,[0-9]+";
        String exception1 = "REBOOT_CAUSE_APPLICATION_WATCHDOG";
        String exception2 = "REBOOT_CAUSE_PROTOCOL_RPC_TIMEOUT";
        while (true) {
            String line = null;
            try {
                line = reader.readLine();
            }
            catch (IOException e2) {
                log.error((Object)"\u4fe1\u606f\u89e3\u6790\u5931\u8d25\u3002\u3002\u3002", (Throwable)e2);
            }
            if (line == null) break;
            if (line.trim().equals("") || line.replace("\r", "").replace("\n", "").equals("OK")) continue;
            if (line.startsWith("OK")) {
                formatedMessage = formatedMessage + line.substring(2);
                continue;
            }
            if (line.replace("\r", "").replace("\n", "").equals("ERROR") || line.replace("\r", "").replace("\n", "").matches(connectionOKRegex) || line.replace("\r", "").replace("\n", "").matches(connectSucessedRegex) || line.replace("\r", "").replace("\n", "").matches(subSucesseRegex) || (mqttQos == 1 || mqttQos == 0) && line.replace("\r", "").replace("\n", "").matches(pubSucessedRegex)) continue;
            if (line.replace("\r", "").replace("\n", "").contains(exception1) || line.replace("\r", "").replace("\n", "").contains(exception2)) {
                log.error((Object)("\u8bbe\u5907\u3010" + device.getGatewayID() + "\u3011\u53d1\u751f\u4e25\u91cd\u5f02\u5e38\uff01\u5373\u5c06\u505c\u6b62\uff01"));
                log.info((Object)("\u9519\u8bef\u4fe1\u606f\uff1a" + messages));
                this.stopDevice(device.getPortID());
                return messageList;
            }
            if (mqttQos == 2 && line.replace("\r", "").replace("\n", "").matches(pubSucessedRegex1) || mqttQos == 2 && line.replace("\r", "").replace("\n", "").matches(pubSucessedRegex2)) continue;
            if (line.replace("\r", "").replace("\n", "").matches(reconnectRegex)) {
                this.a(device.getPortID());
                continue;
            }
            if (line.replace("\r", "").replace("\n", "").matches(noRequestRegex) || line.replace("\r", "").replace("\n", "").matches(disconnectSucess) || line.replace("\r", "").replace("\n", "").matches(netState)) continue;
            if (line.startsWith("+MQTTSTAT:5")) {
                line = line.replace("+MQTTSTAT:5", "");
            }
            formatedMessage = formatedMessage + line;
        }
        try {
            reader.close();
            stringReader.close();
        }
        catch (IOException e3) {
            log.error((Object)"\u6570\u636e\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e3);
        }
        String[] messageArray = formatedMessage.split("(\\+MQTT){0,1}PUBLISH:");
        for (int i2 = 0; i2 < messageArray.length; ++i2) {
            if (messageArray[i2] == null || messageArray[i2].length() == 0) continue;
            messageList.add("+MQTTPUBLISH:" + messageArray[i2]);
        }
        if (formatedMessage.endsWith("PUBLISH:")) {
            messageList.add("+MQTTPUBLISH:");
        }
        return messageList;
    }

    private void a(String portID) {
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(portID);
        if (device != null) {
            log.error((Object)"\u8bbe\u5907\u8fde\u63a5\u5f02\u5e38\uff0c\u5373\u5c06\u91cd\u542f\uff01\u3010M5310A-prepareRestartDevice\u3011");
            device.setUsingStatus("2");
            log.info((Object)(device.getGatewayID() + "\u5373\u5c06\u91cd\u542f\u3002\u3002\u3002"));
            WatchDog.getInstance().interrupt();
        }
    }

    @Override
    public boolean initDevice(SerialPort serialPort) {
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        if (!M5310ANbIoTDriver.execAtCommand(device, serialPort, "AT+NRB\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        String response = ModemDriver.getStrResponse(serialPort, false, "REBOOTING[\\s\\S]*OK", "UTF-8");
        if (response.matches("REBOOTING[\\s\\S]*OK")) {
            return true;
        }
        log.info((Object)("\u8bbe\u5907\u91cd\u542f\u5931\u8d25\uff1a" + response));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendMessage(String recipient, String text, NbIoTBean nbiotDevice) {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        String usingPort = nbiotDevice.getPortID();
        boolean publishSucess = false;
        SerialPort serialport = nbiotDeviceInfoGetter.getSerialPort(usingPort);
        int mqttQos = props.getInt("settings.mqtt_qos", 1);
        String sendMessagecmd = "AT+MQTTPUB=\"" + recipient + "\"," + mqttQos + ",0,0," + 0 + ",\"" + text + "\"\r";
        String publishSucessWithQosIs0ResponseRegex = "[\\s]*OK[\\s]*";
        String publishSucessWithQosIs1ResponseRegex = "(\\+MQTT){0,1}PUBACK:[0-9]+,[0-9]+";
        String publishSucessWithQosIs2ResponseRegex1 = "(\\+MQTT){0,1}PUBREC:[0-9]+,[0-9]+";
        String publishSucessWithQosIs2ResponseRegex2 = "(\\+MQTT){0,1}PUBCOMP:[0-9]+,[0-9]+";
        String publishTimeOutResponseRegex = "(\\+MQTT){0,1}TO:2";
        String reconnectRegex = "(\\+MQTT){0,1}REC:[0-9]+";
        Pattern publishSucessWithQosIs0Pattern = Pattern.compile(publishSucessWithQosIs0ResponseRegex);
        Pattern publishSucessWithQosIs1Pattern = Pattern.compile(publishSucessWithQosIs1ResponseRegex);
        Pattern publishSucessWithQosIs2Pattern1 = Pattern.compile(publishSucessWithQosIs2ResponseRegex1);
        Pattern publishSucessWithQosIs2Pattern2 = Pattern.compile(publishSucessWithQosIs2ResponseRegex2);
        Pattern publishTimeOutPattern = Pattern.compile(publishTimeOutResponseRegex);
        Pattern reconnectPattern = Pattern.compile(reconnectRegex);
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            if (!M5310ANbIoTDriver.execAtCommand(nbiotDevice, serialport, sendMessagecmd, "UTF-8")) {
                log.error((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
                return false;
            }
            byte[] responseByteArray = ModemDriver.getBytesResponse(serialport, "UTF-8");
            int loop = 0;
            while (M5310ANbIoTDriver.serialportConnected(serialport)) {
                String response = Utils.getString(responseByteArray);
                if (response.replace("\r", "").replace("\n", "").equals("ERROR")) {
                    log.info((Object)("\u8bbe\u5907" + nbiotDevice.getGatewayID() + "\u4fe1\u606f\u53d1\u9001\u5931\u8d25.\u8fd4\u56de\u503c\uff1a" + response));
                    return false;
                }
                Matcher publishSucessWithQosIs0Matcher = publishSucessWithQosIs0Pattern.matcher(response.replace("\r", "").replace("\n", ""));
                Matcher publishSucessWithQosIs1Matcher = publishSucessWithQosIs1Pattern.matcher(response.replace("\r", "").replace("\n", ""));
                Matcher publishSucessWithQosIs2Matcher1 = publishSucessWithQosIs2Pattern1.matcher(response.replace("\r", "").replace("\n", ""));
                Matcher publishSucessWithQosIs2Matcher2 = publishSucessWithQosIs2Pattern2.matcher(response.replace("\r", "").replace("\n", ""));
                Matcher publishTimeOutMatcher = publishTimeOutPattern.matcher(response.replace("\r", "").replace("\n", ""));
                Matcher reconnectMatcher = reconnectPattern.matcher(response.replace("\r", "").replace("\n", ""));
                boolean publishSucessWithQosIs0 = publishSucessWithQosIs0Matcher.find();
                boolean publishSucessWithQosIs1 = publishSucessWithQosIs1Matcher.find();
                boolean publishSucessWithQos2 = publishSucessWithQosIs2Matcher1.find() && publishSucessWithQosIs2Matcher2.find();
                boolean publishTimeOut = publishTimeOutMatcher.find();
                boolean reconectting = reconnectMatcher.find();
                if (mqttQos == 0 && publishSucessWithQosIs0 || mqttQos == 1 && publishSucessWithQosIs1 || mqttQos == 2 && publishSucessWithQos2) {
                    publishSucess = true;
                    break;
                }
                if ((publishTimeOut || reconectting) && !publishSucessWithQosIs2Matcher1.reset().find()) {
                    this.a(nbiotDevice.getPortID());
                    break;
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e2) {
                    log.error((Object)"\u7b49\u5f85\u53d1\u9001\u4fe1\u606f\u547d\u4ee4\u7684\u8fd4\u56de\u7ed3\u679c\u65f6\u88ab\u6253\u65ad\u3002\u3002\u3002");
                }
                byte[] tmpResponseByteArray = ModemDriver.getBytesResponse(serialport, "UTF-8");
                responseByteArray = Utils.mergeByteArray(tmpResponseByteArray, responseByteArray);
                if (++loop < 300) continue;
                break;
            }
            this.getCompleteMessages(responseByteArray, serialport, nbiotDevice, "\u53d1\u4fe1\u7ebf\u7a0b");
            return publishSucess;
        }
    }

    @Override
    public void commandNotEcho(SerialPort serialPort) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean subSucessed(String portID) {
        SerialPort serialport = nbiotDeviceInfoGetter.getSerialPort(portID);
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(portID);
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
            int mqttQos = props.getInt("settings.mqtt_qos", 1);
            String subscribeTopic = "AT+MQTTSUB=\"" + device.getCommunicationID() + "\"," + mqttQos + "\r";
            if (!M5310ANbIoTDriver.execAtCommand(device, serialport, subscribeTopic, "UTF-8")) {
                log.error((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
                return false;
            }
            byte[] responseByteArray = ModemDriver.getBytesResponse(serialport, "UTF-8");
            int loop = 0;
            String expectResult1 = "OK[\\s\\S]*(\\+MQTT){0,1}SUBACK:[0-9]+," + mqttQos + "," + device.getCommunicationID();
            String expectResult2 = "(\\+MQTT){0,1}PUBLISH:[0-9]+,[0-9]+,[0-9]+,[0-9]+," + device.getCommunicationID() + ",[0-9]+,[\\s\\S]*";
            Pattern pattern1 = Pattern.compile(expectResult1);
            Pattern pattern2 = Pattern.compile(expectResult2);
            Matcher matcher1 = null;
            Matcher matcher2 = null;
            String response = "";
            while (M5310ANbIoTDriver.serialportConnected(serialport)) {
                response = Utils.getString(responseByteArray);
                if (response.replace("\r", "").replace("\n", "").matches(expectResult1)) {
                    return true;
                }
                if (response.replace("\r", "").replace("\n", "").equals("ERROR")) {
                    return false;
                }
                matcher1 = pattern1.matcher(response.replace("\r", "").replace("\n", ""));
                if (matcher1.find() || (matcher2 = pattern2.matcher(response.replace("\r", "").replace("\n", ""))).find()) break;
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e2) {
                    log.error((Object)"\u7b49\u5f85MQTT\u670d\u52a1\u5668\u8ba2\u9605\u662f\u5426\u6210\u529f\u7684\u53cd\u9988\u4fe1\u606f\u65f6\u88ab\u6253\u65ad\u3002\u3002\u3002");
                }
                byte[] tmpResponseByteArray = ModemDriver.getBytesResponse(serialport, "UTF-8");
                responseByteArray = Utils.mergeByteArray(tmpResponseByteArray, responseByteArray);
                if (++loop < 150) continue;
                break;
            }
            if (response == null || response.equals("")) {
                return false;
            }
            this.getCompleteMessages(responseByteArray, serialport, device, "\u8ba2\u9605\u4e3b\u9898");
            matcher1.reset();
            matcher2.reset();
            return matcher1.find() || matcher2.find();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connectSucessed(String portID) {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        SerialPort serialport = nbiotDeviceInfoGetter.getSerialPort(portID);
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(portID);
        String mqttServer = props.getString("settings.mqtt_server", "119.90.56.92");
        String mqttPort = props.getString("settings.mqtt_port", "1883");
        String mqttUser = props.getString("settings.mqtt_user", "0000");
        String mqttPassword = props.getString("settings.mqtt_password", "0000");
        int keepAlive = props.getInt("settings.mqtt_keepalive", 10);
        int ack = props.getInt("settings.mqtt_ack", 8);
        String deviceConnectionConfigCmd = "AT+MQTTCFG=\"" + mqttServer + "\"," + mqttPort + ",\"" + device.getCommunicationID() + "\"," + keepAlive + ",\"" + mqttUser + "\",\"" + mqttPassword + "\",0\r";
        if (!M5310ANbIoTDriver.execAtCommand(device, serialport, deviceConnectionConfigCmd, "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            this.stopDevice(device.getPortID());
            return false;
        }
        String response = ModemDriver.getStrResponse(serialport, false, "OK", "UTF-8");
        if (!"OK".equals(response)) {
            log.error((Object)(serialport.getPortName() + "\u914d\u7f6eMQTT\u670d\u52a1\u5668\u8fde\u63a5\u53c2\u6570\u5f02\u5e38:" + response));
            this.stopDevice(device.getPortID());
            return false;
        }
        String deviceACKCmd = "AT+MQTTTO=" + ack + "\r";
        if (!M5310ANbIoTDriver.execAtCommand(device, serialport, deviceACKCmd, "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            this.stopDevice(device.getPortID());
            return false;
        }
        response = ModemDriver.getStrResponse(serialport, false, "OK", "UTF-8");
        if (!"OK".equals(response)) {
            log.error((Object)(serialport.getPortName() + "MQTT\u670d\u52a1\u5668\u54cd\u5e94\u65f6\u95f4\u8bbe\u5b9a\u5f02\u5e38" + response + "\u91c7\u7528\u9ed8\u8ba4\u8bbe\u5b9a\uff0810S\uff09..."));
            this.stopDevice(device.getPortID());
            return false;
        }
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            String communicationID = device.getCommunicationID();
            String userFlag = mqttUser.equals("0000") ? "1" : "0";
            String passwordFlag = mqttPassword.equals("0000") ? "1" : "0";
            String deviceConnectionServerCmd = "AT+MQTTOPEN=" + userFlag + "," + passwordFlag + ",0\r";
            if (!M5310ANbIoTDriver.execAtCommand(device, serialport, deviceConnectionServerCmd, "UTF-8")) {
                log.error((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
                return false;
            }
            String openConnSucessRegex = "OK[\\s\\S]*(\\+MQTT){0,1}OPEN:OK";
            String messageRegex = "(\\+MQTT){0,1}PUBLISH:[0-9]+,[0-9]+,[0-9]+,[0-9]+," + communicationID + ",[0-9]+,[\\s\\S]*";
            Pattern openConnSucessPattern = Pattern.compile(openConnSucessRegex);
            Pattern messagePattern = Pattern.compile(messageRegex);
            Matcher openConnSucessMatcher = null;
            Matcher messageMatcher = null;
            byte[] responseByteArray = ModemDriver.getBytesResponse(serialport, "UTF-8");
            int loop = 0;
            while (M5310ANbIoTDriver.serialportConnected(serialport)) {
                response = Utils.getString(responseByteArray);
                if (response.replace("\r", "").replace("\n", "").matches(openConnSucessRegex)) {
                    return true;
                }
                if (response.replace("\r", "").replace("\n", "").equals("ERROR")) {
                    return false;
                }
                openConnSucessMatcher = openConnSucessPattern.matcher(response.replace("\r", "").replace("\n", ""));
                if (openConnSucessMatcher.find() || (messageMatcher = messagePattern.matcher(response.replace("\r", "").replace("\n", ""))).find()) break;
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e2) {
                    log.error((Object)"\u7b49\u5f85MQTT\u670d\u52a1\u5668\u8fde\u63a5\u662f\u5426\u6210\u529f\u7684\u53cd\u9988\u4fe1\u606f\u65f6\u88ab\u6253\u65ad\u3002\u3002\u3002");
                }
                byte[] tmpResponseByteArray = ModemDriver.getBytesResponse(serialport, "UTF-8");
                responseByteArray = Utils.mergeByteArray(tmpResponseByteArray, responseByteArray);
                if (++loop < 150) continue;
                break;
            }
            if (response == null || response.equals("")) {
                return false;
            }
            this.getCompleteMessages(responseByteArray, serialport, device, "\u8fde\u63a5MQTT\u670d\u52a1\u5668");
            openConnSucessMatcher.reset();
            messageMatcher.reset();
            boolean connSucess = openConnSucessMatcher.find();
            boolean receivedMessage = messageMatcher.find();
            if (connSucess || receivedMessage) {
                if (receivedMessage) {
                    device.setUsingStatus("1");
                }
                return true;
            }
            return false;
        }
    }

    @Override
    public void disconnectMQTTServer(SerialPort serialport) {
        String disconnectCmd;
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(serialport.getPortName());
        if (!M5310ANbIoTDriver.execAtCommand(device, serialport, disconnectCmd = "AT+MQTTDISC\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
        }
        String expectResult1 = "MQTTDISC:OK";
        Pattern pattern1 = Pattern.compile(expectResult1);
        Matcher matcher1 = null;
        byte[] responseByteArray = ModemDriver.getBytesResponse(serialport, "UTF-8");
        int loop = 0;
        String response = "";
        while (M5310ANbIoTDriver.serialportConnected(serialport)) {
            response = Utils.getString(responseByteArray);
            if (response.replace("\r", "").replace("\n", "").equals(expectResult1)) {
                log.info((Object)(device.getGatewayID() + "\u65ad\u5f00\u8fde\u63a5\u6210\u529f(1)"));
                break;
            }
            if (response.replace("\r", "").replace("\n", "").equals("ERROR")) {
                log.info((Object)(device.getGatewayID() + "\u65ad\u5f00\u8fde\u63a5\u5931\u8d25(1)\u3002"));
                break;
            }
            matcher1 = pattern1.matcher(response.replace("\r", "").replace("\n", ""));
            if (matcher1.find()) break;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e2) {
                log.error((Object)"\u7b49\u5f85MQTT\u670d\u52a1\u5668\u8fde\u63a5\u662f\u5426\u6210\u529f\u7684\u53cd\u9988\u4fe1\u606f\u65f6\u88ab\u6253\u65ad\u3002\u3002\u3002");
            }
            byte[] tmpResponseByteArray = ModemDriver.getBytesResponse(serialport, "UTF-8");
            responseByteArray = Utils.mergeByteArray(tmpResponseByteArray, responseByteArray);
            if (++loop < 150) continue;
            break;
        }
        if (response == null || response.equals("")) {
            log.info((Object)(device.getGatewayID() + "\u65ad\u5f00\u8fde\u63a5\u5931\u8d25(2)"));
        }
        this.getCompleteMessages(responseByteArray, serialport, device, "\u65ad\u5f00MQTT\u670d\u52a1\u5668\u8fde\u63a5");
        String deleteClientObjCmd = "AT+MQTTDEL\r";
        if (!M5310ANbIoTDriver.execAtCommand(device, serialport, deleteClientObjCmd, "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
        }
        if (!(response = ModemDriver.getStrResponse(serialport, false, expectResult1 = "OK", "UTF-8")).contains(expectResult1)) {
            log.error((Object)"\u6ca1\u6709\u6210\u529f\u6e05\u9664\u5ba2\u6237\u7aef\u5b9e\u4f8b\u3002\u3002\u3002");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connectionOK(String portID) {
        SerialPort serialport = nbiotDeviceInfoGetter.getSerialPort(portID);
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(portID);
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            if ("0".equals(device.getUsingStatus())) {
                log.info((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u5df2\u7ecf\u5173\u95ed\u3002\u3002\u3002"));
                return true;
            }
            String expectResult1 = "(\\+MQTT){0,1}STAT:5";
            Pattern pattern1 = Pattern.compile(expectResult1);
            String getStateCmd = "AT+MQTTSTAT?\r";
            if (!M5310ANbIoTDriver.execAtCommand(device, serialport, getStateCmd, "UTF-8")) {
                if ("0".equals(device.getUsingStatus())) {
                    log.info((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u5df2\u7ecf\u5173\u95ed\u3002\u3002\u3002"));
                    return true;
                }
                return false;
            }
            byte[] responseByteArray = ModemDriver.getBytesResponse(serialport, "UTF-8");
            int loop = 0;
            Matcher matcher1 = null;
            String response = "";
            while (M5310ANbIoTDriver.serialportConnected(serialport)) {
                response = Utils.getString(responseByteArray);
                if (response.replace("\r", "").replace("\n", "").equals("ERROR")) {
                    return false;
                }
                matcher1 = pattern1.matcher(response.replace("\r", "").replace("\n", ""));
                if (matcher1.find()) break;
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e2) {
                    log.error((Object)"\u7b49\u5f85MQTT\u670d\u52a1\u5668\u8fde\u63a5\u662f\u5426\u6b63\u5e38\u7684\u53cd\u9988\u4fe1\u606f\u65f6\u88ab\u6253\u65ad\u3002\u3002\u3002");
                }
                byte[] tmpResponseByteArray = ModemDriver.getBytesResponse(serialport, "UTF-8");
                responseByteArray = Utils.mergeByteArray(tmpResponseByteArray, responseByteArray);
                if (++loop < 50) continue;
                break;
            }
            if (responseByteArray == null || responseByteArray.equals("")) {
                log.info((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u72b6\u6001\u68c0\u6d4b\u65e0\u54cd\u5e94\u3002"));
                return false;
            }
            this.getCompleteMessages(responseByteArray, serialport, device, "\u5224\u65ad\u8fde\u63a5\u72b6\u6001");
            matcher1.reset();
            boolean findExpectResult1 = matcher1.find();
            if (findExpectResult1) {
                return true;
            }
            log.info((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u4e0e\u670d\u52a1\u5668\u8fde\u63a5\u5f02\u5e38\uff01\u68c0\u6d4b\u8fd4\u56de\u503c\uff1a" + response));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] a(SerialPort serialPort, String incompleteMessage, NbIoTBean device) {
        String messageRegex;
        if ("Quectel_BC26".equals(device.getDeviceType()) && incompleteMessage.endsWith("\"") && incompleteMessage.matches(messageRegex = "(\\+QMT){0,1}RECV: [0-9]+,[0-9]+,\"" + device.getCommunicationID() + "\",\"[\\s\\S]+\"$")) {
            log.info((Object)("\u4fe1\u606f\u4e0d\u5b8c\u6574\uff08\u8bbe\u5907\u5bfc\u81f4\u7684\u4fe1\u606f\u4e22\u5931\uff09\uff1a" + incompleteMessage));
            return Utils.getByteArray(incompleteMessage);
        }
        int retryTime = 0;
        byte[] rest = null;
        byte[] response = incompleteMessage.getBytes();
        while (true) {
            SerialPort serialPort2 = serialPort;
            synchronized (serialPort2) {
                byte[] moreResponse;
                block25: {
                    moreResponse = new byte[1];
                    if (!M5310ANbIoTDriver.serialportConnected(serialPort)) {
                        return null;
                    }
                    try {
                        if (!serialPort.isOpened()) break block25;
                        while (serialPort.getInputBufferBytesCount() <= 0 && retryTime < 50) {
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException e2) {
                                log.info((Object)"\u7ebf\u7a0b\u7b49\u5f85\u88ab\u6253\u65ad\u3002\u3002\u3002");
                            }
                            if (++retryTime < 49) continue;
                            log.error((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u672a\u54cd\u5e94!"));
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(rest) + "\u3011"));
                            return response;
                        }
                        moreResponse = serialPort.readBytes(1);
                    }
                    catch (SerialPortException e3) {
                        log.error((Object)("\u8bfb\u4e32\u53e3" + serialPort.getPortName() + "\u5931\u8d25\u3002\u3002\u3002"), (Throwable)e3);
                        break;
                    }
                }
                if (moreResponse == null) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e4) {
                        log.info((Object)"\u7ebf\u7a0b\u7b49\u5f85\u88ab\u6253\u65ad\u3002\u3002\u3002");
                    }
                    if (++retryTime > 50) {
                        break;
                    }
                } else {
                    rest = Utils.mergeByteArray(moreResponse, rest);
                    response = Utils.mergeByteArray(moreResponse, response);
                    String responseStr = Utils.getString(response);
                    if ("Quectel_BC26".equals(device.getDeviceType())) {
                        if (responseStr.endsWith("+QMT")) {
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(rest) + "\u3011"));
                            log.info((Object)("\u4fe1\u606f\u7f3a\u5931\u90e8\u5206\u5df2\u7ecf\u8bfb\u5b8c\uff1a" + responseStr));
                            return Utils.getByteArray(responseStr.substring(0, responseStr.length() - 4));
                        }
                        String connectionRegex = "((\\+QMT){0,1}STAT: [0-9]+,[0-9]+)$";
                        String exceptionRegex = "Rb[\\S\\s]+B[\\S\\s]+";
                        Pattern connectionPattern = Pattern.compile(connectionRegex);
                        Pattern exceptionPattern = Pattern.compile(exceptionRegex);
                        Matcher connectionMatcher = connectionPattern.matcher(responseStr.replace("\r", "").replace("\n", ""));
                        Matcher exceptionMatcher = exceptionPattern.matcher(responseStr.replace("\r", "").replace("\n", ""));
                        if (connectionMatcher.find() || exceptionMatcher.find()) {
                            device.setUsingStatus("2");
                            WatchDog.getInstance().interrupt();
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(rest) + "\u3011"));
                            return Utils.getByteArray(responseStr.replaceAll(exceptionRegex, "").replaceAll(connectionRegex, ""));
                        }
                        if (responseStr.replace("\r", "").replace("\n", "").endsWith("ERROR")) {
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(rest) + "\u3011"));
                            return Utils.getByteArray(responseStr.replace("ERROR", ""));
                        }
                    }
                    if ("M5310-A".equals(device.getDeviceType())) {
                        if (responseStr.endsWith("+MQTT")) {
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(rest) + "\u3011"));
                            log.info((Object)("\u4fe1\u606f\u7f3a\u5931\u90e8\u5206\u5df2\u7ecf\u8bfb\u5b8c\uff1a" + responseStr));
                            return Utils.getByteArray(responseStr.substring(0, responseStr.length() - 5));
                        }
                        String reconnectRegex = "(\\+MQTT){0,1}REC:[0-9]+";
                        String publishSucessWithQosIs2ResponseRegex1 = "(\\+MQTT){0,1}PUBREC:[0-9]+,[0-9]+";
                        Pattern reconnectPattern = Pattern.compile(reconnectRegex);
                        Pattern publishSucessWithQosIs2Pattern1 = Pattern.compile(publishSucessWithQosIs2ResponseRegex1);
                        Matcher reconnectMatcher = reconnectPattern.matcher(responseStr.replace("\r", "").replace("\n", ""));
                        Matcher publishSucessWithQosIs2Matcher1 = publishSucessWithQosIs2Pattern1.matcher(responseStr.replace("\r", "").replace("\n", ""));
                        if (reconnectMatcher.find() && !publishSucessWithQosIs2Matcher1.find()) {
                            device.setUsingStatus("2");
                            WatchDog.getInstance().interrupt();
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(rest) + "\u3011"));
                            return Utils.getByteArray(responseStr.replaceAll(reconnectRegex, ""));
                        }
                        String exception1 = "REBOOT_CAUSE_APPLICATION_WATCHDOG";
                        String exception2 = "REBOOT_CAUSE_PROTOCOL_RPC_TIMEOUT";
                        if (responseStr.contains(exception1) || responseStr.contains(exception2)) {
                            this.stopDevice(serialPort.getPortName());
                        }
                    }
                }
            }
        }
        if (response != null && response.length != 0) {
            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(rest) + "\u3011"));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getCompleteMessages(byte[] responseByteArray, SerialPort serialport, NbIoTBean device, String markForLog) {
        int readTimes = 0;
        ArrayList<String> messageList = new ArrayList<String>();
        ArrayList<String> incompleteMessageList = new ArrayList<String>();
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            while (!this.isCompleteMessages(responseByteArray, device, messageList, incompleteMessageList)) {
                log.debug((Object)("\u6536\u5230\u4e0d\u5b8c\u6574\u4fe1\u606f\uff1a\u3010" + markForLog + "\u3011" + Utils.getString(responseByteArray)));
                if (readTimes >= 15 || messageList.size() > 50) {
                    log.info((Object)("\u8bfb\u4e32\u53e3\u6b21\u6570:" + readTimes));
                    log.info((Object)("\u5185\u5b58\u4e2d\u4fe1\u606f\u6761\u6570\uff1a" + messageList.size()));
                    if (incompleteMessageList.isEmpty()) break;
                    log.info((Object)("\u4fe1\u606f\u63a5\u6536\u5b8c\u6574\u524d" + (String)incompleteMessageList.get(0)));
                    byte[] lastMessageInByteArray = this.a(serialport, (String)incompleteMessageList.get(0), device);
                    log.info((Object)("\u4fe1\u606f\u63a5\u6536\u5b8c\u6574\u540e" + Utils.getString(lastMessageInByteArray)));
                    ArrayList<String> tmpMessageList = new ArrayList<String>();
                    incompleteMessageList = new ArrayList();
                    if (!this.isCompleteMessages(lastMessageInByteArray, device, tmpMessageList, incompleteMessageList)) {
                        log.error((Object)"\u4e0b\u5217\u4fe1\u606f\u672a\u63a5\u6536\u5b8c\u3002\u3002\u3002\u3002");
                        for (int i2 = 0; i2 < incompleteMessageList.size(); ++i2) {
                            log.info(incompleteMessageList.get(i2));
                        }
                        break;
                    }
                    messageList.addAll(tmpMessageList);
                    break;
                }
                if (!M5310ANbIoTDriver.serialportConnected(serialport)) {
                    log.info((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u6389\u7ebf\u4e86\u3002\u3002\u3002"));
                    log.info((Object)("\u4fe1\u606f\u53ef\u80fd\u6709\u4e22\u5931\uff1a" + Utils.getString(responseByteArray)));
                    break;
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException lastMessageInByteArray) {
                    // empty catch block
                }
                byte[] tmpResponseByteArray = ModemDriver.getBytesResponse(serialport, "UTF-8");
                responseByteArray = Utils.mergeByteArray(tmpResponseByteArray, responseByteArray);
                messageList = new ArrayList();
                incompleteMessageList = new ArrayList();
                ++readTimes;
            }
        }
        for (int i3 = 0; i3 < messageList.size(); ++i3) {
            nbiotMessageHolder.updateMessageList(device, (String)messageList.get(i3));
        }
    }

    @Override
    public boolean isDeviceAT(SerialPort serialPort) {
        if (!M5310ANbIoTDriver.execAtCommand(null, serialPort, "AT\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e2) {
            log.info((Object)"\u7b49\u5f85AT\u54cd\u5e94\u65f6\u88ab\u6253\u65ad");
        }
        String response = ModemDriver.getStrResponse(serialPort, false, "", "UTF-8");
        response = response.replace("AT", "");
        return "OK".equals(response);
    }
}

