/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.driver.nbiotDriver;

import cn.sendsms.otherModem.bean.NbIoTBean;
import cn.sendsms.otherModem.common.Utils;
import cn.sendsms.otherModem.driver.ModemDriver;
import cn.sendsms.otherModem.driver.nbiotDriver.BC26NbIoTDriver;
import cn.sendsms.otherModem.driver.nbiotDriver.M5310ANbIoTDriver;
import cn.sendsms.otherModem.driver.nbiotDriver.QBC32NbIoTDriver;
import cn.sendsms.otherModem.driver.nbiotDriver.SIM7020CNbIoTDriver;
import cn.sendsms.otherModem.driver.nbiotDriver.VirtualNbIoTDriver;
import cn.sendsms.otherModem.driver.nbiotDriver.XYM110NBIoTDriver;
import cn.sendsms.otherModem.nbiot.NbIoTDeviceInfoGetter;
import cn.sendsms.otherModem.nbiot.NbIoTMessageHolder;
import java.util.List;
import jssc.SerialPort;
import org.apache.log4j.Logger;

public abstract class NbIoTDriver
extends ModemDriver {
    public static final Logger log = Logger.getRootLogger();
    public static NbIoTDeviceInfoGetter nbiotDeviceInfoGetter = NbIoTDeviceInfoGetter.getInstance();
    public static NbIoTMessageHolder nbiotMessageHolder = NbIoTMessageHolder.getInstance();

    @Override
    public boolean startDevice(String portID) {
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(portID);
        SerialPort serialport = nbiotDeviceInfoGetter.getSerialPort(portID);
        if (!Utils.openPort(device.getBaudrate(), serialport)) {
            device.setUsingStatus("0");
            return false;
        }
        if (!this.isDeviceAT(serialport)) {
            log.error((Object)("\u8bbe\u5907\u3010" + device.getGatewayID() + "\u4e0dAT\uff01"));
            return false;
        }
        device.setAT(true);
        this.commandNotEcho(serialport);
        this.disconnectMQTTServer(serialport);
        if (!this.isNetworkNormal(serialport)) {
            log.error((Object)"\u7f51\u7edc\u5f02\u5e38\u3002\u3002\u3002");
            this.stopDevice(device.getPortID());
            return false;
        }
        device.setSignal(this.getSignal(serialport));
        if (!this.connectSucessed(portID)) {
            log.error((Object)"MQTT\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25...");
            this.stopDevice(device.getPortID());
            return false;
        }
        if (!device.getDeviceType().equals("SIM7020C") && "1".equals(device.getUsingStatus())) {
            log.info((Object)"\u5df2\u7ecf\u8ba2\u9605\u8fc7\uff0c\u4e0d\u518d\u91cd\u590d\u8ba2\u9605\uff01\u3010\u542f\u52a8\u3011");
            return true;
        }
        if (!device.getDeviceType().equals("XYM110") && "1".equals(device.getUsingStatus())) {
            log.info((Object)"\u5df2\u7ecf\u8ba2\u9605\u8fc7\uff0c\u4e0d\u518d\u91cd\u590d\u8ba2\u9605\uff01\u3010\u542f\u52a8\u3011");
            return true;
        }
        if (!this.subSucessed(portID)) {
            log.error((Object)"\u8ba2\u9605\u901a\u4fe1ID\u5931\u8d25...");
            this.stopDevice(device.getPortID());
            return false;
        }
        device.setUsingStatus("1");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restartDevice(String portID) {
        SerialPort serialport;
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(portID);
        if (device == null) {
            log.error((Object)("\u7aef\u53e3" + portID + "\u5bf9\u5e94 \u7684\u8bbe\u5907\u672a\u627e\u5230\u3002\u3002\u3002"));
            return false;
        }
        SerialPort serialPort = serialport = nbiotDeviceInfoGetter.getSerialPort(portID);
        synchronized (serialPort) {
            if (serialport == null) {
                log.error((Object)("\u7aef\u53e3" + portID + "\u672a\u627e\u5230\u3002\u3002\u3002"));
                return false;
            }
            Utils.closePort(serialport);
            if (!Utils.openPort(device.getBaudrate(), serialport)) {
                log.error((Object)("\u7aef\u53e3" + portID + "\u6253\u5f00\u5931\u8d25\u3002\u3002\u3002"));
                return false;
            }
            this.commandNotEcho(serialport);
            this.disconnectMQTTServer(serialport);
            this.initDevice(serialport);
            this.commandNotEcho(serialport);
            if (!this.isNetworkNormal(serialport)) {
                log.error((Object)"\u7f51\u7edc\u5f02\u5e38\u3002\u3002\u3002");
                return false;
            }
            device.setSignal(this.getSignal(serialport));
            if (!this.connectSucessed(portID)) {
                log.error((Object)"\u91cd\u542f\u8bbe\u5907\u65f6MQTT\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25");
                return false;
            }
            if (!device.getDeviceType().equals("SIM7020C") && "1".equals(device.getUsingStatus())) {
                log.info((Object)"\u5df2\u7ecf\u8ba2\u9605\u8fc7\uff0c\u4e0d\u518d\u91cd\u590d\u8ba2\u9605\uff01\u3010\u91cd\u8fde\u3011");
                return true;
            }
            if (!device.getDeviceType().equals("XYM110") && "1".equals(device.getUsingStatus())) {
                log.info((Object)"\u5df2\u7ecf\u8ba2\u9605\u8fc7\uff0c\u4e0d\u518d\u91cd\u590d\u8ba2\u9605\uff01\u3010\u91cd\u8fde\u3011");
                return true;
            }
            if (!this.subSucessed(portID)) {
                log.error((Object)"\u91cd\u542f\u8bbe\u5907\u65f6\u8ba2\u9605\u901a\u4fe1ID\u5931\u8d25:");
                return false;
            }
            device.setUsingStatus("1");
            return true;
        }
    }

    public abstract boolean connectSucessed(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stopDevice(String portID) {
        SerialPort serialport;
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(portID);
        if (device == null) {
            log.info((Object)("\u7aef\u53e3" + portID + "\u4e0d\u5b58\u5728\u3002\u3002\u3002"));
            return true;
        }
        SerialPort serialPort = serialport = nbiotDeviceInfoGetter.getSerialPort(portID);
        synchronized (serialPort) {
            if (serialport == null) {
                device.setUsingStatus("0");
                return true;
            }
            this.disconnectMQTTServer(serialport);
            if (Utils.closePort(serialport)) {
                device.setUsingStatus("0");
            } else if (!serialport.isOpened()) {
                log.info((Object)("\u7aef\u53e3" + portID + "\u5173\u95ed\u6210\u529f"));
                device.setUsingStatus("0");
            } else {
                log.error((Object)("\u7aef\u53e3" + portID + "\u5173\u95ed\u5931\u8d25"));
                device.setUsingStatus("1");
                return false;
            }
        }
        return true;
    }

    public abstract boolean isCompleteMessages(byte[] var1, NbIoTBean var2, List<String> var3, List<String> var4);

    public abstract String getCommunicationID(String var1);

    public abstract boolean sendMessage(String var1, String var2, NbIoTBean var3);

    public abstract void commandNotEcho(SerialPort var1);

    public abstract boolean subSucessed(String var1);

    public abstract void disconnectMQTTServer(SerialPort var1);

    public abstract boolean networkNormal(SerialPort var1);

    public abstract boolean initDevice(SerialPort var1);

    public abstract boolean isDeviceAT(SerialPort var1);

    public boolean isNetworkNormal(SerialPort serialPort) {
        boolean networkNormal = false;
        if (serialPort == null) {
            return networkNormal;
        }
        int retryTimes = 0;
        while (NbIoTDriver.serialportConnected(serialPort)) {
            if (this.networkNormal(serialPort)) {
                networkNormal = true;
                break;
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e2) {
                log.error((Object)"\u68c0\u6d4b\u7f51\u7edc\u65f6\uff0c\u7b49\u5f85\u88ab\u4e2d\u65ad\u4e86\u3002\u3002\u3002");
            }
            if (++retryTimes <= 10) continue;
            break;
        }
        return networkNormal;
    }

    public abstract void getCompleteMessages(byte[] var1, SerialPort var2, NbIoTBean var3, String var4);

    public static final NbIoTDriver getNbIoTDriver(String deviceType) {
        if (deviceType.equals("XYM110")) {
            return XYM110NBIoTDriver.getInstance();
        }
        if (deviceType.equals("SIM7020C")) {
            return SIM7020CNbIoTDriver.getInstance();
        }
        if (deviceType.equals("M5310-A")) {
            return M5310ANbIoTDriver.getInstance();
        }
        if (deviceType.equals("Quectel_BC26")) {
            return BC26NbIoTDriver.getInstance();
        }
        if (deviceType.equals("JD-VITUAL-NBIOT-DEVICE")) {
            return VirtualNbIoTDriver.getInstance();
        }
        if (deviceType.equals("Quectel_BC32-B8")) {
            return QBC32NbIoTDriver.getInstance();
        }
        return null;
    }

    public static boolean checkAT(SerialPort serialPort) {
        if (serialPort.getPortName().matches("Vitual-[0-9]+-COM")) {
            return true;
        }
        if (!NbIoTDriver.execAtCommand(null, serialPort, "AT\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e2) {
            log.info((Object)"\u7b49\u5f85AT\u54cd\u5e94\u65f6\u88ab\u6253\u65ad");
        }
        String response = ModemDriver.getStrResponse(serialPort, false, "", "UTF-8");
        if (response.indexOf("OK") != -1) {
            return true;
        }
        log.info((Object)("AT\u5f02\u5e38, \u8fd4\u56de:" + response));
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e3) {
            log.info((Object)"\u7b49\u5f85AT\u54cd\u5e94\u65f6\u88ab\u6253\u65ad");
        }
        if (!NbIoTDriver.execAtCommand(null, serialPort, "AT\r", "UTF-8")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e4) {
            log.info((Object)"\u7b49\u5f85AT\u54cd\u5e94\u65f6\u88ab\u6253\u65ad");
        }
        response = ModemDriver.getStrResponse(serialPort, false, "", "UTF-8");
        if (response.indexOf("OK") != -1) {
            return true;
        }
        log.info((Object)("AT\u5f02\u5e38, \u8fd4\u56de:" + response));
        return false;
    }

    public static String checkDeviceType(SerialPort serialPort) {
        if (serialPort.getPortName().matches("Vitual-[0-9]+-COM")) {
            return "JD-VITUAL-NBIOT-DEVICE";
        }
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        NbIoTDriver.execAtCommand(device, serialPort, "AT+CGMM\r", "UTF-8");
        String deviceType = ModemDriver.getStrResponse(serialPort, false, "\\S+OK", "UTF-8");
        deviceType = Utils.deleteSuffix(deviceType, "OK");
        deviceType = deviceType.replace("AT+CGMM", "");
        if (Utils.isEmptyStr(deviceType)) {
            return "";
        }
        return deviceType;
    }
}

