/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.modem;

import cn.sendsms.InboundMessage;
import cn.sendsms.Message;
import cn.sendsms.OutboundMessage;
import cn.sendsms.TmpMsg;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.otherModem.bean.NbIoTBean;
import cn.sendsms.otherModem.common.Const;
import cn.sendsms.otherModem.common.Utils;
import cn.sendsms.otherModem.driver.ModemDriver;
import cn.sendsms.otherModem.driver.nbiotDriver.NbIoTDriver;
import cn.sendsms.otherModem.modem.Modem;
import cn.sendsms.otherModem.nbiot.NbIoTDeviceInfoGetter;
import cn.sendsms.otherModem.nbiot.NbIoTMessageHolder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jssc.SerialPort;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Logger;

public class NbIoTModem
extends Modem {
    public static final Logger log = Logger.getRootLogger();
    public static NbIoTDeviceInfoGetter nbiotDeviceInfoGetter = NbIoTDeviceInfoGetter.getInstance();
    public static NbIoTMessageHolder nbiotMessageHolder = NbIoTMessageHolder.getInstance();
    private static int MESSAGE_TEXT_LENGTH = 80;
    public static HashMap<String, String> messageIDReceiveDeviceIDMap = new HashMap();
    public static HashMap<String, String> messageIDCodingTypeMap = new HashMap();
    public static HashMap<String, String> messageIDOReceiveDateMap = new HashMap();
    public static HashMap<String, String> messageIDExpectMessageNumMap = new HashMap();
    public static HashMap<String, HashSet<String>> messageIDSplitedMessagesMap = new HashMap();

    private NbIoTModem() {
    }

    public static NbIoTModem getInstance() {
        return a.a;
    }

    @Override
    public void sendMessage(OutboundMessage msg) {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        String usingPort = "";
        boolean publishSucess = true;
        usingPort = props.getString("settings.send_mode", "sync").equalsIgnoreCase("sync") ? nbiotDeviceInfoGetter.getPortIDByLoop(msg) : msg.getUsingPortID();
        NbIoTBean nbiotDevice = nbiotDeviceInfoGetter.findDeviceByPortID(usingPort);
        if (nbiotDevice == null) {
            return;
        }
        if ("".equals(usingPort)) {
            log.error((Object)"\u6ca1\u6709\u5df2\u7ecf\u542f\u7528\u7684NbIoT\u8bbe\u5907\u3002");
            return;
        }
        msg.setUsingPortID(usingPort);
        if (nbiotDeviceInfoGetter.checkStopNbIoT(usingPort)) {
            return;
        }
        if (!nbiotDeviceInfoGetter.checkAuthorizeInfo(usingPort, msg)) {
            return;
        }
        if ("2".equals(nbiotDevice.getUsingStatus())) {
            return;
        }
        msg.setGatewayId(nbiotDevice.getGatewayID());
        String text = msg.getText();
        Date date = msg.getDispatchDate();
        if (date == null) {
            date = new Date();
        }
        String recipient = msg.getRecipient();
        String dispatchDate = Utils.complementStrWithZero(Const.DATEFORMAT.format(date).trim(), 14);
        String originator = nbiotDeviceInfoGetter.getOriginator(usingPort);
        String codingType = nbiotMessageHolder.getCodingType(msg.getEncoding());
        if ("Quectel_BC26".equals(nbiotDevice.getDeviceType()) && "S".equals(codingType)) {
            log.error((Object)"Quectel_BC26\u4e0d\u652f\u6301\u76f4\u63a5\u53d1\u9001\u4e2d\u6587!");
            return;
        }
        int textLength = text.length();
        this.a(msg.getEncoding());
        int splitNumber = textLength / MESSAGE_TEXT_LENGTH;
        if (textLength % MESSAGE_TEXT_LENGTH != 0) {
            ++splitNumber;
        }
        int msgID = msg.getMessageID();
        if (textLength <= MESSAGE_TEXT_LENGTH) {
            String message;
            String messageIdentificationStr = this.a(msgID, 1, 1);
            String encodedText = text;
            if (!"SIM7020C".equals(nbiotDevice.getDeviceType()) && !"XYM110".equals(nbiotDevice.getDeviceType()) && !"Quectel_BC32-B8".equals(nbiotDevice.getDeviceType()) && "U".equals(codingType)) {
                encodedText = Utils.byteArr2HexStr(Utils.getByteArray(text));
            }
            if (publishSucess = this.a(recipient, message = messageIdentificationStr + originator + dispatchDate + codingType + Utils.complementStrWithZero(Integer.toHexString(Utils.getByteArray(encodedText).length), 3) + encodedText, nbiotDevice)) {
                log.info((Object)("\u8bbe\u5907" + nbiotDevice.getGatewayID() + "\u4fe1\u606f\u53d1\u9001\u6210\u529f\uff01ID\uff1a" + messageIdentificationStr + originator + dispatchDate + codingType));
            }
        } else {
            int serialNumber = 0;
            for (int startIndex = 0; startIndex < text.length(); startIndex += MESSAGE_TEXT_LENGTH) {
                String pieceOfText = "";
                String message = "";
                String encodedText = "";
                String messageIdentificationStr = this.a(msgID, splitNumber, ++serialNumber);
                pieceOfText = startIndex + MESSAGE_TEXT_LENGTH < textLength ? text.substring(startIndex, startIndex + MESSAGE_TEXT_LENGTH) : text.substring(startIndex, text.length());
                encodedText = pieceOfText;
                if (!"SIM7020C".equals(nbiotDevice.getDeviceType()) && !"XYM110".equals(nbiotDevice.getDeviceType()) && !"Quectel_BC32-B8".equals(nbiotDevice.getDeviceType()) && "U".equals(codingType)) {
                    encodedText = Utils.byteArr2HexStr(Utils.getByteArray(pieceOfText));
                }
                if (!(publishSucess = this.a(recipient, message = messageIdentificationStr + originator + dispatchDate + codingType + Utils.complementStrWithZero(Integer.toHexString(Utils.getByteArray(encodedText).length), 3) + encodedText, nbiotDevice))) break;
                log.info((Object)("\u8bbe\u5907" + nbiotDevice.getGatewayID() + "\u4fe1\u606f\u3010" + messageIdentificationStr + originator + dispatchDate + codingType + Utils.complementStrWithZero(Integer.toHexString(Utils.getByteArray(encodedText).length), 3) + pieceOfText + "\u3011\u53d1\u9001\u6210\u529f\uff01"));
            }
        }
        if (publishSucess) {
            msg.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
            nbiotDeviceInfoGetter.updateAvaliableNum(usingPort);
        } else {
            msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readNbIoTMessages() {
        List<NbIoTBean> nbiotDeviceList = nbiotDeviceInfoGetter.getUsingNbIoTs();
        for (int i2 = 0; i2 < nbiotDeviceList.size(); ++i2) {
            boolean checkResult;
            NbIoTBean device = nbiotDeviceList.get(i2);
            if ("0".equals(device.getUsingStatus()) || !(checkResult = nbiotDeviceInfoGetter.checkAuthorizeInfo(device.getPortID(), null)) || "2".equals(device.getUsingStatus())) continue;
            ArrayList<String> messageList = new ArrayList<String>();
            SerialPort serialPort = nbiotDeviceInfoGetter.getSerialPort(device.getPortID());
            if ("JD-VITUAL-NBIOT-DEVICE".equals(device.getDeviceType())) {
                if (nbiotMessageHolder.getMessageList(device) != null && !nbiotMessageHolder.getMessageList(device).isEmpty()) {
                    messageList.addAll(nbiotMessageHolder.getMessageList(device));
                    nbiotMessageHolder.clearMessageList(device);
                }
            } else {
                if (!NbIoTDriver.serialportConnected(serialPort)) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e2) {
                        log.info((Object)"\u7b49\u5f85\u7aef\u53e3\u72b6\u6001\u548c\u8bbe\u5907\u72b6\u6001\u540c\u6b65\u65f6\u88ab\u6253\u65ad...");
                    }
                    if ("1".equals(device.getUsingStatus())) {
                        log.error((Object)"\u8bbe\u5907\u8fde\u63a5\u5f02\u5e38\uff0c\u5373\u5c06\u91cd\u542f\uff01\u3010readNbIoTMessages\u3011");
                        device.setUsingStatus("2");
                    }
                }
                SerialPort e2 = serialPort;
                synchronized (e2) {
                    if (device.getDeviceType().equals("SIM7020C")) {
                        NbIoTDriver.getNbIoTDriver(device.getDeviceType()).getCompleteMessages(null, serialPort, device, "\u6536\u4fe1\u7ebf\u7a0b");
                    } else if (device.getDeviceType().equals("XYM110")) {
                        NbIoTDriver.getNbIoTDriver(device.getDeviceType()).getCompleteMessages(null, serialPort, device, "\u6536\u4fe1\u7ebf\u7a0b");
                    } else if (device.getDeviceType().equals("Quectel_BC32-B8")) {
                        NbIoTDriver.getNbIoTDriver(device.getDeviceType()).getCompleteMessages(null, serialPort, device, "\u6536\u4fe1\u7ebf\u7a0b");
                    } else {
                        byte[] messageByteArray = null;
                        messageByteArray = ModemDriver.getBytesResponse(serialPort, "UTF-8");
                        if (!(messageByteArray != null && messageByteArray.length != 0 || nbiotMessageHolder.getMessageList(device) != null && !nbiotMessageHolder.getMessageList(device).isEmpty())) {
                            log.info((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u6ca1\u6709\u6536\u5230\u4fe1\u606f\u3002\u3002\u3002"));
                            continue;
                        }
                        NbIoTDriver.getNbIoTDriver(device.getDeviceType()).getCompleteMessages(messageByteArray, serialPort, device, "\u6536\u4fe1\u7ebf\u7a0b");
                    }
                    if (nbiotMessageHolder.getMessageList(device) != null && !nbiotMessageHolder.getMessageList(device).isEmpty()) {
                        messageList.addAll(nbiotMessageHolder.getMessageList(device));
                        nbiotMessageHolder.clearMessageList(device);
                    }
                }
            }
            for (int j2 = 0; j2 < messageList.size(); ++j2) {
                String text = (String)messageList.get(j2);
                if (text == null || text.equals("")) continue;
                String receiveDevice = device.getGatewayID();
                String formattedReceiveDevice = Utils.complementStrWithSpace(receiveDevice, 15);
                InboundMessage msg = new InboundMessage(new Date(), "", text + formattedReceiveDevice, device.getGatewayID());
                nbiotMessageHolder.addMessage(msg);
                log.info((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u6536\u5230\u4fe1\u606f\u3010" + text + "\u3011"));
            }
        }
    }

    private void a(Message.MessageEncodings encoding) {
        switch (encoding) {
            case ENC7BIT: {
                MESSAGE_TEXT_LENGTH = 320;
                break;
            }
            case ENC8BIT: {
                MESSAGE_TEXT_LENGTH = 320;
                break;
            }
            case ENCUCS2: {
                MESSAGE_TEXT_LENGTH = 80;
                break;
            }
        }
    }

    private String a(int messageID, int splitNumber, int serialNumber) {
        String messageIDStr = Integer.toHexString(messageID);
        messageIDStr = Utils.complementStrWithZero(messageIDStr, 8);
        String splitNumberStr = Integer.toHexString(splitNumber);
        splitNumberStr = Utils.complementStrWithZero(splitNumberStr, 2);
        String serialNumberStr = Integer.toHexString(serialNumber);
        serialNumberStr = Utils.complementStrWithZero(serialNumberStr, 2);
        return messageIDStr + splitNumberStr + serialNumberStr;
    }

    public List<InboundMessage> getMessages(List<TmpMsg> tmpMsgList) {
        ArrayList<InboundMessage> msgList = new ArrayList<InboundMessage>();
        if (tmpMsgList == null || tmpMsgList.isEmpty()) {
            return msgList;
        }
        for (int i2 = 0; i2 < tmpMsgList.size(); ++i2) {
            try {
                TmpMsg tmpMsg = tmpMsgList.get(i2);
                if (tmpMsg.getMemindex() != 0 || Utils.isEmptyStr(tmpMsg.getMemlocation()) || !"NB".equals(tmpMsg.getMemlocation()) || tmpMsg.getMl() != 0) continue;
                String text = tmpMsg.getPdustring();
                String receiveDevice = "";
                String messageID = "";
                String sliceNumStr = "";
                String currentSliceNumStr = "";
                String originator = "";
                String sendDateStr = "";
                String encodingType = "";
                try {
                    receiveDevice = text.substring(text.length() - 15, text.length()).trim();
                    text = text.substring(0, text.length() - 15);
                    messageID = text.substring(0, 8);
                    text = text.substring(8);
                    sliceNumStr = text.substring(0, 2);
                    text = text.substring(2);
                    currentSliceNumStr = text.substring(0, 2);
                    text = text.substring(2);
                    originator = text.substring(0, 8);
                    text = text.substring(8);
                    sendDateStr = text.substring(0, 14);
                    text = text.substring(14);
                    encodingType = text.substring(0, 1);
                    text = text.substring(1);
                    text = currentSliceNumStr + text.substring(3);
                }
                catch (Exception e2) {
                    log.info((Object)("\u4fe1\u606f\u3010" + tmpMsg.getPdustring() + "\u3011\u683c\u5f0f\u5f02\u5e38..\u3002"), (Throwable)e2);
                    Utils.deleteTmpmsg(tmpMsg.getPdustring(), "NB");
                    continue;
                }
                String messageKey = messageID + originator;
                if (!messageIDReceiveDeviceIDMap.containsKey(messageKey)) {
                    messageIDReceiveDeviceIDMap.put(messageKey, receiveDevice);
                }
                if (!messageIDCodingTypeMap.containsKey(messageKey)) {
                    messageIDCodingTypeMap.put(messageKey, encodingType);
                }
                if (!messageIDOReceiveDateMap.containsKey(messageKey)) {
                    messageIDOReceiveDateMap.put(messageKey, sendDateStr);
                }
                if (!messageIDExpectMessageNumMap.containsKey(messageKey)) {
                    messageIDExpectMessageNumMap.put(messageKey, sliceNumStr);
                }
                if (messageIDSplitedMessagesMap.containsKey(messageKey)) {
                    messageIDSplitedMessagesMap.get(messageKey).add(text);
                    continue;
                }
                HashSet<String> messageSet = new HashSet<String>();
                messageSet.add(text);
                messageIDSplitedMessagesMap.put(messageKey, messageSet);
                continue;
            }
            catch (Exception e3) {
                log.info((Object)"\u4e34\u65f6\u8868\u4fe1\u606f\u683c\u5f0f\u5f02\u5e38\uff01", (Throwable)e3);
            }
        }
        if (messageIDSplitedMessagesMap.isEmpty()) {
            return msgList;
        }
        Iterator<Map.Entry<String, HashSet<String>>> iter = messageIDSplitedMessagesMap.entrySet().iterator();
        while (iter.hasNext() && !messageIDExpectMessageNumMap.isEmpty()) {
            try {
                Map.Entry<String, HashSet<String>> entry = iter.next();
                String messageKey = entry.getKey();
                HashSet<String> messageSet = entry.getValue();
                int splitNumber = Integer.valueOf(messageIDExpectMessageNumMap.get(messageKey), 16);
                InboundMessage msg = new InboundMessage(messageKey);
                msg.setError(false);
                if (messageSet.size() != splitNumber) {
                    long hours;
                    if (!messageIDOReceiveDateMap.containsKey(messageKey)) continue;
                    Date startReceiveDate = Const.DATEFORMAT.parse(messageIDOReceiveDateMap.get(messageKey));
                    Date now = new Date();
                    int diffhours = 5;
                    try {
                        diffhours = Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.recvdiff", "5"));
                    }
                    catch (Exception e4) {
                        log.error((Object)"\u3010settings.recvdiff\u3011\u8bbe\u5b9a\u5f02\u5e38\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c\uff1a5\uff08\u5c0f\u65f6\uff09\u3002");
                    }
                    if ((hours = (now.getTime() - startReceiveDate.getTime()) / 3600000L) <= (long)diffhours) continue;
                    msg.setError(true);
                    msgList.add(msg);
                    continue;
                }
                msgList.add(msg);
            }
            catch (Exception e5) {
                log.info((Object)"\u4e34\u65f6\u8868\u4fe1\u606f\u5206\u6790\u5f02\u5e38\uff01", (Throwable)e5);
            }
        }
        Iterator<InboundMessage> iters = msgList.iterator();
        while (iters.hasNext()) {
            try {
                InboundMessage msg = iters.next();
                String messageKey = msg.getMessageID();
                String messageID = messageKey.substring(0, 8);
                String originator = messageKey.substring(8);
                this.a(messageIDSplitedMessagesMap.get(messageKey), msg, (int)Integer.valueOf(messageIDExpectMessageNumMap.get(messageKey), 16));
                msg.setGatewayId(messageIDReceiveDeviceIDMap.get(messageKey));
                msg.setEncoding(NbIoTMessageHolder.getInstance().getCodingType(messageIDCodingTypeMap.get(messageKey)));
                msg.setOriginator(originator);
                msg.setDate(Const.DATEFORMAT.parse(messageIDOReceiveDateMap.get(messageKey)));
                msg.setMessageID(messageID);
                log.info((Object)("inmsg: " + messageID + "-" + originator));
            }
            catch (Exception e6) {
                log.info((Object)"\u4e34\u65f6\u8868\u4fe1\u606f\u6574\u5408\u5f02\u5e38\uff01", (Throwable)e6);
            }
        }
        this.a();
        return msgList;
    }

    private void a(HashSet<String> hashSet, InboundMessage msg, int numberOfSlices) {
        ArrayList<String> messageList = Utils.getEmptyList(numberOfSlices);
        for (String message : hashSet) {
            String currentNumberOfSlicesInHexStr = message.substring(0, 2);
            int currentNumberOfSlices = Integer.valueOf(currentNumberOfSlicesInHexStr, 16);
            message = message.substring(2);
            messageList.set(currentNumberOfSlices - 1, message);
        }
        StringBuffer buffer = new StringBuffer();
        for (int i2 = 0; i2 < messageList.size(); ++i2) {
            if (Utils.isEmptyStr(messageList.get(i2))) {
                buffer.append("*****");
                continue;
            }
            buffer.append(messageList.get(i2));
        }
        msg.setText(buffer.toString());
    }

    private void a() {
        messageIDReceiveDeviceIDMap.clear();
        messageIDCodingTypeMap.clear();
        messageIDOReceiveDateMap.clear();
        messageIDExpectMessageNumMap.clear();
        messageIDSplitedMessagesMap.clear();
    }

    private boolean a(String recipient, String text, NbIoTBean nbiotDevice) {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        boolean sendSucess = true;
        int retryTimes = props.getInt("settings.nbiot_resend_times", 5);
        int loop = 0;
        while (!(sendSucess = NbIoTDriver.getNbIoTDriver(nbiotDevice.getDeviceType()).sendMessage(recipient, text, nbiotDevice))) {
            if (!nbiotDeviceInfoGetter.isNbIoTUsing(nbiotDevice.getPortID())) {
                log.info((Object)("\u8bbe\u5907" + nbiotDevice.getGatewayID() + "\u72b6\u6001\u4e3a\u3010" + nbiotDevice.getUsingStatus() + "\u3011\uff0c\u53d1\u9001\u5931\u8d25\u3002\u3002"));
                sendSucess = false;
                break;
            }
            if (++loop >= retryTimes) {
                sendSucess = false;
                log.info((Object)("\u8bbe\u5907" + nbiotDevice.getGatewayID() + "\u4fe1\u606f\u53d1\u9001\u5931\u8d25..."));
                if (!"1".equals(nbiotDevice.getUsingStatus())) break;
                log.error((Object)"\u8bbe\u5907\u8fde\u63a5\u5f02\u5e38\uff0c\u5373\u5c06\u91cd\u542f\uff01\u3010\u53d1\u9001\u5931\u8d25\u6b21\u6570\u8fc7\u591a\u3011");
                nbiotDevice.setUsingStatus("2");
                break;
            }
            try {
                Thread.sleep(retryTimes * 1000);
            }
            catch (InterruptedException e2) {
                log.error((Object)"\u7b49\u5f85\u53d1\u9001\u4fe1\u606f\u88ab\u6253\u65ad\uff081\uff09\u3002\u3002");
            }
        }
        int waitTimes = props.getInt("settings.nbiot_outbound_slip_interval", 2);
        try {
            Thread.sleep(waitTimes * 1000);
        }
        catch (InterruptedException e3) {
            log.error((Object)"\u7b49\u5f85\u53d1\u9001\u4fe1\u606f\u88ab\u6253\u65ad\uff082\uff09\u3002\u3002");
        }
        return sendSucess;
    }

    private static class a {
        private static NbIoTModem a = new NbIoTModem();

        private a() {
        }
    }
}

