/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.util;

import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.web.Condition;
import cn.sendsms.jdsmsserver.web.InMessage;
import cn.sendsms.jdsmsserver.web.OutMessage;
import cn.sendsms.jdsmsserver.web.User;
import cn.sendsms.util.FileManager;
import cn.sendsms.util.SysConts;
import cn.sendsms.util.UserAddrBook;
import cn.sendsms.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jxl.Workbook;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

public class GetFile {
    public static void getfile(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String format;
        String showsuball;
        String folderid;
        String path = "";
        String AllFileName = null;
        long lStartPos = 0L;
        boolean bDeleteFile = false;
        String qs = request.getQueryString();
        String sURI = request.getRequestURI();
        String filename = "";
        try {
            int lIndex;
            if (sURI != null && !qs.equals("") && (lIndex = qs.indexOf("filename=/")) != -1) {
                filename = qs.substring(lIndex + 10);
                filename = Util.encodeURL(filename, "GBK");
            }
        }
        catch (Exception lIndex) {
            // empty catch block
        }
        String orgFname = Util.getURLLastName(request.getRequestURI());
        String fname = URLDecoder.decode(orgFname, "GBK");
        String fisoname = URLDecoder.decode(orgFname, "GBK");
        String ContenttypeName = fname;
        String type = "gf";
        String foldertype = request.getParameter("foldertype");
        if (foldertype == null) {
            foldertype = "personal";
        }
        if ((folderid = request.getParameter("folderid")) == null) {
            folderid = "/";
        }
        if ((showsuball = request.getParameter("showsuball")) == null) {
            showsuball = "false";
        }
        if ((format = request.getParameter("format")) == null) {
            format = "xml";
        }
        String strTempFile = JDSMSServer.getInstance().getServerTempFile();
        User user = (User)request.getSession(true).getAttribute("user");
        UserAddrBook uab = user.getAddrBook();
        if (format.equals("xml")) {
            String charset = request.getParameter("charset");
            if (charset == null) {
                charset = "GBK";
            }
            if (foldertype.equals("public")) {
                uab.m_PublicAddress.outputOutlook(strTempFile, charset, folderid, showsuball);
            } else {
                uab.m_PersonalAddress.outputOutlook(strTempFile, charset, folderid, showsuball);
            }
            path = JDSMSServer.getInstance().getServerTempPath();
            AllFileName = strTempFile;
            ContenttypeName = fisoname = "address.xml";
        } else if (format.equals("csv")) {
            String strMap = "name|\u59d3\u540d|email|\u7535\u5b50\u90ae\u4ef6\u5730\u5740|telephone|\u4e1a\u52a1\u7535\u8bdd|postalcode|\u516c\u53f8\u6240\u5728\u5730\u7684\u90ae\u653f\u7f16\u7801|address|\u529e\u516c\u5730\u70b9|employment|\u804c\u52a1|organization|\u516c\u53f8|department|\u90e8\u95e8";
            String charset = request.getParameter("charset");
            if (charset == null) {
                charset = "GBK";
            }
            if (foldertype.equals("public")) {
                uab.m_PublicAddress.outputOutlook(strTempFile, charset, strMap, folderid, showsuball);
            } else {
                uab.m_PersonalAddress.outputOutlook(strTempFile, charset, strMap, folderid, showsuball);
            }
            path = JDSMSServer.getInstance().getServerTempPath();
            AllFileName = strTempFile;
            ContenttypeName = fisoname = "address.csv";
        }
        lStartPos = 0L;
        if (AllFileName == null) {
            AllFileName = path + SysConts.FILE_SEPARATOR + fname;
        }
        FileManager.GetFile(type, path, AllFileName, fisoname, request, response, ContenttypeName, lStartPos);
    }

    public static void exportFile(HttpServletResponse response, HttpServletRequest request, File file, boolean isDel) throws IOException {
        ServletOutputStream out = null;
        FileInputStream in = null;
        String filename = URLEncoder.encode(file.getName(), "UTF-8");
        response.setContentType("application/force-download");
        response.setHeader("Location", filename);
        response.setHeader("Content-Disposition", "attachment;filename=" + filename);
        out = response.getOutputStream();
        in = new FileInputStream(file.getPath());
        byte[] buffer = new byte[1024];
        int i2 = -1;
        while ((i2 = ((InputStream)in).read(buffer)) != -1) {
            out.write(buffer, 0, i2);
        }
        out.flush();
        ((InputStream)in).close();
        out.close();
        if (isDel) {
            file.delete();
        }
    }

    public static void writeExcel(OutputStream os, String[] title, List lists) throws IOException, RowsExceededException, WriteException {
        WritableWorkbook wwb = Workbook.createWorkbook((OutputStream)os);
        int sheetNum = 1;
        int recNum = 0;
        int sheetSize = 10000;
        do {
            int rowNum = 0;
            String sheetName = "Sheet" + sheetNum;
            WritableSheet ws = wwb.createSheet(sheetName, sheetNum);
            ++sheetNum;
            WritableCellFormat format = new WritableCellFormat(NumberFormats.TEXT);
            for (int i2 = 0; i2 < title.length; ++i2) {
                ws.setColumnView(i2, 30);
                ws.addCell((WritableCell)new Label(i2, rowNum, title[i2], (CellFormat)format));
            }
            ++rowNum;
            if (lists.isEmpty()) continue;
            int sheetRecNum = 0;
            int i3 = recNum;
            while (i3 < lists.size() && sheetRecNum < sheetSize) {
                List row = (List)lists.get(i3);
                for (int j2 = 0; j2 < row.size(); ++j2) {
                    ws.addCell((WritableCell)new Label(j2, rowNum, row.get(j2).toString(), (CellFormat)format));
                }
                ++i3;
                ++recNum;
                ++rowNum;
                ++sheetRecNum;
            }
        } while (recNum < lists.size());
        wwb.write();
        wwb.close();
        os.close();
    }

    public static void getSMSFile(HttpServletRequest req, HttpServletResponse resp, List msgList, Condition condition) throws IOException {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String filename = sdf.format(date);
        String strTempFile = JDSMSServer.getInstance().getServerTempPath();
        File f2 = new File(strTempFile + "\\" + filename + ".xls");
        f2.createNewFile();
        try {
            if (condition.getType() == 3) {
                GetFile.getInSMSFile(req, resp, msgList, f2);
            } else {
                GetFile.getOutSMSFile(req, resp, msgList, f2);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        GetFile.exportFile(resp, req, f2, true);
    }

    public static void getOutSMSFile(HttpServletRequest req, HttpServletResponse resp, List msgList, File f2) throws IOException, RowsExceededException, WriteException {
        String[] title = new String[]{"ID", "\u72b6\u6001", "\u64cd\u4f5c\u5458\u4ee3\u7801", "\u53d1\u9001\u65f6\u95f4", "\u5185\u5bb9", "\u53d1\u9001\u76ee\u6807", "\u7aef\u53e3", "\u7c7b\u578b"};
        ArrayList lists = new ArrayList();
        for (int i2 = 0; i2 < msgList.size(); ++i2) {
            ArrayList<Object> tempList = new ArrayList<Object>();
            String mediaStr = "";
            OutMessage msg = (OutMessage)msgList.get(i2);
            tempList.add(msg.getId());
            switch (msg.getStatus()) {
                case 'S': {
                    mediaStr = "\u6210\u529f";
                    break;
                }
                case 'F': {
                    mediaStr = "\u5931\u8d25";
                }
            }
            tempList.add(mediaStr);
            tempList.add(msg.getUserId());
            tempList.add(msg.getCreateTime());
            tempList.add(msg.getContent());
            if (msg.getName().trim().equals("")) {
                tempList.add(msg.getRecipient());
            } else {
                tempList.add(msg.getName() + "(" + msg.getRecipient() + ")");
            }
            mediaStr = "*".equals(msg.getGateway_id().trim()) ? "*(\u81ea\u52a8\u9009\u62e9)" : msg.getGateway_id();
            tempList.add(mediaStr);
            switch (msg.getType()) {
                case 'O': {
                    mediaStr = "\u666e\u901a";
                    break;
                }
                case 'W': {
                    mediaStr = "WAP";
                }
            }
            tempList.add(mediaStr);
            lists.add(tempList);
        }
        GetFile.writeExcel(new FileOutputStream(f2), title, lists);
    }

    public static void getInSMSFile(HttpServletRequest req, HttpServletResponse resp, List msgList, File f2) throws IOException, RowsExceededException, WriteException {
        String[] title = new String[]{"ID", "\u77ed\u4fe1\u6765\u6e90", "\u5185\u5bb9", "\u53d1\u9001\u65f6\u95f4", "\u63a5\u6536\u65f6\u95f4", "\u7aef\u53e3"};
        ArrayList lists = new ArrayList();
        for (int i2 = 0; i2 < msgList.size(); ++i2) {
            ArrayList<Object> tempList = new ArrayList<Object>();
            InMessage msg = (InMessage)msgList.get(i2);
            tempList.add(msg.getId());
            if (msg.getName().trim().equals("")) {
                tempList.add(msg.getOriginator());
            } else {
                tempList.add(msg.getName() + "(" + msg.getOriginator() + ")");
            }
            tempList.add(msg.getContent());
            tempList.add(msg.getMsgDate());
            tempList.add(msg.getRecvDate());
            tempList.add(msg.getGateway_id());
            lists.add(tempList);
        }
        GetFile.writeExcel(new FileOutputStream(f2), title, lists);
    }
}

