/*
 * Decompiled with CFR 0.152.
 */
package cn.ajwcc.pduUtils.gsm3040;

import cn.ajwcc.pduUtils.gsm3040.PduUtils;
import cn.ajwcc.pduUtils.gsm3040.ie.ConcatInformationElement;
import cn.ajwcc.pduUtils.gsm3040.ie.InformationElement;
import cn.ajwcc.pduUtils.gsm3040.ie.PortInformationElement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;

public abstract class Pdu {
    private int a;
    private int b;
    private String c;
    private int d = 0;
    private int e = 0;
    private int f = 0;
    private int g;
    private String h;
    private int i;
    private byte[] j;
    private static final int UDH_CHECK_MODE_ADD_IF_NONE = 0;
    private static final int UDH_CHECK_MODE_EXCEPTION_IF_NONE = 1;
    private static final int UDH_CHECK_MODE_IGNORE_IF_NONE = 2;
    private HashMap<Integer, InformationElement> k = new HashMap();
    private ArrayList<InformationElement> l = new ArrayList();
    private String m;
    private byte[] n;
    private String o;

    public int getSmscInfoLength() {
        return this.a;
    }

    public void setSmscInfoLength(int smscInfoLength) {
        this.a = smscInfoLength;
    }

    public void setSmscAddressType(int smscAddressType) {
        this.b = PduUtils.createAddressType(smscAddressType);
    }

    public int getSmscAddressType() {
        return this.b;
    }

    public void setSmscAddress(String smscAddress) {
        if (smscAddress.equals("")) {
            this.c = null;
            this.b = 0;
            this.a = 0;
            return;
        }
        this.c = smscAddress.startsWith("+") ? smscAddress.substring(1) : smscAddress;
    }

    public String getSmscAddress() {
        return this.c;
    }

    public int getFirstOctet() {
        return this.d;
    }

    public void setFirstOctet(int value) {
        this.d = value;
    }

    protected void setFirstOctetField(int fieldName, int fieldValue, int[] allowedValues) {
        for (int i2 = 0; i2 < allowedValues.length; ++i2) {
            if (allowedValues[i2] != fieldValue) continue;
            this.d &= fieldName;
            this.d |= fieldValue;
            return;
        }
        throw new RuntimeException("Invalid value for fieldName.");
    }

    protected int getFirstOctetField(int fieldName) {
        return this.d & ~fieldName;
    }

    protected void checkTpMti(int allowedType) {
        int tpMti = this.getTpMti();
        if (tpMti != allowedType) {
            throw new RuntimeException("Invalid message type : " + this.getTpMti());
        }
    }

    protected void checkTpMti(int[] allowedTypes) {
        int tpMti = this.getTpMti();
        for (int i2 = 0; i2 < allowedTypes.length; ++i2) {
            if (tpMti != allowedTypes[i2]) continue;
            return;
        }
        throw new RuntimeException("Invalid message type : " + this.getTpMti());
    }

    public void setTpMti(int value) {
        this.setFirstOctetField(252, value, new int[]{0, 2, 1});
    }

    public int getTpMti() {
        return this.getFirstOctetField(252);
    }

    public void setTpUdhi(int value) {
        this.setFirstOctetField(191, value, new int[]{0, 64});
    }

    public boolean hasTpUdhi() {
        return this.getFirstOctetField(191) == 64;
    }

    public void setProtocolIdentifier(int protocolIdentifier) {
        this.e = protocolIdentifier;
    }

    public int getProtocolIdentifier() {
        return this.e;
    }

    public void setDataCodingScheme(int encoding) {
        switch (encoding & 0xFFFFFF0C) {
            case 0: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new RuntimeException("Invalid encoding value: " + PduUtils.byteToPdu(encoding));
            }
        }
        this.f = encoding;
    }

    public int getDataCodingScheme() {
        return this.f;
    }

    public int getAddressType() {
        return this.g;
    }

    public void setAddressType(int addressType) {
        this.g = PduUtils.createAddressType(addressType);
    }

    public void setAddress(String address) {
        if (address == null) {
            throw new RuntimeException("SendSMS internal error: <address> is null!");
        }
        this.h = address.startsWith("+") ? address.substring(1) : address;
        this.setAddressType(PduUtils.getAddressTypeFor(address));
    }

    public String getAddress() {
        return this.h;
    }

    public int getUDLength() {
        return this.i;
    }

    public void setUDLength(int udLength) {
        this.i = udLength;
    }

    public byte[] getUDData() {
        return this.j;
    }

    public void setUDData(byte[] udData) {
        this.j = udData;
    }

    private void a(int udhCheckMode) {
        if (!this.hasTpUdhi()) {
            switch (udhCheckMode) {
                case 1: {
                    throw new IllegalStateException("PDU does not have a UDHI in the first octet");
                }
                case 0: {
                    this.setTpUdhi(64);
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid UDH check mode");
                }
            }
        }
    }

    public int getTotalUDHLength() {
        int udhLength = this.getUDHLength();
        if (udhLength == 0) {
            return 0;
        }
        return udhLength + 1;
    }

    public int getUDHLength() {
        int udhLength = 0;
        for (InformationElement entry : this.k.values()) {
            udhLength = udhLength + entry.getLength() + 2;
        }
        Iterator<InformationElement> iterator = null;
        return udhLength;
    }

    public byte[] getUDHData() {
        this.a(2);
        int totalUdhLength = this.getTotalUDHLength();
        if (totalUdhLength == 0) {
            return null;
        }
        byte[] retVal = new byte[totalUdhLength];
        System.arraycopy(this.j, 0, retVal, 0, totalUdhLength);
        return retVal;
    }

    public void addInformationElement(InformationElement ie) {
        this.a(0);
        this.k.put(ie.getIdentifier(), ie);
        this.l.add(ie);
    }

    public InformationElement getInformationElement(int iei) {
        this.a(2);
        return this.k.get(iei);
    }

    public Iterator<InformationElement> getInformationElements() {
        this.a(2);
        return this.l.iterator();
    }

    public boolean isConcatMessage() {
        return this.getConcatInfo() != null;
    }

    public ConcatInformationElement getConcatInfo() {
        this.a(2);
        ConcatInformationElement concat = (ConcatInformationElement)this.getInformationElement(0);
        if (concat == null) {
            concat = (ConcatInformationElement)this.getInformationElement(8);
        }
        return concat;
    }

    public int getMpRefNo() {
        ConcatInformationElement concat = this.getConcatInfo();
        if (concat != null) {
            return concat.getMpRefNo();
        }
        return 0;
    }

    public int getMpMaxNo() {
        ConcatInformationElement concat = this.getConcatInfo();
        if (concat != null) {
            return concat.getMpMaxNo();
        }
        return 1;
    }

    public int getMpSeqNo() {
        ConcatInformationElement concat = this.getConcatInfo();
        if (concat != null) {
            return concat.getMpSeqNo();
        }
        return 0;
    }

    public boolean isPortedMessage() {
        return this.a() != null;
    }

    private PortInformationElement a() {
        this.a(2);
        return (PortInformationElement)this.getInformationElement(5);
    }

    public int getDestPort() {
        PortInformationElement portIe = this.a();
        if (portIe == null) {
            return -1;
        }
        return portIe.getDestPort();
    }

    public int getSrcPort() {
        PortInformationElement portIe = this.a();
        if (portIe == null) {
            return -1;
        }
        return portIe.getSrcPort();
    }

    public void setDataBytes(byte[] dataBytes) {
        this.n = dataBytes;
        this.m = null;
    }

    public byte[] getDataBytes() {
        return this.n;
    }

    public boolean isBinary() {
        return ((this.f & 0xF0) == 240 || (this.f & 4) == 4) && (this.f & 4) == 4;
    }

    public void setDecodedText(String decodedText) {
        this.m = decodedText;
        this.n = null;
        boolean flash = false;
        if (PduUtils.extractDcsFlash(this.f) == 16) {
            flash = true;
        }
        this.f &= 0xF;
        if (flash) {
            this.f |= 0x10;
        }
    }

    public String getDecodedText() {
        if (this.m != null) {
            return this.m;
        }
        if (this.j == null) {
            throw new NullPointerException("No udData to decode");
        }
        try {
            return this.b();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public byte[] getUserDataAsBytes() {
        int remainingLength = this.j.length - this.getTotalUDHLength();
        byte[] retVal = new byte[remainingLength];
        System.arraycopy(this.j, this.getTotalUDHLength(), retVal, 0, remainingLength);
        return retVal;
    }

    private String b() {
        switch (PduUtils.extractDcsEncoding(this.getDataCodingScheme())) {
            case 0: {
                return PduUtils.decode7bitEncoding(this.getUDHData(), this.j);
            }
            case 4: {
                return PduUtils.byteArr2HexStr(this.getUDHData(), this.j);
            }
            case 8: {
                return PduUtils.decodeUcs2Encoding(this.getUDHData(), this.j);
            }
        }
        throw new RuntimeException("Invalid dataCodingScheme: " + this.getDataCodingScheme());
    }

    public String getRawPdu() {
        return this.o;
    }

    public void setRawPdu(String rawPdu) {
        this.o = rawPdu;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("=================================================\n");
        sb.append("<< " + this.getClass().getSimpleName() + " >>");
        sb.append("\n");
        sb.append("Raw Pdu: ");
        sb.append(this.o);
        sb.append("\n");
        sb.append("\n");
        if (this.c != null) {
            sb.append("SMSC Address: [Length: " + this.getSmscInfoLength() + " (" + PduUtils.byteToPdu((byte)this.getSmscInfoLength()) + ") octets");
            sb.append(", Type: " + PduUtils.byteToPdu(this.b) + " (" + PduUtils.byteToBits((byte)this.b) + ")");
            sb.append(", Address: " + this.c);
            sb.append("]");
        } else {
            sb.append("SMSC Address: [Length: 0 octets]");
        }
        sb.append("\n");
        sb.append(PduUtils.decodeFirstOctet(this));
        String subclassInfo = this.pduSubclassInfo();
        if (subclassInfo != null) {
            sb.append(subclassInfo);
        }
        sb.append("\n");
        if (this.j != null) {
            switch (PduUtils.extractDcsEncoding(this.getDataCodingScheme())) {
                case 0: {
                    sb.append("User Data Length: " + this.getUDLength() + " (" + PduUtils.byteToPdu(this.getUDLength()) + ") septets");
                    sb.append("\n");
                    break;
                }
                case 4: 
                case 8: {
                    sb.append("User Data Length: " + this.getUDLength() + " (" + PduUtils.byteToPdu(this.getUDLength()) + ") octets");
                    sb.append("\n");
                }
            }
            sb.append("User Data (pdu) : " + PduUtils.bytesToPdu(this.getUDData()));
            sb.append("\n");
            if (this.hasTpUdhi()) {
                sb.append("User Data Header (pdu) : " + PduUtils.bytesToPdu(this.getUDHData()));
                sb.append("\n");
                int udhLength = this.getUDHLength();
                sb.append("User Data Header Length: " + udhLength + " (" + PduUtils.byteToPdu(udhLength) + ") octets");
                sb.append("\n");
                sb.append("\n");
                sb.append("UDH Information Elements:\n");
                Iterator<InformationElement> iterator = this.k.values().iterator();
                while (iterator.hasNext()) {
                    sb.append(iterator.next().toString());
                    sb.append("\n");
                }
                iterator = null;
                sb.append("\n");
                sb.append("Non UDH Data (pdu)    : " + PduUtils.bytesToPdu(this.getUserDataAsBytes()));
                sb.append("\n");
                if (!this.isBinary()) {
                    sb.append("Non UDH Data (decoded): [" + this.getDecodedText() + "]");
                    sb.append("\n");
                }
            } else if (!this.isBinary()) {
                sb.append("User Data (decoded): [" + this.getDecodedText() + "]");
                sb.append("\n");
            }
        }
        sb.append("=================================================\n");
        return sb.toString();
    }

    protected String pduSubclassInfo() {
        return null;
    }

    protected String formatTimestamp(Calendar timestamp) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("EEE dd-MMM-yyyy HH:mm:ss z");
        sdf.setTimeZone(timestamp.getTimeZone());
        return sdf.format(timestamp.getTime());
    }
}

