/*
 * Decompiled with CFR 0.152.
 */
package cn.ajwcc.pduUtils.gsm3040;

import cn.ajwcc.pduUtils.gsm3040.Pdu;
import cn.ajwcc.pduUtils.gsm3040.PduFactory;
import cn.ajwcc.pduUtils.gsm3040.PduUtils;
import cn.ajwcc.pduUtils.gsm3040.SmsDeliveryPdu;
import cn.ajwcc.pduUtils.gsm3040.SmsStatusReportPdu;
import cn.ajwcc.pduUtils.gsm3040.SmsSubmitPdu;
import cn.ajwcc.pduUtils.gsm3040.ie.InformationElement;
import cn.ajwcc.pduUtils.gsm3040.ie.InformationElementFactory;
import java.util.Calendar;

public class PduParser {
    private int a;
    private byte[] b;

    private int a() {
        int retVal = this.b[this.a] & 0xFF;
        ++this.a;
        return retVal;
    }

    private int b() {
        int data = this.a();
        data = PduUtils.swapNibbles((byte)data);
        int retVal = 0;
        retVal += (data >>> 4 & 0xF) * 10;
        return retVal += data & 0xF;
    }

    private Calendar c() {
        int year = this.b();
        int month = this.b();
        int day = this.b();
        int hour = this.b();
        int minute = this.b();
        int second = this.b();
        int timestamp = this.a();
        boolean negative = (timestamp & 8) == 8;
        int timezone = PduUtils.swapNibbles(timestamp) & 0x7F;
        Calendar cal = Calendar.getInstance();
        cal.set(1, year + 2000);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        return cal;
    }

    private String a(int addressLength, int addressType) {
        if (addressLength > 0) {
            int addressDataOctetLength = addressLength / 2 + (addressLength % 2 == 1 ? 1 : 0);
            byte[] addressData = new byte[addressDataOctetLength];
            System.arraycopy(this.b, this.a, addressData, 0, addressDataOctetLength);
            this.a += addressDataOctetLength;
            switch (PduUtils.extractAddressType(addressType)) {
                case 80: {
                    return this.a(addressLength, PduUtils.decode7bitEncoding(addressData));
                }
            }
            return PduUtils.readBCDNumbers(addressLength, addressData);
        }
        return null;
    }

    private int d() {
        int validity = this.a();
        int minutes = 0;
        if (validity > 0 && validity <= 143) {
            minutes = (validity + 1) * 5;
        } else if (validity > 143 && validity <= 167) {
            minutes = 720 + (validity - 143) * 30;
        } else if (validity > 167 && validity <= 196) {
            minutes = (validity - 166) * 24 * 60;
        } else if (validity > 197 && validity <= 255) {
            minutes = (validity - 192) * 7 * 24 * 60;
        }
        return minutes;
    }

    public Pdu parsePdu(String rawPdu) {
        this.b = PduUtils.pduToBytes(rawPdu);
        this.a = 0;
        Pdu pdu = this.e();
        pdu.setRawPdu(rawPdu);
        switch (pdu.getTpMti()) {
            case 0: {
                this.a((SmsDeliveryPdu)pdu);
                break;
            }
            case 1: {
                this.a((SmsSubmitPdu)pdu);
                break;
            }
            case 2: {
                this.a((SmsStatusReportPdu)pdu);
            }
        }
        return pdu;
    }

    private Pdu e() {
        int addressLength = this.a();
        Pdu pdu = null;
        if (addressLength > 0) {
            int addressType = this.a();
            String smscAddress = this.a((addressLength - 1) * 2, addressType);
            int firstOctet = this.a();
            pdu = PduFactory.createPdu(firstOctet);
            pdu.setSmscAddressType(addressType);
            pdu.setSmscAddress(smscAddress);
            pdu.setSmscInfoLength(addressLength);
        } else {
            int firstOctet = this.a();
            pdu = PduFactory.createPdu(firstOctet);
        }
        return pdu;
    }

    private void a(Pdu pdu) {
        int udLength = this.a();
        pdu.setUDLength(udLength);
        int udOctetLength = this.b.length - this.a;
        byte[] udData = new byte[udOctetLength];
        System.arraycopy(this.b, this.a, udData, 0, udOctetLength);
        pdu.setUDData(udData);
        if (pdu.hasTpUdhi()) {
            int udhLength = this.a();
            int endUdh = this.a + udhLength;
            if (udhLength < 0 || udhLength + 1 > udOctetLength) {
                return;
            }
            while (this.a < endUdh) {
                int iei = this.a();
                int iedl = this.a();
                if (iedl > 0 && this.a + iedl <= endUdh) {
                    byte[] ieData = new byte[iedl];
                    System.arraycopy(this.b, this.a, ieData, 0, iedl);
                    InformationElement ie = InformationElementFactory.createInformationElement(iei, ieData);
                    pdu.addInformationElement(ie);
                }
                this.a += iedl;
                if (this.a <= endUdh) continue;
                break;
            }
        }
    }

    private void a(SmsDeliveryPdu pdu) {
        int addressLength = this.a();
        int addressType = this.a();
        String originatorAddress = this.a(addressLength, addressType);
        pdu.setAddressType(addressType);
        if (originatorAddress != null) {
            pdu.setAddress(originatorAddress);
        }
        int protocolId = this.a();
        pdu.setProtocolIdentifier(protocolId);
        int dcs = this.a();
        pdu.setDataCodingScheme(dcs);
        Calendar timestamp = this.c();
        pdu.setTimestamp(timestamp);
        this.a((Pdu)pdu);
    }

    private void a(SmsStatusReportPdu pdu) {
        int messageReference = this.a();
        pdu.setMessageReference(messageReference);
        int addressLength = this.a();
        int addressType = this.a();
        String destinationAddress = this.a(addressLength, addressType);
        pdu.setAddressType(addressType);
        pdu.setAddress(destinationAddress);
        Calendar timestamp = this.c();
        pdu.setTimestamp(timestamp);
        Calendar timestamp2 = this.c();
        pdu.setDischargeTime(timestamp2);
        int status = this.a();
        pdu.setStatus(status);
    }

    private void a(SmsSubmitPdu pdu) {
        int messageReference = this.a();
        pdu.setMessageReference(messageReference);
        int addressLength = this.a();
        int addressType = this.a();
        String destinationAddress = this.a(addressLength, addressType);
        pdu.setAddressType(addressType);
        pdu.setAddress(destinationAddress);
        int protocolId = this.a();
        pdu.setProtocolIdentifier(protocolId);
        int dcs = this.a();
        pdu.setDataCodingScheme(dcs);
        switch (pdu.getTpVpf()) {
            case 0: {
                break;
            }
            case 16: {
                int validityInt = this.d();
                pdu.setValidityPeriod(validityInt / 60);
                break;
            }
            case 24: {
                Calendar validityDate = this.c();
                pdu.setValidityTimestamp(validityDate);
            }
        }
        this.a((Pdu)pdu);
    }

    private String a(int validSemiOctetNumber, String addressFieldString) {
        int validBitNumber = validSemiOctetNumber * 4;
        int valid7BitCharNumber = validBitNumber / 7;
        return addressFieldString.substring(0, valid7BitCharNumber);
    }
}

