/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms;

import cn.sendsms.InvalidMessageException;
import cn.sendsms.USSDDatagram;
import cn.sendsms.USSDDcs;
import cn.sendsms.USSDSessionStatus;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class USSDResponse
extends USSDDatagram {
    private static final long serialVersionUID = 1L;
    private static final Pattern MSG_PATTERN = Pattern.compile("^\\+CUSD:\\s+(\\d)(?:,\\s*\"([^\"]*))?(?:\",\\s*(\\d+)\\s*)?\"?\r?$");
    private static final int STATUS_INDEX = 1;
    private static final int CONTENT_INDEX = 2;
    private static final int ENCODING_INDEX = 3;
    private String a;
    private USSDSessionStatus b;

    public USSDResponse() {
        this.a = null;
        this.b = null;
    }

    public USSDResponse(String rawResp, String gtwId) throws InvalidMessageException {
        Matcher matcher = MSG_PATTERN.matcher(rawResp);
        if (!matcher.matches()) {
            throw new InvalidMessageException("Not a well-formed +CUSD response: |" + rawResp + "|");
        }
        try {
            this.setGatewayId(gtwId);
            this.a = rawResp;
            this.b = USSDSessionStatus.getByNumeric(Integer.valueOf(matcher.group(1)));
            if (matcher.groupCount() >= 2 && matcher.group(2) != null) {
                this.setContent(matcher.group(2));
            }
            if (matcher.groupCount() >= 3 && matcher.group(3) != null) {
                this.setDcs(USSDDcs.getByNumeric(Integer.valueOf(matcher.group(3))));
            }
        }
        catch (Exception e2) {
            throw new InvalidMessageException("Session status: " + matcher.group(1) + "; DCS: " + matcher.group(3));
        }
    }

    public String getRawResponse() {
        return this.a;
    }

    public void setRawResponse(String aRawResponse) {
        this.a = aRawResponse;
    }

    public USSDSessionStatus getSessionStatus() {
        return this.b;
    }

    public void setUSSDSessionStatus(USSDSessionStatus aUSSDSessionStatus) {
        this.b = aUSSDSessionStatus;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Gateway: ");
        buf.append(this.getGatewayId());
        buf.append("\n");
        buf.append("Session status: ");
        buf.append((Object)this.b);
        buf.append("\n");
        buf.append("Data coding scheme: ");
        buf.append(this.getDcs() != null ? this.getDcs() : "Unspecified");
        buf.append("\n");
        buf.append("Content: ");
        buf.append(this.getContent() != null ? this.getContent() : "(EMPTY)");
        return buf.toString();
    }
}

