/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.crypto;

import cn.sendsms.crypto.ASymmetricKey;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AESKey
extends ASymmetricKey {
    public AESKey() throws NoSuchAlgorithmException {
        this.setKey(this.generateKey());
    }

    public AESKey(SecretKeySpec key) {
        this.setKey(key);
    }

    @Override
    public SecretKeySpec generateKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(128);
        SecretKey secretKey = keyGen.generateKey();
        byte[] raw = secretKey.getEncoded();
        return new SecretKeySpec(raw, "AES");
    }

    @Override
    public byte[] encrypt(byte[] message) throws NoSuchAlgorithmException, NoSuchPaddingException, BadPaddingException, IllegalBlockSizeException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, this.getKey());
        return cipher.doFinal(message);
    }

    @Override
    public byte[] decrypt(byte[] message) throws NoSuchAlgorithmException, NoSuchPaddingException, BadPaddingException, IllegalBlockSizeException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, this.getKey());
        return cipher.doFinal(message);
    }

    public static void main(String[] args) {
        try {
            AESKey k2 = new AESKey();
            k2.setKey(k2.generateKey());
            String message = "Hello from Thanasis :)";
            System.out.println(">>> " + message);
            byte[] enc = k2.encrypt(message.getBytes());
            byte[] dec = k2.decrypt(enc);
            System.out.println(">>> " + AESKey.asString(dec));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

