/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.crypto;

import cn.sendsms.crypto.AESKey;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.crypto.spec.SecretKeySpec;

public class PwdConf {
    private static String bytes2HexString(byte[] array) {
        if (array == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (byte b2 : array) {
            String hex = Integer.toHexString(b2 & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            builder.append(hex);
        }
        return builder.toString().toUpperCase();
    }

    private static byte[] hexString2Bytes(String hex) {
        if (hex == null) {
            return null;
        }
        int m2 = 0;
        int n2 = 0;
        int byteLen = hex.length() / 2;
        byte[] ret = new byte[byteLen];
        for (int i2 = 0; i2 < byteLen; ++i2) {
            m2 = i2 * 2 + 1;
            n2 = m2 + 1;
            int intVal = Integer.decode("0x" + hex.substring(i2 * 2, m2) + hex.substring(m2, n2));
            ret[i2] = (byte)intVal;
        }
        return ret;
    }

    private static SecretKeySpec confKey() {
        String szKey = "JINDIWEB-PWDCONF";
        return new SecretKeySpec(szKey.getBytes(), "AES");
    }

    public static String encPwd(String szPwd) {
        String szEnc = "";
        try {
            AESKey k2 = new AESKey();
            k2.setKey(PwdConf.confKey());
            String szNew = new SimpleDateFormat("HHmmssSSS").format(new Date()) + szPwd;
            byte[] enc = k2.encrypt(szNew.getBytes());
            szEnc = PwdConf.bytes2HexString(enc);
        }
        catch (NoSuchAlgorithmException e2) {
            e2.printStackTrace();
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        return szEnc;
    }

    public static String decPwd(String szEnc) {
        if (szEnc.length() < 32) {
            return "";
        }
        String szPwd = "";
        try {
            AESKey k2 = new AESKey();
            k2.setKey(PwdConf.confKey());
            byte[] enc = PwdConf.hexString2Bytes(szEnc);
            byte[] dec = k2.decrypt(enc);
            szPwd = AESKey.asString(dec);
        }
        catch (NoSuchAlgorithmException e2) {
            e2.printStackTrace();
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        if (szPwd.length() < 10) {
            return "";
        }
        return szPwd.substring(9);
    }

    public static void main(String[] args) {
        String message = "xxxx1213214214";
        System.out.println(">>> " + message);
        String szEnc = PwdConf.encPwd(message);
        System.out.println(">>> " + szEnc);
        String szDec = PwdConf.decPwd(szEnc);
        System.out.println(">>> " + szDec);
        szDec = PwdConf.decPwd("895549632B07677DC5897F37BA4331B1");
        System.out.println(">>> " + szDec);
    }
}

