/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.gateways;

import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.gateways.BaseGatewayInfo;
import cn.sendsms.jdsmsserver.web.DeviceInfoCache;
import cn.sendsms.jdsmsserver.web.SerialModemBean;
import cn.sendsms.modem.IPModemGateway;
import cn.sendsms.modem.ModemGateway;
import cn.sendsms.modem.athandler.ATHandler;
import java.util.StringTokenizer;
import org.apache.commons.configuration.PropertiesConfiguration;

public class IPModem
extends BaseGatewayInfo {
    public IPModem(String myGatewayId, PropertiesConfiguration myProps, JDSMSServer myServer) {
        super(myGatewayId, myProps, myServer);
        this.setDescription("Default IP Modem Gateway.");
    }

    @Override
    public boolean create() throws Exception {
        String propName = this.getGatewayId() + ".";
        if (DeviceInfoCache.getInstance().findByPort(this.getProperties().getString(propName + "ip") + ":" + this.getProperties().getString(propName + "port")) != null) {
            return false;
        }
        this.setGateway(new IPModemGateway(this.getGatewayId(), this.getProperties().getString(propName + "ip"), Integer.parseInt(this.getProperties().getString(propName + "port")), this.getProperties().getString(propName + "manufacturer"), this.getProperties().getString(propName + "model")));
        if (this.getProperties().getString(propName + "protocol").equalsIgnoreCase("pdu")) {
            this.getGateway().setProtocol(AGatewayHelper.Protocols.PDU);
        } else if (this.getProperties().getString(propName + "protocol").equalsIgnoreCase("text")) {
            this.getGateway().setProtocol(AGatewayHelper.Protocols.TEXT);
        } else {
            throw new Exception("Incorrect parameter: " + propName + "protocol");
        }
        if (this.getProperties().getString(propName + "ipprotocol").equalsIgnoreCase("text")) {
            ((ModemGateway)this.getGateway()).setIpProtocol(ModemGateway.IPProtocols.TEXT);
        } else if (this.getProperties().getString(propName + "ipprotocol").equalsIgnoreCase("binary")) {
            ((ModemGateway)this.getGateway()).setIpProtocol(ModemGateway.IPProtocols.BINARY);
        } else {
            throw new Exception("Incorrect parameter: " + propName + "ipprotocol");
        }
        ((IPModemGateway)this.getGateway()).setSimPin(this.getProperties().getString(propName + "pin"));
        if (this.getProperties().getString(propName + "inbound").equalsIgnoreCase("yes")) {
            this.getGateway().setInbound(true);
        } else if (this.getProperties().getString(propName + "inbound").equalsIgnoreCase("no")) {
            this.getGateway().setInbound(false);
        } else {
            throw new Exception("Incorrect parameter: " + propName + "inbound");
        }
        if (this.getProperties().getString(propName + "outbound").equalsIgnoreCase("yes")) {
            this.getGateway().setOutbound(true);
        } else if (this.getProperties().getString(propName + "outbound").equalsIgnoreCase("no")) {
            this.getGateway().setOutbound(false);
        } else {
            throw new Exception("Incorrect parameter: " + propName + "outbound");
        }
        ((ModemGateway)this.getGateway()).setCustomInitString(this.getProperties().getString(propName + "init_string", ""));
        if (this.getProperties().getString(propName + "smsc_number", "").length() > 0) {
            ((ModemGateway)this.getGateway()).setSmscNumber(this.getProperties().getString(propName + "smsc_number"));
        }
        DeviceInfoCache.getInstance().add(this.getDeviceConfigInfo()).setGateway((ModemGateway)this.getGateway());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerialModemBean getInfo() throws Exception {
        SerialModemBean bean = new SerialModemBean();
        String propName = this.getGatewayId() + ".";
        bean.setPort(this.getProperties().getString(propName + "ip") + ":" + this.getProperties().getString(propName + "port"));
        bean.setModemFlag("IpModem");
        bean.setIpAddress(this.getProperties().getString(propName + "ip"));
        bean.setIpPort(Integer.parseInt(this.getProperties().getString(propName + "port")));
        bean.setGatewayID(this.getGatewayId());
        IPModemGateway gateway = (IPModemGateway)this.getGateway();
        bean.setBaudrate(Integer.parseInt(this.getProperties().getString(propName + "baudrate")));
        bean.setManufacturer(this.getProperties().getString(propName + "manufacturer"));
        bean.setModel(this.getProperties().getString(propName + "model"));
        bean.setInit_string(this.getProperties().getString(propName + "init_string"));
        bean.setProtocol(AGatewayHelper.Protocols.valueOf(this.getProperties().getString(propName + "protocol")));
        bean.setPin(this.getProperties().getString(propName + "pin"));
        bean.setInbound(this.getProperties().getString(propName + "inbound"));
        bean.setOutbound(this.getProperties().getString(propName + "outbound"));
        bean.setSmsc_number(this.getProperties().getString(propName + "smsc_number"));
        bean.setAuthorizePort(bean.getPort());
        Object object = gateway.getDriver().getSYNCCommander();
        synchronized (object) {
            String response = gateway.getAtHandler().getSignalLevel();
            if (response.indexOf("ERROR") >= 0) {
                bean.setCsq("\u65e0\u4fe1\u53f7");
            }
            response = response.replaceAll("\\s+OK\\s+", "");
            StringTokenizer tokens = new StringTokenizer(response, ":");
            tokens.nextToken();
            bean.setCsq(tokens.nextToken().trim());
            ATHandler athandler = (ATHandler)gateway.getAtHandler();
            athandler.getModemDriver().write("AT+CCID\r");
            response = athandler.getModemDriver().getResponse();
            response = response.replaceAll("\\s+OK\\s+", "");
            tokens = new StringTokenizer(response, ":");
            tokens.nextToken();
            bean.setCcid(tokens.nextToken().trim());
            if (athandler.isAlive()) {
                bean.setAtFlag("OK");
            } else {
                bean.setAtFlag("NO");
            }
        }
        return bean;
    }

    @Override
    public SerialModemBean getDeviceConfigInfo() {
        SerialModemBean bean = new SerialModemBean();
        String propName = this.getGatewayId() + ".";
        bean.setPort(this.getProperties().getString(propName + "ip") + ":" + this.getProperties().getString(propName + "port"));
        bean.setIpAddress(this.getProperties().getString(propName + "ip"));
        bean.setIpPort(Integer.parseInt(this.getProperties().getString(propName + "port")));
        bean.setGatewayID(this.getGatewayId());
        bean.setBaudrate(Integer.parseInt(this.getProperties().getString(propName + "baudrate")));
        bean.setManufacturer(this.getProperties().getString(propName + "manufacturer"));
        bean.setModel(this.getProperties().getString(propName + "model"));
        bean.setInit_string(this.getProperties().getString(propName + "init_string"));
        bean.setProtocol(AGatewayHelper.Protocols.valueOf(this.getProperties().getString(propName + "protocol")));
        bean.setPin(this.getProperties().getString(propName + "pin"));
        bean.setInbound(this.getProperties().getString(propName + "inbound"));
        bean.setOutbound(this.getProperties().getString(propName + "outbound"));
        bean.setSmsc_number(this.getProperties().getString(propName + "smsc_number"));
        bean.setModemFlag("IpModem");
        bean.setAuthorizePort(bean.getPort());
        return bean;
    }
}

