/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.interfaces;

import cn.sendsms.InboundMessage;
import cn.sendsms.Message;
import cn.sendsms.OutboundMessage;
import cn.sendsms.helper.ExtStringBuilder;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.SysLock;
import cn.sendsms.jdsmsserver.interfaces.ConnectionPool;
import cn.sendsms.jdsmsserver.interfaces.Interface;
import cn.sendsms.jdsmsserver.web.DbHelper;
import cn.sendsms.util.Logger;
import com.sun.mail.pop3.POP3Message;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;

public class Email
extends Interface<Void> {
    private Session a;
    private String b;
    private String c;
    private Store d;
    private Folder e;
    private StringBuffer f = new StringBuffer();
    private boolean g = false;

    public Email(String myInterfaceId, PropertiesConfiguration myProps, JDSMSServer myServer, Interface.InterfaceTypes myType) {
        super(myInterfaceId, myProps, myServer, myType);
        this.setDescription("Interface for Email communication.");
    }

    public void getMailContent(Part part) throws MessagingException, IOException {
        String contentType = part.getContentType();
        int nameindex = contentType.indexOf("name");
        boolean conname = false;
        if (nameindex != -1) {
            conname = true;
        }
        if (part.isMimeType("text/plain") && !conname) {
            String content = (String)part.getContent();
            if (!contentType.contains("charset")) {
                this.g = true;
                content = new String(content.getBytes("ISO-8859-1"), "GBK");
                content = new String(Email.getUTF8BytesFromGBKString(content), "UTF-8");
            }
            this.f.append(content);
        } else if (part.isMimeType("text/html") && !conname) {
            if ("".equals(this.f.toString())) {
                String[] filterTags = new String[]{""};
                this.f.append(Email.trimHtml2Txt((String)part.getContent(), filterTags));
            }
        } else if (part.isMimeType("multipart/*")) {
            Multipart multipart = (Multipart)part.getContent();
            int count = multipart.getCount();
            for (int i2 = 0; i2 < count; ++i2) {
                this.getMailContent((Part)multipart.getBodyPart(i2));
            }
        } else if (part.isMimeType("message/rfc822")) {
            this.getMailContent((Part)part.getContent());
        }
    }

    public String getBodyText() {
        return this.f.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OutboundMessage> getMessagesToSend() {
        Logger.getInstance().logInfo(this.getId() + " - \u51c6\u5907\u8bfb\u53d6\u6536\u4ef6\u7bb1\u4e2d\u7684\u4fe1\u606f\u3002\u3002\u3002", null, null);
        if (this.d == null || !this.d.isConnected()) {
            try {
                this.d = this.a.getStore();
                if (!this.d.isConnected()) {
                    Logger.getInstance().logInfo(this.getId() + " - \u5f00\u59cb\u5efa\u7acb\u8fde\u63a5\u3002\u3002\u3002", null, null);
                    this.d.connect();
                }
            }
            catch (Exception e2) {
                Logger.getInstance().logInfo("\u90ae\u7bb1\u8fde\u63a5\u5f02\u5e38\u3002\u3002\u3002", e2, null);
                if (this.d != null) {
                    try {
                        if (this.e != null) {
                            this.e.close();
                        }
                        this.d.close();
                    }
                    catch (MessagingException e1) {
                        Logger.getInstance().logInfo("\u90ae\u7bb1\u5173\u95ed\u5f02\u5e38\u3002\u3002\u3002", e2, null);
                    }
                }
                return new ArrayList<OutboundMessage>();
            }
        }
        try {
            this.e = this.d.getFolder(this.getProperty("mailbox_name", "INBOX"));
            this.e.open(2);
        }
        catch (MessagingException e3) {
            Logger.getInstance().logInfo("\u6253\u5f00\u6536\u4ef6\u7bb1\u5f02\u5e38\u3002\u3002\u3002", (Exception)((Object)e3), null);
            if (this.d != null) {
                try {
                    this.e.close();
                    this.d.close();
                }
                catch (MessagingException e1) {
                    Logger.getInstance().logInfo("\u90ae\u7bb1\u5173\u95ed\u5f02\u5e38\u3002\u3002\u3002", (Exception)((Object)e3), null);
                }
            }
            return new ArrayList<OutboundMessage>();
        }
        String recipientT = "";
        String sendContentT = "";
        String recipientC = "";
        String sendContentC = "";
        Connection conn = null;
        Statement pstmt = null;
        int count = 0;
        while (!SysLock.getInstance().canUse()) {
            try {
                Thread.sleep(50L);
                if (count++ <= 50) continue;
                Logger.getInstance().logError("\u81ea\u65cb\u7b49\u5f85\u8d85\u8fc72\u79d2", null, null);
            }
            catch (InterruptedException e4) {
                Logger.getInstance().logError("\u53d6\u5f85\u53d1\u77ed\u4fe1\u65f6\u4ea7\u751f\u4e2d\u65ad\u5f02\u5e38", e4, null);
            }
        }
        try {
            DbHelper database = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            conn = ConnectionPool.getInstance().getConnection();
            String sql = "insert into %s (type,recipient,text,wap_url,wap_expiry_date,wap_signal,create_date,originator,encoding,status_report,flash_sms,dst_port,src_port,sent_date,ref_no,priority,status,errors) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            sql = String.format(sql, database.getProperty("tables.sms_out"));
            pstmt = conn.prepareStatement(sql);
            Logger.getInstance().logInfo(this.getId() + " - \u672a\u5904\u7406\u90ae\u4ef6\u6570:" + this.e.getMessages().length, null, null);
            for (int i2 = 0; i2 < this.e.getMessages().length; ++i2) {
                String[] recipients;
                POP3Message m2 = (POP3Message)this.e.getMessages()[i2];
                if (!m2.getFolder().isOpen()) {
                    Logger.getInstance().logInfo("\u6536\u4ef6\u7bb1\u672a\u6253\u5f00\u3002\u3002\u3002", null, null);
                    ArrayList<OutboundMessage> arrayList = new ArrayList<OutboundMessage>();
                    return arrayList;
                }
                m2.invalidate(true);
                this.getMailContent((Part)m2);
                String text = this.getBodyText();
                this.f.delete(0, this.f.length());
                String titleText = m2.getSubject();
                if (this.g) {
                    titleText = new String(titleText.getBytes("ISO-8859-1"), "GBK");
                    titleText = new String(Email.getUTF8BytesFromGBKString(titleText), "UTF-8");
                }
                Logger.getInstance().logInfo("\u6536\u5230\u90ae\u4ef6\uff0c\u90ae\u4ef6\u4e3b\u9898..." + titleText, null, null);
                Logger.getInstance().logInfo("\u6536\u5230\u90ae\u4ef6\uff0c\u90ae\u4ef6\u5185\u5bb9..." + text, null, null);
                if (titleText == null) {
                    titleText = "";
                }
                if (text == null) {
                    text = "";
                }
                String get_from_title = JDSMSServer.getInstance().getProperties().getString("settings.get_from_title", "no");
                String get_from_content = JDSMSServer.getInstance().getProperties().getString("settings.get_from_content", "no");
                String get_from_conf = JDSMSServer.getInstance().getProperties().getString("settings.get_from_conf", "no");
                if (get_from_content.equals("yes")) {
                    recipientC = text.split("\n")[0].trim();
                    sendContentC = text.substring(text.indexOf("\n") + 1);
                    recipients = recipientC.split(";");
                    for (int x = 0; x < recipients.length; ++x) {
                        String recipientPhone = recipients[x];
                        if (!recipientPhone.matches("\\+?\\d{1,25}")) continue;
                        this.a((PreparedStatement)pstmt, recipientPhone, sendContentC);
                    }
                }
                if (get_from_title.equals("yes")) {
                    recipientT = titleText.trim();
                    sendContentT = text;
                    String ss = "\\d+";
                    Pattern pattern = Pattern.compile(ss);
                    Matcher ma = pattern.matcher(recipientT);
                    String recipientPhone = "";
                    while (ma.find()) {
                        recipientPhone = ma.group();
                        if (!recipientPhone.matches("\\+?\\d{11,25}")) continue;
                        this.a((PreparedStatement)pstmt, recipientPhone, sendContentT);
                    }
                }
                if ("yes".equals(get_from_conf)) {
                    ArrayList<OutboundMessage> arrayList;
                    recipients = JDSMSServer.getInstance().getProperties().getString("settings.recipients", "");
                    String content = "";
                    String get_content_from_mail_title = JDSMSServer.getInstance().getProperties().getString("settings.get_content_from_mail_title", "no");
                    String get_content_from_mail_content = JDSMSServer.getInstance().getProperties().getString("settings.get_content_from_mail_content", "no");
                    if ("yes".equals(get_content_from_mail_title) && "yes".equals(get_content_from_mail_content)) {
                        content = titleText + text;
                    } else if ("yes".equals(get_content_from_mail_title) && "no".equals(get_content_from_mail_content)) {
                        content = titleText;
                    } else if ("no".equals(get_content_from_mail_title) && "yes".equals(get_content_from_mail_content)) {
                        content = text;
                    } else {
                        Logger.getInstance().logInfo("\u6ca1\u6709\u9009\u62e9\u4ece\u54ea\u91cc\u63d0\u53d6\u4fe1\u606f\u6b63\u6587...", null, null);
                        arrayList = new ArrayList<OutboundMessage>();
                        return arrayList;
                    }
                    if ("".equals(recipients)) {
                        Logger.getInstance().logInfo("\u6ca1\u6709\u586b\u5199\u6536\u4fe1\u4eba\u53f7\u7801...", null, null);
                        arrayList = new ArrayList();
                        return arrayList;
                    }
                    String[] recipientArray = recipients.split("[\\s;,.]");
                    for (int j2 = 0; j2 < recipientArray.length; ++j2) {
                        String recipient = recipientArray[j2];
                        if (!recipient.matches("\\+?\\d{1,25}")) {
                            Logger.getInstance().logInfo("\u6536\u4fe1\u4eba\u53f7\u7801\u3010" + recipient + "\u3011\u4e0d\u5408\u6cd5", null, null);
                            continue;
                        }
                        this.a((PreparedStatement)pstmt, recipient, content);
                    }
                }
                m2.setFlag(Flags.Flag.DELETED, true);
            }
            pstmt.executeBatch();
        }
        catch (Exception e5) {
            Logger.getInstance().logInfo("\u4ece\u90ae\u7bb1\u62c9\u53d6\u4fe1\u606f\u5165\u5e93\u5f02\u5e38\u3002\u3002\u3002", e5, null);
        }
        finally {
            try {
                this.e.close(true);
                if (pstmt != null) {
                    pstmt.close();
                }
                ConnectionPool.getInstance().returnConnection(conn);
            }
            catch (Exception exception) {}
            pstmt = null;
            ConnectionPool.getInstance().returnConnection(conn);
            SysLock.getInstance().setbusy(false);
        }
        SysLock.getInstance().setbusy(false);
        return new ArrayList<OutboundMessage>();
    }

    private void a(PreparedStatement pstmt, String recipient, String sendContent) throws SQLException {
        pstmt.setString(1, "O");
        pstmt.setString(2, recipient);
        pstmt.setString(3, sendContent);
        pstmt.setString(4, null);
        pstmt.setTimestamp(5, null);
        pstmt.setString(6, null);
        pstmt.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
        pstmt.setString(8, "");
        pstmt.setString(9, "U");
        pstmt.setInt(10, 0);
        pstmt.setInt(11, 0);
        pstmt.setInt(12, -1);
        pstmt.setInt(13, -1);
        pstmt.setTimestamp(14, null);
        pstmt.setString(15, null);
        pstmt.setInt(16, 1);
        pstmt.setString(17, "U");
        pstmt.setInt(18, 0);
        pstmt.addBatch();
    }

    @Override
    public void start() throws Exception {
        Properties mailProps = new Properties();
        mailProps.setProperty("mail.store.protocol", this.getProperty("mailbox_protocol"));
        if ("pop3".equals(this.getProperty("mailbox_protocol"))) {
            mailProps.setProperty("mail.pop3.connectiontimeout", "30000");
            mailProps.setProperty("mail.pop3.timeout", "30000");
            mailProps.setProperty("mail.pop3.host", this.getProperty("mailbox_host"));
            mailProps.setProperty("mail.pop3.port", this.getProperty("mailbox_port"));
            mailProps.setProperty("mail.pop3.user", this.getProperty("mailbox_user"));
            mailProps.setProperty("mail.pop3.password", this.getProperty("mailbox_password"));
            mailProps.setProperty("mail.pop3.password", this.getProperty("mailbox_password"));
        } else if ("pop3s".equals(this.getProperty("mailbox_protocol"))) {
            mailProps.setProperty("mail.pop3s.connectiontimeout", "30000");
            mailProps.setProperty("mail.pop3s.timeout", "30000");
            mailProps.setProperty("mail.pop3s.host", this.getProperty("mailbox_host"));
            mailProps.setProperty("mail.pop3s.port", this.getProperty("mailbox_port"));
            mailProps.setProperty("mail.pop3s.user", this.getProperty("mailbox_user"));
            mailProps.setProperty("mail.pop3s.password", this.getProperty("mailbox_password"));
        } else if ("imap".equals(this.getProperty("mailbox_protocol"))) {
            mailProps.setProperty("mail.imap.connectiontimeout", "30000");
            mailProps.setProperty("mail.imap.timeout", "30000");
            mailProps.setProperty("mail.imap.host", this.getProperty("mailbox_host"));
            mailProps.setProperty("mail.imap.port", this.getProperty("mailbox_port"));
            mailProps.setProperty("mail.imap.user", this.getProperty("mailbox_user"));
            mailProps.setProperty("mail.imap.password", this.getProperty("mailbox_password"));
        } else if ("imaps".equals(this.getProperty("mailbox_protocol"))) {
            mailProps.setProperty("mail.imaps.connectiontimeout", "30000");
            mailProps.setProperty("mail.imaps.timeout", "30000");
            mailProps.setProperty("mail.imaps.host", this.getProperty("mailbox_host"));
            mailProps.setProperty("mail.imaps.port", this.getProperty("mailbox_port"));
            mailProps.setProperty("mail.imaps.user", this.getProperty("mailbox_user"));
            mailProps.setProperty("mail.imaps.password", this.getProperty("mailbox_password"));
        } else {
            throw new IllegalArgumentException("mailbox_protocol have to be pop3(s) or imap(s)!");
        }
        mailProps.setProperty("mail.transport.protocol", "smtp");
        mailProps.setProperty("mail.from", this.getProperty("from"));
        mailProps.setProperty("mail.smtp.host", this.getProperty("smtp_host"));
        mailProps.setProperty("mail.smtp.port", this.getProperty("smtp_port"));
        mailProps.setProperty("mail.smtp.user", this.getProperty("smtp_user"));
        mailProps.setProperty("mail.smtp.password", this.getProperty("smtp_password"));
        mailProps.setProperty("mail.smtp.auth", "true");
        this.a = Session.getInstance((Properties)mailProps, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(Email.this.getProperty("mailbox_user"), Email.this.getProperty("mailbox_password"));
            }
        });
        if (this.isOutbound()) {
            this.a();
        }
        super.start();
    }

    private String a(String template, InboundMessage msg) {
        ExtStringBuilder sb = new ExtStringBuilder(template);
        sb.replaceAll("%gatewayId%", msg.getGatewayId());
        sb.replaceAll("%encoding%", msg.getEncoding() == Message.MessageEncodings.ENC7BIT ? "7-bit" : (msg.getEncoding() == Message.MessageEncodings.ENC8BIT ? "8-bit" : "UCS2 (Unicode)"));
        sb.replaceAll("%date%", msg.getDate().toString());
        sb.replaceAll("%text%", msg.getText());
        sb.replaceAll("%pduUserData%", msg.getPduUserData());
        sb.replaceAll("%originator%", msg.getOriginator());
        sb.replaceAll("%memIndex%", msg.getMemIndex());
        sb.replaceAll("%mpMemIndex%", msg.getMpMemIndex());
        return sb.toString();
    }

    private void a() {
        File f2;
        this.b = this.getProperty("message_subject");
        if (this.b == null || this.b.length() == 0) {
            this.getService().getLogger().logWarn("No message_subject found - Using default", null, null);
            this.b = "SMS from %ORIGINATOR%";
        }
        if ((f2 = new File(this.getProperty("message_body"))).canRead()) {
            try {
                FileReader r2 = new FileReader(f2);
                BufferedReader br = new BufferedReader(r2);
                String line = null;
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                this.c = sb.toString();
            }
            catch (IOException e2) {
                this.getService().getLogger().logError("I/O-Exception while reading message body template: " + e2.getMessage(), null, null);
            }
        }
        if (this.c == null || this.c.length() == 0) {
            this.getService().getLogger().logWarn("message_body can't be read or is empty - Using default", null, null);
            this.c = null;
        }
    }

    public static String trimHtml2Txt(String html, String[] filterTags) {
        html = html.replaceAll("(?i)\\<head>[\\s\\S]*?</head>(?i)", "");
        html = html.replaceAll("(?i)\\<!--[\\s\\S]*?-->", "");
        html = html.replaceAll("(?i)\\<![\\s\\S]*?>", "");
        html = html.replaceAll("(?i)\\<style[^>]*>[\\s\\S]*?</style>(?i)", "");
        html = html.replaceAll("(?i)\\<script[^>]*>[\\s\\S]*?</script>(?i)", "");
        html = html.replaceAll("(?i)\\<w:[^>]+>[\\s\\S]*?</w:[^>]+>(?i)", "");
        html = html.replaceAll("(?i)\\<xml>[\\s\\S]*?</xml>(?i)", "");
        html = html.replaceAll("(?i)\\<html[^>]*>|<body[^>]*>|</html>|</body>(?i)", "");
        html = html.replaceAll("(?i)\\\r\n|\n|\r", " ");
        html = html.replaceAll("(?i)\\<br[^>]*>(?i)", "\n");
        html = html.replaceAll("(?i)&nbsp;", " ");
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList<String> s_tags = new ArrayList<String>();
        List<String> halfTag = Arrays.asList("img", "table", "thead", "th", "tr", "td");
        if (filterTags != null && filterTags.length > 0) {
            for (int i2 = 0; i2 < filterTags.length; ++i2) {
                String tag = filterTags[i2];
                tags.add("<" + tag + (halfTag.contains(tag) ? "" : ">"));
                if (!"img".equals(tag)) {
                    tags.add("</" + tag + ">");
                }
                s_tags.add("#REPLACETAG" + tag + (halfTag.contains(tag) ? "" : "REPLACETAG#"));
                if ("img".equals(tag)) continue;
                s_tags.add("#REPLACETAG/" + tag + "REPLACETAG#");
            }
        }
        html = StringUtils.replaceEach((String)html, (String[])tags.toArray(new String[tags.size()]), (String[])s_tags.toArray(new String[s_tags.size()]));
        html = html.replaceAll("\\</p>(?i)", "\n");
        html = html.replaceAll("\\<[^>]+>", "");
        html = StringUtils.replaceEach((String)html, (String[])s_tags.toArray(new String[s_tags.size()]), (String[])tags.toArray(new String[tags.size()]));
        html = html.replaceAll("\\ ", " ");
        return html.trim();
    }

    public static byte[] getUTF8BytesFromGBKString(String gbkStr) {
        int n2 = gbkStr.length();
        byte[] utfBytes = new byte[3 * n2];
        int k2 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char m2 = gbkStr.charAt(i2);
            if (m2 < '\u0080' && m2 >= '\u0000') {
                utfBytes[k2++] = (byte)m2;
                continue;
            }
            utfBytes[k2++] = (byte)(0xE0 | m2 >> 12);
            utfBytes[k2++] = (byte)(0x80 | m2 >> 6 & 0x3F);
            utfBytes[k2++] = (byte)(0x80 | m2 & 0x3F);
        }
        if (k2 < utfBytes.length) {
            byte[] tmp = new byte[k2];
            System.arraycopy(utfBytes, 0, tmp, 0, k2);
            return tmp;
        }
        return utfBytes;
    }
}

