/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.web;

import cn.sendsms.InboundMessage;
import cn.sendsms.TmpMsg;
import cn.sendsms.crypto.PwdConf;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.interfaces.ConnectionPool;
import cn.sendsms.jdsmsserver.web.AlertInfo;
import cn.sendsms.jdsmsserver.web.Condition;
import cn.sendsms.jdsmsserver.web.Page;
import cn.sendsms.jdsmsserver.web.User;
import cn.sendsms.otherModem.common.Const;
import cn.sendsms.otherModem.common.Utils;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.configuration.PropertiesConfiguration;

public abstract class DbHelper {
    protected PropertiesConfiguration props;
    protected String dbid;
    private static final Object TMPMSG_TABLE_ACCESS_LOCK = new Object();

    public static DbHelper getDbHelper(PropertiesConfiguration props, String dbid) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String classType1 = DbHelper.class.getName();
        String classType = classType1 + "For" + props.getString(dbid + ".type").toUpperCase();
        if (props.getString(dbid + ".type").equals("oracle-rac")) {
            classType = classType1 + "ForORACLE";
        }
        JDSMSServer.getInstance().userConsolePrint("m", "db classType:" + classType);
        Class<?> c2 = Class.forName(classType);
        Constructor<?> constructor = c2.getConstructor(PropertiesConfiguration.class, String.class);
        DbHelper helper = (DbHelper)constructor.newInstance(props, dbid);
        return helper;
    }

    public String getProperty(String key) {
        return this.props.getString(this.dbid + "." + key, "");
    }

    public String getDbUserName() {
        return this.getProperty("username");
    }

    public String getDbPassword() {
        String szTmpPwd;
        String szTmpEnc = this.getProperty("enc");
        String szDbPwd = szTmpPwd = this.getProperty("password");
        if (szTmpEnc != null && szTmpEnc.equals("1")) {
            szDbPwd = PwdConf.decPwd(szTmpPwd);
        }
        return szDbPwd;
    }

    public abstract String getHttpReceiveApiSQL(String var1, int var2);

    public abstract String getHttpReceiveApiSQL(String var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertMessage(boolean isPush, String mobiles, String content, String sendport, String pushUrl, String userId) throws Exception {
        String sql = "insert into %s (type,recipient,text,wap_url,wap_expiry_date,wap_signal,create_date,originator,encoding,status_report,flash_sms,dst_port,src_port,sent_date,ref_no,priority,status,errors,gateway_id,user_id) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        sql = String.format(sql, this.getProperty("tables.sms_out"));
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            pstmt = conn.prepareStatement(sql);
            String[] ms = mobiles.split(" ");
            for (int i2 = 0; i2 < ms.length; ++i2) {
                if (!isPush) {
                    pstmt.setString(1, "O");
                } else {
                    pstmt.setString(1, "W");
                }
                pstmt.setString(2, ms[i2]);
                pstmt.setString(3, content);
                pstmt.setString(4, pushUrl);
                pstmt.setTimestamp(5, null);
                pstmt.setString(6, null);
                pstmt.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
                pstmt.setString(8, "");
                pstmt.setString(9, "U");
                pstmt.setInt(10, 0);
                pstmt.setInt(11, 0);
                pstmt.setInt(12, -1);
                pstmt.setInt(13, -1);
                pstmt.setTimestamp(14, null);
                pstmt.setString(15, null);
                pstmt.setInt(16, 0);
                pstmt.setString(17, "U");
                pstmt.setInt(18, 0);
                pstmt.setString(19, sendport);
                pstmt.setString(20, userId);
                JDSMSServer.getInstance().userConsolePrint("A", sql);
                pstmt.executeUpdate();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMessages() throws Exception {
        Connection conn = null;
        Statement pstmt = null;
        String sql = "update " + this.getProperty("tables.sms_out") + " set errors = 0, gateway_id=? where status = 'U' and (gateway_id='*' or gateway_id='#' or gateway_id='$')";
        JDSMSServer.getInstance().userConsolePrint("m", "update messages: " + sql);
        try {
            conn = ConnectionPool.getInstance().getConnection();
            pstmt = conn.prepareStatement(sql);
            String flag = this.a();
            pstmt.setString(1, flag);
            pstmt.executeUpdate();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
    }

    public Connection getConnection() throws Exception {
        Class.forName(this.getProperty("driver")).newInstance();
        Connection conn = DriverManager.getConnection(this.getProperty("url"), this.getDbUserName(), this.getDbPassword());
        return conn;
    }

    protected String DateFormat(Date time) {
        if (time == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(time);
    }

    protected Timestamp DateFromString(String date) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddhhmmss");
        if (date == null || "".equals(date) || !date.matches("\\d{14}")) {
            return new Timestamp(df.parse(df.format(new Date())).getTime());
        }
        return new Timestamp(df.parse(date).getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyUser(User user) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String sql = "update  %s set password = ?, user_desc = ? where user_id = ?";
        sql = String.format(sql, this.getProperty("tables.sms_user"));
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, user.getPassword());
            pstmt.setString(2, user.getUserDesc());
            pstmt.setString(3, user.getUserId());
            pstmt.executeUpdate();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyUserPassword(User user) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String sql = "update  %s set password = ? where user_id = ?";
        sql = String.format(sql, this.getProperty("tables.sms_user"));
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, user.getPassword());
            pstmt.setString(2, user.getUserId());
            pstmt.executeUpdate();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyUserSurplusNumber(User user) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String sql = "update  %s set surplus_number = ? where user_id = ?";
        sql = String.format(sql, this.getProperty("tables.sms_user"));
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, user.getSurplusNumber());
            pstmt.setString(2, user.getUserId());
            pstmt.executeUpdate();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delUser(String[] userIdArray) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String sql = "delete  from %s where user_id = ?";
        sql = String.format(sql, this.getProperty("tables.sms_user"));
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            pstmt = conn.prepareStatement(sql);
            for (int i2 = 0; i2 < userIdArray.length; ++i2) {
                pstmt.setString(1, userIdArray[i2]);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignUserPermission(String[] userIdArray) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String sql = "update %s set flag = '1' where user_id = ?";
        sql = String.format(sql, this.getProperty("tables.sms_user"));
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            pstmt = conn.prepareStatement(sql);
            for (int i2 = 0; i2 < userIdArray.length; ++i2) {
                pstmt.setString(1, userIdArray[i2]);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokePermission(String[] userIdArray) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String sql = "update %s set flag = '0' where user_id = ?";
        sql = String.format(sql, this.getProperty("tables.sms_user"));
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            pstmt = conn.prepareStatement(sql);
            for (int i2 = 0; i2 < userIdArray.length; ++i2) {
                pstmt.setString(1, userIdArray[i2]);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setnolimit(String[] userIdArray) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String sql = "update %s set sendlimit = '0' where user_id = ?";
        sql = String.format(sql, this.getProperty("tables.sms_user"));
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            pstmt = conn.prepareStatement(sql);
            for (int i2 = 0; i2 < userIdArray.length; ++i2) {
                pstmt.setString(1, userIdArray[i2]);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setlimit(String[] userIdArray) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String sql = "update %s set sendlimit = '1' where user_id = ?";
        sql = String.format(sql, this.getProperty("tables.sms_user"));
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            pstmt = conn.prepareStatement(sql);
            for (int i2 = 0; i2 < userIdArray.length; ++i2) {
                pstmt.setString(1, userIdArray[i2]);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSendRecord(User user) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String sql = "update  %s set  surplus_number = ? where user_id = ?";
        sql = String.format(sql, this.getProperty("tables.sms_user"));
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, user.getSurplusNumber());
            pstmt.setString(2, user.getUserId());
            pstmt.executeUpdate();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delRecord(List<String> msgIdArray, User user, String type) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String sql = "";
        if ("0".equals(type)) {
            sql = "delete from %s where id = ? and status = 'Z' ";
            if (!"admin".equals(user.getUserId())) {
                sql = sql + "and user_id = ?";
            }
            sql = String.format(sql, this.getProperty("tables.sms_out"));
        } else if (!"3".equals(type)) {
            sql = "delete  from %s where id = ? ";
            if (!"admin".equals(user.getUserId())) {
                sql = sql + "and user_id = ?";
            }
            sql = String.format(sql, this.getProperty("tables.sms_out"));
        } else {
            sql = "delete  from %s where id = ?";
            sql = String.format(sql, this.getProperty("tables.sms_in"));
        }
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            pstmt = conn.prepareStatement(sql);
            for (int i2 = 0; i2 < msgIdArray.size(); ++i2) {
                if ("0".equals(type)) {
                    pstmt.setInt(1, Integer.parseInt(msgIdArray.get(i2)));
                    if (!"admin".equals(user.getUserId())) {
                        pstmt.setString(2, user.getUserId());
                    }
                } else if (!"3".equals(type)) {
                    pstmt.setInt(1, Integer.parseInt(msgIdArray.get(i2)));
                    if (!"admin".equals(user.getUserId())) {
                        pstmt.setString(2, user.getUserId());
                    }
                } else {
                    pstmt.setInt(1, Integer.parseInt(msgIdArray.get(i2)));
                }
                pstmt.execute();
            }
            pstmt.executeBatch();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delRecord(String[] msgIdArray, User user, String type) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String sql = "";
        if ("0".equals(type)) {
            sql = "delete from %s where id = ? and status = 'Z' ";
            if (!"admin".equals(user.getUserId())) {
                sql = sql + "and user_id = ?";
            }
            sql = String.format(sql, this.getProperty("tables.sms_out"));
        } else if (!"3".equals(type)) {
            sql = "delete  from %s where id = ? ";
            if (!"admin".equals(user.getUserId())) {
                sql = sql + "and user_id = ?";
            }
            sql = String.format(sql, this.getProperty("tables.sms_out"));
        } else {
            sql = "delete  from %s where id = ?";
            sql = String.format(sql, this.getProperty("tables.sms_in"));
        }
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            pstmt = conn.prepareStatement(sql);
            for (int i2 = 0; i2 < msgIdArray.length; ++i2) {
                if ("0".equals(type)) {
                    pstmt.setInt(1, Integer.parseInt(msgIdArray[i2]));
                    if (!"admin".equals(user.getUserId())) {
                        pstmt.setString(2, user.getUserId());
                    }
                } else if (!"3".equals(type)) {
                    pstmt.setInt(1, Integer.parseInt(msgIdArray[i2]));
                    if (!"admin".equals(user.getUserId())) {
                        pstmt.setString(2, user.getUserId());
                    }
                } else {
                    pstmt.setInt(1, Integer.parseInt(msgIdArray[i2]));
                }
                pstmt.execute();
            }
            pstmt.executeBatch();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSending(String id) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String sql = "select * from " + this.getProperty("tables.sms_out") + " where id = " + id + " and status = 'Q'";
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAddRecord(String userId, int addRecords) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String sql = "insert into %s (add_time,user_id,add_number) values(?,?,?)";
        sql = String.format(sql, this.getProperty("tables.sms_record"));
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            pstmt.setString(2, userId);
            pstmt.setInt(3, addRecords);
            pstmt.executeUpdate();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getAllUser() throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        ArrayList<User> list = new ArrayList<User>();
        Connection conn = null;
        Statement stmt = null;
        String sql = "select * from " + this.getProperty("tables.sms_user");
        ResultSet rs = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                User user = new User();
                user.setUserId(rs.getString("user_id"));
                user.setPassword(rs.getString("password"));
                user.setUserDesc(rs.getString("user_desc"));
                user.setSurplusNumber(rs.getInt("surplus_number"));
                list.add(user);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUser(User user) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String sql = "insert into %s (user_id,password,user_desc,surplus_number) values(?,?,?,?)";
        sql = String.format(sql, this.getProperty("tables.sms_user"));
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, user.getUserId());
            pstmt.setString(2, user.getPassword());
            pstmt.setString(3, user.getUserDesc());
            pstmt.setInt(4, user.getSurplusNumber());
            pstmt.executeUpdate();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User findUserById(String userId) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String sql = "select * from " + this.getProperty("tables.sms_user") + " where user_id = '" + userId + "'";
        User user = null;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                user = new User();
                user.setUserId(rs.getString("user_id"));
                user.setPassword(rs.getString("password"));
                user.setUserDesc(rs.getString("user_desc"));
                user.setSurplusNumber(rs.getInt("surplus_number"));
                user.setFlag(rs.getInt("flag"));
                user.setSendlimit(rs.getInt("sendlimit"));
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFaultRecord(List<String> msgIdArray, User user, String status) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String sql = "update  %s set  status = ? where id = ? ";
        if (!"admin".equals(user.getUserId())) {
            sql = sql + "and user_id = ?";
        }
        sql = String.format(sql, this.getProperty("tables.sms_out"));
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            pstmt = conn.prepareStatement(sql);
            for (int i2 = 0; i2 < msgIdArray.size(); ++i2) {
                pstmt.setString(1, status);
                pstmt.setInt(2, Integer.parseInt(msgIdArray.get(i2)));
                if (!"admin".equals(user.getUserId())) {
                    pstmt.setString(3, user.getUserId());
                }
                pstmt.execute();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFaultRecord(User user, String status) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String sql = "update  %s set  status = ? where status = 'U'";
        if (!"admin".equals(user.getUserId())) {
            sql = sql + " and user_id = ?";
        }
        sql = String.format(sql, this.getProperty("tables.sms_out"));
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, status);
            if (!"admin".equals(user.getUserId())) {
                pstmt.setString(2, user.getUserId());
            }
            pstmt.execute();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFaultRecord(String[] msgIdArray, User user, String status) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String sql = "update  %s set  status = ? where id = ? ";
        if (!"admin".equals(user.getUserId())) {
            sql = sql + "and user_id = ?";
        }
        sql = String.format(sql, this.getProperty("tables.sms_out"));
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            pstmt = conn.prepareStatement(sql);
            for (int i2 = 0; i2 < msgIdArray.length; ++i2) {
                pstmt.setString(1, status);
                pstmt.setInt(2, Integer.parseInt(msgIdArray[i2]));
                if (!"admin".equals(user.getUserId())) {
                    pstmt.setString(3, user.getUserId());
                }
                pstmt.execute();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean AddAlertInfoToDB(AlertInfo demo) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        Connection conn = null;
        Statement stmt = null;
        Statement pstmt = null;
        Statement pstmt11 = null;
        ResultSet rs = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            String strCCID = demo.getCCID();
            String tablename = this.getProperty("tables.sms_alert");
            stmt = conn.createStatement();
            String sql = "select * from " + tablename + " where ccid_id = '" + strCCID + "'";
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                sql = "delete from " + tablename + " where ccid_id = '" + strCCID + "'";
                pstmt11 = conn.prepareStatement(sql);
                pstmt11.executeUpdate();
                pstmt11.close();
            }
            sql = "insert into %s (ccid_id,alert_number,sent_number,call_number,alert_msg,maxLimit_number,add_time) values(?,?,?,?,?,?,?)";
            sql = String.format(sql, tablename);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, demo.getCCID());
            pstmt.setString(2, String.valueOf(demo.getAlertNumber()));
            pstmt.setString(3, String.valueOf(demo.getSentNumber()));
            pstmt.setString(4, demo.getCallNumber());
            String str = demo.getAlertMsg();
            pstmt.setString(5, str);
            pstmt.setString(6, String.valueOf(demo.getMaxLimitNumber()));
            pstmt.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
            pstmt.executeUpdate();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            if (pstmt11 != null) {
                pstmt11.close();
                pstmt11 = null;
            }
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTmpMsg(String pdustring, int memindex, String memlocation, int ml, String ccid) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        Object object = TMPMSG_TABLE_ACCESS_LOCK;
        synchronized (object) {
            JDSMSServer.getInstance().userConsolePrint("A", "addTmpMsg-----");
            String tablename = this.getProperty("tables.sms_tmp_msg");
            Connection conn = null;
            Statement pstmt = null;
            Statement stmt = null;
            try {
                conn = ConnectionPool.getInstance().getConnection();
                stmt = conn.createStatement();
                String sql = "insert into %s (pdustring,memindex,memlocation,ml,ccid) values(?,?,?,?,?)";
                sql = String.format(sql, tablename);
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, pdustring);
                pstmt.setInt(2, memindex);
                pstmt.setString(3, memlocation);
                pstmt.setInt(4, ml);
                pstmt.setString(5, ccid);
                pstmt.executeUpdate();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            finally {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                ConnectionPool.getInstance().returnConnection(conn);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<TmpMsg> getTmpMsg(boolean isSmsMsg, String ccid) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        Object object = TMPMSG_TABLE_ACCESS_LOCK;
        synchronized (object) {
            ArrayList<TmpMsg> msgList = new ArrayList<TmpMsg>();
            ResultSet rs = null;
            Statement stmt = null;
            Connection conn = null;
            try {
                conn = ConnectionPool.getInstance().getConnection();
                String tablename = this.getProperty("tables.sms_tmp_msg");
                stmt = conn.createStatement();
                String moreSql = "";
                if (ccid != null && !ccid.trim().equals("")) {
                    moreSql = " where ccid = '" + ccid + "'";
                }
                String sql = "select * from " + tablename + moreSql + " order by id";
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    TmpMsg tmpMsg = new TmpMsg();
                    tmpMsg.setId(rs.getInt("id"));
                    tmpMsg.setPdustring(rs.getString("pdustring"));
                    tmpMsg.setMemindex(rs.getInt("memindex"));
                    tmpMsg.setMemlocation(rs.getString("memlocation"));
                    tmpMsg.setMl(rs.getInt("ml"));
                    tmpMsg.setCCID(rs.getString("ccid"));
                    if (isSmsMsg) {
                        if (tmpMsg.getMemindex() == 0 && (Utils.isEmptyStr(tmpMsg.getMemlocation()) || Const.TMP_MSG_TYPE.contains(tmpMsg.getMemlocation())) && tmpMsg.getMl() == 0) continue;
                        msgList.add(tmpMsg);
                    }
                    if (isSmsMsg || tmpMsg.getMemindex() != 0 || !Const.TMP_MSG_TYPE.contains(tmpMsg.getMemlocation()) || tmpMsg.getMl() != 0) continue;
                    msgList.add(tmpMsg);
                }
                ArrayList<TmpMsg> arrayList = msgList;
                return arrayList;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            finally {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                ConnectionPool.getInstance().returnConnection(conn);
            }
            return msgList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteTmpMsg(int id) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        JDSMSServer.getInstance().userConsolePrint("A", "delete----" + id);
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            String tablename = this.getProperty("tables.sms_tmp_msg");
            stmt = conn.createStatement();
            String sql = "delete from " + tablename + " where id = '" + id + "'";
            stmt.execute(sql);
            boolean bl = stmt.execute(sql);
            return bl;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteTmpMsg(String messageKey1, String messageKey2) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        Object object = TMPMSG_TABLE_ACCESS_LOCK;
        synchronized (object) {
            JDSMSServer.getInstance().userConsolePrint("A", "delete----" + messageKey1 + "____" + messageKey2);
            Connection conn = null;
            Statement stmt = null;
            String tablename = this.getProperty("tables.sms_tmp_msg");
            String sql = "delete from " + tablename + " where pdustring like '" + messageKey1 + "____" + messageKey2 + "%'";
            try {
                conn = ConnectionPool.getInstance().getConnection();
                stmt = conn.createStatement();
                boolean bl = stmt.execute(sql);
                return bl;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                ConnectionPool.getInstance().returnConnection(conn);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteTmpMsgByType(String pduString, String messageType) {
        Object object = TMPMSG_TABLE_ACCESS_LOCK;
        synchronized (object) {
            Statement stmt = null;
            Connection conn = null;
            try {
                conn = ConnectionPool.getInstance().getConnection();
                String tablename = this.getProperty("tables.sms_tmp_msg");
                stmt = conn.createStatement();
                String sql = "delete from " + tablename + " where pdustring like '" + pduString + "%' and memlocation = '" + messageType + "'";
                boolean bl = stmt.execute(sql);
                return bl;
            }
            catch (Exception e3) {
                boolean bl2 = false;
                return bl2;
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e5) {
                        e5.printStackTrace();
                    }
                    stmt = null;
                }
                ConnectionPool.getInstance().returnConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dealOldMsg() throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        Object object = TMPMSG_TABLE_ACCESS_LOCK;
        synchronized (object) {
            JDSMSServer.getInstance().userConsolePrint("A", "delete----");
            String tablename = this.getProperty("tables.sms_tmp_msg");
            String delRecord = "delete from " + tablename + " where memindex ='' and memlocation =0 and ml =0";
            String updateRecord = "update " + this.getProperty("tables.sms_in") + " set process = 99 where process >99";
            Connection conn = null;
            Statement stmt = null;
            try {
                conn = ConnectionPool.getInstance().getConnection();
                stmt = conn.createStatement();
                stmt.execute(delRecord);
                stmt.execute(updateRecord);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                ConnectionPool.getInstance().returnConnection(conn);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlertInfo getAlertInfoFromDB(String strCCID) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        AlertInfo demo = new AlertInfo();
        String tablename = this.getProperty("tables.sms_alert");
        String sql = "select * from " + tablename + " where ccid_id = '" + strCCID + "'";
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                demo.setCCID(rs.getString("ccid_id"));
                demo.setAlertNumber(Integer.valueOf(rs.getString("alert_number")));
                demo.setSentNumber(Integer.valueOf(rs.getString("sent_number")));
                demo.setCallNumber(rs.getString("call_number"));
                String str = rs.getString("alert_msg");
                demo.setAlertMsg(str);
                demo.setMaxLimitNumber(Integer.valueOf(rs.getString("maxLimit_number")));
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
        return demo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPhoneMsgSentCount(String phoneno) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        String nowyear = "" + year;
        String nowmonth = "" + month;
        String nowday = "" + day;
        String nowhour = "" + hour;
        String nowminute = "" + minute;
        String nowsecond = "" + second;
        if (nowmonth.length() == 1) {
            nowmonth = "0" + nowmonth;
        }
        if (nowday.length() == 1) {
            nowday = "0" + nowday;
        }
        if (nowhour.length() == 1) {
            nowhour = "0" + nowhour;
        }
        if (nowminute.length() == 1) {
            nowminute = "0" + nowminute;
        }
        if (nowsecond.length() == 1) {
            nowsecond = "0" + nowsecond;
        }
        String now = nowday + nowhour + nowminute + nowsecond;
        String startday = JDSMSServer.getInstance().getProperties().getString("settings.settlement_interval_day_begin", "15");
        String starthour = JDSMSServer.getInstance().getProperties().getString("settings.settlement_interval_hour_begin", "00");
        String startminute = JDSMSServer.getInstance().getProperties().getString("settings.settlement_interval_min_begin", "00");
        String startsecond = JDSMSServer.getInstance().getProperties().getString("settings.settlement_interval_second_begin", "00");
        if (startday.length() == 1) {
            startday = "0" + startday;
        }
        if (starthour.length() == 1) {
            starthour = "0" + starthour;
        }
        if (startminute.length() == 1) {
            startminute = "0" + startminute;
        }
        if (startsecond.length() == 1) {
            startsecond = "0" + startsecond;
        }
        String start = startday + starthour + startminute + startsecond;
        String endday = JDSMSServer.getInstance().getProperties().getString("settings.settlement_interval_day_end", "14");
        String endhour = JDSMSServer.getInstance().getProperties().getString("settings.settlement_interval_hour_end", "23");
        String endminute = JDSMSServer.getInstance().getProperties().getString("settings.settlement_interval_min_end", "59");
        String endsecond = JDSMSServer.getInstance().getProperties().getString("settings.settlement_interval_second_end", "59");
        if (endday.length() == 1) {
            endday = "0" + endday;
        }
        if (endhour.length() == 1) {
            endhour = "0" + endhour;
        }
        if (endminute.length() == 1) {
            endminute = "0" + endminute;
        }
        if (endsecond.length() == 1) {
            endsecond = "0" + endsecond;
        }
        String end = endday + endhour + endminute + endsecond;
        if (now.compareTo(start) >= 0) {
            start = nowyear + nowmonth + start;
            end = now.compareTo(end) <= 0 ? nowyear + nowmonth + end : (nowmonth.equals("12") ? String.valueOf(Integer.parseInt(nowyear) + 1) + "01" + end : nowyear + String.valueOf(Integer.parseInt(nowmonth) + 1) + end);
        } else {
            start = nowmonth.equals("01") ? String.valueOf(Integer.parseInt(nowyear) - 1) + "12" + start : nowyear + String.valueOf(Integer.parseInt(nowmonth) - 1) + start;
            end = now.compareTo(end) <= 0 ? nowyear + nowmonth + end : (nowmonth.equals("12") ? String.valueOf(Integer.parseInt(nowyear) + 1) + nowmonth + end : nowyear + String.valueOf(Integer.parseInt(nowmonth) + 1) + end);
        }
        Timestamp datestart = null;
        Timestamp dateend = null;
        try {
            datestart = this.DateFromString(start);
            dateend = this.DateFromString(end);
        }
        catch (ParseException e2) {
            e2.printStackTrace();
        }
        int msgSentCount = 0;
        String sql = "select count(1) as MsgSentCount from " + this.getProperty("tables.sms_out") + " where gateway_id = '" + phoneno + "' and sent_date >= '" + datestart + "' and sent_date <= '" + dateend + "'";
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                msgSentCount = rs.getInt("MsgSentCount");
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        finally {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
        return msgSentCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProcess(int id, int processStatus) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String sql = "update  %s set  process = ? where id = ? ";
        sql = String.format(sql, this.getProperty("tables.sms_in"));
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, processStatus);
            pstmt.setInt(2, id);
            pstmt.execute();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InboundMessage> getProcess(int processStatus) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        ArrayList<InboundMessage> msgList = new ArrayList<InboundMessage>();
        String sql = "select id,gateway_id,text,originator from  %s where  process = " + processStatus + "";
        sql = String.format(sql, this.getProperty("tables.sms_in"));
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                InboundMessage inboundMessage = new InboundMessage(new Date(), rs.getString("originator"), rs.getString("text"), rs.getString("gateway_id"));
                inboundMessage.setPushMsgId(rs.getInt("id"));
                msgList.add(inboundMessage);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InboundMessage> getProcessFail(int processStatus, long day) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        ArrayList<InboundMessage> msgList = new ArrayList<InboundMessage>();
        long starttime = new Date().getTime();
        day = day * 24L * 60L * 60L * 1000L;
        long endtime = starttime -= day;
        Timestamp sTime = new Timestamp(endtime);
        String sql = "select id,gateway_id,text,originator from  " + this.getProperty("tables.sms_in") + " where  process = " + processStatus + " and receive_date >= '" + sTime + "'";
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                InboundMessage inboundMessage = new InboundMessage(new Date(), rs.getString("originator"), rs.getString("text"), rs.getString("gateway_id"));
                inboundMessage.setPushMsgId(rs.getInt("id"));
                msgList.add(inboundMessage);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            ConnectionPool.getInstance().returnConnection(conn);
        }
        return msgList;
    }

    public abstract Page waitForSendMsgList(int var1, User var2) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException;

    public abstract Page getUserList(int var1) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException;

    public abstract Page getAddRecordList(String var1, int var2) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException;

    public abstract void cancelWaitMsg(User var1) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException;

    public abstract void deleteCanceledMsg(User var1) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException;

    public abstract Page findMsgByCondition(Condition var1, User var2) throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException;

    public abstract List findAllMsgByCondition(Condition var1, User var2) throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException;

    public abstract boolean modifySendTable(String var1);

    protected String GenerateRecvSQL(String gatewayid) {
        String sql = "";
        if (!"".equals(gatewayid)) {
            sql = " where gateway_id='" + gatewayid + "' ";
        }
        return sql;
    }

    protected String GenerateRecvSQL(String gatewayid, int minId) {
        String sql = "";
        sql = !"".equals(gatewayid) ? " where gateway_id='" + gatewayid + "' and id>" + minId : " where id>" + minId;
        return sql;
    }

    private String a() {
        String flag = "*";
        int isorted = Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.using_sorted", "0"));
        String device_using = JDSMSServer.getInstance().getProperties().getString("settings.device_using", "yes");
        String phone_using = JDSMSServer.getInstance().getProperties().getString("settings.phone_using", "yes");
        String gateway_using = JDSMSServer.getInstance().getProperties().getString("settings.gateway_using", "yes");
        switch (isorted) {
            case 0: {
                if (device_using.equals("yes")) {
                    flag = "*";
                    break;
                }
                if (gateway_using.equals("yes")) {
                    flag = "#";
                    break;
                }
                if (!phone_using.equals("yes")) break;
                flag = "$";
                break;
            }
            case 1: {
                if (device_using.equals("yes")) {
                    flag = "*";
                    break;
                }
                if (phone_using.equals("yes")) {
                    flag = "$";
                    break;
                }
                if (!gateway_using.equals("yes")) break;
                flag = "#";
                break;
            }
            case 2: {
                if (gateway_using.equals("yes")) {
                    flag = "#";
                    break;
                }
                if (device_using.equals("yes")) {
                    flag = "*";
                    break;
                }
                if (!phone_using.equals("yes")) break;
                flag = "$";
                break;
            }
            case 3: {
                if (gateway_using.equals("yes")) {
                    flag = "#";
                    break;
                }
                if (phone_using.equals("yes")) {
                    flag = "$";
                    break;
                }
                if (!device_using.equals("yes")) break;
                flag = "*";
                break;
            }
            case 4: {
                if (phone_using.equals("yes")) {
                    flag = "$";
                    break;
                }
                if (device_using.equals("yes")) {
                    flag = "*";
                    break;
                }
                if (!gateway_using.equals("yes")) break;
                flag = "#";
                break;
            }
            case 5: {
                if (phone_using.equals("yes")) {
                    flag = "$";
                    break;
                }
                if (gateway_using.equals("yes")) {
                    flag = "#";
                    break;
                }
                if (!device_using.equals("yes")) break;
                flag = "*";
                break;
            }
        }
        return flag;
    }
}

