/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.web;

import cn.sendsms.Service;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.helper.Logger;
import cn.sendsms.jdsmsserver.web.GetPortInfo;
import cn.sendsms.jdsmsserver.web.SerialModemBean;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Properties;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jssc.SerialPort;
import jssc.SerialPortException;
import org.apache.commons.io.IOUtils;

public class GetSerialPortInfo
extends GetPortInfo {
    protected SerialPort serialPort = null;
    private InputStream inStream = null;
    private OutputStream outStream = null;
    protected Properties options = null;
    public static int[] botelvs = new int[]{115200, 9600};
    public static final String PORT_NAME = "portname";
    public static final String BAUDRATE = "baudrate";
    public static final String AT = "at";
    public static final String NOCSQ = "csq";
    public static final String NOCCID = "ccid";
    public static final String NOVERSION = "version";
    public static final String NOMODEL = "model";
    public static final String NOSERIALNUMBER = "serialnumber";
    public static final String NOMANUFACTURER = "manufacturer";
    public static final String CFUN = "cfun";
    public static final int SERVER_PORT = 8092;

    public GetSerialPortInfo(Properties options) {
        this.options = options;
        this.serialmodem = new SerialModemBean(options.getProperty(PORT_NAME, ""), null);
    }

    protected void open() throws Exception {
        this.serialPort = new SerialPort(this.serialmodem.getPort());
        boolean flag = this.serialPort.openPort();
        this.serialPort.setFlowControlMode(0);
    }

    protected void init(int botelv) throws Exception {
        this.serialPort.setParams(botelv, 8, 1, 0);
        this.serialmodem.setBaudrate(botelv);
    }

    protected void testOK() throws Exception {
        String response = "";
        String[] result = null;
        boolean flag = this.serialPort.writeString("AT\r");
        Thread.sleep(Service.getInstance().getSettings().AT_WAIT);
        int count1 = 0;
        while (this.serialPort.getInputBufferBytesCount() <= 0) {
            Thread.sleep(200L);
            if (++count1 != 15) continue;
        }
        if (count1 >= 15 && this.serialPort.getInputBufferBytesCount() <= 0) {
            Logger.getInstance().logError("\u8d85\u8fc73s\u53d1\u9001at\u6307\u4ee4\u6ca1\u6709\u5f97\u5230\u8fd4\u56de\u6570\u636e", null, null);
            throw new Exception();
        }
        response = this.serialPort.readString();
        flag = this.serialPort.writeBytes("AT\r".getBytes());
        Thread.sleep(Service.getInstance().getSettings().AT_WAIT);
        count1 = 0;
        while (this.serialPort.getInputBufferBytesCount() <= 0) {
            Thread.sleep(200L);
            if (++count1 != 30) continue;
        }
        if ((result = (response = this.serialPort.readString()).replaceAll("\\s+\\s+", " ").replaceAll("\n", " ").replaceAll("\r", " ").split(" "))[result.length - 1].indexOf("OK") == -1 && result[result.length - 1].indexOf("ERROR") == -1) {
            throw new Exception();
        }
        this.serialmodem.setAtFlag(result[result.length - 1]);
    }

    protected void getCardNumber() throws Exception {
        if (this.options.getProperty(NOCCID) != null) {
            return;
        }
        String result = null;
        result = this.athandle("AT+CCID\r");
        if (result.indexOf("ERROR") == -1) {
            this.serialmodem.setCcid(result.substring(result.indexOf(58) + 1));
        }
    }

    protected void getCardNumberForINCORPORATED() throws Exception {
        if (this.options.getProperty(NOCCID) != null) {
            return;
        }
        String result = null;
        result = this.athandle("AT+CICCID\r");
        if (result.indexOf("ERROR") == -1) {
            this.serialmodem.setCcid(result.substring(result.indexOf(58) + 1));
        }
    }

    protected void getCardNumber2() throws Exception {
        if (this.options.getProperty(NOCCID) != null) {
            return;
        }
        String result = null;
        result = this.athandle("AT^ICCID?\r");
        if (result.indexOf("ERROR") == -1) {
            this.serialmodem.setCcid(result.substring(result.indexOf(58) + 1));
        }
    }

    protected void getCardNumber3() throws Exception {
        this.getCardNumber2();
    }

    protected void getCardNumber1() throws Exception {
        if (this.options.getProperty(NOCCID) != null) {
            return;
        }
        String result = null;
        result = this.athandle("AT+CXXCID\r");
        if (result.indexOf("ERROR") == -1) {
            this.serialmodem.setCcid(result.substring(result.indexOf(58) + 1));
        }
    }

    protected void getCardNumber4() throws Exception {
        if (this.options.getProperty(NOCCID) != null) {
            return;
        }
        String result = null;
        result = this.athandle("AT+ICCID\r");
        if (result.indexOf("ERROR") == -1) {
            this.serialmodem.setCcid(result.substring(result.indexOf(58) + 1));
        }
    }

    protected void getSignal() throws Exception {
        if (this.options.getProperty(NOCSQ) != null) {
            return;
        }
        String result = null;
        String matchStr = "\\+CSQ:\\s*\\d{1,2},\\d{1,2}";
        Pattern signalPattern = Pattern.compile(matchStr);
        Matcher signalMatcher = signalPattern.matcher(result = this.athandle("AT+CSQ\r"));
        if (signalMatcher.find()) {
            result = signalMatcher.group(0);
            this.serialmodem.setCsq(result.substring(result.indexOf(58) + 1));
        } else if (result.indexOf("ERROR") == -1) {
            throw new Exception();
        }
    }

    protected String getVersion() throws Exception {
        if (this.options.getProperty(NOVERSION) != null) {
            return NOVERSION;
        }
        String result = null;
        result = this.athandle("ATI3\r");
        if (result == null) {
            return NOVERSION;
        }
        return result;
    }

    protected void getSerialNumber() throws Exception {
        if (this.options.getProperty(NOSERIALNUMBER) != null) {
            return;
        }
        String result = null;
        String matchStr = "SerialNumber[a-z0-9A-Z]+";
        String matchStr1 = "\\+WMSN:SerialNumber:[a-z0-9A-Z]+";
        Logger.getInstance().logInfo("TO SEND AT+WMSN (2)", null, null);
        result = this.athandle("AT+WMSN\r");
        if (result.matches(matchStr) || result.matches(matchStr1)) {
            if (result.matches(matchStr)) {
                this.serialmodem.setSerialnum(result.replace("SerialNumber", ""));
            } else {
                this.serialmodem.setSerialnum(result.replaceFirst("\\+WMSN:SerialNumber:", ""));
            }
        } else if (result.indexOf("SerialNumber") != -1) {
            this.serialmodem.setSerialnum(result.substring(result.indexOf("SerialNumber") + 12));
        } else if (result.indexOf("ERROR") != -1) {
            this.getSerialNumber1();
        } else if (result.indexOf("NOT") != -1) {
            this.getSerialNumber1();
        } else {
            throw new Exception();
        }
    }

    protected void getSerialNumber1() throws Exception {
        if (this.options.getProperty(NOSERIALNUMBER) != null) {
            return;
        }
        String result = null;
        String matchStr = "[a-z0-9A-Z]+";
        result = this.athandle("AT+CGSN\r");
        if ((result = result.substring(result.indexOf(58) + 1)).matches(matchStr)) {
            this.serialmodem.setSerialnum(result.substring(result.indexOf(58) + 1));
        } else if (result.indexOf("ERROR") == -1) {
            throw new Exception();
        }
    }

    protected void getManufacturer() throws Exception {
        if (this.options.getProperty(NOMANUFACTURER) != null) {
            return;
        }
        String result = null;
        result = this.athandle("ATI\r");
        System.out.println("result=" + result);
        if (result.indexOf("ERROR") != -1) {
            this.serialmodem.setManufacturer("");
        } else if (result.indexOf("WAVECOM") != -1 || result.indexOf("WISMOQ") != -1 || result.indexOf("SierraWireless") != -1) {
            this.serialmodem.setManufacturer("Wavecom");
        } else if (result.indexOf("SIEMENS") != -1) {
            this.serialmodem.setManufacturer("Siemens");
        } else if (result.indexOf("Quectel_Ltd") != -1) {
            this.serialmodem.setManufacturer("Quectel_Ltd");
        } else if (result.indexOf("Quectel") != -1) {
            this.serialmodem.setManufacturer("Quectel");
        } else if (result.indexOf("Yuga") != -1) {
            this.serialmodem.setManufacturer("Yuga");
        } else if (result.indexOf("TDTech") != -1) {
            this.serialmodem.setManufacturer("TDTech");
        } else if (result.indexOf("INCORPORATED") != -1) {
            this.serialmodem.setManufacturer("INCORPORATED");
        } else if (result.indexOf("MEIG") != -1) {
            this.serialmodem.setManufacturer("MEIG");
        } else if ((result = result.toLowerCase()).indexOf("huawei") != -1) {
            this.serialmodem.setManufacturer("Huawei");
        } else {
            throw new Exception();
        }
    }

    protected void getModel1() throws Exception {
        if (this.options.getProperty(NOMODEL) != null) {
            return;
        }
        String result = null;
        result = this.athandle("AT+CGMR\r");
        System.out.println("debug: " + result);
        if (result.indexOf("ERROR") != -1) {
            this.serialmodem.setModel("");
        } else if (result.indexOf("WISM") != -1) {
            this.serialmodem.setModel("WISMOQCDMA");
        } else {
            this.serialmodem.setModel("");
        }
    }

    protected void getModel2() throws Exception {
        this.getModel();
    }

    protected void getModel() throws Exception {
        if (this.options.getProperty(NOMODEL) != null) {
            return;
        }
        String result = null;
        result = this.athandle("AT+CGMM\r");
        if (result.indexOf("ERROR") != -1) {
            this.serialmodem.setModel("");
        } else if (result.indexOf("Quectel_M35") != -1) {
            this.serialmodem.setModel("Quectel_M35");
        } else if (result.indexOf("Quectel_M26") != -1) {
            this.serialmodem.setModel("Quectel_M26");
        } else if (result.indexOf("EC20F") != -1) {
            this.serialmodem.setModel("EC20F");
        } else if (result.indexOf("MC323") != -1) {
            this.serialmodem.setModel("MC323");
        } else if (result.indexOf("MG301") != -1) {
            this.serialmodem.setModel("MG301");
        } else if (result.indexOf("ME909") != -1) {
            this.serialmodem.setModel("ME909");
        } else if (result.indexOf("MH5000-82M") != -1) {
            this.serialmodem.setModel("MH5000-82M");
        } else if (result.indexOf("ME901") != -1) {
            this.serialmodem.setModel("ME901");
        } else if (result.indexOf("CLM920_NC5") != -1) {
            this.serialmodem.setModel("CLM920_NC5");
        } else if (result.indexOf("CLM920_RC3") != -1) {
            this.serialmodem.setModel("CLM920_RC3");
        } else if (result.indexOf("CLM920_RV3") != -1) {
            this.serialmodem.setModel("CLM920_RV3");
        } else if (result.indexOf("A7600C1-SE") != -1) {
            this.serialmodem.setModel("A7600C1_SE");
        } else if (result.indexOf("SIMCOM_SIM7600CE-L") != -1) {
            this.serialmodem.setModel("7600CE_L");
        } else if (result.indexOf("SIMCOM_SIM7600CE-JT1S") != -1) {
            this.serialmodem.setModel("7600CE_JT1S");
        } else if (result.indexOf("SIMCOM_SIM7600CE-T") != -1) {
            this.serialmodem.setModel("7600CE_T");
        } else if (result.indexOf("MH5000-31") != -1) {
            this.serialmodem.setModel("MH5000-31");
        } else if (result.indexOf("SLM750-V") != -1) {
            this.serialmodem.setModel("SLM750_V");
        } else {
            this.serialmodem.setModel("");
        }
    }

    protected String athandle(String cmd) throws Exception {
        String response = null;
        this.outStream.write(cmd.getBytes());
        this.outStream.flush();
        response = "";
        int c2 = this.inStream.read();
        while (c2 != -1) {
            response = response + (char)c2;
            c2 = this.inStream.read();
        }
        System.out.println(response);
        response = response.replace(cmd, "").replaceAll("\\s+OK\\s+", "").replaceAll("\\s+", "");
        return response;
    }

    protected void close() {
        IOUtils.closeQuietly((InputStream)this.inStream);
        IOUtils.closeQuietly((OutputStream)this.outStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handler() {
        try {
            this.open();
        }
        catch (Exception e1) {
            if (e1 instanceof RuntimeException) {
                // empty if block
            }
            this.serialmodem.setStatus(AGatewayHelper.GatewayStatuses.FAILURE);
            e1.printStackTrace();
            return;
        }
        for (int i2 = 0; i2 < botelvs.length; ++i2) {
            int botelv = Integer.parseInt(this.options.getProperty(BAUDRATE, "0"));
            try {
                String result;
                if (botelv == 0) {
                    this.init(botelvs[i2]);
                } else {
                    this.init(botelv);
                }
                this.serialmodem.setStatus(AGatewayHelper.GatewayStatuses.STOPPED);
                this.testOK();
                this.getSignal();
                this.getManufacturer();
                if (this.serialmodem.getManufacturer().equalsIgnoreCase("Siemens")) {
                    this.getModel2();
                    this.getCardNumber1();
                    this.getSerialNumber1();
                } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("Huawei")) {
                    this.getModel2();
                    if (this.serialmodem.getModel().equalsIgnoreCase("MC323")) {
                        this.serialmodem.setProtocol(AGatewayHelper.Protocols.TEXT);
                        this.a();
                    }
                    if (this.serialmodem.getModel().equalsIgnoreCase("MG301")) {
                        result = null;
                        result = this.athandle("AT+CGSN\r");
                        this.serialmodem.setSerialnum(result);
                    }
                    this.getCardNumber();
                } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("WAVECOM")) {
                    this.getModel1();
                    if (this.serialmodem.getModel().equalsIgnoreCase("WISMOQCDMA")) {
                        this.getSerialNumber1();
                        this.serialmodem.setProtocol(AGatewayHelper.Protocols.TEXT);
                    } else {
                        this.getSerialNumber();
                    }
                    this.getCardNumber();
                } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("Yuga")) {
                    this.getModel();
                    if (this.serialmodem.getModel().equalsIgnoreCase("CLM920_RC3")) {
                        this.getCardNumber4();
                    } else if (this.serialmodem.getModel().equalsIgnoreCase("CLM920_RV3")) {
                        this.getCardNumber4();
                    } else if (this.serialmodem.getModel().equalsIgnoreCase("CLM920_NC5")) {
                        this.getCardNumber();
                    }
                } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("INCORPORATED")) {
                    this.getModel();
                    if (this.serialmodem.getModel().equalsIgnoreCase("A7600C1_SE")) {
                        result = null;
                        result = this.athandle("AT+CGSN\r");
                        this.serialmodem.setSerialnum(result);
                        this.getCardNumberForINCORPORATED();
                    } else if (this.serialmodem.getModel().equalsIgnoreCase("7600CE_L") || this.serialmodem.getModel().equalsIgnoreCase("7600CE_JT1S") || this.serialmodem.getModel().equalsIgnoreCase("7600CE_T")) {
                        result = null;
                        result = this.athandle("AT+CGSN\r");
                        this.serialmodem.setSerialnum(result);
                        this.getCardNumberForINCORPORATED();
                    }
                } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("TDTech")) {
                    this.getModel();
                    if (this.serialmodem.getModel().equalsIgnoreCase("ME909")) {
                        result = null;
                        result = this.athandle("AT+CGSN\r");
                        this.serialmodem.setSerialnum(result);
                        this.getCardNumber2();
                    } else if (this.serialmodem.getModel().equalsIgnoreCase("MH5000-82M")) {
                        result = null;
                        result = this.athandle("AT+CGSN\r");
                        this.serialmodem.setSerialnum(result);
                        this.getCardNumber2();
                    } else if (this.serialmodem.getModel().equalsIgnoreCase("ME901")) {
                        result = null;
                        result = this.athandle("AT+CGSN\r");
                        this.serialmodem.setSerialnum(result);
                        this.getCardNumber();
                    }
                } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("MEIG")) {
                    this.getModel();
                    if (this.serialmodem.getModel().equalsIgnoreCase("SLM750_V")) {
                        this.getCardNumber4();
                    }
                }
            }
            catch (Exception e2) {
                if (!this.serialmodem.getAtFlag().equals("OK")) {
                    this.serialmodem.setStatus(AGatewayHelper.GatewayStatuses.FAILURE);
                }
            }
            if (this.serialmodem.getStatus() != AGatewayHelper.GatewayStatuses.FAILURE || botelv != 0) break;
        }
        if (this.serialPort != null && this.serialPort.isOpened()) {
            try {
                this.serialPort.closePort();
            }
            catch (SerialPortException e3) {
                e3.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Properties options = new Properties();
        try {
            Socket client = new Socket();
            client.connect(new InetSocketAddress("127.0.0.1", 8092), 10000);
            ObjectInputStream oin = new ObjectInputStream(client.getInputStream());
            options = (Properties)oin.readObject();
            GetSerialPortInfo getter = new GetSerialPortInfo(options);
            getter.handler();
            ObjectOutputStream oout = new ObjectOutputStream(client.getOutputStream());
            oout.writeObject(getter.serialmodem);
            oout.flush();
            client.getInputStream().read();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (ClassNotFoundException e3) {
            e3.printStackTrace();
        }
        System.exit(0);
    }

    private static String getWMSN() {
        char[] nums = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
        Random rand = new Random();
        String wmsn = "";
        for (int i2 = 0; i2 < 17; ++i2) {
            wmsn = wmsn + nums[rand.nextInt(10)];
        }
        return wmsn;
    }

    private void a() throws Exception {
        String wmsn;
        String result = null;
        result = this.athandle("AT+CPBS=\"ME\"\r");
        result = this.athandle("AT^CPBR=1\r");
        String key = "";
        if (result.indexOf("ERROR") != -1) {
            wmsn = GetSerialPortInfo.getWMSN();
            this.athandle("AT^CPBW=1,\"" + wmsn + "\",129,\"WMSN\"\r");
            result = this.athandle("AT^CPBR=1\r");
        } else {
            key = result.substring(result.lastIndexOf(44, result.length() - 3) + 1, result.lastIndexOf(","));
            System.out.println("key:" + key);
            if ((result.equals("") || !key.equals("\"WMSN\"")) && result.indexOf("ERROR") == -1) {
                wmsn = GetSerialPortInfo.getWMSN();
                this.athandle("AT^CPBW=1,\"" + wmsn + "\",129,\"WMSN\"\r");
                result = this.athandle("AT^CPBR=1\r");
            }
        }
        result = result.substring(result.indexOf(58) + 1);
        key = result.substring(result.lastIndexOf(44, result.length() - 3) + 1, result.lastIndexOf(","));
        if (result.indexOf("ERROR") != -1) {
            return;
        }
        if (result.trim().equals("")) {
            return;
        }
        if (!key.equals("\"WMSN\"")) {
            return;
        }
        String str = result.split(",")[1];
        this.serialmodem.setSerialnum(str.substring(1, str.length() - 1));
    }
}

