/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.web;

import cn.sendsms.crypto.PwdConf;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.ResourceManager;
import cn.sendsms.jdsmsserver.web.DbHelper;
import cn.sendsms.jdsmsserver.web.JDWebAction;
import cn.sendsms.jdsmsserver.web.User;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SecurityAction
extends JDWebAction {
    private static final long serialVersionUID = 1L;
    private String newpwd;
    private String oldpwd;
    private String confirmpwd;

    public void modifyPwd(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String message = null;
        if (!this.newpwd.equals(this.confirmpwd)) {
            message = ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.modify_psw_not_same");
            req.setAttribute("message", (Object)message);
            this.findForward("modify-password.jsp", true, req, resp);
            return;
        }
        User user = (User)req.getSession(true).getAttribute("user");
        if (user == null || !user.getPassword().equals(this.oldpwd)) {
            message = ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.modify_psw_old_error");
            req.setAttribute("message", (Object)message);
            this.findForward("modify-password.jsp", true, req, resp);
            return;
        }
        try {
            user.setPassword(this.newpwd);
            DbHelper helper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            helper.modifyUserPassword(user);
            if ("admin".equalsIgnoreCase(user.getUserId())) {
                JDSMSServer.getInstance().getProperties().setProperty("console.enc", (Object)"1");
                JDSMSServer.getInstance().getProperties().setProperty("console.password", (Object)PwdConf.encPwd(user.getPassword()));
                JDSMSServer.getInstance().getProperties().save();
            }
            req.getSession(true).setAttribute("user", (Object)user);
        }
        catch (Exception e2) {
            message = ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.modify_psw_failure_info");
            req.setAttribute("message", (Object)message);
            this.findForward("modify-password.jsp", true, req, resp);
            return;
        }
        message = ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.modify_psw_success_info");
        req.setAttribute("message", (Object)message);
        this.findForward("modify-password.jsp", true, req, resp);
    }
}

