/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem.athandler;

import cn.ajwcc.pduUtils.gsm3040.Pdu;
import cn.ajwcc.pduUtils.gsm3040.PduParser;
import cn.sendsms.AGateway;
import cn.sendsms.GatewayException;
import cn.sendsms.InboundMessage;
import cn.sendsms.Service;
import cn.sendsms.TimeoutException;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.helper.Logger;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.web.DeviceInfoCache;
import cn.sendsms.jdsmsserver.web.SerialModemBean;
import cn.sendsms.modem.AModemDriver;
import cn.sendsms.modem.CNMIDetector;
import cn.sendsms.modem.ModemGateway;
import cn.sendsms.modem.athandler.AATHandler;
import cn.sendsms.util.GSM0338;
import java.io.IOException;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ATHandler
extends AATHandler {
    protected Pattern delLineSeparatorAfterCMGR = Pattern.compile("(\\+CMGR:.*?)[\r|\n]{1,}");
    protected AModemDriver modemDriver;
    protected CNMIDetector cnmiDetector;
    protected static final int DEFAULT_USSD_DCS_NUM = 15;

    @Override
    public String getCXXCID() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CXXCID\r");
        String response = this.getModemDriver().getResponse();
        return response;
    }

    @Override
    public String getCSQ() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CSQ\r");
        String response = this.getModemDriver().getResponse();
        return response;
    }

    @Override
    public int getCSQValue() throws TimeoutException, GatewayException, IOException, InterruptedException {
        String szCSQ = this.getCSQ();
        if (szCSQ == null) {
            return 0;
        }
        if (szCSQ.length() < 2) {
            return 0;
        }
        String matchStr = "\\+CSQ:\\s*\\d{1,2},\\s*\\d{1,2}";
        Pattern signalPattern = Pattern.compile(matchStr);
        Matcher signalMatcher = signalPattern.matcher(szCSQ);
        if (!signalMatcher.find()) {
            return 0;
        }
        String szTmp = signalMatcher.group(0);
        int n1 = szTmp.indexOf("+CSQ:");
        int n2 = szTmp.indexOf(",", n1);
        String szVal = szTmp.substring(n1 + 5, n2).trim();
        int nVal = Integer.parseInt(szVal);
        return nVal;
    }

    @Override
    public void checkMode() throws TimeoutException, GatewayException, IOException, InterruptedException {
    }

    @Override
    public String getCCID() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CCID\r");
        String response = this.getModemDriver().getResponse();
        return response;
    }

    public AModemDriver getModemDriver() {
        return this.modemDriver;
    }

    public ATHandler(ModemGateway myGateway) {
        super(myGateway);
        this.modemDriver = myGateway.getModemDriver();
        this.cnmiDetector = null;
        this.terminators = new String[15];
        this.terminators[0] = "OK\\s";
        this.terminators[1] = "\\s*[\\p{ASCII}]*\\s+OK\\s";
        this.terminators[2] = "\\s*(ERROR|NO CARRIER|NO DIALTONE)\\s";
        this.terminators[3] = "ERROR:\\s*\\d+\\s";
        this.terminators[4] = "[>]*([\\s\\S]*)\\+CM[ES]\\s+ERROR:\\s*\\d+\\s*";
        this.terminators[5] = "\\s*[\\p{ASCII}]*\\s*\\+CPIN:\\s*READY\\s";
        this.terminators[6] = "\\+CPIN:\\s*SIM\\s*BUSY\\s";
        this.terminators[7] = "\\+CPIN:\\s*SIM\\s*PIN\\s";
        this.terminators[8] = "\\+CPIN:\\s*SIM\\s*PIN2\\s";
        this.terminators[9] = "fge";
        this.terminators[10] = "\\+CUSD:\\s.*\\s";
        this.terminators[11] = "[>]*([\\s\\S]*)\\+CMTI:\\s*\\p{Punct}[\\p{ASCII}]+\\p{Punct}\\p{Punct}\\s*\\d+\\s*([\\s\\S]*)";
        this.terminators[12] = "\\+CDSI:\\s*\\p{Punct}[\\p{ASCII}]+\\p{Punct}\\p{Punct}\\s*\\d+\\s";
        this.terminators[13] = "RING";
        this.terminators[14] = "\\+CLIP:\\s*\\p{Punct}[\\p{ASCII}]*\\p{Punct}\\p{Punct}\\s*\\d+[\\p{ASCII}]*\\s*";
        this.unsolicitedResponses = new String[5];
        this.unsolicitedResponses[0] = "+CMTI";
        this.unsolicitedResponses[1] = "+CDSI";
        this.unsolicitedResponses[2] = "RING";
        this.unsolicitedResponses[3] = "+CLIP";
        this.unsolicitedResponses[4] = "+CUSD";
    }

    @Override
    public void sync() throws IOException, InterruptedException {
        this.getModemDriver().write("ATZ\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
    }

    @Override
    public int getSimNums() throws TimeoutException, GatewayException, IOException, InterruptedException {
        if ("1".equals(JDSMSServer.getInstance().getProperties().getString("settings.sendfirst", "1"))) {
            return 0;
        }
        this.getModemDriver().write("AT+CPMS?\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        String response = this.getModemDriver().getResponse();
        int nums = 0;
        int result = response.indexOf("CPMS");
        if (result != -1) {
            int start1 = response.indexOf(",", result);
            int end1 = response.indexOf(",", start1 + 1);
            nums = Integer.valueOf(response.substring(start1 + 1, end1));
        }
        return nums;
    }

    @Override
    public void reset() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().clearBuffer();
    }

    @Override
    public void echoOff() throws IOException, InterruptedException {
        this.getModemDriver().write("ATE0\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().clearBuffer();
    }

    @Override
    public void init() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CLIP=1\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CNMI=1,1,0,1,1\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().getResponse();
        SerialModemBean bean = DeviceInfoCache.getInstance().get(this.getGateway().getGatewayId());
        if (bean.getManufacturer().equalsIgnoreCase("Quectel") && bean.getModel().equalsIgnoreCase("EC20F")) {
            this.getModemDriver().write("AT+QCFG=\"nwscanmode\",0,1\r");
            this.threadWait(Service.getInstance().getSettings().AT_WAIT);
            this.getModemDriver().getResponse();
            this.getModemDriver().write("AT+QCFG=\"nwscanseq\",04,1\r");
            this.threadWait(Service.getInstance().getSettings().AT_WAIT);
            this.getModemDriver().getResponse();
        } else if (bean.getManufacturer().equals("INCORPORATED") && bean.getModel().equals("7600CE_L")) {
            this.getModemDriver().write("AT+CNMP=38\r");
            this.threadWait(Service.getInstance().getSettings().AT_WAIT);
            this.getModemDriver().getResponse();
        } else if (bean.getManufacturer().equals("INCORPORATED") && bean.getModel().equals("7600CE_JT1S")) {
            this.getModemDriver().write("AT+CNMP=38\r");
            this.threadWait(Service.getInstance().getSettings().AT_WAIT);
            this.getModemDriver().getResponse();
        } else if (bean.getManufacturer().equals("INCORPORATED") && bean.getModel().equals("7600CE_T")) {
            this.getModemDriver().write("AT+CNMP=38\r");
            this.threadWait(Service.getInstance().getSettings().AT_WAIT);
            this.getModemDriver().getResponse();
        }
    }

    @Override
    public String readTextMode() throws GatewayException, TimeoutException, IOException, InterruptedException {
        return "";
    }

    @Override
    public void done() throws TimeoutException, GatewayException, IOException, InterruptedException {
    }

    @Override
    public boolean isAlive() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT\r");
        this.threadWait(200L);
        String response = this.getModemDriver().getResponse();
        Logger.getInstance().logInfo("isAlive\u8fd4\u56de" + response, null, this.getGateway().getGatewayId());
        if (response.indexOf("OK") != -1 || response.indexOf("ok") != -1) {
            return true;
        }
        if (response.indexOf("AT\r") == -1) {
            return this.getModemDriver().isOk();
        }
        return false;
    }

    public static String toHexString(String s) {
        String str = "";
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char ch = s.charAt(i2);
            String s4 = Integer.toHexString(ch);
            str = str + s4;
        }
        return str;
    }

    @Override
    public String getSimStatus() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CPIN?\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public boolean enterPin(String pin) throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CPIN=\"_1_\"\r".replaceAll("_1_", pin));
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    @Override
    public boolean setVerboseErrors() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CMEE=1\r");
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    @Override
    public boolean setPduProtocol() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CMGF=0\r");
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    @Override
    public boolean setTextProtocol() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CMGF=1\r");
        this.getModemDriver().getResponse();
        if (this.getModemDriver().isOk()) {
            this.getModemDriver().write("AT+CSCS=\"GSM\"\r");
            this.getModemDriver().getResponse();
            return this.getModemDriver().isOk();
        }
        return false;
    }

    @Override
    public boolean setIndications() throws TimeoutException, GatewayException, IOException, InterruptedException {
        int RETRIES = 10;
        for (int count = 0; count < RETRIES; ++count) {
            this.getModemDriver().write("AT+CNMI=?\r");
            try {
                this.cnmiDetector = new CNMIDetector(this.getModemDriver().getResponse());
                this.getModemDriver().write(this.cnmiDetector.getATCommand());
                this.getModemDriver().getResponse();
                return this.getModemDriver().isOk();
            }
            catch (Exception e2) {
                e2.printStackTrace();
                Logger.getInstance().logWarn("Retrying the detection of CNMI, modem busy?", null, this.getGateway().getGatewayId());
                this.threadWait(Service.getInstance().getSettings().AT_WAIT_CNMI);
                continue;
            }
        }
        Logger.getInstance().logWarn("CNMI detection failed, proceeding with defaults.", null, this.getGateway().getGatewayId());
        return false;
    }

    @Override
    public CNMIDetector getIndications() {
        return this.cnmiDetector;
    }

    @Override
    public String getManufacturer() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CGMI\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public String getModel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CGMM\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public String getSerialNo() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CGSN\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public String getImsi() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CIMI\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public String getSwVersion() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CGMR\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public String getBatteryLevel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CBC\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public String getSignalLevel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CSQ\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public boolean switchStorageLocation(String mem) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (mem.equalsIgnoreCase("--")) {
            return true;
        }
        this.getModemDriver().write("ATE0\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CPMS=\"" + mem + "\",\"" + mem + "\",\"" + mem + "\"\r");
        this.getModemDriver().getResponse();
        boolean bOk = this.getModemDriver().isOk();
        if (!bOk) {
            this.getModemDriver().write("AT+CFUN=1,0\r");
            this.threadWait(10000L);
        }
        return bOk;
    }

    @Override
    public void switchToCmdMode() throws IOException, InterruptedException {
        this.getModemDriver().write("+++");
        Date start = new Date();
        while (new Date().getTime() - start.getTime() <= (long)Service.getInstance().getSettings().AT_WAIT_CMD) {
            this.threadWait(100L);
        }
    }

    @Override
    public void keepLinkOpen() throws TimeoutException, GatewayException, IOException, InterruptedException {
        block0: {
            if (Service.getInstance().getSettings().DISABLE_CMMS) break block0;
            boolean recheckTimes = false;
            this.getModemDriver().write("AT+CMMS=2\r");
            this.threadWait(Service.getInstance().getSettings().AT_WAIT);
            String response = this.getModemDriver().getResponse();
        }
    }

    @Override
    public int sendMessage(int size, String pdu, String phone, String text) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int refNo = -1;
        if (this.getGateway().getProtocol() == AGatewayHelper.Protocols.PDU) {
            int errorRetries = 0;
            SerialModemBean bean = DeviceInfoCache.getInstance().get(this.getGateway().getGatewayId());
            if (bean != null && bean.getManufacturer().equals("Wavecom")) {
                this.getModemDriver().write("AT+CMGF?\r");
                String textMode = this.getModemDriver().getResponse();
                if (textMode.indexOf("CMGF: 1") != -1) {
                    Logger.getInstance().logError("pdu\u7f16\u7801\u53d1\u751f\u9519\u8bef,\u91cd\u65b0\u521d\u59cb\u5316\u7f16\u7801", null, this.getGateway().getGatewayId());
                    this.setPduProtocol();
                }
            }
            long interval = 3600 / Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.send_speed", "600")) * 1000;
            while (this.getGateway().getStatus() == AGatewayHelper.GatewayStatuses.STARTED) {
                int responseRetries = 0;
                this.getModemDriver().write("AT+CMGS=\"_1_\"\r".replaceAll("\"_1_\"", "" + size));
                if (!this.threadWait(Service.getInstance().getSettings().AT_WAIT_CGMS)) break;
                while (!this.getModemDriver().dataAvailable() && this.getGateway().getStatus() == AGatewayHelper.GatewayStatuses.STARTED) {
                    if (++responseRetries == Service.getInstance().getSettings().OUTBOUND_RES_RETRIES) {
                        Logger.getInstance().logError("\u54cd\u5e94\u91cd\u8bd5\u8d85\u8fc7\u6700\u5927\u6b21\u6570", null, this.getGateway().getGatewayId());
                        throw new GatewayException("Gateway is not responding, max number of retries reached.");
                    }
                    Logger.getInstance().logWarn("ATHandler().SendMessage(): Still waiting for response (I) (" + responseRetries + ")...", null, this.getGateway().getGatewayId());
                    if (this.threadWait((long)Service.getInstance().getSettings().OUTBOUND_RETRY_WAIT + interval)) continue;
                }
                if (this.getGateway().getStatus() != AGatewayHelper.GatewayStatuses.STARTED) {
                    refNo = -1;
                    break;
                }
                responseRetries = 0;
                this.getModemDriver().write(pdu);
                this.getModemDriver().write('\u001a');
                String response = this.getModemDriver().getResponse();
                int nDebug = 0;
                Logger.getInstance().logDebug("debug------\u6b21\u6570\u662f\uff08\u65e0\u5faa\u73af\uff09\uff1a" + String.valueOf(nDebug++), null, null);
                Logger.getInstance().logDebug("debug------\u7ed3\u679c\u662f\uff08\u65e0\u5faa\u73af\uff09\uff1a" + response, null, null);
                while (response.length() == 0 && this.getGateway().getStatus() == AGatewayHelper.GatewayStatuses.STARTED) {
                    if (++responseRetries == Service.getInstance().getSettings().OUTBOUND_RES_RETRIES) {
                        Logger.getInstance().logError("\u54cd\u5e94\u91cd\u8bd5\u8d85\u8fc7\u6700\u5927\u6b21\u6570", null, this.getGateway().getGatewayId());
                        throw new GatewayException("Gateway is not responding, max number of retries reached.");
                    }
                    Logger.getInstance().logWarn("ATHandler().SendMessage(): Still waiting for response (II) (" + responseRetries + ")...", null, this.getGateway().getGatewayId());
                    if (!this.threadWait((long)Service.getInstance().getSettings().OUTBOUND_RETRY_WAIT + interval)) break;
                    response = this.getModemDriver().getResponse();
                    Logger.getInstance().logDebug("debug------\u6b21\u6570\u662f(\u8fdb\u5faa\u73af)\uff1a", null, String.valueOf(nDebug++));
                    Logger.getInstance().logDebug("debug------\u7ed3\u679c\u662f(\u8fdb\u5faa\u73af)\uff1a", null, response);
                }
                if (this.getGateway().getStatus() != AGatewayHelper.GatewayStatuses.STARTED) {
                    refNo = -1;
                    break;
                }
                if (this.getModemDriver().getLastError() == 0) {
                    Matcher m2 = Pattern.compile("\\s*\\+CMGS: *(\\d+)").matcher(response);
                    refNo = m2.find() ? Integer.parseInt(m2.group(1)) : -1;
                    break;
                }
                if (this.getModemDriver().getLastError() > 0) {
                    if (this.getModemDriver().getLastErrorText().indexOf("unknown") >= 0) {
                        Logger.getInstance().logError("\u51fa\u73b0\u672a\u77e5\u9519\u8bef\u7aef\u53e3\u91cd\u542f", null, this.getGateway().getGatewayId());
                        this.getGateway().setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                        if (!this.threadWait(10000L)) break;
                    }
                    if (this.getModemDriver().getLastErrorText().indexOf("CMS Error 305") >= 0) {
                        Logger.getInstance().logError("\u6a21\u5757\u51fa\u73b0\u7f16\u7801\u9519\u8befCMS ERROR: 305", null, this.getGateway().getGatewayId());
                        this.setPduProtocol();
                    }
                    if (++errorRetries == Service.getInstance().getSettings().OUTBOUND_RETRIES) {
                        Logger.getInstance().logError(this.getModemDriver().getLastErrorText() + ": Quit retrying, message lost...", null, this.getGateway().getGatewayId());
                        refNo = -1;
                    } else {
                        Logger.getInstance().logWarn(response + ": Retrying...", null, this.getGateway().getGatewayId());
                        if (this.threadWait((long)Service.getInstance().getSettings().OUTBOUND_RETRY_WAIT + interval)) continue;
                    }
                    break;
                }
                refNo = -1;
            }
        } else if (this.getGateway().getProtocol() == AGatewayHelper.Protocols.TEXT) {
            this.getModemDriver().write("AT+CMGS=\"_1_\"\r".replaceAll("_1_", phone));
            this.getModemDriver().clearBuffer();
            this.getModemDriver().write(GSM0338.encode(text));
            this.threadWait(Service.getInstance().getSettings().AT_WAIT_CGMS);
            this.getModemDriver().write('\u001a');
            String response = this.getModemDriver().getResponse();
            if (response.indexOf("OK\r") >= 0) {
                StringBuilder tmp = new StringBuilder();
                int i2 = response.indexOf(":");
                while (!Character.isDigit(response.charAt(i2))) {
                    ++i2;
                }
                while (Character.isDigit(response.charAt(i2))) {
                    tmp.append(response.charAt(i2));
                    ++i2;
                }
                refNo = Integer.parseInt(tmp.toString());
            } else {
                refNo = -1;
            }
        }
        return refNo;
    }

    @Override
    public String listMessages(InboundMessage.MessageClasses messageClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getGateway().getProtocol() == AGatewayHelper.Protocols.PDU) {
            if (messageClass == InboundMessage.MessageClasses.ALL) {
                this.getModemDriver().write("AT+CMGL=4\r");
            } else if (messageClass == InboundMessage.MessageClasses.UNREAD) {
                this.getModemDriver().write("AT+CMGL=0\r");
            } else if (messageClass == InboundMessage.MessageClasses.READ) {
                this.getModemDriver().write("AT+CMGL=1\r");
            }
        } else if (this.getGateway().getProtocol() == AGatewayHelper.Protocols.TEXT) {
            if (messageClass == InboundMessage.MessageClasses.ALL) {
                this.getModemDriver().write("AT+CMGL=\"ALL\"\r");
            } else if (messageClass == InboundMessage.MessageClasses.UNREAD) {
                this.getModemDriver().write("AT+CMGL=\"REC UNREAD\"\r");
            } else if (messageClass == InboundMessage.MessageClasses.READ) {
                this.getModemDriver().write("AT+CMGL=\"REC READ\"\r");
            }
        }
        return this.getModemDriver().getResponse();
    }

    @Override
    public String getMessageByIndex(int msgIndex) throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CMGR=" + msgIndex + "\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public boolean deleteMessage(int memIndex, String memLocation) throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().write("AT+CMGD=_1_\r".replaceAll("_1_", "" + memIndex));
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    @Override
    public String getGprsStatus() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CGATT?\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public String send(String s) throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write(s);
        return this.getModemDriver().getResponse();
    }

    @Override
    public String getNetworkRegistration() throws GatewayException, TimeoutException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CREG=1\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CREG?\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public void readStorageLocations() throws Exception {
        this.getModemDriver().write("AT+CPMS=?\r");
        String response = this.getModemDriver().getResponse();
        try {
            this.addStorageLocation("SM");
        }
        catch (Exception e2) {
            this.addStorageLocation("SM");
            Logger.getInstance().logWarn("CPMS detection failed, proceeding with default storage 'SM'.", null, this.getGateway().getGatewayId());
        }
    }

    @Override
    public String readPhonebookLocations() throws GatewayException, TimeoutException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CPBS=?\r");
        String response = this.getModemDriver().getResponse();
        if (response.indexOf("+CPBS:") >= 0) {
            response = response.replaceAll("\\s*\\+CPBS:\\s*", "");
            response = response.replaceAll("[()]", "");
            return response;
        }
        return "";
    }

    @Override
    public String readPhonebook(String loc) throws GatewayException, TimeoutException, IOException {
        try {
            this.getModemDriver().write("AT+CPBS=\"" + loc + "\"\r");
            this.getModemDriver().getResponse();
            this.getModemDriver().write("AT+CPBR=?\r");
            String response = this.getModemDriver().getResponse();
            response = response.replaceAll("\\s*\\+CPBR:\\s*", "");
            response = response.replaceAll("[()]", "");
            StringTokenizer tokens1 = new StringTokenizer(response, ",");
            StringTokenizer tokens2 = new StringTokenizer(tokens1.nextToken(), "-");
            int minIndex = Integer.parseInt(tokens2.nextToken());
            int maxIndex = Integer.parseInt(tokens2.nextToken());
            this.getModemDriver().write("AT+CPBR=" + minIndex + "," + maxIndex + "\r");
            response = this.getModemDriver().getResponse();
            return response;
        }
        catch (Exception e2) {
            Logger.getInstance().logWarn("Phonebook detection failed.", null, this.getGateway().getGatewayId());
            return "";
        }
    }

    @Override
    public String sendCustomATCommand(String atCommand) throws GatewayException, TimeoutException, IOException, InterruptedException {
        this.threadWait(Service.getInstance().getSettings().AT_WAIT4M35);
        this.getModemDriver().write(atCommand);
        this.threadWait(Service.getInstance().getSettings().AT_WAIT4M35);
        return this.getModemDriver().getResponse();
    }

    @Override
    public String sendUSSDCommand(String ussdCommand) throws GatewayException, TimeoutException, IOException, InterruptedException {
        return this.sendUSSDCommand(ussdCommand, false);
    }

    @Override
    public String sendUSSDCommand(String ussdCommand, boolean interactive) throws GatewayException, TimeoutException, IOException, InterruptedException {
        String regex;
        Pattern pattern;
        Matcher matcher;
        String command = this.formatUSSDCommand(ussdCommand);
        String ussdResponse = this.sendCustomATCommand(command);
        if (!ussdResponse.contains("OK")) {
            Logger.getInstance().logError("+CUSD command returned non-OK result: " + ussdResponse, null, this.getGateway().getGatewayId());
            return null;
        }
        ussdResponse = new String(this.getModemDriver().getResponse(AGateway.AsyncEvents.USSDRESPONSE));
        if (!interactive) {
            char esc = '\u001b';
            command = "" + esc + '\r';
            this.getModemDriver().write(command);
            this.getModemDriver().clearBuffer();
        }
        String response = (matcher = (pattern = Pattern.compile(regex = "\"(.*)\"")).matcher(ussdResponse)).find() ? this.formatUSSDResponse(matcher.group(1)) : ussdResponse;
        return response;
    }

    @Override
    public boolean sendUSSDRequest(String presentation, String content, String dcs) throws GatewayException, TimeoutException, IOException, InterruptedException {
        String rawRequest = this.formatUSSDCommand(presentation, content, dcs);
        String ussdResponse = this.sendCustomATCommand(rawRequest);
        if (!ussdResponse.contains("OK")) {
            Logger.getInstance().logError("+CUSD command returned non-OK result: " + ussdResponse, null, this.getGateway().getGatewayId());
            return false;
        }
        return true;
    }

    protected String formatUSSDCommand(String ussdCommand) {
        return this.formatUSSDCommand("1", ussdCommand, null);
    }

    protected String formatUSSDCommand(String presentation, String content, String dcs) {
        StringBuffer buf = new StringBuffer();
        buf.append("AT+CUSD=");
        buf.append(presentation);
        buf.append(",");
        buf.append("\"");
        buf.append(content);
        buf.append("\"");
        if (dcs != null && dcs.length() > 0) {
            buf.append(",");
            buf.append(dcs);
        }
        buf.append("\r");
        return buf.toString();
    }

    @Override
    public String formatUSSDResponse(String ussdResponse) {
        return ussdResponse;
    }

    @Override
    public AGateway.AsyncEvents processUnsolicitedEvents(String response) throws IOException {
        AGateway.AsyncEvents event = AGateway.AsyncEvents.NOTHING;
        if (response.indexOf(this.getUnsolicitedResponse(0)) >= 0) {
            event = AGateway.AsyncEvents.INBOUNDMESSAGE;
        } else if (response.indexOf(this.getUnsolicitedResponse(1)) >= 0) {
            event = AGateway.AsyncEvents.INBOUNDSTATUSREPORTMESSAGE;
        } else if (response.indexOf(this.getUnsolicitedResponse(2)) >= 0) {
            event = AGateway.AsyncEvents.NOTHING;
        } else if (response.indexOf(this.getUnsolicitedResponse(3)) >= 0) {
            event = AGateway.AsyncEvents.INBOUNDCALL;
        } else if (response.indexOf(this.getUnsolicitedResponse(4)) >= 0) {
            event = AGateway.AsyncEvents.USSDRESPONSE;
        }
        return event;
    }

    @Override
    public String getSerialNumber() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Logger.getInstance().logInfo("TO SEND AT+WMSN (3)", null, null);
        this.getModemDriver().write("AT+WMSN\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public int getTextSplitNum(String text) {
        return 0;
    }

    @Override
    public void modifyMMSRemindWay() throws IOException, InterruptedException {
    }

    @Override
    public void doExRing(String szPhone, int nRingLen) {
        Logger.getInstance().logInfo("External want call phone:" + szPhone + ", ringlen=" + nRingLen, null, this.getGateway().getGatewayId());
        if (szPhone.length() <= 5) {
            Logger.getInstance().logInfo("phone length <= 5, no call", null, null);
            return;
        }
        this.a(szPhone, nRingLen);
        this.a();
    }

    @Override
    public void doExVoice(String szPhone, String szMsg, int nRingLen) {
        Logger.getInstance().logInfo("External want voice notify:" + szPhone + ", current modem not supportted.", null, this.getGateway().getGatewayId());
    }

    private boolean a(String szPhone, int nRingLen) {
        try {
            Logger.getInstance().logInfo("ex voice calling...", null, null);
            this.getModemDriver().write("ATD" + szPhone + ";\r");
            this.threadWait(2000L);
        }
        catch (IOException | InterruptedException e2) {
            e2.printStackTrace();
        }
        String szRes = "";
        try {
            szRes = szRes + this.getModemDriver().getResponse();
        }
        catch (GatewayException | TimeoutException | IOException | InterruptedException e1) {
            e1.printStackTrace();
        }
        boolean bOk = true;
        boolean isBegin = false;
        for (int nTick = 0; bOk && nTick < nRingLen && !isBegin; ++nTick) {
            try {
                this.getModemDriver().writeNoClear("AT\r");
                this.threadWait(2000L);
                szRes = szRes + this.getModemDriver().getResponse();
            }
            catch (GatewayException | TimeoutException | IOException | InterruptedException e3) {
                e3.printStackTrace();
            }
            if (szRes.indexOf("BEGIN") != -1) {
                isBegin = true;
                break;
            }
            if (szRes.indexOf("CONNECT") != -1) {
                isBegin = true;
                break;
            }
            if (szRes.indexOf("ERROR") != -1) {
                bOk = false;
                break;
            }
            if (szRes.indexOf("NO CARRIER") != -1) {
                bOk = false;
                break;
            }
            if (szRes.indexOf("NO DIALTONE") == -1) continue;
            bOk = false;
            break;
        }
        Logger.getInstance().logInfo("ex call wait result: " + szRes, null, null);
        return isBegin;
    }

    private void a() {
        try {
            this.getModemDriver().write("AT+CHUP\r");
            this.threadWait(2000L);
        }
        catch (IOException | InterruptedException e2) {
            e2.printStackTrace();
        }
    }

    protected Pdu checkNullPduParse(String szPduString) {
        Pdu pdu = null;
        PduParser parser = new PduParser();
        try {
            pdu = parser.parsePdu(szPduString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pdu;
    }
}

