/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem.athandler;

import cn.sendsms.GatewayException;
import cn.sendsms.InboundMessage;
import cn.sendsms.Service;
import cn.sendsms.TimeoutException;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.modem.ModemGateway;
import cn.sendsms.modem.athandler.ATHandler;
import cn.sendsms.util.Logger;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;

public class ATHandler_INCORPORATED_7600CE_JT1S
extends ATHandler {
    public ATHandler_INCORPORATED_7600CE_JT1S(ModemGateway myGateway) {
        super(myGateway);
        this.setStorageLocations("SM");
    }

    @Override
    public String getStorageLocations() {
        return "SM";
    }

    @Override
    public String getCCID() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CICCID\r");
        String response = this.getModemDriver().getResponse();
        return response;
    }

    @Override
    public void reset() throws TimeoutException, GatewayException, IOException, InterruptedException {
        super.reset();
        this.getModemDriver().clearBuffer();
    }

    @Override
    public String sendCustomATCommand(String atCommand) throws GatewayException, TimeoutException, IOException, InterruptedException {
        this.getModemDriver().write(atCommand);
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        return this.getModemDriver().getResponse();
    }

    @Override
    public void done() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.threadWait(Service.getInstance().getSettings().AT_WAIT_AFTER_RESET);
    }

    @Override
    public void init() throws TimeoutException, GatewayException, IOException, InterruptedException {
        super.init();
        this.threadWait(2000L);
        this.getModemDriver().write("ATE0\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CPMS=\"SM\",\"SM\",\"SM\"\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CDTAM=1\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+MORING=1\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CTTSPARAM=2,2,0,1,0\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT&W\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().getResponse();
    }

    @Override
    public String readTextMode() throws GatewayException, TimeoutException, IOException, InterruptedException {
        this.threadWait(2000L);
        this.getModemDriver().write("AT+CMGF?\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        return this.getModemDriver().getResponse();
    }

    @Override
    public int findMatchingTerminator(String response) {
        if (response.indexOf("OK") != -1) {
            return 0;
        }
        for (int i2 = 0; i2 < this.terminators.length; ++i2) {
            if (!response.matches(this.terminators[i2])) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public String listMessages(InboundMessage.MessageClasses messageClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        StringBuilder listMessage = new StringBuilder();
        this.getModemDriver().write("AT+CMGD=?\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        String indexstr = this.getModemDriver().getResponse();
        int start = indexstr.indexOf("(");
        int end = indexstr.indexOf(")");
        Logger.getInstance().logInfo("listMessages = " + indexstr, null, null);
        String parseStr = "";
        if (start + 1 < end) {
            String index;
            int iindex;
            String[] indexs = indexstr.substring(start + 1, end).split(",");
            String[] delIndexs = new String[indexs.length];
            for (iindex = 0; indexs != null && iindex < delIndexs.length; ++iindex) {
                delIndexs[iindex] = "";
            }
            for (iindex = 0; this.getGateway().getStatus() == AGatewayHelper.GatewayStatuses.STARTED && indexs != null && iindex < indexs.length; ++iindex) {
                index = indexs[iindex];
                try {
                    parseStr = "";
                    indexstr = "";
                    this.getModemDriver().write("ATE0\r");
                    this.threadWait(Service.getInstance().getSettings().AT_WAIT);
                    this.getModemDriver().write("AT+CMGR=" + index + "\r");
                    this.threadWait(Service.getInstance().getSettings().AT_WAIT);
                    indexstr = this.getModemDriver().getResponse();
                    if (indexstr.indexOf("+CMGR") >= 0) {
                        int endIndex;
                        Matcher matcher = this.delLineSeparatorAfterCMGR.matcher(indexstr = indexstr.substring(indexstr.indexOf("+CMGR")));
                        if (matcher.find()) {
                            indexstr = indexstr.replace(matcher.group(), matcher.group(1) + "\r");
                        }
                        String pduString = indexstr.trim();
                        Logger.getInstance().logInfo("\u6536\u5230\u77ed\u4fe1:" + pduString, null, null);
                        int startIndex = pduString.indexOf("\n");
                        if (startIndex == -1) {
                            startIndex = pduString.indexOf("\r");
                        }
                        if ((endIndex = pduString.lastIndexOf("\nOK")) == -1) {
                            endIndex = pduString.lastIndexOf("\rOK");
                        }
                        parseStr = pduString = pduString.substring(startIndex + 1, endIndex).replaceFirst("[\r|\n]+", "");
                        listMessage.append(indexstr.replace("CMGR:", "CMGL: " + index + ",").replaceFirst("\n*OK.*", ""));
                        delIndexs[iindex] = index;
                        continue;
                    }
                    Logger.getInstance().logError("\u8bfb\u53d6" + index + "\u4f4d\u7f6e\u7684\u77ed\u4fe1\u5f02\u5e38: index: " + indexstr, null, this.getGateway().getGatewayId());
                    continue;
                }
                catch (Exception e2) {
                    Logger.getInstance().logError("\u8bfb\u53d6" + index + "\u4f4d\u7f6e\u7684\u77ed\u4fe1\u65f6\u51fa\u9519", e2, this.getGateway().getGatewayId());
                    Logger.getInstance().logError("index : " + indexstr, null, this.getGateway().getGatewayId());
                    Logger.getInstance().logError("parse : " + parseStr, null, this.getGateway().getGatewayId());
                }
            }
            for (iindex = 0; this.getGateway().getStatus() == AGatewayHelper.GatewayStatuses.STARTED && indexs != null && iindex < delIndexs.length; ++iindex) {
                index = delIndexs[iindex];
                try {
                    if (index.isEmpty()) continue;
                    this.getModemDriver().write("AT+CMGD=" + index + "\r");
                    this.threadWait(Service.getInstance().getSettings().AT_WAIT);
                    continue;
                }
                catch (Exception e3) {
                    Logger.getInstance().logError("\u5220\u9664" + index + "\u4f4d\u7f6e\u7684\u77ed\u4fe1\u65f6\u9519\u8bef", null, this.getGateway().getGatewayId());
                }
            }
        }
        listMessage.append("\nOK");
        return listMessage.toString();
    }

    @Override
    public boolean deleteMessage(int memIndex, String memLocation) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return true;
    }

    @Override
    public void doExRing(String szPhone, int nRingLen) {
        Logger.getInstance().logInfo("External want call phone:" + szPhone + ", ringlen=" + nRingLen, null, this.getGateway().getGatewayId());
        if (szPhone.length() <= 5) {
            Logger.getInstance().logInfo("phone length <= 5, no call", null, null);
            return;
        }
        this.b(szPhone, nRingLen);
        this.a();
    }

    @Override
    public void doExVoice(String szPhone, String szMsg, int nRingLen) {
        Logger.getInstance().logInfo("External want voice notify:" + szPhone + ", ringlen=" + nRingLen, null, this.getGateway().getGatewayId());
        if (szPhone.length() <= 5) {
            Logger.getInstance().logInfo("phone length <= 5, no call", null, null);
            return;
        }
        if (szMsg.length() < 2) {
            Logger.getInstance().logInfo("message length< 2, no call", null, null);
            return;
        }
        if (this.b(szPhone, nRingLen)) {
            this.a(szMsg, 25);
        }
        this.a();
    }

    private void a(String szMsg, int nWaitSeconds) {
        try {
            String szTTS = this.a(szMsg);
            if (szTTS.length() > 508) {
                szTTS = szTTS.substring(0, 508);
            }
            this.getModemDriver().write("AT+CTTS=1,\"" + szTTS + "\"\r");
            this.threadWait(1000L);
        }
        catch (IOException | InterruptedException e2) {
            e2.printStackTrace();
        }
        String szRes = "";
        try {
            szRes = szRes + this.getModemDriver().getResponse();
        }
        catch (GatewayException | TimeoutException | IOException | InterruptedException e1) {
            e1.printStackTrace();
        }
        boolean bOk = true;
        boolean isEnd = false;
        for (int nTick = 0; bOk && nTick < nWaitSeconds && !isEnd; ++nTick) {
            try {
                this.getModemDriver().writeNoClear("AT\r");
                this.threadWait(2000L);
                szRes = szRes + this.getModemDriver().getResponse();
            }
            catch (GatewayException | TimeoutException | IOException | InterruptedException e3) {
                e3.printStackTrace();
            }
            if (szRes.indexOf("END") != -1) {
                isEnd = true;
                break;
            }
            if (szRes.indexOf("+CTTS:0") != -1) {
                isEnd = true;
                break;
            }
            if (szRes.indexOf("+CTTS: 0") != -1) {
                isEnd = true;
                break;
            }
            if (szRes.indexOf("ERROR") != -1) {
                bOk = false;
                break;
            }
            if (szRes.indexOf("NO CARRIER") != -1) {
                bOk = false;
                break;
            }
            if (szRes.indexOf("NO DIALTONE") == -1) continue;
            bOk = false;
            break;
        }
        Logger.getInstance().logInfo("ctts result: " + szRes, null, null);
    }

    private boolean b(String szPhone, int nRingLen) {
        try {
            Logger.getInstance().logInfo("ex voice calling...", null, null);
            this.getModemDriver().write("ATD" + szPhone + ";\r");
            this.threadWait(2000L);
        }
        catch (IOException | InterruptedException e2) {
            e2.printStackTrace();
        }
        String szRes = "";
        try {
            szRes = szRes + this.getModemDriver().getResponse();
        }
        catch (GatewayException | TimeoutException | IOException | InterruptedException e1) {
            e1.printStackTrace();
        }
        boolean bOk = true;
        boolean isBegin = false;
        for (int nTick = 0; bOk && nTick < nRingLen && !isBegin; ++nTick) {
            try {
                this.getModemDriver().writeNoClear("AT\r");
                this.threadWait(2000L);
                szRes = szRes + this.getModemDriver().getResponse();
            }
            catch (GatewayException | TimeoutException | IOException | InterruptedException e3) {
                e3.printStackTrace();
            }
            if (szRes.indexOf("BEGIN") != -1) {
                isBegin = true;
                break;
            }
            if (szRes.indexOf("CONNECT") != -1) {
                isBegin = true;
                break;
            }
            if (szRes.indexOf("ERROR") != -1) {
                bOk = false;
                break;
            }
            if (szRes.indexOf("NO CARRIER") != -1) {
                bOk = false;
                break;
            }
            if (szRes.indexOf("NO DIALTONE") == -1) continue;
            bOk = false;
            break;
        }
        Logger.getInstance().logInfo("ex call wait result: " + szRes, null, null);
        return isBegin;
    }

    private void a() {
        try {
            this.getModemDriver().write("AT+CHUP\r");
            this.threadWait(2000L);
        }
        catch (IOException | InterruptedException e2) {
            e2.printStackTrace();
        }
    }

    private String a(String src) {
        byte[] bytes = null;
        try {
            bytes = src.getBytes("UTF-16BE");
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        if (bytes == null) {
            return "";
        }
        StringBuffer reValue = new StringBuffer();
        StringBuffer tem = new StringBuffer();
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            tem.delete(0, tem.length());
            tem.append(Integer.toHexString(bytes[i2] & 0xFF));
            if (tem.length() == 1) {
                tem.insert(0, '0');
            }
            reValue.append(tem);
        }
        return reValue.toString().toUpperCase();
    }
}

