/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem.athandler;

import cn.sendsms.GatewayException;
import cn.sendsms.Service;
import cn.sendsms.TimeoutException;
import cn.sendsms.helper.Logger;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.modem.ModemGateway;
import cn.sendsms.modem.athandler.ATHandler;
import java.io.IOException;

public class ATHandler_Wavecom
extends ATHandler {
    public ATHandler_Wavecom(ModemGateway myGateway) {
        super(myGateway);
        this.setStorageLocations("SM");
    }

    @Override
    public void reset() throws TimeoutException, GatewayException, IOException, InterruptedException {
        super.reset();
        if (!JDSMSServer.getInstance().getProperties().getString("settings.at.cfun", "0").equals("0")) {
            this.getModemDriver().write("AT+CFUN=1\r");
        }
        this.threadWait(Service.getInstance().getSettings().AT_WAIT_AFTER_RESET);
        this.getModemDriver().clearBuffer();
    }

    @Override
    public void done() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        if (!JDSMSServer.getInstance().getProperties().getString("settings.at.cfun", "0").equals("0")) {
            this.getModemDriver().write("AT+CFUN=0\r");
        }
        this.threadWait(Service.getInstance().getSettings().AT_WAIT_AFTER_RESET);
    }

    @Override
    public String readTextMode() throws GatewayException, TimeoutException, IOException, InterruptedException {
        this.threadWait(2000L);
        this.getModemDriver().write("AT+CMGF?\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        return this.getModemDriver().getResponse();
    }

    @Override
    public boolean switchStorageLocation(String mem) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (mem.equalsIgnoreCase("--")) {
            return true;
        }
        this.getModemDriver().write("ATE0\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CPMS=\"" + mem + "\"\r");
        boolean doubleCheck = true;
        int waitTimes = 0;
        String response = this.getModemDriver().getResponse();
        boolean firstCheck = this.getModemDriver().isOk();
        while (response.indexOf("+CPMS") == -1) {
            if (waitTimes > 50) {
                Logger.getInstance().logError("AT+CPMS\u8d85\u8fc710S\u672a\u54cd\u5e94", null, this.getGateway().getGatewayId());
                Logger.getInstance().logError("AT+CPMS\u54cd\u5e94\u503c\uff1a" + response, null, this.getGateway().getGatewayId());
                doubleCheck = false;
                break;
            }
            this.threadWait(Service.getInstance().getSettings().AT_WAIT);
            response = response + this.getModemDriver().getResponse();
            ++waitTimes;
        }
        Logger.getInstance().logInfo(firstCheck + "", null, this.getGateway().getGatewayId());
        Logger.getInstance().logInfo(doubleCheck + "", null, this.getGateway().getGatewayId());
        return firstCheck && doubleCheck;
    }
}

