/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem.athandler;

import cn.sendsms.GatewayException;
import cn.sendsms.InboundMessage;
import cn.sendsms.Service;
import cn.sendsms.TimeoutException;
import cn.sendsms.helper.Logger;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.web.CharacterSetToolkit;
import cn.sendsms.modem.ModemGateway;
import cn.sendsms.modem.athandler.ATHandler_Wavecom;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ATHandler_Wavecom_WISMOQCDMA
extends ATHandler_Wavecom {
    private Object a = new Object();

    @Override
    public void reset() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.threadWait(Service.getInstance().getSettings().AT_WAIT_AFTER_RESET);
        this.getModemDriver().clearBuffer();
    }

    @Override
    public String getSerialNo() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("ATI3\r");
        String versionResult = this.getModemDriver().getResponse();
        if (versionResult != null && versionResult.indexOf("WQ2") != -1) {
            this.getModemDriver().write("AT+WAIP=0\r");
            this.getModemDriver().getResponse();
            this.getModemDriver().write("AT+CPBS=\"ME\"\r");
            this.getModemDriver().getResponse();
            this.getModemDriver().write("AT+CPBR=1\r");
            String result = this.getModemDriver().getResponse();
            result = result.replaceAll("AT+CPBR=1\r", "").replaceAll("\\s+OK\\s+", "").replaceAll("\\s+", "");
            result = result.substring(result.indexOf(58) + 1);
            String key = result.substring(result.lastIndexOf(44) + 1);
            if (result.indexOf("ERROR") != -1) {
                return "N/A";
            }
            if (result.trim().equals("")) {
                return "N/A";
            }
            if (!key.equals("\"WMSN\"")) {
                return "N/A";
            }
            String str = result.split(",")[1];
            return str.substring(1, str.length() - 1);
        }
        this.getModemDriver().write("AT+WMSN\r");
        String response = this.getModemDriver().getResponse();
        response = response.replaceAll("\\s+OK\\s+", "");
        String[] tmp = response.split(":");
        return tmp[tmp.length - 1];
    }

    @Override
    public String getSerialNumber() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("ATI3\r");
        String versionResult = this.getModemDriver().getResponse();
        if (versionResult != null && versionResult.indexOf("WQ2") != -1) {
            this.getModemDriver().write("AT+WAIP=0\r");
            this.getModemDriver().getResponse();
            this.getModemDriver().write("AT+CPBS=\"ME\"\r");
            this.getModemDriver().getResponse();
            this.getModemDriver().write("AT+CPBR=1\r");
            String result = this.getModemDriver().getResponse();
            result = result.replaceAll("AT+CPBR=1\r", "").replaceAll("\\s+OK\\s+", "").replaceAll("\\s+", "");
            result = result.substring(result.indexOf(58) + 1);
            String key = result.substring(result.lastIndexOf(44) + 1);
            if (result.indexOf("ERROR") != -1) {
                return "N/A";
            }
            if (result.trim().equals("")) {
                return "N/A";
            }
            if (!key.equals("\"WMSN\"")) {
                return "N/A";
            }
            String str = result.split(",")[1];
            return str.substring(1, str.length() - 1);
        }
        this.getModemDriver().write("AT+WMSN\r");
        String response = this.getModemDriver().getResponse();
        response = response.replaceAll("\\s+OK\\s+", "");
        String[] tmp = response.split(":");
        return tmp[tmp.length - 1];
    }

    @Override
    public void done() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
    }

    public ATHandler_Wavecom_WISMOQCDMA(ModemGateway myGateway) {
        super(myGateway);
        this.terminators[1] = "\\s*([\\p{ASCII}]|[^\\x00-\\xff])*\\s+OK\\s";
        this.terminators[9] = "\\+CCID:\\s*[\\p{ASCII}]*\\s*";
        this.setStorageLocations("MT");
    }

    @Override
    public String listMessages(InboundMessage.MessageClasses messageClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        StringBuffer msgList = new StringBuffer();
        String listMsgRespons = "";
        try {
            if (messageClass == InboundMessage.MessageClasses.ALL) {
                this.getModemDriver().write("AT+CMGL=\"ALL\"\r");
            } else if (messageClass == InboundMessage.MessageClasses.UNREAD) {
                this.getModemDriver().write("AT+CMGL=\"REC UNREAD\"\r");
            } else if (messageClass == InboundMessage.MessageClasses.READ) {
                this.getModemDriver().write("AT+CMGL=\"REC READ\"\r");
            }
            listMsgRespons = this.getModemDriver().getResponse4CDMA();
        }
        catch (TimeoutException e2) {
            Logger.getInstance().logError("\u63a5\u6536\u77ed\u4fe1\u53d1\u9001at+cmgl=all\u6307\u4ee4\u51fa\u73b0\u8d85\u65f6", e2, this.getGateway().getGatewayId());
            this.threadWait(60000L);
        }
        ArrayList<Integer> memIndexs = this.a(listMsgRespons);
        for (int x = 0; x < memIndexs.size(); ++x) {
            int memIndex = memIndexs.get(x);
            String header = "";
            String msgText = "";
            this.getModemDriver().write("AT+CMGR=" + memIndex + "\r");
            byte[] text = new byte[]{};
            try {
                text = this.getModemDriver().getResponseByteArray4CDMA();
            }
            catch (TimeoutException e3) {
                Logger.getInstance().logError("\u63a5\u6536\u77ed\u4fe1\u53d1\u9001at+cmgr\u6307\u4ee4\u65f6\u51fa\u73b0\u8d85\u65f6", e3, this.getGateway().getGatewayId());
                continue;
            }
            int i2 = 0;
            for (i2 = 0; i2 < text.length && text[i2] != 13; ++i2) {
                header = header + (char)text[i2];
            }
            ++i2;
            String regx = "(^\\+CMGR:)(\\\"[^\\\"]+\\\",)(\\\"[^\\\"]+\\\",)(\\\"[^,]+,)(\\d+)\\s+(:\\d+)\\s+(:\\d+\\\")(,\\d,)(\\d)";
            Pattern pat = Pattern.compile(regx);
            Matcher matcher = pat.matcher(header);
            header = matcher.replaceAll("$1 " + memIndex + ",$2$3,$4$5$6$7$8$9");
            char encoding = matcher.replaceAll("$9").charAt(0);
            String msgContentStr = "";
            if (encoding == '4') {
                byte[] tmp;
                try {
                    tmp = new byte[text.length - i2 - 4];
                }
                catch (NegativeArraySizeException e4) {
                    continue;
                }
                for (int j2 = 0; j2 < tmp.length; ++j2) {
                    tmp[j2] = text[i2 + j2];
                }
                msgContentStr = CharacterSetToolkit.unicode2Ascii(tmp);
            } else {
                while (i2 < text.length) {
                    msgContentStr = msgContentStr + (char)text[i2++];
                }
            }
            msgText = header + "\r" + msgContentStr + "\r";
            msgList.append(msgText);
        }
        return msgList.toString();
    }

    private ArrayList<Integer> a(String respons) throws IOException {
        String line;
        ArrayList<Integer> msgIndexs = new ArrayList<Integer>();
        String listMsgRespons = respons;
        BufferedReader reader = new BufferedReader(new StringReader(listMsgRespons));
        while ((line = reader.readLine().trim()) != null && (line = line.trim()).length() <= 0) {
        }
        while (line != null && (line = line.trim()).length() > 0 && !line.equalsIgnoreCase("OK")) {
            if (line.matches("^\\+CMGL:\\s*\\d+,.*")) {
                int i2 = line.indexOf(58);
                int j2 = line.indexOf(44);
                int memIndex = Integer.parseInt(line.substring(i2 + 1, j2).trim());
                msgIndexs.add(memIndex);
            }
            if ((line = reader.readLine()) == null) break;
            line = line.trim();
            while (line.length() == 0 && (line = reader.readLine()) != null) {
                line = line.trim();
            }
        }
        reader.close();
        return msgIndexs;
    }

    @Override
    public boolean setTextProtocol() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("ATI3\r");
        String versionResult = this.getModemDriver().getResponse();
        if (versionResult != null && versionResult.indexOf("WQ2") != -1) {
            this.getModemDriver().write("AT+CMGF=1\r");
            this.getModemDriver().getResponse();
            if (this.getModemDriver().isOk()) {
                this.getModemDriver().write("AT+CSCS=\"CDMA\"\r");
                this.getModemDriver().getResponse();
                if (this.getModemDriver().isOk()) {
                    this.getModemDriver().write("AT+WSCL=6,4\r");
                    this.echoOff();
                    return true;
                }
                return false;
            }
        }
        this.getModemDriver().write("AT+CSCS=\"CDMA\"\r");
        this.getModemDriver().getResponse();
        if (this.getModemDriver().isOk()) {
            this.getModemDriver().write("AT+WSCL=6,4\r");
            this.echoOff();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendMessage(int size, String pdu, String phone, String text) throws GatewayException, IOException, InterruptedException {
        String response = "";
        int refNo = -1;
        boolean isContinue = true;
        if (JDSMSServer.getInstance().getProperties().getString("settings.delete_after_processing", "no").equalsIgnoreCase("no")) {
            this.getModemDriver().write("AT+CMGD=1,4\r");
            try {
                this.getModemDriver().getResponse();
            }
            catch (Exception e2) {
                Logger.getInstance().logError("\u5220\u9664\u77ed\u4fe1\u51fa\u73b0\u5f02\u5e38", null, this.getGateway().getGatewayId());
            }
        }
        Logger.getInstance().logDebug("wait...", null, this.getGateway().getGatewayId());
        byte[] unicodeBytes = ATHandler_Wavecom_WISMOQCDMA.ascii2UnicodeBytes(text, false);
        for (int i2 = 0; i2 <= (unicodeBytes.length - 1) / 130; ++i2) {
            int length = unicodeBytes.length < 130 * (i2 + 1) ? unicodeBytes.length - 130 * i2 : 130;
            byte[] sendingBytes = new byte[length];
            try {
                System.arraycopy(unicodeBytes, i2 * 130, sendingBytes, 0, length);
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
            Logger.getInstance().logInfo(text + " : \u7684unicode bytes are: " + new String(unicodeBytes), null, this.getGateway().getGatewayId());
            Object object = this.a;
            synchronized (object) {
                this.getModemDriver().clearBuffer();
                if (unicodeBytes.length <= 140) {
                    this.getModemDriver().write("AT+CMGS=\"_1_\",_2_\r".replaceAll("_1_", phone).replaceAll("_2_", unicodeBytes.length + ""));
                    Logger.getInstance().logInfo("\u5f00\u59cb\u53d1\u77ed\u4fe1:" + "AT+CMGS=\"_1_\",_2_\r".replaceAll("_1_", phone).replaceAll("_2_", unicodeBytes.length + ""), null, this.getGateway().getGatewayId());
                    this.getModemDriver().write(unicodeBytes);
                    isContinue = false;
                } else {
                    int k2 = (unicodeBytes.length - 1) / 130 + 1;
                    String prefix = "(" + (i2 + 1) + "/" + k2 + ")";
                    byte[] prefixUnicodeBytes = ATHandler_Wavecom_WISMOQCDMA.ascii2UnicodeBytes(prefix, false);
                    byte[] fullUnicodeBytes = new byte[prefixUnicodeBytes.length + sendingBytes.length];
                    System.arraycopy(prefixUnicodeBytes, 0, fullUnicodeBytes, 0, prefixUnicodeBytes.length);
                    System.arraycopy(sendingBytes, 0, fullUnicodeBytes, prefixUnicodeBytes.length, sendingBytes.length);
                    this.getModemDriver().write("AT+CMGS=\"_1_\",_2_\r".replaceAll("_1_", phone).replaceAll("_2_", fullUnicodeBytes.length + ""));
                    Logger.getInstance().logInfo("\u5f00\u59cb\u53d1\u77ed\u4fe1:" + "AT+CMGS=\"_1_\",_2_\r".replaceAll("_1_", phone).replaceAll("_2_", fullUnicodeBytes.length + ""), null, this.getGateway().getGatewayId());
                    this.getModemDriver().write(fullUnicodeBytes);
                }
                Logger.getInstance().logInfo("\u77ed\u4fe1\u5185\u5bb9: " + text, null, this.getGateway().getGatewayId());
                this.getModemDriver().write('\u0000');
                this.getModemDriver().write('\u001a');
                this.getModemDriver().write('\r');
                boolean flag = true;
                boolean second = false;
                long startTime = System.currentTimeMillis();
                boolean nDebug = false;
                while (flag) {
                    if ((System.currentTimeMillis() - startTime) / 1000L >= 120L) {
                        refNo = -1;
                        break;
                    }
                    Logger.getInstance().logInfo("response \u5f00\u59cb\u54cd\u5e94...", null, this.getGateway().getGatewayId());
                    try {
                        response = second ? this.getModemDriver().getResponseString() : this.getModemDriver().getResponse();
                    }
                    catch (TimeoutException e4) {
                        e4.printStackTrace();
                        Logger.getInstance().logInfo("\u63a5\u6536\u77ed\u4fe1\u54cd\u5e94\u65f6\u51fa\u73b0\u8d85\u65f6\u5f02\u5e38", e4, this.getGateway().getGatewayId());
                    }
                    if (response.indexOf("CMGR:") == -1 && response.indexOf("CMGL:") == -1 && response.indexOf("CDS:") == -1) {
                        second = true;
                        continue;
                    }
                    String checkString = response.substring(response.lastIndexOf(","), response.length());
                    if (checkString.indexOf("32768") != -1 || checkString.indexOf("8") != -1) {
                        StringBuilder tmp = new StringBuilder();
                        int n2 = response.indexOf(",");
                        while (!Character.isDigit(response.charAt(n2))) {
                            ++n2;
                        }
                        while (Character.isDigit(response.charAt(n2))) {
                            tmp.append(response.charAt(n2));
                            ++n2;
                        }
                        refNo = Integer.parseInt(tmp.toString());
                    } else {
                        refNo = -1;
                    }
                    Logger.getInstance().logInfo("\u8fd4\u56de\u54cd\u5e94: " + response, null, this.getGateway().getGatewayId());
                    break;
                }
            }
            if (!isContinue) break;
        }
        return refNo;
    }

    public static byte[] ascii2UnicodeBytes(String theString, boolean escapeSpace) {
        int len = theString.length();
        int buflen = len * 2;
        if (buflen < 0) {
            buflen = Integer.MAX_VALUE;
        }
        byte[] outBuffer = new byte[buflen];
        for (int i2 = 0; i2 < len; ++i2) {
            char aChar = theString.charAt(i2);
            outBuffer[2 * i2] = (byte)(aChar >> 8);
            outBuffer[2 * i2 + 1] = (byte)(aChar << 8 >> 8);
        }
        return outBuffer;
    }
}

