/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem.athandler;

import cn.ajwcc.pduUtils.gsm3040.Pdu;
import cn.ajwcc.pduUtils.gsm3040.PduParser;
import cn.ajwcc.pduUtils.gsm3040.SmsDeliveryPdu;
import cn.sendsms.GatewayException;
import cn.sendsms.InboundMessage;
import cn.sendsms.Service;
import cn.sendsms.TimeoutException;
import cn.sendsms.modem.ModemGateway;
import cn.sendsms.modem.athandler.ATHandler;
import cn.sendsms.util.Logger;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ATHandler_Yuga
extends ATHandler {
    public ATHandler_Yuga(ModemGateway myGateway) {
        super(myGateway);
        this.setStorageLocations("SM");
    }

    @Override
    public String getStorageLocations() {
        return "SM";
    }

    @Override
    public void reset() throws TimeoutException, GatewayException, IOException, InterruptedException {
        super.reset();
        this.getModemDriver().clearBuffer();
    }

    @Override
    public String sendCustomATCommand(String atCommand) throws GatewayException, TimeoutException, IOException, InterruptedException {
        this.getModemDriver().write(atCommand);
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        return this.getModemDriver().getResponse();
    }

    @Override
    public void done() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.threadWait(Service.getInstance().getSettings().AT_WAIT_AFTER_RESET);
    }

    @Override
    public void init() throws TimeoutException, GatewayException, IOException, InterruptedException {
        super.init();
        this.threadWait(2000L);
        this.getModemDriver().write("ATE0\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CPMS=\"SM\",\"MT\",\"SM\"\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT&W\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().getResponse();
    }

    @Override
    public String readTextMode() throws GatewayException, TimeoutException, IOException, InterruptedException {
        this.threadWait(2000L);
        this.getModemDriver().write("AT+CMGF?\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        return this.getModemDriver().getResponse();
    }

    @Override
    public int findMatchingTerminator(String response) {
        if (response.indexOf("OK") != -1) {
            return 0;
        }
        for (int i2 = 0; i2 < this.terminators.length; ++i2) {
            if (!response.matches(this.terminators[i2])) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public String listMessages(InboundMessage.MessageClasses messageClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        StringBuilder listMessage = new StringBuilder();
        this.getModemDriver().write("AT+CMGD=?\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        String indexstr = this.getModemDriver().getResponse();
        int start = indexstr.indexOf("(");
        int end = indexstr.indexOf(")");
        String parseStr = "";
        if (start + 1 < end) {
            String[] indexs = indexstr.substring(start + 1, end).split(",");
            PduParser parser = new PduParser();
            for (int iindex = 0; indexs != null && iindex < indexs.length; ++iindex) {
                String index = indexs[iindex];
                try {
                    int endIndex;
                    this.getModemDriver().write("ATE0\r");
                    this.threadWait(Service.getInstance().getSettings().AT_WAIT);
                    this.getModemDriver().getResponse();
                    this.getModemDriver().write("AT+CMGR=" + index + "\r");
                    this.threadWait(Service.getInstance().getSettings().AT_WAIT);
                    indexstr = this.getModemDriver().getResponse();
                    indexstr = indexstr.substring(indexstr.indexOf("+CMGR"));
                    Matcher matcher = this.delLineSeparatorAfterCMGR.matcher(indexstr);
                    if (matcher.find()) {
                        indexstr = indexstr.replace(matcher.group(), matcher.group(1) + "\r");
                    }
                    String pduString = indexstr.trim();
                    Logger.getInstance().logInfo("\u6536\u5230\u77ed\u4fe1:" + pduString, null, null);
                    int startIndex = pduString.indexOf("\n");
                    if (startIndex == -1) {
                        startIndex = pduString.indexOf("\r");
                    }
                    if ((endIndex = pduString.lastIndexOf("\nOK")) == -1) {
                        endIndex = pduString.lastIndexOf("\rOK");
                    }
                    parseStr = pduString = pduString.substring(startIndex + 1, endIndex).replaceFirst("[\r|\n]+", "");
                    Pdu pdu = parser.parsePdu(pduString);
                    String sendDate = "";
                    if (pdu instanceof SmsDeliveryPdu) {
                        sendDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(((SmsDeliveryPdu)pdu).getTimestamp());
                    }
                    listMessage.append(indexstr.replace("CMGR:", "CMGL: " + index + ",").replaceFirst("\n*OK.*", ""));
                    this.getModemDriver().write("AT+CMGD=" + index + "\r");
                    this.threadWait(Service.getInstance().getSettings().AT_WAIT);
                    this.getModemDriver().getResponse();
                    if (!this.getModemDriver().isOk()) {
                        throw new RuntimeException("\u5220\u9664\u77ed\u4fe1 " + indexstr + " : \u4f4d\u7f6e" + index + "\u51fa\u9519");
                    }
                    continue;
                }
                catch (Exception e2) {
                    Logger.getInstance().logError("\u8bfb\u53d6" + index + "\u4f4d\u7f6e\u7684\u77ed\u4fe1" + parseStr + "\u65f6\u51fa\u9519", e2, this.getGateway().getGatewayId());
                }
            }
        }
        listMessage.append("\nOK");
        return listMessage.toString();
    }

    @Override
    public boolean deleteMessage(int memIndex, String memLocation) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return true;
    }

    public static void main(String[] args) {
        Pattern delLineSeparatorAfterCMGR = Pattern.compile("(\\+CMGR:.*?)[\r|\n]{2,}");
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n+CMGR: 0,\"\",26\n");
        sb.append("0891683108100005F04005A10180F600089120720171302388050003EF040367E56D4191CF300167E58BDD8D393001529E4E1A52A1FF0C8FD853EF53C252A0591A79CD4F1860E06D3B52A8FF0C514D8D396D4191CF98864E0D505C30024E0B8F7D57305740FF1A00680074007400700073003A002F002F006100700070002E00310030003000380036002E0063006E002F0044004C0031003000300073006D3002\n");
        sb.append("OK");
        String indexstr = sb.toString();
        Matcher matcher = delLineSeparatorAfterCMGR.matcher(indexstr);
        if (matcher.find()) {
            indexstr = indexstr.replace(matcher.group(), matcher.group(1) + "\r");
        }
        System.out.println("indexstr=" + indexstr);
        String pduString = indexstr.trim();
        System.out.println(pduString);
        int startIndex = pduString.indexOf("\n");
        int endIndex = pduString.lastIndexOf("\nOK");
        String parseStr = pduString = pduString.substring(startIndex + 1, endIndex).replaceFirst("[\r|\n]+", "");
        System.out.println("pduString=" + pduString);
        Logger.getInstance().logInfo("\u6536\u5230\u77ed\u4fe1:" + pduString, null, null);
        PduParser parser = new PduParser();
        Pdu pdu = parser.parsePdu(pduString);
        String sendDate = "";
        if (pdu instanceof SmsDeliveryPdu) {
            sendDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(((SmsDeliveryPdu)pdu).getTimestamp());
        }
    }

    @Override
    public void modifyMMSRemindWay() throws IOException, InterruptedException {
        this.getModemDriver().write("AT+MMSMODE=1\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        String response = "";
        try {
            response = this.getModemDriver().getResponse();
        }
        catch (Exception e2) {
            Logger.getInstance().logError("\u5f69\u4fe1\u63a5\u6536\u6a21\u5f0f\u53d8\u66f4\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u5c1d\u8bd5\u91cd\u65b0\u542f\u52a8!\u8bbe\u5907\u54cd\u5e94\uff1a" + response, e2, "");
        }
        if (response.contains("ERROR")) {
            Logger.getInstance().logInfo("\u5f69\u4fe1\u63a5\u6536\u6a21\u5f0f\u53d8\u66f4\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u5c1d\u8bd5\u91cd\u65b0\u542f\u52a8!\u8bbe\u5907\u54cd\u5e94\uff1a" + response, null, null);
        }
    }
}

