/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.driver.nbiotDriver;

import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.otherModem.bean.NbIoTBean;
import cn.sendsms.otherModem.common.ComReadWriter;
import cn.sendsms.otherModem.common.ComReadWriterManager;
import cn.sendsms.otherModem.common.Utils;
import cn.sendsms.otherModem.driver.nbiotDriver.NbIoTDriver;
import cn.sendsms.otherModem.thread.WatchDog;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jssc.SerialPort;
import org.apache.commons.configuration.PropertiesConfiguration;

public class SIM7020CNbIoTDriver
extends NbIoTDriver {
    private static final SIM7020CNbIoTDriver SIM7020C_DRIVER = new SIM7020CNbIoTDriver();
    private ComReadWriterManager a = new ComReadWriterManager();

    public static final SIM7020CNbIoTDriver getInstance() {
        return SIM7020C_DRIVER;
    }

    @Override
    public boolean connectSucessed(String portID) {
        ComReadWriter thisReadWriter = this.a.getReadWriter(portID);
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        SerialPort serialport = nbiotDeviceInfoGetter.getSerialPort(portID);
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(portID);
        String mqttServer = props.getString("settings.mqtt_server", "gateway.sendsms.cn");
        String mqttPort = props.getString("settings.mqtt_port", "1883");
        String mqttUser = props.getString("settings.mqtt_user", "0000");
        String mqttPassword = props.getString("settings.mqtt_password", "0000");
        int keepAlive = props.getInt("settings.mqtt_keepalive", 10);
        int ack = props.getInt("settings.mqtt_ack", 8);
        String deviceConnectionConfigCmd = "AT+CMQNEW=\"" + mqttServer + "\",\"" + mqttPort + "\"," + keepAlive * 1000 + ",1024\r";
        if (!thisReadWriter.send(serialport, deviceConnectionConfigCmd)) {
            log.error((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            ComReadWriter.xClosePort(serialport);
            return false;
        }
        ComReadWriter.ComReadResult ret = thisReadWriter.recv(serialport, 5000L);
        if (ret.code != 1) {
            log.error((Object)(serialport.getPortName() + "\u914d\u7f6eMQTT\u670d\u52a1\u5668\u8fde\u63a5\u53c2\u6570\u5f02\u5e38:" + ret.szValue));
            return false;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        String communicationID = device.getCommunicationID();
        String deviceConnectionServerCmd = "AT+CMQCON=0,3,\"" + communicationID + "\",600,0,0\r";
        if (!thisReadWriter.send(serialport, deviceConnectionServerCmd)) {
            log.error((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        ComReadWriter.ComReadResult ret2 = thisReadWriter.recv(serialport, 5000L);
        if (ret2.code != 1) {
            log.error((Object)(serialport.getPortName() + "MQTT\u670d\u52a1\u5668\u8fde\u63a5\u5f02\u5e38:" + ret2.szValue));
            return false;
        }
        this.getCompleteMessages(null, serialport, device, "\u8fde\u63a5MQTT\u670d\u52a1\u5668");
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException e3) {
            e3.printStackTrace();
        }
        return true;
    }

    public static String bytes2HexString(byte[] array) {
        if (array == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (byte b2 : array) {
            String hex = Integer.toHexString(b2 & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            builder.append(hex);
        }
        return builder.toString().toUpperCase();
    }

    public static byte[] hexString2Bytes(String hex) {
        if (hex == null) {
            return null;
        }
        int m2 = 0;
        int n2 = 0;
        int byteLen = hex.length() / 2;
        byte[] ret = new byte[byteLen];
        for (int i2 = 0; i2 < byteLen; ++i2) {
            m2 = i2 * 2 + 1;
            n2 = m2 + 1;
            int intVal = Integer.decode("0x" + hex.substring(i2 * 2, m2) + hex.substring(m2, n2));
            ret[i2] = (byte)intVal;
        }
        return ret;
    }

    private String a(String subMessage) {
        String szRegex = "\\\"[0-9a-zA-Z]*?\\\"$";
        Pattern tailPattern = Pattern.compile(szRegex);
        Matcher tailMatcher = tailPattern.matcher(subMessage);
        if (!tailMatcher.find()) {
            return "";
        }
        String szHex = tailMatcher.group(0).replaceAll("\"", "");
        String szDec = "";
        try {
            szDec = new String(SIM7020CNbIoTDriver.hexString2Bytes(szHex), "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            log.info((Object)("\u6d88\u606f\u5185\u5bb9\u89e3\u6790\u9519\u8bef:" + e2));
        }
        return szDec;
    }

    private boolean a(String messages, NbIoTBean device, List<String> messageList) {
        String szCommID = device.getCommunicationID();
        String messageRegex = "\\+JINDIPUB2:\\s+[0-9],\\\"" + szCommID + "\\\",[0-9]{1,2},[0-9]{1,2},[0-9]{1,2},[0-9]{1,4},\\\"[0-9a-zA-Z]*?\\\"";
        Pattern messagePattern = Pattern.compile(messageRegex);
        String szJindi = messages.replaceAll("\\+CMQPUB:", "\\+JINDIPUB1:\\+JINDIPUB2:");
        String[] szArray = szJindi.split("\\+JINDIPUB1:");
        boolean bComplete = true;
        for (String szItem : szArray) {
            if (szItem.indexOf("+JINDIPUB2:") != 0) continue;
            Matcher messageMatcher = messagePattern.matcher(szItem);
            if (messageMatcher.find()) {
                messageList.add(this.a(messageMatcher.group(0)));
                continue;
            }
            bComplete = false;
        }
        return bComplete;
    }

    @Override
    public boolean isCompleteMessages(byte[] messageByteArray, NbIoTBean device, List<String> messageList, List<String> incompleteMessageList) {
        String messages = Utils.getString(messageByteArray);
        return this.a(messages, device, messageList);
    }

    @Override
    public String getCommunicationID(String serialNumber) {
        String communicationID = "";
        if (serialNumber == null || serialNumber.equals("")) {
            return communicationID;
        }
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        String pointedOrignStr = props.getString("random_number_seed", "");
        if (pointedOrignStr != null && !"".equals(pointedOrignStr) && pointedOrignStr.length() >= 10 && pointedOrignStr.matches("[0-9a-zA-Z]+")) {
            serialNumber = pointedOrignStr;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(serialNumber.getBytes("UTF-8"));
            byte[] b2 = md.digest();
            communicationID = new BigInteger(1, b2).toString(16).substring(8, 16).toUpperCase();
        }
        catch (Exception e2) {
            log.error((Object)"\u83b7\u53d6\u901a\u4fe1ID\u5931\u8d25\u3002\u3002\u3002", (Throwable)e2);
            communicationID = "";
        }
        return communicationID;
    }

    public static String createMessageBody(String szTxt) {
        if (szTxt == null) {
            return "";
        }
        byte[] bzEnc = null;
        try {
            bzEnc = szTxt.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            System.out.println("ERROR:" + e2);
        }
        return SIM7020CNbIoTDriver.bytes2HexString(bzEnc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendMessage(String recipient, String text, NbIoTBean nbiotDevice) {
        String szMsgBody = SIM7020CNbIoTDriver.createMessageBody(text);
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        String usingPort = nbiotDevice.getPortID();
        ComReadWriter thisReadWriter = this.a.getReadWriter(usingPort);
        SerialPort serialport = nbiotDeviceInfoGetter.getSerialPort(usingPort);
        int mqttQos = props.getInt("settings.mqtt_qos", 1);
        String sendMessagecmd = "AT+CMQPUB=0,\"" + recipient + "\"," + mqttQos + ",0,0," + szMsgBody.length() + ",\"" + szMsgBody + "\"\r";
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            if (!thisReadWriter.send(serialport, sendMessagecmd)) {
                log.error((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
                ComReadWriter.xClosePort(serialport);
                return false;
            }
            ComReadWriter.ComReadResult ret = thisReadWriter.recv(serialport, 10000L);
            if (ret.code != 1) {
                log.error((Object)(serialport.getPortName() + "\u6d88\u606f\u53d1\u9001\u5931\u8d25:" + ret.szValue));
                return false;
            }
        }
        this.getCompleteMessages(null, serialport, nbiotDevice, "\u53d1\u9001\u7ebf\u7a0b");
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        return true;
    }

    @Override
    public void commandNotEcho(SerialPort serialPort) {
        if (!ComReadWriter.xSend(serialPort, "ATE0\r")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return;
        }
        ComReadWriter.ComReadResult ret = ComReadWriter.xRecv(serialPort, 5000L);
        if (ret.code != 1) {
            log.error((Object)"\u5173\u95ed\u547d\u4ee4\u56de\u663e\u5931\u8d25");
        } else {
            log.info((Object)"\u5173\u95ed\u547d\u4ee4\u56de\u663e\u6210\u529f");
        }
    }

    @Override
    public boolean subSucessed(String portID) {
        ComReadWriter thisReadWriter = this.a.getReadWriter(portID);
        SerialPort serialport = nbiotDeviceInfoGetter.getSerialPort(portID);
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(portID);
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        int mqttQos = props.getInt("settings.mqtt_qos", 1);
        String subscribeTopic = "AT+CMQSUB=0,\"" + device.getCommunicationID() + "\"," + mqttQos + "\r";
        if (!thisReadWriter.send(serialport, subscribeTopic)) {
            log.error((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        ComReadWriter.ComReadResult ret = thisReadWriter.recv(serialport, 5000L);
        if (ret.code != 1) {
            log.error((Object)(serialport.getPortName() + "\u6d88\u606f\u8ba2\u9605\u5931\u8d25: " + ret.szValue));
            return false;
        }
        this.getCompleteMessages(null, serialport, device, "\u8ba2\u9605\u4e3b\u9898");
        return true;
    }

    @Override
    public void disconnectMQTTServer(SerialPort serialport) {
        ComReadWriter thisReadWriter = this.a.getReadWriter(serialport.getPortName());
        if (!thisReadWriter.send(serialport, "AT+CMQDISCON=0\r")) {
            log.error((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return;
        }
        ComReadWriter.ComReadResult ret = thisReadWriter.recv(serialport, 5000L);
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public boolean networkNormal(SerialPort serialPort) {
        ComReadWriter thisReadWriter = this.a.getReadWriter(serialPort.getPortName());
        if (!thisReadWriter.send(serialPort, "AT+CGREG?\r")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        ComReadWriter.ComReadResult ret = thisReadWriter.recv(serialPort, 5000L);
        if (ret.code != 1) {
            log.info((Object)("\u7f51\u7edc\u72b6\u6001\u83b7\u53d6\u9519\u8bef\uff1a" + ret.szValue));
            return false;
        }
        Pattern pattern = Pattern.compile("CGREG:[\\s]*0,1");
        Matcher matcher = pattern.matcher(ret.szValue);
        if (matcher.find()) {
            log.info((Object)(serialPort.getPortName() + "\u7f51\u7edc\u6b63\u5e38\u3002\u3002\u3002"));
            return true;
        }
        log.info((Object)("\u5f53\u524d\u7f51\u7edc\u72b6\u6001\uff1a" + ret.szValue));
        return false;
    }

    @Override
    public boolean initDevice(SerialPort serialPort) {
        if (!ComReadWriter.xSend(serialPort, "AT+CRESET\r")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        ComReadWriter.ComReadResult ret = ComReadWriter.xRecv(serialPort, "READY", "ERROR", 10000L);
        if (ret.code != 1) {
            log.info((Object)("\u8bbe\u5907\u91cd\u542f\u5931\u8d25\uff1a" + ret.szValue));
            return false;
        }
        log.info((Object)("\u8bbe\u5907\u91cd\u542f\u5b8c\u6210\uff1a" + ret.szValue));
        return true;
    }

    @Override
    public String getSignal(SerialPort serialPort) {
        String signal = "99,99";
        boolean needToClose = false;
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        if (device != null && !SIM7020CNbIoTDriver.serialportConnected(serialPort)) {
            Utils.closePort(serialPort);
            if (Utils.openPort(device.getBaudrate(), serialPort)) {
                needToClose = true;
            } else {
                return signal;
            }
        }
        if (!ComReadWriter.xSend(serialPort, "AT+CSQ\r")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return signal;
        }
        ComReadWriter.ComReadResult ret = ComReadWriter.xRecv(serialPort, 5000L);
        if (ret.code != 1) {
            return signal;
        }
        String regex = "\\+CSQ:[\\s\\S]+[0-9]+,[0-9]+";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(ret.szValue);
        if (matcher.find()) {
            signal = matcher.group(0);
        }
        signal = Utils.deletePrefix(signal, "+CSQ:");
        signal = signal.trim();
        if (needToClose) {
            Utils.closePort(serialPort);
        }
        return signal;
    }

    @Override
    public String getSerialNumber(SerialPort serialPort) {
        boolean needToClose = false;
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        if (device != null && !SIM7020CNbIoTDriver.serialportConnected(serialPort)) {
            Utils.closePort(serialPort);
            log.info((Object)("\u6b63\u5728\u5c1d\u8bd5\u6253\u5f00\u7aef\u53e3:" + serialPort.getPortName()));
            if (Utils.openPort(device.getBaudrate(), serialPort)) {
                needToClose = true;
            } else {
                return "";
            }
        }
        if (!ComReadWriter.xSend(serialPort, "AT+CGSN\r")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return "";
        }
        ComReadWriter.ComReadResult ret = ComReadWriter.xRecv(serialPort, 5000L);
        if (ret.code != 1) {
            return "";
        }
        String serialNumber = "";
        String regex = "[A-Z,0-9]{10,}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(ret.szValue);
        if (matcher.find()) {
            serialNumber = matcher.group(0);
        }
        return serialNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connectionOK(String portID) {
        ComReadWriter thisReadWriter = this.a.getReadWriter(portID);
        SerialPort serialport = nbiotDeviceInfoGetter.getSerialPort(portID);
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(portID);
        if ("0".equals(device.getUsingStatus())) {
            log.info((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u5df2\u7ecf\u5173\u95ed\u3002\u3002\u3002"));
            return true;
        }
        String getStateCmd = "AT+CMQCON?\r";
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            if (!thisReadWriter.send(serialport, getStateCmd)) {
                if ("0".equals(device.getUsingStatus())) {
                    log.info((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u5df2\u7ecf\u5173\u95ed\u3002\u3002\u3002"));
                    return true;
                }
                return false;
            }
            ComReadWriter.ComReadResult ret = thisReadWriter.recv(serialport, 2000L);
            if (ret.code != 1) {
                log.info((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u72b6\u6001\u83b7\u53d6\u5f02\u5e38\uff1a" + ret.szValue));
                this.disconnectMQTTServer(serialport);
                return false;
            }
            if (ret.szValue.indexOf("null") > 0) {
                log.info((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u72b6\u6001\u65ad\u7ebf\u4e86\uff1a" + ret.szValue));
                this.disconnectMQTTServer(serialport);
                return false;
            }
        }
        this.getCompleteMessages(null, serialport, device, "\u5224\u65ad\u8fde\u63a5\u72b6\u6001");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getCompleteMessages(byte[] responseByteArray, SerialPort serialport, NbIoTBean device, String markForLog) {
        ComReadWriter thisReadWriter = this.a.getReadWriter(serialport.getPortName());
        thisReadWriter.recvNoWait(serialport);
        ArrayList<String> messageList = new ArrayList<String>();
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            String szLine;
            while ((szLine = thisReadWriter.getRecvLine()) != null) {
                if (szLine.indexOf("CMQPUB:") > 0 || szLine.indexOf("CMQDISCON:") > 0) {
                    log.info((Object)("RECV: " + szLine));
                }
                this.a(szLine, device, messageList);
            }
        }
        for (int i2 = 0; i2 < messageList.size(); ++i2) {
            nbiotMessageHolder.updateMessageList(device, (String)messageList.get(i2));
        }
    }

    private void b(String portID) {
        NbIoTBean device = nbiotDeviceInfoGetter.findDeviceByPortID(portID);
        if (device != null && "1" == device.getUsingStatus()) {
            log.error((Object)"\u8bbe\u5907\u8fde\u63a5\u5f02\u5e38\uff0c\u5373\u5c06\u91cd\u542f\uff01");
            device.setUsingStatus("2");
            log.info((Object)(device.getGatewayID() + "\u5373\u5c06\u91cd\u542f\u3002\u3002\u3002"));
            WatchDog.getInstance().interrupt();
        }
    }

    @Override
    public boolean isDeviceAT(SerialPort serialPort) {
        ComReadWriter thisReadWriter = this.a.getReadWriter(serialPort.getPortName());
        if (!thisReadWriter.send(serialPort, "AT\r")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        ComReadWriter.ComReadResult ret = thisReadWriter.recv(serialPort, 5000L);
        return ret.code == 1;
    }
}

