/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.driver.nbiotDriver;

import cn.sendsms.otherModem.bean.NbIoTBean;
import cn.sendsms.otherModem.bean.VitualNbIoTBean;
import cn.sendsms.otherModem.common.Const;
import cn.sendsms.otherModem.common.Utils;
import cn.sendsms.otherModem.driver.ModemDriver;
import cn.sendsms.otherModem.driver.nbiotDriver.NbIoTDriver;
import cn.sendsms.otherModem.nbiot.JDMqttConnectOptions;
import cn.sendsms.otherModem.thread.WatchDog;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jssc.SerialPort;
import jssc.SerialPortException;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class VirtualNbIoTDriver
extends NbIoTDriver {
    private static final VirtualNbIoTDriver VITUAL_NBIOT_DRIVER = new VirtualNbIoTDriver();

    public static final VirtualNbIoTDriver getInstance() {
        return VITUAL_NBIOT_DRIVER;
    }

    @Override
    public String getSignal(SerialPort serialPort) {
        String signal = "99,99";
        if (this.connectionOK("")) {
            return "30,00";
        }
        return signal;
    }

    @Override
    public String getSerialNumber(SerialPort serialPort) {
        String serialNumber = "";
        return serialNumber;
    }

    @Override
    public String getCommunicationID(String serialNumber) {
        String randomString = UUID.randomUUID().toString();
        String nowStr = Const.DATEFORMAT.format(new Date());
        String communicationID = nowStr + randomString;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(communicationID.getBytes("UTF-8"));
            byte[] b2 = md.digest();
            communicationID = new BigInteger(1, b2).toString(16).substring(8, 16).toUpperCase();
        }
        catch (Exception e2) {
            log.error((Object)"\u83b7\u53d6\u901a\u4fe1ID\u5931\u8d25\u3002\u3002\u3002", (Throwable)e2);
            communicationID = "";
        }
        return communicationID;
    }

    @Override
    public boolean networkNormal(SerialPort serialPort) {
        return this.connectionOK("");
    }

    @Override
    public boolean isCompleteMessages(byte[] messageByteArray, NbIoTBean device, List<String> messageList, List<String> incompleteMessageList) {
        return true;
    }

    @Override
    public boolean initDevice(SerialPort serialPort) {
        return true;
    }

    @Override
    public boolean sendMessage(String recipient, String text, NbIoTBean device) {
        VitualNbIoTBean nbiotDevice = (VitualNbIoTBean)device;
        if (!"JD-VITUAL-NBIOT-DEVICE".equals(nbiotDevice.getDeviceType())) {
            log.error((Object)(nbiotDevice.getGatewayID() + "\u8bbf\u95ee\u5f02\u5e38\u3002\u3002"));
            return false;
        }
        if ("0".equals(nbiotDevice.getUsingStatus())) {
            log.info((Object)(nbiotDevice.getGatewayID() + "\u5df2\u7ecf\u505c\u6b62\u3002\u3002"));
            return false;
        }
        if ("2".equals(nbiotDevice.getUsingStatus())) {
            log.info((Object)(nbiotDevice.getGatewayID() + "\u6b63\u5728\u91cd\u542f\u3002\u3002"));
            return false;
        }
        try {
            MqttMessage messageToSend = nbiotDevice.getMessage();
            messageToSend.clearPayload();
            messageToSend.setPayload(Utils.getByteArray(text));
            nbiotDevice.getClient().publish(recipient, messageToSend);
        }
        catch (Exception e2) {
            log.error((Object)("\u4fe1\u606f\u3010" + text + "\u3011\u53d1\u9001\u5931\u8d25"), (Throwable)e2);
            return false;
        }
        return true;
    }

    @Override
    public void commandNotEcho(SerialPort serialPort) {
    }

    @Override
    public boolean subSucessed(String portID) {
        VitualNbIoTBean vitualDevice = nbiotDeviceInfoGetter.findVitualNbIoTBeanByPortID(portID);
        try {
            vitualDevice.getClient().subscribe(vitualDevice.getCommunicationID());
        }
        catch (Exception e2) {
            log.error((Object)("\u865a\u62df\u8bbe\u5907" + vitualDevice.getGatewayID() + "\u8ba2\u9605\u4e3b\u9898\u5931\u8d25\uff01"), (Throwable)e2);
        }
        return true;
    }

    @Override
    public boolean connectSucessed(String portID) {
        VitualNbIoTBean vitualDevice = nbiotDeviceInfoGetter.findVitualNbIoTBeanByPortID(portID);
        vitualDevice.setClient(nbiotDeviceInfoGetter.generateMqttClient(vitualDevice.getCommunicationID()));
        try {
            if (vitualDevice.getClient().isConnected()) {
                return true;
            }
            vitualDevice.getClient().connect(JDMqttConnectOptions.getOptions());
            log.info((Object)("\u8bbe\u5907" + vitualDevice.getGatewayID() + "\u5df2\u7ecf\u6210\u529f\u8fde\u63a5\u5230MQTT\u670d\u52a1\u5668\uff01"));
        }
        catch (Exception e2) {
            log.error((Object)("\u865a\u62df\u8bbe\u5907" + vitualDevice.getGatewayID() + "\u8fde\u63a5MQTT\u670d\u52a1\u5668\u5931\u8d25\uff01"), (Throwable)e2);
            return false;
        }
        return true;
    }

    @Override
    public void disconnectMQTTServer(SerialPort serialport) {
        VitualNbIoTBean vitualDevice = nbiotDeviceInfoGetter.findVitualNbIoTBeanByPortID(serialport.getPortName());
        try {
            vitualDevice.getClient().disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean connectionOK(String portID) {
        return true;
    }

    public String decodeMessage(String context) {
        int receivedContextLength;
        String decodedContext = "";
        int sentContextLength = 0;
        String sentContextLengthStr = context.substring(35, 38);
        try {
            sentContextLength = Integer.valueOf(sentContextLengthStr, 16);
        }
        catch (NumberFormatException e2) {
            log.info((Object)"\u4fe1\u606f\u672a\u63a5\u6536\u5b8c(1)");
            return "";
        }
        String codingType = context.substring(34, 35);
        decodedContext = context;
        if ("U".equals(codingType)) {
            String attachInfo = context.substring(0, 38);
            String encodedText = context.substring(38);
            try {
                decodedContext = attachInfo + Utils.getString(Utils.hexStr2ByteArr(encodedText));
            }
            catch (Exception e3) {
                log.info((Object)"\u4fe1\u606f\u672a\u63a5\u6536\u5b8c(2)");
                return "";
            }
        }
        if (sentContextLength != (receivedContextLength = Utils.getByteArray(context.substring(38)).length)) {
            log.info((Object)"\u4fe1\u606f\u672a\u63a5\u6536\u5b8c(3)");
            return "";
        }
        return decodedContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] a(SerialPort serialPort, String incompleteMessage, NbIoTBean device) {
        String messageRegex;
        if ("Quectel_BC26".equals(device.getDeviceType()) && incompleteMessage.endsWith("\"") && incompleteMessage.matches(messageRegex = "(\\+QMT){0,1}RECV: [0-9]+,[0-9]+,\"" + device.getCommunicationID() + "\",\"[\\s\\S]+\"$")) {
            log.info((Object)("\u4fe1\u606f\u4e0d\u5b8c\u6574\uff08\u8bbe\u5907\u5bfc\u81f4\u7684\u4fe1\u606f\u4e22\u5931\uff09\uff1a" + incompleteMessage));
            return Utils.getByteArray(incompleteMessage);
        }
        int retryTime = 0;
        byte[] rest = null;
        byte[] response = incompleteMessage.getBytes();
        while (true) {
            SerialPort serialPort2 = serialPort;
            synchronized (serialPort2) {
                byte[] moreResponse;
                block25: {
                    moreResponse = new byte[1];
                    if (!VirtualNbIoTDriver.serialportConnected(serialPort)) {
                        return null;
                    }
                    try {
                        if (!serialPort.isOpened()) break block25;
                        while (serialPort.getInputBufferBytesCount() <= 0 && retryTime < 50) {
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException e2) {
                                log.info((Object)"\u7ebf\u7a0b\u7b49\u5f85\u88ab\u6253\u65ad\u3002\u3002\u3002");
                            }
                            if (++retryTime < 49) continue;
                            log.error((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u672a\u54cd\u5e94!"));
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(rest) + "\u3011"));
                            return response;
                        }
                        moreResponse = serialPort.readBytes(1);
                    }
                    catch (SerialPortException e3) {
                        log.error((Object)("\u8bfb\u4e32\u53e3" + serialPort.getPortName() + "\u5931\u8d25\u3002\u3002\u3002"), (Throwable)e3);
                        break;
                    }
                }
                if (moreResponse == null) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e4) {
                        log.info((Object)"\u7ebf\u7a0b\u7b49\u5f85\u88ab\u6253\u65ad\u3002\u3002\u3002");
                    }
                    if (++retryTime > 50) {
                        break;
                    }
                } else {
                    rest = Utils.mergeByteArray(moreResponse, rest);
                    response = Utils.mergeByteArray(moreResponse, response);
                    String responseStr = Utils.getString(response);
                    if ("Quectel_BC26".equals(device.getDeviceType())) {
                        if (responseStr.endsWith("+QMT")) {
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(rest) + "\u3011"));
                            log.info((Object)("\u4fe1\u606f\u7f3a\u5931\u90e8\u5206\u5df2\u7ecf\u8bfb\u5b8c\uff1a" + responseStr));
                            return Utils.getByteArray(responseStr.substring(0, responseStr.length() - 4));
                        }
                        String connectionRegex = "((\\+QMT){0,1}STAT: [0-9]+,[0-9]+)$";
                        String exceptionRegex = "Rb[\\S\\s]+B[\\S\\s]+";
                        Pattern connectionPattern = Pattern.compile(connectionRegex);
                        Pattern exceptionPattern = Pattern.compile(exceptionRegex);
                        Matcher connectionMatcher = connectionPattern.matcher(responseStr.replace("\r", "").replace("\n", ""));
                        Matcher exceptionMatcher = exceptionPattern.matcher(responseStr.replace("\r", "").replace("\n", ""));
                        if (connectionMatcher.find() || exceptionMatcher.find()) {
                            device.setUsingStatus("2");
                            WatchDog.getInstance().interrupt();
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(rest) + "\u3011"));
                            return Utils.getByteArray(responseStr.replaceAll(exceptionRegex, "").replaceAll(connectionRegex, ""));
                        }
                        if (responseStr.replace("\r", "").replace("\n", "").endsWith("ERROR")) {
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(rest) + "\u3011"));
                            return Utils.getByteArray(responseStr.replace("ERROR", ""));
                        }
                    }
                    if ("M5310-A".equals(device.getDeviceType())) {
                        if (responseStr.endsWith("+MQTT")) {
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(rest) + "\u3011"));
                            log.info((Object)("\u4fe1\u606f\u7f3a\u5931\u90e8\u5206\u5df2\u7ecf\u8bfb\u5b8c\uff1a" + responseStr));
                            return Utils.getByteArray(responseStr.substring(0, responseStr.length() - 5));
                        }
                        String reconnectRegex = "(\\+MQTT){0,1}REC:[0-9]+";
                        String publishSucessWithQosIs2ResponseRegex1 = "(\\+MQTT){0,1}PUBREC:[0-9]+,[0-9]+";
                        Pattern reconnectPattern = Pattern.compile(reconnectRegex);
                        Pattern publishSucessWithQosIs2Pattern1 = Pattern.compile(publishSucessWithQosIs2ResponseRegex1);
                        Matcher reconnectMatcher = reconnectPattern.matcher(responseStr.replace("\r", "").replace("\n", ""));
                        Matcher publishSucessWithQosIs2Matcher1 = publishSucessWithQosIs2Pattern1.matcher(responseStr.replace("\r", "").replace("\n", ""));
                        if (reconnectMatcher.find() && !publishSucessWithQosIs2Matcher1.find()) {
                            device.setUsingStatus("2");
                            WatchDog.getInstance().interrupt();
                            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(rest) + "\u3011"));
                            return Utils.getByteArray(responseStr.replaceAll(reconnectRegex, ""));
                        }
                        String exception1 = "REBOOT_CAUSE_APPLICATION_WATCHDOG";
                        String exception2 = "REBOOT_CAUSE_PROTOCOL_RPC_TIMEOUT";
                        if (responseStr.contains(exception1) || responseStr.contains(exception2)) {
                            this.stopDevice(serialPort.getPortName());
                        }
                    }
                }
            }
        }
        if (response != null && response.length != 0) {
            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(rest) + "\u3011"));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getCompleteMessages(byte[] responseByteArray, SerialPort serialport, NbIoTBean device, String markForLog) {
        int readTimes = 0;
        ArrayList<String> messageList = new ArrayList<String>();
        ArrayList<String> incompleteMessageList = new ArrayList<String>();
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            while (!this.isCompleteMessages(responseByteArray, device, messageList, incompleteMessageList)) {
                log.debug((Object)("\u6536\u5230\u4e0d\u5b8c\u6574\u4fe1\u606f\uff1a\u3010" + markForLog + "\u3011" + Utils.getString(responseByteArray)));
                if (readTimes >= 15 || messageList.size() > 50) {
                    log.info((Object)("\u8bfb\u4e32\u53e3\u6b21\u6570:" + readTimes));
                    log.info((Object)("\u5185\u5b58\u4e2d\u4fe1\u606f\u6761\u6570\uff1a" + messageList.size()));
                    if (incompleteMessageList.isEmpty()) break;
                    log.info((Object)("\u4fe1\u606f\u63a5\u6536\u5b8c\u6574\u524d" + (String)incompleteMessageList.get(0)));
                    byte[] lastMessageInByteArray = this.a(serialport, (String)incompleteMessageList.get(0), device);
                    log.info((Object)("\u4fe1\u606f\u63a5\u6536\u5b8c\u6574\u540e" + Utils.getString(lastMessageInByteArray)));
                    ArrayList<String> tmpMessageList = new ArrayList<String>();
                    incompleteMessageList = new ArrayList();
                    if (!this.isCompleteMessages(lastMessageInByteArray, device, tmpMessageList, incompleteMessageList)) {
                        log.error((Object)"\u4e0b\u5217\u4fe1\u606f\u672a\u63a5\u6536\u5b8c\u3002\u3002\u3002\u3002");
                        for (int i2 = 0; i2 < incompleteMessageList.size(); ++i2) {
                            log.info(incompleteMessageList.get(i2));
                        }
                        break;
                    }
                    messageList.addAll(tmpMessageList);
                    break;
                }
                if (!VirtualNbIoTDriver.serialportConnected(serialport)) {
                    log.info((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u6389\u7ebf\u4e86\u3002\u3002\u3002"));
                    log.info((Object)("\u4fe1\u606f\u53ef\u80fd\u6709\u4e22\u5931\uff1a" + Utils.getString(responseByteArray)));
                    break;
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException lastMessageInByteArray) {
                    // empty catch block
                }
                byte[] tmpResponseByteArray = ModemDriver.getBytesResponse(serialport, "UTF-8");
                responseByteArray = Utils.mergeByteArray(tmpResponseByteArray, responseByteArray);
                messageList = new ArrayList();
                incompleteMessageList = new ArrayList();
                ++readTimes;
            }
        }
        for (int i3 = 0; i3 < messageList.size(); ++i3) {
            nbiotMessageHolder.updateMessageList(device, (String)messageList.get(i3));
        }
    }

    @Override
    public boolean isDeviceAT(SerialPort serialPort) {
        return true;
    }
}

