/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.smpp.jsmpp;

import cn.sendsms.GatewayException;
import cn.sendsms.InboundMessage;
import cn.sendsms.Message;
import cn.sendsms.OutboundMessage;
import cn.sendsms.Service;
import cn.sendsms.StatusReportMessage;
import cn.sendsms.TimeoutException;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.helper.Logger;
import cn.sendsms.notify.InboundMessageNotification;
import cn.sendsms.smpp.AbstractSMPPGateway;
import cn.sendsms.smpp.BindAttributes;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.bean.AlertNotification;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.bean.DeliveryReceipt;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.GeneralDataCoding;
import org.jsmpp.bean.MessageClass;
import org.jsmpp.bean.MessageType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.SMSCDeliveryReceipt;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.MessageReceiverListener;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.session.Session;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.util.InvalidDeliveryReceiptException;

public class JSMPPGateway
extends AbstractSMPPGateway {
    private SMPPSession a = null;
    private b b = new b();
    private SessionStateListener c = new a();
    private BindType d;
    private TypeOfNumber e;
    private NumberingPlanIndicator f;

    public JSMPPGateway(String id, String host, int port, BindAttributes bindAttributes) {
        super(id, host, port, bindAttributes);
        this.setAttributes(79);
        this.a();
    }

    private void a() {
        switch (this.bindAttributes.getBindType()) {
            case RECEIVER: {
                this.d = BindType.BIND_RX;
                this.setInbound(true);
                this.setOutbound(false);
                break;
            }
            case TRANSMITTER: {
                this.d = BindType.BIND_TX;
                this.setInbound(false);
                this.setOutbound(true);
                break;
            }
            case TRANSCEIVER: {
                this.d = BindType.BIND_TRX;
                this.setInbound(true);
                this.setOutbound(true);
                break;
            }
            default: {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Unknown BindType " + (Object)((Object)this.bindAttributes.getBindType()));
                Logger.getInstance().logError(illegalArgumentException.getMessage(), illegalArgumentException, this.getGatewayId());
                throw illegalArgumentException;
            }
        }
        this.e = TypeOfNumber.valueOf((byte)this.bindAttributes.getBindAddress().getTypeOfNumber().value());
        this.f = NumberingPlanIndicator.valueOf((byte)this.bindAttributes.getBindAddress().getNumberingPlanIndicator().value());
        this.b();
    }

    private void b() {
        this.a = new SMPPSession();
        this.a.addSessionStateListener(this.c);
        this.a.setMessageReceiverListener((MessageReceiverListener)this.b);
    }

    @Override
    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (!this.a.getSessionState().isBound()) {
            if (this.enquireLink > 0) {
                this.a.setEnquireLinkTimer(this.enquireLink);
            }
            this.a.connectAndBind(this.host, this.port, new BindParameter(this.d, this.bindAttributes.getSystemId(), this.bindAttributes.getPassword(), this.bindAttributes.getSystemType(), this.e, this.f, null));
        } else {
            Logger.getInstance().logWarn("SMPP session already bound.", null, this.getGatewayId());
        }
    }

    @Override
    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.a.getSessionState().isBound()) {
            this.a.removeSessionStateListener(this.c);
            this.a.unbindAndClose();
        } else {
            Logger.getInstance().logWarn("SMPP session not bound.", null, this.getGatewayId());
        }
        super.stopGateway();
    }

    @Override
    public boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        GeneralDataCoding dataCoding;
        Alphabet encoding = Alphabet.ALPHA_DEFAULT;
        switch (msg.getEncoding()) {
            case ENC8BIT: {
                encoding = Alphabet.ALPHA_8_BIT;
                break;
            }
            case ENCUCS2: {
                encoding = Alphabet.ALPHA_UCS2;
                break;
            }
            case ENCCUSTOM: {
                encoding = Alphabet.ALPHA_RESERVED;
            }
        }
        switch (msg.getDCSMessageClass()) {
            case MSGCLASS_FLASH: {
                dataCoding = new GeneralDataCoding(false, true, MessageClass.CLASS0, encoding);
                break;
            }
            case MSGCLASS_ME: {
                dataCoding = new GeneralDataCoding(false, true, MessageClass.CLASS1, encoding);
                break;
            }
            case MSGCLASS_SIM: {
                dataCoding = new GeneralDataCoding(false, true, MessageClass.CLASS2, encoding);
                break;
            }
            case MSGCLASS_TE: {
                dataCoding = new GeneralDataCoding(false, true, MessageClass.CLASS3, encoding);
                break;
            }
            default: {
                dataCoding = new GeneralDataCoding();
                dataCoding.setAlphabet(encoding);
            }
        }
        try {
            RegisteredDelivery registeredDelivery = new RegisteredDelivery();
            registeredDelivery.setSMSCDeliveryReceipt(msg.getStatusReport() ? SMSCDeliveryReceipt.SUCCESS_FAILURE : SMSCDeliveryReceipt.DEFAULT);
            String msgId = this.a.submitShortMessage(this.bindAttributes.getSystemType(), TypeOfNumber.valueOf((byte)this.sourceAddress.getTypeOfNumber().value()), NumberingPlanIndicator.valueOf((byte)this.sourceAddress.getNumberingPlanIndicator().value()), msg.getFrom() != null ? msg.getFrom() : this.getFrom(), TypeOfNumber.valueOf((byte)this.destinationAddress.getTypeOfNumber().value()), NumberingPlanIndicator.valueOf((byte)this.destinationAddress.getNumberingPlanIndicator().value()), msg.getRecipient(), new ESMClass(), (byte)0, (byte)msg.getPriority(), null, this.b(msg.getValidityPeriod()), registeredDelivery, (byte)0, (DataCoding)dataCoding, (byte)0, msg.getText().getBytes(), new OptionalParameter[0]);
            msg.setRefNo(msgId);
            msg.setDispatchDate(new Date());
            msg.setGatewayId(this.getGatewayId());
            msg.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
            this.incOutboundMessageCount();
        }
        catch (PDUException e2) {
            msg.setGatewayId(this.getGatewayId());
            msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
            msg.setFailureCause(OutboundMessage.FailureCauses.BAD_FORMAT);
            Logger.getInstance().logError("Message Format not accepted.", (Exception)((Object)e2), this.getGatewayId());
            return false;
        }
        catch (ResponseTimeoutException e3) {
            Logger.getInstance().logError("Message could not be sent.", (Exception)((Object)e3), this.getGatewayId());
            throw new TimeoutException(e3.getMessage());
        }
        catch (InvalidResponseException e4) {
            Logger.getInstance().logError("Message could not be sent.", (Exception)((Object)e4), this.getGatewayId());
            throw new IOException("InvalidResponseException: ", e4);
        }
        catch (NegativeResponseException e5) {
            Logger.getInstance().logError("Message could not be sent.", (Exception)((Object)e5), this.getGatewayId());
            throw new IOException("NegativeResponseException: ", e5);
        }
        return true;
    }

    private String b(int timeInHours) {
        if (timeInHours < 0) {
            return null;
        }
        Calendar cDate = Calendar.getInstance();
        cDate.clear();
        cDate.set(1, 0);
        cDate.add(10, timeInHours);
        int years = cDate.get(1) - cDate.getMinimum(1);
        int months = cDate.get(2);
        int days = cDate.get(5) - 1;
        int hours = cDate.get(11);
        String yearsString = years < 10 ? "0" + years : years + "";
        String monthsString = months < 10 ? "0" + months : months + "";
        String daysString = days < 10 ? "0" + days : days + "";
        String hoursString = hours < 10 ? "0" + hours : hours + "";
        return yearsString + monthsString + daysString + hoursString + "0000000R";
    }

    @Override
    public void setEnquireLink(int enquireLink) {
        super.setEnquireLink(enquireLink);
        if (this.a != null) {
            this.a.setEnquireLinkTimer(enquireLink);
        }
    }

    class a
    implements SessionStateListener {
        a() {
        }

        public void onStateChange(SessionState newState, SessionState oldState, Object source) {
            if (newState.isBound()) {
                if (!JSMPPGateway.this.getStatus().equals((Object)AGatewayHelper.GatewayStatuses.STARTED)) {
                    try {
                        JSMPPGateway.super.startGateway();
                    }
                    catch (TimeoutException e2) {
                        Logger.getInstance().logError("Failed starting Gateway.", e2, JSMPPGateway.this.getGatewayId());
                    }
                    catch (GatewayException e3) {
                        Logger.getInstance().logError("Failed starting Gateway.", e3, JSMPPGateway.this.getGatewayId());
                    }
                    catch (IOException e4) {
                        Logger.getInstance().logError("Failed starting Gateway.", e4, JSMPPGateway.this.getGatewayId());
                    }
                    catch (InterruptedException e5) {
                        Logger.getInstance().logError("Failed starting Gateway.", e5, JSMPPGateway.this.getGatewayId());
                    }
                }
            } else if (newState.equals((Object)SessionState.CLOSED) && JSMPPGateway.this.getStatus().equals((Object)AGatewayHelper.GatewayStatuses.STARTED)) {
                JSMPPGateway.super.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                JSMPPGateway.this.b();
            }
        }
    }

    class b
    implements MessageReceiverListener {
        b() {
        }

        public void onAcceptDeliverSm(DeliverSm deliverSm) throws ProcessRequestException {
            if (MessageType.SMSC_DEL_RECEIPT.containedIn(deliverSm.getEsmClass())) {
                try {
                    DeliveryReceipt delReceipt = deliverSm.getShortMessageAsDeliveryReceipt();
                    StatusReportMessage statusReportMessage = new StatusReportMessage(delReceipt.getId(), deliverSm.getDestAddress(), deliverSm.getSourceAddr(), delReceipt.getText(), delReceipt.getSubmitDate(), delReceipt.getDoneDate());
                    switch (delReceipt.getFinalStatus()) {
                        case DELIVRD: {
                            statusReportMessage.setStatus(StatusReportMessage.DeliveryStatuses.DELIVERED);
                            break;
                        }
                        case REJECTD: 
                        case EXPIRED: 
                        case UNDELIV: {
                            statusReportMessage.setStatus(StatusReportMessage.DeliveryStatuses.ABORTED);
                            break;
                        }
                        default: {
                            statusReportMessage.setStatus(StatusReportMessage.DeliveryStatuses.UNKNOWN);
                        }
                    }
                    statusReportMessage.setGatewayId(JSMPPGateway.this.getGatewayId());
                    Service.getInstance().getNotifyQueueManager().getNotifyQueue().add(new InboundMessageNotification(JSMPPGateway.this.getMyself(), Message.MessageTypes.STATUSREPORT, statusReportMessage));
                }
                catch (InvalidDeliveryReceiptException e2) {
                    Logger.getInstance().logError("Failed getting delivery receipt.", (Exception)((Object)e2), JSMPPGateway.this.getGatewayId());
                }
            } else {
                InboundMessage msg = new InboundMessage(new Date(), deliverSm.getSourceAddr(), new String(deliverSm.getShortMessage()), 0, null);
                msg.setGatewayId(JSMPPGateway.this.getGatewayId());
                if (Alphabet.ALPHA_DEFAULT.value() == deliverSm.getDataCoding()) {
                    msg.setEncoding(Message.MessageEncodings.ENC7BIT);
                } else if (Alphabet.ALPHA_8_BIT.value() == deliverSm.getDataCoding()) {
                    msg.setEncoding(Message.MessageEncodings.ENC8BIT);
                } else if (Alphabet.ALPHA_UCS2.value() == deliverSm.getDataCoding()) {
                    msg.setEncoding(Message.MessageEncodings.ENCUCS2);
                } else {
                    msg.setEncoding(Message.MessageEncodings.ENCCUSTOM);
                }
                JSMPPGateway.this.incInboundMessageCount();
                Service.getInstance().getNotifyQueueManager().getNotifyQueue().add(new InboundMessageNotification(JSMPPGateway.this.getMyself(), Message.MessageTypes.INBOUND, msg));
            }
        }

        public DataSmResult onAcceptDataSm(DataSm dataSm, Session source) throws ProcessRequestException {
            return null;
        }

        public void onAcceptAlertNotification(AlertNotification alertNotification) {
        }
    }
}

